#!/usr/bin/env python3

import asyncio
import pdcom5
import argparse
import time
import os

from pdcom5._PdComWrapper import Transmission


async def main(args):
    while True:
        try:
            await connect_and_monitor(args)
        except Exception as e:
            print('Failed:', repr(e))
            time.sleep(5)
            continue


async def connect_and_monitor(args):
    process = pdcom5.Process()
    await process.connect(args.url)
    print(f"Connected to {args.url}")
    sub = await process.subscribe(Transmission.event_mode, args.variable)
    print(f"Subscribed to {args.variable}")
    value = await sub.poll()
    prev_value = value
    while True:
        print("Value:", value)
        if value != prev_value:
            os.system(args.command)
            exit(0)
        prev_value = value
        value = (await sub.read())[0]


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description='Monitors a process variable to shut the system down.')
    parser.add_argument('variable')
    parser.add_argument('--url', help='Host URL (without variable path)',
                        default='msr://localhost:2345')
    parser.add_argument('--command', help='Shutdown command',
                        default='echo Shutting down.')
    args = parser.parse_args()

    loop = asyncio.get_event_loop()
    loop.run_until_complete(main(args))
