vim: tw=78 spelllang=en

[[_TOC_]]

# Introduction

EtherLab is a Simulink Coder Target used to create user space binaries that
use the [PdServ library](https://gitlab.com/etherlab.org/pdserv).

MATLAB, Simulink and Stateflow are registered trademarks, and Simulink Coder
is a trademark of The MathWorks, Inc.
References to these terms in this package are used in context of these terms
to explain concepts.

# License

Copyright 2012-2025 Richard Hacker <ha@igh.de>

This file is part of EtherLab.

EtherLab is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option)
any later version.

EtherLab is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public License along with
EtherLab See COPYING. If not, see
[http://www.gnu.org/licenses](http://www.gnu.org/licenses).

# Quick Start

If you are impatient, already know what EtherLab does, and are really keen on
getting going with this package, jump straight to the end and read the
[installation instructions](#installation).

# Motivation

Extract from MathWorks' Website on Simulink Coder:

>>>
Simulink Coder (formerly Real-Time Workshop) generates and executes C and
C++ code from Simulink diagrams, Stateflow charts, and MATLAB functions.
The generated source code can be used for real-time and non real time
applications, including simulation acceleration, rapid prototyping, and
hardware-in-the-loop testing. You can tune and monitor the generated code
using Simulink or run and interact with the code outside MATLAB and
Simulink.
(http://www.mathworks.com/products/simulink-coder/index.html)
>>>
 
First and foremost, Simulink Coder generates C/C++ code from Simulink
diagrams. This generated code is generic in the sense that a support
framework is required to make it run.  Typically this framework is
provided for the targets on which the executable will run. The framework
ensures execution (maybe in real time), possible interaction with signals
and parameters, and real world input and output with sensors and
actuators.

Simulink Coder comes with a generic real time target (grt). This target
creates an executable that runs on Linux for example. However, neither
Simulink nor Simulink Coder blockset supply sources or sinks to interact
with real world sensors. The generated executable does not run in real
time and interaction with signals and parameters are limited to External
Mode Communication within the Simulink diagram.

PdServ is a library that facilitates interaction with another process
using shared memory only. No system calls are used between the library and
its process. System calls are a major stumbling block real time
applications have to deal with.

EtherLab is a target for Simulink Coder to generate an executable that
works with PdServ. Thus the executable has all the possibilities PdServ
has.

EtherLab also supplies an extensive blockset to interact with the real
world from within the Simulink diagram. Most importantly, it works very
closely with EtherCAT. This opens a enormous range of IO devices that can
be used at the diagram level.

# Installation

## From Debian or rpm package:

Install the package.

This installs the package into /usr/share/etherlab

## From source files

You need:
    - the source tarball
    - installed pdserv environment (not a prerequisite, but is required
      when the executable is generated)
    - cmake, version 2.6 or higher

Here it goes:

```bash
$ tar xfj etherlab-X.Y.Z.tgz
$ cd etherlab-X.Y.Z
$ mkdir build
$ cd build
$ cmake ..
$ make
$ sudo make install
```

This installs the package into /usr/local/share/etherlab

Once installed, the files need to be copied to MATLAB and configured
before use. See the next section.

## Power users

The files are installed into the data directory as defined by cmake
for your platform. The default data directory is

```
${CMAKE_INSTALL_PREFIX}/${DATAROOTDIR}/${TARGETDIR}
```

where the defaults are:

```
CMAKE_INSTALL_PREFIX = /usr/local
DATAROOTDIR = share
TARGETDIR = etherlab
```

Thus, by default your files are installed to /usr/local/share/etherlab.

To install more than one EtherLab version simultaneously, use the
TARGETDIR variable when configuring:

```
$ cmake -DTARGETDIR=etherlab_Vxx ..
```

for example. This will install to /usr/local/share/etherlab_Vxx

You can also change the variables CMAKE_INSTALL_PREFIX and
DATAROOTDIR, but this is usually not required.

# Configuration

This section uses MATLAB_ROOT as a generic variable that points to the
head of the MATLAB installation. Either you know it by heart, or call

```
>> matlabroot
```

from MATLAB's command line.

Regardless whether you install using a package manager or from source
code, another two steps are required before EtherLab can be used:

1) Copy the files from the installation path to MATLAB:

    This is done with a script:
    ```
    # /usr/share/etherlab/install.sh $(MATLAB_ROOT)
    ```
    or (from source install):
    ```
    # /usr/local/share/etherlab/install.sh $(MATLAB_ROOT)
    ```

    The files are copied to $(MATLAB_ROOT)/rtw/c/etherlab. 
    **Make sure this directory is writeable by you!**

2) Compile the files to be used by MATLAB:

    During configuration, paths are added to matlabpath and saved to
    ($(MATLAB_ROOT)/toolbox/local/pathdef.m). Make sure it is writeable.

    Matlab mex functions are generated during configuration, so make sure
    that directories below $(MATLAB_ROOT)/rtw/c/etherlab/ are writeable
    by the matlab user (as instruction in the step above).

    Now start MATLAB and call:
    ```
    >> run(fullfile(matlabroot, 'rtw/c/etherlab', 'setup_etherlab.m'))
    ```

    This configures the package for use with Simulink.

## Power users

The default installation directory of the files in MATLAB is:
$(MATLAB_ROOT)/rtw/c/etherlab, where the last directory can be
changed by using the optional second parameter when calling install.sh:

```
$ /usr/local/share/etherlab/install.sh $(MATLAB_ROOT) etherlab_Vxx
```

This will install to $(MATLAB_ROOT)/rtw/c/etherlab_Vxx

Using this feature, many parallel installations of EtherLab is
possible. To switch between them, call:

```
>> switch_etherlab('etherlab_Vxx')
```

from MATLAB. This will change matlabpath to point to the new
directory!

Of course (as a power user), you know how to adapt the run()
command in step 2) above appropriately.

# Using EtherLab

Now open a Simulink diagram. From the diagram, open the Configuration
Parameters (Menu: Simulation -> Configuration Parameters, or press Ctrl-E
from within the Simulink diagram). Choose Code Generation tab, and select
"etherlab.tlc" for System target file. Go to the Solver tab and choose a
Fixed-step size, such as 0.001. Select the appropriate solver and a
Tasking mode (SingleTasking or MultiTasking) for your application. Go back
to the Code Generation tab and press Build button (Pressing Ctrl-B from
within the diagram also works). Voilà, you have an executable! Call it and
be happy.

# Using EtherLab in a hosted environment (power users)

MATLAB, Simulink and Simulink Coder is a significant financial investment
that is typically installed only on a limited number of systems. These
licenses are definitely NOT required to run the executable.

While it is easy to transfer the generated executable to a system with a
similar runtime environment as that of the host (of coarse, including
pdserv and possibly EtherCAT libraries), you may have the requirement to
generate only C/C++ code with the MATLAB installation and build the
executable on another machine. This is for instance when MATLAB is
installed on a Windows machine while your target will run on Linux.

In this case, select "Generate code only" from the "Code Generation" tab
of the Configuration Parameters.

Now copy the directory <model>_etl_hrt to the target machine. Also copy
the following files from your MATLAB installation:
        ${MATLAB_ROOT}/extern/include
        ${MATLAB_ROOT}/simulink/include/
        ${MATLAB_ROOT}/rtw/c/src/
        ${MATLAB_ROOT}/rtw/c/tools/unixtools.mk
to the target using the same directory structure.

Dive into the directory containing <model>_etl_hrt -- not into the
directory <model>_etl_hrt itself. Type
$ make -C <model>_etl_hrt -f <model>.mk MATLAB_ROOT=${MATLAB_ROOT}
and there you go! (MATLAB_ROOT may be omitted if the path on the host
and target machines does not change)

If the code is generated on a windows host, you will have to edit
<model>_etl_hrt/<model>.mk and remove references to drive letters (e.g.
C:\...) that Simulink Coder inserts automatically. GNU make chokes on
these lines, so you are required to edit the file unfortunately.

# Removing EtherLab

First remove etherlab from matlab (this is not done automatically, not
even when using package managers):
    - call /usr/local/share/etherlab/uninstall.sh $(MATLAB_ROOT)

    - From Matlab:
    >> pathtool
    remove references to etherlab. Save path.

Now remove installation base:
    - package manager: remove EtherLab
    - source files: rm -rf /usr/local/share/etherlab

Finished
