# Driver for Beckhoff EL7041 Stepper Controllers

The [`lcec_el7041`](../src/devices/lcec_el7041.c) driver supports
Bekchoff's [EL7041](http://beckhoff.com/EL7041) EtherCAT stepper
driver as well as a couple close relatives.  There is also a
`lcec_el70x1` driver that overlaps somewhat.  These two drivers will
probably be unified in the near future.

## How to configure an EL7041 in LinuxCNC-Ethercat

To use an EL7041, you will need to add a line to your `ethercat.xml` file to tell LinuxCNC about the module.  This should look like this:


```xml
<masters>
  <master idx="0" appTimePeriod="1000000" refClockSyncCycles="1000">
    ...

    <slave idx="5" type="EL7041" name="X"/>

    ...
  </master>
</masters>
```

The index number (`5`, above) needs to match the slave ID of your
EL7041; run `ethercat slaves` if you don't know its ID.  The name
provided (`X` here) has no special meaning, but it's used in your
LinuxCNC `hal` config to refer to the stepper, so it's generally a
good practice to use the name of whichever axis this stepper controls.

In addition, the EL7041 has a number of configuration settings that
can be controlled via the XML file.  See [Beckhoff's PDF documentation
for the EL70x1
family](https://download.beckhoff.com/download/Document/io/ethercat-terminals/el70x1en.pdf#page=226)
for more in-depth information about each setting.

You can control these by adding `<modParam>` settings under the EL7041's `<slave>` entry:

```xml
<masters>
  <master idx="0" appTimePeriod="1000000" refClockSyncCycles="1000">
    ...

    <slave idx="5" type="EL7041" name="X">
	  <modParam name="maxCurrent" value="2.5"/>
	  <modParam name="nominalVoltage" value="48"/>
	</slave>

    ...
  </master>
</masters>
```

Notice that instead of `<slave ... />`, we now have `<slave ... >
... </slave>`, without the trailing `/` on the first `<slave/>` tag.

Each `<modParam/>` line has a `name="..."` and a `value="..."` setting.

Supported parameters:

* `maxCurrent`: the maximum current for the stepper.  In Amps.  Default depends on the device, EL7041 defaults to 5.0A.
* `reducedCurrent`: reduced current for reduced torque.  In Amps.  EL7041 defaults to 2.5A. (Unsupported on `EL7041-1000`)
* `nominalVoltage`: the nominal voltage of the motor, in Volts.  EL7041 defaults to 50.0V
* `coilResistance`: the internal resistance of a motol coil, in Ohms.  EL7041 defaults to 1.0 Ohm. (Unsupported on `EL7041-1000`)
* `motorEMF`: Motor countervoltage, in V/(rad/S).  Defaults to 0. (Unsupported on `EL7041-1000`)
* `motorFullsteps`: number of motor steps per full revolution.  Defaults to 200.
* `encoderIncrements`: number of encoder increments per revolution.
* `startVelocity`: Maximum possible start velocity of the motor.  Unit unknown, default varies.
* `driveOnDelay`: Switch-on delay of the driver stage, in ms.  Defaults to 100ms.
* `driveOffDelay`: Switch-off delay of the driver stage, in ms.  Defaults to 150ms.
* `maxSpeed`: maximum supported speed in full steps/second.  1000, 2000, 4000, 8000, 16000, or 32000.   (Unsupported on `EL7041-1000`)
* `encoder`: `true` if an encoder is connected.  The EL7041 will report "fake" encoder data if this is not set.
* `microsteps`: Number of microsteps used.  Valid values are 1, 2, 4, 8, 16, 32, or 64. (*Only* supported on `EL7041-1000`)

Note that not all hardware will support all of these parameters.
Attempting to set a parameter that the hardware does not support will
cause LinuxCNC to fail to start and report an error message.  Check
`ethercat sdos` to see which SDOs your hardware supports.


## How to file a bug

See
[gitub.com/linuxcnc-ethercat/linuxcnc-ethercat](https://github.com/linuxcnc-ethercat/linuxcnc-ethercat/issues)
for view existing bugs and file new issues.
