/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef PROTOCOLHANDLER_H
#define PROTOCOLHANDLER_H

#include "pdcom/Exception.h"

#include <string>
#include <map>

namespace PdCom {

class Process;

/****************************************************************************/

/** Protocol handler.
 */

class ProtocolHandler {
    public:
        ProtocolHandler(PdCom::Process *process, std::ostream *os);
        virtual ~ProtocolHandler();

        virtual size_t parse(const char *buf, size_t len);
        virtual bool connected() const;

        virtual bool hasFeature(const std::string &f) const = 0;

        Process *getProcess() const { return process; }

        virtual std::map<std::string,std::string> getInfo() const = 0;

        virtual void sendBroadcast(const std::string &,
                const std::string & = "text") = 0;

    protected:
        PdCom::Process * const process;
        std::ostream * const os;

        /** Call this when the protocol handler has finished initialisation.
         */
        void initialised();
};

} // namespace PdCom

#endif // PROTOCOLHANDLER_H

/****************************************************************************/
