/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef MSRCOMEXCEPT_H
#define MSRCOMEXCEPT_H

#include "pdcom/Exception.h"

#include <string>

namespace MSRProto {

/****************************************************************************/

/** Exception class.
 */

class Exception: public PdCom::Exception {
    public:
        /** Constructor with std::string parameter. */
        Exception(
                const std::string &s /**< Message. */):
            PdCom::Exception(s) {}

        /** Constructor with std::ostringstream parameter. */
        Exception( const std::string &var,
                const std::ostringstream &s /**< Message. */
                ): PdCom::Exception(
                    std::string(var).append(": ").append(s.str())) {}

        /** Constructor with const char pointer parameter. */
        Exception(
                const char *s /**< message. */
                ): PdCom::Exception(s) {}
};

} // namespace MSRProto

#endif // MSRCOMEXCEPT_H

/****************************************************************************/
