/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef PDCOM_SUBSCRIBER_H
#define PDCOM_SUBSCRIBER_H

namespace PdCom {

class Variable;

/****************************************************************************/

/** Variable subscriber.
 *
 * To receive real-time process values, the Variable can be
 * subscribed by a Subscriber.
 *
 * In order be able to receive these notifications, subclass from
 * Subscriber and implement the notify() and variableDeleted()
 * methods.
 *
 * You may safely subclass from both Process and Subscriber in
 * the same class for simple applications.
 */

class Subscriber {
    public:
        /** Constructor.
         */
        Subscriber() {};

        /** Destructor.
         */
        virtual ~Subscriber() {};

        /** New value notification.
         *
         * Called by Variable to notify the subscriber of a new value.
         *
         * Calling pv->unsubscribe() is not allowed within this context.
         *
         * Reimplement this method in the derived class.
         */
        virtual void notify(
                Variable *pv /**< The variable having a new value. */
                ) = 0;

        /** Process Variable is deleted
         *
         * When a Variable is deleted, it informs all
         * Subscribers about its impending death. It is therefor
         * not allowed to change anything in the Variable any more.
         */
        virtual void notifyDelete(
                Variable *pv /**< The variable that is being
                                      deleted */
                ) = 0;
};

} // namespace PdCom

#endif // PDCOM_SUBSCRIBER_H

/****************************************************************************/
