# PdServ version history

## Version 3.4.1

- Allow the text argument of `pdserv_event_set_text()` to be NULL to clear
  all message texts of the given event

## Version 3.4.0

- Catch logging configuration errors early and let `pdserv_prepare()` fail
- Improved documentation of return values (i. e. `pdserv_prepare()`)
- Re-worked documentation of configuration file format.
- Import event messages from plainmessages.yml (via config file)
- Export list of registered events to yaml via `pdserv_exent_export()`
- Named pthreads
- Limit shared memory consumption
- Escape contents of "comment" and "alias" attributes
- Removed `etherlab_buddy` implementation
- Always use long description in full version string.

## Version 3.3.1

- Fix subscriptions for signals with RT-side decimation
- Added `pdserv_get_variable_path()` function.

## Version 3.3.0

- Use symbol versioning
- Enable symbol visibility control
- Document return value of `pdserv_prepare()`

## Version 3.2.4

- Added logger for broadcasts
- Ported realtime task to thread (like in realtime example).
- Make authorization for guest user configurable
- Enable PAM auth in default config
- Make SASL PAM serivce name configurable
- Added a 2x3 matrix to the example.
- Startup with defaults if no configuration is provided.
- Added feature flag 'group'; updated documentation of other flags.
- Log pdserv version on startup.
- Warn when empty CA or empty CRL has been loaded
- Introduce Exceptions.h
- Enabled broadcast by default.
- Fix memory leak for events
- Make default realm configurable
- Failing to chrt in rt service task is not critical
- Fixed return value of `postfork_rt_setup`
- Removed StartTLS -- separate port for MSR over TLS is 4523
- Set the priority of the real time helper thread to highest
- Added missing throws
- Removed EtlProto (that was never used)
- Added throwing sleep() function in case `pdserv_exit()` has been called
- Fixed MSR protocol documentation
- Fixed parameter-signal pair in persistence
- Do not treat empty configuration file as error
- Output configuration errors on STDERR instead of STDOUT.
- Require C++11 (cmake now >= 3.2)
- Disable automatic port selection (ports have to be configured expolicitely)
- Fixed memory leak in Config::load
- Fixed memory leak in SubscriptionManager
- Replace deprecated `pdserv_signal_cb()`
- Activated Gitlab-CI tests
- Improved `pthread_cancel()` behavior
- Fixed possible nullptr-dereference
- Moved to git

## Version 3.2.3

- Fixed double mutex deadlock.
- Fixed compiler warnings

## Version 3.2.2

- Fixed bug in persistent parameter, where subindex parameter writes
  were incorrectly saved

## Version 3.2.1

- Fixed bug in persistent parameter, where the value was not updated in a
  signal-parameter pair
- Example got command line parameters for config file and duration

## Version 3.2.0

- Bumped minor version number to clean up and consolidate changes in 3.1.x
- Updated documentation, especially documenting MSR
- Added a good working example. See example/

## Version 3.1.1

- Added functions for locking when reading signals and writing parameters
- Interface changes in pdserv.h
   - added `pdserv_set_parameter_writelock()`
   - added `pdserv_set_signal_readlock()`
   - deprecated `pdserv_signal_set_read_cb()`, use
     `pdserv_set_parameter_writelock()` instead
   - deprecated `pdserv_signal_cb()`, use `pdserv_set_parameter_writelock()`
     instead

## Version 3.1.0

- documentation
- example
- interface changes in pdserv.h
   - removed `read_signal_cb`, `priv_data` from `pdserv_signal()`, see
     `pdserv_signal_cb()`
   - moved priority from `pdserv_event()` to `pdserv_event_set()`
   - removed state from `pdserv_event_set()`
   - renumbered `*_EVENT` macros
   - added `pdserv_signal_cb()`
   - added `pdserv_event_set_all()`
   - added `RESET_EVENT` macro
   - added lots of common data types `pd_*_T`
- lots of work on events
- bugfixes
- installing from hg now uses HgID as soversion
- parameter subscription to MSR

## Version 1.1.0

- Fixed some bugs and memory leaks
- Added `<remote_host polite>` so that the process does not send any messages
  by itself
- Parameter write failure not logged any more
- Removed unnecessary output stream locking
- Removed `value=''` attribute for `<rk>` and `<rp>`
- Removed MSR `<info>` broadcast when new session connects
- Using log4cplus instead of log4cpp
- Using standard cmake installation paths. Default installation to /usr/local
- Simplified events defined with a path instead of a numeric identifier
- Simplified configuration. Removed default configuration option

## Version 1.0.0

- Removed duplicate unit attribute.
- Fixed some locking issues.
- Fixed memory leak on every network disconnect
- Loading config file as early as possible
- Added configuration option for lib
- Integrated compound data types into msr protocol
- Fixed bug where not all parameters were added in traditional mode
- Large improvements on performance
- Added 'out of sync' log message.
- Change `<connected>` tag to `name="MSR"`
- Export vector signals also in traditional mode.
- Traditional mode as a runtime configuration option.
- Traditional mode inserts model name in front of variable path for MSR
- Added 64-bit library support in spec file.

## Version 0.99.3

- Changed License to LGPLv3.

vim: tw=78
