############################################################################
##
## COPYRIGHTHERE
##
############################################################################

"""
<module maturity="stable">
  <summary>
    The Config module defines global options of Zorp.
  </summary>
  <description>
    <para>
      This module defines global options of Zorp.
      For a detailed description of the options, see <xref
      linkend="appendix_globaloptions"/>.
    </para>
  </description>
</module>
"""
import new, sys

TRUE = 1
FALSE = 0

config = sys.modules[__name__]

def addConfigContainer(cont):
    """
    <function internal="yes">
      <summary>
        Create a container for global configuration variables.
      </summary>
    </function>
    """
    setattr(config, cont, new.module(cont))

addConfigContainer('dirs')

config.dirs.libdir="/root/lib/zorp"
config.dirs.sbindir="/root/sbin"
config.dirs.sysconfdir="/root/etc/zorp"
config.dirs.pidfiledir="/root/var/run/zorp/"

addConfigContainer('blob')
# The directory where blobs are swapped out
config.blob.temp_directory = '/var/lib/zorp/tmp/'

# Maximum disk usage (1G)
config.blob.max_disk_usage = 1024*0x100000

# Maximum memory usage (256M)
config.blob.max_mem_usage = 256*0x100000

# Low water mark for blob swapout, it stops when reaching this amount in memory
config.blob.lowat = 96*0x100000

# High water mark for blob swapout, swapout starts when having this amount of memory used
config.blob.hiwat = 128*0x100000

# The maximum size for blobs that are never swapped.
config.blob.noswap_max = 16384

addConfigContainer('audit')

## Session level options, controlling what to do when auditing is enabled
## for a session.

# whether to write records to audit trail file (if you disable this and
# config.audit.ids, then initializing the audit trail will fail)
config.audit.audit = TRUE

# Whether audit trail encryption is enabled
config.audit.encrypt = FALSE

# Whether to compress audit trails
config.audit.compress = TRUE

# Sign the digest record
config.audit.sign = FALSE

# Timestamp the digest record
config.audit.timestamp = FALSE

config.audit.ids = FALSE

## Compression options

# The compression level for audit trail files
config.audit.compress_level = 1

## Encryption options

# List of X.509 PEM certificates. to encrypt the audit trail with
config.audit.encrypt_certificate_list = None

# File names which contain an X.509 PEM certificate to encrypt the audit
# trail file, overrides the setting for config.audit.encrypt_certificate_list
#config.audit.encrypt_certificate_list_file = [ ["", "" ], ]
# by default empty:
config.audit.encrypt_certificate_list_file = None

# X.509 PEM certificate to encrypt the audit trail file for. Fallback if config.audit.encrypt_certifiace_list is empty
config.audit.encrypt_certificate = None

# File name which contains an X.509 PEM certificate to encrypt the audit
# trail file, overrides the setting for config.audit.encrypt_certificate
config.audit.encrypt_certificate_file = None

## Sign related options

# Seconds between audit trail digest record is written
# Optionally the digest can be timestamped by a server and sign by an RSA key
# This whole record is the digital sign of the trail
config.audit.sign_interval = 30

# RSA or DSA  private key to sign the digest calculated for the sign record
config.audit.sign_private_key = None

# Certificate to sign the digest calculated for the sign record
config.audit.sign_certificate = None

# File of private key to sign the digest calculated for the sign record
config.audit.sign_private_key_file = None

# File of the certificate to sign the digest calculated for the sign record
config.audit.sign_certificate_file = None

## Timestamping options

# Timestamping URL for the digest record
config.audit.timestamp_url = ""

# Policy of the timestamping server (ASN1)
# in form of "1.2.4.3.124.7"
config.audit.timestamp_policy = ""

# Max length of the timestamp field of the digest record
config.audit.timestamp_length = 3072

## IDS options

# Interface to use towards the IDS sensor
config.audit.ids_interface = ""

# IDS source MAC address
config.audit.ids_src_mac = ""

# IDS destination MAC address
config.audit.ids_dst_mac = ""

## Misc parameters

# Rate of filling the bucket in byte/sec
config.audit.rate_limit = 2*1024*1024

# Interval between two notifications, if bucket is empty, in seconds
config.audit.rate_notification_interval = 300

# Maximum size of audit trail files in bytes
config.audit.write_size_max = 2048*1024*1024

# Terminate proxy if cannot write audit trail (max size exceeded)
config.audit.terminate_on_max_size = FALSE

addConfigContainer('options')

# The visible product name to use by Zorp python components
config.options.product_name = "Zorp Professional"

# The Zorp version identifier used in systemd service name
config.options.package_suffix = ""

# The timeout used when establishing server side connection.
config.options.timeout_server_connect = 30000

# The default language used for user messages in various proxies.
config.options.language = "en"

# Zone and CSZoneDispatcher shift cache parameter
config.options.zone_dispatcher_shift_threshold = 1000

# KZorp enabled or not. If KZorp is not present in the kernel and this is
# enabled, Zorp startup/shutdown/reload will be delayed by about 5sec
config.options.kzorp_enabled = TRUE
