### Requirements for Contributing a Bug Fix

* Fill out the template below. Any pull request that does not include enough information to be reviewed in a timely manner may be closed at the maintainers' discretion.
* The pull request must only fix an existing bug. To contribute other changes, you must use a different template. You can see all templates at https://github.com/etr/libhttpserver/tree/master/.github/PULL_REQUEST_TEMPLATE.
* The pull request must update the test suite to demonstrate the changed functionality.
* After you create the pull request, all status checks must be pass before a maintainer reviews your contribution. For more details, please see https://github.com/etr/libhttpserver/tree/master/CONTRIBUTING.md#pull-requests.

### Identify the Bug

<!--

Link to the issue describing the bug that you're fixing.

If there is not yet an issue for your bug, please open a new issue and then link to that issue in your pull request.
Note: In some cases, one person's "bug" is another person's "feature." If the pull request does not address an existing issue with the "bug" label, the maintainers have the final say on whether the current behavior is a bug.

-->

### Description of the Change

<!--

We must be able to understand the design of your change from this description. If we can't get a good idea of what the code will be doing from the description here, the pull request may be closed at the maintainers' discretion. Keep in mind that the maintainer reviewing this PR may not be familiar with or have worked with the code here recently, so please walk us through the concepts.

-->

### Alternate Designs

<!-- Explain what other alternates were considered and why the proposed version was selected -->

### Possible Drawbacks

<!-- What are the possible side-effects or negative impacts of the code change? -->

### Verification Process

<!--

What process did you follow to verify that the change has not introduced any regressions?

-->

### Release Notes

<!--

Please describe the changes in a single line that explains this improvement in
terms that a user can understand.  This text will be used in libhttpserver's release notes.

If this change is not user-facing or notable enough to be included in release notes
you may use the strings "Not applicable" or "N/A" here.

Examples:

- The GitHub package now allows you to add co-authors to commits.
- Fixed an issue where multiple cursors did not work in a file with a single line.
- Increased the performance of searching and replacing across a whole project.

-->
