/***********************************************************************************************************************************
IO Functions

Common IO functions.
***********************************************************************************************************************************/
#ifndef COMMON_IO_IO_H
#define COMMON_IO_IO_H

#include <stddef.h>

#include <common/io/read.h>

/***********************************************************************************************************************************
Default IO timeout to use when nothing else is configured
***********************************************************************************************************************************/
#define IO_TIMEOUT_DEFAULT                                          60000

/***********************************************************************************************************************************
Functions
***********************************************************************************************************************************/
Buffer *ioReadBuf(IoRead *read);
bool ioReadDrain(IoRead *read);

/***********************************************************************************************************************************
Getters/Setters
***********************************************************************************************************************************/
size_t ioBufferSize(void);
void ioBufferSizeSet(size_t bufferSize);

#endif
