set client_min_messages to WARNING;

CREATE TEMPORARY TABLE _time AS SELECT now() t;

CREATE FUNCTION _timecheck(label text, tolerated interval) RETURNS text
AS $$
DECLARE
  ret TEXT;
  lap INTERVAL;
BEGIN
  lap := now()-t FROM _time;
  IF lap <= tolerated THEN ret := label || ' interrupted on time';
  ELSE ret := label || ' interrupted late: ' || lap;
  END IF;
  UPDATE _time SET t = now();
  RETURN ret;
END;
$$ LANGUAGE 'plpgsql' VOLATILE;

CREATE TEMP TABLE _inputs AS
SELECT 1::int as id, ST_Collect(g) g FROM (
 SELECT ST_MakeLine(
   ST_Point(cos(radians(x)),sin(radians(270-x))),
   ST_Point(sin(radians(x)),cos(radians(60-x)))
   ) g
 FROM generate_series(1,720) x
 ) foo
;

UPDATE _time SET t = now(); -- reset time as creating tables spends some

-----------------------------
-- IM9 based predicates
-----------------------------

SET statement_timeout TO 100;

select ST_Contains(g,g) from _inputs WHERE id = 1; -- 6+ seconds
SELECT _timecheck('contains', '500ms');

select ST_Covers(g,g) from _inputs WHERE id = 1; -- 6+ seconds
SELECT _timecheck('covers', '500ms');

select ST_CoveredBy(g,g) from _inputs WHERE id = 1; -- 6+ seconds
SELECT _timecheck('coveredby', '500ms');

select ST_Crosses(g,g) from _inputs WHERE id = 1; -- 6+ seconds
SELECT _timecheck('crosses', '500ms');

-- NOTE: we're reversing one of the operands to avoid the
--       short-circuit described in #3226
select ST_Equals(g,st_reverse(g)) from _inputs WHERE id = 1; -- 6+ seconds
SELECT _timecheck('equals', '500ms');

-- NOTE: intersects became very fast, so we segmentize
--       input to make it slower
select ST_Intersects(g,ST_Segmentize(g,1e-4)) from _inputs WHERE id = 1; -- 6+ seconds
SELECT _timecheck('intersects', '500ms');

select ST_Overlaps(g,g) from _inputs WHERE id = 1; -- 6+ seconds
SELECT _timecheck('overlaps', '500ms');

select ST_Relate(g,g) from _inputs WHERE id = 1; -- 6+ seconds
SELECT _timecheck('relate', '500ms');

DROP FUNCTION _timecheck(text, interval);
DROP TABLE _inputs;
