/* Copyright (c) 2017, 2018, Oracle and/or its affiliates. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */

#ifndef DD_UPGRADE__ROUTINE_H_INCLUDED
#define DD_UPGRADE__ROUTINE_H_INCLUDED

class THD;

namespace dd {
class Routine;
class Schema;
}  // namespace dd

namespace dd {
namespace bootstrap {

/**
  Validate a dd::Routine object.

  @param[in]  thd        Thread handle.
  @param[in]  schema     Schema in which the routine belongs.
  @param[in]  routine    Routine to be validated.

  @retval false  ON SUCCESS
  @retval true   ON FAILURE
*/
bool invalid_routine(THD *thd, const dd::Schema &schema,
                     const dd::Routine &routine);
}  // namespace bootstrap

namespace upgrade_57 {

/**
  Migrate all SP/SF from mysql.proc to mysql.routines dd table.

  @param[in]  thd        Thread handle.

  @retval false  ON SUCCESS
  @retval true   ON FAILURE
*/
bool migrate_routines_to_dd(THD *thd);

}  // namespace upgrade_57
}  // namespace dd

#endif  // DD_UPGRADE__ROUTINE_H_INCLUDED
