/*
   Copyright (c) 2004, 2023, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*/

#ifndef SOCKET_AUTHENTICATOR_HPP
#define SOCKET_AUTHENTICATOR_HPP

#include "util/NdbSocket.h"

/* client_authenticate() and server_authenticate() return a value
   less than AuthOk on failure. They return a value greater than or
   equal to AuthOk on success.
*/

class SocketAuthenticator {
 public:
  SocketAuthenticator() {}
  virtual ~SocketAuthenticator() {}
  virtual int client_authenticate(const NdbSocket &) = 0;
  virtual int server_authenticate(const NdbSocket &) = 0;

  static constexpr int AuthOk = 0;
  static const char *error(int);  // returns error message for code
};

class SocketAuthSimple : public SocketAuthenticator {
 public:
  SocketAuthSimple() {}
  ~SocketAuthSimple() override {}
  int client_authenticate(const NdbSocket &) override;
  int server_authenticate(const NdbSocket &) override;
};

#endif  // SOCKET_AUTHENTICATOR_HPP
