/*
 * Copyright (c) 2020, 2023, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0,
 * as published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms, as
 * designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an additional
 * permission to link the program and your derivative works with the
 * separately licensed software that they have included with MySQL.
 * This program is distributed in the hope that it will be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 * the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MODULES_UTIL_COMMON_DUMP_UTILS_H_
#define MODULES_UTIL_COMMON_DUMP_UTILS_H_

#include <memory>
#include <string>
#include <vector>

#include "mysqlshdk/libs/oci/oci_par.h"
#include "mysqlshdk/libs/utils/utils_general.h"

namespace mysqlsh {
namespace dump {
namespace common {

// Encodes/decodes filenames for schema/table dumps
// All strings must be UTF-8

std::string encode_schema_basename(const std::string &schema);

std::string encode_table_basename(const std::string &schema,
                                  const std::string &table);

std::string encode_partition_basename(const std::string &schema,
                                      const std::string &table,
                                      const std::string &partition);

std::string get_schema_filename(const std::string &basename);

std::string get_schema_filename(const std::string &basename,
                                const std::string &ext);

std::string get_table_filename(const std::string &basename);

std::string get_table_data_filename(const std::string &basename,
                                    const std::string &ext);

std::string get_table_data_filename(const std::string &basename,
                                    const std::string &ext, size_t index,
                                    bool last_chunk);

void parse_schema_and_object(const std::string &str, const std::string &context,
                             const std::string &object_type,
                             std::string *out_schema, std::string *out_table);

mysqlshdk::oci::PAR_structure parse_par(const std::string &url);

std::shared_ptr<mysqlshdk::oci::IPAR_config> get_par_config(
    const std::string &url);

std::shared_ptr<mysqlshdk::oci::IPAR_config> get_par_config(
    const mysqlshdk::oci::PAR_structure &par);

}  // namespace common
}  // namespace dump
}  // namespace mysqlsh

#endif  // MODULES_UTIL_COMMON_DUMP_UTILS_H_
