// clang-format off
/*
 * Copyright (c) 2020, 2023, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0,
 * as published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms, as
 * designated in a particular file or component or in included license
 * documentation. The authors of MySQL hereby grant you an additional
 * permission to link the program and your derivative works with the
 * separately licensed software that they have included with MySQL.
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */




// Generated from /home/paandrus/dev/ngshell/mysqlshdk/libs/parser/grammars/MySQLParser.g4 by ANTLR 4.10.1


#include "MySQLParserListener.h"
#include "MySQLParserVisitor.h"

#include "MySQLParser.h"

#include "mysqlshdk/libs/parser/MySQLBaseRecognizer.h"

using namespace antlrcpp;
using namespace parsers;

using namespace antlr4;

namespace {

struct MySQLParserStaticData final {
  MySQLParserStaticData(std::vector<std::string> ruleNames,
                        std::vector<std::string> literalNames,
                        std::vector<std::string> symbolicNames)
      : ruleNames(std::move(ruleNames)), literalNames(std::move(literalNames)),
        symbolicNames(std::move(symbolicNames)),
        vocabulary(this->literalNames, this->symbolicNames) {}

  MySQLParserStaticData(const MySQLParserStaticData&) = delete;
  MySQLParserStaticData(MySQLParserStaticData&&) = delete;
  MySQLParserStaticData& operator=(const MySQLParserStaticData&) = delete;
  MySQLParserStaticData& operator=(MySQLParserStaticData&&) = delete;

  std::vector<antlr4::dfa::DFA> decisionToDFA;
  antlr4::atn::PredictionContextCache sharedContextCache;
  const std::vector<std::string> ruleNames;
  const std::vector<std::string> literalNames;
  const std::vector<std::string> symbolicNames;
  const antlr4::dfa::Vocabulary vocabulary;
  antlr4::atn::SerializedATNView serializedATN;
  std::unique_ptr<antlr4::atn::ATN> atn;
};

std::once_flag mysqlparserParserOnceFlag;
MySQLParserStaticData *mysqlparserParserStaticData = nullptr;

void mysqlparserParserInitialize() {
  assert(mysqlparserParserStaticData == nullptr);
  auto staticData = std::make_unique<MySQLParserStaticData>(
    std::vector<std::string>{
      "query", "simpleStatement", "alterStatement", "alterDatabase", "alterDatabaseOption", 
      "alterEvent", "alterLogfileGroup", "alterLogfileGroupOptions", "alterLogfileGroupOption", 
      "alterServer", "alterTable", "alterTableActions", "alterCommandList", 
      "alterCommandsModifierList", "standaloneAlterCommands", "alterPartition", 
      "alterList", "alterCommandsModifier", "alterListItem", "place", "restrict", 
      "alterOrderList", "alterAlgorithmOption", "alterLockOption", "indexLockAndAlgorithm", 
      "withValidation", "removePartitioning", "allOrPartitionNameList", 
      "alterTablespace", "alterUndoTablespace", "undoTableSpaceOptions", 
      "undoTableSpaceOption", "alterTablespaceOptions", "alterTablespaceOption", 
      "changeTablespaceOption", "alterView", "viewTail", "viewQueryBlock", 
      "viewCheckOption", "alterInstanceStatement", "createStatement", "createDatabase", 
      "createDatabaseOption", "createTable", "tableElementList", "tableElement", 
      "duplicateAsQe", "asCreateQueryExpression", "queryExpressionOrParens", 
      "queryExpressionWithOptLockingClauses", "createRoutine", "createProcedure", 
      "routineString", "storedRoutineBody", "createFunction", "createUdf", 
      "routineCreateOption", "routineAlterOptions", "routineOption", "createIndex", 
      "indexNameAndType", "createIndexTarget", "createLogfileGroup", "logfileGroupOptions", 
      "logfileGroupOption", "createServer", "serverOptions", "serverOption", 
      "createTablespace", "createUndoTablespace", "tsDataFileName", "tsDataFile", 
      "tablespaceOptions", "tablespaceOption", "tsOptionInitialSize", "tsOptionUndoRedoBufferSize", 
      "tsOptionAutoextendSize", "tsOptionMaxSize", "tsOptionExtentSize", 
      "tsOptionNodegroup", "tsOptionEngine", "tsOptionWait", "tsOptionComment", 
      "tsOptionFileblockSize", "tsOptionEncryption", "tsOptionEngineAttribute", 
      "createView", "viewReplaceOrAlgorithm", "viewAlgorithm", "viewSuid", 
      "createTrigger", "triggerFollowsPrecedesClause", "createEvent", "createRole", 
      "createSpatialReference", "srsAttribute", "dropStatement", "dropDatabase", 
      "dropEvent", "dropFunction", "dropProcedure", "dropIndex", "dropLogfileGroup", 
      "dropLogfileGroupOption", "dropServer", "dropTable", "dropTableSpace", 
      "dropTrigger", "dropView", "dropRole", "dropSpatialReference", "dropUndoTablespace", 
      "renameTableStatement", "renamePair", "truncateTableStatement", "importStatement", 
      "callStatement", "deleteStatement", "partitionDelete", "deleteStatementOption", 
      "doStatement", "handlerStatement", "handlerReadOrScan", "insertStatement", 
      "insertLockOption", "insertFromConstructor", "fields", "insertValues", 
      "insertQueryExpression", "valueList", "values", "valuesReference", 
      "insertUpdateList", "loadStatement", "dataOrXml", "loadDataLock", 
      "loadFrom", "loadSourceType", "sourceCount", "sourceOrder", "xmlRowsIdentifiedBy", 
      "loadDataFileTail", "loadDataFileTargetList", "fieldOrVariableList", 
      "loadAlgorithm", "loadParallel", "loadMemory", "replaceStatement", 
      "selectStatement", "selectStatementWithInto", "queryExpression", "queryExpressionBody", 
      "queryExpressionParens", "queryPrimary", "querySpecification", "subquery", 
      "querySpecOption", "limitClause", "simpleLimitClause", "limitOptions", 
      "limitOption", "intoClause", "procedureAnalyseClause", "havingClause", 
      "windowClause", "windowDefinition", "windowSpec", "windowSpecDetails", 
      "windowFrameClause", "windowFrameUnits", "windowFrameExtent", "windowFrameStart", 
      "windowFrameBetween", "windowFrameBound", "windowFrameExclusion", 
      "withClause", "commonTableExpression", "groupByClause", "olapOption", 
      "orderClause", "direction", "fromClause", "tableReferenceList", "tableValueConstructor", 
      "explicitTable", "rowValueExplicit", "selectOption", "lockingClauseList", 
      "lockingClause", "lockStrengh", "lockedRowAction", "selectItemList", 
      "selectItem", "selectAlias", "whereClause", "tableReference", "escapedTableReference", 
      "joinedTable", "naturalJoinType", "innerJoinType", "outerJoinType", 
      "tableFactor", "singleTable", "singleTableParens", "derivedTable", 
      "tableReferenceListParens", "tableFunction", "columnsClause", "jtColumn", 
      "onEmptyOrError", "onEmptyOrErrorJsonTable", "onEmpty", "onError", 
      "jsonOnResponse", "unionOption", "tableAlias", "indexHintList", "indexHint", 
      "indexHintType", "keyOrIndex", "constraintKeyType", "indexHintClause", 
      "indexList", "indexListElement", "updateStatement", "transactionOrLockingStatement", 
      "transactionStatement", "beginWork", "startTransactionOptionList", 
      "savepointStatement", "lockStatement", "lockItem", "lockOption", "xaStatement", 
      "xaConvert", "xid", "replicationStatement", "purgeOptions", "resetOption", 
      "masterOrBinaryLogsAndGtids", "sourceResetOptions", "replicationLoad", 
      "changeReplicationSource", "changeSource", "sourceDefinitions", "sourceDefinition", 
      "changeReplicationSourceAutoPosition", "changeReplicationSourceHost", 
      "changeReplicationSourceBind", "changeReplicationSourceUser", "changeReplicationSourcePassword", 
      "changeReplicationSourcePort", "changeReplicationSourceConnectRetry", 
      "changeReplicationSourceRetryCount", "changeReplicationSourceDelay", 
      "changeReplicationSourceSSL", "changeReplicationSourceSSLCA", "changeReplicationSourceSSLCApath", 
      "changeReplicationSourceSSLCipher", "changeReplicationSourceSSLCLR", 
      "changeReplicationSourceSSLCLRpath", "changeReplicationSourceSSLKey", 
      "changeReplicationSourceSSLVerifyServerCert", "changeReplicationSourceTLSVersion", 
      "changeReplicationSourceTLSCiphersuites", "changeReplicationSourceSSLCert", 
      "changeReplicationSourcePublicKey", "changeReplicationSourceGetSourcePublicKey", 
      "changeReplicationSourceHeartbeatPeriod", "changeReplicationSourceCompressionAlgorithm", 
      "changeReplicationSourceZstdCompressionLevel", "privilegeCheckDef", 
      "tablePrimaryKeyCheckDef", "assignGtidsToAnonymousTransactionsDefinition", 
      "sourceTlsCiphersuitesDef", "sourceFileDef", "sourceLogFile", "sourceLogPos", 
      "serverIdList", "changeReplication", "filterDefinition", "filterDbList", 
      "filterTableList", "filterStringList", "filterWildDbTableString", 
      "filterDbPairList", "startReplicaStatement", "stopReplicaStatement", 
      "replicaUntil", "userOption", "passwordOption", "defaultAuthOption", 
      "pluginDirOption", "replicaThreadOptions", "replicaThreadOption", 
      "groupReplication", "groupReplicationStartOptions", "groupReplicationStartOption", 
      "groupReplicationUser", "groupReplicationPassword", "groupReplicationPluginAuth", 
      "replica", "preparedStatement", "executeStatement", "executeVarList", 
      "cloneStatement", "dataDirSSL", "ssl", "accountManagementStatement", 
      "alterUserStatement", "alterUserList", "alterUser", "oldAlterUser", 
      "userFunction", "createUserStatement", "createUserTail", "userAttributes", 
      "defaultRoleClause", "requireClause", "connectOptions", "accountLockPasswordExpireOptions", 
      "dropUserStatement", "grantStatement", "grantTargetList", "grantOptions", 
      "exceptRoleList", "withRoles", "grantAs", "versionedRequireClause", 
      "renameUserStatement", "revokeStatement", "aclType", "roleOrPrivilegesList", 
      "roleOrPrivilege", "grantIdentifier", "requireList", "requireListElement", 
      "grantOption", "setRoleStatement", "roleList", "role", "tableAdministrationStatement", 
      "histogram", "checkOption", "repairType", "uninstallStatement", "installStatement", 
      "installOptionType", "installSetRvalue", "installSetValue", "installSetValueList", 
      "setStatement", "startOptionValueList", "transactionCharacteristics", 
      "transactionAccessMode", "isolationLevel", "optionValueListContinued", 
      "optionValueNoOptionType", "optionValue", "startOptionValueListFollowingOptionType", 
      "optionValueFollowingOptionType", "setExprOrDefault", "showDatabasesStatement", 
      "showTablesStatement", "showTriggersStatement", "showEventsStatement", 
      "showTableStatusStatement", "showOpenTablesStatement", "showParseTreeStatement", 
      "showPluginsStatement", "showEngineLogsStatement", "showEngineMutexStatement", 
      "showEngineStatusStatement", "showColumnsStatement", "showBinaryLogsStatement", 
      "showBinaryLogStatusStatement", "showReplicasStatement", "showBinlogEventsStatement", 
      "showRelaylogEventsStatement", "showKeysStatement", "showEnginesStatement", 
      "showCountWarningsStatement", "showCountErrorsStatement", "showWarningsStatement", 
      "showErrorsStatement", "showProfilesStatement", "showProfileStatement", 
      "showStatusStatement", "showProcessListStatement", "showVariablesStatement", 
      "showCharacterSetStatement", "showCollationStatement", "showPrivilegesStatement", 
      "showGrantsStatement", "showCreateDatabaseStatement", "showCreateTableStatement", 
      "showCreateViewStatement", "showMasterStatusStatement", "showReplicaStatusStatement", 
      "showCreateProcedureStatement", "showCreateFunctionStatement", "showCreateTriggerStatement", 
      "showCreateProcedureStatusStatement", "showCreateFunctionStatusStatement", 
      "showCreateProcedureCodeStatement", "showCreateFunctionCodeStatement", 
      "showCreateEventStatement", "showCreateUserStatement", "showCommandType", 
      "engineOrAll", "fromOrIn", "inDb", "profileDefinitions", "profileDefinition", 
      "otherAdministrativeStatement", "keyCacheListOrParts", "keyCacheList", 
      "assignToKeycache", "assignToKeycachePartition", "cacheKeyList", "keyUsageElement", 
      "keyUsageList", "flushOption", "logType", "flushTables", "flushTablesOptions", 
      "preloadTail", "preloadList", "preloadKeys", "adminPartition", "resourceGroupManagement", 
      "createResourceGroup", "resourceGroupVcpuList", "vcpuNumOrRange", 
      "resourceGroupPriority", "resourceGroupEnableDisable", "alterResourceGroup", 
      "setResourceGroup", "threadIdList", "dropResourceGroup", "utilityStatement", 
      "describeStatement", "explainStatement", "explainOptions", "explainableStatement", 
      "explainInto", "helpCommand", "useCommand", "restartServer", "expr", 
      "boolPri", "compOp", "predicate", "predicateOperations", "bitExpr", 
      "simpleExpr", "arrayCast", "jsonOperator", "sumExpr", "groupingOperation", 
      "windowFunctionCall", "windowingClause", "leadLagInfo", "stableInteger", 
      "paramOrVar", "nullTreatment", "jsonFunction", "inSumExpr", "identListArg", 
      "identList", "fulltextOptions", "runtimeFunctionCall", "returningType", 
      "geometryFunction", "timeFunctionParameters", "fractionalPrecision", 
      "weightStringLevels", "weightStringLevelListItem", "dateTimeTtype", 
      "trimFunction", "substringFunction", "functionCall", "udfExprList", 
      "udfExpr", "userVariable", "userVariableIdentifier", "inExpressionUserVariableAssignment", 
      "rvalueSystemOrUserVariable", "lvalueVariable", "rvalueSystemVariable", 
      "whenExpression", "thenExpression", "elseExpression", "castType", 
      "exprList", "charset", "notRule", "not2Rule", "interval", "intervalTimeStamp", 
      "exprListWithParentheses", "exprWithParentheses", "simpleExprWithParentheses", 
      "orderList", "orderExpression", "groupList", "groupingExpression", 
      "channel", "compoundStatement", "returnStatement", "ifStatement", 
      "ifBody", "thenStatement", "compoundStatementList", "caseStatement", 
      "elseStatement", "labeledBlock", "unlabeledBlock", "label", "beginEndBlock", 
      "labeledControl", "unlabeledControl", "loopBlock", "whileDoBlock", 
      "repeatUntilBlock", "spDeclarations", "spDeclaration", "variableDeclaration", 
      "conditionDeclaration", "spCondition", "sqlstate", "handlerDeclaration", 
      "handlerCondition", "cursorDeclaration", "iterateStatement", "leaveStatement", 
      "getDiagnosticsStatement", "signalAllowedExpr", "statementInformationItem", 
      "conditionInformationItem", "signalInformationItemName", "signalStatement", 
      "resignalStatement", "signalInformationItem", "cursorOpen", "cursorClose", 
      "cursorFetch", "schedule", "columnDefinition", "checkOrReferences", 
      "checkConstraint", "constraintEnforcement", "tableConstraintDef", 
      "constraintName", "fieldDefinition", "columnAttribute", "columnFormat", 
      "storageMedia", "now", "nowOrSignedLiteral", "gcolAttribute", "references", 
      "deleteOption", "keyList", "keyPart", "keyListWithExpression", "keyPartOrExpression", 
      "indexType", "indexOption", "commonIndexOption", "visibility", "indexTypeClause", 
      "fulltextIndexOption", "spatialIndexOption", "dataTypeDefinition", 
      "dataType", "nchar", "realType", "fieldLength", "fieldOptions", "charsetWithOptBinary", 
      "ascii", "unicode", "wsNumCodepoints", "typeDatetimePrecision", "functionDatetimePrecision", 
      "charsetName", "collationName", "createTableOptions", "createTableOptionsEtc", 
      "createPartitioningEtc", "createTableOptionsSpaceSeparated", "createTableOption", 
      "ternaryOption", "defaultCollation", "defaultEncryption", "defaultCharset", 
      "partitionClause", "partitionTypeDef", "subPartitions", "partitionKeyAlgorithm", 
      "partitionDefinitions", "partitionDefinition", "partitionValuesIn", 
      "partitionOption", "subpartitionDefinition", "partitionValueItemListParen", 
      "partitionValueItem", "definerClause", "ifExists", "ifExistsIdentifier", 
      "persistedVariableIdentifier", "ifNotExists", "ignoreUnknownUser", 
      "procedureParameter", "functionParameter", "collate", "typeWithOptCollate", 
      "schemaIdentifierPair", "viewRefList", "updateList", "updateElement", 
      "charsetClause", "fieldsClause", "fieldTerm", "linesClause", "lineTerm", 
      "userList", "createUserList", "createUser", "createUserWithMfa", "identification", 
      "identifiedByPassword", "identifiedByRandomPassword", "identifiedWithPlugin", 
      "identifiedWithPluginAsAuth", "identifiedWithPluginByPassword", "identifiedWithPluginByRandomPassword", 
      "initialAuth", "retainCurrentPassword", "discardOldPassword", "userRegistration", 
      "factor", "replacePassword", "userIdentifierOrText", "user", "likeClause", 
      "likeOrWhere", "onlineOption", "noWriteToBinLog", "usePartition", 
      "fieldIdentifier", "columnName", "columnInternalRef", "columnInternalRefList", 
      "columnRef", "insertIdentifier", "indexName", "indexRef", "tableWild", 
      "schemaName", "schemaRef", "procedureName", "procedureRef", "functionName", 
      "functionRef", "triggerName", "triggerRef", "viewName", "viewRef", 
      "tablespaceName", "tablespaceRef", "logfileGroupName", "logfileGroupRef", 
      "eventName", "eventRef", "udfName", "serverName", "serverRef", "engineRef", 
      "tableName", "filterTableRef", "tableRefWithWildcard", "tableRef", 
      "tableRefList", "tableAliasRefList", "parameterName", "labelIdentifier", 
      "labelRef", "roleIdentifier", "pluginRef", "componentRef", "resourceGroupRef", 
      "windowName", "pureIdentifier", "identifier", "identifierList", "identifierListWithParentheses", 
      "qualifiedIdentifier", "simpleIdentifier", "dotIdentifier", "ulong_number", 
      "real_ulong_number", "ulonglong_number", "real_ulonglong_number", 
      "signedLiteral", "signedLiteralOrNull", "literal", "literalOrNull", 
      "nullAsLiteral", "stringList", "textStringLiteral", "textString", 
      "textStringHash", "textLiteral", "textStringNoLinebreak", "textStringLiteralList", 
      "numLiteral", "boolLiteral", "nullLiteral", "int64Literal", "temporalLiteral", 
      "floatOptions", "standardFloatOptions", "precision", "textOrIdentifier", 
      "lValueIdentifier", "roleIdentifierOrText", "sizeNumber", "parentheses", 
      "equal", "optionType", "rvalueSystemVariableType", "setVarIdentType", 
      "jsonAttribute", "identifierKeyword", "identifierKeywordsAmbiguous1RolesAndLabels", 
      "identifierKeywordsAmbiguous2Labels", "labelKeyword", "identifierKeywordsAmbiguous3Roles", 
      "identifierKeywordsUnambiguous", "roleKeyword", "lValueKeyword", "identifierKeywordsAmbiguous4SystemVariables", 
      "roleOrIdentifierKeyword", "roleOrLabelKeyword"
    },
    std::vector<std::string>{
      "", "", "", "", "", "", "'='", "':='", "'<=>'", "'>='", "'>'", "'<='", 
      "'<'", "'!='", "'+'", "'-'", "'*'", "'/'", "'%'", "'!'", "'~'", "'<<'", 
      "'>>'", "'&&'", "'&'", "'^'", "'||'", "'|'", "'.'", "','", "';'", 
      "':'", "'('", "')'", "'{'", "'}'", "'_'", "'->'", "'->>'", "'@'", 
      "", "'\\N'", "'\\u003F'", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "'<>'"
    },
    std::vector<std::string>{
      "", "NOT2_SYMBOL", "CONCAT_PIPES_SYMBOL", "INT_NUMBER", "LONG_NUMBER", 
      "ULONGLONG_NUMBER", "EQUAL_OPERATOR", "ASSIGN_OPERATOR", "NULL_SAFE_EQUAL_OPERATOR", 
      "GREATER_OR_EQUAL_OPERATOR", "GREATER_THAN_OPERATOR", "LESS_OR_EQUAL_OPERATOR", 
      "LESS_THAN_OPERATOR", "NOT_EQUAL_OPERATOR", "PLUS_OPERATOR", "MINUS_OPERATOR", 
      "MULT_OPERATOR", "DIV_OPERATOR", "MOD_OPERATOR", "LOGICAL_NOT_OPERATOR", 
      "BITWISE_NOT_OPERATOR", "SHIFT_LEFT_OPERATOR", "SHIFT_RIGHT_OPERATOR", 
      "LOGICAL_AND_OPERATOR", "BITWISE_AND_OPERATOR", "BITWISE_XOR_OPERATOR", 
      "LOGICAL_OR_OPERATOR", "BITWISE_OR_OPERATOR", "DOT_SYMBOL", "COMMA_SYMBOL", 
      "SEMICOLON_SYMBOL", "COLON_SYMBOL", "OPEN_PAR_SYMBOL", "CLOSE_PAR_SYMBOL", 
      "OPEN_CURLY_SYMBOL", "CLOSE_CURLY_SYMBOL", "UNDERLINE_SYMBOL", "JSON_SEPARATOR_SYMBOL", 
      "JSON_UNQUOTED_SEPARATOR_SYMBOL", "AT_SIGN_SYMBOL", "AT_AT_SIGN_SYMBOL", 
      "NULL2_SYMBOL", "PARAM_MARKER", "HEX_NUMBER", "BIN_NUMBER", "DECIMAL_NUMBER", 
      "FLOAT_NUMBER", "ACCESSIBLE_SYMBOL", "ACCOUNT_SYMBOL", "ACTION_SYMBOL", 
      "ADD_SYMBOL", "ADDDATE_SYMBOL", "AFTER_SYMBOL", "AGAINST_SYMBOL", 
      "AGGREGATE_SYMBOL", "ALGORITHM_SYMBOL", "ALL_SYMBOL", "ALTER_SYMBOL", 
      "ALWAYS_SYMBOL", "ANALYSE_SYMBOL", "ANALYZE_SYMBOL", "AND_SYMBOL", 
      "ANY_SYMBOL", "AS_SYMBOL", "ASC_SYMBOL", "ASCII_SYMBOL", "ASENSITIVE_SYMBOL", 
      "AT_SYMBOL", "AUTOEXTEND_SIZE_SYMBOL", "AUTO_INCREMENT_SYMBOL", "AVG_ROW_LENGTH_SYMBOL", 
      "AVG_SYMBOL", "BACKUP_SYMBOL", "BEFORE_SYMBOL", "BEGIN_SYMBOL", "BETWEEN_SYMBOL", 
      "BIGINT_SYMBOL", "BINARY_SYMBOL", "BINLOG_SYMBOL", "BIN_NUM_SYMBOL", 
      "BIT_AND_SYMBOL", "BIT_OR_SYMBOL", "BIT_SYMBOL", "BIT_XOR_SYMBOL", 
      "BLOB_SYMBOL", "BLOCK_SYMBOL", "BOOLEAN_SYMBOL", "BOOL_SYMBOL", "BOTH_SYMBOL", 
      "BTREE_SYMBOL", "BY_SYMBOL", "BYTE_SYMBOL", "CACHE_SYMBOL", "CALL_SYMBOL", 
      "CASCADE_SYMBOL", "CASCADED_SYMBOL", "CASE_SYMBOL", "CAST_SYMBOL", 
      "CATALOG_NAME_SYMBOL", "CHAIN_SYMBOL", "CHANGE_SYMBOL", "CHANGED_SYMBOL", 
      "CHANNEL_SYMBOL", "CHARSET_SYMBOL", "CHAR_SYMBOL", "CHECKSUM_SYMBOL", 
      "CHECK_SYMBOL", "CIPHER_SYMBOL", "CLASS_ORIGIN_SYMBOL", "CLIENT_SYMBOL", 
      "CLOSE_SYMBOL", "COALESCE_SYMBOL", "CODE_SYMBOL", "COLLATE_SYMBOL", 
      "COLLATION_SYMBOL", "COLUMNS_SYMBOL", "COLUMN_SYMBOL", "COLUMN_NAME_SYMBOL", 
      "COLUMN_FORMAT_SYMBOL", "COMMENT_SYMBOL", "COMMITTED_SYMBOL", "COMMIT_SYMBOL", 
      "COMPACT_SYMBOL", "COMPLETION_SYMBOL", "COMPRESSED_SYMBOL", "COMPRESSION_SYMBOL", 
      "CONCURRENT_SYMBOL", "CONDITION_SYMBOL", "CONNECTION_SYMBOL", "CONSISTENT_SYMBOL", 
      "CONSTRAINT_SYMBOL", "CONSTRAINT_CATALOG_SYMBOL", "CONSTRAINT_NAME_SYMBOL", 
      "CONSTRAINT_SCHEMA_SYMBOL", "CONTAINS_SYMBOL", "CONTEXT_SYMBOL", "CONTINUE_SYMBOL", 
      "CONVERT_SYMBOL", "COUNT_SYMBOL", "CPU_SYMBOL", "CREATE_SYMBOL", "CROSS_SYMBOL", 
      "CUBE_SYMBOL", "CURDATE_SYMBOL", "CURRENT_SYMBOL", "CURRENT_DATE_SYMBOL", 
      "CURRENT_TIME_SYMBOL", "CURRENT_USER_SYMBOL", "CURSOR_SYMBOL", "CURSOR_NAME_SYMBOL", 
      "CURTIME_SYMBOL", "DATABASE_SYMBOL", "DATABASES_SYMBOL", "DATAFILE_SYMBOL", 
      "DATA_SYMBOL", "DATETIME_SYMBOL", "DATE_ADD_SYMBOL", "DATE_SUB_SYMBOL", 
      "DATE_SYMBOL", "DAY_HOUR_SYMBOL", "DAY_MICROSECOND_SYMBOL", "DAY_MINUTE_SYMBOL", 
      "DAY_SECOND_SYMBOL", "DAY_SYMBOL", "DEALLOCATE_SYMBOL", "DECIMAL_NUM_SYMBOL", 
      "DECIMAL_SYMBOL", "DECLARE_SYMBOL", "DEFAULT_SYMBOL", "DEFAULT_AUTH_SYMBOL", 
      "DEFINER_SYMBOL", "DELAYED_SYMBOL", "DELAY_KEY_WRITE_SYMBOL", "DELETE_SYMBOL", 
      "DESC_SYMBOL", "DESCRIBE_SYMBOL", "DES_KEY_FILE_SYMBOL", "DETERMINISTIC_SYMBOL", 
      "DIAGNOSTICS_SYMBOL", "DIRECTORY_SYMBOL", "DISABLE_SYMBOL", "DISCARD_SYMBOL", 
      "DISK_SYMBOL", "DISTINCT_SYMBOL", "DIV_SYMBOL", "DOUBLE_SYMBOL", "DO_SYMBOL", 
      "DROP_SYMBOL", "DUAL_SYMBOL", "DUMPFILE_SYMBOL", "DUPLICATE_SYMBOL", 
      "DYNAMIC_SYMBOL", "EACH_SYMBOL", "ELSE_SYMBOL", "ELSEIF_SYMBOL", "ENABLE_SYMBOL", 
      "ENCLOSED_SYMBOL", "ENCRYPTION_SYMBOL", "END_SYMBOL", "ENDS_SYMBOL", 
      "END_OF_INPUT_SYMBOL", "ENGINES_SYMBOL", "ENGINE_SYMBOL", "ENUM_SYMBOL", 
      "ERROR_SYMBOL", "ERRORS_SYMBOL", "ESCAPED_SYMBOL", "ESCAPE_SYMBOL", 
      "EVENTS_SYMBOL", "EVENT_SYMBOL", "EVERY_SYMBOL", "EXCHANGE_SYMBOL", 
      "EXECUTE_SYMBOL", "EXISTS_SYMBOL", "EXIT_SYMBOL", "EXPANSION_SYMBOL", 
      "EXPIRE_SYMBOL", "EXPLAIN_SYMBOL", "EXPORT_SYMBOL", "EXTENDED_SYMBOL", 
      "EXTENT_SIZE_SYMBOL", "EXTRACT_SYMBOL", "FALSE_SYMBOL", "FAST_SYMBOL", 
      "FAULTS_SYMBOL", "FETCH_SYMBOL", "FILE_SYMBOL", "FILE_BLOCK_SIZE_SYMBOL", 
      "FILTER_SYMBOL", "FIRST_SYMBOL", "FIXED_SYMBOL", "FLOAT_SYMBOL", "FLUSH_SYMBOL", 
      "FOLLOWS_SYMBOL", "FORCE_SYMBOL", "FOREIGN_SYMBOL", "FOR_SYMBOL", 
      "FORMAT_SYMBOL", "FOUND_SYMBOL", "FROM_SYMBOL", "FULL_SYMBOL", "FULLTEXT_SYMBOL", 
      "FUNCTION_SYMBOL", "GET_SYMBOL", "GENERAL_SYMBOL", "GENERATED_SYMBOL", 
      "GROUP_REPLICATION_SYMBOL", "GEOMETRYCOLLECTION_SYMBOL", "GEOMETRY_SYMBOL", 
      "GET_FORMAT_SYMBOL", "GLOBAL_SYMBOL", "GRANT_SYMBOL", "GRANTS_SYMBOL", 
      "GROUP_SYMBOL", "GROUP_CONCAT_SYMBOL", "HANDLER_SYMBOL", "HASH_SYMBOL", 
      "HAVING_SYMBOL", "HELP_SYMBOL", "HIGH_PRIORITY_SYMBOL", "HOST_SYMBOL", 
      "HOSTS_SYMBOL", "HOUR_MICROSECOND_SYMBOL", "HOUR_MINUTE_SYMBOL", "HOUR_SECOND_SYMBOL", 
      "HOUR_SYMBOL", "IDENTIFIED_SYMBOL", "IF_SYMBOL", "IGNORE_SYMBOL", 
      "IGNORE_SERVER_IDS_SYMBOL", "IMPORT_SYMBOL", "INDEXES_SYMBOL", "INDEX_SYMBOL", 
      "INFILE_SYMBOL", "INITIAL_SIZE_SYMBOL", "INNER_SYMBOL", "INOUT_SYMBOL", 
      "INSENSITIVE_SYMBOL", "INSERT_SYMBOL", "INSERT_METHOD_SYMBOL", "INSTANCE_SYMBOL", 
      "INSTALL_SYMBOL", "INTERVAL_SYMBOL", "INTO_SYMBOL", "INT_SYMBOL", 
      "INVOKER_SYMBOL", "IN_SYMBOL", "IO_AFTER_GTIDS_SYMBOL", "IO_BEFORE_GTIDS_SYMBOL", 
      "IO_SYMBOL", "IPC_SYMBOL", "IS_SYMBOL", "ISOLATION_SYMBOL", "ISSUER_SYMBOL", 
      "ITERATE_SYMBOL", "JOIN_SYMBOL", "JSON_SYMBOL", "KEYS_SYMBOL", "KEY_BLOCK_SIZE_SYMBOL", 
      "KEY_SYMBOL", "KILL_SYMBOL", "LANGUAGE_SYMBOL", "LAST_SYMBOL", "LEADING_SYMBOL", 
      "LEAVES_SYMBOL", "LEAVE_SYMBOL", "LEFT_SYMBOL", "LESS_SYMBOL", "LEVEL_SYMBOL", 
      "LIKE_SYMBOL", "LIMIT_SYMBOL", "LINEAR_SYMBOL", "LINES_SYMBOL", "LINESTRING_SYMBOL", 
      "LIST_SYMBOL", "LOAD_SYMBOL", "LOCAL_SYMBOL", "LOCATOR_SYMBOL", "LOCKS_SYMBOL", 
      "LOCK_SYMBOL", "LOGFILE_SYMBOL", "LOGS_SYMBOL", "LONGBLOB_SYMBOL", 
      "LONGTEXT_SYMBOL", "LONG_NUM_SYMBOL", "LONG_SYMBOL", "LOOP_SYMBOL", 
      "LOW_PRIORITY_SYMBOL", "MASTER_AUTO_POSITION_SYMBOL", "MASTER_BIND_SYMBOL", 
      "MASTER_CONNECT_RETRY_SYMBOL", "MASTER_DELAY_SYMBOL", "MASTER_HOST_SYMBOL", 
      "MASTER_LOG_FILE_SYMBOL", "MASTER_LOG_POS_SYMBOL", "MASTER_PASSWORD_SYMBOL", 
      "MASTER_PORT_SYMBOL", "MASTER_RETRY_COUNT_SYMBOL", "MASTER_SERVER_ID_SYMBOL", 
      "MASTER_SSL_CAPATH_SYMBOL", "MASTER_SSL_CA_SYMBOL", "MASTER_SSL_CERT_SYMBOL", 
      "MASTER_SSL_CIPHER_SYMBOL", "MASTER_SSL_CRL_SYMBOL", "MASTER_SSL_CRLPATH_SYMBOL", 
      "MASTER_SSL_KEY_SYMBOL", "MASTER_SSL_SYMBOL", "MASTER_SSL_VERIFY_SERVER_CERT_SYMBOL", 
      "MASTER_SYMBOL", "MASTER_TLS_VERSION_SYMBOL", "MASTER_USER_SYMBOL", 
      "MASTER_HEARTBEAT_PERIOD_SYMBOL", "MATCH_SYMBOL", "MAX_CONNECTIONS_PER_HOUR_SYMBOL", 
      "MAX_QUERIES_PER_HOUR_SYMBOL", "MAX_ROWS_SYMBOL", "MAX_SIZE_SYMBOL", 
      "MAX_STATEMENT_TIME_SYMBOL", "MAX_SYMBOL", "MAX_UPDATES_PER_HOUR_SYMBOL", 
      "MAX_USER_CONNECTIONS_SYMBOL", "MAXVALUE_SYMBOL", "MEDIUMBLOB_SYMBOL", 
      "MEDIUMINT_SYMBOL", "MEDIUMTEXT_SYMBOL", "MEDIUM_SYMBOL", "MEMORY_SYMBOL", 
      "MERGE_SYMBOL", "MESSAGE_TEXT_SYMBOL", "MICROSECOND_SYMBOL", "MID_SYMBOL", 
      "MIGRATE_SYMBOL", "MINUTE_MICROSECOND_SYMBOL", "MINUTE_SECOND_SYMBOL", 
      "MINUTE_SYMBOL", "MIN_ROWS_SYMBOL", "MIN_SYMBOL", "MODE_SYMBOL", "MODIFIES_SYMBOL", 
      "MODIFY_SYMBOL", "MOD_SYMBOL", "MONTH_SYMBOL", "MULTILINESTRING_SYMBOL", 
      "MULTIPOINT_SYMBOL", "MULTIPOLYGON_SYMBOL", "MUTEX_SYMBOL", "MYSQL_ERRNO_SYMBOL", 
      "NAMES_SYMBOL", "NAME_SYMBOL", "NATIONAL_SYMBOL", "NATURAL_SYMBOL", 
      "NCHAR_STRING_SYMBOL", "NCHAR_SYMBOL", "NDBCLUSTER_SYMBOL", "NEG_SYMBOL", 
      "NEVER_SYMBOL", "NEW_SYMBOL", "NEXT_SYMBOL", "NODEGROUP_SYMBOL", "NONE_SYMBOL", 
      "NONBLOCKING_SYMBOL", "NOT_SYMBOL", "NOW_SYMBOL", "NO_SYMBOL", "NO_WAIT_SYMBOL", 
      "NO_WRITE_TO_BINLOG_SYMBOL", "NULL_SYMBOL", "NUMBER_SYMBOL", "NUMERIC_SYMBOL", 
      "NVARCHAR_SYMBOL", "OFFLINE_SYMBOL", "OFFSET_SYMBOL", "OLD_PASSWORD_SYMBOL", 
      "ON_SYMBOL", "ONE_SYMBOL", "ONLINE_SYMBOL", "ONLY_SYMBOL", "OPEN_SYMBOL", 
      "OPTIMIZE_SYMBOL", "OPTIMIZER_COSTS_SYMBOL", "OPTIONS_SYMBOL", "OPTION_SYMBOL", 
      "OPTIONALLY_SYMBOL", "ORDER_SYMBOL", "OR_SYMBOL", "OUTER_SYMBOL", 
      "OUTFILE_SYMBOL", "OUT_SYMBOL", "OWNER_SYMBOL", "PACK_KEYS_SYMBOL", 
      "PAGE_SYMBOL", "PARSER_SYMBOL", "PARTIAL_SYMBOL", "PARTITIONING_SYMBOL", 
      "PARTITIONS_SYMBOL", "PARTITION_SYMBOL", "PASSWORD_SYMBOL", "PHASE_SYMBOL", 
      "PLUGINS_SYMBOL", "PLUGIN_DIR_SYMBOL", "PLUGIN_SYMBOL", "POINT_SYMBOL", 
      "POLYGON_SYMBOL", "PORT_SYMBOL", "POSITION_SYMBOL", "PRECEDES_SYMBOL", 
      "PRECISION_SYMBOL", "PREPARE_SYMBOL", "PRESERVE_SYMBOL", "PREV_SYMBOL", 
      "PRIMARY_SYMBOL", "PRIVILEGES_SYMBOL", "PROCEDURE_SYMBOL", "PROCESS_SYMBOL", 
      "PROCESSLIST_SYMBOL", "PROFILE_SYMBOL", "PROFILES_SYMBOL", "PROXY_SYMBOL", 
      "PURGE_SYMBOL", "QUARTER_SYMBOL", "QUERY_SYMBOL", "QUICK_SYMBOL", 
      "RANGE_SYMBOL", "READS_SYMBOL", "READ_ONLY_SYMBOL", "READ_SYMBOL", 
      "READ_WRITE_SYMBOL", "REAL_SYMBOL", "REBUILD_SYMBOL", "RECOVER_SYMBOL", 
      "REDOFILE_SYMBOL", "REDO_BUFFER_SIZE_SYMBOL", "REDUNDANT_SYMBOL", 
      "REFERENCES_SYMBOL", "REGEXP_SYMBOL", "RELAY_SYMBOL", "RELAYLOG_SYMBOL", 
      "RELAY_LOG_FILE_SYMBOL", "RELAY_LOG_POS_SYMBOL", "RELAY_THREAD_SYMBOL", 
      "RELEASE_SYMBOL", "RELOAD_SYMBOL", "REMOVE_SYMBOL", "RENAME_SYMBOL", 
      "REORGANIZE_SYMBOL", "REPAIR_SYMBOL", "REPEATABLE_SYMBOL", "REPEAT_SYMBOL", 
      "REPLACE_SYMBOL", "REPLICATION_SYMBOL", "REPLICATE_DO_DB_SYMBOL", 
      "REPLICATE_IGNORE_DB_SYMBOL", "REPLICATE_DO_TABLE_SYMBOL", "REPLICATE_IGNORE_TABLE_SYMBOL", 
      "REPLICATE_WILD_DO_TABLE_SYMBOL", "REPLICATE_WILD_IGNORE_TABLE_SYMBOL", 
      "REPLICATE_REWRITE_DB_SYMBOL", "REQUIRE_SYMBOL", "RESET_SYMBOL", "RESIGNAL_SYMBOL", 
      "RESTORE_SYMBOL", "RESTRICT_SYMBOL", "RESUME_SYMBOL", "RETURNED_SQLSTATE_SYMBOL", 
      "RETURNS_SYMBOL", "RETURN_SYMBOL", "REVERSE_SYMBOL", "REVOKE_SYMBOL", 
      "RIGHT_SYMBOL", "ROLLBACK_SYMBOL", "ROLLUP_SYMBOL", "ROTATE_SYMBOL", 
      "ROUTINE_SYMBOL", "ROWS_SYMBOL", "ROW_COUNT_SYMBOL", "ROW_FORMAT_SYMBOL", 
      "ROW_SYMBOL", "RTREE_SYMBOL", "SAVEPOINT_SYMBOL", "SCHEDULE_SYMBOL", 
      "SCHEMA_NAME_SYMBOL", "SECOND_MICROSECOND_SYMBOL", "SECOND_SYMBOL", 
      "SECURITY_SYMBOL", "SELECT_SYMBOL", "SENSITIVE_SYMBOL", "SEPARATOR_SYMBOL", 
      "SERIALIZABLE_SYMBOL", "SERIAL_SYMBOL", "SESSION_SYMBOL", "SERVER_SYMBOL", 
      "SERVER_OPTIONS_SYMBOL", "SESSION_USER_SYMBOL", "SET_SYMBOL", "SET_VAR_SYMBOL", 
      "SHARE_SYMBOL", "SHOW_SYMBOL", "SHUTDOWN_SYMBOL", "SIGNAL_SYMBOL", 
      "SIGNED_SYMBOL", "SIMPLE_SYMBOL", "SLAVE_SYMBOL", "SLOW_SYMBOL", "SMALLINT_SYMBOL", 
      "SNAPSHOT_SYMBOL", "SOCKET_SYMBOL", "SONAME_SYMBOL", "SOUNDS_SYMBOL", 
      "SOURCE_SYMBOL", "SPATIAL_SYMBOL", "SPECIFIC_SYMBOL", "SQLEXCEPTION_SYMBOL", 
      "SQLSTATE_SYMBOL", "SQLWARNING_SYMBOL", "SQL_AFTER_GTIDS_SYMBOL", 
      "SQL_AFTER_MTS_GAPS_SYMBOL", "SQL_BEFORE_GTIDS_SYMBOL", "SQL_BIG_RESULT_SYMBOL", 
      "SQL_BUFFER_RESULT_SYMBOL", "SQL_CACHE_SYMBOL", "SQL_CALC_FOUND_ROWS_SYMBOL", 
      "SQL_NO_CACHE_SYMBOL", "SQL_SMALL_RESULT_SYMBOL", "SQL_SYMBOL", "SQL_THREAD_SYMBOL", 
      "SSL_SYMBOL", "STACKED_SYMBOL", "STARTING_SYMBOL", "STARTS_SYMBOL", 
      "START_SYMBOL", "STATS_AUTO_RECALC_SYMBOL", "STATS_PERSISTENT_SYMBOL", 
      "STATS_SAMPLE_PAGES_SYMBOL", "STATUS_SYMBOL", "STDDEV_SAMP_SYMBOL", 
      "STDDEV_SYMBOL", "STDDEV_POP_SYMBOL", "STD_SYMBOL", "STOP_SYMBOL", 
      "STORAGE_SYMBOL", "STORED_SYMBOL", "STRAIGHT_JOIN_SYMBOL", "STRING_SYMBOL", 
      "SUBCLASS_ORIGIN_SYMBOL", "SUBDATE_SYMBOL", "SUBJECT_SYMBOL", "SUBPARTITIONS_SYMBOL", 
      "SUBPARTITION_SYMBOL", "SUBSTR_SYMBOL", "SUBSTRING_SYMBOL", "SUM_SYMBOL", 
      "SUPER_SYMBOL", "SUSPEND_SYMBOL", "SWAPS_SYMBOL", "SWITCHES_SYMBOL", 
      "SYSDATE_SYMBOL", "SYSTEM_USER_SYMBOL", "TABLES_SYMBOL", "TABLESPACE_SYMBOL", 
      "TABLE_REF_PRIORITY_SYMBOL", "TABLE_SYMBOL", "TABLE_CHECKSUM_SYMBOL", 
      "TABLE_NAME_SYMBOL", "TEMPORARY_SYMBOL", "TEMPTABLE_SYMBOL", "TERMINATED_SYMBOL", 
      "TEXT_SYMBOL", "THAN_SYMBOL", "THEN_SYMBOL", "TIMESTAMP_SYMBOL", "TIMESTAMPADD_SYMBOL", 
      "TIMESTAMPDIFF_SYMBOL", "TIME_SYMBOL", "TINYBLOB_SYMBOL", "TINYINT_SYMBOL", 
      "TINYTEXT_SYMBOL", "TO_SYMBOL", "TRAILING_SYMBOL", "TRANSACTION_SYMBOL", 
      "TRIGGERS_SYMBOL", "TRIGGER_SYMBOL", "TRIM_SYMBOL", "TRUE_SYMBOL", 
      "TRUNCATE_SYMBOL", "TYPES_SYMBOL", "TYPE_SYMBOL", "UDF_RETURNS_SYMBOL", 
      "UNCOMMITTED_SYMBOL", "UNDEFINED_SYMBOL", "UNDOFILE_SYMBOL", "UNDO_BUFFER_SIZE_SYMBOL", 
      "UNDO_SYMBOL", "UNICODE_SYMBOL", "UNINSTALL_SYMBOL", "UNION_SYMBOL", 
      "UNIQUE_SYMBOL", "UNKNOWN_SYMBOL", "UNLOCK_SYMBOL", "UNSIGNED_SYMBOL", 
      "UNTIL_SYMBOL", "UPDATE_SYMBOL", "UPGRADE_SYMBOL", "USAGE_SYMBOL", 
      "USER_RESOURCES_SYMBOL", "USER_SYMBOL", "USE_FRM_SYMBOL", "USE_SYMBOL", 
      "USING_SYMBOL", "UTC_DATE_SYMBOL", "UTC_TIMESTAMP_SYMBOL", "UTC_TIME_SYMBOL", 
      "VALIDATION_SYMBOL", "VALUES_SYMBOL", "VALUE_SYMBOL", "VARBINARY_SYMBOL", 
      "VARCHAR_SYMBOL", "VARIABLES_SYMBOL", "VARIANCE_SYMBOL", "VARYING_SYMBOL", 
      "VAR_POP_SYMBOL", "VAR_SAMP_SYMBOL", "VIEW_SYMBOL", "VIRTUAL_SYMBOL", 
      "WAIT_SYMBOL", "WARNINGS_SYMBOL", "WEEK_SYMBOL", "WEIGHT_STRING_SYMBOL", 
      "WHEN_SYMBOL", "WHERE_SYMBOL", "WHILE_SYMBOL", "WITH_SYMBOL", "WITHOUT_SYMBOL", 
      "WORK_SYMBOL", "WRAPPER_SYMBOL", "WRITE_SYMBOL", "X509_SYMBOL", "XA_SYMBOL", 
      "XID_SYMBOL", "XML_SYMBOL", "XOR_SYMBOL", "YEAR_MONTH_SYMBOL", "YEAR_SYMBOL", 
      "ZEROFILL_SYMBOL", "PERSIST_SYMBOL", "ROLE_SYMBOL", "ADMIN_SYMBOL", 
      "INVISIBLE_SYMBOL", "VISIBLE_SYMBOL", "EXCEPT_SYMBOL", "COMPONENT_SYMBOL", 
      "RECURSIVE_SYMBOL", "JSON_OBJECTAGG_SYMBOL", "JSON_ARRAYAGG_SYMBOL", 
      "OF_SYMBOL", "SKIP_SYMBOL", "LOCKED_SYMBOL", "NOWAIT_SYMBOL", "GROUPING_SYMBOL", 
      "PERSIST_ONLY_SYMBOL", "HISTOGRAM_SYMBOL", "BUCKETS_SYMBOL", "REMOTE_SYMBOL", 
      "CLONE_SYMBOL", "CUME_DIST_SYMBOL", "DENSE_RANK_SYMBOL", "EXCLUDE_SYMBOL", 
      "FIRST_VALUE_SYMBOL", "FOLLOWING_SYMBOL", "GROUPS_SYMBOL", "LAG_SYMBOL", 
      "LAST_VALUE_SYMBOL", "LEAD_SYMBOL", "NTH_VALUE_SYMBOL", "NTILE_SYMBOL", 
      "NULLS_SYMBOL", "OTHERS_SYMBOL", "OVER_SYMBOL", "PERCENT_RANK_SYMBOL", 
      "PRECEDING_SYMBOL", "RANK_SYMBOL", "RESPECT_SYMBOL", "ROW_NUMBER_SYMBOL", 
      "TIES_SYMBOL", "UNBOUNDED_SYMBOL", "WINDOW_SYMBOL", "EMPTY_SYMBOL", 
      "JSON_TABLE_SYMBOL", "NESTED_SYMBOL", "ORDINALITY_SYMBOL", "PATH_SYMBOL", 
      "HISTORY_SYMBOL", "REUSE_SYMBOL", "SRID_SYMBOL", "THREAD_PRIORITY_SYMBOL", 
      "RESOURCE_SYMBOL", "SYSTEM_SYMBOL", "VCPU_SYMBOL", "MASTER_PUBLIC_KEY_PATH_SYMBOL", 
      "GET_MASTER_PUBLIC_KEY_SYMBOL", "RESTART_SYMBOL", "DEFINITION_SYMBOL", 
      "DESCRIPTION_SYMBOL", "ORGANIZATION_SYMBOL", "REFERENCE_SYMBOL", "OPTIONAL_SYMBOL", 
      "SECONDARY_SYMBOL", "SECONDARY_ENGINE_SYMBOL", "SECONDARY_LOAD_SYMBOL", 
      "SECONDARY_UNLOAD_SYMBOL", "ACTIVE_SYMBOL", "INACTIVE_SYMBOL", "LATERAL_SYMBOL", 
      "RETAIN_SYMBOL", "OLD_SYMBOL", "NETWORK_NAMESPACE_SYMBOL", "ENFORCED_SYMBOL", 
      "ARRAY_SYMBOL", "OJ_SYMBOL", "MEMBER_SYMBOL", "RANDOM_SYMBOL", "MASTER_COMPRESSION_ALGORITHM_SYMBOL", 
      "MASTER_ZSTD_COMPRESSION_LEVEL_SYMBOL", "PRIVILEGE_CHECKS_USER_SYMBOL", 
      "MASTER_TLS_CIPHERSUITES_SYMBOL", "REQUIRE_ROW_FORMAT_SYMBOL", "PASSWORD_LOCK_TIME_SYMBOL", 
      "FAILED_LOGIN_ATTEMPTS_SYMBOL", "REQUIRE_TABLE_PRIMARY_KEY_CHECK_SYMBOL", 
      "STREAM_SYMBOL", "OFF_SYMBOL", "RETURNING_SYMBOL", "JSON_VALUE_SYMBOL", 
      "TLS_SYMBOL", "ATTRIBUTE_SYMBOL", "ENGINE_ATTRIBUTE_SYMBOL", "SECONDARY_ENGINE_ATTRIBUTE_SYMBOL", 
      "SOURCE_CONNECTION_AUTO_FAILOVER_SYMBOL", "ZONE_SYMBOL", "GRAMMAR_SELECTOR_DERIVED_EXPR", 
      "REPLICA_SYMBOL", "REPLICAS_SYMBOL", "ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS_SYMBOL", 
      "GET_SOURCE_PUBLIC_KEY_SYMBOL", "SOURCE_AUTO_POSITION_SYMBOL", "SOURCE_BIND_SYMBOL", 
      "SOURCE_COMPRESSION_ALGORITHM_SYMBOL", "SOURCE_CONNECT_RETRY_SYMBOL", 
      "SOURCE_DELAY_SYMBOL", "SOURCE_HEARTBEAT_PERIOD_SYMBOL", "SOURCE_HOST_SYMBOL", 
      "SOURCE_LOG_FILE_SYMBOL", "SOURCE_LOG_POS_SYMBOL", "SOURCE_PASSWORD_SYMBOL", 
      "SOURCE_PORT_SYMBOL", "SOURCE_PUBLIC_KEY_PATH_SYMBOL", "SOURCE_RETRY_COUNT_SYMBOL", 
      "SOURCE_SSL_SYMBOL", "SOURCE_SSL_CA_SYMBOL", "SOURCE_SSL_CAPATH_SYMBOL", 
      "SOURCE_SSL_CERT_SYMBOL", "SOURCE_SSL_CIPHER_SYMBOL", "SOURCE_SSL_CRL_SYMBOL", 
      "SOURCE_SSL_CRLPATH_SYMBOL", "SOURCE_SSL_KEY_SYMBOL", "SOURCE_SSL_VERIFY_SERVER_CERT_SYMBOL", 
      "SOURCE_TLS_CIPHERSUITES_SYMBOL", "SOURCE_TLS_VERSION_SYMBOL", "SOURCE_USER_SYMBOL", 
      "SOURCE_ZSTD_COMPRESSION_LEVEL_SYMBOL", "ST_COLLECT_SYMBOL", "KEYRING_SYMBOL", 
      "AUTHENTICATION_SYMBOL", "FACTOR_SYMBOL", "FINISH_SYMBOL", "INITIATE_SYMBOL", 
      "REGISTRATION_SYMBOL", "UNREGISTER_SYMBOL", "INITIAL_SYMBOL", "CHALLENGE_RESPONSE_SYMBOL", 
      "GTID_ONLY_SYMBOL", "INTERSECT_SYMBOL", "BULK_SYMBOL", "URL_SYMBOL", 
      "GENERATE_SYMBOL", "PARSE_TREE_SYMBOL", "LOG_SYMBOL", "GTIDS_SYMBOL", 
      "PARALLEL_SYMBOL", "S3_SYMBOL", "WHITESPACE", "INVALID_INPUT", "UNDERSCORE_CHARSET", 
      "IDENTIFIER", "NCHAR_TEXT", "BACK_TICK_QUOTED_ID", "DOUBLE_QUOTED_TEXT", 
      "SINGLE_QUOTED_TEXT", "DOLLAR_QUOTED_STRING_TEXT", "VERSION_COMMENT_START", 
      "MYSQL_COMMENT_START", "VERSION_COMMENT_END", "BLOCK_COMMENT", "INVALID_BLOCK_COMMENT", 
      "POUND_COMMENT", "DASHDASH_COMMENT", "SIMPLE_IDENTIFIER", "NOT_EQUAL2_OPERATOR"
    }
  );
  static const int32_t serializedATNSegment[] = {
  	4,1,846,9432,2,0,7,0,2,1,7,1,2,2,7,2,2,3,7,3,2,4,7,4,2,5,7,5,2,6,7,6,
  	2,7,7,7,2,8,7,8,2,9,7,9,2,10,7,10,2,11,7,11,2,12,7,12,2,13,7,13,2,14,
  	7,14,2,15,7,15,2,16,7,16,2,17,7,17,2,18,7,18,2,19,7,19,2,20,7,20,2,21,
  	7,21,2,22,7,22,2,23,7,23,2,24,7,24,2,25,7,25,2,26,7,26,2,27,7,27,2,28,
  	7,28,2,29,7,29,2,30,7,30,2,31,7,31,2,32,7,32,2,33,7,33,2,34,7,34,2,35,
  	7,35,2,36,7,36,2,37,7,37,2,38,7,38,2,39,7,39,2,40,7,40,2,41,7,41,2,42,
  	7,42,2,43,7,43,2,44,7,44,2,45,7,45,2,46,7,46,2,47,7,47,2,48,7,48,2,49,
  	7,49,2,50,7,50,2,51,7,51,2,52,7,52,2,53,7,53,2,54,7,54,2,55,7,55,2,56,
  	7,56,2,57,7,57,2,58,7,58,2,59,7,59,2,60,7,60,2,61,7,61,2,62,7,62,2,63,
  	7,63,2,64,7,64,2,65,7,65,2,66,7,66,2,67,7,67,2,68,7,68,2,69,7,69,2,70,
  	7,70,2,71,7,71,2,72,7,72,2,73,7,73,2,74,7,74,2,75,7,75,2,76,7,76,2,77,
  	7,77,2,78,7,78,2,79,7,79,2,80,7,80,2,81,7,81,2,82,7,82,2,83,7,83,2,84,
  	7,84,2,85,7,85,2,86,7,86,2,87,7,87,2,88,7,88,2,89,7,89,2,90,7,90,2,91,
  	7,91,2,92,7,92,2,93,7,93,2,94,7,94,2,95,7,95,2,96,7,96,2,97,7,97,2,98,
  	7,98,2,99,7,99,2,100,7,100,2,101,7,101,2,102,7,102,2,103,7,103,2,104,
  	7,104,2,105,7,105,2,106,7,106,2,107,7,107,2,108,7,108,2,109,7,109,2,110,
  	7,110,2,111,7,111,2,112,7,112,2,113,7,113,2,114,7,114,2,115,7,115,2,116,
  	7,116,2,117,7,117,2,118,7,118,2,119,7,119,2,120,7,120,2,121,7,121,2,122,
  	7,122,2,123,7,123,2,124,7,124,2,125,7,125,2,126,7,126,2,127,7,127,2,128,
  	7,128,2,129,7,129,2,130,7,130,2,131,7,131,2,132,7,132,2,133,7,133,2,134,
  	7,134,2,135,7,135,2,136,7,136,2,137,7,137,2,138,7,138,2,139,7,139,2,140,
  	7,140,2,141,7,141,2,142,7,142,2,143,7,143,2,144,7,144,2,145,7,145,2,146,
  	7,146,2,147,7,147,2,148,7,148,2,149,7,149,2,150,7,150,2,151,7,151,2,152,
  	7,152,2,153,7,153,2,154,7,154,2,155,7,155,2,156,7,156,2,157,7,157,2,158,
  	7,158,2,159,7,159,2,160,7,160,2,161,7,161,2,162,7,162,2,163,7,163,2,164,
  	7,164,2,165,7,165,2,166,7,166,2,167,7,167,2,168,7,168,2,169,7,169,2,170,
  	7,170,2,171,7,171,2,172,7,172,2,173,7,173,2,174,7,174,2,175,7,175,2,176,
  	7,176,2,177,7,177,2,178,7,178,2,179,7,179,2,180,7,180,2,181,7,181,2,182,
  	7,182,2,183,7,183,2,184,7,184,2,185,7,185,2,186,7,186,2,187,7,187,2,188,
  	7,188,2,189,7,189,2,190,7,190,2,191,7,191,2,192,7,192,2,193,7,193,2,194,
  	7,194,2,195,7,195,2,196,7,196,2,197,7,197,2,198,7,198,2,199,7,199,2,200,
  	7,200,2,201,7,201,2,202,7,202,2,203,7,203,2,204,7,204,2,205,7,205,2,206,
  	7,206,2,207,7,207,2,208,7,208,2,209,7,209,2,210,7,210,2,211,7,211,2,212,
  	7,212,2,213,7,213,2,214,7,214,2,215,7,215,2,216,7,216,2,217,7,217,2,218,
  	7,218,2,219,7,219,2,220,7,220,2,221,7,221,2,222,7,222,2,223,7,223,2,224,
  	7,224,2,225,7,225,2,226,7,226,2,227,7,227,2,228,7,228,2,229,7,229,2,230,
  	7,230,2,231,7,231,2,232,7,232,2,233,7,233,2,234,7,234,2,235,7,235,2,236,
  	7,236,2,237,7,237,2,238,7,238,2,239,7,239,2,240,7,240,2,241,7,241,2,242,
  	7,242,2,243,7,243,2,244,7,244,2,245,7,245,2,246,7,246,2,247,7,247,2,248,
  	7,248,2,249,7,249,2,250,7,250,2,251,7,251,2,252,7,252,2,253,7,253,2,254,
  	7,254,2,255,7,255,2,256,7,256,2,257,7,257,2,258,7,258,2,259,7,259,2,260,
  	7,260,2,261,7,261,2,262,7,262,2,263,7,263,2,264,7,264,2,265,7,265,2,266,
  	7,266,2,267,7,267,2,268,7,268,2,269,7,269,2,270,7,270,2,271,7,271,2,272,
  	7,272,2,273,7,273,2,274,7,274,2,275,7,275,2,276,7,276,2,277,7,277,2,278,
  	7,278,2,279,7,279,2,280,7,280,2,281,7,281,2,282,7,282,2,283,7,283,2,284,
  	7,284,2,285,7,285,2,286,7,286,2,287,7,287,2,288,7,288,2,289,7,289,2,290,
  	7,290,2,291,7,291,2,292,7,292,2,293,7,293,2,294,7,294,2,295,7,295,2,296,
  	7,296,2,297,7,297,2,298,7,298,2,299,7,299,2,300,7,300,2,301,7,301,2,302,
  	7,302,2,303,7,303,2,304,7,304,2,305,7,305,2,306,7,306,2,307,7,307,2,308,
  	7,308,2,309,7,309,2,310,7,310,2,311,7,311,2,312,7,312,2,313,7,313,2,314,
  	7,314,2,315,7,315,2,316,7,316,2,317,7,317,2,318,7,318,2,319,7,319,2,320,
  	7,320,2,321,7,321,2,322,7,322,2,323,7,323,2,324,7,324,2,325,7,325,2,326,
  	7,326,2,327,7,327,2,328,7,328,2,329,7,329,2,330,7,330,2,331,7,331,2,332,
  	7,332,2,333,7,333,2,334,7,334,2,335,7,335,2,336,7,336,2,337,7,337,2,338,
  	7,338,2,339,7,339,2,340,7,340,2,341,7,341,2,342,7,342,2,343,7,343,2,344,
  	7,344,2,345,7,345,2,346,7,346,2,347,7,347,2,348,7,348,2,349,7,349,2,350,
  	7,350,2,351,7,351,2,352,7,352,2,353,7,353,2,354,7,354,2,355,7,355,2,356,
  	7,356,2,357,7,357,2,358,7,358,2,359,7,359,2,360,7,360,2,361,7,361,2,362,
  	7,362,2,363,7,363,2,364,7,364,2,365,7,365,2,366,7,366,2,367,7,367,2,368,
  	7,368,2,369,7,369,2,370,7,370,2,371,7,371,2,372,7,372,2,373,7,373,2,374,
  	7,374,2,375,7,375,2,376,7,376,2,377,7,377,2,378,7,378,2,379,7,379,2,380,
  	7,380,2,381,7,381,2,382,7,382,2,383,7,383,2,384,7,384,2,385,7,385,2,386,
  	7,386,2,387,7,387,2,388,7,388,2,389,7,389,2,390,7,390,2,391,7,391,2,392,
  	7,392,2,393,7,393,2,394,7,394,2,395,7,395,2,396,7,396,2,397,7,397,2,398,
  	7,398,2,399,7,399,2,400,7,400,2,401,7,401,2,402,7,402,2,403,7,403,2,404,
  	7,404,2,405,7,405,2,406,7,406,2,407,7,407,2,408,7,408,2,409,7,409,2,410,
  	7,410,2,411,7,411,2,412,7,412,2,413,7,413,2,414,7,414,2,415,7,415,2,416,
  	7,416,2,417,7,417,2,418,7,418,2,419,7,419,2,420,7,420,2,421,7,421,2,422,
  	7,422,2,423,7,423,2,424,7,424,2,425,7,425,2,426,7,426,2,427,7,427,2,428,
  	7,428,2,429,7,429,2,430,7,430,2,431,7,431,2,432,7,432,2,433,7,433,2,434,
  	7,434,2,435,7,435,2,436,7,436,2,437,7,437,2,438,7,438,2,439,7,439,2,440,
  	7,440,2,441,7,441,2,442,7,442,2,443,7,443,2,444,7,444,2,445,7,445,2,446,
  	7,446,2,447,7,447,2,448,7,448,2,449,7,449,2,450,7,450,2,451,7,451,2,452,
  	7,452,2,453,7,453,2,454,7,454,2,455,7,455,2,456,7,456,2,457,7,457,2,458,
  	7,458,2,459,7,459,2,460,7,460,2,461,7,461,2,462,7,462,2,463,7,463,2,464,
  	7,464,2,465,7,465,2,466,7,466,2,467,7,467,2,468,7,468,2,469,7,469,2,470,
  	7,470,2,471,7,471,2,472,7,472,2,473,7,473,2,474,7,474,2,475,7,475,2,476,
  	7,476,2,477,7,477,2,478,7,478,2,479,7,479,2,480,7,480,2,481,7,481,2,482,
  	7,482,2,483,7,483,2,484,7,484,2,485,7,485,2,486,7,486,2,487,7,487,2,488,
  	7,488,2,489,7,489,2,490,7,490,2,491,7,491,2,492,7,492,2,493,7,493,2,494,
  	7,494,2,495,7,495,2,496,7,496,2,497,7,497,2,498,7,498,2,499,7,499,2,500,
  	7,500,2,501,7,501,2,502,7,502,2,503,7,503,2,504,7,504,2,505,7,505,2,506,
  	7,506,2,507,7,507,2,508,7,508,2,509,7,509,2,510,7,510,2,511,7,511,2,512,
  	7,512,2,513,7,513,2,514,7,514,2,515,7,515,2,516,7,516,2,517,7,517,2,518,
  	7,518,2,519,7,519,2,520,7,520,2,521,7,521,2,522,7,522,2,523,7,523,2,524,
  	7,524,2,525,7,525,2,526,7,526,2,527,7,527,2,528,7,528,2,529,7,529,2,530,
  	7,530,2,531,7,531,2,532,7,532,2,533,7,533,2,534,7,534,2,535,7,535,2,536,
  	7,536,2,537,7,537,2,538,7,538,2,539,7,539,2,540,7,540,2,541,7,541,2,542,
  	7,542,2,543,7,543,2,544,7,544,2,545,7,545,2,546,7,546,2,547,7,547,2,548,
  	7,548,2,549,7,549,2,550,7,550,2,551,7,551,2,552,7,552,2,553,7,553,2,554,
  	7,554,2,555,7,555,2,556,7,556,2,557,7,557,2,558,7,558,2,559,7,559,2,560,
  	7,560,2,561,7,561,2,562,7,562,2,563,7,563,2,564,7,564,2,565,7,565,2,566,
  	7,566,2,567,7,567,2,568,7,568,2,569,7,569,2,570,7,570,2,571,7,571,2,572,
  	7,572,2,573,7,573,2,574,7,574,2,575,7,575,2,576,7,576,2,577,7,577,2,578,
  	7,578,2,579,7,579,2,580,7,580,2,581,7,581,2,582,7,582,2,583,7,583,2,584,
  	7,584,2,585,7,585,2,586,7,586,2,587,7,587,2,588,7,588,2,589,7,589,2,590,
  	7,590,2,591,7,591,2,592,7,592,2,593,7,593,2,594,7,594,2,595,7,595,2,596,
  	7,596,2,597,7,597,2,598,7,598,2,599,7,599,2,600,7,600,2,601,7,601,2,602,
  	7,602,2,603,7,603,2,604,7,604,2,605,7,605,2,606,7,606,2,607,7,607,2,608,
  	7,608,2,609,7,609,2,610,7,610,2,611,7,611,2,612,7,612,2,613,7,613,2,614,
  	7,614,2,615,7,615,2,616,7,616,2,617,7,617,2,618,7,618,2,619,7,619,2,620,
  	7,620,2,621,7,621,2,622,7,622,2,623,7,623,2,624,7,624,2,625,7,625,2,626,
  	7,626,2,627,7,627,2,628,7,628,2,629,7,629,2,630,7,630,2,631,7,631,2,632,
  	7,632,2,633,7,633,2,634,7,634,2,635,7,635,2,636,7,636,2,637,7,637,2,638,
  	7,638,2,639,7,639,2,640,7,640,2,641,7,641,2,642,7,642,2,643,7,643,2,644,
  	7,644,2,645,7,645,2,646,7,646,2,647,7,647,2,648,7,648,2,649,7,649,2,650,
  	7,650,2,651,7,651,2,652,7,652,2,653,7,653,2,654,7,654,2,655,7,655,2,656,
  	7,656,2,657,7,657,2,658,7,658,2,659,7,659,2,660,7,660,2,661,7,661,2,662,
  	7,662,2,663,7,663,2,664,7,664,2,665,7,665,2,666,7,666,2,667,7,667,2,668,
  	7,668,2,669,7,669,2,670,7,670,2,671,7,671,2,672,7,672,2,673,7,673,2,674,
  	7,674,2,675,7,675,2,676,7,676,2,677,7,677,2,678,7,678,2,679,7,679,2,680,
  	7,680,2,681,7,681,2,682,7,682,2,683,7,683,2,684,7,684,2,685,7,685,2,686,
  	7,686,2,687,7,687,2,688,7,688,2,689,7,689,2,690,7,690,2,691,7,691,2,692,
  	7,692,2,693,7,693,2,694,7,694,2,695,7,695,2,696,7,696,2,697,7,697,2,698,
  	7,698,2,699,7,699,2,700,7,700,2,701,7,701,2,702,7,702,2,703,7,703,2,704,
  	7,704,2,705,7,705,2,706,7,706,2,707,7,707,2,708,7,708,2,709,7,709,2,710,
  	7,710,2,711,7,711,2,712,7,712,2,713,7,713,2,714,7,714,2,715,7,715,2,716,
  	7,716,2,717,7,717,2,718,7,718,2,719,7,719,2,720,7,720,2,721,7,721,2,722,
  	7,722,2,723,7,723,2,724,7,724,2,725,7,725,2,726,7,726,2,727,7,727,2,728,
  	7,728,2,729,7,729,2,730,7,730,2,731,7,731,2,732,7,732,2,733,7,733,2,734,
  	7,734,2,735,7,735,2,736,7,736,2,737,7,737,2,738,7,738,2,739,7,739,2,740,
  	7,740,2,741,7,741,2,742,7,742,2,743,7,743,2,744,7,744,2,745,7,745,1,0,
  	1,0,3,0,1495,8,0,1,0,3,0,1498,8,0,3,0,1500,8,0,1,0,1,0,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1584,8,1,1,2,1,2,1,2,1,2,1,2,1,2,3,2,1592,
  	8,2,1,2,1,2,1,2,3,2,1597,8,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,3,2,1607,
  	8,2,1,3,1,3,1,3,4,3,1612,8,3,11,3,12,3,1613,1,3,1,3,1,3,1,3,1,3,3,3,1621,
  	8,3,1,4,1,4,1,4,1,4,3,4,1627,8,4,1,4,3,4,1630,8,4,1,5,3,5,1633,8,5,1,
  	5,1,5,1,5,1,5,1,5,3,5,1640,8,5,1,5,1,5,1,5,3,5,1645,8,5,1,5,3,5,1648,
  	8,5,1,5,1,5,1,5,3,5,1653,8,5,1,5,1,5,1,5,1,5,3,5,1659,8,5,3,5,1661,8,
  	5,1,5,1,5,3,5,1665,8,5,1,5,1,5,3,5,1669,8,5,1,6,1,6,1,6,1,6,1,6,1,6,1,
  	6,3,6,1678,8,6,1,7,1,7,3,7,1682,8,7,1,7,5,7,1685,8,7,10,7,12,7,1688,9,
  	7,1,8,1,8,1,8,3,8,1693,8,8,1,9,1,9,1,9,1,9,1,10,3,10,1700,8,10,1,10,1,
  	10,1,10,3,10,1705,8,10,1,11,1,11,1,11,3,11,1710,8,11,1,11,1,11,1,11,1,
  	11,1,11,3,11,1717,8,11,1,11,3,11,1720,8,11,1,12,1,12,1,12,1,12,3,12,1726,
  	8,12,1,12,3,12,1729,8,12,1,13,1,13,1,13,5,13,1734,8,13,10,13,12,13,1737,
  	9,13,1,14,1,14,1,14,1,14,1,14,1,14,1,14,3,14,1746,8,14,1,15,1,15,1,15,
  	3,15,1751,8,15,1,15,1,15,1,15,3,15,1756,8,15,1,15,1,15,1,15,1,15,1,15,
  	1,15,3,15,1764,8,15,1,15,1,15,1,15,1,15,3,15,1770,8,15,1,15,1,15,3,15,
  	1774,8,15,1,15,1,15,1,15,3,15,1779,8,15,1,15,1,15,1,15,1,15,1,15,5,15,
  	1786,8,15,10,15,12,15,1789,9,15,1,15,1,15,1,15,3,15,1794,8,15,1,15,1,
  	15,5,15,1798,8,15,10,15,12,15,1801,9,15,1,15,1,15,1,15,3,15,1806,8,15,
  	1,15,1,15,1,15,1,15,1,15,1,15,1,15,3,15,1815,8,15,1,15,1,15,1,15,1,15,
  	3,15,1821,8,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,3,15,1830,8,15,1,15,
  	1,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,1,15,3,15,1844,8,15,
  	1,16,1,16,3,16,1848,8,16,1,16,1,16,1,16,1,16,3,16,1854,8,16,5,16,1856,
  	8,16,10,16,12,16,1859,9,16,1,17,1,17,1,17,3,17,1864,8,17,1,18,1,18,3,
  	18,1868,8,18,1,18,1,18,1,18,3,18,1873,8,18,1,18,3,18,1876,8,18,1,18,1,
  	18,1,18,1,18,3,18,1882,8,18,1,18,1,18,1,18,1,18,3,18,1888,8,18,1,18,1,
  	18,1,18,1,18,3,18,1894,8,18,1,18,1,18,3,18,1898,8,18,1,18,1,18,1,18,3,
  	18,1903,8,18,1,18,1,18,3,18,1907,8,18,1,18,1,18,3,18,1911,8,18,1,18,1,
  	18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,3,18,1927,
  	8,18,1,18,1,18,1,18,1,18,1,18,1,18,3,18,1935,8,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,3,18,1943,8,18,1,18,1,18,1,18,1,18,1,18,3,18,1950,8,18,1,18,
  	1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,3,18,1979,
  	8,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	3,18,1994,8,18,1,18,3,18,1997,8,18,1,18,1,18,1,18,1,18,1,18,1,18,1,18,
  	3,18,2006,8,18,1,19,1,19,1,19,3,19,2011,8,19,1,20,1,20,1,21,1,21,3,21,
  	2017,8,21,1,21,1,21,1,21,3,21,2022,8,21,5,21,2024,8,21,10,21,12,21,2027,
  	9,21,1,22,1,22,3,22,2031,8,22,1,22,1,22,3,22,2035,8,22,1,23,1,23,3,23,
  	2039,8,23,1,23,1,23,3,23,2043,8,23,1,24,1,24,3,24,2047,8,24,1,24,1,24,
  	3,24,2051,8,24,3,24,2053,8,24,1,25,1,25,1,25,1,25,1,26,1,26,1,26,1,27,
  	1,27,3,27,2064,8,27,1,28,1,28,1,28,1,28,1,28,1,28,3,28,2072,8,28,1,28,
  	1,28,1,28,1,28,1,28,3,28,2079,8,28,1,29,1,29,1,29,1,29,1,29,1,29,3,29,
  	2087,8,29,1,30,1,30,3,30,2091,8,30,1,30,5,30,2094,8,30,10,30,12,30,2097,
  	9,30,1,31,1,31,1,32,1,32,3,32,2103,8,32,1,32,5,32,2106,8,32,10,32,12,
  	32,2109,9,32,1,33,1,33,3,33,2113,8,33,1,33,1,33,1,33,1,33,1,33,1,33,1,
  	33,1,33,3,33,2123,8,33,1,34,1,34,3,34,2127,8,34,1,34,1,34,1,34,3,34,2132,
  	8,34,1,35,3,35,2135,8,35,1,35,3,35,2138,8,35,1,35,3,35,2141,8,35,1,35,
  	1,35,1,35,1,35,1,36,3,36,2148,8,36,1,36,1,36,1,36,1,37,1,37,3,37,2155,
  	8,37,1,38,1,38,3,38,2159,8,38,1,38,1,38,1,38,1,39,1,39,1,39,1,39,1,39,
  	1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,3,39,2178,8,39,1,39,1,39,
  	1,39,1,39,3,39,2184,8,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,1,39,3,39,
  	2194,8,39,1,39,3,39,2197,8,39,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,
  	1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,1,40,3,40,2218,8,40,
  	1,41,1,41,3,41,2222,8,41,1,41,1,41,5,41,2226,8,41,10,41,12,41,2229,9,
  	41,1,42,1,42,1,42,1,42,3,42,2235,8,42,1,43,3,43,2238,8,43,1,43,1,43,3,
  	43,2242,8,43,1,43,1,43,1,43,1,43,1,43,3,43,2249,8,43,1,43,3,43,2252,8,
  	43,1,43,1,43,1,43,1,43,1,43,1,43,1,43,3,43,2261,8,43,1,44,1,44,1,44,5,
  	44,2266,8,44,10,44,12,44,2269,9,44,1,45,1,45,3,45,2273,8,45,1,46,3,46,
  	2276,8,46,1,46,1,46,1,47,3,47,2281,8,47,1,47,1,47,1,48,1,48,3,48,2287,
  	8,48,1,48,3,48,2290,8,48,1,49,1,49,3,49,2294,8,49,1,50,1,50,1,50,1,50,
  	3,50,2300,8,50,1,50,3,50,2303,8,50,1,50,1,50,1,51,3,51,2308,8,51,1,51,
  	1,51,1,51,3,51,2313,8,51,1,51,1,51,1,51,1,51,1,51,5,51,2320,8,51,10,51,
  	12,51,2323,9,51,3,51,2325,8,51,1,51,1,51,5,51,2329,8,51,10,51,12,51,2332,
  	9,51,1,51,1,51,1,52,1,52,3,52,2338,8,52,1,53,1,53,1,53,1,53,3,53,2344,
  	8,53,1,54,3,54,2347,8,54,1,54,1,54,1,54,3,54,2352,8,54,1,54,1,54,1,54,
  	1,54,1,54,5,54,2359,8,54,10,54,12,54,2362,9,54,3,54,2364,8,54,1,54,1,
  	54,1,54,1,54,5,54,2370,8,54,10,54,12,54,2373,9,54,1,54,1,54,1,55,3,55,
  	2378,8,55,1,55,1,55,1,55,3,55,2383,8,55,1,55,1,55,1,55,1,55,1,55,1,55,
  	1,56,1,56,3,56,2393,8,56,1,56,3,56,2396,8,56,1,57,4,57,2399,8,57,11,57,
  	12,57,2400,1,58,1,58,1,58,1,58,1,58,1,58,3,58,2409,8,58,1,58,1,58,1,58,
  	1,58,1,58,1,58,1,58,1,58,1,58,1,58,1,58,1,58,1,58,3,58,2424,8,58,1,59,
  	3,59,2427,8,59,1,59,3,59,2430,8,59,1,59,1,59,1,59,3,59,2435,8,59,1,59,
  	1,59,5,59,2439,8,59,10,59,12,59,2442,9,59,1,59,1,59,1,59,1,59,1,59,5,
  	59,2449,8,59,10,59,12,59,2452,9,59,1,59,1,59,1,59,1,59,1,59,5,59,2459,
  	8,59,10,59,12,59,2462,9,59,3,59,2464,8,59,1,59,3,59,2467,8,59,1,60,1,
  	60,3,60,2471,8,60,1,60,1,60,1,60,1,60,1,60,1,60,3,60,2479,8,60,1,61,1,
  	61,1,61,1,61,1,62,1,62,1,62,1,62,1,62,1,62,1,62,3,62,2492,8,62,1,63,1,
  	63,3,63,2496,8,63,1,63,5,63,2499,8,63,10,63,12,63,2502,9,63,1,64,1,64,
  	1,64,1,64,1,64,1,64,3,64,2510,8,64,1,65,1,65,1,65,1,65,1,65,1,65,1,65,
  	1,65,1,66,1,66,1,66,1,66,1,66,5,66,2525,8,66,10,66,12,66,2528,9,66,1,
  	66,1,66,1,67,1,67,1,67,1,67,1,67,1,67,1,67,1,67,1,67,1,67,1,67,1,67,1,
  	67,1,67,3,67,2546,8,67,1,68,1,68,1,68,1,68,1,68,1,68,1,68,3,68,2555,8,
  	68,1,68,3,68,2558,8,68,1,69,1,69,1,69,1,69,1,69,1,69,3,69,2566,8,69,1,
  	70,1,70,1,70,1,70,1,70,3,70,2573,8,70,3,70,2575,8,70,1,71,1,71,1,71,1,
  	72,1,72,3,72,2582,8,72,1,72,5,72,2585,8,72,10,72,12,72,2588,9,72,1,73,
  	1,73,1,73,1,73,1,73,1,73,1,73,1,73,1,73,1,73,1,73,1,73,3,73,2602,8,73,
  	1,74,1,74,3,74,2606,8,74,1,74,1,74,1,75,1,75,3,75,2612,8,75,1,75,1,75,
  	1,76,1,76,3,76,2618,8,76,1,76,1,76,1,77,1,77,3,77,2624,8,77,1,77,1,77,
  	1,78,1,78,3,78,2630,8,78,1,78,1,78,1,79,1,79,3,79,2636,8,79,1,79,1,79,
  	1,80,3,80,2641,8,80,1,80,1,80,3,80,2645,8,80,1,80,1,80,1,81,1,81,1,82,
  	1,82,3,82,2653,8,82,1,82,1,82,1,83,1,83,3,83,2659,8,83,1,83,1,83,1,84,
  	1,84,3,84,2665,8,84,1,84,1,84,1,85,1,85,3,85,2671,8,85,1,85,1,85,1,86,
  	3,86,2676,8,86,1,86,3,86,2679,8,86,1,86,3,86,2682,8,86,1,86,1,86,1,86,
  	1,86,1,87,1,87,1,87,3,87,2691,8,87,1,87,3,87,2694,8,87,1,88,1,88,1,88,
  	1,88,1,89,1,89,1,89,1,89,1,90,3,90,2705,8,90,1,90,1,90,1,90,3,90,2710,
  	8,90,1,90,1,90,1,90,1,90,1,90,1,90,1,90,1,90,1,90,3,90,2721,8,90,1,90,
  	1,90,1,91,1,91,1,91,1,92,3,92,2729,8,92,1,92,1,92,3,92,2733,8,92,1,92,
  	1,92,1,92,1,92,1,92,1,92,1,92,3,92,2742,8,92,1,92,3,92,2745,8,92,1,92,
  	1,92,1,92,1,92,3,92,2751,8,92,3,92,2753,8,92,1,92,1,92,3,92,2757,8,92,
  	1,92,1,92,1,92,1,93,1,93,3,93,2764,8,93,1,93,1,93,1,94,1,94,1,94,1,94,
  	1,94,1,94,1,94,5,94,2775,8,94,10,94,12,94,2778,9,94,1,94,1,94,1,94,1,
  	94,3,94,2784,8,94,1,94,1,94,5,94,2788,8,94,10,94,12,94,2791,9,94,3,94,
  	2793,8,94,1,95,1,95,1,95,1,95,1,95,1,95,1,95,1,95,1,95,1,95,1,95,1,95,
  	1,95,1,95,1,95,3,95,2810,8,95,1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,
  	1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,1,96,3,96,2830,8,96,1,97,
  	1,97,3,97,2834,8,97,1,97,1,97,1,98,1,98,3,98,2840,8,98,1,98,1,98,1,99,
  	1,99,3,99,2846,8,99,1,99,1,99,1,100,1,100,3,100,2852,8,100,1,100,1,100,
  	1,101,3,101,2857,8,101,1,101,1,101,1,101,1,101,1,101,3,101,2864,8,101,
  	1,102,1,102,1,102,1,102,1,102,3,102,2871,8,102,1,102,5,102,2874,8,102,
  	10,102,12,102,2877,9,102,3,102,2879,8,102,1,103,1,103,3,103,2883,8,103,
  	1,104,1,104,3,104,2887,8,104,1,104,1,104,1,105,3,105,2892,8,105,1,105,
  	1,105,3,105,2896,8,105,1,105,1,105,3,105,2900,8,105,1,106,1,106,1,106,
  	1,106,3,106,2906,8,106,1,106,5,106,2909,8,106,10,106,12,106,2912,9,106,
  	3,106,2914,8,106,1,107,1,107,3,107,2918,8,107,1,107,1,107,1,108,1,108,
  	3,108,2924,8,108,1,108,1,108,3,108,2928,8,108,1,109,1,109,3,109,2932,
  	8,109,1,109,1,109,1,110,1,110,1,110,1,110,3,110,2940,8,110,1,110,1,110,
  	1,111,1,111,1,111,1,111,3,111,2948,8,111,1,112,1,112,1,112,1,112,1,112,
  	5,112,2955,8,112,10,112,12,112,2958,9,112,1,113,1,113,1,113,1,113,1,114,
  	1,114,3,114,2966,8,114,1,114,1,114,1,115,1,115,1,115,1,115,1,115,1,116,
  	1,116,1,116,1,116,3,116,2979,8,116,1,116,3,116,2982,8,116,1,117,1,117,
  	3,117,2986,8,117,1,117,1,117,5,117,2990,8,117,10,117,12,117,2993,9,117,
  	1,117,1,117,1,117,1,117,1,117,3,117,3000,8,117,1,117,1,117,1,117,3,117,
  	3005,8,117,1,117,3,117,3008,8,117,1,117,3,117,3011,8,117,1,117,3,117,
  	3014,8,117,1,117,3,117,3017,8,117,3,117,3019,8,117,1,117,1,117,1,117,
  	1,117,3,117,3025,8,117,3,117,3027,8,117,1,118,1,118,1,118,1,118,1,118,
  	1,119,1,119,1,120,1,120,1,120,1,120,1,120,3,120,3041,8,120,1,121,1,121,
  	1,121,1,121,3,121,3047,8,121,1,121,1,121,1,121,1,121,1,121,3,121,3054,
  	8,121,1,121,3,121,3057,8,121,3,121,3059,8,121,3,121,3061,8,121,1,122,
  	1,122,1,122,1,122,1,122,1,122,1,122,1,122,3,122,3071,8,122,3,122,3073,
  	8,122,1,123,1,123,3,123,3077,8,123,1,123,3,123,3080,8,123,1,123,3,123,
  	3083,8,123,1,123,1,123,3,123,3087,8,123,1,123,1,123,3,123,3091,8,123,
  	1,123,1,123,1,123,3,123,3096,8,123,1,123,3,123,3099,8,123,1,123,3,123,
  	3102,8,123,1,124,1,124,1,125,1,125,3,125,3108,8,125,1,125,3,125,3111,
  	8,125,1,125,1,125,1,126,1,126,1,126,5,126,3118,8,126,10,126,12,126,3121,
  	9,126,1,127,1,127,1,127,1,128,1,128,1,128,1,128,3,128,3130,8,128,1,128,
  	3,128,3133,8,128,1,128,3,128,3136,8,128,1,129,1,129,3,129,3140,8,129,
  	1,129,1,129,1,129,1,129,3,129,3146,8,129,1,129,5,129,3149,8,129,10,129,
  	12,129,3152,9,129,1,130,1,130,3,130,3156,8,130,1,130,1,130,1,130,3,130,
  	3161,8,130,5,130,3163,8,130,10,130,12,130,3166,9,130,1,131,1,131,1,131,
  	1,131,3,131,3172,8,131,1,132,1,132,1,132,1,132,1,132,1,132,1,133,1,133,
  	1,133,3,133,3183,8,133,1,133,3,133,3186,8,133,1,133,3,133,3189,8,133,
  	1,133,3,133,3192,8,133,1,133,1,133,3,133,3196,8,133,1,133,3,133,3199,
  	8,133,1,133,3,133,3202,8,133,1,133,1,133,1,133,1,133,3,133,3208,8,133,
  	1,133,3,133,3211,8,133,1,133,3,133,3214,8,133,1,133,3,133,3217,8,133,
  	1,133,3,133,3220,8,133,1,133,1,133,3,133,3224,8,133,1,133,3,133,3227,
  	8,133,1,133,3,133,3230,8,133,1,134,1,134,1,135,1,135,1,136,1,136,1,136,
  	1,137,1,137,1,137,3,137,3242,8,137,1,138,1,138,1,138,1,138,1,138,1,138,
  	3,138,3250,8,138,1,139,1,139,1,139,1,139,1,139,1,139,1,140,1,140,1,140,
  	1,140,1,140,1,141,1,141,1,141,3,141,3266,8,141,1,141,3,141,3269,8,141,
  	1,141,1,141,3,141,3273,8,141,1,142,1,142,3,142,3277,8,142,1,142,1,142,
  	1,143,1,143,3,143,3283,8,143,1,143,1,143,1,143,3,143,3288,8,143,5,143,
  	3290,8,143,10,143,12,143,3293,9,143,1,144,1,144,1,144,1,144,1,144,1,145,
  	1,145,1,145,1,145,1,145,1,146,1,146,1,146,1,146,1,146,1,147,1,147,3,147,
  	3312,8,147,1,147,3,147,3315,8,147,1,147,1,147,3,147,3319,8,147,1,147,
  	1,147,1,147,1,147,3,147,3325,8,147,1,148,1,148,3,148,3329,8,148,1,148,
  	3,148,3332,8,148,1,149,1,149,1,149,1,149,1,149,1,149,1,149,3,149,3341,
  	8,149,1,149,1,149,1,149,1,149,1,149,1,149,1,149,1,149,3,149,3351,8,149,
  	1,150,1,150,3,150,3355,8,150,1,150,1,150,3,150,3359,8,150,1,150,3,150,
  	3362,8,150,1,150,1,150,3,150,3366,8,150,1,151,1,151,3,151,3370,8,151,
  	1,151,1,151,1,151,3,151,3375,8,151,1,151,3,151,3378,8,151,1,151,5,151,
  	3381,8,151,10,151,12,151,3384,9,151,1,152,1,152,1,152,3,152,3389,8,152,
  	1,152,1,152,1,153,1,153,1,153,1,153,1,153,3,153,3398,8,153,1,154,1,154,
  	5,154,3402,8,154,10,154,12,154,3405,9,154,1,154,1,154,3,154,3409,8,154,
  	1,154,3,154,3412,8,154,1,154,3,154,3415,8,154,1,154,3,154,3418,8,154,
  	1,154,3,154,3421,8,154,1,154,1,154,3,154,3425,8,154,1,155,1,155,1,156,
  	1,156,1,157,1,157,1,157,1,158,1,158,1,158,1,159,1,159,1,159,3,159,3440,
  	8,159,1,160,1,160,3,160,3444,8,160,1,161,1,161,1,161,1,161,3,161,3450,
  	8,161,1,161,3,161,3453,8,161,1,161,3,161,3456,8,161,1,161,1,161,1,161,
  	1,161,3,161,3462,8,161,1,161,1,161,1,161,3,161,3467,8,161,5,161,3469,
  	8,161,10,161,12,161,3472,9,161,3,161,3474,8,161,1,162,1,162,1,162,1,162,
  	1,162,1,162,3,162,3482,8,162,3,162,3484,8,162,1,162,1,162,1,163,1,163,
  	1,163,1,164,1,164,1,164,1,164,5,164,3495,8,164,10,164,12,164,3498,9,164,
  	1,165,1,165,1,165,1,165,1,166,1,166,1,166,1,166,1,167,3,167,3509,8,167,
  	1,167,1,167,1,167,3,167,3514,8,167,1,167,3,167,3517,8,167,1,167,3,167,
  	3520,8,167,1,168,1,168,1,168,3,168,3525,8,168,1,169,1,169,1,170,1,170,
  	3,170,3531,8,170,1,171,1,171,1,171,1,171,1,171,1,171,1,171,1,171,1,171,
  	1,171,1,171,1,171,1,171,1,171,3,171,3547,8,171,1,172,1,172,1,172,1,172,
  	1,172,1,173,1,173,1,173,1,173,1,173,1,173,1,173,1,173,1,173,1,173,1,173,
  	1,173,1,173,3,173,3567,8,173,1,174,1,174,1,174,1,174,1,174,1,174,1,174,
  	3,174,3576,8,174,1,175,1,175,3,175,3580,8,175,1,175,1,175,1,175,5,175,
  	3585,8,175,10,175,12,175,3588,9,175,1,176,1,176,3,176,3592,8,176,1,176,
  	1,176,1,176,1,177,1,177,1,177,1,177,3,177,3601,8,177,1,177,1,177,1,177,
  	1,177,1,177,1,177,1,177,1,177,3,177,3611,8,177,1,178,1,178,1,178,1,178,
  	1,178,3,178,3618,8,178,1,179,1,179,1,179,1,179,1,180,1,180,1,181,1,181,
  	1,181,3,181,3629,8,181,1,182,1,182,1,182,5,182,3634,8,182,10,182,12,182,
  	3637,9,182,1,183,1,183,1,183,1,183,5,183,3643,8,183,10,183,12,183,3646,
  	9,183,1,184,1,184,1,184,1,185,1,185,1,185,3,185,3654,8,185,1,185,1,185,
  	1,186,1,186,1,186,1,186,1,186,1,186,1,186,1,186,3,186,3666,8,186,1,187,
  	1,187,4,187,3670,8,187,11,187,12,187,3671,1,188,1,188,1,188,1,188,1,188,
  	3,188,3679,8,188,1,188,1,188,3,188,3683,8,188,1,188,1,188,1,188,1,188,
  	3,188,3689,8,188,1,189,1,189,1,189,3,189,3694,8,189,1,190,1,190,1,190,
  	3,190,3699,8,190,1,191,1,191,3,191,3703,8,191,1,191,1,191,5,191,3707,
  	8,191,10,191,12,191,3710,9,191,1,192,1,192,1,192,3,192,3715,8,192,3,192,
  	3717,8,192,1,193,3,193,3720,8,193,1,193,1,193,3,193,3724,8,193,1,194,
  	1,194,1,194,1,195,1,195,1,195,1,195,1,195,3,195,3734,8,195,1,195,1,195,
  	1,195,3,195,3739,8,195,1,195,5,195,3742,8,195,10,195,12,195,3745,9,195,
  	1,196,1,196,5,196,3749,8,196,10,196,12,196,3752,9,196,1,197,1,197,1,197,
  	1,197,1,197,1,197,3,197,3760,8,197,1,197,1,197,1,197,1,197,1,197,1,197,
  	3,197,3768,8,197,1,197,1,197,1,197,3,197,3773,8,197,1,198,1,198,3,198,
  	3777,8,198,1,198,1,198,1,198,1,198,3,198,3783,8,198,1,198,3,198,3786,
  	8,198,1,199,3,199,3789,8,199,1,199,1,199,3,199,3793,8,199,1,200,1,200,
  	3,200,3797,8,200,1,200,1,200,1,201,1,201,1,201,1,201,1,201,1,201,3,201,
  	3807,8,201,1,202,1,202,3,202,3811,8,202,1,202,3,202,3814,8,202,1,202,
  	3,202,3817,8,202,1,203,1,203,1,203,3,203,3822,8,203,1,203,1,203,1,204,
  	1,204,3,204,3828,8,204,1,204,1,204,3,204,3832,8,204,1,204,1,204,1,204,
  	1,204,3,204,3838,8,204,1,204,3,204,3841,8,204,3,204,3843,8,204,1,205,
  	1,205,1,205,3,205,3848,8,205,1,205,1,205,1,206,1,206,1,206,1,206,1,206,
  	1,206,1,206,1,206,3,206,3860,8,206,1,207,1,207,1,207,1,207,1,207,5,207,
  	3867,8,207,10,207,12,207,3870,9,207,1,207,1,207,1,208,1,208,1,208,1,208,
  	1,208,1,208,1,208,1,208,3,208,3882,8,208,1,208,3,208,3885,8,208,1,208,
  	1,208,1,208,3,208,3890,8,208,1,208,1,208,1,208,1,208,1,208,3,208,3897,
  	8,208,1,209,1,209,3,209,3901,8,209,1,209,3,209,3904,8,209,1,210,1,210,
  	1,210,1,210,3,210,3910,8,210,1,211,1,211,1,211,1,211,1,212,1,212,1,212,
  	1,212,1,213,1,213,1,213,1,213,3,213,3924,8,213,1,214,1,214,1,215,1,215,
  	1,215,3,215,3931,8,215,1,215,1,215,1,216,1,216,1,216,5,216,3938,8,216,
  	10,216,12,216,3941,9,216,1,217,1,217,1,217,3,217,3946,8,217,1,217,1,217,
  	1,217,1,217,1,217,1,217,1,217,3,217,3955,8,217,1,217,1,217,3,217,3959,
  	8,217,1,217,1,217,3,217,3963,8,217,1,218,1,218,1,219,1,219,1,220,1,220,
  	1,220,1,220,3,220,3973,8,220,3,220,3975,8,220,1,221,1,221,1,221,1,221,
  	1,221,1,221,3,221,3983,8,221,1,222,1,222,1,222,5,222,3988,8,222,10,222,
  	12,222,3991,9,222,1,223,1,223,3,223,3995,8,223,1,224,1,224,3,224,3999,
  	8,224,1,224,1,224,3,224,4003,8,224,1,224,3,224,4006,8,224,1,224,1,224,
  	1,224,1,224,3,224,4012,8,224,1,224,3,224,4015,8,224,1,224,3,224,4018,
  	8,224,1,225,1,225,1,225,1,225,3,225,4024,8,225,1,226,1,226,1,226,5,226,
  	4029,8,226,10,226,12,226,4032,9,226,1,226,1,226,3,226,4036,8,226,1,226,
  	1,226,3,226,4040,8,226,1,226,3,226,4043,8,226,1,226,3,226,4046,8,226,
  	1,226,3,226,4049,8,226,3,226,4051,8,226,1,227,1,227,3,227,4055,8,227,
  	1,228,1,228,1,228,1,228,1,228,3,228,4062,8,228,1,229,1,229,1,229,1,229,
  	3,229,4068,8,229,1,229,1,229,3,229,4072,8,229,1,229,1,229,1,229,3,229,
  	4077,8,229,1,229,3,229,4080,8,229,1,229,3,229,4083,8,229,1,229,3,229,
  	4086,8,229,3,229,4088,8,229,1,229,1,229,1,229,3,229,4093,8,229,1,230,
  	1,230,1,230,1,230,1,230,5,230,4100,8,230,10,230,12,230,4103,9,230,1,230,
  	1,230,1,230,1,230,1,230,1,230,1,230,1,230,1,230,1,230,3,230,4115,8,230,
  	3,230,4117,8,230,1,231,1,231,3,231,4121,8,231,1,231,1,231,1,232,1,232,
  	3,232,4127,8,232,1,232,3,232,4130,8,232,1,232,3,232,4133,8,232,1,233,
  	1,233,1,233,1,233,3,233,4139,8,233,1,233,1,233,1,233,1,233,1,233,3,233,
  	4146,8,233,3,233,4148,8,233,1,233,1,233,1,233,1,233,1,233,1,233,3,233,
  	4156,8,233,1,233,1,233,1,233,1,233,3,233,4162,8,233,1,234,1,234,1,234,
  	3,234,4167,8,234,1,234,3,234,4170,8,234,1,235,1,235,1,235,1,235,1,235,
  	3,235,4177,8,235,3,235,4179,8,235,1,236,1,236,1,236,1,236,1,236,1,236,
  	1,236,5,236,4188,8,236,10,236,12,236,4191,9,236,1,236,1,236,1,236,1,236,
  	3,236,4197,8,236,1,236,1,236,1,236,1,236,1,236,1,236,3,236,4205,8,236,
  	1,237,1,237,1,237,1,237,1,237,1,237,3,237,4213,8,237,1,238,1,238,3,238,
  	4217,8,238,1,238,1,238,1,238,1,238,1,238,3,238,4224,8,238,1,238,3,238,
  	4227,8,238,3,238,4229,8,238,1,239,1,239,1,239,1,239,1,239,1,239,3,239,
  	4237,8,239,1,240,1,240,1,240,1,240,1,241,1,241,1,241,1,241,3,241,4247,
  	8,241,1,241,1,241,1,241,1,242,1,242,1,242,1,242,3,242,4256,8,242,1,243,
  	1,243,1,243,1,243,1,243,3,243,4263,8,243,1,244,1,244,1,244,5,244,4268,
  	8,244,10,244,12,244,4271,9,244,1,245,1,245,1,245,1,245,1,245,1,245,1,
  	245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,1,245,
  	1,245,1,245,3,245,4401,8,245,1,246,1,246,1,247,1,247,1,248,1,248,1,249,
  	1,249,1,250,1,250,1,251,1,251,1,252,1,252,1,253,1,253,1,254,1,254,1,255,
  	1,255,1,256,1,256,1,257,1,257,1,258,1,258,1,259,1,259,1,260,1,260,1,261,
  	1,261,1,262,1,262,1,263,1,263,1,264,1,264,1,265,1,265,1,266,1,266,1,267,
  	1,267,1,268,1,268,1,269,1,269,1,270,1,270,1,271,1,271,3,271,4455,8,271,
  	1,272,1,272,1,273,1,273,1,273,3,273,4462,8,273,1,274,1,274,3,274,4466,
  	8,274,1,275,1,275,1,275,1,275,1,275,1,275,1,275,1,275,1,275,1,275,1,275,
  	1,275,1,275,1,275,3,275,4482,8,275,1,276,1,276,1,277,1,277,1,278,1,278,
  	1,278,1,278,5,278,4492,8,278,10,278,12,278,4495,9,278,3,278,4497,8,278,
  	1,278,1,278,1,279,1,279,1,279,1,279,1,279,1,279,5,279,4507,8,279,10,279,
  	12,279,4510,9,279,1,279,1,279,3,279,4514,8,279,1,280,1,280,1,280,1,280,
  	3,280,4520,8,280,1,280,1,280,1,280,1,280,1,280,3,280,4527,8,280,1,280,
  	1,280,1,280,1,280,1,280,3,280,4534,8,280,1,280,1,280,1,280,1,280,1,280,
  	3,280,4541,8,280,1,280,1,280,1,280,1,280,1,280,3,280,4548,8,280,1,280,
  	1,280,1,280,1,280,1,280,3,280,4555,8,280,1,280,1,280,1,280,1,280,1,280,
  	3,280,4562,8,280,1,280,3,280,4565,8,280,1,281,1,281,1,281,5,281,4570,
  	8,281,10,281,12,281,4573,9,281,1,282,1,282,1,282,5,282,4578,8,282,10,
  	282,12,282,4581,9,282,1,283,1,283,1,283,5,283,4586,8,283,10,283,12,283,
  	4589,9,283,1,284,1,284,1,285,1,285,1,285,5,285,4596,8,285,10,285,12,285,
  	4599,9,285,1,286,1,286,1,286,3,286,4604,8,286,1,286,1,286,3,286,4608,
  	8,286,1,286,3,286,4611,8,286,1,286,3,286,4614,8,286,1,286,3,286,4617,
  	8,286,1,286,3,286,4620,8,286,1,286,3,286,4623,8,286,1,287,1,287,1,287,
  	3,287,4628,8,287,1,287,3,287,4631,8,287,1,288,1,288,1,288,1,288,1,288,
  	3,288,4638,8,288,1,288,1,288,5,288,4642,8,288,10,288,12,288,4645,9,288,
  	1,289,1,289,1,289,1,289,1,290,1,290,1,290,1,290,1,291,1,291,1,291,1,291,
  	1,292,1,292,1,292,1,292,1,293,1,293,1,293,5,293,4666,8,293,10,293,12,
  	293,4669,9,293,1,294,1,294,1,295,1,295,1,295,1,295,3,295,4677,8,295,1,
  	295,1,295,3,295,4681,8,295,1,296,1,296,1,296,5,296,4686,8,296,10,296,
  	12,296,4689,9,296,1,297,1,297,1,297,3,297,4694,8,297,1,298,1,298,1,298,
  	1,298,1,299,1,299,1,299,1,299,1,300,1,300,1,300,1,300,1,301,1,301,1,302,
  	1,302,1,302,1,302,1,302,3,302,4715,8,302,1,302,1,302,1,302,1,302,3,302,
  	4721,8,302,1,303,1,303,1,303,1,303,3,303,4727,8,303,1,304,1,304,1,304,
  	5,304,4732,8,304,10,304,12,304,4735,9,304,1,305,1,305,1,305,1,305,1,305,
  	3,305,4742,8,305,1,305,1,305,1,305,1,305,3,305,4748,8,305,1,305,1,305,
  	1,305,1,305,1,305,1,305,1,305,1,305,1,305,1,305,3,305,4760,8,305,3,305,
  	4762,8,305,1,306,1,306,1,306,1,306,3,306,4768,8,306,1,306,1,306,3,306,
  	4772,8,306,3,306,4774,8,306,1,307,1,307,3,307,4778,8,307,1,307,1,307,
  	1,308,1,308,1,308,1,308,1,308,1,308,1,308,1,308,3,308,4790,8,308,1,309,
  	1,309,1,309,1,309,3,309,4796,8,309,1,309,1,309,1,309,1,309,3,309,4802,
  	8,309,1,309,1,309,1,309,1,309,1,309,1,309,3,309,4810,8,309,1,309,1,309,
  	3,309,4814,8,309,1,309,1,309,3,309,4818,8,309,1,309,1,309,1,309,1,309,
  	3,309,4824,8,309,3,309,4826,8,309,1,309,1,309,1,309,1,309,1,309,1,309,
  	1,309,1,309,1,309,1,309,1,309,3,309,4839,8,309,1,309,1,309,3,309,4843,
  	8,309,3,309,4845,8,309,3,309,4847,8,309,1,310,1,310,1,310,5,310,4852,
  	8,310,10,310,12,310,4855,9,310,1,311,1,311,1,311,1,311,1,311,1,311,1,
  	311,1,311,3,311,4865,8,311,1,311,3,311,4868,8,311,3,311,4870,8,311,1,
  	311,1,311,3,311,4874,8,311,1,311,1,311,1,311,3,311,4879,8,311,3,311,4881,
  	8,311,1,311,1,311,1,311,3,311,4886,8,311,1,311,1,311,1,311,1,311,3,311,
  	4892,8,311,1,311,3,311,4895,8,311,3,311,4897,8,311,1,311,1,311,3,311,
  	4901,8,311,1,311,3,311,4904,8,311,1,311,1,311,1,311,1,311,1,311,1,311,
  	1,311,1,311,3,311,4914,8,311,1,311,1,311,1,311,1,311,1,311,1,311,1,311,
  	1,311,3,311,4924,8,311,1,311,1,311,1,311,1,311,1,311,3,311,4931,8,311,
  	3,311,4933,8,311,3,311,4935,8,311,1,312,1,312,1,312,1,312,1,312,1,312,
  	3,312,4943,8,312,1,312,1,312,3,312,4947,8,312,1,312,1,312,1,312,1,312,
  	3,312,4953,8,312,1,312,3,312,4956,8,312,3,312,4958,8,312,1,312,1,312,
  	1,312,1,312,1,312,1,312,1,312,1,312,3,312,4968,8,312,1,312,1,312,3,312,
  	4972,8,312,1,312,1,312,1,312,1,312,3,312,4978,8,312,1,312,1,312,1,312,
  	1,312,1,312,3,312,4985,8,312,3,312,4987,8,312,1,312,1,312,1,312,3,312,
  	4992,8,312,3,312,4994,8,312,1,313,1,313,1,313,1,314,1,314,1,314,1,314,
  	3,314,5003,8,314,1,314,1,314,1,314,1,314,1,315,1,315,3,315,5011,8,315,
  	1,315,3,315,5014,8,315,1,315,5,315,5017,8,315,10,315,12,315,5020,9,315,
  	1,315,1,315,3,315,5024,8,315,1,315,3,315,5027,8,315,1,316,1,316,1,316,
  	1,316,3,316,5033,8,316,1,317,1,317,1,317,1,317,3,317,5039,8,317,1,317,
  	3,317,5042,8,317,1,318,1,318,1,318,3,318,5047,8,318,1,319,1,319,1,319,
  	1,319,1,319,1,319,1,319,1,319,1,319,4,319,5058,8,319,11,319,12,319,5059,
  	1,320,1,320,1,320,1,320,1,320,1,320,1,320,1,320,1,320,1,320,3,320,5072,
  	8,320,1,320,1,320,1,320,3,320,5077,8,320,1,320,1,320,1,320,1,320,1,320,
  	1,320,3,320,5085,8,320,1,320,1,320,1,320,1,320,3,320,5091,8,320,3,320,
  	5093,8,320,1,320,1,320,1,320,1,320,1,320,1,320,1,320,3,320,5102,8,320,
  	3,320,5104,8,320,1,321,1,321,1,321,1,321,3,321,5110,8,321,1,321,1,321,
  	1,322,1,322,1,322,1,322,1,322,1,322,1,322,1,322,3,322,5122,8,322,1,322,
  	1,322,1,322,3,322,5127,8,322,3,322,5129,8,322,1,322,1,322,3,322,5133,
  	8,322,1,322,1,322,1,322,1,322,3,322,5139,8,322,1,322,3,322,5142,8,322,
  	1,322,3,322,5145,8,322,1,322,1,322,1,322,1,322,1,322,1,322,1,322,1,322,
  	3,322,5155,8,322,3,322,5157,8,322,1,323,1,323,1,323,1,323,3,323,5163,
  	8,323,1,324,1,324,1,324,1,325,1,325,1,325,1,326,1,326,1,326,1,326,1,326,
  	3,326,5176,8,326,1,326,1,326,3,326,5180,8,326,1,327,1,327,1,327,3,327,
  	5185,8,327,1,328,1,328,1,328,1,329,1,329,1,329,1,329,1,329,1,329,1,329,
  	1,329,1,329,1,329,5,329,5200,8,329,10,329,12,329,5203,9,329,1,330,1,330,
  	1,330,3,330,5208,8,330,1,330,1,330,1,330,1,330,1,330,1,330,1,330,1,330,
  	3,330,5218,8,330,1,330,1,330,1,330,1,330,1,330,1,330,3,330,5226,8,330,
  	1,330,1,330,1,330,3,330,5231,8,330,1,330,1,330,1,330,1,330,3,330,5237,
  	8,330,1,330,1,330,1,330,1,330,1,330,1,330,1,330,1,330,3,330,5247,8,330,
  	1,330,1,330,3,330,5251,8,330,1,331,1,331,1,332,1,332,1,332,5,332,5258,
  	8,332,10,332,12,332,5261,9,332,1,333,1,333,1,333,3,333,5266,8,333,1,333,
  	1,333,1,333,1,333,3,333,5272,8,333,3,333,5274,8,333,1,333,1,333,3,333,
  	5278,8,333,1,333,1,333,1,333,1,333,1,333,1,333,1,333,1,333,1,333,3,333,
  	5289,8,333,1,333,1,333,1,333,1,333,1,333,3,333,5296,8,333,1,333,1,333,
  	1,333,1,333,3,333,5302,8,333,1,333,1,333,1,333,3,333,5307,8,333,1,334,
  	1,334,1,334,3,334,5312,8,334,1,334,1,334,1,334,3,334,5317,8,334,1,334,
  	1,334,1,334,1,334,1,334,1,334,3,334,5325,8,334,1,335,1,335,3,335,5329,
  	8,335,1,335,5,335,5332,8,335,10,335,12,335,5335,9,335,1,336,1,336,1,336,
  	1,336,1,336,1,336,3,336,5343,8,336,1,337,1,337,1,337,1,337,1,337,1,337,
  	1,337,1,337,1,337,1,337,1,337,3,337,5356,8,337,3,337,5358,8,337,1,338,
  	1,338,1,338,1,338,1,338,1,338,1,338,1,338,1,338,1,338,1,338,1,338,3,338,
  	5372,8,338,1,338,1,338,1,338,1,338,1,338,1,338,1,338,3,338,5381,8,338,
  	3,338,5383,8,338,1,339,1,339,1,339,5,339,5388,8,339,10,339,12,339,5391,
  	9,339,1,340,1,340,1,340,1,340,3,340,5397,8,340,3,340,5399,8,340,1,341,
  	1,341,3,341,5403,8,341,1,341,1,341,1,341,1,341,3,341,5409,8,341,1,341,
  	1,341,1,341,1,341,5,341,5415,8,341,10,341,12,341,5418,9,341,1,341,1,341,
  	1,341,1,341,3,341,5424,8,341,1,341,1,341,3,341,5428,8,341,1,341,1,341,
  	1,341,1,341,3,341,5434,8,341,1,341,1,341,1,341,5,341,5439,8,341,10,341,
  	12,341,5442,9,341,3,341,5444,8,341,1,342,1,342,1,342,1,342,1,342,1,342,
  	1,342,1,342,1,342,1,342,1,342,3,342,5457,8,342,1,342,1,342,1,342,1,342,
  	3,342,5463,8,342,1,343,1,343,1,343,3,343,5468,8,343,1,344,1,344,1,345,
  	1,345,1,345,1,345,1,345,1,345,1,345,5,345,5479,8,345,10,345,12,345,5482,
  	9,345,3,345,5484,8,345,1,346,1,346,1,346,1,346,1,346,1,346,1,346,1,346,
  	1,346,3,346,5495,8,346,3,346,5497,8,346,1,347,1,347,1,348,1,348,3,348,
  	5503,8,348,1,349,1,349,1,349,1,349,1,349,1,350,1,350,1,350,1,350,1,350,
  	5,350,5515,8,350,10,350,12,350,5518,9,350,1,351,1,351,1,351,1,352,1,352,
  	1,352,1,352,1,352,1,352,1,352,1,352,1,352,1,352,1,352,3,352,5534,8,352,
  	1,352,1,352,1,352,3,352,5539,8,352,1,352,3,352,5542,8,352,1,352,1,352,
  	3,352,5546,8,352,1,352,3,352,5549,8,352,1,352,1,352,1,352,1,352,1,352,
  	1,352,1,352,1,352,1,352,1,352,1,352,1,352,3,352,5563,8,352,1,352,1,352,
  	1,352,1,352,3,352,5569,8,352,1,352,1,352,1,352,3,352,5574,8,352,1,352,
  	3,352,5577,8,352,3,352,5579,8,352,1,353,1,353,3,353,5583,8,353,1,353,
  	1,353,1,353,3,353,5588,8,353,3,353,5590,8,353,1,354,1,354,1,354,1,355,
  	1,355,1,355,1,355,1,355,1,355,1,355,3,355,5602,8,355,1,356,1,356,5,356,
  	5606,8,356,10,356,12,356,5609,9,356,1,357,1,357,1,357,1,357,1,357,1,357,
  	1,357,1,357,1,357,1,357,1,357,1,357,3,357,5623,8,357,1,357,1,357,1,357,
  	1,357,1,357,1,357,1,357,1,357,1,357,1,357,3,357,5635,8,357,1,357,1,357,
  	3,357,5639,8,357,3,357,5641,8,357,1,358,1,358,1,358,1,358,1,358,1,358,
  	3,358,5649,8,358,1,359,1,359,1,359,1,359,1,359,3,359,5656,8,359,1,360,
  	1,360,1,360,1,360,1,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,1,361,
  	3,361,5671,8,361,1,362,1,362,1,362,3,362,5676,8,362,1,363,1,363,3,363,
  	5680,8,363,1,363,1,363,3,363,5684,8,363,1,363,3,363,5687,8,363,1,364,
  	1,364,3,364,5691,8,364,1,364,1,364,3,364,5695,8,364,1,364,3,364,5698,
  	8,364,1,365,1,365,1,365,3,365,5703,8,365,1,365,3,365,5706,8,365,1,366,
  	1,366,1,366,1,366,3,366,5712,8,366,1,366,3,366,5715,8,366,1,367,1,367,
  	1,367,1,367,3,367,5721,8,367,1,367,3,367,5724,8,367,1,368,1,368,1,368,
  	1,368,1,368,1,369,1,369,1,369,1,370,1,370,1,370,1,370,1,370,1,371,1,371,
  	1,371,1,371,1,371,1,372,1,372,1,372,1,372,1,372,1,373,1,373,3,373,5751,
  	8,373,1,373,1,373,1,373,1,373,3,373,5757,8,373,1,373,3,373,5760,8,373,
  	1,374,1,374,1,374,1,374,1,375,1,375,1,375,1,375,1,375,1,376,1,376,1,376,
  	1,376,3,376,5775,8,376,1,377,1,377,1,377,1,377,1,377,3,377,5782,8,377,
  	1,377,1,377,3,377,5786,8,377,1,377,3,377,5789,8,377,1,377,3,377,5792,
  	8,377,1,378,1,378,1,378,1,378,1,378,3,378,5799,8,378,1,378,1,378,3,378,
  	5803,8,378,1,378,3,378,5806,8,378,1,378,3,378,5809,8,378,1,379,1,379,
  	1,379,3,379,5814,8,379,1,379,1,379,1,379,1,379,3,379,5820,8,379,1,379,
  	3,379,5823,8,379,1,380,1,380,3,380,5827,8,380,1,380,1,380,1,381,1,381,
  	1,381,1,381,1,381,1,381,1,381,1,382,1,382,1,382,1,382,1,382,1,382,1,382,
  	1,383,1,383,1,383,3,383,5848,8,383,1,384,1,384,1,384,3,384,5853,8,384,
  	1,385,1,385,1,385,1,386,1,386,1,386,3,386,5861,8,386,1,386,1,386,1,386,
  	3,386,5866,8,386,1,386,3,386,5869,8,386,1,387,1,387,3,387,5873,8,387,
  	1,387,1,387,3,387,5877,8,387,1,388,1,388,3,388,5881,8,388,1,388,1,388,
  	1,389,1,389,3,389,5887,8,389,1,389,1,389,3,389,5891,8,389,1,390,1,390,
  	1,390,3,390,5896,8,390,1,391,1,391,1,391,3,391,5901,8,391,1,392,1,392,
  	1,392,1,393,1,393,1,393,1,393,1,393,1,393,3,393,5912,8,393,3,393,5914,
  	8,393,1,394,1,394,1,394,1,394,3,394,5920,8,394,1,394,1,394,1,395,1,395,
  	1,395,1,395,1,395,1,396,1,396,1,396,1,396,1,396,1,397,1,397,1,397,1,397,
  	1,398,1,398,1,398,1,398,1,398,3,398,5943,8,398,1,398,3,398,5946,8,398,
  	1,399,1,399,1,399,1,399,1,399,1,400,1,400,1,400,1,400,1,400,1,401,1,401,
  	1,401,1,401,1,401,1,402,1,402,1,402,1,402,1,402,3,402,5968,8,402,1,403,
  	1,403,1,403,1,403,1,403,3,403,5975,8,403,1,404,1,404,1,404,1,404,1,404,
  	1,404,1,405,1,405,1,405,1,405,1,405,1,405,1,406,1,406,1,406,1,406,1,406,
  	1,407,1,407,1,407,1,407,1,407,1,408,1,408,1,408,1,408,3,408,6003,8,408,
  	3,408,6005,8,408,1,409,1,409,3,409,6009,8,409,1,410,1,410,1,411,1,411,
  	1,411,1,412,1,412,1,412,5,412,6019,8,412,10,412,12,412,6022,9,412,1,413,
  	1,413,1,413,1,413,1,413,1,413,1,413,3,413,6031,8,413,1,414,1,414,1,414,
  	1,414,1,414,1,414,1,414,1,414,3,414,6041,8,414,1,414,1,414,3,414,6045,
  	8,414,1,414,1,414,1,414,1,414,5,414,6051,8,414,10,414,12,414,6054,9,414,
  	3,414,6056,8,414,1,414,1,414,3,414,6060,8,414,1,414,1,414,1,414,1,414,
  	1,414,1,414,1,414,1,414,3,414,6070,8,414,1,415,1,415,3,415,6074,8,415,
  	1,416,1,416,1,416,5,416,6079,8,416,10,416,12,416,6082,9,416,1,417,1,417,
  	3,417,6086,8,417,1,418,1,418,1,418,1,418,1,418,1,418,3,418,6094,8,418,
  	1,419,1,419,1,419,3,419,6099,8,419,1,419,1,419,1,420,1,420,3,420,6105,
  	8,420,1,421,1,421,1,421,5,421,6110,8,421,10,421,12,421,6113,9,421,1,422,
  	1,422,3,422,6117,8,422,1,422,1,422,1,422,1,422,3,422,6123,8,422,1,422,
  	1,422,1,422,1,422,1,422,3,422,6130,8,422,1,423,1,423,1,424,1,424,1,424,
  	1,424,1,424,1,424,3,424,6140,8,424,3,424,6142,8,424,1,425,1,425,1,425,
  	1,425,1,425,3,425,6149,8,425,1,426,1,426,1,426,3,426,6154,8,426,1,426,
  	1,426,3,426,6158,8,426,1,426,3,426,6161,8,426,1,427,1,427,1,427,5,427,
  	6166,8,427,10,427,12,427,6169,9,427,1,428,1,428,3,428,6173,8,428,1,428,
  	1,428,3,428,6177,8,428,1,429,1,429,1,429,1,429,1,429,1,430,1,430,1,430,
  	1,430,3,430,6188,8,430,1,431,1,431,1,431,1,431,1,431,1,431,3,431,6196,
  	8,431,1,431,1,431,3,431,6200,8,431,1,431,3,431,6203,8,431,1,431,3,431,
  	6206,8,431,1,432,1,432,3,432,6210,8,432,1,432,1,432,3,432,6214,8,432,
  	1,432,5,432,6217,8,432,10,432,12,432,6220,9,432,1,433,1,433,1,433,3,433,
  	6225,8,433,1,434,1,434,3,434,6229,8,434,1,434,1,434,1,435,1,435,1,436,
  	1,436,1,436,1,436,1,436,3,436,6240,8,436,1,436,3,436,6243,8,436,1,436,
  	3,436,6246,8,436,1,436,3,436,6249,8,436,1,437,1,437,1,437,1,437,1,437,
  	1,437,3,437,6257,8,437,1,438,1,438,3,438,6261,8,438,1,438,5,438,6264,
  	8,438,10,438,12,438,6267,9,438,1,439,1,439,1,439,1,439,1,439,3,439,6274,
  	8,439,1,440,1,440,1,440,1,440,1,440,1,440,3,440,6282,8,440,1,441,1,441,
  	1,441,1,441,3,441,6288,8,441,1,442,1,442,3,442,6292,8,442,1,442,1,442,
  	1,442,1,442,3,442,6298,8,442,1,442,1,442,1,443,1,443,1,443,1,443,1,443,
  	3,443,6307,8,443,1,443,1,443,1,443,1,443,1,443,1,443,1,443,1,443,1,443,
  	1,443,1,443,3,443,6320,8,443,1,444,1,444,1,444,1,444,1,444,1,444,1,444,
  	1,444,3,444,6330,8,444,1,445,1,445,1,445,1,445,1,446,1,446,1,446,1,447,
  	1,447,1,447,1,448,1,448,1,449,1,449,1,449,1,449,3,449,6348,8,449,1,449,
  	3,449,6351,8,449,1,449,1,449,3,449,6355,8,449,1,449,1,449,1,449,1,449,
  	1,449,1,449,1,449,1,449,1,449,5,449,6366,8,449,10,449,12,449,6369,9,449,
  	1,450,1,450,1,450,1,450,1,450,1,450,3,450,6377,8,450,1,450,1,450,1,450,
  	1,450,1,450,1,450,1,450,1,450,1,450,1,450,5,450,6389,8,450,10,450,12,
  	450,6392,9,450,1,451,1,451,1,452,1,452,3,452,6398,8,452,1,452,1,452,1,
  	452,1,452,3,452,6404,8,452,1,452,1,452,1,452,1,452,3,452,6410,8,452,1,
  	453,1,453,1,453,1,453,1,453,1,453,3,453,6418,8,453,1,453,1,453,1,453,
  	1,453,1,453,1,453,1,453,1,453,1,453,3,453,6429,8,453,1,453,1,453,3,453,
  	6433,8,453,1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,
  	1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,1,454,
  	1,454,1,454,1,454,1,454,1,454,5,454,6462,8,454,10,454,12,454,6465,9,454,
  	1,455,1,455,1,455,3,455,6470,8,455,1,455,1,455,1,455,1,455,1,455,1,455,
  	1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,3,455,
  	6489,8,455,1,455,1,455,1,455,1,455,1,455,3,455,6496,8,455,1,455,1,455,
  	1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,3,455,6510,
  	8,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,3,455,6521,
  	8,455,1,455,1,455,1,455,3,455,6526,8,455,1,455,1,455,1,455,1,455,1,455,
  	1,455,1,455,1,455,1,455,1,455,3,455,6538,8,455,1,455,1,455,1,455,1,455,
  	1,455,1,455,1,455,1,455,3,455,6548,8,455,1,455,1,455,1,455,4,455,6553,
  	8,455,11,455,12,455,6554,1,455,3,455,6558,8,455,1,455,1,455,1,455,1,455,
  	1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,
  	1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,1,455,
  	1,455,1,455,1,455,1,455,3,455,6592,8,455,1,455,1,455,1,455,1,455,1,455,
  	1,455,5,455,6600,8,455,10,455,12,455,6603,9,455,1,456,1,456,1,456,1,457,
  	1,457,1,457,1,457,1,457,1,457,3,457,6614,8,457,1,458,1,458,1,458,3,458,
  	6619,8,458,1,458,1,458,1,458,1,458,3,458,6625,8,458,1,458,1,458,1,458,
  	1,458,1,458,1,458,3,458,6633,8,458,1,458,1,458,1,458,1,458,1,458,1,458,
  	3,458,6641,8,458,1,458,1,458,1,458,3,458,6646,8,458,1,458,1,458,1,458,
  	3,458,6651,8,458,1,458,1,458,1,458,1,458,3,458,6657,8,458,1,458,1,458,
  	1,458,3,458,6662,8,458,1,458,1,458,1,458,3,458,6667,8,458,1,458,1,458,
  	1,458,1,458,3,458,6673,8,458,1,458,1,458,1,458,1,458,1,458,1,458,3,458,
  	6681,8,458,1,458,1,458,1,458,1,458,1,458,1,458,1,458,3,458,6690,8,458,
  	1,458,1,458,1,458,3,458,6695,8,458,1,458,1,458,3,458,6699,8,458,1,458,
  	1,458,3,458,6703,8,458,1,458,1,458,1,458,3,458,6708,8,458,3,458,6710,
  	8,458,1,459,1,459,1,459,1,459,1,459,1,460,1,460,1,460,1,460,1,460,1,460,
  	1,460,1,460,1,460,1,460,1,460,3,460,6728,8,460,1,460,1,460,1,460,1,460,
  	1,460,1,460,3,460,6736,8,460,1,460,1,460,3,460,6740,8,460,1,460,1,460,
  	1,460,1,460,1,460,3,460,6747,8,460,1,460,1,460,1,460,1,460,1,460,1,460,
  	1,460,1,460,1,460,1,460,3,460,6759,8,460,1,460,3,460,6762,8,460,1,460,
  	1,460,3,460,6766,8,460,1,461,1,461,1,461,3,461,6771,8,461,1,462,1,462,
  	1,462,1,462,1,462,3,462,6778,8,462,1,462,1,462,3,462,6782,8,462,1,463,
  	1,463,3,463,6786,8,463,1,464,1,464,1,464,3,464,6791,8,464,1,465,1,465,
  	1,465,1,466,1,466,1,466,1,466,1,466,3,466,6801,8,466,1,466,1,466,1,466,
  	1,466,1,466,1,466,1,466,3,466,6810,8,466,3,466,6812,8,466,1,467,3,467,
  	6815,8,467,1,467,1,467,1,468,1,468,1,468,1,468,1,468,3,468,6824,8,468,
  	1,469,1,469,1,469,5,469,6829,8,469,10,469,12,469,6832,9,469,1,470,1,470,
  	1,470,1,470,1,470,1,470,1,470,1,470,1,470,1,470,3,470,6844,8,470,1,470,
  	1,470,1,470,3,470,6849,8,470,1,471,1,471,1,471,1,471,1,471,3,471,6856,
  	8,471,1,471,1,471,1,471,1,471,3,471,6862,8,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,4,471,6886,8,471,11,471,12,471,6887,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,3,471,6899,8,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,3,471,6931,8,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,3,471,6950,8,471,1,471,1,471,1,471,1,471,3,471,6956,8,471,
  	1,471,1,471,3,471,6960,8,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,3,471,6991,
  	8,471,1,471,1,471,1,471,1,471,3,471,6997,8,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,3,471,7009,8,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,3,471,7022,8,471,1,471,
  	1,471,3,471,7026,8,471,1,471,1,471,3,471,7030,8,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,3,471,
  	7058,8,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,1,471,3,471,7108,8,471,1,471,1,471,1,471,1,471,1,471,1,471,1,471,
  	1,471,3,471,7118,8,471,1,471,1,471,3,471,7122,8,471,1,471,1,471,1,471,
  	1,471,1,471,1,471,1,471,1,471,1,471,1,471,3,471,7134,8,471,1,471,1,471,
  	1,471,3,471,7139,8,471,1,472,1,472,1,472,1,473,1,473,1,473,1,473,1,473,
  	1,473,1,473,1,473,1,473,1,473,1,473,3,473,7155,8,473,1,473,1,473,1,473,
  	1,473,1,473,1,473,1,473,1,473,1,473,1,473,1,473,1,473,1,473,1,473,1,473,
  	1,473,1,473,1,473,3,473,7175,8,473,1,474,1,474,3,474,7179,8,474,1,474,
  	1,474,1,475,1,475,1,476,1,476,1,476,1,476,1,476,1,476,1,476,1,476,5,476,
  	7193,8,476,10,476,12,476,7196,9,476,3,476,7198,8,476,1,477,1,477,1,477,
  	3,477,7203,8,477,1,477,3,477,7206,8,477,1,478,1,478,1,479,1,479,1,479,
  	1,479,1,479,3,479,7215,8,479,1,479,1,479,3,479,7219,8,479,1,479,1,479,
  	1,479,1,479,3,479,7225,8,479,1,479,1,479,1,479,1,479,3,479,7231,8,479,
  	1,479,1,479,3,479,7235,8,479,1,479,1,479,1,480,1,480,1,480,1,480,1,480,
  	1,480,1,480,3,480,7246,8,480,1,480,1,480,1,480,1,480,3,480,7252,8,480,
  	3,480,7254,8,480,1,480,1,480,1,481,1,481,1,481,3,481,7261,8,481,1,481,
  	1,481,1,481,1,481,1,481,3,481,7268,8,481,1,481,1,481,3,481,7272,8,481,
  	1,482,1,482,1,482,5,482,7277,8,482,10,482,12,482,7280,9,482,1,483,1,483,
  	3,483,7284,8,483,1,484,1,484,1,484,1,485,1,485,3,485,7291,8,485,1,486,
  	1,486,1,486,1,486,1,487,1,487,1,487,1,487,3,487,7301,8,487,1,487,3,487,
  	7304,8,487,1,488,1,488,3,488,7308,8,488,1,488,1,488,1,488,3,488,7313,
  	8,488,3,488,7315,8,488,1,488,1,488,3,488,7319,8,488,1,489,1,489,3,489,
  	7323,8,489,1,490,1,490,1,490,1,491,1,491,1,491,1,492,1,492,1,492,1,493,
  	1,493,3,493,7336,8,493,1,493,1,493,3,493,7340,8,493,1,493,3,493,7343,
  	8,493,1,493,1,493,3,493,7347,8,493,1,493,1,493,3,493,7351,8,493,1,493,
  	1,493,3,493,7355,8,493,1,493,1,493,1,493,1,493,1,493,3,493,7362,8,493,
  	1,493,1,493,3,493,7366,8,493,1,493,1,493,3,493,7370,8,493,1,493,1,493,
  	1,493,1,493,1,493,1,493,1,493,3,493,7379,8,493,1,493,1,493,3,493,7383,
  	8,493,1,494,1,494,1,494,5,494,7388,8,494,10,494,12,494,7391,9,494,1,495,
  	1,495,1,495,3,495,7396,8,495,1,496,1,496,1,497,1,497,1,498,1,498,3,498,
  	7404,8,498,1,499,1,499,1,500,1,500,1,500,1,500,1,501,1,501,1,501,1,501,
  	1,502,1,502,1,502,1,502,1,503,1,503,1,503,5,503,7423,8,503,10,503,12,
  	503,7426,9,503,1,504,1,504,3,504,7430,8,504,1,505,1,505,1,505,5,505,7435,
  	8,505,10,505,12,505,7438,9,505,1,506,1,506,1,507,1,507,1,507,1,507,1,
  	507,1,508,1,508,1,508,1,508,1,508,1,508,1,508,1,508,1,508,1,508,1,508,
  	1,508,1,508,3,508,7460,8,508,1,509,1,509,1,509,1,510,1,510,1,510,1,510,
  	1,510,1,511,1,511,1,511,1,511,1,511,1,511,3,511,7476,8,511,1,512,1,512,
  	1,512,1,513,1,513,1,513,4,513,7484,8,513,11,513,12,513,7485,1,514,1,514,
  	3,514,7490,8,514,1,514,1,514,1,514,4,514,7495,8,514,11,514,12,514,7496,
  	1,514,3,514,7500,8,514,1,514,1,514,1,514,1,515,1,515,1,515,1,516,1,516,
  	1,516,3,516,7511,8,516,1,517,1,517,1,518,1,518,1,518,1,519,1,519,3,519,
  	7520,8,519,1,519,3,519,7523,8,519,1,519,1,519,1,520,1,520,1,520,3,520,
  	7530,8,520,1,521,1,521,1,521,3,521,7535,8,521,1,522,1,522,1,522,1,522,
  	1,522,1,523,1,523,1,523,1,523,1,523,1,523,1,523,1,524,1,524,1,524,1,524,
  	1,524,1,524,1,524,1,525,1,525,1,525,4,525,7559,8,525,11,525,12,525,7560,
  	1,526,1,526,1,526,1,526,3,526,7567,8,526,1,527,1,527,1,527,1,527,3,527,
  	7573,8,527,1,527,1,527,3,527,7577,8,527,1,528,1,528,1,528,1,528,1,528,
  	1,528,1,529,1,529,3,529,7587,8,529,1,530,1,530,3,530,7591,8,530,1,530,
  	1,530,1,531,1,531,1,531,1,531,1,531,1,531,1,531,5,531,7602,8,531,10,531,
  	12,531,7605,9,531,1,531,1,531,1,532,1,532,1,532,1,532,1,532,1,532,1,532,
  	3,532,7616,8,532,1,533,1,533,1,533,1,533,1,533,1,533,1,534,1,534,1,534,
  	1,535,1,535,1,535,1,536,1,536,3,536,7632,8,536,1,536,1,536,1,536,1,536,
  	5,536,7638,8,536,10,536,12,536,7641,9,536,1,536,1,536,1,536,1,536,1,536,
  	5,536,7648,8,536,10,536,12,536,7651,9,536,3,536,7653,8,536,1,537,1,537,
  	1,537,3,537,7658,8,537,1,538,1,538,3,538,7662,8,538,1,538,1,538,1,538,
  	1,539,1,539,3,539,7669,8,539,1,539,1,539,1,539,3,539,7674,8,539,1,540,
  	1,540,1,541,1,541,1,541,3,541,7681,8,541,1,541,1,541,1,541,1,541,5,541,
  	7687,8,541,10,541,12,541,7690,9,541,3,541,7692,8,541,1,542,1,542,1,542,
  	3,542,7697,8,542,1,542,1,542,1,542,1,542,5,542,7703,8,542,10,542,12,542,
  	7706,9,542,3,542,7708,8,542,1,543,1,543,1,543,1,543,1,544,1,544,1,544,
  	1,545,1,545,1,545,1,546,1,546,3,546,7722,8,546,1,546,3,546,7725,8,546,
  	1,546,1,546,1,546,1,546,1,547,1,547,1,547,1,547,1,547,1,547,1,547,3,547,
  	7738,8,547,1,547,1,547,3,547,7742,8,547,3,547,7744,8,547,1,548,1,548,
  	1,548,3,548,7749,8,548,1,549,1,549,1,549,3,549,7754,8,549,1,550,1,550,
  	1,550,1,551,1,551,3,551,7761,8,551,1,551,1,551,1,552,1,552,3,552,7767,
  	8,552,1,552,1,552,5,552,7771,8,552,10,552,12,552,7774,9,552,1,552,1,552,
  	3,552,7778,8,552,1,552,3,552,7781,8,552,1,552,1,552,5,552,7785,8,552,
  	10,552,12,552,7788,9,552,1,552,1,552,3,552,7792,8,552,1,552,3,552,7795,
  	8,552,1,552,1,552,5,552,7799,8,552,10,552,12,552,7802,9,552,1,552,3,552,
  	7805,8,552,1,552,1,552,1,552,1,552,3,552,7811,8,552,3,552,7813,8,552,
  	1,552,3,552,7816,8,552,1,552,1,552,5,552,7820,8,552,10,552,12,552,7823,
  	9,552,1,552,1,552,1,552,3,552,7828,8,552,1,552,1,552,1,552,1,552,1,552,
  	3,552,7835,8,552,3,552,7837,8,552,3,552,7839,8,552,1,553,1,553,3,553,
  	7843,8,553,1,554,1,554,5,554,7847,8,554,10,554,12,554,7850,9,554,1,554,
  	1,554,3,554,7854,8,554,1,554,1,554,3,554,7858,8,554,1,554,1,554,1,554,
  	3,554,7863,8,554,1,554,1,554,5,554,7867,8,554,10,554,12,554,7870,9,554,
  	1,554,1,554,5,554,7874,8,554,10,554,12,554,7877,9,554,3,554,7879,8,554,
  	3,554,7881,8,554,1,555,3,555,7884,8,555,1,555,1,555,1,555,1,555,1,555,
  	1,555,1,555,1,555,3,555,7894,8,555,1,555,1,555,1,555,1,555,3,555,7900,
  	8,555,1,555,1,555,1,555,1,555,1,555,3,555,7907,8,555,1,555,1,555,1,555,
  	3,555,7912,8,555,1,555,1,555,1,555,1,555,1,555,1,555,1,555,1,555,1,555,
  	1,555,1,555,1,555,3,555,7926,8,555,1,555,1,555,1,555,1,555,1,555,1,555,
  	3,555,7934,8,555,1,555,1,555,1,555,1,555,3,555,7940,8,555,1,555,1,555,
  	1,555,3,555,7945,8,555,1,556,1,556,1,557,1,557,1,558,1,558,1,558,1,559,
  	1,559,3,559,7956,8,559,1,560,1,560,3,560,7960,8,560,1,560,1,560,1,560,
  	3,560,7965,8,560,1,560,1,560,3,560,7969,8,560,1,560,3,560,7972,8,560,
  	1,561,1,561,1,561,3,561,7977,8,561,1,561,1,561,3,561,7981,8,561,1,561,
  	1,561,1,561,1,561,1,561,1,561,3,561,7989,8,561,1,561,1,561,1,561,1,561,
  	1,561,1,561,3,561,7997,8,561,3,561,7999,8,561,1,562,1,562,1,562,1,562,
  	1,562,1,562,1,562,3,562,8008,8,562,1,563,1,563,1,563,1,563,5,563,8014,
  	8,563,10,563,12,563,8017,9,563,1,563,1,563,1,564,1,564,3,564,8023,8,564,
  	1,564,3,564,8026,8,564,1,565,1,565,1,565,1,565,5,565,8032,8,565,10,565,
  	12,565,8035,9,565,1,565,1,565,1,566,1,566,1,566,1,566,3,566,8043,8,566,
  	3,566,8045,8,566,1,567,1,567,1,568,1,568,3,568,8051,8,568,1,569,1,569,
  	3,569,8055,8,569,1,569,1,569,1,569,1,569,1,569,1,569,1,569,1,569,3,569,
  	8065,8,569,1,569,1,569,1,569,1,569,3,569,8071,8,569,1,569,3,569,8074,
  	8,569,1,570,1,570,1,571,1,571,1,571,1,572,1,572,1,572,1,572,3,572,8085,
  	8,572,1,573,1,573,1,574,1,574,1,574,1,575,1,575,3,575,8094,8,575,1,575,
  	3,575,8097,8,575,1,575,1,575,1,575,3,575,8102,8,575,3,575,8104,8,575,
  	1,575,3,575,8107,8,575,1,575,3,575,8110,8,575,1,575,1,575,3,575,8114,
  	8,575,1,575,3,575,8117,8,575,1,575,1,575,3,575,8121,8,575,1,575,1,575,
  	1,575,3,575,8126,8,575,1,575,3,575,8129,8,575,1,575,1,575,3,575,8133,
  	8,575,1,575,3,575,8136,8,575,1,575,1,575,3,575,8140,8,575,1,575,1,575,
  	1,575,3,575,8145,8,575,1,575,1,575,3,575,8149,8,575,1,575,1,575,1,575,
  	1,575,1,575,1,575,1,575,1,575,1,575,1,575,3,575,8161,8,575,1,575,1,575,
  	3,575,8165,8,575,1,575,1,575,1,575,1,575,3,575,8171,8,575,1,575,3,575,
  	8174,8,575,1,575,1,575,1,575,3,575,8179,8,575,1,575,1,575,3,575,8183,
  	8,575,1,575,1,575,3,575,8187,8,575,1,575,1,575,1,575,3,575,8192,8,575,
  	1,575,1,575,1,575,1,575,1,575,1,575,1,575,3,575,8201,8,575,1,575,3,575,
  	8204,8,575,1,575,1,575,3,575,8208,8,575,1,575,1,575,3,575,8212,8,575,
  	1,575,3,575,8215,8,575,1,575,1,575,3,575,8219,8,575,1,575,1,575,3,575,
  	8223,8,575,1,575,1,575,1,575,3,575,8228,8,575,1,575,1,575,1,575,3,575,
  	8233,8,575,1,575,1,575,1,575,1,575,3,575,8239,8,575,1,576,1,576,1,576,
  	3,576,8244,8,576,1,577,1,577,1,577,3,577,8249,8,577,3,577,8251,8,577,
  	1,578,1,578,1,578,3,578,8256,8,578,1,578,1,578,1,579,4,579,8261,8,579,
  	11,579,12,579,8262,1,580,1,580,1,580,1,580,1,580,1,580,3,580,8271,8,580,
  	1,580,1,580,1,580,1,580,3,580,8277,8,580,3,580,8279,8,580,1,581,1,581,
  	3,581,8283,8,581,1,581,1,581,3,581,8287,8,581,1,582,1,582,3,582,8291,
  	8,582,1,582,1,582,3,582,8295,8,582,1,583,1,583,1,583,1,583,1,584,1,584,
  	1,584,1,584,1,585,1,585,1,585,1,585,1,585,3,585,8310,8,585,1,586,1,586,
  	1,586,1,586,3,586,8316,8,586,1,587,1,587,1,587,1,587,1,587,3,587,8323,
  	8,587,1,588,1,588,3,588,8327,8,588,1,588,5,588,8330,8,588,10,588,12,588,
  	8333,9,588,1,589,1,589,3,589,8337,8,589,1,589,3,589,8340,8,589,1,590,
  	1,590,3,590,8344,8,590,1,590,3,590,8347,8,590,1,591,4,591,8350,8,591,
  	11,591,12,591,8351,1,592,1,592,3,592,8356,8,592,1,592,1,592,1,592,1,592,
  	3,592,8362,8,592,1,592,1,592,3,592,8366,8,592,1,592,1,592,3,592,8370,
  	8,592,1,592,1,592,1,592,3,592,8375,8,592,1,592,1,592,1,592,3,592,8380,
  	8,592,1,592,1,592,1,592,3,592,8385,8,592,1,592,1,592,1,592,3,592,8390,
  	8,592,1,592,1,592,1,592,1,592,3,592,8396,8,592,1,592,1,592,1,592,1,592,
  	3,592,8402,8,592,1,592,1,592,1,592,3,592,8407,8,592,1,592,1,592,1,592,
  	3,592,8412,8,592,1,592,1,592,1,592,3,592,8417,8,592,1,592,1,592,1,592,
  	3,592,8422,8,592,1,592,1,592,1,592,3,592,8427,8,592,1,592,1,592,1,592,
  	3,592,8432,8,592,1,592,1,592,1,592,3,592,8437,8,592,1,592,1,592,1,592,
  	1,592,1,592,1,592,1,592,1,592,3,592,8447,8,592,1,592,1,592,1,592,1,592,
  	3,592,8453,8,592,1,592,1,592,1,592,1,592,3,592,8459,8,592,1,592,1,592,
  	1,592,1,592,3,592,8465,8,592,1,592,3,592,8468,8,592,1,592,1,592,1,592,
  	1,592,1,592,3,592,8475,8,592,1,592,1,592,1,592,3,592,8480,8,592,1,592,
  	1,592,1,592,1,592,1,592,1,592,1,592,3,592,8489,8,592,1,592,1,592,1,592,
  	1,592,3,592,8495,8,592,1,592,1,592,1,592,3,592,8500,8,592,1,593,1,593,
  	3,593,8504,8,593,1,594,3,594,8507,8,594,1,594,1,594,3,594,8511,8,594,
  	1,594,1,594,1,595,3,595,8516,8,595,1,595,1,595,3,595,8520,8,595,1,595,
  	1,595,1,596,3,596,8525,8,596,1,596,1,596,3,596,8529,8,596,1,596,1,596,
  	1,597,1,597,1,597,1,597,1,597,3,597,8538,8,597,1,597,3,597,8541,8,597,
  	1,597,3,597,8544,8,597,1,598,3,598,8547,8,598,1,598,1,598,3,598,8551,
  	8,598,1,598,1,598,3,598,8555,8,598,1,598,1,598,3,598,8559,8,598,1,598,
  	1,598,1,598,1,598,1,598,1,598,1,598,1,598,1,598,1,598,1,598,1,598,1,598,
  	3,598,8574,8,598,1,598,3,598,8577,8,598,3,598,8579,8,598,1,599,1,599,
  	1,599,3,599,8584,8,599,1,599,1,599,1,599,1,599,1,599,1,599,1,599,3,599,
  	8593,8,599,1,599,3,599,8596,8,599,1,599,1,599,3,599,8600,8,599,1,600,
  	1,600,1,600,1,600,1,601,1,601,1,601,1,601,5,601,8610,8,601,10,601,12,
  	601,8613,9,601,1,601,1,601,1,602,1,602,1,602,1,602,1,602,1,602,1,602,
  	3,602,8624,8,602,1,602,1,602,1,602,3,602,8629,8,602,1,602,5,602,8632,
  	8,602,10,602,12,602,8635,9,602,1,602,1,602,1,602,1,602,5,602,8641,8,602,
  	10,602,12,602,8644,9,602,1,602,1,602,3,602,8648,8,602,1,603,1,603,1,603,
  	1,603,1,603,5,603,8655,8,603,10,603,12,603,8658,9,603,1,603,1,603,3,603,
  	8662,8,603,1,604,1,604,3,604,8666,8,604,1,604,1,604,3,604,8670,8,604,
  	1,604,1,604,3,604,8674,8,604,1,604,1,604,1,604,3,604,8679,8,604,1,604,
  	1,604,1,604,3,604,8684,8,604,1,604,1,604,1,604,1,604,3,604,8690,8,604,
  	1,604,1,604,1,604,3,604,8695,8,604,1,604,3,604,8698,8,604,1,605,1,605,
  	1,605,5,605,8703,8,605,10,605,12,605,8706,9,605,1,606,1,606,1,606,1,606,
  	5,606,8712,8,606,10,606,12,606,8715,9,606,1,606,1,606,1,607,1,607,3,607,
  	8721,8,607,1,608,1,608,1,608,1,608,1,609,1,609,1,609,1,610,3,610,8731,
  	8,610,1,610,1,610,1,611,1,611,1,611,1,611,1,611,3,611,8740,8,611,3,611,
  	8742,8,611,1,612,1,612,1,612,1,612,1,613,1,613,1,613,1,613,1,614,3,614,
  	8753,8,614,1,614,1,614,1,615,1,615,1,615,1,616,1,616,1,616,1,617,1,617,
  	3,617,8765,8,617,1,618,1,618,1,618,1,618,1,618,1,618,1,619,1,619,1,619,
  	5,619,8776,8,619,10,619,12,619,8779,9,619,1,620,1,620,1,620,5,620,8784,
  	8,620,10,620,12,620,8787,9,620,1,621,1,621,1,621,1,621,3,621,8793,8,621,
  	1,622,1,622,1,622,1,623,1,623,4,623,8800,8,623,11,623,12,623,8801,1,624,
  	1,624,1,624,1,624,3,624,8808,8,624,1,624,1,624,1,624,1,624,1,624,1,624,
  	3,624,8816,8,624,1,625,1,625,4,625,8820,8,625,11,625,12,625,8821,1,626,
  	1,626,1,626,1,626,1,627,1,627,1,627,5,627,8831,8,627,10,627,12,627,8834,
  	9,627,1,628,1,628,1,628,5,628,8839,8,628,10,628,12,628,8842,9,628,1,629,
  	1,629,1,629,1,629,3,629,8848,8,629,1,629,1,629,1,629,3,629,8853,8,629,
  	1,629,1,629,3,629,8857,8,629,1,630,1,630,1,630,1,630,3,630,8863,8,630,
  	1,631,1,631,1,631,1,631,1,631,1,631,1,631,1,631,1,631,3,631,8874,8,631,
  	1,632,1,632,1,632,1,632,3,632,8880,8,632,1,632,1,632,1,633,1,633,1,633,
  	1,633,1,633,1,634,1,634,1,634,1,634,1,635,1,635,1,635,1,635,1,635,1,635,
  	1,636,1,636,1,636,1,636,1,636,1,636,1,637,1,637,1,637,1,637,1,637,1,637,
  	1,637,1,638,1,638,1,638,1,638,1,638,3,638,8917,8,638,1,639,1,639,1,639,
  	1,639,1,640,1,640,1,640,1,640,1,641,1,641,1,641,1,641,1,641,1,641,1,641,
  	1,641,1,641,1,641,1,641,1,641,1,641,1,641,1,641,3,641,8942,8,641,1,642,
  	1,642,1,642,1,643,1,643,1,643,1,644,1,644,1,644,1,644,3,644,8954,8,644,
  	3,644,8956,8,644,1,645,1,645,1,645,3,645,8961,8,645,3,645,8963,8,645,
  	1,646,1,646,1,646,1,647,1,647,3,647,8970,8,647,1,648,1,648,1,649,1,649,
  	1,650,1,650,1,650,1,651,1,651,1,651,3,651,8982,8,651,3,651,8984,8,651,
  	1,652,1,652,1,652,1,652,3,652,8990,8,652,1,653,1,653,1,654,1,654,1,654,
  	1,654,5,654,8998,8,654,10,654,12,654,9001,9,654,1,654,1,654,1,655,1,655,
  	1,656,1,656,3,656,9009,8,656,1,657,1,657,1,658,1,658,1,659,1,659,1,659,
  	1,659,1,659,3,659,9020,8,659,1,659,1,659,1,660,1,660,1,661,1,661,1,662,
  	1,662,1,663,1,663,1,664,1,664,1,665,1,665,1,666,1,666,1,667,1,667,1,668,
  	1,668,3,668,9042,8,668,1,669,1,669,3,669,9046,8,669,1,670,1,670,1,671,
  	1,671,1,672,1,672,1,673,1,673,1,674,1,674,1,675,1,675,1,676,1,676,1,677,
  	1,677,1,678,1,678,1,679,1,679,1,680,1,680,3,680,9070,8,680,1,681,1,681,
  	1,681,1,682,1,682,1,682,1,682,1,682,1,682,3,682,9081,8,682,3,682,9083,
  	8,682,1,683,1,683,3,683,9087,8,683,1,684,1,684,1,684,5,684,9092,8,684,
  	10,684,12,684,9095,9,684,1,685,1,685,1,685,5,685,9100,8,685,10,685,12,
  	685,9103,9,685,1,686,1,686,1,687,1,687,3,687,9109,8,687,1,688,1,688,1,
  	689,1,689,3,689,9115,8,689,1,690,1,690,1,691,1,691,1,692,1,692,1,693,
  	1,693,1,694,1,694,1,694,3,694,9128,8,694,1,695,1,695,3,695,9132,8,695,
  	1,696,1,696,1,696,5,696,9137,8,696,10,696,12,696,9140,9,696,1,697,1,697,
  	1,697,1,697,1,698,1,698,3,698,9148,8,698,1,699,1,699,1,699,3,699,9153,
  	8,699,3,699,9155,8,699,1,699,1,699,1,699,1,699,3,699,9161,8,699,1,700,
  	1,700,1,700,1,701,1,701,1,702,1,702,1,703,1,703,1,704,1,704,1,704,1,704,
  	1,704,3,704,9177,8,704,1,705,1,705,1,705,1,705,1,705,3,705,9184,8,705,
  	1,706,1,706,1,706,3,706,9189,8,706,1,707,1,707,1,707,1,707,1,707,1,707,
  	3,707,9197,8,707,1,707,3,707,9200,8,707,1,708,1,708,1,708,3,708,9205,
  	8,708,1,709,1,709,1,710,1,710,1,710,1,710,5,710,9213,8,710,10,710,12,
  	710,9216,9,710,1,710,1,710,1,711,1,711,1,711,3,711,9223,8,711,1,712,1,
  	712,1,712,3,712,9228,8,712,1,713,1,713,1,713,3,713,9233,8,713,1,714,3,
  	714,9236,8,714,1,714,1,714,3,714,9240,8,714,1,714,5,714,9243,8,714,10,
  	714,12,714,9246,9,714,1,715,1,715,1,716,1,716,1,716,5,716,9253,8,716,
  	10,716,12,716,9256,9,716,1,717,1,717,1,717,3,717,9261,8,717,1,718,1,718,
  	1,719,1,719,1,720,1,720,1,721,1,721,1,721,1,721,1,721,1,721,3,721,9275,
  	8,721,1,722,1,722,3,722,9279,8,722,1,723,1,723,1,724,1,724,1,724,1,724,
  	1,724,1,724,1,725,1,725,3,725,9291,8,725,1,726,1,726,3,726,9295,8,726,
  	1,727,1,727,3,727,9299,8,727,1,728,1,728,3,728,9303,8,728,1,729,1,729,
  	1,729,1,730,1,730,1,731,1,731,1,731,1,731,1,731,1,731,1,731,3,731,9317,
  	8,731,1,732,1,732,1,732,1,732,1,732,1,732,3,732,9325,8,732,1,733,1,733,
  	1,733,1,733,1,733,1,733,1,733,3,733,9334,8,733,1,733,1,733,1,734,1,734,
  	1,735,1,735,1,735,1,735,1,735,1,735,1,735,1,735,3,735,9348,8,735,1,735,
  	1,735,1,735,1,735,1,735,3,735,9355,8,735,3,735,9357,8,735,1,736,1,736,
  	1,737,1,737,1,738,1,738,1,738,1,738,1,738,1,738,1,738,1,738,1,738,1,738,
  	1,738,3,738,9374,8,738,1,738,1,738,1,738,3,738,9379,8,738,3,738,9381,
  	8,738,1,739,1,739,1,740,1,740,1,740,1,740,1,740,3,740,9390,8,740,1,741,
  	1,741,1,741,3,741,9395,8,741,1,741,1,741,1,741,3,741,9400,8,741,3,741,
  	9402,8,741,1,742,1,742,1,742,1,742,3,742,9408,8,742,1,743,1,743,1,744,
  	1,744,1,744,1,744,1,744,3,744,9417,8,744,1,745,1,745,1,745,1,745,1,745,
  	1,745,1,745,1,745,1,745,1,745,1,745,3,745,9430,8,745,1,745,0,4,898,900,
  	908,910,746,0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,
  	42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,
  	88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,
  	126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,
  	162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,
  	198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,
  	234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,
  	270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,
  	306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,338,340,
  	342,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,376,
  	378,380,382,384,386,388,390,392,394,396,398,400,402,404,406,408,410,412,
  	414,416,418,420,422,424,426,428,430,432,434,436,438,440,442,444,446,448,
  	450,452,454,456,458,460,462,464,466,468,470,472,474,476,478,480,482,484,
  	486,488,490,492,494,496,498,500,502,504,506,508,510,512,514,516,518,520,
  	522,524,526,528,530,532,534,536,538,540,542,544,546,548,550,552,554,556,
  	558,560,562,564,566,568,570,572,574,576,578,580,582,584,586,588,590,592,
  	594,596,598,600,602,604,606,608,610,612,614,616,618,620,622,624,626,628,
  	630,632,634,636,638,640,642,644,646,648,650,652,654,656,658,660,662,664,
  	666,668,670,672,674,676,678,680,682,684,686,688,690,692,694,696,698,700,
  	702,704,706,708,710,712,714,716,718,720,722,724,726,728,730,732,734,736,
  	738,740,742,744,746,748,750,752,754,756,758,760,762,764,766,768,770,772,
  	774,776,778,780,782,784,786,788,790,792,794,796,798,800,802,804,806,808,
  	810,812,814,816,818,820,822,824,826,828,830,832,834,836,838,840,842,844,
  	846,848,850,852,854,856,858,860,862,864,866,868,870,872,874,876,878,880,
  	882,884,886,888,890,892,894,896,898,900,902,904,906,908,910,912,914,916,
  	918,920,922,924,926,928,930,932,934,936,938,940,942,944,946,948,950,952,
  	954,956,958,960,962,964,966,968,970,972,974,976,978,980,982,984,986,988,
  	990,992,994,996,998,1000,1002,1004,1006,1008,1010,1012,1014,1016,1018,
  	1020,1022,1024,1026,1028,1030,1032,1034,1036,1038,1040,1042,1044,1046,
  	1048,1050,1052,1054,1056,1058,1060,1062,1064,1066,1068,1070,1072,1074,
  	1076,1078,1080,1082,1084,1086,1088,1090,1092,1094,1096,1098,1100,1102,
  	1104,1106,1108,1110,1112,1114,1116,1118,1120,1122,1124,1126,1128,1130,
  	1132,1134,1136,1138,1140,1142,1144,1146,1148,1150,1152,1154,1156,1158,
  	1160,1162,1164,1166,1168,1170,1172,1174,1176,1178,1180,1182,1184,1186,
  	1188,1190,1192,1194,1196,1198,1200,1202,1204,1206,1208,1210,1212,1214,
  	1216,1218,1220,1222,1224,1226,1228,1230,1232,1234,1236,1238,1240,1242,
  	1244,1246,1248,1250,1252,1254,1256,1258,1260,1262,1264,1266,1268,1270,
  	1272,1274,1276,1278,1280,1282,1284,1286,1288,1290,1292,1294,1296,1298,
  	1300,1302,1304,1306,1308,1310,1312,1314,1316,1318,1320,1322,1324,1326,
  	1328,1330,1332,1334,1336,1338,1340,1342,1344,1346,1348,1350,1352,1354,
  	1356,1358,1360,1362,1364,1366,1368,1370,1372,1374,1376,1378,1380,1382,
  	1384,1386,1388,1390,1392,1394,1396,1398,1400,1402,1404,1406,1408,1410,
  	1412,1414,1416,1418,1420,1422,1424,1426,1428,1430,1432,1434,1436,1438,
  	1440,1442,1444,1446,1448,1450,1452,1454,1456,1458,1460,1462,1464,1466,
  	1468,1470,1472,1474,1476,1478,1480,1482,1484,1486,1488,1490,0,174,1,0,
  	747,748,2,0,63,63,616,616,2,0,94,94,501,501,1,0,670,671,2,0,50,50,187,
  	187,1,0,749,750,2,0,95,95,316,316,2,0,180,180,195,195,2,0,268,268,488,
  	488,4,0,166,166,284,284,467,467,582,582,2,0,170,170,285,285,2,0,471,471,
  	630,630,2,0,404,404,663,663,3,0,367,367,604,604,628,628,2,0,52,52,73,
  	73,3,0,173,173,278,278,640,640,2,0,233,233,445,445,2,0,597,597,600,600,
  	3,0,268,268,327,327,461,461,2,0,229,229,397,397,4,0,229,229,302,302,397,
  	397,449,449,2,0,6,6,9,12,3,0,171,171,259,259,327,327,1,0,652,653,2,0,
  	154,154,678,678,2,0,126,126,327,327,2,0,822,822,828,828,2,0,312,312,513,
  	513,2,0,171,171,327,327,2,0,688,688,820,820,7,0,56,56,183,183,259,259,
  	557,558,560,560,562,562,581,581,2,0,29,29,411,411,2,0,3,5,42,42,3,0,462,
  	462,513,513,708,708,2,0,142,142,510,510,2,0,64,64,174,174,2,0,306,306,
  	508,508,2,0,141,141,275,275,2,0,56,56,183,183,2,0,234,234,268,268,2,0,
  	272,272,299,299,2,0,416,416,674,674,2,0,74,74,569,569,2,0,295,295,502,
  	502,2,0,77,77,348,348,2,0,328,328,783,783,2,0,332,332,789,789,2,0,329,
  	329,784,784,2,0,350,350,807,807,2,0,335,335,792,792,2,0,336,336,793,793,
  	2,0,330,330,786,786,2,0,337,337,795,795,2,0,331,331,787,787,2,0,346,346,
  	796,796,2,0,340,340,797,797,2,0,339,339,798,798,2,0,342,342,800,800,2,
  	0,343,343,801,801,2,0,344,344,802,802,2,0,345,345,803,803,2,0,347,347,
  	804,804,2,0,349,349,806,806,2,0,763,763,805,805,2,0,341,341,799,799,2,
  	0,737,737,794,794,2,0,738,738,782,782,2,0,351,351,788,788,2,0,760,760,
  	785,785,2,0,761,761,808,808,3,0,413,413,768,769,823,823,2,0,333,333,790,
  	790,2,0,334,334,791,791,2,0,554,554,556,556,2,0,479,479,564,564,2,0,541,
  	541,779,779,2,0,164,164,187,187,3,0,399,399,565,565,675,675,2,0,319,319,
  	637,637,2,0,168,168,744,744,3,0,242,242,452,452,600,600,4,0,278,278,473,
  	473,524,524,640,640,13,0,173,173,187,187,209,209,212,212,226,226,272,
  	272,453,453,457,457,481,481,537,537,591,591,620,620,642,642,4,0,512,512,
  	598,598,644,644,661,661,2,0,140,140,187,187,2,0,168,168,399,399,2,0,219,
  	219,461,461,5,0,101,101,219,219,223,223,365,365,461,461,3,0,219,219,461,
  	461,645,645,2,0,250,250,683,683,2,0,120,120,627,627,2,0,239,239,286,286,
  	2,0,271,272,297,297,6,0,56,56,139,139,290,290,366,366,548,548,593,593,
  	2,0,128,128,460,460,5,0,176,176,261,261,451,451,573,573,643,643,5,0,77,
  	77,202,202,204,204,244,244,542,542,2,0,644,644,735,735,2,0,174,175,217,
  	217,3,0,222,222,622,622,636,636,2,0,23,23,61,61,2,0,26,26,424,424,2,0,
  	56,56,62,62,2,0,6,6,8,13,3,0,16,18,184,184,380,380,1,0,14,15,1,0,21,22,
  	2,0,14,15,20,20,2,0,80,81,83,83,2,0,358,358,376,376,5,0,574,574,577,577,
  	590,590,657,657,660,660,4,0,703,704,717,717,719,719,721,721,2,0,709,709,
  	711,711,2,0,706,706,710,710,2,0,229,229,302,302,2,0,268,268,720,720,2,
  	0,51,51,584,584,1,0,156,157,1,0,610,611,4,0,155,155,158,158,609,609,612,
  	612,4,0,247,247,313,313,382,384,441,442,2,0,1,1,401,401,2,0,1,1,19,19,
  	5,0,159,162,262,264,372,373,521,521,680,680,9,0,163,163,265,265,369,369,
  	374,374,381,381,459,459,522,522,665,665,681,681,3,0,136,136,214,214,631,
  	631,2,0,144,144,566,566,2,0,407,407,514,514,10,0,98,98,108,108,117,117,
  	131,133,149,149,368,368,386,386,520,520,583,583,602,602,2,0,580,580,662,
  	662,3,0,168,168,191,191,230,230,3,0,168,168,182,182,366,366,3,0,240,240,
  	432,432,540,540,3,0,89,89,256,256,517,517,1,0,686,687,2,0,625,625,647,
  	647,5,0,76,76,284,284,363,363,543,543,614,614,3,0,166,166,230,231,408,
  	408,1,0,86,87,2,0,322,322,362,362,4,0,247,248,313,313,382,384,441,442,
  	3,0,539,539,638,638,682,682,1,0,570,572,2,0,105,105,601,601,6,0,122,122,
  	124,124,168,168,191,191,230,230,472,472,3,0,229,229,302,302,403,403,2,
  	0,182,182,366,366,2,0,314,314,462,462,2,0,355,355,375,375,2,0,154,154,
  	272,272,3,0,276,276,286,286,427,427,2,0,567,567,605,605,2,0,410,410,415,
  	415,2,0,316,316,405,405,2,0,832,832,834,834,3,0,3,5,43,43,45,46,2,0,3,
  	5,43,43,2,0,3,5,45,46,1,0,43,44,2,0,222,222,622,622,2,0,41,41,406,406,
  	1,0,3,5,1,0,6,7,3,0,212,212,537,537,739,739,32,0,65,65,74,74,91,92,103,
  	103,105,105,119,119,121,121,134,134,164,164,186,186,198,198,232,233,255,
  	255,258,258,270,270,281,281,301,301,403,403,445,445,447,447,485,485,498,
  	498,509,509,518,518,539,539,541,541,569,569,578,578,623,623,632,633,676,
  	676,702,702,9,0,209,209,226,226,399,399,453,453,457,457,481,481,489,489,
  	591,591,734,734,160,0,48,49,51,55,58,58,62,62,67,72,78,78,82,82,85,87,
  	89,89,95,95,98,99,101,102,107,112,114,115,117,118,120,120,122,126,128,
  	129,131,133,135,135,139,139,144,144,149,149,153,155,158,158,163,163,169,
  	170,172,172,178,182,189,191,195,195,197,197,199,199,201,205,207,208,210,
  	211,215,216,218,220,223,224,227,230,237,238,240,240,244,244,246,249,252,
  	252,256,256,260,261,265,266,269,269,271,271,274,274,279,280,285,285,289,
  	290,292,293,296,296,298,298,302,302,304,304,307,308,313,314,318,318,320,
  	321,328,328,330,346,348,351,353,356,359,360,365,369,371,371,374,375,377,
  	377,379,379,381,389,392,393,395,398,404,404,407,407,409,409,411,411,414,
  	414,416,417,420,420,428,434,436,443,448,449,451,451,454,456,459,461,464,
  	464,468,469,471,472,475,479,482,482,484,484,486,486,490,496,500,500,502,
  	504,506,506,510,512,514,515,517,517,519,520,522,523,527,528,530,530,535,
  	535,540,540,542,542,544,548,554,556,558,558,561,561,564,564,566,566,568,
  	568,570,573,579,579,582,587,592,594,597,598,601,604,606,607,609,612,618,
  	619,624,625,627,630,636,636,639,639,641,641,643,645,651,651,653,653,656,
  	656,661,661,663,666,671,673,675,675,677,678,681,681,684,687,689,689,694,
  	696,699,700,705,705,707,707,714,715,718,718,720,720,722,723,727,733,736,
  	738,740,750,752,755,757,757,760,763,770,773,775,777,779,819,4,0,609,609,
  	612,612,756,756,758,769,3,0,821,821,823,826,828,828,5,0,250,250,316,316,
  	529,529,683,683,698,698,54,0,48,48,58,58,65,65,72,72,74,74,91,92,103,
  	103,105,105,110,110,119,119,121,121,134,134,164,164,186,186,198,198,232,
  	233,237,237,246,246,255,255,258,258,260,260,281,281,301,301,403,403,417,
  	417,420,420,428,428,431,431,435,435,443,443,445,445,447,447,482,482,485,
  	485,498,498,500,500,509,509,518,518,523,523,530,530,539,539,541,541,545,
  	546,569,569,578,578,623,623,632,633,641,641,673,673,676,676,684,684,686,
  	687,702,702,745,748,154,0,49,49,51,55,59,59,62,62,67,71,78,78,82,82,85,
  	87,89,89,95,95,98,99,101,102,107,109,111,112,114,115,117,118,120,120,
  	122,126,128,129,131,133,135,135,139,139,144,144,149,149,153,155,158,158,
  	163,163,169,170,172,172,176,176,178,182,189,191,195,195,197,197,199,199,
  	201,205,207,208,210,210,215,215,218,220,223,224,227,230,238,238,240,240,
  	244,244,247,250,252,252,256,256,261,261,265,266,269,269,271,271,274,274,
  	279,280,285,285,289,290,292,293,296,296,298,298,302,302,304,304,307,308,
  	313,314,316,316,318,318,320,321,328,328,330,337,339,346,348,351,353,357,
  	359,360,365,369,371,371,374,375,377,377,379,379,381,389,392,393,395,398,
  	404,404,407,407,409,409,411,412,414,414,429,430,432,434,436,442,448,449,
  	451,451,454,456,459,461,464,464,468,472,475,479,484,484,486,486,490,496,
  	502,504,506,506,510,512,514,515,517,517,519,520,522,522,527,529,535,535,
  	540,540,542,542,544,544,547,548,554,556,558,559,561,561,564,564,566,566,
  	568,568,570,573,579,579,582,587,591,594,597,598,601,604,606,607,609,612,
  	618,619,624,630,636,636,639,639,643,645,653,653,656,656,661,661,663,666,
  	672,672,675,675,677,678,681,681,689,689,694,696,699,701,705,705,707,707,
  	714,715,718,718,720,720,722,723,727,733,736,737,741,742,744,744,749,750,
  	752,753,774,774,5,0,142,142,242,242,270,270,513,513,516,516,6,0,211,211,
  	216,216,416,416,591,591,651,651,671,671,10536,0,1499,1,0,0,0,2,1583,1,
  	0,0,0,4,1585,1,0,0,0,6,1608,1,0,0,0,8,1629,1,0,0,0,10,1632,1,0,0,0,12,
  	1670,1,0,0,0,14,1679,1,0,0,0,16,1692,1,0,0,0,18,1694,1,0,0,0,20,1699,
  	1,0,0,0,22,1719,1,0,0,0,24,1728,1,0,0,0,26,1730,1,0,0,0,28,1745,1,0,0,
  	0,30,1843,1,0,0,0,32,1847,1,0,0,0,34,1863,1,0,0,0,36,2005,1,0,0,0,38,
  	2010,1,0,0,0,40,2012,1,0,0,0,42,2014,1,0,0,0,44,2028,1,0,0,0,46,2036,
  	1,0,0,0,48,2052,1,0,0,0,50,2054,1,0,0,0,52,2058,1,0,0,0,54,2063,1,0,0,
  	0,56,2065,1,0,0,0,58,2080,1,0,0,0,60,2088,1,0,0,0,62,2098,1,0,0,0,64,
  	2100,1,0,0,0,66,2122,1,0,0,0,68,2131,1,0,0,0,70,2134,1,0,0,0,72,2147,
  	1,0,0,0,74,2152,1,0,0,0,76,2156,1,0,0,0,78,2196,1,0,0,0,80,2198,1,0,0,
  	0,82,2219,1,0,0,0,84,2234,1,0,0,0,86,2237,1,0,0,0,88,2262,1,0,0,0,90,
  	2272,1,0,0,0,92,2275,1,0,0,0,94,2280,1,0,0,0,96,2289,1,0,0,0,98,2291,
  	1,0,0,0,100,2295,1,0,0,0,102,2307,1,0,0,0,104,2337,1,0,0,0,106,2343,1,
  	0,0,0,108,2346,1,0,0,0,110,2377,1,0,0,0,112,2395,1,0,0,0,114,2398,1,0,
  	0,0,116,2423,1,0,0,0,118,2426,1,0,0,0,120,2478,1,0,0,0,122,2480,1,0,0,
  	0,124,2484,1,0,0,0,126,2493,1,0,0,0,128,2509,1,0,0,0,130,2511,1,0,0,0,
  	132,2519,1,0,0,0,134,2545,1,0,0,0,136,2547,1,0,0,0,138,2559,1,0,0,0,140,
  	2574,1,0,0,0,142,2576,1,0,0,0,144,2579,1,0,0,0,146,2601,1,0,0,0,148,2603,
  	1,0,0,0,150,2609,1,0,0,0,152,2615,1,0,0,0,154,2621,1,0,0,0,156,2627,1,
  	0,0,0,158,2633,1,0,0,0,160,2640,1,0,0,0,162,2648,1,0,0,0,164,2650,1,0,
  	0,0,166,2656,1,0,0,0,168,2662,1,0,0,0,170,2668,1,0,0,0,172,2675,1,0,0,
  	0,174,2693,1,0,0,0,176,2695,1,0,0,0,178,2699,1,0,0,0,180,2704,1,0,0,0,
  	182,2724,1,0,0,0,184,2728,1,0,0,0,186,2761,1,0,0,0,188,2792,1,0,0,0,190,
  	2809,1,0,0,0,192,2811,1,0,0,0,194,2831,1,0,0,0,196,2837,1,0,0,0,198,2843,
  	1,0,0,0,200,2849,1,0,0,0,202,2856,1,0,0,0,204,2865,1,0,0,0,206,2882,1,
  	0,0,0,208,2884,1,0,0,0,210,2891,1,0,0,0,212,2901,1,0,0,0,214,2915,1,0,
  	0,0,216,2921,1,0,0,0,218,2929,1,0,0,0,220,2935,1,0,0,0,222,2943,1,0,0,
  	0,224,2949,1,0,0,0,226,2959,1,0,0,0,228,2963,1,0,0,0,230,2969,1,0,0,0,
  	232,2974,1,0,0,0,234,2985,1,0,0,0,236,3028,1,0,0,0,238,3033,1,0,0,0,240,
  	3035,1,0,0,0,242,3042,1,0,0,0,244,3072,1,0,0,0,246,3074,1,0,0,0,248,3103,
  	1,0,0,0,250,3110,1,0,0,0,252,3114,1,0,0,0,254,3122,1,0,0,0,256,3135,1,
  	0,0,0,258,3137,1,0,0,0,260,3155,1,0,0,0,262,3167,1,0,0,0,264,3173,1,0,
  	0,0,266,3179,1,0,0,0,268,3231,1,0,0,0,270,3233,1,0,0,0,272,3235,1,0,0,
  	0,274,3241,1,0,0,0,276,3243,1,0,0,0,278,3251,1,0,0,0,280,3257,1,0,0,0,
  	282,3265,1,0,0,0,284,3274,1,0,0,0,286,3282,1,0,0,0,288,3294,1,0,0,0,290,
  	3299,1,0,0,0,292,3304,1,0,0,0,294,3309,1,0,0,0,296,3331,1,0,0,0,298,3350,
  	1,0,0,0,300,3354,1,0,0,0,302,3369,1,0,0,0,304,3385,1,0,0,0,306,3397,1,
  	0,0,0,308,3399,1,0,0,0,310,3426,1,0,0,0,312,3428,1,0,0,0,314,3430,1,0,
  	0,0,316,3433,1,0,0,0,318,3436,1,0,0,0,320,3443,1,0,0,0,322,3445,1,0,0,
  	0,324,3475,1,0,0,0,326,3487,1,0,0,0,328,3490,1,0,0,0,330,3499,1,0,0,0,
  	332,3503,1,0,0,0,334,3508,1,0,0,0,336,3521,1,0,0,0,338,3526,1,0,0,0,340,
  	3530,1,0,0,0,342,3546,1,0,0,0,344,3548,1,0,0,0,346,3566,1,0,0,0,348,3568,
  	1,0,0,0,350,3577,1,0,0,0,352,3589,1,0,0,0,354,3610,1,0,0,0,356,3617,1,
  	0,0,0,358,3619,1,0,0,0,360,3623,1,0,0,0,362,3625,1,0,0,0,364,3630,1,0,
  	0,0,366,3638,1,0,0,0,368,3647,1,0,0,0,370,3650,1,0,0,0,372,3665,1,0,0,
  	0,374,3667,1,0,0,0,376,3688,1,0,0,0,378,3693,1,0,0,0,380,3698,1,0,0,0,
  	382,3702,1,0,0,0,384,3716,1,0,0,0,386,3719,1,0,0,0,388,3725,1,0,0,0,390,
  	3738,1,0,0,0,392,3746,1,0,0,0,394,3772,1,0,0,0,396,3785,1,0,0,0,398,3792,
  	1,0,0,0,400,3794,1,0,0,0,402,3806,1,0,0,0,404,3808,1,0,0,0,406,3818,1,
  	0,0,0,408,3842,1,0,0,0,410,3844,1,0,0,0,412,3851,1,0,0,0,414,3861,1,0,
  	0,0,416,3896,1,0,0,0,418,3903,1,0,0,0,420,3909,1,0,0,0,422,3911,1,0,0,
  	0,424,3915,1,0,0,0,426,3923,1,0,0,0,428,3925,1,0,0,0,430,3930,1,0,0,0,
  	432,3934,1,0,0,0,434,3962,1,0,0,0,436,3964,1,0,0,0,438,3966,1,0,0,0,440,
  	3974,1,0,0,0,442,3976,1,0,0,0,444,3984,1,0,0,0,446,3994,1,0,0,0,448,3998,
  	1,0,0,0,450,4023,1,0,0,0,452,4050,1,0,0,0,454,4052,1,0,0,0,456,4061,1,
  	0,0,0,458,4092,1,0,0,0,460,4116,1,0,0,0,462,4118,1,0,0,0,464,4132,1,0,
  	0,0,466,4134,1,0,0,0,468,4169,1,0,0,0,470,4171,1,0,0,0,472,4204,1,0,0,
  	0,474,4206,1,0,0,0,476,4228,1,0,0,0,478,4236,1,0,0,0,480,4238,1,0,0,0,
  	482,4242,1,0,0,0,484,4255,1,0,0,0,486,4257,1,0,0,0,488,4264,1,0,0,0,490,
  	4400,1,0,0,0,492,4402,1,0,0,0,494,4404,1,0,0,0,496,4406,1,0,0,0,498,4408,
  	1,0,0,0,500,4410,1,0,0,0,502,4412,1,0,0,0,504,4414,1,0,0,0,506,4416,1,
  	0,0,0,508,4418,1,0,0,0,510,4420,1,0,0,0,512,4422,1,0,0,0,514,4424,1,0,
  	0,0,516,4426,1,0,0,0,518,4428,1,0,0,0,520,4430,1,0,0,0,522,4432,1,0,0,
  	0,524,4434,1,0,0,0,526,4436,1,0,0,0,528,4438,1,0,0,0,530,4440,1,0,0,0,
  	532,4442,1,0,0,0,534,4444,1,0,0,0,536,4446,1,0,0,0,538,4448,1,0,0,0,540,
  	4450,1,0,0,0,542,4454,1,0,0,0,544,4456,1,0,0,0,546,4461,1,0,0,0,548,4465,
  	1,0,0,0,550,4481,1,0,0,0,552,4483,1,0,0,0,554,4485,1,0,0,0,556,4487,1,
  	0,0,0,558,4500,1,0,0,0,560,4564,1,0,0,0,562,4566,1,0,0,0,564,4574,1,0,
  	0,0,566,4582,1,0,0,0,568,4590,1,0,0,0,570,4592,1,0,0,0,572,4600,1,0,0,
  	0,574,4624,1,0,0,0,576,4637,1,0,0,0,578,4646,1,0,0,0,580,4650,1,0,0,0,
  	582,4654,1,0,0,0,584,4658,1,0,0,0,586,4662,1,0,0,0,588,4670,1,0,0,0,590,
  	4680,1,0,0,0,592,4682,1,0,0,0,594,4693,1,0,0,0,596,4695,1,0,0,0,598,4699,
  	1,0,0,0,600,4703,1,0,0,0,602,4707,1,0,0,0,604,4720,1,0,0,0,606,4722,1,
  	0,0,0,608,4728,1,0,0,0,610,4736,1,0,0,0,612,4773,1,0,0,0,614,4775,1,0,
  	0,0,616,4789,1,0,0,0,618,4791,1,0,0,0,620,4848,1,0,0,0,622,4934,1,0,0,
  	0,624,4993,1,0,0,0,626,4995,1,0,0,0,628,4998,1,0,0,0,630,5026,1,0,0,0,
  	632,5032,1,0,0,0,634,5041,1,0,0,0,636,5043,1,0,0,0,638,5048,1,0,0,0,640,
  	5103,1,0,0,0,642,5105,1,0,0,0,644,5113,1,0,0,0,646,5162,1,0,0,0,648,5164,
  	1,0,0,0,650,5167,1,0,0,0,652,5170,1,0,0,0,654,5181,1,0,0,0,656,5186,1,
  	0,0,0,658,5189,1,0,0,0,660,5204,1,0,0,0,662,5252,1,0,0,0,664,5254,1,0,
  	0,0,666,5306,1,0,0,0,668,5324,1,0,0,0,670,5326,1,0,0,0,672,5342,1,0,0,
  	0,674,5357,1,0,0,0,676,5382,1,0,0,0,678,5384,1,0,0,0,680,5392,1,0,0,0,
  	682,5443,1,0,0,0,684,5462,1,0,0,0,686,5467,1,0,0,0,688,5469,1,0,0,0,690,
  	5471,1,0,0,0,692,5485,1,0,0,0,694,5498,1,0,0,0,696,5502,1,0,0,0,698,5504,
  	1,0,0,0,700,5509,1,0,0,0,702,5519,1,0,0,0,704,5578,1,0,0,0,706,5589,1,
  	0,0,0,708,5591,1,0,0,0,710,5594,1,0,0,0,712,5607,1,0,0,0,714,5640,1,0,
  	0,0,716,5648,1,0,0,0,718,5655,1,0,0,0,720,5657,1,0,0,0,722,5670,1,0,0,
  	0,724,5672,1,0,0,0,726,5677,1,0,0,0,728,5688,1,0,0,0,730,5699,1,0,0,0,
  	732,5707,1,0,0,0,734,5716,1,0,0,0,736,5725,1,0,0,0,738,5730,1,0,0,0,740,
  	5733,1,0,0,0,742,5738,1,0,0,0,744,5743,1,0,0,0,746,5748,1,0,0,0,748,5761,
  	1,0,0,0,750,5765,1,0,0,0,752,5770,1,0,0,0,754,5776,1,0,0,0,756,5793,1,
  	0,0,0,758,5810,1,0,0,0,760,5824,1,0,0,0,762,5830,1,0,0,0,764,5837,1,0,
  	0,0,766,5844,1,0,0,0,768,5849,1,0,0,0,770,5854,1,0,0,0,772,5857,1,0,0,
  	0,774,5870,1,0,0,0,776,5878,1,0,0,0,778,5884,1,0,0,0,780,5892,1,0,0,0,
  	782,5897,1,0,0,0,784,5902,1,0,0,0,786,5905,1,0,0,0,788,5915,1,0,0,0,790,
  	5923,1,0,0,0,792,5928,1,0,0,0,794,5933,1,0,0,0,796,5937,1,0,0,0,798,5947,
  	1,0,0,0,800,5952,1,0,0,0,802,5957,1,0,0,0,804,5962,1,0,0,0,806,5969,1,
  	0,0,0,808,5976,1,0,0,0,810,5982,1,0,0,0,812,5988,1,0,0,0,814,5993,1,0,
  	0,0,816,6004,1,0,0,0,818,6008,1,0,0,0,820,6010,1,0,0,0,822,6012,1,0,0,
  	0,824,6015,1,0,0,0,826,6030,1,0,0,0,828,6069,1,0,0,0,830,6073,1,0,0,0,
  	832,6075,1,0,0,0,834,6083,1,0,0,0,836,6087,1,0,0,0,838,6095,1,0,0,0,840,
  	6104,1,0,0,0,842,6106,1,0,0,0,844,6129,1,0,0,0,846,6131,1,0,0,0,848,6133,
  	1,0,0,0,850,6148,1,0,0,0,852,6160,1,0,0,0,854,6162,1,0,0,0,856,6170,1,
  	0,0,0,858,6178,1,0,0,0,860,6187,1,0,0,0,862,6189,1,0,0,0,864,6207,1,0,
  	0,0,866,6221,1,0,0,0,868,6226,1,0,0,0,870,6232,1,0,0,0,872,6234,1,0,0,
  	0,874,6250,1,0,0,0,876,6258,1,0,0,0,878,6268,1,0,0,0,880,6281,1,0,0,0,
  	882,6283,1,0,0,0,884,6289,1,0,0,0,886,6319,1,0,0,0,888,6329,1,0,0,0,890,
  	6331,1,0,0,0,892,6335,1,0,0,0,894,6338,1,0,0,0,896,6341,1,0,0,0,898,6354,
  	1,0,0,0,900,6370,1,0,0,0,902,6393,1,0,0,0,904,6395,1,0,0,0,906,6432,1,
  	0,0,0,908,6434,1,0,0,0,910,6591,1,0,0,0,912,6604,1,0,0,0,914,6613,1,0,
  	0,0,916,6709,1,0,0,0,918,6711,1,0,0,0,920,6765,1,0,0,0,922,6767,1,0,0,
  	0,924,6772,1,0,0,0,926,6785,1,0,0,0,928,6790,1,0,0,0,930,6792,1,0,0,0,
  	932,6811,1,0,0,0,934,6814,1,0,0,0,936,6823,1,0,0,0,938,6825,1,0,0,0,940,
  	6848,1,0,0,0,942,7138,1,0,0,0,944,7140,1,0,0,0,946,7174,1,0,0,0,948,7176,
  	1,0,0,0,950,7182,1,0,0,0,952,7184,1,0,0,0,954,7199,1,0,0,0,956,7207,1,
  	0,0,0,958,7209,1,0,0,0,960,7238,1,0,0,0,962,7271,1,0,0,0,964,7273,1,0,
  	0,0,966,7281,1,0,0,0,968,7285,1,0,0,0,970,7290,1,0,0,0,972,7292,1,0,0,
  	0,974,7303,1,0,0,0,976,7318,1,0,0,0,978,7320,1,0,0,0,980,7324,1,0,0,0,
  	982,7327,1,0,0,0,984,7330,1,0,0,0,986,7382,1,0,0,0,988,7384,1,0,0,0,990,
  	7395,1,0,0,0,992,7397,1,0,0,0,994,7399,1,0,0,0,996,7403,1,0,0,0,998,7405,
  	1,0,0,0,1000,7407,1,0,0,0,1002,7411,1,0,0,0,1004,7415,1,0,0,0,1006,7419,
  	1,0,0,0,1008,7427,1,0,0,0,1010,7431,1,0,0,0,1012,7439,1,0,0,0,1014,7441,
  	1,0,0,0,1016,7459,1,0,0,0,1018,7461,1,0,0,0,1020,7464,1,0,0,0,1022,7469,
  	1,0,0,0,1024,7477,1,0,0,0,1026,7483,1,0,0,0,1028,7487,1,0,0,0,1030,7504,
  	1,0,0,0,1032,7507,1,0,0,0,1034,7512,1,0,0,0,1036,7514,1,0,0,0,1038,7517,
  	1,0,0,0,1040,7526,1,0,0,0,1042,7534,1,0,0,0,1044,7536,1,0,0,0,1046,7541,
  	1,0,0,0,1048,7548,1,0,0,0,1050,7558,1,0,0,0,1052,7566,1,0,0,0,1054,7568,
  	1,0,0,0,1056,7578,1,0,0,0,1058,7586,1,0,0,0,1060,7588,1,0,0,0,1062,7594,
  	1,0,0,0,1064,7615,1,0,0,0,1066,7617,1,0,0,0,1068,7623,1,0,0,0,1070,7626,
  	1,0,0,0,1072,7629,1,0,0,0,1074,7657,1,0,0,0,1076,7661,1,0,0,0,1078,7668,
  	1,0,0,0,1080,7675,1,0,0,0,1082,7677,1,0,0,0,1084,7693,1,0,0,0,1086,7709,
  	1,0,0,0,1088,7713,1,0,0,0,1090,7716,1,0,0,0,1092,7719,1,0,0,0,1094,7743,
  	1,0,0,0,1096,7745,1,0,0,0,1098,7753,1,0,0,0,1100,7755,1,0,0,0,1102,7758,
  	1,0,0,0,1104,7838,1,0,0,0,1106,7840,1,0,0,0,1108,7844,1,0,0,0,1110,7944,
  	1,0,0,0,1112,7946,1,0,0,0,1114,7948,1,0,0,0,1116,7950,1,0,0,0,1118,7955,
  	1,0,0,0,1120,7971,1,0,0,0,1122,7973,1,0,0,0,1124,8007,1,0,0,0,1126,8009,
  	1,0,0,0,1128,8020,1,0,0,0,1130,8027,1,0,0,0,1132,8044,1,0,0,0,1134,8046,
  	1,0,0,0,1136,8050,1,0,0,0,1138,8073,1,0,0,0,1140,8075,1,0,0,0,1142,8077,
  	1,0,0,0,1144,8084,1,0,0,0,1146,8086,1,0,0,0,1148,8088,1,0,0,0,1150,8238,
  	1,0,0,0,1152,8243,1,0,0,0,1154,8250,1,0,0,0,1156,8252,1,0,0,0,1158,8260,
  	1,0,0,0,1160,8278,1,0,0,0,1162,8286,1,0,0,0,1164,8294,1,0,0,0,1166,8296,
  	1,0,0,0,1168,8300,1,0,0,0,1170,8309,1,0,0,0,1172,8315,1,0,0,0,1174,8322,
  	1,0,0,0,1176,8324,1,0,0,0,1178,8339,1,0,0,0,1180,8346,1,0,0,0,1182,8349,
  	1,0,0,0,1184,8499,1,0,0,0,1186,8503,1,0,0,0,1188,8506,1,0,0,0,1190,8515,
  	1,0,0,0,1192,8524,1,0,0,0,1194,8532,1,0,0,0,1196,8578,1,0,0,0,1198,8580,
  	1,0,0,0,1200,8601,1,0,0,0,1202,8605,1,0,0,0,1204,8616,1,0,0,0,1206,8661,
  	1,0,0,0,1208,8697,1,0,0,0,1210,8699,1,0,0,0,1212,8707,1,0,0,0,1214,8720,
  	1,0,0,0,1216,8722,1,0,0,0,1218,8726,1,0,0,0,1220,8730,1,0,0,0,1222,8741,
  	1,0,0,0,1224,8743,1,0,0,0,1226,8747,1,0,0,0,1228,8752,1,0,0,0,1230,8756,
  	1,0,0,0,1232,8759,1,0,0,0,1234,8762,1,0,0,0,1236,8766,1,0,0,0,1238,8772,
  	1,0,0,0,1240,8780,1,0,0,0,1242,8788,1,0,0,0,1244,8794,1,0,0,0,1246,8797,
  	1,0,0,0,1248,8815,1,0,0,0,1250,8817,1,0,0,0,1252,8823,1,0,0,0,1254,8827,
  	1,0,0,0,1256,8835,1,0,0,0,1258,8843,1,0,0,0,1260,8858,1,0,0,0,1262,8873,
  	1,0,0,0,1264,8875,1,0,0,0,1266,8883,1,0,0,0,1268,8888,1,0,0,0,1270,8892,
  	1,0,0,0,1272,8898,1,0,0,0,1274,8904,1,0,0,0,1276,8911,1,0,0,0,1278,8918,
  	1,0,0,0,1280,8922,1,0,0,0,1282,8941,1,0,0,0,1284,8943,1,0,0,0,1286,8946,
  	1,0,0,0,1288,8949,1,0,0,0,1290,8962,1,0,0,0,1292,8964,1,0,0,0,1294,8969,
  	1,0,0,0,1296,8971,1,0,0,0,1298,8973,1,0,0,0,1300,8975,1,0,0,0,1302,8983,
  	1,0,0,0,1304,8989,1,0,0,0,1306,8991,1,0,0,0,1308,8993,1,0,0,0,1310,9004,
  	1,0,0,0,1312,9008,1,0,0,0,1314,9010,1,0,0,0,1316,9012,1,0,0,0,1318,9014,
  	1,0,0,0,1320,9023,1,0,0,0,1322,9025,1,0,0,0,1324,9027,1,0,0,0,1326,9029,
  	1,0,0,0,1328,9031,1,0,0,0,1330,9033,1,0,0,0,1332,9035,1,0,0,0,1334,9037,
  	1,0,0,0,1336,9041,1,0,0,0,1338,9045,1,0,0,0,1340,9047,1,0,0,0,1342,9049,
  	1,0,0,0,1344,9051,1,0,0,0,1346,9053,1,0,0,0,1348,9055,1,0,0,0,1350,9057,
  	1,0,0,0,1352,9059,1,0,0,0,1354,9061,1,0,0,0,1356,9063,1,0,0,0,1358,9065,
  	1,0,0,0,1360,9069,1,0,0,0,1362,9071,1,0,0,0,1364,9074,1,0,0,0,1366,9086,
  	1,0,0,0,1368,9088,1,0,0,0,1370,9096,1,0,0,0,1372,9104,1,0,0,0,1374,9108,
  	1,0,0,0,1376,9110,1,0,0,0,1378,9114,1,0,0,0,1380,9116,1,0,0,0,1382,9118,
  	1,0,0,0,1384,9120,1,0,0,0,1386,9122,1,0,0,0,1388,9127,1,0,0,0,1390,9131,
  	1,0,0,0,1392,9133,1,0,0,0,1394,9141,1,0,0,0,1396,9145,1,0,0,0,1398,9160,
  	1,0,0,0,1400,9162,1,0,0,0,1402,9165,1,0,0,0,1404,9167,1,0,0,0,1406,9169,
  	1,0,0,0,1408,9176,1,0,0,0,1410,9183,1,0,0,0,1412,9188,1,0,0,0,1414,9199,
  	1,0,0,0,1416,9204,1,0,0,0,1418,9206,1,0,0,0,1420,9208,1,0,0,0,1422,9222,
  	1,0,0,0,1424,9227,1,0,0,0,1426,9232,1,0,0,0,1428,9239,1,0,0,0,1430,9247,
  	1,0,0,0,1432,9249,1,0,0,0,1434,9260,1,0,0,0,1436,9262,1,0,0,0,1438,9264,
  	1,0,0,0,1440,9266,1,0,0,0,1442,9274,1,0,0,0,1444,9278,1,0,0,0,1446,9280,
  	1,0,0,0,1448,9282,1,0,0,0,1450,9290,1,0,0,0,1452,9294,1,0,0,0,1454,9298,
  	1,0,0,0,1456,9302,1,0,0,0,1458,9304,1,0,0,0,1460,9307,1,0,0,0,1462,9316,
  	1,0,0,0,1464,9324,1,0,0,0,1466,9333,1,0,0,0,1468,9337,1,0,0,0,1470,9356,
  	1,0,0,0,1472,9358,1,0,0,0,1474,9360,1,0,0,0,1476,9380,1,0,0,0,1478,9382,
  	1,0,0,0,1480,9389,1,0,0,0,1482,9401,1,0,0,0,1484,9407,1,0,0,0,1486,9409,
  	1,0,0,0,1488,9416,1,0,0,0,1490,9429,1,0,0,0,1492,1495,3,2,1,0,1493,1495,
  	3,454,227,0,1494,1492,1,0,0,0,1494,1493,1,0,0,0,1495,1497,1,0,0,0,1496,
  	1498,5,30,0,0,1497,1496,1,0,0,0,1497,1498,1,0,0,0,1498,1500,1,0,0,0,1499,
  	1494,1,0,0,0,1499,1500,1,0,0,0,1500,1501,1,0,0,0,1501,1502,5,0,0,1,1502,
  	1,1,0,0,0,1503,1584,3,4,2,0,1504,1584,3,80,40,0,1505,1584,3,192,96,0,
  	1506,1584,3,224,112,0,1507,1584,3,228,114,0,1508,1509,4,1,0,0,1509,1584,
  	3,230,115,0,1510,1584,3,232,116,0,1511,1584,3,234,117,0,1512,1584,3,240,
  	120,0,1513,1584,3,242,121,0,1514,1584,3,246,123,0,1515,1584,3,266,133,
  	0,1516,1584,3,294,147,0,1517,1584,3,296,148,0,1518,1584,3,448,224,0,1519,
  	1584,3,450,225,0,1520,1584,3,472,236,0,1521,1584,3,604,302,0,1522,1523,
  	4,1,1,0,1523,1584,3,610,305,0,1524,1584,3,616,308,0,1525,1584,3,682,341,
  	0,1526,1584,3,690,345,0,1527,1584,3,692,346,0,1528,1584,3,702,351,0,1529,
  	1584,3,724,362,0,1530,1584,3,726,363,0,1531,1584,3,728,364,0,1532,1584,
  	3,730,365,0,1533,1584,3,732,366,0,1534,1584,3,734,367,0,1535,1584,3,736,
  	368,0,1536,1584,3,738,369,0,1537,1584,3,740,370,0,1538,1584,3,742,371,
  	0,1539,1584,3,744,372,0,1540,1584,3,746,373,0,1541,1584,3,748,374,0,1542,
  	1584,3,750,375,0,1543,1584,3,752,376,0,1544,1584,3,754,377,0,1545,1584,
  	3,756,378,0,1546,1584,3,758,379,0,1547,1584,3,760,380,0,1548,1584,3,762,
  	381,0,1549,1584,3,764,382,0,1550,1584,3,766,383,0,1551,1584,3,768,384,
  	0,1552,1584,3,770,385,0,1553,1584,3,772,386,0,1554,1584,3,774,387,0,1555,
  	1584,3,776,388,0,1556,1584,3,778,389,0,1557,1584,3,780,390,0,1558,1584,
  	3,782,391,0,1559,1584,3,784,392,0,1560,1584,3,786,393,0,1561,1584,3,788,
  	394,0,1562,1584,3,790,395,0,1563,1584,3,792,396,0,1564,1584,3,794,397,
  	0,1565,1584,3,796,398,0,1566,1584,3,798,399,0,1567,1584,3,800,400,0,1568,
  	1584,3,802,401,0,1569,1584,3,804,402,0,1570,1584,3,806,403,0,1571,1584,
  	3,808,404,0,1572,1584,3,810,405,0,1573,1584,3,812,406,0,1574,1575,4,1,
  	2,0,1575,1584,3,814,407,0,1576,1577,4,1,3,0,1577,1584,3,860,430,0,1578,
  	1584,3,828,414,0,1579,1584,3,880,440,0,1580,1584,3,1072,536,0,1581,1584,
  	3,1082,541,0,1582,1584,3,1084,542,0,1583,1503,1,0,0,0,1583,1504,1,0,0,
  	0,1583,1505,1,0,0,0,1583,1506,1,0,0,0,1583,1507,1,0,0,0,1583,1508,1,0,
  	0,0,1583,1510,1,0,0,0,1583,1511,1,0,0,0,1583,1512,1,0,0,0,1583,1513,1,
  	0,0,0,1583,1514,1,0,0,0,1583,1515,1,0,0,0,1583,1516,1,0,0,0,1583,1517,
  	1,0,0,0,1583,1518,1,0,0,0,1583,1519,1,0,0,0,1583,1520,1,0,0,0,1583,1521,
  	1,0,0,0,1583,1522,1,0,0,0,1583,1524,1,0,0,0,1583,1525,1,0,0,0,1583,1526,
  	1,0,0,0,1583,1527,1,0,0,0,1583,1528,1,0,0,0,1583,1529,1,0,0,0,1583,1530,
  	1,0,0,0,1583,1531,1,0,0,0,1583,1532,1,0,0,0,1583,1533,1,0,0,0,1583,1534,
  	1,0,0,0,1583,1535,1,0,0,0,1583,1536,1,0,0,0,1583,1537,1,0,0,0,1583,1538,
  	1,0,0,0,1583,1539,1,0,0,0,1583,1540,1,0,0,0,1583,1541,1,0,0,0,1583,1542,
  	1,0,0,0,1583,1543,1,0,0,0,1583,1544,1,0,0,0,1583,1545,1,0,0,0,1583,1546,
  	1,0,0,0,1583,1547,1,0,0,0,1583,1548,1,0,0,0,1583,1549,1,0,0,0,1583,1550,
  	1,0,0,0,1583,1551,1,0,0,0,1583,1552,1,0,0,0,1583,1553,1,0,0,0,1583,1554,
  	1,0,0,0,1583,1555,1,0,0,0,1583,1556,1,0,0,0,1583,1557,1,0,0,0,1583,1558,
  	1,0,0,0,1583,1559,1,0,0,0,1583,1560,1,0,0,0,1583,1561,1,0,0,0,1583,1562,
  	1,0,0,0,1583,1563,1,0,0,0,1583,1564,1,0,0,0,1583,1565,1,0,0,0,1583,1566,
  	1,0,0,0,1583,1567,1,0,0,0,1583,1568,1,0,0,0,1583,1569,1,0,0,0,1583,1570,
  	1,0,0,0,1583,1571,1,0,0,0,1583,1572,1,0,0,0,1583,1573,1,0,0,0,1583,1574,
  	1,0,0,0,1583,1576,1,0,0,0,1583,1578,1,0,0,0,1583,1579,1,0,0,0,1583,1580,
  	1,0,0,0,1583,1581,1,0,0,0,1583,1582,1,0,0,0,1584,3,1,0,0,0,1585,1606,
  	5,57,0,0,1586,1607,3,20,10,0,1587,1607,3,6,3,0,1588,1589,5,452,0,0,1589,
  	1591,3,1326,663,0,1590,1592,3,114,57,0,1591,1590,1,0,0,0,1591,1592,1,
  	0,0,0,1592,1607,1,0,0,0,1593,1594,5,242,0,0,1594,1596,3,1330,665,0,1595,
  	1597,3,114,57,0,1596,1595,1,0,0,0,1596,1597,1,0,0,0,1597,1607,1,0,0,0,
  	1598,1607,3,70,35,0,1599,1607,3,10,5,0,1600,1607,3,56,28,0,1601,1602,
  	4,2,4,0,1602,1607,3,58,29,0,1603,1607,3,12,6,0,1604,1607,3,18,9,0,1605,
  	1607,3,78,39,0,1606,1586,1,0,0,0,1606,1587,1,0,0,0,1606,1588,1,0,0,0,
  	1606,1593,1,0,0,0,1606,1598,1,0,0,0,1606,1599,1,0,0,0,1606,1600,1,0,0,
  	0,1606,1601,1,0,0,0,1606,1603,1,0,0,0,1606,1604,1,0,0,0,1606,1605,1,0,
  	0,0,1607,5,1,0,0,0,1608,1609,5,151,0,0,1609,1620,3,1322,661,0,1610,1612,
  	3,8,4,0,1611,1610,1,0,0,0,1612,1613,1,0,0,0,1613,1611,1,0,0,0,1613,1614,
  	1,0,0,0,1614,1621,1,0,0,0,1615,1616,4,3,5,0,1616,1617,5,641,0,0,1617,
  	1618,5,154,0,0,1618,1619,5,179,0,0,1619,1621,5,388,0,0,1620,1611,1,0,
  	0,0,1620,1615,1,0,0,0,1621,7,1,0,0,0,1622,1630,3,84,42,0,1623,1624,5,
  	465,0,0,1624,1626,5,416,0,0,1625,1627,5,6,0,0,1626,1625,1,0,0,0,1626,
  	1627,1,0,0,0,1627,1628,1,0,0,0,1628,1630,3,1186,593,0,1629,1622,1,0,0,
  	0,1629,1623,1,0,0,0,1630,9,1,0,0,0,1631,1633,3,1216,608,0,1632,1631,1,
  	0,0,0,1632,1633,1,0,0,0,1633,1634,1,0,0,0,1634,1635,5,209,0,0,1635,1639,
  	3,1350,675,0,1636,1637,5,413,0,0,1637,1638,5,519,0,0,1638,1640,3,1094,
  	547,0,1639,1636,1,0,0,0,1639,1640,1,0,0,0,1640,1647,1,0,0,0,1641,1642,
  	5,413,0,0,1642,1644,5,123,0,0,1643,1645,5,401,0,0,1644,1643,1,0,0,0,1644,
  	1645,1,0,0,0,1645,1646,1,0,0,0,1646,1648,5,448,0,0,1647,1641,1,0,0,0,
  	1647,1648,1,0,0,0,1648,1652,1,0,0,0,1649,1650,5,483,0,0,1650,1651,5,616,
  	0,0,1651,1653,3,1390,695,0,1652,1649,1,0,0,0,1652,1653,1,0,0,0,1653,1660,
  	1,0,0,0,1654,1661,5,195,0,0,1655,1658,5,180,0,0,1656,1657,5,413,0,0,1657,
  	1659,3,602,301,0,1658,1656,1,0,0,0,1658,1659,1,0,0,0,1659,1661,1,0,0,
  	0,1660,1654,1,0,0,0,1660,1655,1,0,0,0,1660,1661,1,0,0,0,1661,1664,1,0,
  	0,0,1662,1663,5,119,0,0,1663,1665,3,1428,714,0,1664,1662,1,0,0,0,1664,
  	1665,1,0,0,0,1665,1668,1,0,0,0,1666,1667,5,186,0,0,1667,1669,3,1016,508,
  	0,1668,1666,1,0,0,0,1668,1669,1,0,0,0,1669,11,1,0,0,0,1670,1671,5,320,
  	0,0,1671,1672,5,253,0,0,1672,1673,3,1346,673,0,1673,1674,5,50,0,0,1674,
  	1675,5,629,0,0,1675,1677,3,1428,714,0,1676,1678,3,14,7,0,1677,1676,1,
  	0,0,0,1677,1678,1,0,0,0,1678,13,1,0,0,0,1679,1686,3,16,8,0,1680,1682,
  	5,29,0,0,1681,1680,1,0,0,0,1681,1682,1,0,0,0,1682,1683,1,0,0,0,1683,1685,
  	3,16,8,0,1684,1681,1,0,0,0,1685,1688,1,0,0,0,1686,1684,1,0,0,0,1686,1687,
  	1,0,0,0,1687,15,1,0,0,0,1688,1686,1,0,0,0,1689,1693,3,148,74,0,1690,1693,
  	3,160,80,0,1691,1693,3,162,81,0,1692,1689,1,0,0,0,1692,1690,1,0,0,0,1692,
  	1691,1,0,0,0,1693,17,1,0,0,0,1694,1695,5,530,0,0,1695,1696,3,1356,678,
  	0,1696,1697,3,132,66,0,1697,19,1,0,0,0,1698,1700,3,1296,648,0,1699,1698,
  	1,0,0,0,1699,1700,1,0,0,0,1700,1701,1,0,0,0,1701,1702,5,600,0,0,1702,
  	1704,3,1366,683,0,1703,1705,3,22,11,0,1704,1703,1,0,0,0,1704,1705,1,0,
  	0,0,1705,21,1,0,0,0,1706,1709,3,24,12,0,1707,1710,3,1194,597,0,1708,1710,
  	3,52,26,0,1709,1707,1,0,0,0,1709,1708,1,0,0,0,1709,1710,1,0,0,0,1710,
  	1720,1,0,0,0,1711,1720,3,1194,597,0,1712,1720,3,52,26,0,1713,1714,3,26,
  	13,0,1714,1715,5,29,0,0,1715,1717,1,0,0,0,1716,1713,1,0,0,0,1716,1717,
  	1,0,0,0,1717,1718,1,0,0,0,1718,1720,3,28,14,0,1719,1706,1,0,0,0,1719,
  	1711,1,0,0,0,1719,1712,1,0,0,0,1719,1716,1,0,0,0,1720,23,1,0,0,0,1721,
  	1729,3,26,13,0,1722,1723,3,26,13,0,1723,1724,5,29,0,0,1724,1726,1,0,0,
  	0,1725,1722,1,0,0,0,1725,1726,1,0,0,0,1726,1727,1,0,0,0,1727,1729,3,32,
  	16,0,1728,1721,1,0,0,0,1728,1725,1,0,0,0,1729,25,1,0,0,0,1730,1735,3,
  	34,17,0,1731,1732,5,29,0,0,1732,1734,3,34,17,0,1733,1731,1,0,0,0,1734,
  	1737,1,0,0,0,1735,1733,1,0,0,0,1735,1736,1,0,0,0,1736,27,1,0,0,0,1737,
  	1735,1,0,0,0,1738,1739,5,181,0,0,1739,1746,5,598,0,0,1740,1741,5,270,
  	0,0,1741,1746,5,598,0,0,1742,1746,3,30,15,0,1743,1744,4,14,6,0,1744,1746,
  	7,0,0,0,1745,1738,1,0,0,0,1745,1740,1,0,0,0,1745,1742,1,0,0,0,1745,1743,
  	1,0,0,0,1746,29,1,0,0,0,1747,1748,5,50,0,0,1748,1750,5,435,0,0,1749,1751,
  	3,1298,649,0,1750,1749,1,0,0,0,1750,1751,1,0,0,0,1751,1755,1,0,0,0,1752,
  	1756,3,1202,601,0,1753,1754,5,434,0,0,1754,1756,3,1404,702,0,1755,1752,
  	1,0,0,0,1755,1753,1,0,0,0,1756,1844,1,0,0,0,1757,1758,5,187,0,0,1758,
  	1759,5,435,0,0,1759,1844,3,1392,696,0,1760,1761,5,468,0,0,1761,1763,5,
  	435,0,0,1762,1764,3,1298,649,0,1763,1762,1,0,0,0,1763,1764,1,0,0,0,1764,
  	1765,1,0,0,0,1765,1844,3,54,27,0,1766,1767,5,418,0,0,1767,1769,5,435,
  	0,0,1768,1770,3,1298,649,0,1769,1768,1,0,0,0,1769,1770,1,0,0,0,1770,1771,
  	1,0,0,0,1771,1773,3,54,27,0,1772,1774,3,1298,649,0,1773,1772,1,0,0,0,
  	1773,1774,1,0,0,0,1774,1844,1,0,0,0,1775,1776,5,60,0,0,1776,1778,5,435,
  	0,0,1777,1779,3,1298,649,0,1778,1777,1,0,0,0,1778,1779,1,0,0,0,1779,1780,
  	1,0,0,0,1780,1844,3,54,27,0,1781,1782,5,106,0,0,1782,1783,5,435,0,0,1783,
  	1787,3,54,27,0,1784,1786,3,686,343,0,1785,1784,1,0,0,0,1786,1789,1,0,
  	0,0,1787,1785,1,0,0,0,1787,1788,1,0,0,0,1788,1844,1,0,0,0,1789,1787,1,
  	0,0,0,1790,1791,5,485,0,0,1791,1793,5,435,0,0,1792,1794,3,1298,649,0,
  	1793,1792,1,0,0,0,1793,1794,1,0,0,0,1794,1795,1,0,0,0,1795,1799,3,54,
  	27,0,1796,1798,3,688,344,0,1797,1796,1,0,0,0,1798,1801,1,0,0,0,1799,1797,
  	1,0,0,0,1799,1800,1,0,0,0,1800,1844,1,0,0,0,1801,1799,1,0,0,0,1802,1803,
  	5,111,0,0,1803,1805,5,435,0,0,1804,1806,3,1298,649,0,1805,1804,1,0,0,
  	0,1805,1806,1,0,0,0,1806,1807,1,0,0,0,1807,1844,3,1404,702,0,1808,1809,
  	5,623,0,0,1809,1810,5,435,0,0,1810,1844,3,54,27,0,1811,1812,5,484,0,0,
  	1812,1814,5,435,0,0,1813,1815,3,1298,649,0,1814,1813,1,0,0,0,1814,1815,
  	1,0,0,0,1815,1820,1,0,0,0,1816,1817,3,1392,696,0,1817,1818,5,283,0,0,
  	1818,1819,3,1202,601,0,1819,1821,1,0,0,0,1820,1816,1,0,0,0,1820,1821,
  	1,0,0,0,1821,1844,1,0,0,0,1822,1823,5,211,0,0,1823,1824,5,435,0,0,1824,
  	1825,3,1390,695,0,1825,1826,5,670,0,0,1826,1827,5,600,0,0,1827,1829,3,
  	1366,683,0,1828,1830,3,50,25,0,1829,1828,1,0,0,0,1829,1830,1,0,0,0,1830,
  	1844,1,0,0,0,1831,1832,4,15,7,0,1832,1833,5,181,0,0,1833,1834,5,435,0,
  	0,1834,1835,3,54,27,0,1835,1836,5,598,0,0,1836,1844,1,0,0,0,1837,1838,
  	4,15,8,0,1838,1839,5,270,0,0,1839,1840,5,435,0,0,1840,1841,3,54,27,0,
  	1841,1842,5,598,0,0,1842,1844,1,0,0,0,1843,1747,1,0,0,0,1843,1757,1,0,
  	0,0,1843,1760,1,0,0,0,1843,1766,1,0,0,0,1843,1775,1,0,0,0,1843,1781,1,
  	0,0,0,1843,1790,1,0,0,0,1843,1802,1,0,0,0,1843,1808,1,0,0,0,1843,1811,
  	1,0,0,0,1843,1822,1,0,0,0,1843,1831,1,0,0,0,1843,1837,1,0,0,0,1844,31,
  	1,0,0,0,1845,1848,3,36,18,0,1846,1848,3,1182,591,0,1847,1845,1,0,0,0,
  	1847,1846,1,0,0,0,1848,1857,1,0,0,0,1849,1853,5,29,0,0,1850,1854,3,36,
  	18,0,1851,1854,3,34,17,0,1852,1854,3,1182,591,0,1853,1850,1,0,0,0,1853,
  	1851,1,0,0,0,1853,1852,1,0,0,0,1854,1856,1,0,0,0,1855,1849,1,0,0,0,1856,
  	1859,1,0,0,0,1857,1855,1,0,0,0,1857,1858,1,0,0,0,1858,33,1,0,0,0,1859,
  	1857,1,0,0,0,1860,1864,3,44,22,0,1861,1864,3,46,23,0,1862,1864,3,50,25,
  	0,1863,1860,1,0,0,0,1863,1861,1,0,0,0,1863,1862,1,0,0,0,1864,35,1,0,0,
  	0,1865,1867,5,50,0,0,1866,1868,5,116,0,0,1867,1866,1,0,0,0,1867,1868,
  	1,0,0,0,1868,1881,1,0,0,0,1869,1870,3,1390,695,0,1870,1872,3,1108,554,
  	0,1871,1873,3,1098,549,0,1872,1871,1,0,0,0,1872,1873,1,0,0,0,1873,1875,
  	1,0,0,0,1874,1876,3,38,19,0,1875,1874,1,0,0,0,1875,1876,1,0,0,0,1876,
  	1882,1,0,0,0,1877,1878,5,32,0,0,1878,1879,3,88,44,0,1879,1880,5,33,0,
  	0,1880,1882,1,0,0,0,1881,1869,1,0,0,0,1881,1877,1,0,0,0,1882,2006,1,0,
  	0,0,1883,1884,5,50,0,0,1884,2006,3,1104,552,0,1885,1887,5,100,0,0,1886,
  	1888,5,116,0,0,1887,1886,1,0,0,0,1887,1888,1,0,0,0,1888,1889,1,0,0,0,
  	1889,1890,3,1306,653,0,1890,1891,3,1390,695,0,1891,1893,3,1108,554,0,
  	1892,1894,3,38,19,0,1893,1892,1,0,0,0,1893,1894,1,0,0,0,1894,2006,1,0,
  	0,0,1895,1897,5,379,0,0,1896,1898,5,116,0,0,1897,1896,1,0,0,0,1897,1898,
  	1,0,0,0,1898,1899,1,0,0,0,1899,1900,3,1306,653,0,1900,1902,3,1108,554,
  	0,1901,1903,3,38,19,0,1902,1901,1,0,0,0,1902,1903,1,0,0,0,1903,2006,1,
  	0,0,0,1904,1926,5,187,0,0,1905,1907,5,116,0,0,1906,1905,1,0,0,0,1906,
  	1907,1,0,0,0,1907,1908,1,0,0,0,1908,1910,3,1306,653,0,1909,1911,3,40,
  	20,0,1910,1909,1,0,0,0,1910,1911,1,0,0,0,1911,1927,1,0,0,0,1912,1913,
  	5,235,0,0,1913,1914,5,299,0,0,1914,1927,3,1306,653,0,1915,1916,5,450,
  	0,0,1916,1927,5,299,0,0,1917,1918,3,438,219,0,1918,1919,3,1316,658,0,
  	1919,1927,1,0,0,0,1920,1921,4,18,9,0,1921,1922,5,106,0,0,1922,1927,3,
  	1390,695,0,1923,1924,4,18,10,0,1924,1925,5,130,0,0,1925,1927,3,1390,695,
  	0,1926,1906,1,0,0,0,1926,1912,1,0,0,0,1926,1915,1,0,0,0,1926,1917,1,0,
  	0,0,1926,1920,1,0,0,0,1926,1923,1,0,0,0,1927,2006,1,0,0,0,1928,1929,5,
  	180,0,0,1929,2006,5,297,0,0,1930,1931,5,195,0,0,1931,2006,5,297,0,0,1932,
  	1934,5,57,0,0,1933,1935,5,116,0,0,1934,1933,1,0,0,0,1934,1935,1,0,0,0,
  	1935,1936,1,0,0,0,1936,1949,3,1306,653,0,1937,1938,5,533,0,0,1938,1942,
  	5,168,0,0,1939,1940,4,18,11,0,1940,1943,3,1002,501,0,1941,1943,3,1412,
  	706,0,1942,1939,1,0,0,0,1942,1941,1,0,0,0,1943,1950,1,0,0,0,1944,1945,
  	5,187,0,0,1945,1950,5,168,0,0,1946,1947,4,18,12,0,1947,1948,5,533,0,0,
  	1948,1950,3,1140,570,0,1949,1937,1,0,0,0,1949,1944,1,0,0,0,1949,1946,
  	1,0,0,0,1950,2006,1,0,0,0,1951,1952,4,18,13,0,1952,1953,5,57,0,0,1953,
  	1954,5,272,0,0,1954,1955,3,1316,658,0,1955,1956,3,1140,570,0,1956,2006,
  	1,0,0,0,1957,1958,4,18,14,0,1958,1959,5,57,0,0,1959,1960,5,106,0,0,1960,
  	1961,3,1390,695,0,1961,1962,3,1102,551,0,1962,2006,1,0,0,0,1963,1964,
  	4,18,15,0,1964,1965,5,57,0,0,1965,1966,5,130,0,0,1966,1967,3,1390,695,
  	0,1967,1968,3,1102,551,0,1968,2006,1,0,0,0,1969,1970,4,18,16,0,1970,1971,
  	5,483,0,0,1971,1972,5,116,0,0,1972,1973,3,1306,653,0,1973,1974,5,616,
  	0,0,1974,1975,3,1390,695,0,1975,2006,1,0,0,0,1976,1978,5,483,0,0,1977,
  	1979,7,1,0,0,1978,1977,1,0,0,0,1978,1979,1,0,0,0,1979,1980,1,0,0,0,1980,
  	2006,3,1360,680,0,1981,1982,5,483,0,0,1982,1983,3,438,219,0,1983,1984,
  	3,1316,658,0,1984,1985,5,616,0,0,1985,1986,3,1314,657,0,1986,2006,1,0,
  	0,0,1987,1988,5,137,0,0,1988,1989,5,616,0,0,1989,1993,3,990,495,0,1990,
  	1991,4,18,17,0,1991,1994,5,168,0,0,1992,1994,3,1172,586,0,1993,1990,1,
  	0,0,0,1993,1992,1,0,0,0,1994,1996,1,0,0,0,1995,1997,3,1232,616,0,1996,
  	1995,1,0,0,0,1996,1997,1,0,0,0,1997,2006,1,0,0,0,1998,2006,5,234,0,0,
  	1999,2000,5,423,0,0,2000,2001,5,90,0,0,2001,2006,3,42,21,0,2002,2003,
  	4,18,18,0,2003,2004,5,641,0,0,2004,2006,5,433,0,0,2005,1865,1,0,0,0,2005,
  	1883,1,0,0,0,2005,1885,1,0,0,0,2005,1895,1,0,0,0,2005,1904,1,0,0,0,2005,
  	1928,1,0,0,0,2005,1930,1,0,0,0,2005,1932,1,0,0,0,2005,1951,1,0,0,0,2005,
  	1957,1,0,0,0,2005,1963,1,0,0,0,2005,1969,1,0,0,0,2005,1976,1,0,0,0,2005,
  	1981,1,0,0,0,2005,1987,1,0,0,0,2005,1998,1,0,0,0,2005,1999,1,0,0,0,2005,
  	2002,1,0,0,0,2006,37,1,0,0,0,2007,2008,5,52,0,0,2008,2011,3,1390,695,
  	0,2009,2011,5,229,0,0,2010,2007,1,0,0,0,2010,2009,1,0,0,0,2011,39,1,0,
  	0,0,2012,2013,7,2,0,0,2013,41,1,0,0,0,2014,2016,3,1390,695,0,2015,2017,
  	3,360,180,0,2016,2015,1,0,0,0,2016,2017,1,0,0,0,2017,2025,1,0,0,0,2018,
  	2019,5,29,0,0,2019,2021,3,1390,695,0,2020,2022,3,360,180,0,2021,2020,
  	1,0,0,0,2021,2022,1,0,0,0,2022,2024,1,0,0,0,2023,2018,1,0,0,0,2024,2027,
  	1,0,0,0,2025,2023,1,0,0,0,2025,2026,1,0,0,0,2026,43,1,0,0,0,2027,2025,
  	1,0,0,0,2028,2030,5,55,0,0,2029,2031,5,6,0,0,2030,2029,1,0,0,0,2030,2031,
  	1,0,0,0,2031,2034,1,0,0,0,2032,2035,5,168,0,0,2033,2035,3,1390,695,0,
  	2034,2032,1,0,0,0,2034,2033,1,0,0,0,2035,45,1,0,0,0,2036,2038,5,319,0,
  	0,2037,2039,5,6,0,0,2038,2037,1,0,0,0,2038,2039,1,0,0,0,2039,2042,1,0,
  	0,0,2040,2043,5,168,0,0,2041,2043,3,1390,695,0,2042,2040,1,0,0,0,2042,
  	2041,1,0,0,0,2043,47,1,0,0,0,2044,2046,3,44,22,0,2045,2047,3,46,23,0,
  	2046,2045,1,0,0,0,2046,2047,1,0,0,0,2047,2053,1,0,0,0,2048,2050,3,46,
  	23,0,2049,2051,3,44,22,0,2050,2049,1,0,0,0,2050,2051,1,0,0,0,2051,2053,
  	1,0,0,0,2052,2044,1,0,0,0,2052,2048,1,0,0,0,2053,49,1,0,0,0,2054,2055,
  	4,25,19,0,2055,2056,7,3,0,0,2056,2057,5,651,0,0,2057,51,1,0,0,0,2058,
  	2059,5,482,0,0,2059,2060,5,433,0,0,2060,53,1,0,0,0,2061,2064,5,56,0,0,
  	2062,2064,3,1392,696,0,2063,2061,1,0,0,0,2063,2062,1,0,0,0,2064,55,1,
  	0,0,0,2065,2066,5,598,0,0,2066,2078,3,1342,671,0,2067,2068,7,4,0,0,2068,
  	2069,5,153,0,0,2069,2071,3,1428,714,0,2070,2072,3,64,32,0,2071,2070,1,
  	0,0,0,2071,2072,1,0,0,0,2072,2079,1,0,0,0,2073,2074,5,483,0,0,2074,2075,
  	5,616,0,0,2075,2079,3,1390,695,0,2076,2077,4,28,20,0,2077,2079,3,64,32,
  	0,2078,2067,1,0,0,0,2078,2073,1,0,0,0,2078,2076,1,0,0,0,2079,57,1,0,0,
  	0,2080,2081,5,631,0,0,2081,2082,5,598,0,0,2082,2083,3,1342,671,0,2083,
  	2084,5,533,0,0,2084,2086,7,5,0,0,2085,2087,3,60,30,0,2086,2085,1,0,0,
  	0,2086,2087,1,0,0,0,2087,59,1,0,0,0,2088,2095,3,62,31,0,2089,2091,5,29,
  	0,0,2090,2089,1,0,0,0,2090,2091,1,0,0,0,2091,2092,1,0,0,0,2092,2094,3,
  	62,31,0,2093,2090,1,0,0,0,2094,2097,1,0,0,0,2095,2093,1,0,0,0,2095,2096,
  	1,0,0,0,2096,61,1,0,0,0,2097,2095,1,0,0,0,2098,2099,3,160,80,0,2099,63,
  	1,0,0,0,2100,2107,3,66,33,0,2101,2103,5,29,0,0,2102,2101,1,0,0,0,2102,
  	2103,1,0,0,0,2103,2104,1,0,0,0,2104,2106,3,66,33,0,2105,2102,1,0,0,0,
  	2106,2109,1,0,0,0,2107,2105,1,0,0,0,2107,2108,1,0,0,0,2108,65,1,0,0,0,
  	2109,2107,1,0,0,0,2110,2112,5,274,0,0,2111,2113,5,6,0,0,2112,2111,1,0,
  	0,0,2112,2113,1,0,0,0,2113,2114,1,0,0,0,2114,2123,3,1456,728,0,2115,2123,
  	3,152,76,0,2116,2123,3,154,77,0,2117,2123,3,160,80,0,2118,2123,3,162,
  	81,0,2119,2123,3,168,84,0,2120,2121,4,33,21,0,2121,2123,3,170,85,0,2122,
  	2110,1,0,0,0,2122,2115,1,0,0,0,2122,2116,1,0,0,0,2122,2117,1,0,0,0,2122,
  	2118,1,0,0,0,2122,2119,1,0,0,0,2122,2120,1,0,0,0,2123,67,1,0,0,0,2124,
  	2126,5,274,0,0,2125,2127,5,6,0,0,2126,2125,1,0,0,0,2126,2127,1,0,0,0,
  	2127,2128,1,0,0,0,2128,2132,3,1456,728,0,2129,2132,3,152,76,0,2130,2132,
  	3,154,77,0,2131,2124,1,0,0,0,2131,2129,1,0,0,0,2131,2130,1,0,0,0,2132,
  	69,1,0,0,0,2133,2135,3,176,88,0,2134,2133,1,0,0,0,2134,2135,1,0,0,0,2135,
  	2137,1,0,0,0,2136,2138,3,1216,608,0,2137,2136,1,0,0,0,2137,2138,1,0,0,
  	0,2138,2140,1,0,0,0,2139,2141,3,178,89,0,2140,2139,1,0,0,0,2140,2141,
  	1,0,0,0,2141,2142,1,0,0,0,2142,2143,5,661,0,0,2143,2144,3,1338,669,0,
  	2144,2145,3,72,36,0,2145,71,1,0,0,0,2146,2148,3,1308,654,0,2147,2146,
  	1,0,0,0,2147,2148,1,0,0,0,2148,2149,1,0,0,0,2149,2150,5,63,0,0,2150,2151,
  	3,74,37,0,2151,73,1,0,0,0,2152,2154,3,98,49,0,2153,2155,3,76,38,0,2154,
  	2153,1,0,0,0,2154,2155,1,0,0,0,2155,75,1,0,0,0,2156,2158,5,670,0,0,2157,
  	2159,7,6,0,0,2158,2157,1,0,0,0,2158,2159,1,0,0,0,2159,2160,1,0,0,0,2160,
  	2161,5,106,0,0,2161,2162,5,421,0,0,2162,77,1,0,0,0,2163,2164,4,39,22,
  	0,2164,2193,5,280,0,0,2165,2166,5,511,0,0,2166,2167,3,1450,725,0,2167,
  	2168,5,348,0,0,2168,2169,5,299,0,0,2169,2194,1,0,0,0,2170,2171,4,39,23,
  	0,2171,2172,5,481,0,0,2172,2177,5,772,0,0,2173,2174,4,39,24,0,2174,2175,
  	5,236,0,0,2175,2176,5,102,0,0,2176,2178,3,1390,695,0,2177,2173,1,0,0,
  	0,2177,2178,1,0,0,0,2178,2183,1,0,0,0,2179,2180,5,403,0,0,2180,2181,5,
  	509,0,0,2181,2182,5,413,0,0,2182,2184,5,204,0,0,2183,2179,1,0,0,0,2183,
  	2184,1,0,0,0,2184,2194,1,0,0,0,2185,2186,4,39,25,0,2186,2187,7,7,0,0,
  	2187,2188,3,1390,695,0,2188,2189,3,1390,695,0,2189,2194,1,0,0,0,2190,
  	2191,4,39,26,0,2191,2192,5,481,0,0,2192,2194,5,810,0,0,2193,2165,1,0,
  	0,0,2193,2170,1,0,0,0,2193,2185,1,0,0,0,2193,2190,1,0,0,0,2194,2197,1,
  	0,0,0,2195,2197,1,0,0,0,2196,2163,1,0,0,0,2196,2195,1,0,0,0,2197,79,1,
  	0,0,0,2198,2217,5,140,0,0,2199,2218,3,82,41,0,2200,2218,3,86,43,0,2201,
  	2218,3,108,54,0,2202,2218,3,102,51,0,2203,2218,3,110,55,0,2204,2218,3,
  	124,62,0,2205,2218,3,172,86,0,2206,2218,3,180,90,0,2207,2218,3,118,59,
  	0,2208,2218,3,130,65,0,2209,2218,3,136,68,0,2210,2218,3,184,92,0,2211,
  	2212,4,40,27,0,2212,2218,3,186,93,0,2213,2214,4,40,28,0,2214,2218,3,188,
  	94,0,2215,2216,4,40,29,0,2216,2218,3,138,69,0,2217,2199,1,0,0,0,2217,
  	2200,1,0,0,0,2217,2201,1,0,0,0,2217,2202,1,0,0,0,2217,2203,1,0,0,0,2217,
  	2204,1,0,0,0,2217,2205,1,0,0,0,2217,2206,1,0,0,0,2217,2207,1,0,0,0,2217,
  	2208,1,0,0,0,2217,2209,1,0,0,0,2217,2210,1,0,0,0,2217,2211,1,0,0,0,2217,
  	2213,1,0,0,0,2217,2215,1,0,0,0,2218,81,1,0,0,0,2219,2221,5,151,0,0,2220,
  	2222,3,1224,612,0,2221,2220,1,0,0,0,2221,2222,1,0,0,0,2222,2223,1,0,0,
  	0,2223,2227,3,1320,660,0,2224,2226,3,84,42,0,2225,2224,1,0,0,0,2226,2229,
  	1,0,0,0,2227,2225,1,0,0,0,2227,2228,1,0,0,0,2228,83,1,0,0,0,2229,2227,
  	1,0,0,0,2230,2235,3,1192,596,0,2231,2235,3,1188,594,0,2232,2233,4,42,
  	30,0,2233,2235,3,1190,595,0,2234,2230,1,0,0,0,2234,2231,1,0,0,0,2234,
  	2232,1,0,0,0,2235,85,1,0,0,0,2236,2238,5,603,0,0,2237,2236,1,0,0,0,2237,
  	2238,1,0,0,0,2238,2239,1,0,0,0,2239,2241,5,600,0,0,2240,2242,3,1224,612,
  	0,2241,2240,1,0,0,0,2241,2242,1,0,0,0,2242,2243,1,0,0,0,2243,2260,3,1360,
  	680,0,2244,2245,5,32,0,0,2245,2246,3,88,44,0,2246,2247,5,33,0,0,2247,
  	2249,1,0,0,0,2248,2244,1,0,0,0,2248,2249,1,0,0,0,2249,2251,1,0,0,0,2250,
  	2252,3,1178,589,0,2251,2250,1,0,0,0,2251,2252,1,0,0,0,2252,2261,1,0,0,
  	0,2253,2254,5,309,0,0,2254,2261,3,1366,683,0,2255,2256,5,32,0,0,2256,
  	2257,5,309,0,0,2257,2258,3,1366,683,0,2258,2259,5,33,0,0,2259,2261,1,
  	0,0,0,2260,2248,1,0,0,0,2260,2253,1,0,0,0,2260,2255,1,0,0,0,2261,87,1,
  	0,0,0,2262,2267,3,90,45,0,2263,2264,5,29,0,0,2264,2266,3,90,45,0,2265,
  	2263,1,0,0,0,2266,2269,1,0,0,0,2267,2265,1,0,0,0,2267,2268,1,0,0,0,2268,
  	89,1,0,0,0,2269,2267,1,0,0,0,2270,2273,3,1096,548,0,2271,2273,3,1104,
  	552,0,2272,2270,1,0,0,0,2272,2271,1,0,0,0,2273,91,1,0,0,0,2274,2276,7,
  	8,0,0,2275,2274,1,0,0,0,2275,2276,1,0,0,0,2276,2277,1,0,0,0,2277,2278,
  	3,94,47,0,2278,93,1,0,0,0,2279,2281,5,63,0,0,2280,2279,1,0,0,0,2280,2281,
  	1,0,0,0,2281,2282,1,0,0,0,2282,2283,3,98,49,0,2283,95,1,0,0,0,2284,2286,
  	3,300,150,0,2285,2287,3,374,187,0,2286,2285,1,0,0,0,2286,2287,1,0,0,0,
  	2287,2290,1,0,0,0,2288,2290,3,304,152,0,2289,2284,1,0,0,0,2289,2288,1,
  	0,0,0,2290,97,1,0,0,0,2291,2293,3,300,150,0,2292,2294,3,374,187,0,2293,
  	2292,1,0,0,0,2293,2294,1,0,0,0,2294,99,1,0,0,0,2295,2299,5,140,0,0,2296,
  	2300,3,102,51,0,2297,2300,3,108,54,0,2298,2300,3,110,55,0,2299,2296,1,
  	0,0,0,2299,2297,1,0,0,0,2299,2298,1,0,0,0,2300,2302,1,0,0,0,2301,2303,
  	5,30,0,0,2302,2301,1,0,0,0,2302,2303,1,0,0,0,2303,2304,1,0,0,0,2304,2305,
  	5,0,0,1,2305,101,1,0,0,0,2306,2308,3,1216,608,0,2307,2306,1,0,0,0,2307,
  	2308,1,0,0,0,2308,2309,1,0,0,0,2309,2312,5,452,0,0,2310,2311,4,51,31,
  	0,2311,2313,3,1224,612,0,2312,2310,1,0,0,0,2312,2313,1,0,0,0,2313,2314,
  	1,0,0,0,2314,2315,3,1324,662,0,2315,2324,5,32,0,0,2316,2321,3,1228,614,
  	0,2317,2318,5,29,0,0,2318,2320,3,1228,614,0,2319,2317,1,0,0,0,2320,2323,
  	1,0,0,0,2321,2319,1,0,0,0,2321,2322,1,0,0,0,2322,2325,1,0,0,0,2323,2321,
  	1,0,0,0,2324,2316,1,0,0,0,2324,2325,1,0,0,0,2325,2326,1,0,0,0,2326,2330,
  	5,33,0,0,2327,2329,3,112,56,0,2328,2327,1,0,0,0,2329,2332,1,0,0,0,2330,
  	2328,1,0,0,0,2330,2331,1,0,0,0,2331,2333,1,0,0,0,2332,2330,1,0,0,0,2333,
  	2334,3,106,53,0,2334,103,1,0,0,0,2335,2338,3,1422,711,0,2336,2338,5,837,
  	0,0,2337,2335,1,0,0,0,2337,2336,1,0,0,0,2338,105,1,0,0,0,2339,2344,3,
  	1016,508,0,2340,2341,4,53,32,0,2341,2342,5,63,0,0,2342,2344,3,104,52,
  	0,2343,2339,1,0,0,0,2343,2340,1,0,0,0,2344,107,1,0,0,0,2345,2347,3,1216,
  	608,0,2346,2345,1,0,0,0,2346,2347,1,0,0,0,2347,2348,1,0,0,0,2348,2351,
  	5,242,0,0,2349,2350,4,54,33,0,2350,2352,3,1224,612,0,2351,2349,1,0,0,
  	0,2351,2352,1,0,0,0,2352,2353,1,0,0,0,2353,2354,3,1328,664,0,2354,2363,
  	5,32,0,0,2355,2360,3,1230,615,0,2356,2357,5,29,0,0,2357,2359,3,1230,615,
  	0,2358,2356,1,0,0,0,2359,2362,1,0,0,0,2360,2358,1,0,0,0,2360,2361,1,0,
  	0,0,2361,2364,1,0,0,0,2362,2360,1,0,0,0,2363,2355,1,0,0,0,2363,2364,1,
  	0,0,0,2364,2365,1,0,0,0,2365,2366,5,33,0,0,2366,2367,5,504,0,0,2367,2371,
  	3,1234,617,0,2368,2370,3,112,56,0,2369,2368,1,0,0,0,2370,2373,1,0,0,0,
  	2371,2369,1,0,0,0,2371,2372,1,0,0,0,2372,2374,1,0,0,0,2373,2371,1,0,0,
  	0,2374,2375,3,106,53,0,2375,109,1,0,0,0,2376,2378,5,54,0,0,2377,2376,
  	1,0,0,0,2377,2378,1,0,0,0,2378,2379,1,0,0,0,2379,2382,5,242,0,0,2380,
  	2381,4,55,34,0,2381,2383,3,1224,612,0,2382,2380,1,0,0,0,2382,2383,1,0,
  	0,0,2383,2384,1,0,0,0,2384,2385,3,1352,676,0,2385,2386,5,504,0,0,2386,
  	2387,7,9,0,0,2387,2388,5,546,0,0,2388,2389,3,1428,714,0,2389,111,1,0,
  	0,0,2390,2396,3,116,58,0,2391,2393,5,401,0,0,2392,2391,1,0,0,0,2392,2393,
  	1,0,0,0,2393,2394,1,0,0,0,2394,2396,5,177,0,0,2395,2390,1,0,0,0,2395,
  	2392,1,0,0,0,2396,113,1,0,0,0,2397,2399,3,112,56,0,2398,2397,1,0,0,0,
  	2399,2400,1,0,0,0,2400,2398,1,0,0,0,2400,2401,1,0,0,0,2401,115,1,0,0,
  	0,2402,2403,5,119,0,0,2403,2424,3,1428,714,0,2404,2408,5,301,0,0,2405,
  	2409,5,563,0,0,2406,2407,4,58,35,0,2407,2409,3,1390,695,0,2408,2405,1,
  	0,0,0,2408,2406,1,0,0,0,2409,2424,1,0,0,0,2410,2411,5,403,0,0,2411,2424,
  	5,563,0,0,2412,2413,5,134,0,0,2413,2424,5,563,0,0,2414,2415,5,463,0,0,
  	2415,2416,5,563,0,0,2416,2424,5,154,0,0,2417,2418,5,378,0,0,2418,2419,
  	5,563,0,0,2419,2424,5,154,0,0,2420,2421,5,563,0,0,2421,2422,5,523,0,0,
  	2422,2424,7,10,0,0,2423,2402,1,0,0,0,2423,2404,1,0,0,0,2423,2410,1,0,
  	0,0,2423,2412,1,0,0,0,2423,2414,1,0,0,0,2423,2417,1,0,0,0,2423,2420,1,
  	0,0,0,2424,117,1,0,0,0,2425,2427,3,1296,648,0,2426,2425,1,0,0,0,2426,
  	2427,1,0,0,0,2427,2463,1,0,0,0,2428,2430,5,635,0,0,2429,2428,1,0,0,0,
  	2429,2430,1,0,0,0,2430,2431,1,0,0,0,2431,2432,5,272,0,0,2432,2434,3,1314,
  	657,0,2433,2435,3,1142,571,0,2434,2433,1,0,0,0,2434,2435,1,0,0,0,2435,
  	2436,1,0,0,0,2436,2440,3,122,61,0,2437,2439,3,1136,568,0,2438,2437,1,
  	0,0,0,2439,2442,1,0,0,0,2440,2438,1,0,0,0,2440,2441,1,0,0,0,2441,2464,
  	1,0,0,0,2442,2440,1,0,0,0,2443,2444,5,241,0,0,2444,2445,5,272,0,0,2445,
  	2446,3,1314,657,0,2446,2450,3,122,61,0,2447,2449,3,1144,572,0,2448,2447,
  	1,0,0,0,2449,2452,1,0,0,0,2450,2448,1,0,0,0,2450,2451,1,0,0,0,2451,2464,
  	1,0,0,0,2452,2450,1,0,0,0,2453,2454,5,549,0,0,2454,2455,5,272,0,0,2455,
  	2456,3,1314,657,0,2456,2460,3,122,61,0,2457,2459,3,1146,573,0,2458,2457,
  	1,0,0,0,2459,2462,1,0,0,0,2460,2458,1,0,0,0,2460,2461,1,0,0,0,2461,2464,
  	1,0,0,0,2462,2460,1,0,0,0,2463,2429,1,0,0,0,2463,2443,1,0,0,0,2463,2453,
  	1,0,0,0,2464,2466,1,0,0,0,2465,2467,3,48,24,0,2466,2465,1,0,0,0,2466,
  	2467,1,0,0,0,2467,119,1,0,0,0,2468,2479,3,1314,657,0,2469,2471,3,1314,
  	657,0,2470,2469,1,0,0,0,2470,2471,1,0,0,0,2471,2472,1,0,0,0,2472,2473,
  	5,647,0,0,2473,2479,3,1134,567,0,2474,2475,3,1314,657,0,2475,2476,5,625,
  	0,0,2476,2477,3,1134,567,0,2477,2479,1,0,0,0,2478,2468,1,0,0,0,2478,2470,
  	1,0,0,0,2478,2474,1,0,0,0,2479,121,1,0,0,0,2480,2481,5,413,0,0,2481,2482,
  	3,1366,683,0,2482,2483,3,1130,565,0,2483,123,1,0,0,0,2484,2485,5,320,
  	0,0,2485,2486,5,253,0,0,2486,2487,3,1344,672,0,2487,2488,5,50,0,0,2488,
  	2489,5,629,0,0,2489,2491,3,1428,714,0,2490,2492,3,126,63,0,2491,2490,
  	1,0,0,0,2491,2492,1,0,0,0,2492,125,1,0,0,0,2493,2500,3,128,64,0,2494,
  	2496,5,29,0,0,2495,2494,1,0,0,0,2495,2496,1,0,0,0,2496,2497,1,0,0,0,2497,
  	2499,3,128,64,0,2498,2495,1,0,0,0,2499,2502,1,0,0,0,2500,2498,1,0,0,0,
  	2500,2501,1,0,0,0,2501,127,1,0,0,0,2502,2500,1,0,0,0,2503,2510,3,148,
  	74,0,2504,2510,3,150,75,0,2505,2510,3,158,79,0,2506,2510,3,160,80,0,2507,
  	2510,3,162,81,0,2508,2510,3,164,82,0,2509,2503,1,0,0,0,2509,2504,1,0,
  	0,0,2509,2505,1,0,0,0,2509,2506,1,0,0,0,2509,2507,1,0,0,0,2509,2508,1,
  	0,0,0,2510,129,1,0,0,0,2511,2512,5,530,0,0,2512,2513,3,1354,677,0,2513,
  	2514,5,235,0,0,2514,2515,5,154,0,0,2515,2516,5,673,0,0,2516,2517,3,1450,
  	725,0,2517,2518,3,132,66,0,2518,131,1,0,0,0,2519,2520,5,420,0,0,2520,
  	2521,5,32,0,0,2521,2526,3,134,67,0,2522,2523,5,29,0,0,2523,2525,3,134,
  	67,0,2524,2522,1,0,0,0,2525,2528,1,0,0,0,2526,2524,1,0,0,0,2526,2527,
  	1,0,0,0,2527,2529,1,0,0,0,2528,2526,1,0,0,0,2529,2530,5,33,0,0,2530,133,
  	1,0,0,0,2531,2532,5,260,0,0,2532,2546,3,1428,714,0,2533,2534,5,151,0,
  	0,2534,2546,3,1428,714,0,2535,2536,5,644,0,0,2536,2546,3,1428,714,0,2537,
  	2538,5,436,0,0,2538,2546,3,1428,714,0,2539,2540,5,545,0,0,2540,2546,3,
  	1428,714,0,2541,2542,5,428,0,0,2542,2546,3,1428,714,0,2543,2544,5,443,
  	0,0,2544,2546,3,1402,701,0,2545,2531,1,0,0,0,2545,2533,1,0,0,0,2545,2535,
  	1,0,0,0,2545,2537,1,0,0,0,2545,2539,1,0,0,0,2545,2541,1,0,0,0,2545,2543,
  	1,0,0,0,2546,135,1,0,0,0,2547,2548,5,598,0,0,2548,2549,3,1340,670,0,2549,
  	2554,3,140,70,0,2550,2551,5,646,0,0,2551,2552,5,320,0,0,2552,2553,5,253,
  	0,0,2553,2555,3,1346,673,0,2554,2550,1,0,0,0,2554,2555,1,0,0,0,2555,2557,
  	1,0,0,0,2556,2558,3,144,72,0,2557,2556,1,0,0,0,2557,2558,1,0,0,0,2558,
  	137,1,0,0,0,2559,2560,5,631,0,0,2560,2561,5,598,0,0,2561,2562,3,1340,
  	670,0,2562,2563,5,50,0,0,2563,2565,3,142,71,0,2564,2566,3,60,30,0,2565,
  	2564,1,0,0,0,2565,2566,1,0,0,0,2566,139,1,0,0,0,2567,2568,5,50,0,0,2568,
  	2575,3,142,71,0,2569,2572,4,70,36,0,2570,2571,5,50,0,0,2571,2573,3,142,
  	71,0,2572,2570,1,0,0,0,2572,2573,1,0,0,0,2573,2575,1,0,0,0,2574,2567,
  	1,0,0,0,2574,2569,1,0,0,0,2575,141,1,0,0,0,2576,2577,5,153,0,0,2577,2578,
  	3,1428,714,0,2578,143,1,0,0,0,2579,2586,3,146,73,0,2580,2582,5,29,0,0,
  	2581,2580,1,0,0,0,2581,2582,1,0,0,0,2582,2583,1,0,0,0,2583,2585,3,146,
  	73,0,2584,2581,1,0,0,0,2585,2588,1,0,0,0,2586,2584,1,0,0,0,2586,2587,
  	1,0,0,0,2587,145,1,0,0,0,2588,2586,1,0,0,0,2589,2602,3,148,74,0,2590,
  	2602,3,152,76,0,2591,2602,3,154,77,0,2592,2602,3,156,78,0,2593,2602,3,
  	158,79,0,2594,2602,3,160,80,0,2595,2602,3,162,81,0,2596,2602,3,164,82,
  	0,2597,2598,4,73,37,0,2598,2602,3,166,83,0,2599,2600,4,73,38,0,2600,2602,
  	3,168,84,0,2601,2589,1,0,0,0,2601,2590,1,0,0,0,2601,2591,1,0,0,0,2601,
  	2592,1,0,0,0,2601,2593,1,0,0,0,2601,2594,1,0,0,0,2601,2595,1,0,0,0,2601,
  	2596,1,0,0,0,2601,2597,1,0,0,0,2601,2599,1,0,0,0,2602,147,1,0,0,0,2603,
  	2605,5,274,0,0,2604,2606,5,6,0,0,2605,2604,1,0,0,0,2605,2606,1,0,0,0,
  	2606,2607,1,0,0,0,2607,2608,3,1456,728,0,2608,149,1,0,0,0,2609,2611,7,
  	11,0,0,2610,2612,5,6,0,0,2611,2610,1,0,0,0,2611,2612,1,0,0,0,2612,2613,
  	1,0,0,0,2613,2614,3,1456,728,0,2614,151,1,0,0,0,2615,2617,5,68,0,0,2616,
  	2618,5,6,0,0,2617,2616,1,0,0,0,2617,2618,1,0,0,0,2618,2619,1,0,0,0,2619,
  	2620,3,1456,728,0,2620,153,1,0,0,0,2621,2623,5,356,0,0,2622,2624,5,6,
  	0,0,2623,2622,1,0,0,0,2623,2624,1,0,0,0,2624,2625,1,0,0,0,2625,2626,3,
  	1456,728,0,2626,155,1,0,0,0,2627,2629,5,220,0,0,2628,2630,5,6,0,0,2629,
  	2628,1,0,0,0,2629,2630,1,0,0,0,2630,2631,1,0,0,0,2631,2632,3,1456,728,
  	0,2632,157,1,0,0,0,2633,2635,5,398,0,0,2634,2636,5,6,0,0,2635,2634,1,
  	0,0,0,2635,2636,1,0,0,0,2636,2637,1,0,0,0,2637,2638,3,1404,702,0,2638,
  	159,1,0,0,0,2639,2641,5,579,0,0,2640,2639,1,0,0,0,2640,2641,1,0,0,0,2641,
  	2642,1,0,0,0,2642,2644,5,202,0,0,2643,2645,5,6,0,0,2644,2643,1,0,0,0,
  	2644,2645,1,0,0,0,2645,2646,1,0,0,0,2646,2647,3,1358,679,0,2647,161,1,
  	0,0,0,2648,2649,7,12,0,0,2649,163,1,0,0,0,2650,2652,5,119,0,0,2651,2653,
  	5,6,0,0,2652,2651,1,0,0,0,2652,2653,1,0,0,0,2653,2654,1,0,0,0,2654,2655,
  	3,1428,714,0,2655,165,1,0,0,0,2656,2658,5,227,0,0,2657,2659,5,6,0,0,2658,
  	2657,1,0,0,0,2658,2659,1,0,0,0,2659,2660,1,0,0,0,2660,2661,3,1456,728,
  	0,2661,167,1,0,0,0,2662,2664,5,197,0,0,2663,2665,5,6,0,0,2664,2663,1,
  	0,0,0,2664,2665,1,0,0,0,2665,2666,1,0,0,0,2666,2667,3,1422,711,0,2667,
  	169,1,0,0,0,2668,2670,5,202,0,0,2669,2671,5,6,0,0,2670,2669,1,0,0,0,2670,
  	2671,1,0,0,0,2671,2672,1,0,0,0,2672,2673,3,1468,734,0,2673,171,1,0,0,
  	0,2674,2676,3,174,87,0,2675,2674,1,0,0,0,2675,2676,1,0,0,0,2676,2678,
  	1,0,0,0,2677,2679,3,1216,608,0,2678,2677,1,0,0,0,2678,2679,1,0,0,0,2679,
  	2681,1,0,0,0,2680,2682,3,178,89,0,2681,2680,1,0,0,0,2681,2682,1,0,0,0,
  	2682,2683,1,0,0,0,2683,2684,5,661,0,0,2684,2685,3,1336,668,0,2685,2686,
  	3,72,36,0,2686,173,1,0,0,0,2687,2688,5,424,0,0,2688,2690,5,488,0,0,2689,
  	2691,3,176,88,0,2690,2689,1,0,0,0,2690,2691,1,0,0,0,2691,2694,1,0,0,0,
  	2692,2694,3,176,88,0,2693,2687,1,0,0,0,2693,2692,1,0,0,0,2694,175,1,0,
  	0,0,2695,2696,5,55,0,0,2696,2697,5,6,0,0,2697,2698,7,13,0,0,2698,177,
  	1,0,0,0,2699,2700,5,563,0,0,2700,2701,5,523,0,0,2701,2702,7,10,0,0,2702,
  	179,1,0,0,0,2703,2705,3,1216,608,0,2704,2703,1,0,0,0,2704,2705,1,0,0,
  	0,2705,2706,1,0,0,0,2706,2709,5,620,0,0,2707,2708,4,90,39,0,2708,2710,
  	3,1224,612,0,2709,2707,1,0,0,0,2709,2710,1,0,0,0,2710,2711,1,0,0,0,2711,
  	2712,3,1332,666,0,2712,2713,7,14,0,0,2713,2714,7,15,0,0,2714,2715,5,413,
  	0,0,2715,2716,3,1366,683,0,2716,2717,5,236,0,0,2717,2718,5,192,0,0,2718,
  	2720,5,516,0,0,2719,2721,3,182,91,0,2720,2719,1,0,0,0,2720,2721,1,0,0,
  	0,2721,2722,1,0,0,0,2722,2723,3,1016,508,0,2723,181,1,0,0,0,2724,2725,
  	7,16,0,0,2725,2726,3,1450,725,0,2726,183,1,0,0,0,2727,2729,3,1216,608,
  	0,2728,2727,1,0,0,0,2728,2729,1,0,0,0,2729,2730,1,0,0,0,2730,2732,5,209,
  	0,0,2731,2733,3,1224,612,0,2732,2731,1,0,0,0,2732,2733,1,0,0,0,2733,2734,
  	1,0,0,0,2734,2735,3,1348,674,0,2735,2736,5,413,0,0,2736,2737,5,519,0,
  	0,2737,2744,3,1094,547,0,2738,2739,5,413,0,0,2739,2741,5,123,0,0,2740,
  	2742,5,401,0,0,2741,2740,1,0,0,0,2741,2742,1,0,0,0,2742,2743,1,0,0,0,
  	2743,2745,5,448,0,0,2744,2738,1,0,0,0,2744,2745,1,0,0,0,2745,2752,1,0,
  	0,0,2746,2753,5,195,0,0,2747,2750,5,180,0,0,2748,2749,5,413,0,0,2749,
  	2751,3,602,301,0,2750,2748,1,0,0,0,2750,2751,1,0,0,0,2751,2753,1,0,0,
  	0,2752,2746,1,0,0,0,2752,2747,1,0,0,0,2752,2753,1,0,0,0,2753,2756,1,0,
  	0,0,2754,2755,5,119,0,0,2755,2757,3,1428,714,0,2756,2754,1,0,0,0,2756,
  	2757,1,0,0,0,2757,2758,1,0,0,0,2758,2759,5,186,0,0,2759,2760,3,1016,508,
  	0,2760,185,1,0,0,0,2761,2763,5,684,0,0,2762,2764,3,1224,612,0,2763,2762,
  	1,0,0,0,2763,2764,1,0,0,0,2764,2765,1,0,0,0,2765,2766,3,678,339,0,2766,
  	187,1,0,0,0,2767,2768,5,424,0,0,2768,2769,5,488,0,0,2769,2770,5,549,0,
  	0,2770,2771,5,743,0,0,2771,2772,5,735,0,0,2772,2776,3,1408,704,0,2773,
  	2775,3,190,95,0,2774,2773,1,0,0,0,2775,2778,1,0,0,0,2776,2774,1,0,0,0,
  	2776,2777,1,0,0,0,2777,2793,1,0,0,0,2778,2776,1,0,0,0,2779,2780,5,549,
  	0,0,2780,2781,5,743,0,0,2781,2783,5,735,0,0,2782,2784,3,1224,612,0,2783,
  	2782,1,0,0,0,2783,2784,1,0,0,0,2784,2785,1,0,0,0,2785,2789,3,1408,704,
  	0,2786,2788,3,190,95,0,2787,2786,1,0,0,0,2788,2791,1,0,0,0,2789,2787,
  	1,0,0,0,2789,2790,1,0,0,0,2790,2793,1,0,0,0,2791,2789,1,0,0,0,2792,2767,
  	1,0,0,0,2792,2779,1,0,0,0,2793,189,1,0,0,0,2794,2795,5,388,0,0,2795,2796,
  	5,606,0,0,2796,2810,3,1430,715,0,2797,2798,5,740,0,0,2798,2799,5,606,
  	0,0,2799,2810,3,1430,715,0,2800,2801,5,742,0,0,2801,2802,3,1430,715,0,
  	2802,2803,5,266,0,0,2803,2804,5,90,0,0,2804,2805,3,1408,704,0,2805,2810,
  	1,0,0,0,2806,2807,5,741,0,0,2807,2808,5,606,0,0,2808,2810,3,1430,715,
  	0,2809,2794,1,0,0,0,2809,2797,1,0,0,0,2809,2800,1,0,0,0,2809,2806,1,0,
  	0,0,2810,191,1,0,0,0,2811,2829,5,187,0,0,2812,2830,3,194,97,0,2813,2830,
  	3,196,98,0,2814,2830,3,198,99,0,2815,2830,3,200,100,0,2816,2830,3,202,
  	101,0,2817,2830,3,204,102,0,2818,2830,3,208,104,0,2819,2830,3,210,105,
  	0,2820,2830,3,212,106,0,2821,2830,3,214,107,0,2822,2830,3,216,108,0,2823,
  	2824,4,96,40,0,2824,2830,3,218,109,0,2825,2826,4,96,41,0,2826,2830,3,
  	220,110,0,2827,2828,4,96,42,0,2828,2830,3,222,111,0,2829,2812,1,0,0,0,
  	2829,2813,1,0,0,0,2829,2814,1,0,0,0,2829,2815,1,0,0,0,2829,2816,1,0,0,
  	0,2829,2817,1,0,0,0,2829,2818,1,0,0,0,2829,2819,1,0,0,0,2829,2820,1,0,
  	0,0,2829,2821,1,0,0,0,2829,2822,1,0,0,0,2829,2823,1,0,0,0,2829,2825,1,
  	0,0,0,2829,2827,1,0,0,0,2830,193,1,0,0,0,2831,2833,5,151,0,0,2832,2834,
  	3,1218,609,0,2833,2832,1,0,0,0,2833,2834,1,0,0,0,2834,2835,1,0,0,0,2835,
  	2836,3,1322,661,0,2836,195,1,0,0,0,2837,2839,5,209,0,0,2838,2840,3,1218,
  	609,0,2839,2838,1,0,0,0,2839,2840,1,0,0,0,2840,2841,1,0,0,0,2841,2842,
  	3,1350,675,0,2842,197,1,0,0,0,2843,2845,5,242,0,0,2844,2846,3,1218,609,
  	0,2845,2844,1,0,0,0,2845,2846,1,0,0,0,2846,2847,1,0,0,0,2847,2848,3,1330,
  	665,0,2848,199,1,0,0,0,2849,2851,5,452,0,0,2850,2852,3,1218,609,0,2851,
  	2850,1,0,0,0,2851,2852,1,0,0,0,2852,2853,1,0,0,0,2853,2854,3,1326,663,
  	0,2854,201,1,0,0,0,2855,2857,3,1296,648,0,2856,2855,1,0,0,0,2856,2857,
  	1,0,0,0,2857,2858,1,0,0,0,2858,2859,5,272,0,0,2859,2860,3,1316,658,0,
  	2860,2861,5,413,0,0,2861,2863,3,1366,683,0,2862,2864,3,48,24,0,2863,2862,
  	1,0,0,0,2863,2864,1,0,0,0,2864,203,1,0,0,0,2865,2866,5,320,0,0,2866,2867,
  	5,253,0,0,2867,2878,3,1346,673,0,2868,2875,3,206,103,0,2869,2871,5,29,
  	0,0,2870,2869,1,0,0,0,2870,2871,1,0,0,0,2871,2872,1,0,0,0,2872,2874,3,
  	206,103,0,2873,2870,1,0,0,0,2874,2877,1,0,0,0,2875,2873,1,0,0,0,2875,
  	2876,1,0,0,0,2876,2879,1,0,0,0,2877,2875,1,0,0,0,2878,2868,1,0,0,0,2878,
  	2879,1,0,0,0,2879,205,1,0,0,0,2880,2883,3,162,81,0,2881,2883,3,160,80,
  	0,2882,2880,1,0,0,0,2882,2881,1,0,0,0,2883,207,1,0,0,0,2884,2886,5,530,
  	0,0,2885,2887,3,1218,609,0,2886,2885,1,0,0,0,2886,2887,1,0,0,0,2887,2888,
  	1,0,0,0,2888,2889,3,1356,678,0,2889,209,1,0,0,0,2890,2892,5,603,0,0,2891,
  	2890,1,0,0,0,2891,2892,1,0,0,0,2892,2893,1,0,0,0,2893,2895,7,17,0,0,2894,
  	2896,3,1218,609,0,2895,2894,1,0,0,0,2895,2896,1,0,0,0,2896,2897,1,0,0,
  	0,2897,2899,3,1368,684,0,2898,2900,7,2,0,0,2899,2898,1,0,0,0,2899,2900,
  	1,0,0,0,2900,211,1,0,0,0,2901,2902,5,598,0,0,2902,2913,3,1342,671,0,2903,
  	2910,3,206,103,0,2904,2906,5,29,0,0,2905,2904,1,0,0,0,2905,2906,1,0,0,
  	0,2906,2907,1,0,0,0,2907,2909,3,206,103,0,2908,2905,1,0,0,0,2909,2912,
  	1,0,0,0,2910,2908,1,0,0,0,2910,2911,1,0,0,0,2911,2914,1,0,0,0,2912,2910,
  	1,0,0,0,2913,2903,1,0,0,0,2913,2914,1,0,0,0,2914,213,1,0,0,0,2915,2917,
  	5,620,0,0,2916,2918,3,1218,609,0,2917,2916,1,0,0,0,2917,2918,1,0,0,0,
  	2918,2919,1,0,0,0,2919,2920,3,1334,667,0,2920,215,1,0,0,0,2921,2923,5,
  	661,0,0,2922,2924,3,1218,609,0,2923,2922,1,0,0,0,2923,2924,1,0,0,0,2924,
  	2925,1,0,0,0,2925,2927,3,1238,619,0,2926,2928,7,2,0,0,2927,2926,1,0,0,
  	0,2927,2928,1,0,0,0,2928,217,1,0,0,0,2929,2931,5,684,0,0,2930,2932,3,
  	1218,609,0,2931,2930,1,0,0,0,2931,2932,1,0,0,0,2932,2933,1,0,0,0,2933,
  	2934,3,678,339,0,2934,219,1,0,0,0,2935,2936,5,549,0,0,2936,2937,5,743,
  	0,0,2937,2939,5,735,0,0,2938,2940,3,1218,609,0,2939,2938,1,0,0,0,2939,
  	2940,1,0,0,0,2940,2941,1,0,0,0,2941,2942,3,1408,704,0,2942,221,1,0,0,
  	0,2943,2944,5,631,0,0,2944,2945,5,598,0,0,2945,2947,3,1342,671,0,2946,
  	2948,3,60,30,0,2947,2946,1,0,0,0,2947,2948,1,0,0,0,2948,223,1,0,0,0,2949,
  	2950,5,483,0,0,2950,2951,7,17,0,0,2951,2956,3,226,113,0,2952,2953,5,29,
  	0,0,2953,2955,3,226,113,0,2954,2952,1,0,0,0,2955,2958,1,0,0,0,2956,2954,
  	1,0,0,0,2956,2957,1,0,0,0,2957,225,1,0,0,0,2958,2956,1,0,0,0,2959,2960,
  	3,1366,683,0,2960,2961,5,616,0,0,2961,2962,3,1360,680,0,2962,227,1,0,
  	0,0,2963,2965,5,623,0,0,2964,2966,5,600,0,0,2965,2964,1,0,0,0,2965,2966,
  	1,0,0,0,2966,2967,1,0,0,0,2967,2968,3,1366,683,0,2968,229,1,0,0,0,2969,
  	2970,5,270,0,0,2970,2971,5,600,0,0,2971,2972,5,239,0,0,2972,2973,3,1432,
  	716,0,2973,231,1,0,0,0,2974,2975,5,93,0,0,2975,2981,3,1326,663,0,2976,
  	2978,5,32,0,0,2977,2979,3,988,494,0,2978,2977,1,0,0,0,2978,2979,1,0,0,
  	0,2979,2980,1,0,0,0,2980,2982,5,33,0,0,2981,2976,1,0,0,0,2981,2982,1,
  	0,0,0,2982,233,1,0,0,0,2983,2984,4,117,43,0,2984,2986,3,350,175,0,2985,
  	2983,1,0,0,0,2985,2986,1,0,0,0,2986,2987,1,0,0,0,2987,2991,5,173,0,0,
  	2988,2990,3,238,119,0,2989,2988,1,0,0,0,2990,2993,1,0,0,0,2991,2989,1,
  	0,0,0,2991,2992,1,0,0,0,2992,3026,1,0,0,0,2993,2991,1,0,0,0,2994,3018,
  	5,239,0,0,2995,2996,3,1370,685,0,2996,2997,5,647,0,0,2997,2999,3,364,
  	182,0,2998,3000,3,388,194,0,2999,2998,1,0,0,0,2999,3000,1,0,0,0,3000,
  	3019,1,0,0,0,3001,3004,3,1366,683,0,3002,3003,4,117,44,0,3003,3005,3,
  	430,215,0,3004,3002,1,0,0,0,3004,3005,1,0,0,0,3005,3007,1,0,0,0,3006,
  	3008,3,236,118,0,3007,3006,1,0,0,0,3007,3008,1,0,0,0,3008,3010,1,0,0,
  	0,3009,3011,3,388,194,0,3010,3009,1,0,0,0,3010,3011,1,0,0,0,3011,3013,
  	1,0,0,0,3012,3014,3,358,179,0,3013,3012,1,0,0,0,3013,3014,1,0,0,0,3014,
  	3016,1,0,0,0,3015,3017,3,316,158,0,3016,3015,1,0,0,0,3016,3017,1,0,0,
  	0,3017,3019,1,0,0,0,3018,2995,1,0,0,0,3018,3001,1,0,0,0,3019,3027,1,0,
  	0,0,3020,3021,3,1370,685,0,3021,3022,5,239,0,0,3022,3024,3,364,182,0,
  	3023,3025,3,388,194,0,3024,3023,1,0,0,0,3024,3025,1,0,0,0,3025,3027,1,
  	0,0,0,3026,2994,1,0,0,0,3026,3020,1,0,0,0,3027,235,1,0,0,0,3028,3029,
  	5,435,0,0,3029,3030,5,32,0,0,3030,3031,3,1392,696,0,3031,3032,5,33,0,
  	0,3032,237,1,0,0,0,3033,3034,7,18,0,0,3034,239,1,0,0,0,3035,3040,5,186,
  	0,0,3036,3037,4,120,45,0,3037,3041,3,988,494,0,3038,3039,4,120,46,0,3039,
  	3041,3,382,191,0,3040,3036,1,0,0,0,3040,3038,1,0,0,0,3041,241,1,0,0,0,
  	3042,3060,5,255,0,0,3043,3044,3,1366,683,0,3044,3046,5,417,0,0,3045,3047,
  	3,430,215,0,3046,3045,1,0,0,0,3046,3047,1,0,0,0,3047,3061,1,0,0,0,3048,
  	3058,3,1390,695,0,3049,3059,5,110,0,0,3050,3051,5,465,0,0,3051,3053,3,
  	244,122,0,3052,3054,3,388,194,0,3053,3052,1,0,0,0,3053,3054,1,0,0,0,3054,
  	3056,1,0,0,0,3055,3057,3,314,157,0,3056,3055,1,0,0,0,3056,3057,1,0,0,
  	0,3057,3059,1,0,0,0,3058,3049,1,0,0,0,3058,3050,1,0,0,0,3059,3061,1,0,
  	0,0,3060,3043,1,0,0,0,3060,3048,1,0,0,0,3061,243,1,0,0,0,3062,3073,7,
  	19,0,0,3063,3070,3,1390,695,0,3064,3071,7,20,0,0,3065,3066,7,21,0,0,3066,
  	3067,5,32,0,0,3067,3068,3,260,130,0,3068,3069,5,33,0,0,3069,3071,1,0,
  	0,0,3070,3064,1,0,0,0,3070,3065,1,0,0,0,3071,3073,1,0,0,0,3072,3062,1,
  	0,0,0,3072,3063,1,0,0,0,3073,245,1,0,0,0,3074,3076,5,278,0,0,3075,3077,
  	3,248,124,0,3076,3075,1,0,0,0,3076,3077,1,0,0,0,3077,3079,1,0,0,0,3078,
  	3080,5,268,0,0,3079,3078,1,0,0,0,3079,3080,1,0,0,0,3080,3082,1,0,0,0,
  	3081,3083,5,283,0,0,3082,3081,1,0,0,0,3082,3083,1,0,0,0,3083,3084,1,0,
  	0,0,3084,3086,3,1366,683,0,3085,3087,3,1300,650,0,3086,3085,1,0,0,0,3086,
  	3087,1,0,0,0,3087,3098,1,0,0,0,3088,3090,3,250,125,0,3089,3091,3,262,
  	131,0,3090,3089,1,0,0,0,3090,3091,1,0,0,0,3091,3099,1,0,0,0,3092,3093,
  	5,533,0,0,3093,3095,3,1240,620,0,3094,3096,3,262,131,0,3095,3094,1,0,
  	0,0,3095,3096,1,0,0,0,3096,3099,1,0,0,0,3097,3099,3,256,128,0,3098,3088,
  	1,0,0,0,3098,3092,1,0,0,0,3098,3097,1,0,0,0,3099,3101,1,0,0,0,3100,3102,
  	3,264,132,0,3101,3100,1,0,0,0,3101,3102,1,0,0,0,3102,247,1,0,0,0,3103,
  	3104,7,22,0,0,3104,249,1,0,0,0,3105,3107,5,32,0,0,3106,3108,3,252,126,
  	0,3107,3106,1,0,0,0,3107,3108,1,0,0,0,3108,3109,1,0,0,0,3109,3111,5,33,
  	0,0,3110,3105,1,0,0,0,3110,3111,1,0,0,0,3111,3112,1,0,0,0,3112,3113,3,
  	254,127,0,3113,251,1,0,0,0,3114,3119,3,1312,656,0,3115,3116,5,29,0,0,
  	3116,3118,3,1312,656,0,3117,3115,1,0,0,0,3118,3121,1,0,0,0,3119,3117,
  	1,0,0,0,3119,3120,1,0,0,0,3120,253,1,0,0,0,3121,3119,1,0,0,0,3122,3123,
  	7,23,0,0,3123,3124,3,258,129,0,3124,255,1,0,0,0,3125,3136,3,300,150,0,
  	3126,3136,3,304,152,0,3127,3129,5,32,0,0,3128,3130,3,252,126,0,3129,3128,
  	1,0,0,0,3129,3130,1,0,0,0,3130,3131,1,0,0,0,3131,3133,5,33,0,0,3132,3127,
  	1,0,0,0,3132,3133,1,0,0,0,3133,3134,1,0,0,0,3134,3136,3,98,49,0,3135,
  	3125,1,0,0,0,3135,3126,1,0,0,0,3135,3132,1,0,0,0,3136,257,1,0,0,0,3137,
  	3139,5,32,0,0,3138,3140,3,260,130,0,3139,3138,1,0,0,0,3139,3140,1,0,0,
  	0,3140,3141,1,0,0,0,3141,3150,5,33,0,0,3142,3143,5,29,0,0,3143,3145,5,
  	32,0,0,3144,3146,3,260,130,0,3145,3144,1,0,0,0,3145,3146,1,0,0,0,3146,
  	3147,1,0,0,0,3147,3149,5,33,0,0,3148,3142,1,0,0,0,3149,3152,1,0,0,0,3150,
  	3148,1,0,0,0,3150,3151,1,0,0,0,3151,259,1,0,0,0,3152,3150,1,0,0,0,3153,
  	3156,3,898,449,0,3154,3156,5,168,0,0,3155,3153,1,0,0,0,3155,3154,1,0,
  	0,0,3156,3164,1,0,0,0,3157,3160,5,29,0,0,3158,3161,3,898,449,0,3159,3161,
  	5,168,0,0,3160,3158,1,0,0,0,3160,3159,1,0,0,0,3161,3163,1,0,0,0,3162,
  	3157,1,0,0,0,3163,3166,1,0,0,0,3164,3162,1,0,0,0,3164,3165,1,0,0,0,3165,
  	261,1,0,0,0,3166,3164,1,0,0,0,3167,3168,4,131,47,0,3168,3169,5,63,0,0,
  	3169,3171,3,1390,695,0,3170,3172,3,1308,654,0,3171,3170,1,0,0,0,3171,
  	3172,1,0,0,0,3172,263,1,0,0,0,3173,3174,5,413,0,0,3174,3175,5,190,0,0,
  	3175,3176,5,299,0,0,3176,3177,5,640,0,0,3177,3178,3,1240,620,0,3178,265,
  	1,0,0,0,3179,3180,5,315,0,0,3180,3182,3,268,134,0,3181,3183,3,270,135,
  	0,3182,3181,1,0,0,0,3182,3183,1,0,0,0,3183,3185,1,0,0,0,3184,3186,3,272,
  	136,0,3185,3184,1,0,0,0,3185,3186,1,0,0,0,3186,3188,1,0,0,0,3187,3189,
  	5,316,0,0,3188,3187,1,0,0,0,3188,3189,1,0,0,0,3189,3191,1,0,0,0,3190,
  	3192,3,274,137,0,3191,3190,1,0,0,0,3191,3192,1,0,0,0,3192,3193,1,0,0,
  	0,3193,3195,3,1422,711,0,3194,3196,3,276,138,0,3195,3194,1,0,0,0,3195,
  	3196,1,0,0,0,3196,3198,1,0,0,0,3197,3199,3,278,139,0,3198,3197,1,0,0,
  	0,3198,3199,1,0,0,0,3199,3201,1,0,0,0,3200,3202,7,8,0,0,3201,3200,1,0,
  	0,0,3201,3202,1,0,0,0,3202,3203,1,0,0,0,3203,3204,5,283,0,0,3204,3205,
  	5,600,0,0,3205,3207,3,1366,683,0,3206,3208,3,1300,650,0,3207,3206,1,0,
  	0,0,3207,3208,1,0,0,0,3208,3210,1,0,0,0,3209,3211,3,1244,622,0,3210,3209,
  	1,0,0,0,3210,3211,1,0,0,0,3211,3213,1,0,0,0,3212,3214,3,280,140,0,3213,
  	3212,1,0,0,0,3213,3214,1,0,0,0,3214,3216,1,0,0,0,3215,3217,3,1246,623,
  	0,3216,3215,1,0,0,0,3216,3217,1,0,0,0,3217,3219,1,0,0,0,3218,3220,3,1250,
  	625,0,3219,3218,1,0,0,0,3219,3220,1,0,0,0,3220,3221,1,0,0,0,3221,3223,
  	3,282,141,0,3222,3224,3,290,145,0,3223,3222,1,0,0,0,3223,3224,1,0,0,0,
  	3224,3226,1,0,0,0,3225,3227,3,292,146,0,3226,3225,1,0,0,0,3226,3227,1,
  	0,0,0,3227,3229,1,0,0,0,3228,3230,3,288,144,0,3229,3228,1,0,0,0,3229,
  	3230,1,0,0,0,3230,267,1,0,0,0,3231,3232,7,24,0,0,3232,269,1,0,0,0,3233,
  	3234,7,25,0,0,3234,271,1,0,0,0,3235,3236,4,136,48,0,3236,3237,5,239,0,
  	0,3237,273,1,0,0,0,3238,3242,5,273,0,0,3239,3240,4,137,49,0,3240,3242,
  	7,26,0,0,3241,3238,1,0,0,0,3241,3239,1,0,0,0,3242,275,1,0,0,0,3243,3249,
  	4,138,50,0,3244,3245,5,138,0,0,3245,3250,5,3,0,0,3246,3247,3,1388,694,
  	0,3247,3248,5,3,0,0,3248,3250,1,0,0,0,3249,3244,1,0,0,0,3249,3246,1,0,
  	0,0,3250,277,1,0,0,0,3251,3252,4,139,51,0,3252,3253,5,286,0,0,3253,3254,
  	5,450,0,0,3254,3255,5,299,0,0,3255,3256,5,423,0,0,3256,279,1,0,0,0,3257,
  	3258,5,513,0,0,3258,3259,5,266,0,0,3259,3260,5,90,0,0,3260,3261,3,1424,
  	712,0,3261,281,1,0,0,0,3262,3263,5,268,0,0,3263,3264,5,3,0,0,3264,3266,
  	7,27,0,0,3265,3262,1,0,0,0,3265,3266,1,0,0,0,3266,3268,1,0,0,0,3267,3269,
  	3,284,142,0,3268,3267,1,0,0,0,3268,3269,1,0,0,0,3269,3272,1,0,0,0,3270,
  	3271,5,533,0,0,3271,3273,3,1240,620,0,3272,3270,1,0,0,0,3272,3273,1,0,
  	0,0,3273,283,1,0,0,0,3274,3276,5,32,0,0,3275,3277,3,286,143,0,3276,3275,
  	1,0,0,0,3276,3277,1,0,0,0,3277,3278,1,0,0,0,3278,3279,5,33,0,0,3279,285,
  	1,0,0,0,3280,3283,3,1310,655,0,3281,3283,3,968,484,0,3282,3280,1,0,0,
  	0,3282,3281,1,0,0,0,3283,3291,1,0,0,0,3284,3287,5,29,0,0,3285,3288,3,
  	1310,655,0,3286,3288,3,968,484,0,3287,3285,1,0,0,0,3287,3286,1,0,0,0,
  	3288,3290,1,0,0,0,3289,3284,1,0,0,0,3290,3293,1,0,0,0,3291,3289,1,0,0,
  	0,3291,3292,1,0,0,0,3292,287,1,0,0,0,3293,3291,1,0,0,0,3294,3295,4,144,
  	52,0,3295,3296,5,55,0,0,3296,3297,5,6,0,0,3297,3298,5,821,0,0,3298,289,
  	1,0,0,0,3299,3300,4,145,53,0,3300,3301,5,827,0,0,3301,3302,5,6,0,0,3302,
  	3303,5,3,0,0,3303,291,1,0,0,0,3304,3305,4,146,54,0,3305,3306,5,366,0,
  	0,3306,3307,5,6,0,0,3307,3308,3,1456,728,0,3308,293,1,0,0,0,3309,3311,
  	5,488,0,0,3310,3312,7,28,0,0,3311,3310,1,0,0,0,3311,3312,1,0,0,0,3312,
  	3314,1,0,0,0,3313,3315,5,283,0,0,3314,3313,1,0,0,0,3314,3315,1,0,0,0,
  	3315,3316,1,0,0,0,3316,3318,3,1366,683,0,3317,3319,3,1300,650,0,3318,
  	3317,1,0,0,0,3318,3319,1,0,0,0,3319,3324,1,0,0,0,3320,3325,3,250,125,
  	0,3321,3322,5,533,0,0,3322,3325,3,1240,620,0,3323,3325,3,256,128,0,3324,
  	3320,1,0,0,0,3324,3321,1,0,0,0,3324,3323,1,0,0,0,3325,295,1,0,0,0,3326,
  	3328,3,300,150,0,3327,3329,3,374,187,0,3328,3327,1,0,0,0,3328,3329,1,
  	0,0,0,3329,3332,1,0,0,0,3330,3332,3,298,149,0,3331,3326,1,0,0,0,3331,
  	3330,1,0,0,0,3332,297,1,0,0,0,3333,3334,5,32,0,0,3334,3335,3,298,149,
  	0,3335,3336,5,33,0,0,3336,3351,1,0,0,0,3337,3338,3,300,150,0,3338,3340,
  	3,322,161,0,3339,3341,3,374,187,0,3340,3339,1,0,0,0,3340,3341,1,0,0,0,
  	3341,3351,1,0,0,0,3342,3343,3,300,150,0,3343,3344,3,374,187,0,3344,3345,
  	3,322,161,0,3345,3351,1,0,0,0,3346,3347,4,149,55,0,3347,3348,3,304,152,
  	0,3348,3349,3,322,161,0,3349,3351,1,0,0,0,3350,3333,1,0,0,0,3350,3337,
  	1,0,0,0,3350,3342,1,0,0,0,3350,3346,1,0,0,0,3351,299,1,0,0,0,3352,3353,
  	4,150,56,0,3353,3355,3,350,175,0,3354,3352,1,0,0,0,3354,3355,1,0,0,0,
  	3355,3356,1,0,0,0,3356,3358,3,302,151,0,3357,3359,3,358,179,0,3358,3357,
  	1,0,0,0,3358,3359,1,0,0,0,3359,3361,1,0,0,0,3360,3362,3,314,157,0,3361,
  	3360,1,0,0,0,3361,3362,1,0,0,0,3362,3365,1,0,0,0,3363,3364,4,150,57,0,
  	3364,3366,3,324,162,0,3365,3363,1,0,0,0,3365,3366,1,0,0,0,3366,301,1,
  	0,0,0,3367,3370,3,306,153,0,3368,3370,3,304,152,0,3369,3367,1,0,0,0,3369,
  	3368,1,0,0,0,3370,3382,1,0,0,0,3371,3375,5,634,0,0,3372,3373,4,151,58,
  	0,3373,3375,7,29,0,0,3374,3371,1,0,0,0,3374,3372,1,0,0,0,3375,3377,1,
  	0,0,0,3376,3378,3,428,214,0,3377,3376,1,0,0,0,3377,3378,1,0,0,0,3378,
  	3379,1,0,0,0,3379,3381,3,302,151,0,3380,3374,1,0,0,0,3381,3384,1,0,0,
  	0,3382,3380,1,0,0,0,3382,3383,1,0,0,0,3383,303,1,0,0,0,3384,3382,1,0,
  	0,0,3385,3388,5,32,0,0,3386,3389,3,304,152,0,3387,3389,3,98,49,0,3388,
  	3386,1,0,0,0,3388,3387,1,0,0,0,3389,3390,1,0,0,0,3390,3391,5,33,0,0,3391,
  	305,1,0,0,0,3392,3398,3,308,154,0,3393,3394,4,153,59,0,3394,3398,3,366,
  	183,0,3395,3396,4,153,60,0,3396,3398,3,368,184,0,3397,3392,1,0,0,0,3397,
  	3393,1,0,0,0,3397,3395,1,0,0,0,3398,307,1,0,0,0,3399,3403,5,524,0,0,3400,
  	3402,3,372,186,0,3401,3400,1,0,0,0,3402,3405,1,0,0,0,3403,3401,1,0,0,
  	0,3403,3404,1,0,0,0,3404,3406,1,0,0,0,3405,3403,1,0,0,0,3406,3408,3,382,
  	191,0,3407,3409,3,322,161,0,3408,3407,1,0,0,0,3408,3409,1,0,0,0,3409,
  	3411,1,0,0,0,3410,3412,3,362,181,0,3411,3410,1,0,0,0,3411,3412,1,0,0,
  	0,3412,3414,1,0,0,0,3413,3415,3,388,194,0,3414,3413,1,0,0,0,3414,3415,
  	1,0,0,0,3415,3417,1,0,0,0,3416,3418,3,354,177,0,3417,3416,1,0,0,0,3417,
  	3418,1,0,0,0,3418,3420,1,0,0,0,3419,3421,3,326,163,0,3420,3419,1,0,0,
  	0,3420,3421,1,0,0,0,3421,3424,1,0,0,0,3422,3423,4,154,61,0,3423,3425,
  	3,328,164,0,3424,3422,1,0,0,0,3424,3425,1,0,0,0,3425,309,1,0,0,0,3426,
  	3427,3,304,152,0,3427,311,1,0,0,0,3428,3429,7,30,0,0,3429,313,1,0,0,0,
  	3430,3431,5,310,0,0,3431,3432,3,318,159,0,3432,315,1,0,0,0,3433,3434,
  	5,310,0,0,3434,3435,3,320,160,0,3435,317,1,0,0,0,3436,3439,3,320,160,
  	0,3437,3438,7,31,0,0,3438,3440,3,320,160,0,3439,3437,1,0,0,0,3439,3440,
  	1,0,0,0,3440,319,1,0,0,0,3441,3444,3,1390,695,0,3442,3444,7,32,0,0,3443,
  	3441,1,0,0,0,3443,3442,1,0,0,0,3444,321,1,0,0,0,3445,3473,5,283,0,0,3446,
  	3447,5,426,0,0,3447,3449,3,1422,711,0,3448,3450,3,1244,622,0,3449,3448,
  	1,0,0,0,3449,3450,1,0,0,0,3450,3452,1,0,0,0,3451,3453,3,1246,623,0,3452,
  	3451,1,0,0,0,3452,3453,1,0,0,0,3453,3455,1,0,0,0,3454,3456,3,1250,625,
  	0,3455,3454,1,0,0,0,3455,3456,1,0,0,0,3456,3474,1,0,0,0,3457,3458,5,189,
  	0,0,3458,3474,3,1422,711,0,3459,3462,3,1450,725,0,3460,3462,3,968,484,
  	0,3461,3459,1,0,0,0,3461,3460,1,0,0,0,3462,3470,1,0,0,0,3463,3466,5,29,
  	0,0,3464,3467,3,1450,725,0,3465,3467,3,968,484,0,3466,3464,1,0,0,0,3466,
  	3465,1,0,0,0,3467,3469,1,0,0,0,3468,3463,1,0,0,0,3469,3472,1,0,0,0,3470,
  	3468,1,0,0,0,3470,3471,1,0,0,0,3471,3474,1,0,0,0,3472,3470,1,0,0,0,3473,
  	3446,1,0,0,0,3473,3457,1,0,0,0,3473,3461,1,0,0,0,3474,323,1,0,0,0,3475,
  	3476,5,452,0,0,3476,3477,5,59,0,0,3477,3483,5,32,0,0,3478,3481,5,3,0,
  	0,3479,3480,5,29,0,0,3480,3482,5,3,0,0,3481,3479,1,0,0,0,3481,3482,1,
  	0,0,0,3482,3484,1,0,0,0,3483,3478,1,0,0,0,3483,3484,1,0,0,0,3484,3485,
  	1,0,0,0,3485,3486,5,33,0,0,3486,325,1,0,0,0,3487,3488,5,257,0,0,3488,
  	3489,3,898,449,0,3489,327,1,0,0,0,3490,3491,5,724,0,0,3491,3496,3,330,
  	165,0,3492,3493,5,29,0,0,3493,3495,3,330,165,0,3494,3492,1,0,0,0,3495,
  	3498,1,0,0,0,3496,3494,1,0,0,0,3496,3497,1,0,0,0,3497,329,1,0,0,0,3498,
  	3496,1,0,0,0,3499,3500,3,1386,693,0,3500,3501,5,63,0,0,3501,3502,3,332,
  	166,0,3502,331,1,0,0,0,3503,3504,5,32,0,0,3504,3505,3,334,167,0,3505,
  	3506,5,33,0,0,3506,333,1,0,0,0,3507,3509,3,1386,693,0,3508,3507,1,0,0,
  	0,3508,3509,1,0,0,0,3509,3513,1,0,0,0,3510,3511,5,435,0,0,3511,3512,5,
  	90,0,0,3512,3514,3,1006,503,0,3513,3510,1,0,0,0,3513,3514,1,0,0,0,3514,
  	3516,1,0,0,0,3515,3517,3,358,179,0,3516,3515,1,0,0,0,3516,3517,1,0,0,
  	0,3517,3519,1,0,0,0,3518,3520,3,336,168,0,3519,3518,1,0,0,0,3519,3520,
  	1,0,0,0,3520,335,1,0,0,0,3521,3522,3,338,169,0,3522,3524,3,340,170,0,
  	3523,3525,3,348,174,0,3524,3523,1,0,0,0,3524,3525,1,0,0,0,3525,337,1,
  	0,0,0,3526,3527,7,33,0,0,3527,339,1,0,0,0,3528,3531,3,342,171,0,3529,
  	3531,3,344,172,0,3530,3528,1,0,0,0,3530,3529,1,0,0,0,3531,341,1,0,0,0,
  	3532,3533,5,723,0,0,3533,3547,5,718,0,0,3534,3535,3,1406,703,0,3535,3536,
  	5,718,0,0,3536,3547,1,0,0,0,3537,3538,5,42,0,0,3538,3547,5,718,0,0,3539,
  	3540,5,282,0,0,3540,3541,3,898,449,0,3541,3542,3,996,498,0,3542,3543,
  	5,718,0,0,3543,3547,1,0,0,0,3544,3545,5,144,0,0,3545,3547,5,516,0,0,3546,
  	3532,1,0,0,0,3546,3534,1,0,0,0,3546,3537,1,0,0,0,3546,3539,1,0,0,0,3546,
  	3544,1,0,0,0,3547,343,1,0,0,0,3548,3549,5,75,0,0,3549,3550,3,346,173,
  	0,3550,3551,5,61,0,0,3551,3552,3,346,173,0,3552,345,1,0,0,0,3553,3567,
  	3,342,171,0,3554,3555,5,723,0,0,3555,3567,5,707,0,0,3556,3557,3,1406,
  	703,0,3557,3558,5,707,0,0,3558,3567,1,0,0,0,3559,3560,5,42,0,0,3560,3567,
  	5,707,0,0,3561,3562,5,282,0,0,3562,3563,3,898,449,0,3563,3564,3,996,498,
  	0,3564,3565,5,707,0,0,3565,3567,1,0,0,0,3566,3553,1,0,0,0,3566,3554,1,
  	0,0,0,3566,3556,1,0,0,0,3566,3559,1,0,0,0,3566,3561,1,0,0,0,3567,347,
  	1,0,0,0,3568,3575,5,705,0,0,3569,3570,5,144,0,0,3570,3576,5,516,0,0,3571,
  	3576,5,253,0,0,3572,3576,5,722,0,0,3573,3574,5,403,0,0,3574,3576,5,715,
  	0,0,3575,3569,1,0,0,0,3575,3571,1,0,0,0,3575,3572,1,0,0,0,3575,3573,1,
  	0,0,0,3576,349,1,0,0,0,3577,3579,5,670,0,0,3578,3580,5,690,0,0,3579,3578,
  	1,0,0,0,3579,3580,1,0,0,0,3580,3581,1,0,0,0,3581,3586,3,352,176,0,3582,
  	3583,5,29,0,0,3583,3585,3,352,176,0,3584,3582,1,0,0,0,3585,3588,1,0,0,
  	0,3586,3584,1,0,0,0,3586,3587,1,0,0,0,3587,351,1,0,0,0,3588,3586,1,0,
  	0,0,3589,3591,3,1390,695,0,3590,3592,3,1308,654,0,3591,3590,1,0,0,0,3591,
  	3592,1,0,0,0,3592,3593,1,0,0,0,3593,3594,5,63,0,0,3594,3595,3,310,155,
  	0,3595,353,1,0,0,0,3596,3597,5,253,0,0,3597,3598,5,90,0,0,3598,3600,3,
  	1006,503,0,3599,3601,3,356,178,0,3600,3599,1,0,0,0,3600,3601,1,0,0,0,
  	3601,3611,1,0,0,0,3602,3603,4,177,62,0,3603,3604,5,253,0,0,3604,3605,
  	5,90,0,0,3605,3606,7,34,0,0,3606,3607,5,32,0,0,3607,3608,3,1010,505,0,
  	3608,3609,5,33,0,0,3609,3611,1,0,0,0,3610,3596,1,0,0,0,3610,3602,1,0,
  	0,0,3611,355,1,0,0,0,3612,3613,5,670,0,0,3613,3618,5,510,0,0,3614,3615,
  	4,178,63,0,3615,3616,5,670,0,0,3616,3618,5,142,0,0,3617,3612,1,0,0,0,
  	3617,3614,1,0,0,0,3618,357,1,0,0,0,3619,3620,5,423,0,0,3620,3621,5,90,
  	0,0,3621,3622,3,1006,503,0,3622,359,1,0,0,0,3623,3624,7,35,0,0,3624,361,
  	1,0,0,0,3625,3628,5,239,0,0,3626,3629,5,188,0,0,3627,3629,3,364,182,0,
  	3628,3626,1,0,0,0,3628,3627,1,0,0,0,3629,363,1,0,0,0,3630,3635,3,390,
  	195,0,3631,3632,5,29,0,0,3632,3634,3,390,195,0,3633,3631,1,0,0,0,3634,
  	3637,1,0,0,0,3635,3633,1,0,0,0,3635,3636,1,0,0,0,3636,365,1,0,0,0,3637,
  	3635,1,0,0,0,3638,3639,5,652,0,0,3639,3644,3,370,185,0,3640,3641,5,29,
  	0,0,3641,3643,3,370,185,0,3642,3640,1,0,0,0,3643,3646,1,0,0,0,3644,3642,
  	1,0,0,0,3644,3645,1,0,0,0,3645,367,1,0,0,0,3646,3644,1,0,0,0,3647,3648,
  	5,600,0,0,3648,3649,3,1366,683,0,3649,369,1,0,0,0,3650,3651,5,516,0,0,
  	3651,3653,5,32,0,0,3652,3654,3,260,130,0,3653,3652,1,0,0,0,3653,3654,
  	1,0,0,0,3654,3655,1,0,0,0,3655,3656,5,33,0,0,3656,371,1,0,0,0,3657,3666,
  	3,312,156,0,3658,3666,5,561,0,0,3659,3660,4,186,64,0,3660,3666,5,559,
  	0,0,3661,3662,4,186,65,0,3662,3663,5,357,0,0,3663,3664,5,6,0,0,3664,3666,
  	3,1404,702,0,3665,3657,1,0,0,0,3665,3658,1,0,0,0,3665,3659,1,0,0,0,3665,
  	3661,1,0,0,0,3666,373,1,0,0,0,3667,3669,4,187,66,0,3668,3670,3,376,188,
  	0,3669,3668,1,0,0,0,3670,3671,1,0,0,0,3671,3669,1,0,0,0,3671,3672,1,0,
  	0,0,3672,375,1,0,0,0,3673,3674,5,236,0,0,3674,3678,3,378,189,0,3675,3676,
  	4,188,67,0,3676,3677,5,693,0,0,3677,3679,3,1370,685,0,3678,3675,1,0,0,
  	0,3678,3679,1,0,0,0,3679,3682,1,0,0,0,3680,3681,4,188,68,0,3681,3683,
  	3,380,190,0,3682,3680,1,0,0,0,3682,3683,1,0,0,0,3683,3689,1,0,0,0,3684,
  	3685,5,319,0,0,3685,3686,5,286,0,0,3686,3687,5,535,0,0,3687,3689,5,377,
  	0,0,3688,3673,1,0,0,0,3688,3684,1,0,0,0,3689,377,1,0,0,0,3690,3694,5,
  	640,0,0,3691,3692,4,189,69,0,3692,3694,5,535,0,0,3693,3690,1,0,0,0,3693,
  	3691,1,0,0,0,3694,379,1,0,0,0,3695,3696,5,694,0,0,3696,3699,5,695,0,0,
  	3697,3699,5,696,0,0,3698,3695,1,0,0,0,3698,3697,1,0,0,0,3699,381,1,0,
  	0,0,3700,3703,3,384,192,0,3701,3703,5,16,0,0,3702,3700,1,0,0,0,3702,3701,
  	1,0,0,0,3703,3708,1,0,0,0,3704,3705,5,29,0,0,3705,3707,3,384,192,0,3706,
  	3704,1,0,0,0,3707,3710,1,0,0,0,3708,3706,1,0,0,0,3708,3709,1,0,0,0,3709,
  	383,1,0,0,0,3710,3708,1,0,0,0,3711,3717,3,1318,659,0,3712,3714,3,898,
  	449,0,3713,3715,3,386,193,0,3714,3713,1,0,0,0,3714,3715,1,0,0,0,3715,
  	3717,1,0,0,0,3716,3711,1,0,0,0,3716,3712,1,0,0,0,3717,385,1,0,0,0,3718,
  	3720,5,63,0,0,3719,3718,1,0,0,0,3719,3720,1,0,0,0,3720,3723,1,0,0,0,3721,
  	3724,3,1390,695,0,3722,3724,3,1422,711,0,3723,3721,1,0,0,0,3723,3722,
  	1,0,0,0,3724,387,1,0,0,0,3725,3726,5,668,0,0,3726,3727,3,898,449,0,3727,
  	389,1,0,0,0,3728,3739,3,402,201,0,3729,3733,5,34,0,0,3730,3731,4,195,
  	70,0,3731,3734,3,1390,695,0,3732,3734,5,757,0,0,3733,3730,1,0,0,0,3733,
  	3732,1,0,0,0,3734,3735,1,0,0,0,3735,3736,3,392,196,0,3736,3737,5,35,0,
  	0,3737,3739,1,0,0,0,3738,3728,1,0,0,0,3738,3729,1,0,0,0,3739,3743,1,0,
  	0,0,3740,3742,3,394,197,0,3741,3740,1,0,0,0,3742,3745,1,0,0,0,3743,3741,
  	1,0,0,0,3743,3744,1,0,0,0,3744,391,1,0,0,0,3745,3743,1,0,0,0,3746,3750,
  	3,402,201,0,3747,3749,3,394,197,0,3748,3747,1,0,0,0,3749,3752,1,0,0,0,
  	3750,3748,1,0,0,0,3750,3751,1,0,0,0,3751,393,1,0,0,0,3752,3750,1,0,0,
  	0,3753,3754,3,398,199,0,3754,3759,3,390,195,0,3755,3756,5,413,0,0,3756,
  	3760,3,898,449,0,3757,3758,5,647,0,0,3758,3760,3,1394,697,0,3759,3755,
  	1,0,0,0,3759,3757,1,0,0,0,3759,3760,1,0,0,0,3760,3773,1,0,0,0,3761,3762,
  	3,400,200,0,3762,3767,3,390,195,0,3763,3764,5,413,0,0,3764,3768,3,898,
  	449,0,3765,3766,5,647,0,0,3766,3768,3,1394,697,0,3767,3763,1,0,0,0,3767,
  	3765,1,0,0,0,3768,3773,1,0,0,0,3769,3770,3,396,198,0,3770,3771,3,402,
  	201,0,3771,3773,1,0,0,0,3772,3753,1,0,0,0,3772,3761,1,0,0,0,3772,3769,
  	1,0,0,0,3773,395,1,0,0,0,3774,3776,5,390,0,0,3775,3777,5,275,0,0,3776,
  	3775,1,0,0,0,3776,3777,1,0,0,0,3777,3778,1,0,0,0,3778,3786,5,295,0,0,
  	3779,3780,5,390,0,0,3780,3782,7,36,0,0,3781,3783,5,425,0,0,3782,3781,
  	1,0,0,0,3782,3783,1,0,0,0,3783,3784,1,0,0,0,3784,3786,5,295,0,0,3785,
  	3774,1,0,0,0,3785,3779,1,0,0,0,3786,397,1,0,0,0,3787,3789,7,37,0,0,3788,
  	3787,1,0,0,0,3788,3789,1,0,0,0,3789,3790,1,0,0,0,3790,3793,5,295,0,0,
  	3791,3793,5,581,0,0,3792,3788,1,0,0,0,3792,3791,1,0,0,0,3793,399,1,0,
  	0,0,3794,3796,7,36,0,0,3795,3797,5,425,0,0,3796,3795,1,0,0,0,3796,3797,
  	1,0,0,0,3797,3798,1,0,0,0,3798,3799,5,295,0,0,3799,401,1,0,0,0,3800,3807,
  	3,404,202,0,3801,3807,3,406,203,0,3802,3807,3,408,204,0,3803,3807,3,410,
  	205,0,3804,3805,4,201,71,0,3805,3807,3,412,206,0,3806,3800,1,0,0,0,3806,
  	3801,1,0,0,0,3806,3802,1,0,0,0,3806,3803,1,0,0,0,3806,3804,1,0,0,0,3807,
  	403,1,0,0,0,3808,3810,3,1366,683,0,3809,3811,3,1300,650,0,3810,3809,1,
  	0,0,0,3810,3811,1,0,0,0,3811,3813,1,0,0,0,3812,3814,3,430,215,0,3813,
  	3812,1,0,0,0,3813,3814,1,0,0,0,3814,3816,1,0,0,0,3815,3817,3,432,216,
  	0,3816,3815,1,0,0,0,3816,3817,1,0,0,0,3817,405,1,0,0,0,3818,3821,5,32,
  	0,0,3819,3822,3,404,202,0,3820,3822,3,406,203,0,3821,3819,1,0,0,0,3821,
  	3820,1,0,0,0,3822,3823,1,0,0,0,3823,3824,5,33,0,0,3824,407,1,0,0,0,3825,
  	3827,3,310,155,0,3826,3828,3,430,215,0,3827,3826,1,0,0,0,3827,3828,1,
  	0,0,0,3828,3831,1,0,0,0,3829,3830,4,204,72,0,3830,3832,3,1308,654,0,3831,
  	3829,1,0,0,0,3831,3832,1,0,0,0,3832,3843,1,0,0,0,3833,3834,4,204,73,0,
  	3834,3835,5,751,0,0,3835,3837,3,310,155,0,3836,3838,3,430,215,0,3837,
  	3836,1,0,0,0,3837,3838,1,0,0,0,3838,3840,1,0,0,0,3839,3841,3,1308,654,
  	0,3840,3839,1,0,0,0,3840,3841,1,0,0,0,3841,3843,1,0,0,0,3842,3825,1,0,
  	0,0,3842,3833,1,0,0,0,3843,409,1,0,0,0,3844,3847,5,32,0,0,3845,3848,3,
  	364,182,0,3846,3848,3,410,205,0,3847,3845,1,0,0,0,3847,3846,1,0,0,0,3848,
  	3849,1,0,0,0,3849,3850,5,33,0,0,3850,411,1,0,0,0,3851,3852,5,726,0,0,
  	3852,3853,5,32,0,0,3853,3854,3,898,449,0,3854,3855,5,29,0,0,3855,3856,
  	3,1422,711,0,3856,3857,3,414,207,0,3857,3859,5,33,0,0,3858,3860,3,430,
  	215,0,3859,3858,1,0,0,0,3859,3860,1,0,0,0,3860,413,1,0,0,0,3861,3862,
  	5,115,0,0,3862,3863,5,32,0,0,3863,3868,3,416,208,0,3864,3865,5,29,0,0,
  	3865,3867,3,416,208,0,3866,3864,1,0,0,0,3867,3870,1,0,0,0,3868,3866,1,
  	0,0,0,3868,3869,1,0,0,0,3869,3871,1,0,0,0,3870,3868,1,0,0,0,3871,3872,
  	5,33,0,0,3872,415,1,0,0,0,3873,3874,3,1390,695,0,3874,3875,5,236,0,0,
  	3875,3876,5,728,0,0,3876,3897,1,0,0,0,3877,3878,3,1390,695,0,3878,3881,
  	3,1150,575,0,3879,3880,4,208,74,0,3880,3882,3,1232,616,0,3881,3879,1,
  	0,0,0,3881,3882,1,0,0,0,3882,3884,1,0,0,0,3883,3885,5,213,0,0,3884,3883,
  	1,0,0,0,3884,3885,1,0,0,0,3885,3886,1,0,0,0,3886,3887,5,729,0,0,3887,
  	3889,3,1422,711,0,3888,3890,3,420,210,0,3889,3888,1,0,0,0,3889,3890,1,
  	0,0,0,3890,3897,1,0,0,0,3891,3892,5,727,0,0,3892,3893,5,729,0,0,3893,
  	3894,3,1422,711,0,3894,3895,3,414,207,0,3895,3897,1,0,0,0,3896,3873,1,
  	0,0,0,3896,3877,1,0,0,0,3896,3891,1,0,0,0,3897,417,1,0,0,0,3898,3900,
  	3,422,211,0,3899,3901,3,424,212,0,3900,3899,1,0,0,0,3900,3901,1,0,0,0,
  	3901,3904,1,0,0,0,3902,3904,3,424,212,0,3903,3898,1,0,0,0,3903,3902,1,
  	0,0,0,3904,419,1,0,0,0,3905,3910,3,418,209,0,3906,3907,3,424,212,0,3907,
  	3908,3,422,211,0,3908,3910,1,0,0,0,3909,3905,1,0,0,0,3909,3906,1,0,0,
  	0,3910,421,1,0,0,0,3911,3912,3,426,213,0,3912,3913,5,413,0,0,3913,3914,
  	5,725,0,0,3914,423,1,0,0,0,3915,3916,3,426,213,0,3916,3917,5,413,0,0,
  	3917,3918,5,204,0,0,3918,425,1,0,0,0,3919,3924,5,204,0,0,3920,3924,5,
  	406,0,0,3921,3922,5,168,0,0,3922,3924,3,1422,711,0,3923,3919,1,0,0,0,
  	3923,3920,1,0,0,0,3923,3921,1,0,0,0,3924,427,1,0,0,0,3925,3926,7,38,0,
  	0,3926,429,1,0,0,0,3927,3931,5,63,0,0,3928,3929,4,215,75,0,3929,3931,
  	5,6,0,0,3930,3927,1,0,0,0,3930,3928,1,0,0,0,3930,3931,1,0,0,0,3931,3932,
  	1,0,0,0,3932,3933,3,1390,695,0,3933,431,1,0,0,0,3934,3939,3,434,217,0,
  	3935,3936,5,29,0,0,3936,3938,3,434,217,0,3937,3935,1,0,0,0,3938,3941,
  	1,0,0,0,3939,3937,1,0,0,0,3939,3940,1,0,0,0,3940,433,1,0,0,0,3941,3939,
  	1,0,0,0,3942,3943,3,436,218,0,3943,3945,3,438,219,0,3944,3946,3,442,221,
  	0,3945,3944,1,0,0,0,3945,3946,1,0,0,0,3946,3947,1,0,0,0,3947,3948,5,32,
  	0,0,3948,3949,3,444,222,0,3949,3950,5,33,0,0,3950,3963,1,0,0,0,3951,3952,
  	5,646,0,0,3952,3954,3,438,219,0,3953,3955,3,442,221,0,3954,3953,1,0,0,
  	0,3954,3955,1,0,0,0,3955,3956,1,0,0,0,3956,3958,5,32,0,0,3957,3959,3,
  	444,222,0,3958,3957,1,0,0,0,3958,3959,1,0,0,0,3959,3960,1,0,0,0,3960,
  	3961,5,33,0,0,3961,3963,1,0,0,0,3962,3942,1,0,0,0,3962,3951,1,0,0,0,3963,
  	435,1,0,0,0,3964,3965,7,39,0,0,3965,437,1,0,0,0,3966,3967,7,40,0,0,3967,
  	439,1,0,0,0,3968,3969,5,450,0,0,3969,3975,5,299,0,0,3970,3972,5,635,0,
  	0,3971,3973,3,438,219,0,3972,3971,1,0,0,0,3972,3973,1,0,0,0,3973,3975,
  	1,0,0,0,3974,3968,1,0,0,0,3974,3970,1,0,0,0,3975,441,1,0,0,0,3976,3982,
  	5,236,0,0,3977,3983,5,295,0,0,3978,3979,5,423,0,0,3979,3983,5,90,0,0,
  	3980,3981,5,253,0,0,3981,3983,5,90,0,0,3982,3977,1,0,0,0,3982,3978,1,
  	0,0,0,3982,3980,1,0,0,0,3983,443,1,0,0,0,3984,3989,3,446,223,0,3985,3986,
  	5,29,0,0,3986,3988,3,446,223,0,3987,3985,1,0,0,0,3988,3991,1,0,0,0,3989,
  	3987,1,0,0,0,3989,3990,1,0,0,0,3990,445,1,0,0,0,3991,3989,1,0,0,0,3992,
  	3995,3,1390,695,0,3993,3995,5,450,0,0,3994,3992,1,0,0,0,3994,3993,1,0,
  	0,0,3995,447,1,0,0,0,3996,3997,4,224,76,0,3997,3999,3,350,175,0,3998,
  	3996,1,0,0,0,3998,3999,1,0,0,0,3999,4000,1,0,0,0,4000,4002,5,640,0,0,
  	4001,4003,5,327,0,0,4002,4001,1,0,0,0,4002,4003,1,0,0,0,4003,4005,1,0,
  	0,0,4004,4006,5,268,0,0,4005,4004,1,0,0,0,4005,4006,1,0,0,0,4006,4007,
  	1,0,0,0,4007,4008,3,364,182,0,4008,4009,5,533,0,0,4009,4011,3,1240,620,
  	0,4010,4012,3,388,194,0,4011,4010,1,0,0,0,4011,4012,1,0,0,0,4012,4014,
  	1,0,0,0,4013,4015,3,358,179,0,4014,4013,1,0,0,0,4014,4015,1,0,0,0,4015,
  	4017,1,0,0,0,4016,4018,3,316,158,0,4017,4016,1,0,0,0,4017,4018,1,0,0,
  	0,4018,449,1,0,0,0,4019,4024,3,452,226,0,4020,4024,3,458,229,0,4021,4024,
  	3,460,230,0,4022,4024,3,466,233,0,4023,4019,1,0,0,0,4023,4020,1,0,0,0,
  	4023,4021,1,0,0,0,4023,4022,1,0,0,0,4024,451,1,0,0,0,4025,4026,5,569,
  	0,0,4026,4030,5,618,0,0,4027,4029,3,456,228,0,4028,4027,1,0,0,0,4029,
  	4032,1,0,0,0,4030,4028,1,0,0,0,4030,4031,1,0,0,0,4031,4051,1,0,0,0,4032,
  	4030,1,0,0,0,4033,4035,5,121,0,0,4034,4036,5,672,0,0,4035,4034,1,0,0,
  	0,4035,4036,1,0,0,0,4036,4042,1,0,0,0,4037,4039,5,61,0,0,4038,4040,5,
  	403,0,0,4039,4038,1,0,0,0,4039,4040,1,0,0,0,4040,4041,1,0,0,0,4041,4043,
  	5,99,0,0,4042,4037,1,0,0,0,4042,4043,1,0,0,0,4043,4048,1,0,0,0,4044,4046,
  	5,403,0,0,4045,4044,1,0,0,0,4045,4046,1,0,0,0,4046,4047,1,0,0,0,4047,
  	4049,5,480,0,0,4048,4045,1,0,0,0,4048,4049,1,0,0,0,4049,4051,1,0,0,0,
  	4050,4025,1,0,0,0,4050,4033,1,0,0,0,4051,453,1,0,0,0,4052,4054,5,74,0,
  	0,4053,4055,5,672,0,0,4054,4053,1,0,0,0,4054,4055,1,0,0,0,4055,455,1,
  	0,0,0,4056,4057,5,670,0,0,4057,4058,5,129,0,0,4058,4062,5,544,0,0,4059,
  	4060,5,465,0,0,4060,4062,7,41,0,0,4061,4056,1,0,0,0,4061,4059,1,0,0,0,
  	4062,457,1,0,0,0,4063,4064,5,518,0,0,4064,4093,3,1390,695,0,4065,4067,
  	5,509,0,0,4066,4068,5,672,0,0,4067,4066,1,0,0,0,4067,4068,1,0,0,0,4068,
  	4087,1,0,0,0,4069,4071,5,616,0,0,4070,4072,5,518,0,0,4071,4070,1,0,0,
  	0,4071,4072,1,0,0,0,4072,4073,1,0,0,0,4073,4088,3,1390,695,0,4074,4076,
  	5,61,0,0,4075,4077,5,403,0,0,4076,4075,1,0,0,0,4076,4077,1,0,0,0,4077,
  	4078,1,0,0,0,4078,4080,5,99,0,0,4079,4074,1,0,0,0,4079,4080,1,0,0,0,4080,
  	4085,1,0,0,0,4081,4083,5,403,0,0,4082,4081,1,0,0,0,4082,4083,1,0,0,0,
  	4083,4084,1,0,0,0,4084,4086,5,480,0,0,4085,4082,1,0,0,0,4085,4086,1,0,
  	0,0,4086,4088,1,0,0,0,4087,4069,1,0,0,0,4087,4079,1,0,0,0,4088,4093,1,
  	0,0,0,4089,4090,5,480,0,0,4090,4091,5,518,0,0,4091,4093,3,1390,695,0,
  	4092,4063,1,0,0,0,4092,4065,1,0,0,0,4092,4089,1,0,0,0,4093,459,1,0,0,
  	0,4094,4095,5,319,0,0,4095,4096,7,17,0,0,4096,4101,3,462,231,0,4097,4098,
  	5,29,0,0,4098,4100,3,462,231,0,4099,4097,1,0,0,0,4100,4103,1,0,0,0,4101,
  	4099,1,0,0,0,4101,4102,1,0,0,0,4102,4117,1,0,0,0,4103,4101,1,0,0,0,4104,
  	4105,4,230,77,0,4105,4106,5,319,0,0,4106,4107,5,280,0,0,4107,4108,5,236,
  	0,0,4108,4117,5,72,0,0,4109,4114,5,637,0,0,4110,4115,5,597,0,0,4111,4115,
  	5,600,0,0,4112,4113,4,230,78,0,4113,4115,5,280,0,0,4114,4110,1,0,0,0,
  	4114,4111,1,0,0,0,4114,4112,1,0,0,0,4115,4117,1,0,0,0,4116,4094,1,0,0,
  	0,4116,4104,1,0,0,0,4116,4109,1,0,0,0,4117,461,1,0,0,0,4118,4120,3,1366,
  	683,0,4119,4121,3,430,215,0,4120,4119,1,0,0,0,4120,4121,1,0,0,0,4121,
  	4122,1,0,0,0,4122,4123,3,464,232,0,4123,463,1,0,0,0,4124,4126,5,465,0,
  	0,4125,4127,5,316,0,0,4126,4125,1,0,0,0,4126,4127,1,0,0,0,4127,4133,1,
  	0,0,0,4128,4130,5,327,0,0,4129,4128,1,0,0,0,4129,4130,1,0,0,0,4130,4131,
  	1,0,0,0,4131,4133,5,674,0,0,4132,4124,1,0,0,0,4132,4129,1,0,0,0,4133,
  	465,1,0,0,0,4134,4161,5,676,0,0,4135,4136,7,42,0,0,4136,4138,3,470,235,
  	0,4137,4139,7,43,0,0,4138,4137,1,0,0,0,4138,4139,1,0,0,0,4139,4162,1,
  	0,0,0,4140,4141,5,198,0,0,4141,4147,3,470,235,0,4142,4145,5,592,0,0,4143,
  	4144,5,236,0,0,4144,4146,5,371,0,0,4145,4143,1,0,0,0,4145,4146,1,0,0,
  	0,4146,4148,1,0,0,0,4147,4142,1,0,0,0,4147,4148,1,0,0,0,4148,4162,1,0,
  	0,0,4149,4150,5,447,0,0,4150,4162,3,470,235,0,4151,4152,5,121,0,0,4152,
  	4155,3,470,235,0,4153,4154,5,414,0,0,4154,4156,5,437,0,0,4155,4153,1,
  	0,0,0,4155,4156,1,0,0,0,4156,4162,1,0,0,0,4157,4158,5,509,0,0,4158,4162,
  	3,470,235,0,4159,4160,5,469,0,0,4160,4162,3,468,234,0,4161,4135,1,0,0,
  	0,4161,4140,1,0,0,0,4161,4149,1,0,0,0,4161,4151,1,0,0,0,4161,4157,1,0,
  	0,0,4161,4159,1,0,0,0,4162,467,1,0,0,0,4163,4166,4,234,79,0,4164,4165,
  	5,137,0,0,4165,4167,5,677,0,0,4166,4164,1,0,0,0,4166,4167,1,0,0,0,4167,
  	4170,1,0,0,0,4168,4170,1,0,0,0,4169,4163,1,0,0,0,4169,4168,1,0,0,0,4170,
  	469,1,0,0,0,4171,4178,3,1424,712,0,4172,4173,5,29,0,0,4173,4176,3,1424,
  	712,0,4174,4175,5,29,0,0,4175,4177,3,1402,701,0,4176,4174,1,0,0,0,4176,
  	4177,1,0,0,0,4177,4179,1,0,0,0,4178,4172,1,0,0,0,4178,4179,1,0,0,0,4179,
  	471,1,0,0,0,4180,4181,5,458,0,0,4181,4205,3,474,237,0,4182,4205,3,486,
  	243,0,4183,4184,5,498,0,0,4184,4189,3,476,238,0,4185,4186,5,29,0,0,4186,
  	4188,3,476,238,0,4187,4185,1,0,0,0,4188,4191,1,0,0,0,4189,4187,1,0,0,
  	0,4189,4190,1,0,0,0,4190,4205,1,0,0,0,4191,4189,1,0,0,0,4192,4193,4,236,
  	80,0,4193,4194,5,498,0,0,4194,4196,5,683,0,0,4195,4197,3,1220,610,0,4196,
  	4195,1,0,0,0,4196,4197,1,0,0,0,4197,4205,1,0,0,0,4198,4205,3,572,286,
  	0,4199,4205,3,574,287,0,4200,4205,3,558,279,0,4201,4205,3,482,241,0,4202,
  	4203,4,236,81,0,4203,4205,3,590,295,0,4204,4180,1,0,0,0,4204,4182,1,0,
  	0,0,4204,4183,1,0,0,0,4204,4192,1,0,0,0,4204,4198,1,0,0,0,4204,4199,1,
  	0,0,0,4204,4200,1,0,0,0,4204,4201,1,0,0,0,4204,4202,1,0,0,0,4205,473,
  	1,0,0,0,4206,4207,7,44,0,0,4207,4212,5,321,0,0,4208,4209,5,616,0,0,4209,
  	4213,3,1428,714,0,4210,4211,5,73,0,0,4211,4213,3,898,449,0,4212,4208,
  	1,0,0,0,4212,4210,1,0,0,0,4213,475,1,0,0,0,4214,4216,3,478,239,0,4215,
  	4217,3,480,240,0,4216,4215,1,0,0,0,4216,4217,1,0,0,0,4217,4229,1,0,0,
  	0,4218,4219,4,238,82,0,4219,4220,5,460,0,0,4220,4229,5,92,0,0,4221,4223,
  	3,602,301,0,4222,4224,5,56,0,0,4223,4222,1,0,0,0,4223,4224,1,0,0,0,4224,
  	4226,1,0,0,0,4225,4227,3,1014,507,0,4226,4225,1,0,0,0,4226,4227,1,0,0,
  	0,4227,4229,1,0,0,0,4228,4214,1,0,0,0,4228,4218,1,0,0,0,4228,4221,1,0,
  	0,0,4229,477,1,0,0,0,4230,4237,5,348,0,0,4231,4232,4,239,83,0,4232,4233,
  	5,77,0,0,4233,4234,5,321,0,0,4234,4235,5,61,0,0,4235,4237,5,826,0,0,4236,
  	4230,1,0,0,0,4236,4231,1,0,0,0,4237,479,1,0,0,0,4238,4239,4,240,84,0,
  	4239,4240,5,616,0,0,4240,4241,3,1408,704,0,4241,481,1,0,0,0,4242,4246,
  	5,315,0,0,4243,4247,5,154,0,0,4244,4245,5,600,0,0,4245,4247,3,1366,683,
  	0,4246,4243,1,0,0,0,4246,4244,1,0,0,0,4247,4248,1,0,0,0,4248,4249,5,239,
  	0,0,4249,4250,5,348,0,0,4250,483,1,0,0,0,4251,4256,5,348,0,0,4252,4253,
  	4,242,85,0,4253,4254,5,489,0,0,4254,4256,5,548,0,0,4255,4251,1,0,0,0,
  	4255,4252,1,0,0,0,4256,485,1,0,0,0,4257,4258,5,100,0,0,4258,4259,3,484,
  	242,0,4259,4260,5,616,0,0,4260,4262,3,488,244,0,4261,4263,3,1014,507,
  	0,4262,4261,1,0,0,0,4262,4263,1,0,0,0,4263,487,1,0,0,0,4264,4269,3,490,
  	245,0,4265,4266,5,29,0,0,4266,4268,3,490,245,0,4267,4265,1,0,0,0,4268,
  	4271,1,0,0,0,4269,4267,1,0,0,0,4269,4270,1,0,0,0,4270,489,1,0,0,0,4271,
  	4269,1,0,0,0,4272,4273,3,494,247,0,4273,4274,5,6,0,0,4274,4275,3,1430,
  	715,0,4275,4401,1,0,0,0,4276,4277,5,754,0,0,4277,4278,5,6,0,0,4278,4401,
  	3,1430,715,0,4279,4280,3,496,248,0,4280,4281,5,6,0,0,4281,4282,3,1430,
  	715,0,4282,4401,1,0,0,0,4283,4284,3,498,249,0,4284,4285,5,6,0,0,4285,
  	4286,3,1430,715,0,4286,4401,1,0,0,0,4287,4288,3,500,250,0,4288,4289,5,
  	6,0,0,4289,4290,3,1430,715,0,4290,4401,1,0,0,0,4291,4292,3,502,251,0,
  	4292,4293,5,6,0,0,4293,4294,3,1402,701,0,4294,4401,1,0,0,0,4295,4296,
  	3,504,252,0,4296,4297,5,6,0,0,4297,4298,3,1402,701,0,4298,4401,1,0,0,
  	0,4299,4300,3,506,253,0,4300,4301,5,6,0,0,4301,4302,3,1402,701,0,4302,
  	4401,1,0,0,0,4303,4304,3,508,254,0,4304,4305,5,6,0,0,4305,4306,3,1402,
  	701,0,4306,4401,1,0,0,0,4307,4308,3,510,255,0,4308,4309,5,6,0,0,4309,
  	4310,3,1402,701,0,4310,4401,1,0,0,0,4311,4312,3,512,256,0,4312,4313,5,
  	6,0,0,4313,4314,3,1430,715,0,4314,4401,1,0,0,0,4315,4316,3,514,257,0,
  	4316,4317,5,6,0,0,4317,4318,3,1430,715,0,4318,4401,1,0,0,0,4319,4320,
  	3,526,263,0,4320,4321,5,6,0,0,4321,4322,3,1430,715,0,4322,4401,1,0,0,
  	0,4323,4324,3,530,265,0,4324,4325,5,6,0,0,4325,4326,3,1430,715,0,4326,
  	4401,1,0,0,0,4327,4328,3,528,264,0,4328,4329,5,6,0,0,4329,4330,3,548,
  	274,0,4330,4401,1,0,0,0,4331,4332,3,516,258,0,4332,4333,5,6,0,0,4333,
  	4334,3,1430,715,0,4334,4401,1,0,0,0,4335,4336,3,522,261,0,4336,4337,5,
  	6,0,0,4337,4338,3,1430,715,0,4338,4401,1,0,0,0,4339,4340,3,524,262,0,
  	4340,4341,5,6,0,0,4341,4342,3,1402,701,0,4342,4401,1,0,0,0,4343,4344,
  	3,518,259,0,4344,4345,5,6,0,0,4345,4346,3,1428,714,0,4346,4401,1,0,0,
  	0,4347,4348,3,520,260,0,4348,4349,5,6,0,0,4349,4350,3,1430,715,0,4350,
  	4401,1,0,0,0,4351,4352,3,532,266,0,4352,4353,5,6,0,0,4353,4354,3,1430,
  	715,0,4354,4401,1,0,0,0,4355,4356,3,534,267,0,4356,4357,5,6,0,0,4357,
  	4358,3,1402,701,0,4358,4401,1,0,0,0,4359,4360,3,536,268,0,4360,4361,5,
  	6,0,0,4361,4362,3,1402,701,0,4362,4401,1,0,0,0,4363,4364,5,269,0,0,4364,
  	4365,5,6,0,0,4365,4401,3,556,278,0,4366,4367,3,538,269,0,4367,4368,5,
  	6,0,0,4368,4369,3,1422,711,0,4369,4401,1,0,0,0,4370,4371,3,540,270,0,
  	4371,4372,5,6,0,0,4372,4373,3,1402,701,0,4373,4401,1,0,0,0,4374,4375,
  	3,492,246,0,4375,4376,5,6,0,0,4376,4377,3,1402,701,0,4377,4401,1,0,0,
  	0,4378,4379,5,762,0,0,4379,4380,5,6,0,0,4380,4401,3,542,271,0,4381,4382,
  	5,764,0,0,4382,4383,5,6,0,0,4383,4401,3,1402,701,0,4384,4385,5,767,0,
  	0,4385,4386,5,6,0,0,4386,4401,3,544,272,0,4387,4388,4,245,86,0,4388,4389,
  	5,776,0,0,4389,4390,5,6,0,0,4390,4401,3,1404,702,0,4391,4392,4,245,87,
  	0,4392,4393,5,781,0,0,4393,4394,5,6,0,0,4394,4401,3,546,273,0,4395,4396,
  	4,245,88,0,4396,4397,5,819,0,0,4397,4398,5,6,0,0,4398,4401,3,1404,702,
  	0,4399,4401,3,550,275,0,4400,4272,1,0,0,0,4400,4276,1,0,0,0,4400,4279,
  	1,0,0,0,4400,4283,1,0,0,0,4400,4287,1,0,0,0,4400,4291,1,0,0,0,4400,4295,
  	1,0,0,0,4400,4299,1,0,0,0,4400,4303,1,0,0,0,4400,4307,1,0,0,0,4400,4311,
  	1,0,0,0,4400,4315,1,0,0,0,4400,4319,1,0,0,0,4400,4323,1,0,0,0,4400,4327,
  	1,0,0,0,4400,4331,1,0,0,0,4400,4335,1,0,0,0,4400,4339,1,0,0,0,4400,4343,
  	1,0,0,0,4400,4347,1,0,0,0,4400,4351,1,0,0,0,4400,4355,1,0,0,0,4400,4359,
  	1,0,0,0,4400,4363,1,0,0,0,4400,4366,1,0,0,0,4400,4370,1,0,0,0,4400,4374,
  	1,0,0,0,4400,4378,1,0,0,0,4400,4381,1,0,0,0,4400,4384,1,0,0,0,4400,4387,
  	1,0,0,0,4400,4391,1,0,0,0,4400,4395,1,0,0,0,4400,4399,1,0,0,0,4401,491,
  	1,0,0,0,4402,4403,7,45,0,0,4403,493,1,0,0,0,4404,4405,7,46,0,0,4405,495,
  	1,0,0,0,4406,4407,7,47,0,0,4407,497,1,0,0,0,4408,4409,7,48,0,0,4409,499,
  	1,0,0,0,4410,4411,7,49,0,0,4411,501,1,0,0,0,4412,4413,7,50,0,0,4413,503,
  	1,0,0,0,4414,4415,7,51,0,0,4415,505,1,0,0,0,4416,4417,7,52,0,0,4417,507,
  	1,0,0,0,4418,4419,7,53,0,0,4419,509,1,0,0,0,4420,4421,7,54,0,0,4421,511,
  	1,0,0,0,4422,4423,7,55,0,0,4423,513,1,0,0,0,4424,4425,7,56,0,0,4425,515,
  	1,0,0,0,4426,4427,7,57,0,0,4427,517,1,0,0,0,4428,4429,7,58,0,0,4429,519,
  	1,0,0,0,4430,4431,7,59,0,0,4431,521,1,0,0,0,4432,4433,7,60,0,0,4433,523,
  	1,0,0,0,4434,4435,7,61,0,0,4435,525,1,0,0,0,4436,4437,7,62,0,0,4437,527,
  	1,0,0,0,4438,4439,7,63,0,0,4439,529,1,0,0,0,4440,4441,7,64,0,0,4441,531,
  	1,0,0,0,4442,4443,7,65,0,0,4443,533,1,0,0,0,4444,4445,7,66,0,0,4445,535,
  	1,0,0,0,4446,4447,7,67,0,0,4447,537,1,0,0,0,4448,4449,7,68,0,0,4449,539,
  	1,0,0,0,4450,4451,7,69,0,0,4451,541,1,0,0,0,4452,4455,3,1288,644,0,4453,
  	4455,5,406,0,0,4454,4452,1,0,0,0,4454,4453,1,0,0,0,4455,543,1,0,0,0,4456,
  	4457,7,70,0,0,4457,545,1,0,0,0,4458,4462,5,769,0,0,4459,4462,5,316,0,
  	0,4460,4462,3,1422,711,0,4461,4458,1,0,0,0,4461,4459,1,0,0,0,4461,4460,
  	1,0,0,0,4462,547,1,0,0,0,4463,4466,3,1430,715,0,4464,4466,5,406,0,0,4465,
  	4463,1,0,0,0,4465,4464,1,0,0,0,4466,549,1,0,0,0,4467,4468,3,552,276,0,
  	4468,4469,5,6,0,0,4469,4470,3,1430,715,0,4470,4482,1,0,0,0,4471,4472,
  	3,554,277,0,4472,4473,5,6,0,0,4473,4474,3,1406,703,0,4474,4482,1,0,0,
  	0,4475,4476,5,477,0,0,4476,4477,5,6,0,0,4477,4482,3,1430,715,0,4478,4479,
  	5,478,0,0,4479,4480,5,6,0,0,4480,4482,3,1402,701,0,4481,4467,1,0,0,0,
  	4481,4471,1,0,0,0,4481,4475,1,0,0,0,4481,4478,1,0,0,0,4482,551,1,0,0,
  	0,4483,4484,7,71,0,0,4484,553,1,0,0,0,4485,4486,7,72,0,0,4486,555,1,0,
  	0,0,4487,4496,5,32,0,0,4488,4493,3,1402,701,0,4489,4490,5,29,0,0,4490,
  	4492,3,1402,701,0,4491,4489,1,0,0,0,4492,4495,1,0,0,0,4493,4491,1,0,0,
  	0,4493,4494,1,0,0,0,4494,4497,1,0,0,0,4495,4493,1,0,0,0,4496,4488,1,0,
  	0,0,4496,4497,1,0,0,0,4497,4498,1,0,0,0,4498,4499,5,33,0,0,4499,557,1,
  	0,0,0,4500,4501,5,100,0,0,4501,4502,5,489,0,0,4502,4503,5,228,0,0,4503,
  	4508,3,560,280,0,4504,4505,5,29,0,0,4505,4507,3,560,280,0,4506,4504,1,
  	0,0,0,4507,4510,1,0,0,0,4508,4506,1,0,0,0,4508,4509,1,0,0,0,4509,4513,
  	1,0,0,0,4510,4508,1,0,0,0,4511,4512,4,279,89,0,4512,4514,3,1014,507,0,
  	4513,4511,1,0,0,0,4513,4514,1,0,0,0,4514,559,1,0,0,0,4515,4516,5,490,
  	0,0,4516,4517,5,6,0,0,4517,4519,5,32,0,0,4518,4520,3,562,281,0,4519,4518,
  	1,0,0,0,4519,4520,1,0,0,0,4520,4521,1,0,0,0,4521,4565,5,33,0,0,4522,4523,
  	5,491,0,0,4523,4524,5,6,0,0,4524,4526,5,32,0,0,4525,4527,3,562,281,0,
  	4526,4525,1,0,0,0,4526,4527,1,0,0,0,4527,4528,1,0,0,0,4528,4565,5,33,
  	0,0,4529,4530,5,492,0,0,4530,4531,5,6,0,0,4531,4533,5,32,0,0,4532,4534,
  	3,564,282,0,4533,4532,1,0,0,0,4533,4534,1,0,0,0,4534,4535,1,0,0,0,4535,
  	4565,5,33,0,0,4536,4537,5,493,0,0,4537,4538,5,6,0,0,4538,4540,5,32,0,
  	0,4539,4541,3,564,282,0,4540,4539,1,0,0,0,4540,4541,1,0,0,0,4541,4542,
  	1,0,0,0,4542,4565,5,33,0,0,4543,4544,5,494,0,0,4544,4545,5,6,0,0,4545,
  	4547,5,32,0,0,4546,4548,3,566,283,0,4547,4546,1,0,0,0,4547,4548,1,0,0,
  	0,4548,4549,1,0,0,0,4549,4565,5,33,0,0,4550,4551,5,495,0,0,4551,4552,
  	5,6,0,0,4552,4554,5,32,0,0,4553,4555,3,566,283,0,4554,4553,1,0,0,0,4554,
  	4555,1,0,0,0,4555,4556,1,0,0,0,4556,4565,5,33,0,0,4557,4558,5,496,0,0,
  	4558,4559,5,6,0,0,4559,4561,5,32,0,0,4560,4562,3,570,285,0,4561,4560,
  	1,0,0,0,4561,4562,1,0,0,0,4562,4563,1,0,0,0,4563,4565,5,33,0,0,4564,4515,
  	1,0,0,0,4564,4522,1,0,0,0,4564,4529,1,0,0,0,4564,4536,1,0,0,0,4564,4543,
  	1,0,0,0,4564,4550,1,0,0,0,4564,4557,1,0,0,0,4565,561,1,0,0,0,4566,4571,
  	3,1322,661,0,4567,4568,5,29,0,0,4568,4570,3,1322,661,0,4569,4567,1,0,
  	0,0,4570,4573,1,0,0,0,4571,4569,1,0,0,0,4571,4572,1,0,0,0,4572,563,1,
  	0,0,0,4573,4571,1,0,0,0,4574,4579,3,1362,681,0,4575,4576,5,29,0,0,4576,
  	4578,3,1362,681,0,4577,4575,1,0,0,0,4578,4581,1,0,0,0,4579,4577,1,0,0,
  	0,4579,4580,1,0,0,0,4580,565,1,0,0,0,4581,4579,1,0,0,0,4582,4587,3,568,
  	284,0,4583,4584,5,29,0,0,4584,4586,3,568,284,0,4585,4583,1,0,0,0,4586,
  	4589,1,0,0,0,4587,4585,1,0,0,0,4587,4588,1,0,0,0,4588,567,1,0,0,0,4589,
  	4587,1,0,0,0,4590,4591,3,1430,715,0,4591,569,1,0,0,0,4592,4597,3,1236,
  	618,0,4593,4594,5,29,0,0,4594,4596,3,1236,618,0,4595,4593,1,0,0,0,4596,
  	4599,1,0,0,0,4597,4595,1,0,0,0,4597,4598,1,0,0,0,4598,571,1,0,0,0,4599,
  	4597,1,0,0,0,4600,4601,5,569,0,0,4601,4603,3,602,301,0,4602,4604,3,586,
  	293,0,4603,4602,1,0,0,0,4603,4604,1,0,0,0,4604,4607,1,0,0,0,4605,4606,
  	5,639,0,0,4606,4608,3,576,288,0,4607,4605,1,0,0,0,4607,4608,1,0,0,0,4608,
  	4610,1,0,0,0,4609,4611,3,578,289,0,4610,4609,1,0,0,0,4610,4611,1,0,0,
  	0,4611,4613,1,0,0,0,4612,4614,3,580,290,0,4613,4612,1,0,0,0,4613,4614,
  	1,0,0,0,4614,4616,1,0,0,0,4615,4617,3,582,291,0,4616,4615,1,0,0,0,4616,
  	4617,1,0,0,0,4617,4619,1,0,0,0,4618,4620,3,584,292,0,4619,4618,1,0,0,
  	0,4619,4620,1,0,0,0,4620,4622,1,0,0,0,4621,4623,3,1014,507,0,4622,4621,
  	1,0,0,0,4622,4623,1,0,0,0,4623,573,1,0,0,0,4624,4625,5,578,0,0,4625,4627,
  	3,602,301,0,4626,4628,3,586,293,0,4627,4626,1,0,0,0,4627,4628,1,0,0,0,
  	4628,4630,1,0,0,0,4629,4631,3,1014,507,0,4630,4629,1,0,0,0,4630,4631,
  	1,0,0,0,4631,575,1,0,0,0,4632,4638,3,550,275,0,4633,4634,7,73,0,0,4634,
  	4635,5,6,0,0,4635,4638,3,1424,712,0,4636,4638,5,555,0,0,4637,4632,1,0,
  	0,0,4637,4633,1,0,0,0,4637,4636,1,0,0,0,4638,4643,1,0,0,0,4639,4640,5,
  	29,0,0,4640,4642,3,550,275,0,4641,4639,1,0,0,0,4642,4645,1,0,0,0,4643,
  	4641,1,0,0,0,4643,4644,1,0,0,0,4644,577,1,0,0,0,4645,4643,1,0,0,0,4646,
  	4647,5,644,0,0,4647,4648,5,6,0,0,4648,4649,3,1424,712,0,4649,579,1,0,
  	0,0,4650,4651,5,436,0,0,4651,4652,5,6,0,0,4652,4653,3,1424,712,0,4653,
  	581,1,0,0,0,4654,4655,5,169,0,0,4655,4656,5,6,0,0,4656,4657,3,1424,712,
  	0,4657,583,1,0,0,0,4658,4659,5,439,0,0,4659,4660,5,6,0,0,4660,4661,3,
  	1424,712,0,4661,585,1,0,0,0,4662,4667,3,588,294,0,4663,4664,5,29,0,0,
  	4664,4666,3,588,294,0,4665,4663,1,0,0,0,4666,4669,1,0,0,0,4667,4665,1,
  	0,0,0,4667,4668,1,0,0,0,4668,587,1,0,0,0,4669,4667,1,0,0,0,4670,4671,
  	7,74,0,0,4671,589,1,0,0,0,4672,4673,5,569,0,0,4673,4676,5,246,0,0,4674,
  	4675,4,295,90,0,4675,4677,3,592,296,0,4676,4674,1,0,0,0,4676,4677,1,0,
  	0,0,4677,4681,1,0,0,0,4678,4679,5,578,0,0,4679,4681,5,246,0,0,4680,4672,
  	1,0,0,0,4680,4678,1,0,0,0,4681,591,1,0,0,0,4682,4687,3,594,297,0,4683,
  	4684,5,29,0,0,4684,4686,3,594,297,0,4685,4683,1,0,0,0,4686,4689,1,0,0,
  	0,4687,4685,1,0,0,0,4687,4688,1,0,0,0,4688,593,1,0,0,0,4689,4687,1,0,
  	0,0,4690,4694,3,596,298,0,4691,4694,3,598,299,0,4692,4694,3,600,300,0,
  	4693,4690,1,0,0,0,4693,4691,1,0,0,0,4693,4692,1,0,0,0,4694,595,1,0,0,
  	0,4695,4696,5,644,0,0,4696,4697,5,6,0,0,4697,4698,3,1430,715,0,4698,597,
  	1,0,0,0,4699,4700,5,436,0,0,4700,4701,5,6,0,0,4701,4702,3,1430,715,0,
  	4702,599,1,0,0,0,4703,4704,5,169,0,0,4704,4705,5,6,0,0,4705,4706,3,1430,
  	715,0,4706,601,1,0,0,0,4707,4708,7,75,0,0,4708,603,1,0,0,0,4709,4710,
  	5,447,0,0,4710,4711,3,1390,695,0,4711,4714,5,239,0,0,4712,4715,3,1428,
  	714,0,4713,4715,3,968,484,0,4714,4712,1,0,0,0,4714,4713,1,0,0,0,4715,
  	4721,1,0,0,0,4716,4721,3,606,303,0,4717,4718,7,76,0,0,4718,4719,5,447,
  	0,0,4719,4721,3,1390,695,0,4720,4709,1,0,0,0,4720,4716,1,0,0,0,4720,4717,
  	1,0,0,0,4721,605,1,0,0,0,4722,4723,5,212,0,0,4723,4726,3,1390,695,0,4724,
  	4725,5,647,0,0,4725,4727,3,608,304,0,4726,4724,1,0,0,0,4726,4727,1,0,
  	0,0,4727,607,1,0,0,0,4728,4733,3,968,484,0,4729,4730,5,29,0,0,4730,4732,
  	3,968,484,0,4731,4729,1,0,0,0,4732,4735,1,0,0,0,4733,4731,1,0,0,0,4733,
  	4734,1,0,0,0,4734,609,1,0,0,0,4735,4733,1,0,0,0,4736,4761,5,702,0,0,4737,
  	4738,5,316,0,0,4738,4739,5,154,0,0,4739,4741,5,179,0,0,4740,4742,3,1460,
  	730,0,4741,4740,1,0,0,0,4741,4742,1,0,0,0,4742,4743,1,0,0,0,4743,4762,
  	3,1422,711,0,4744,4747,5,701,0,0,4745,4746,5,236,0,0,4746,4748,5,489,
  	0,0,4747,4745,1,0,0,0,4747,4748,1,0,0,0,4748,4762,1,0,0,0,4749,4750,4,
  	305,91,0,4750,4751,5,280,0,0,4751,4752,5,239,0,0,4752,4753,3,1290,645,
  	0,4753,4754,5,31,0,0,4754,4755,3,1402,701,0,4755,4756,5,266,0,0,4756,
  	4757,5,90,0,0,4757,4759,3,1422,711,0,4758,4760,3,612,306,0,4759,4758,
  	1,0,0,0,4759,4760,1,0,0,0,4760,4762,1,0,0,0,4761,4737,1,0,0,0,4761,4744,
  	1,0,0,0,4761,4749,1,0,0,0,4762,611,1,0,0,0,4763,4774,3,614,307,0,4764,
  	4765,5,154,0,0,4765,4767,5,179,0,0,4766,4768,3,1460,730,0,4767,4766,1,
  	0,0,0,4767,4768,1,0,0,0,4768,4769,1,0,0,0,4769,4771,3,1422,711,0,4770,
  	4772,3,614,307,0,4771,4770,1,0,0,0,4771,4772,1,0,0,0,4772,4774,1,0,0,
  	0,4773,4763,1,0,0,0,4773,4764,1,0,0,0,4774,613,1,0,0,0,4775,4777,5,497,
  	0,0,4776,4778,5,403,0,0,4777,4776,1,0,0,0,4777,4778,1,0,0,0,4778,4779,
  	1,0,0,0,4779,4780,5,565,0,0,4780,615,1,0,0,0,4781,4790,3,618,309,0,4782,
  	4790,3,628,314,0,4783,4790,3,642,321,0,4784,4790,3,644,322,0,4785,4790,
  	3,658,329,0,4786,4790,3,660,330,0,4787,4788,4,308,92,0,4788,4790,3,676,
  	338,0,4789,4781,1,0,0,0,4789,4782,1,0,0,0,4789,4783,1,0,0,0,4789,4784,
  	1,0,0,0,4789,4785,1,0,0,0,4789,4786,1,0,0,0,4789,4787,1,0,0,0,4790,617,
  	1,0,0,0,4791,4792,5,57,0,0,4792,4795,5,644,0,0,4793,4794,4,309,93,0,4794,
  	4796,3,1218,609,0,4795,4793,1,0,0,0,4795,4796,1,0,0,0,4796,4846,1,0,0,
  	0,4797,4798,4,309,94,0,4798,4802,3,1256,628,0,4799,4800,4,309,95,0,4800,
  	4802,3,620,310,0,4801,4797,1,0,0,0,4801,4799,1,0,0,0,4802,4803,1,0,0,
  	0,4803,4804,3,630,315,0,4804,4847,1,0,0,0,4805,4806,4,309,96,0,4806,4825,
  	3,626,313,0,4807,4810,3,1266,633,0,4808,4810,3,1264,632,0,4809,4807,1,
  	0,0,0,4809,4808,1,0,0,0,4810,4813,1,0,0,0,4811,4812,4,309,97,0,4812,4814,
  	3,1286,643,0,4813,4811,1,0,0,0,4813,4814,1,0,0,0,4814,4817,1,0,0,0,4815,
  	4816,4,309,98,0,4816,4818,3,1278,639,0,4817,4815,1,0,0,0,4817,4818,1,
  	0,0,0,4818,4826,1,0,0,0,4819,4820,4,309,99,0,4820,4826,3,1280,640,0,4821,
  	4823,4,309,100,0,4822,4824,3,1282,641,0,4823,4822,1,0,0,0,4823,4824,1,
  	0,0,0,4824,4826,1,0,0,0,4825,4809,1,0,0,0,4825,4819,1,0,0,0,4825,4821,
  	1,0,0,0,4826,4847,1,0,0,0,4827,4828,4,309,101,0,4828,4829,3,626,313,0,
  	4829,4830,3,1264,632,0,4830,4847,1,0,0,0,4831,4832,4,309,102,0,4832,4844,
  	3,1290,645,0,4833,4834,5,168,0,0,4834,4838,5,684,0,0,4835,4839,5,56,0,
  	0,4836,4839,5,399,0,0,4837,4839,3,678,339,0,4838,4835,1,0,0,0,4838,4836,
  	1,0,0,0,4838,4837,1,0,0,0,4839,4845,1,0,0,0,4840,4842,4,309,103,0,4841,
  	4843,3,1282,641,0,4842,4841,1,0,0,0,4842,4843,1,0,0,0,4843,4845,1,0,0,
  	0,4844,4833,1,0,0,0,4844,4840,1,0,0,0,4845,4847,1,0,0,0,4846,4801,1,0,
  	0,0,4846,4805,1,0,0,0,4846,4827,1,0,0,0,4846,4831,1,0,0,0,4847,619,1,
  	0,0,0,4848,4853,3,622,311,0,4849,4850,5,29,0,0,4850,4852,3,622,311,0,
  	4851,4849,1,0,0,0,4852,4855,1,0,0,0,4853,4851,1,0,0,0,4853,4854,1,0,0,
  	0,4854,621,1,0,0,0,4855,4853,1,0,0,0,4856,4857,4,311,104,0,4857,4935,
  	3,624,312,0,4858,4859,4,311,105,0,4859,4932,3,1290,645,0,4860,4869,3,
  	1264,632,0,4861,4862,5,488,0,0,4862,4864,3,1422,711,0,4863,4865,3,1278,
  	639,0,4864,4863,1,0,0,0,4864,4865,1,0,0,0,4865,4870,1,0,0,0,4866,4868,
  	3,1278,639,0,4867,4866,1,0,0,0,4867,4868,1,0,0,0,4868,4870,1,0,0,0,4869,
  	4861,1,0,0,0,4869,4867,1,0,0,0,4870,4933,1,0,0,0,4871,4880,3,1266,633,
  	0,4872,4874,3,1278,639,0,4873,4872,1,0,0,0,4873,4874,1,0,0,0,4874,4881,
  	1,0,0,0,4875,4876,5,488,0,0,4876,4878,3,1422,711,0,4877,4879,3,1278,639,
  	0,4878,4877,1,0,0,0,4878,4879,1,0,0,0,4879,4881,1,0,0,0,4880,4873,1,0,
  	0,0,4880,4875,1,0,0,0,4881,4933,1,0,0,0,4882,4933,3,1268,634,0,4883,4885,
  	3,1270,635,0,4884,4886,3,1278,639,0,4885,4884,1,0,0,0,4885,4886,1,0,0,
  	0,4886,4933,1,0,0,0,4887,4896,3,1272,636,0,4888,4889,5,488,0,0,4889,4891,
  	3,1422,711,0,4890,4892,3,1278,639,0,4891,4890,1,0,0,0,4891,4892,1,0,0,
  	0,4892,4897,1,0,0,0,4893,4895,3,1278,639,0,4894,4893,1,0,0,0,4894,4895,
  	1,0,0,0,4895,4897,1,0,0,0,4896,4888,1,0,0,0,4896,4894,1,0,0,0,4897,4933,
  	1,0,0,0,4898,4900,3,1274,637,0,4899,4901,3,1278,639,0,4900,4899,1,0,0,
  	0,4900,4901,1,0,0,0,4901,4933,1,0,0,0,4902,4904,3,1280,640,0,4903,4902,
  	1,0,0,0,4903,4904,1,0,0,0,4904,4933,1,0,0,0,4905,4906,4,311,106,0,4906,
  	4907,5,50,0,0,4907,4908,3,1284,642,0,4908,4913,3,1262,631,0,4909,4910,
  	5,50,0,0,4910,4911,3,1284,642,0,4911,4912,3,1262,631,0,4912,4914,1,0,
  	0,0,4913,4909,1,0,0,0,4913,4914,1,0,0,0,4914,4933,1,0,0,0,4915,4916,4,
  	311,107,0,4916,4917,5,379,0,0,4917,4918,3,1284,642,0,4918,4923,3,1262,
  	631,0,4919,4920,5,379,0,0,4920,4921,3,1284,642,0,4921,4922,3,1262,631,
  	0,4922,4924,1,0,0,0,4923,4919,1,0,0,0,4923,4924,1,0,0,0,4924,4933,1,0,
  	0,0,4925,4926,4,311,108,0,4926,4927,5,187,0,0,4927,4930,3,1284,642,0,
  	4928,4929,5,187,0,0,4929,4931,3,1284,642,0,4930,4928,1,0,0,0,4930,4931,
  	1,0,0,0,4931,4933,1,0,0,0,4932,4860,1,0,0,0,4932,4871,1,0,0,0,4932,4882,
  	1,0,0,0,4932,4883,1,0,0,0,4932,4887,1,0,0,0,4932,4898,1,0,0,0,4932,4903,
  	1,0,0,0,4932,4905,1,0,0,0,4932,4915,1,0,0,0,4932,4925,1,0,0,0,4933,4935,
  	1,0,0,0,4934,4856,1,0,0,0,4934,4858,1,0,0,0,4935,623,1,0,0,0,4936,4937,
  	3,1290,645,0,4937,4938,5,266,0,0,4938,4957,5,90,0,0,4939,4942,3,1424,
  	712,0,4940,4941,4,312,109,0,4941,4943,3,1286,643,0,4942,4940,1,0,0,0,
  	4942,4943,1,0,0,0,4943,4946,1,0,0,0,4944,4945,4,312,110,0,4945,4947,3,
  	1278,639,0,4946,4944,1,0,0,0,4946,4947,1,0,0,0,4947,4958,1,0,0,0,4948,
  	4949,4,312,111,0,4949,4950,5,759,0,0,4950,4952,5,436,0,0,4951,4953,3,
  	1286,643,0,4952,4951,1,0,0,0,4952,4953,1,0,0,0,4953,4955,1,0,0,0,4954,
  	4956,3,1278,639,0,4955,4954,1,0,0,0,4955,4956,1,0,0,0,4956,4958,1,0,0,
  	0,4957,4939,1,0,0,0,4957,4948,1,0,0,0,4958,4994,1,0,0,0,4959,4960,3,1290,
  	645,0,4960,4961,5,266,0,0,4961,4962,5,670,0,0,4962,4986,3,1450,725,0,
  	4963,4964,5,90,0,0,4964,4967,3,1424,712,0,4965,4966,4,312,112,0,4966,
  	4968,3,1286,643,0,4967,4965,1,0,0,0,4967,4968,1,0,0,0,4968,4971,1,0,0,
  	0,4969,4970,4,312,113,0,4970,4972,3,1278,639,0,4971,4969,1,0,0,0,4971,
  	4972,1,0,0,0,4972,4987,1,0,0,0,4973,4974,5,63,0,0,4974,4977,3,1426,713,
  	0,4975,4976,4,312,114,0,4976,4978,3,1278,639,0,4977,4975,1,0,0,0,4977,
  	4978,1,0,0,0,4978,4987,1,0,0,0,4979,4980,4,312,115,0,4980,4981,5,90,0,
  	0,4981,4982,5,759,0,0,4982,4984,5,436,0,0,4983,4985,3,1278,639,0,4984,
  	4983,1,0,0,0,4984,4985,1,0,0,0,4985,4987,1,0,0,0,4986,4963,1,0,0,0,4986,
  	4973,1,0,0,0,4986,4979,1,0,0,0,4986,4987,1,0,0,0,4987,4994,1,0,0,0,4988,
  	4989,4,312,116,0,4989,4991,3,1290,645,0,4990,4992,3,1280,640,0,4991,4990,
  	1,0,0,0,4991,4992,1,0,0,0,4992,4994,1,0,0,0,4993,4936,1,0,0,0,4993,4959,
  	1,0,0,0,4993,4988,1,0,0,0,4994,625,1,0,0,0,4995,4996,5,644,0,0,4996,4997,
  	3,1458,729,0,4997,627,1,0,0,0,4998,4999,5,140,0,0,4999,5002,5,644,0,0,
  	5000,5001,4,314,117,0,5001,5003,3,1224,612,0,5002,5000,1,0,0,0,5002,5003,
  	1,0,0,0,5003,5004,1,0,0,0,5004,5005,3,1256,628,0,5005,5006,3,634,317,
  	0,5006,5007,3,630,315,0,5007,629,1,0,0,0,5008,5010,4,315,118,0,5009,5011,
  	3,636,318,0,5010,5009,1,0,0,0,5010,5011,1,0,0,0,5011,5013,1,0,0,0,5012,
  	5014,3,638,319,0,5013,5012,1,0,0,0,5013,5014,1,0,0,0,5014,5018,1,0,0,
  	0,5015,5017,3,640,320,0,5016,5015,1,0,0,0,5017,5020,1,0,0,0,5018,5016,
  	1,0,0,0,5018,5019,1,0,0,0,5019,5023,1,0,0,0,5020,5018,1,0,0,0,5021,5022,
  	4,315,119,0,5022,5024,3,632,316,0,5023,5021,1,0,0,0,5023,5024,1,0,0,0,
  	5024,5027,1,0,0,0,5025,5027,1,0,0,0,5026,5008,1,0,0,0,5026,5025,1,0,0,
  	0,5027,631,1,0,0,0,5028,5029,5,773,0,0,5029,5033,3,1422,711,0,5030,5031,
  	5,119,0,0,5031,5033,3,1422,711,0,5032,5028,1,0,0,0,5032,5030,1,0,0,0,
  	5033,633,1,0,0,0,5034,5038,4,317,120,0,5035,5036,5,168,0,0,5036,5037,
  	5,684,0,0,5037,5039,3,678,339,0,5038,5035,1,0,0,0,5038,5039,1,0,0,0,5039,
  	5042,1,0,0,0,5040,5042,1,0,0,0,5041,5034,1,0,0,0,5041,5040,1,0,0,0,5042,
  	635,1,0,0,0,5043,5046,5,497,0,0,5044,5047,3,670,335,0,5045,5047,7,77,
  	0,0,5046,5044,1,0,0,0,5046,5045,1,0,0,0,5047,637,1,0,0,0,5048,5057,5,
  	670,0,0,5049,5050,5,354,0,0,5050,5058,3,1402,701,0,5051,5052,5,359,0,
  	0,5052,5058,3,1402,701,0,5053,5054,5,353,0,0,5054,5058,3,1402,701,0,5055,
  	5056,5,360,0,0,5056,5058,3,1402,701,0,5057,5049,1,0,0,0,5057,5051,1,0,
  	0,0,5057,5053,1,0,0,0,5057,5055,1,0,0,0,5058,5059,1,0,0,0,5059,5057,1,
  	0,0,0,5059,5060,1,0,0,0,5060,639,1,0,0,0,5061,5062,5,48,0,0,5062,5104,
  	7,78,0,0,5063,5092,5,436,0,0,5064,5071,5,216,0,0,5065,5066,5,282,0,0,
  	5066,5067,3,1404,702,0,5067,5068,5,163,0,0,5068,5072,1,0,0,0,5069,5072,
  	5,395,0,0,5070,5072,5,168,0,0,5071,5065,1,0,0,0,5071,5069,1,0,0,0,5071,
  	5070,1,0,0,0,5071,5072,1,0,0,0,5072,5093,1,0,0,0,5073,5076,5,730,0,0,
  	5074,5077,3,1404,702,0,5075,5077,5,168,0,0,5076,5074,1,0,0,0,5076,5075,
  	1,0,0,0,5077,5093,1,0,0,0,5078,5079,5,731,0,0,5079,5084,5,282,0,0,5080,
  	5081,3,1404,702,0,5081,5082,5,163,0,0,5082,5085,1,0,0,0,5083,5085,5,168,
  	0,0,5084,5080,1,0,0,0,5084,5083,1,0,0,0,5085,5093,1,0,0,0,5086,5087,4,
  	320,121,0,5087,5088,5,497,0,0,5088,5090,5,144,0,0,5089,5091,7,79,0,0,
  	5090,5089,1,0,0,0,5090,5091,1,0,0,0,5091,5093,1,0,0,0,5092,5064,1,0,0,
  	0,5092,5073,1,0,0,0,5092,5078,1,0,0,0,5092,5086,1,0,0,0,5093,5104,1,0,
  	0,0,5094,5095,4,320,122,0,5095,5096,5,766,0,0,5096,5104,3,1404,702,0,
  	5097,5098,4,320,123,0,5098,5101,5,765,0,0,5099,5102,3,1404,702,0,5100,
  	5102,5,723,0,0,5101,5099,1,0,0,0,5101,5100,1,0,0,0,5102,5104,1,0,0,0,
  	5103,5061,1,0,0,0,5103,5063,1,0,0,0,5103,5094,1,0,0,0,5103,5097,1,0,0,
  	0,5104,641,1,0,0,0,5105,5106,5,187,0,0,5106,5109,5,644,0,0,5107,5108,
  	4,321,124,0,5108,5110,3,1218,609,0,5109,5107,1,0,0,0,5109,5110,1,0,0,
  	0,5110,5111,1,0,0,0,5111,5112,3,1254,627,0,5112,643,1,0,0,0,5113,5156,
  	5,251,0,0,5114,5115,4,322,125,0,5115,5116,3,664,332,0,5116,5117,5,616,
  	0,0,5117,5121,3,1254,627,0,5118,5119,5,670,0,0,5119,5120,5,685,0,0,5120,
  	5122,5,421,0,0,5121,5118,1,0,0,0,5121,5122,1,0,0,0,5122,5157,1,0,0,0,
  	5123,5129,3,664,332,0,5124,5126,5,56,0,0,5125,5127,5,451,0,0,5126,5125,
  	1,0,0,0,5126,5127,1,0,0,0,5127,5129,1,0,0,0,5128,5123,1,0,0,0,5128,5124,
  	1,0,0,0,5129,5130,1,0,0,0,5130,5132,5,413,0,0,5131,5133,3,662,331,0,5132,
  	5131,1,0,0,0,5132,5133,1,0,0,0,5133,5134,1,0,0,0,5134,5135,3,668,334,
  	0,5135,5136,5,616,0,0,5136,5138,3,646,323,0,5137,5139,3,656,328,0,5138,
  	5137,1,0,0,0,5138,5139,1,0,0,0,5139,5141,1,0,0,0,5140,5142,3,648,324,
  	0,5141,5140,1,0,0,0,5141,5142,1,0,0,0,5142,5144,1,0,0,0,5143,5145,3,654,
  	327,0,5144,5143,1,0,0,0,5144,5145,1,0,0,0,5145,5157,1,0,0,0,5146,5147,
  	5,457,0,0,5147,5148,5,413,0,0,5148,5149,3,1290,645,0,5149,5150,5,616,
  	0,0,5150,5154,3,646,323,0,5151,5152,5,670,0,0,5152,5153,5,251,0,0,5153,
  	5155,5,421,0,0,5154,5151,1,0,0,0,5154,5155,1,0,0,0,5155,5157,1,0,0,0,
  	5156,5114,1,0,0,0,5156,5128,1,0,0,0,5156,5146,1,0,0,0,5157,645,1,0,0,
  	0,5158,5159,4,323,126,0,5159,5163,3,1256,628,0,5160,5161,4,323,127,0,
  	5161,5163,3,1254,627,0,5162,5158,1,0,0,0,5162,5160,1,0,0,0,5163,647,1,
  	0,0,0,5164,5165,5,670,0,0,5165,5166,3,674,337,0,5166,649,1,0,0,0,5167,
  	5168,5,688,0,0,5168,5169,3,678,339,0,5169,651,1,0,0,0,5170,5171,5,670,
  	0,0,5171,5179,5,684,0,0,5172,5180,3,678,339,0,5173,5175,5,56,0,0,5174,
  	5176,3,650,325,0,5175,5174,1,0,0,0,5175,5176,1,0,0,0,5176,5180,1,0,0,
  	0,5177,5180,5,399,0,0,5178,5180,5,168,0,0,5179,5172,1,0,0,0,5179,5173,
  	1,0,0,0,5179,5177,1,0,0,0,5179,5178,1,0,0,0,5180,653,1,0,0,0,5181,5182,
  	5,63,0,0,5182,5184,5,644,0,0,5183,5185,3,652,326,0,5184,5183,1,0,0,0,
  	5184,5185,1,0,0,0,5185,655,1,0,0,0,5186,5187,4,328,128,0,5187,5188,3,
  	636,318,0,5188,657,1,0,0,0,5189,5190,5,483,0,0,5190,5191,5,644,0,0,5191,
  	5192,3,1290,645,0,5192,5193,5,616,0,0,5193,5201,3,1290,645,0,5194,5195,
  	5,29,0,0,5195,5196,3,1290,645,0,5196,5197,5,616,0,0,5197,5198,3,1290,
  	645,0,5198,5200,1,0,0,0,5199,5194,1,0,0,0,5200,5203,1,0,0,0,5201,5199,
  	1,0,0,0,5201,5202,1,0,0,0,5202,659,1,0,0,0,5203,5201,1,0,0,0,5204,5207,
  	5,507,0,0,5205,5206,4,330,129,0,5206,5208,3,1218,609,0,5207,5205,1,0,
  	0,0,5207,5208,1,0,0,0,5208,5246,1,0,0,0,5209,5210,4,330,130,0,5210,5211,
  	3,664,332,0,5211,5212,5,239,0,0,5212,5213,3,1254,627,0,5213,5247,1,0,
  	0,0,5214,5215,3,664,332,0,5215,5217,5,413,0,0,5216,5218,3,662,331,0,5217,
  	5216,1,0,0,0,5217,5218,1,0,0,0,5218,5219,1,0,0,0,5219,5220,3,668,334,
  	0,5220,5221,5,239,0,0,5221,5222,3,1254,627,0,5222,5247,1,0,0,0,5223,5225,
  	5,56,0,0,5224,5226,5,451,0,0,5225,5224,1,0,0,0,5225,5226,1,0,0,0,5226,
  	5236,1,0,0,0,5227,5228,4,330,131,0,5228,5230,5,413,0,0,5229,5231,3,662,
  	331,0,5230,5229,1,0,0,0,5230,5231,1,0,0,0,5231,5232,1,0,0,0,5232,5237,
  	3,668,334,0,5233,5234,5,29,0,0,5234,5235,5,251,0,0,5235,5237,5,421,0,
  	0,5236,5227,1,0,0,0,5236,5233,1,0,0,0,5237,5238,1,0,0,0,5238,5239,5,239,
  	0,0,5239,5247,3,1254,627,0,5240,5241,5,457,0,0,5241,5242,5,413,0,0,5242,
  	5243,3,1290,645,0,5243,5244,5,239,0,0,5244,5245,3,1254,627,0,5245,5247,
  	1,0,0,0,5246,5209,1,0,0,0,5246,5214,1,0,0,0,5246,5223,1,0,0,0,5246,5240,
  	1,0,0,0,5247,5250,1,0,0,0,5248,5249,4,330,132,0,5249,5251,3,1226,613,
  	0,5250,5248,1,0,0,0,5250,5251,1,0,0,0,5251,661,1,0,0,0,5252,5253,7,80,
  	0,0,5253,663,1,0,0,0,5254,5259,3,666,333,0,5255,5256,5,29,0,0,5256,5258,
  	3,666,333,0,5257,5255,1,0,0,0,5258,5261,1,0,0,0,5259,5257,1,0,0,0,5259,
  	5260,1,0,0,0,5260,665,1,0,0,0,5261,5259,1,0,0,0,5262,5273,4,333,133,0,
  	5263,5265,3,1454,727,0,5264,5266,3,1308,654,0,5265,5264,1,0,0,0,5265,
  	5266,1,0,0,0,5266,5274,1,0,0,0,5267,5268,3,1454,727,0,5268,5271,5,39,
  	0,0,5269,5272,3,1450,725,0,5270,5272,5,845,0,0,5271,5269,1,0,0,0,5271,
  	5270,1,0,0,0,5272,5274,1,0,0,0,5273,5263,1,0,0,0,5273,5267,1,0,0,0,5274,
  	5307,1,0,0,0,5275,5277,7,81,0,0,5276,5278,3,1308,654,0,5277,5276,1,0,
  	0,0,5277,5278,1,0,0,0,5278,5307,1,0,0,0,5279,5307,7,82,0,0,5280,5281,
  	5,251,0,0,5281,5307,5,421,0,0,5282,5283,5,536,0,0,5283,5307,5,152,0,0,
  	5284,5288,5,140,0,0,5285,5286,5,603,0,0,5286,5289,5,597,0,0,5287,5289,
  	7,83,0,0,5288,5285,1,0,0,0,5288,5287,1,0,0,0,5288,5289,1,0,0,0,5289,5307,
  	1,0,0,0,5290,5291,5,319,0,0,5291,5307,5,597,0,0,5292,5295,5,489,0,0,5293,
  	5296,5,109,0,0,5294,5296,3,602,301,0,5295,5293,1,0,0,0,5295,5294,1,0,
  	0,0,5296,5307,1,0,0,0,5297,5298,5,536,0,0,5298,5307,5,661,0,0,5299,5301,
  	5,57,0,0,5300,5302,5,512,0,0,5301,5300,1,0,0,0,5301,5302,1,0,0,0,5302,
  	5307,1,0,0,0,5303,5304,4,333,134,0,5304,5305,7,84,0,0,5305,5307,5,684,
  	0,0,5306,5262,1,0,0,0,5306,5275,1,0,0,0,5306,5279,1,0,0,0,5306,5280,1,
  	0,0,0,5306,5282,1,0,0,0,5306,5284,1,0,0,0,5306,5290,1,0,0,0,5306,5292,
  	1,0,0,0,5306,5297,1,0,0,0,5306,5299,1,0,0,0,5306,5303,1,0,0,0,5307,667,
  	1,0,0,0,5308,5311,5,16,0,0,5309,5310,5,28,0,0,5310,5312,5,16,0,0,5311,
  	5309,1,0,0,0,5311,5312,1,0,0,0,5312,5325,1,0,0,0,5313,5316,3,1322,661,
  	0,5314,5315,5,28,0,0,5315,5317,5,16,0,0,5316,5314,1,0,0,0,5316,5317,1,
  	0,0,0,5317,5325,1,0,0,0,5318,5325,3,1366,683,0,5319,5320,4,334,135,0,
  	5320,5321,3,1322,661,0,5321,5322,5,28,0,0,5322,5323,3,1366,683,0,5323,
  	5325,1,0,0,0,5324,5308,1,0,0,0,5324,5313,1,0,0,0,5324,5318,1,0,0,0,5324,
  	5319,1,0,0,0,5325,669,1,0,0,0,5326,5333,3,672,336,0,5327,5329,5,61,0,
  	0,5328,5327,1,0,0,0,5328,5329,1,0,0,0,5329,5330,1,0,0,0,5330,5332,3,672,
  	336,0,5331,5328,1,0,0,0,5332,5335,1,0,0,0,5333,5331,1,0,0,0,5333,5334,
  	1,0,0,0,5334,671,1,0,0,0,5335,5333,1,0,0,0,5336,5337,5,107,0,0,5337,5343,
  	3,1424,712,0,5338,5339,5,293,0,0,5339,5343,3,1424,712,0,5340,5341,5,585,
  	0,0,5341,5343,3,1424,712,0,5342,5336,1,0,0,0,5342,5338,1,0,0,0,5342,5340,
  	1,0,0,0,5343,673,1,0,0,0,5344,5345,5,251,0,0,5345,5358,5,421,0,0,5346,
  	5355,4,337,136,0,5347,5348,5,354,0,0,5348,5356,3,1402,701,0,5349,5350,
  	5,359,0,0,5350,5356,3,1402,701,0,5351,5352,5,353,0,0,5352,5356,3,1402,
  	701,0,5353,5354,5,360,0,0,5354,5356,3,1402,701,0,5355,5347,1,0,0,0,5355,
  	5349,1,0,0,0,5355,5351,1,0,0,0,5355,5353,1,0,0,0,5356,5358,1,0,0,0,5357,
  	5344,1,0,0,0,5357,5346,1,0,0,0,5358,675,1,0,0,0,5359,5360,5,533,0,0,5360,
  	5361,5,684,0,0,5361,5383,3,678,339,0,5362,5363,5,533,0,0,5363,5364,5,
  	684,0,0,5364,5383,7,85,0,0,5365,5366,5,533,0,0,5366,5367,5,168,0,0,5367,
  	5371,5,684,0,0,5368,5372,3,678,339,0,5369,5372,5,399,0,0,5370,5372,5,
  	56,0,0,5371,5368,1,0,0,0,5371,5369,1,0,0,0,5371,5370,1,0,0,0,5372,5373,
  	1,0,0,0,5373,5374,5,616,0,0,5374,5383,3,678,339,0,5375,5376,5,533,0,0,
  	5376,5377,5,684,0,0,5377,5380,5,56,0,0,5378,5379,5,688,0,0,5379,5381,
  	3,678,339,0,5380,5378,1,0,0,0,5380,5381,1,0,0,0,5381,5383,1,0,0,0,5382,
  	5359,1,0,0,0,5382,5362,1,0,0,0,5382,5365,1,0,0,0,5382,5375,1,0,0,0,5383,
  	677,1,0,0,0,5384,5389,3,680,340,0,5385,5386,5,29,0,0,5386,5388,3,680,
  	340,0,5387,5385,1,0,0,0,5388,5391,1,0,0,0,5389,5387,1,0,0,0,5389,5390,
  	1,0,0,0,5390,679,1,0,0,0,5391,5389,1,0,0,0,5392,5398,3,1454,727,0,5393,
  	5396,5,39,0,0,5394,5397,3,1450,725,0,5395,5397,5,845,0,0,5396,5394,1,
  	0,0,0,5396,5395,1,0,0,0,5397,5399,1,0,0,0,5398,5393,1,0,0,0,5398,5399,
  	1,0,0,0,5399,681,1,0,0,0,5400,5402,5,60,0,0,5401,5403,3,1298,649,0,5402,
  	5401,1,0,0,0,5402,5403,1,0,0,0,5403,5404,1,0,0,0,5404,5405,5,600,0,0,
  	5405,5408,3,1368,684,0,5406,5407,4,341,137,0,5407,5409,3,684,342,0,5408,
  	5406,1,0,0,0,5408,5409,1,0,0,0,5409,5444,1,0,0,0,5410,5411,5,106,0,0,
  	5411,5412,5,600,0,0,5412,5416,3,1368,684,0,5413,5415,3,686,343,0,5414,
  	5413,1,0,0,0,5415,5418,1,0,0,0,5416,5414,1,0,0,0,5416,5417,1,0,0,0,5417,
  	5444,1,0,0,0,5418,5416,1,0,0,0,5419,5420,5,105,0,0,5420,5421,5,600,0,
  	0,5421,5423,3,1368,684,0,5422,5424,7,86,0,0,5423,5422,1,0,0,0,5423,5424,
  	1,0,0,0,5424,5444,1,0,0,0,5425,5427,5,418,0,0,5426,5428,3,1298,649,0,
  	5427,5426,1,0,0,0,5427,5428,1,0,0,0,5428,5429,1,0,0,0,5429,5430,5,600,
  	0,0,5430,5444,3,1368,684,0,5431,5433,5,485,0,0,5432,5434,3,1298,649,0,
  	5433,5432,1,0,0,0,5433,5434,1,0,0,0,5434,5435,1,0,0,0,5435,5436,5,600,
  	0,0,5436,5440,3,1368,684,0,5437,5439,3,688,344,0,5438,5437,1,0,0,0,5439,
  	5442,1,0,0,0,5440,5438,1,0,0,0,5440,5441,1,0,0,0,5441,5444,1,0,0,0,5442,
  	5440,1,0,0,0,5443,5400,1,0,0,0,5443,5410,1,0,0,0,5443,5419,1,0,0,0,5443,
  	5425,1,0,0,0,5443,5431,1,0,0,0,5444,683,1,0,0,0,5445,5446,5,640,0,0,5446,
  	5447,5,699,0,0,5447,5448,5,413,0,0,5448,5456,3,1392,696,0,5449,5450,5,
  	670,0,0,5450,5451,5,3,0,0,5451,5457,5,700,0,0,5452,5453,4,342,138,0,5453,
  	5454,5,647,0,0,5454,5455,5,154,0,0,5455,5457,3,1422,711,0,5456,5449,1,
  	0,0,0,5456,5452,1,0,0,0,5456,5457,1,0,0,0,5457,5463,1,0,0,0,5458,5459,
  	5,187,0,0,5459,5460,5,699,0,0,5460,5461,5,413,0,0,5461,5463,3,1392,696,
  	0,5462,5445,1,0,0,0,5462,5458,1,0,0,0,5463,685,1,0,0,0,5464,5465,5,236,
  	0,0,5465,5468,5,641,0,0,5466,5468,7,87,0,0,5467,5464,1,0,0,0,5467,5466,
  	1,0,0,0,5468,687,1,0,0,0,5469,5470,7,88,0,0,5470,689,1,0,0,0,5471,5483,
  	5,633,0,0,5472,5473,5,440,0,0,5473,5484,3,1380,690,0,5474,5475,5,689,
  	0,0,5475,5480,3,1382,691,0,5476,5477,5,29,0,0,5477,5479,3,1382,691,0,
  	5478,5476,1,0,0,0,5479,5482,1,0,0,0,5480,5478,1,0,0,0,5480,5481,1,0,0,
  	0,5481,5484,1,0,0,0,5482,5480,1,0,0,0,5483,5472,1,0,0,0,5483,5474,1,0,
  	0,0,5484,691,1,0,0,0,5485,5496,5,281,0,0,5486,5487,5,440,0,0,5487,5488,
  	3,1390,695,0,5488,5489,5,546,0,0,5489,5490,3,1422,711,0,5490,5497,1,0,
  	0,0,5491,5492,5,689,0,0,5492,5494,3,1432,716,0,5493,5495,3,700,350,0,
  	5494,5493,1,0,0,0,5494,5495,1,0,0,0,5495,5497,1,0,0,0,5496,5486,1,0,0,
  	0,5496,5491,1,0,0,0,5497,693,1,0,0,0,5498,5499,7,89,0,0,5499,695,1,0,
  	0,0,5500,5503,3,898,449,0,5501,5503,5,413,0,0,5502,5500,1,0,0,0,5502,
  	5501,1,0,0,0,5503,697,1,0,0,0,5504,5505,3,694,347,0,5505,5506,3,976,488,
  	0,5506,5507,3,1460,730,0,5507,5508,3,696,348,0,5508,699,1,0,0,0,5509,
  	5510,4,350,139,0,5510,5511,5,533,0,0,5511,5516,3,698,349,0,5512,5513,
  	5,29,0,0,5513,5515,3,698,349,0,5514,5512,1,0,0,0,5515,5518,1,0,0,0,5516,
  	5514,1,0,0,0,5516,5517,1,0,0,0,5517,701,1,0,0,0,5518,5516,1,0,0,0,5519,
  	5520,5,533,0,0,5520,5521,3,704,352,0,5521,703,1,0,0,0,5522,5523,3,714,
  	357,0,5523,5524,3,712,356,0,5524,5579,1,0,0,0,5525,5526,5,618,0,0,5526,
  	5579,3,706,353,0,5527,5528,3,1462,731,0,5528,5529,3,718,359,0,5529,5579,
  	1,0,0,0,5530,5533,5,436,0,0,5531,5532,5,236,0,0,5532,5534,3,1290,645,
  	0,5533,5531,1,0,0,0,5533,5534,1,0,0,0,5534,5535,1,0,0,0,5535,5562,3,1460,
  	730,0,5536,5538,3,1424,712,0,5537,5539,3,1286,643,0,5538,5537,1,0,0,0,
  	5538,5539,1,0,0,0,5539,5541,1,0,0,0,5540,5542,3,1278,639,0,5541,5540,
  	1,0,0,0,5541,5542,1,0,0,0,5542,5563,1,0,0,0,5543,5545,3,1424,712,0,5544,
  	5546,3,1286,643,0,5545,5544,1,0,0,0,5545,5546,1,0,0,0,5546,5548,1,0,0,
  	0,5547,5549,3,1278,639,0,5548,5547,1,0,0,0,5548,5549,1,0,0,0,5549,5563,
  	1,0,0,0,5550,5551,4,352,140,0,5551,5552,5,412,0,0,5552,5553,5,32,0,0,
  	5553,5554,3,1424,712,0,5554,5555,5,33,0,0,5555,5563,1,0,0,0,5556,5557,
  	4,352,141,0,5557,5558,5,436,0,0,5558,5559,5,32,0,0,5559,5560,3,1424,712,
  	0,5560,5561,5,33,0,0,5561,5563,1,0,0,0,5562,5536,1,0,0,0,5562,5543,1,
  	0,0,0,5562,5550,1,0,0,0,5562,5556,1,0,0,0,5563,5579,1,0,0,0,5564,5565,
  	4,352,142,0,5565,5568,5,436,0,0,5566,5567,5,236,0,0,5567,5569,3,1290,
  	645,0,5568,5566,1,0,0,0,5568,5569,1,0,0,0,5569,5570,1,0,0,0,5570,5571,
  	5,616,0,0,5571,5573,5,759,0,0,5572,5574,3,1286,643,0,5573,5572,1,0,0,
  	0,5573,5574,1,0,0,0,5574,5576,1,0,0,0,5575,5577,3,1278,639,0,5576,5575,
  	1,0,0,0,5576,5577,1,0,0,0,5577,5579,1,0,0,0,5578,5522,1,0,0,0,5578,5525,
  	1,0,0,0,5578,5527,1,0,0,0,5578,5530,1,0,0,0,5578,5564,1,0,0,0,5579,705,
  	1,0,0,0,5580,5582,3,708,354,0,5581,5583,3,710,355,0,5582,5581,1,0,0,0,
  	5582,5583,1,0,0,0,5583,5590,1,0,0,0,5584,5587,3,710,355,0,5585,5586,5,
  	29,0,0,5586,5588,3,708,354,0,5587,5585,1,0,0,0,5587,5588,1,0,0,0,5588,
  	5590,1,0,0,0,5589,5580,1,0,0,0,5589,5584,1,0,0,0,5590,707,1,0,0,0,5591,
  	5592,5,465,0,0,5592,5593,7,41,0,0,5593,709,1,0,0,0,5594,5595,5,292,0,
  	0,5595,5601,5,308,0,0,5596,5597,5,486,0,0,5597,5602,5,465,0,0,5598,5599,
  	5,465,0,0,5599,5602,7,90,0,0,5600,5602,5,527,0,0,5601,5596,1,0,0,0,5601,
  	5598,1,0,0,0,5601,5600,1,0,0,0,5602,711,1,0,0,0,5603,5604,5,29,0,0,5604,
  	5606,3,716,358,0,5605,5603,1,0,0,0,5606,5609,1,0,0,0,5607,5605,1,0,0,
  	0,5607,5608,1,0,0,0,5608,713,1,0,0,0,5609,5607,1,0,0,0,5610,5611,3,976,
  	488,0,5611,5612,3,1460,730,0,5612,5613,3,722,361,0,5613,5641,1,0,0,0,
  	5614,5641,3,1244,622,0,5615,5616,3,968,484,0,5616,5617,3,1460,730,0,5617,
  	5618,3,898,449,0,5618,5641,1,0,0,0,5619,5620,5,39,0,0,5620,5622,5,39,
  	0,0,5621,5623,3,1466,733,0,5622,5621,1,0,0,0,5622,5623,1,0,0,0,5623,5624,
  	1,0,0,0,5624,5625,3,976,488,0,5625,5626,3,1460,730,0,5626,5627,3,722,
  	361,0,5627,5641,1,0,0,0,5628,5638,5,387,0,0,5629,5630,3,1460,730,0,5630,
  	5631,3,898,449,0,5631,5639,1,0,0,0,5632,5634,3,1172,586,0,5633,5635,3,
  	1232,616,0,5634,5633,1,0,0,0,5634,5635,1,0,0,0,5635,5639,1,0,0,0,5636,
  	5637,4,357,143,0,5637,5639,5,168,0,0,5638,5629,1,0,0,0,5638,5632,1,0,
  	0,0,5638,5636,1,0,0,0,5639,5641,1,0,0,0,5640,5610,1,0,0,0,5640,5614,1,
  	0,0,0,5640,5615,1,0,0,0,5640,5619,1,0,0,0,5640,5628,1,0,0,0,5641,715,
  	1,0,0,0,5642,5643,3,1462,731,0,5643,5644,3,976,488,0,5644,5645,3,1460,
  	730,0,5645,5646,3,722,361,0,5646,5649,1,0,0,0,5647,5649,3,714,357,0,5648,
  	5642,1,0,0,0,5648,5647,1,0,0,0,5649,717,1,0,0,0,5650,5651,3,720,360,0,
  	5651,5652,3,712,356,0,5652,5656,1,0,0,0,5653,5654,5,618,0,0,5654,5656,
  	3,706,353,0,5655,5650,1,0,0,0,5655,5653,1,0,0,0,5656,719,1,0,0,0,5657,
  	5658,3,976,488,0,5658,5659,3,1460,730,0,5659,5660,3,722,361,0,5660,721,
  	1,0,0,0,5661,5671,3,898,449,0,5662,5671,5,168,0,0,5663,5671,5,413,0,0,
  	5664,5671,5,56,0,0,5665,5671,5,77,0,0,5666,5667,4,361,144,0,5667,5671,
  	5,516,0,0,5668,5669,4,361,145,0,5669,5671,5,735,0,0,5670,5661,1,0,0,0,
  	5670,5662,1,0,0,0,5670,5663,1,0,0,0,5670,5664,1,0,0,0,5670,5665,1,0,0,
  	0,5670,5666,1,0,0,0,5670,5668,1,0,0,0,5671,723,1,0,0,0,5672,5673,5,536,
  	0,0,5673,5675,5,152,0,0,5674,5676,3,1294,647,0,5675,5674,1,0,0,0,5675,
  	5676,1,0,0,0,5676,725,1,0,0,0,5677,5679,5,536,0,0,5678,5680,3,816,408,
  	0,5679,5678,1,0,0,0,5679,5680,1,0,0,0,5680,5681,1,0,0,0,5681,5683,5,597,
  	0,0,5682,5684,3,822,411,0,5683,5682,1,0,0,0,5683,5684,1,0,0,0,5684,5686,
  	1,0,0,0,5685,5687,3,1294,647,0,5686,5685,1,0,0,0,5686,5687,1,0,0,0,5687,
  	727,1,0,0,0,5688,5690,5,536,0,0,5689,5691,5,240,0,0,5690,5689,1,0,0,0,
  	5690,5691,1,0,0,0,5691,5692,1,0,0,0,5692,5694,5,619,0,0,5693,5695,3,822,
  	411,0,5694,5693,1,0,0,0,5694,5695,1,0,0,0,5695,5697,1,0,0,0,5696,5698,
  	3,1294,647,0,5697,5696,1,0,0,0,5697,5698,1,0,0,0,5698,729,1,0,0,0,5699,
  	5700,5,536,0,0,5700,5702,5,208,0,0,5701,5703,3,822,411,0,5702,5701,1,
  	0,0,0,5702,5703,1,0,0,0,5703,5705,1,0,0,0,5704,5706,3,1294,647,0,5705,
  	5704,1,0,0,0,5705,5706,1,0,0,0,5706,731,1,0,0,0,5707,5708,5,536,0,0,5708,
  	5709,5,600,0,0,5709,5711,5,573,0,0,5710,5712,3,822,411,0,5711,5710,1,
  	0,0,0,5711,5712,1,0,0,0,5712,5714,1,0,0,0,5713,5715,3,1294,647,0,5714,
  	5713,1,0,0,0,5714,5715,1,0,0,0,5715,733,1,0,0,0,5716,5717,5,536,0,0,5717,
  	5718,5,417,0,0,5718,5720,5,597,0,0,5719,5721,3,822,411,0,5720,5719,1,
  	0,0,0,5720,5721,1,0,0,0,5721,5723,1,0,0,0,5722,5724,3,1294,647,0,5723,
  	5722,1,0,0,0,5723,5724,1,0,0,0,5724,735,1,0,0,0,5725,5726,4,368,146,0,
  	5726,5727,5,536,0,0,5727,5728,5,824,0,0,5728,5729,3,2,1,0,5729,737,1,
  	0,0,0,5730,5731,5,536,0,0,5731,5732,5,438,0,0,5732,739,1,0,0,0,5733,5734,
  	5,536,0,0,5734,5735,5,202,0,0,5735,5736,3,818,409,0,5736,5737,5,321,0,
  	0,5737,741,1,0,0,0,5738,5739,5,536,0,0,5739,5740,5,202,0,0,5740,5741,
  	3,818,409,0,5741,5742,5,385,0,0,5742,743,1,0,0,0,5743,5744,5,536,0,0,
  	5744,5745,5,202,0,0,5745,5746,3,818,409,0,5746,5747,5,573,0,0,5747,745,
  	1,0,0,0,5748,5750,5,536,0,0,5749,5751,3,816,408,0,5750,5749,1,0,0,0,5750,
  	5751,1,0,0,0,5751,5752,1,0,0,0,5752,5753,5,115,0,0,5753,5754,7,91,0,0,
  	5754,5756,3,1366,683,0,5755,5757,3,822,411,0,5756,5755,1,0,0,0,5756,5757,
  	1,0,0,0,5757,5759,1,0,0,0,5758,5760,3,1294,647,0,5759,5758,1,0,0,0,5759,
  	5760,1,0,0,0,5760,747,1,0,0,0,5761,5762,5,536,0,0,5762,5763,7,44,0,0,
  	5763,5764,5,321,0,0,5764,749,1,0,0,0,5765,5766,5,536,0,0,5766,5767,5,
  	77,0,0,5767,5768,5,825,0,0,5768,5769,5,573,0,0,5769,751,1,0,0,0,5770,
  	5774,5,536,0,0,5771,5772,5,541,0,0,5772,5775,5,261,0,0,5773,5775,5,780,
  	0,0,5774,5771,1,0,0,0,5774,5773,1,0,0,0,5775,753,1,0,0,0,5776,5777,5,
  	536,0,0,5777,5778,5,78,0,0,5778,5781,5,208,0,0,5779,5780,5,286,0,0,5780,
  	5782,3,1424,712,0,5781,5779,1,0,0,0,5781,5782,1,0,0,0,5782,5785,1,0,0,
  	0,5783,5784,5,239,0,0,5784,5786,3,1406,703,0,5785,5783,1,0,0,0,5785,5786,
  	1,0,0,0,5786,5788,1,0,0,0,5787,5789,3,314,157,0,5788,5787,1,0,0,0,5788,
  	5789,1,0,0,0,5789,5791,1,0,0,0,5790,5792,3,1014,507,0,5791,5790,1,0,0,
  	0,5791,5792,1,0,0,0,5792,755,1,0,0,0,5793,5794,5,536,0,0,5794,5795,5,
  	476,0,0,5795,5798,5,208,0,0,5796,5797,5,286,0,0,5797,5799,3,1424,712,
  	0,5798,5796,1,0,0,0,5798,5799,1,0,0,0,5799,5802,1,0,0,0,5800,5801,5,239,
  	0,0,5801,5803,3,1406,703,0,5802,5800,1,0,0,0,5802,5803,1,0,0,0,5803,5805,
  	1,0,0,0,5804,5806,3,314,157,0,5805,5804,1,0,0,0,5805,5806,1,0,0,0,5806,
  	5808,1,0,0,0,5807,5809,3,1014,507,0,5808,5807,1,0,0,0,5808,5809,1,0,0,
  	0,5809,757,1,0,0,0,5810,5813,5,536,0,0,5811,5812,4,379,147,0,5812,5814,
  	5,219,0,0,5813,5811,1,0,0,0,5813,5814,1,0,0,0,5814,5815,1,0,0,0,5815,
  	5816,7,92,0,0,5816,5817,3,820,410,0,5817,5819,3,1366,683,0,5818,5820,
  	3,822,411,0,5819,5818,1,0,0,0,5819,5820,1,0,0,0,5820,5822,1,0,0,0,5821,
  	5823,3,388,194,0,5822,5821,1,0,0,0,5822,5823,1,0,0,0,5823,759,1,0,0,0,
  	5824,5826,5,536,0,0,5825,5827,5,579,0,0,5826,5825,1,0,0,0,5826,5827,1,
  	0,0,0,5827,5828,1,0,0,0,5828,5829,5,201,0,0,5829,761,1,0,0,0,5830,5831,
  	5,536,0,0,5831,5832,5,138,0,0,5832,5833,5,32,0,0,5833,5834,5,16,0,0,5834,
  	5835,5,33,0,0,5835,5836,5,664,0,0,5836,763,1,0,0,0,5837,5838,5,536,0,
  	0,5838,5839,5,138,0,0,5839,5840,5,32,0,0,5840,5841,5,16,0,0,5841,5842,
  	5,33,0,0,5842,5843,5,205,0,0,5843,765,1,0,0,0,5844,5845,5,536,0,0,5845,
  	5847,5,664,0,0,5846,5848,3,314,157,0,5847,5846,1,0,0,0,5847,5848,1,0,
  	0,0,5848,767,1,0,0,0,5849,5850,5,536,0,0,5850,5852,5,205,0,0,5851,5853,
  	3,314,157,0,5852,5851,1,0,0,0,5852,5853,1,0,0,0,5853,769,1,0,0,0,5854,
  	5855,5,536,0,0,5855,5856,5,456,0,0,5856,771,1,0,0,0,5857,5858,5,536,0,
  	0,5858,5860,5,455,0,0,5859,5861,3,824,412,0,5860,5859,1,0,0,0,5860,5861,
  	1,0,0,0,5861,5865,1,0,0,0,5862,5863,5,236,0,0,5863,5864,5,460,0,0,5864,
  	5866,5,3,0,0,5865,5862,1,0,0,0,5865,5866,1,0,0,0,5866,5868,1,0,0,0,5867,
  	5869,3,314,157,0,5868,5867,1,0,0,0,5868,5869,1,0,0,0,5869,773,1,0,0,0,
  	5870,5872,5,536,0,0,5871,5873,3,1462,731,0,5872,5871,1,0,0,0,5872,5873,
  	1,0,0,0,5873,5874,1,0,0,0,5874,5876,5,573,0,0,5875,5877,3,1294,647,0,
  	5876,5875,1,0,0,0,5876,5877,1,0,0,0,5877,775,1,0,0,0,5878,5880,5,536,
  	0,0,5879,5881,5,240,0,0,5880,5879,1,0,0,0,5880,5881,1,0,0,0,5881,5882,
  	1,0,0,0,5882,5883,5,454,0,0,5883,777,1,0,0,0,5884,5886,5,536,0,0,5885,
  	5887,3,1462,731,0,5886,5885,1,0,0,0,5886,5887,1,0,0,0,5887,5888,1,0,0,
  	0,5888,5890,5,656,0,0,5889,5891,3,1294,647,0,5890,5889,1,0,0,0,5890,5891,
  	1,0,0,0,5891,779,1,0,0,0,5892,5893,5,536,0,0,5893,5895,3,990,495,0,5894,
  	5896,3,1294,647,0,5895,5894,1,0,0,0,5895,5896,1,0,0,0,5896,781,1,0,0,
  	0,5897,5898,5,536,0,0,5898,5900,5,114,0,0,5899,5901,3,1294,647,0,5900,
  	5899,1,0,0,0,5900,5901,1,0,0,0,5901,783,1,0,0,0,5902,5903,5,536,0,0,5903,
  	5904,5,451,0,0,5904,785,1,0,0,0,5905,5906,5,536,0,0,5906,5913,5,252,0,
  	0,5907,5908,5,236,0,0,5908,5911,3,1290,645,0,5909,5910,5,647,0,0,5910,
  	5912,3,1254,627,0,5911,5909,1,0,0,0,5911,5912,1,0,0,0,5912,5914,1,0,0,
  	0,5913,5907,1,0,0,0,5913,5914,1,0,0,0,5914,787,1,0,0,0,5915,5916,5,536,
  	0,0,5916,5917,5,140,0,0,5917,5919,5,151,0,0,5918,5920,3,1224,612,0,5919,
  	5918,1,0,0,0,5919,5920,1,0,0,0,5920,5921,1,0,0,0,5921,5922,3,1322,661,
  	0,5922,789,1,0,0,0,5923,5924,5,536,0,0,5924,5925,5,140,0,0,5925,5926,
  	5,600,0,0,5926,5927,3,1366,683,0,5927,791,1,0,0,0,5928,5929,5,536,0,0,
  	5929,5930,5,140,0,0,5930,5931,5,661,0,0,5931,5932,3,1338,669,0,5932,793,
  	1,0,0,0,5933,5934,5,536,0,0,5934,5935,5,348,0,0,5935,5936,5,573,0,0,5936,
  	795,1,0,0,0,5937,5938,5,536,0,0,5938,5939,3,602,301,0,5939,5942,5,573,
  	0,0,5940,5941,4,398,148,0,5941,5943,5,400,0,0,5942,5940,1,0,0,0,5942,
  	5943,1,0,0,0,5943,5945,1,0,0,0,5944,5946,3,1014,507,0,5945,5944,1,0,0,
  	0,5945,5946,1,0,0,0,5946,797,1,0,0,0,5947,5948,5,536,0,0,5948,5949,5,
  	140,0,0,5949,5950,5,452,0,0,5950,5951,3,1326,663,0,5951,799,1,0,0,0,5952,
  	5953,5,536,0,0,5953,5954,5,140,0,0,5954,5955,5,242,0,0,5955,5956,3,1330,
  	665,0,5956,801,1,0,0,0,5957,5958,5,536,0,0,5958,5959,5,140,0,0,5959,5960,
  	5,620,0,0,5960,5961,3,1334,667,0,5961,803,1,0,0,0,5962,5963,5,536,0,0,
  	5963,5964,5,140,0,0,5964,5965,5,452,0,0,5965,5967,5,573,0,0,5966,5968,
  	3,1294,647,0,5967,5966,1,0,0,0,5967,5968,1,0,0,0,5968,805,1,0,0,0,5969,
  	5970,5,536,0,0,5970,5971,5,140,0,0,5971,5972,5,242,0,0,5972,5974,5,573,
  	0,0,5973,5975,3,1294,647,0,5974,5973,1,0,0,0,5974,5975,1,0,0,0,5975,807,
  	1,0,0,0,5976,5977,5,536,0,0,5977,5978,5,140,0,0,5978,5979,5,452,0,0,5979,
  	5980,5,112,0,0,5980,5981,3,1326,663,0,5981,809,1,0,0,0,5982,5983,5,536,
  	0,0,5983,5984,5,140,0,0,5984,5985,5,242,0,0,5985,5986,5,112,0,0,5986,
  	5987,3,1330,665,0,5987,811,1,0,0,0,5988,5989,5,536,0,0,5989,5990,5,140,
  	0,0,5990,5991,5,209,0,0,5991,5992,3,1350,675,0,5992,813,1,0,0,0,5993,
  	5994,5,536,0,0,5994,5995,5,140,0,0,5995,5996,5,644,0,0,5996,5997,3,1290,
  	645,0,5997,815,1,0,0,0,5998,6005,5,240,0,0,5999,6000,4,408,149,0,6000,
  	6002,5,219,0,0,6001,6003,5,240,0,0,6002,6001,1,0,0,0,6002,6003,1,0,0,
  	0,6003,6005,1,0,0,0,6004,5998,1,0,0,0,6004,5999,1,0,0,0,6005,817,1,0,
  	0,0,6006,6009,3,1358,679,0,6007,6009,5,56,0,0,6008,6006,1,0,0,0,6008,
  	6007,1,0,0,0,6009,819,1,0,0,0,6010,6011,7,91,0,0,6011,821,1,0,0,0,6012,
  	6013,3,820,410,0,6013,6014,3,1390,695,0,6014,823,1,0,0,0,6015,6020,3,
  	826,413,0,6016,6017,5,29,0,0,6017,6019,3,826,413,0,6018,6016,1,0,0,0,
  	6019,6022,1,0,0,0,6020,6018,1,0,0,0,6020,6021,1,0,0,0,6021,825,1,0,0,
  	0,6022,6020,1,0,0,0,6023,6024,5,85,0,0,6024,6031,5,289,0,0,6025,6026,
  	5,135,0,0,6026,6031,5,594,0,0,6027,6028,5,430,0,0,6028,6031,5,224,0,0,
  	6029,6031,7,93,0,0,6030,6023,1,0,0,0,6030,6025,1,0,0,0,6030,6027,1,0,
  	0,0,6030,6029,1,0,0,0,6031,827,1,0,0,0,6032,6033,5,78,0,0,6033,6070,3,
  	1428,714,0,6034,6035,5,92,0,0,6035,6036,5,272,0,0,6036,6037,3,830,415,
  	0,6037,6040,5,286,0,0,6038,6041,3,1390,695,0,6039,6041,5,168,0,0,6040,
  	6038,1,0,0,0,6040,6039,1,0,0,0,6041,6070,1,0,0,0,6042,6044,5,232,0,0,
  	6043,6045,3,1298,649,0,6044,6043,1,0,0,0,6044,6045,1,0,0,0,6045,6055,
  	1,0,0,0,6046,6056,3,848,424,0,6047,6052,3,844,422,0,6048,6049,5,29,0,
  	0,6049,6051,3,844,422,0,6050,6048,1,0,0,0,6051,6054,1,0,0,0,6052,6050,
  	1,0,0,0,6052,6053,1,0,0,0,6053,6056,1,0,0,0,6054,6052,1,0,0,0,6055,6046,
  	1,0,0,0,6055,6047,1,0,0,0,6056,6070,1,0,0,0,6057,6059,5,300,0,0,6058,
  	6060,7,94,0,0,6059,6058,1,0,0,0,6059,6060,1,0,0,0,6060,6061,1,0,0,0,6061,
  	6070,3,898,449,0,6062,6063,5,315,0,0,6063,6064,5,272,0,0,6064,6065,5,
  	283,0,0,6065,6066,5,92,0,0,6066,6070,3,852,426,0,6067,6068,4,414,150,
  	0,6068,6070,5,537,0,0,6069,6032,1,0,0,0,6069,6034,1,0,0,0,6069,6042,1,
  	0,0,0,6069,6057,1,0,0,0,6069,6062,1,0,0,0,6069,6067,1,0,0,0,6070,829,
  	1,0,0,0,6071,6074,3,832,416,0,6072,6074,3,836,418,0,6073,6071,1,0,0,0,
  	6073,6072,1,0,0,0,6074,831,1,0,0,0,6075,6080,3,834,417,0,6076,6077,5,
  	29,0,0,6077,6079,3,834,417,0,6078,6076,1,0,0,0,6079,6082,1,0,0,0,6080,
  	6078,1,0,0,0,6080,6081,1,0,0,0,6081,833,1,0,0,0,6082,6080,1,0,0,0,6083,
  	6085,3,1366,683,0,6084,6086,3,838,419,0,6085,6084,1,0,0,0,6085,6086,1,
  	0,0,0,6086,835,1,0,0,0,6087,6088,3,1366,683,0,6088,6089,5,435,0,0,6089,
  	6090,5,32,0,0,6090,6091,3,54,27,0,6091,6093,5,33,0,0,6092,6094,3,838,
  	419,0,6093,6092,1,0,0,0,6093,6094,1,0,0,0,6094,837,1,0,0,0,6095,6096,
  	3,438,219,0,6096,6098,5,32,0,0,6097,6099,3,842,421,0,6098,6097,1,0,0,
  	0,6098,6099,1,0,0,0,6099,6100,1,0,0,0,6100,6101,5,33,0,0,6101,839,1,0,
  	0,0,6102,6105,3,1390,695,0,6103,6105,5,450,0,0,6104,6102,1,0,0,0,6104,
  	6103,1,0,0,0,6105,841,1,0,0,0,6106,6111,3,840,420,0,6107,6108,5,29,0,
  	0,6108,6110,3,840,420,0,6109,6107,1,0,0,0,6110,6113,1,0,0,0,6111,6109,
  	1,0,0,0,6111,6112,1,0,0,0,6112,843,1,0,0,0,6113,6111,1,0,0,0,6114,6130,
  	7,95,0,0,6115,6117,3,846,423,0,6116,6115,1,0,0,0,6116,6117,1,0,0,0,6117,
  	6118,1,0,0,0,6118,6130,5,321,0,0,6119,6120,5,475,0,0,6120,6122,5,321,
  	0,0,6121,6123,3,1014,507,0,6122,6121,1,0,0,0,6122,6123,1,0,0,0,6123,6130,
  	1,0,0,0,6124,6125,4,422,151,0,6125,6126,5,460,0,0,6126,6130,5,92,0,0,
  	6127,6128,4,422,152,0,6128,6130,5,419,0,0,6129,6114,1,0,0,0,6129,6116,
  	1,0,0,0,6129,6119,1,0,0,0,6129,6124,1,0,0,0,6129,6127,1,0,0,0,6130,845,
  	1,0,0,0,6131,6132,7,96,0,0,6132,847,1,0,0,0,6133,6141,7,17,0,0,6134,6135,
  	5,670,0,0,6135,6136,5,465,0,0,6136,6142,5,319,0,0,6137,6139,3,1392,696,
  	0,6138,6140,3,850,425,0,6139,6138,1,0,0,0,6139,6140,1,0,0,0,6140,6142,
  	1,0,0,0,6141,6134,1,0,0,0,6141,6137,1,0,0,0,6141,6142,1,0,0,0,6142,849,
  	1,0,0,0,6143,6144,5,236,0,0,6144,6149,5,218,0,0,6145,6146,5,670,0,0,6146,
  	6147,5,465,0,0,6147,6149,5,319,0,0,6148,6143,1,0,0,0,6148,6145,1,0,0,
  	0,6149,851,1,0,0,0,6150,6151,3,1366,683,0,6151,6153,3,858,429,0,6152,
  	6154,3,838,419,0,6153,6152,1,0,0,0,6153,6154,1,0,0,0,6154,6157,1,0,0,
  	0,6155,6156,5,268,0,0,6156,6158,5,304,0,0,6157,6155,1,0,0,0,6157,6158,
  	1,0,0,0,6158,6161,1,0,0,0,6159,6161,3,854,427,0,6160,6150,1,0,0,0,6160,
  	6159,1,0,0,0,6161,853,1,0,0,0,6162,6167,3,856,428,0,6163,6164,5,29,0,
  	0,6164,6166,3,856,428,0,6165,6163,1,0,0,0,6166,6169,1,0,0,0,6167,6165,
  	1,0,0,0,6167,6168,1,0,0,0,6168,855,1,0,0,0,6169,6167,1,0,0,0,6170,6172,
  	3,1366,683,0,6171,6173,3,838,419,0,6172,6171,1,0,0,0,6172,6173,1,0,0,
  	0,6173,6176,1,0,0,0,6174,6175,5,268,0,0,6175,6177,5,304,0,0,6176,6174,
  	1,0,0,0,6176,6177,1,0,0,0,6177,857,1,0,0,0,6178,6179,5,435,0,0,6179,6180,
  	5,32,0,0,6180,6181,3,54,27,0,6181,6182,5,33,0,0,6182,859,1,0,0,0,6183,
  	6188,3,862,431,0,6184,6188,3,872,436,0,6185,6188,3,874,437,0,6186,6188,
  	3,878,439,0,6187,6183,1,0,0,0,6187,6184,1,0,0,0,6187,6185,1,0,0,0,6187,
  	6186,1,0,0,0,6188,861,1,0,0,0,6189,6190,5,140,0,0,6190,6191,5,734,0,0,
  	6191,6192,5,253,0,0,6192,6193,3,1390,695,0,6193,6195,5,625,0,0,6194,6196,
  	3,1460,730,0,6195,6194,1,0,0,0,6195,6196,1,0,0,0,6196,6197,1,0,0,0,6197,
  	6199,7,97,0,0,6198,6200,3,864,432,0,6199,6198,1,0,0,0,6199,6200,1,0,0,
  	0,6200,6202,1,0,0,0,6201,6203,3,868,434,0,6202,6201,1,0,0,0,6202,6203,
  	1,0,0,0,6203,6205,1,0,0,0,6204,6206,3,870,435,0,6205,6204,1,0,0,0,6205,
  	6206,1,0,0,0,6206,863,1,0,0,0,6207,6209,5,736,0,0,6208,6210,3,1460,730,
  	0,6209,6208,1,0,0,0,6209,6210,1,0,0,0,6210,6211,1,0,0,0,6211,6218,3,866,
  	433,0,6212,6214,5,29,0,0,6213,6212,1,0,0,0,6213,6214,1,0,0,0,6214,6215,
  	1,0,0,0,6215,6217,3,866,433,0,6216,6213,1,0,0,0,6217,6220,1,0,0,0,6218,
  	6216,1,0,0,0,6218,6219,1,0,0,0,6219,865,1,0,0,0,6220,6218,1,0,0,0,6221,
  	6224,5,3,0,0,6222,6223,5,15,0,0,6223,6225,5,3,0,0,6224,6222,1,0,0,0,6224,
  	6225,1,0,0,0,6225,867,1,0,0,0,6226,6228,5,733,0,0,6227,6229,3,1460,730,
  	0,6228,6227,1,0,0,0,6228,6229,1,0,0,0,6229,6230,1,0,0,0,6230,6231,5,3,
  	0,0,6231,869,1,0,0,0,6232,6233,7,7,0,0,6233,871,1,0,0,0,6234,6235,5,57,
  	0,0,6235,6236,5,734,0,0,6236,6237,5,253,0,0,6237,6239,3,1384,692,0,6238,
  	6240,3,864,432,0,6239,6238,1,0,0,0,6239,6240,1,0,0,0,6240,6242,1,0,0,
  	0,6241,6243,3,868,434,0,6242,6241,1,0,0,0,6242,6243,1,0,0,0,6243,6245,
  	1,0,0,0,6244,6246,3,870,435,0,6245,6244,1,0,0,0,6245,6246,1,0,0,0,6246,
  	6248,1,0,0,0,6247,6249,5,234,0,0,6248,6247,1,0,0,0,6248,6249,1,0,0,0,
  	6249,873,1,0,0,0,6250,6251,5,533,0,0,6251,6252,5,734,0,0,6252,6253,5,
  	253,0,0,6253,6256,3,1390,695,0,6254,6255,5,236,0,0,6255,6257,3,876,438,
  	0,6256,6254,1,0,0,0,6256,6257,1,0,0,0,6257,875,1,0,0,0,6258,6265,3,1404,
  	702,0,6259,6261,5,29,0,0,6260,6259,1,0,0,0,6260,6261,1,0,0,0,6261,6262,
  	1,0,0,0,6262,6264,3,1404,702,0,6263,6260,1,0,0,0,6264,6267,1,0,0,0,6265,
  	6263,1,0,0,0,6265,6266,1,0,0,0,6266,877,1,0,0,0,6267,6265,1,0,0,0,6268,
  	6269,5,187,0,0,6269,6270,5,734,0,0,6270,6271,5,253,0,0,6271,6273,3,1384,
  	692,0,6272,6274,5,234,0,0,6273,6272,1,0,0,0,6273,6274,1,0,0,0,6274,879,
  	1,0,0,0,6275,6282,3,882,441,0,6276,6282,3,884,442,0,6277,6282,3,892,446,
  	0,6278,6282,3,894,447,0,6279,6280,4,440,153,0,6280,6282,3,896,448,0,6281,
  	6275,1,0,0,0,6281,6276,1,0,0,0,6281,6277,1,0,0,0,6281,6278,1,0,0,0,6281,
  	6279,1,0,0,0,6282,881,1,0,0,0,6283,6284,7,98,0,0,6284,6287,3,1366,683,
  	0,6285,6288,3,1424,712,0,6286,6288,3,1310,655,0,6287,6285,1,0,0,0,6287,
  	6286,1,0,0,0,6287,6288,1,0,0,0,6288,883,1,0,0,0,6289,6291,7,98,0,0,6290,
  	6292,3,886,443,0,6291,6290,1,0,0,0,6291,6292,1,0,0,0,6292,6297,1,0,0,
  	0,6293,6294,4,442,154,0,6294,6295,5,236,0,0,6295,6296,5,151,0,0,6296,
  	6298,3,1450,725,0,6297,6293,1,0,0,0,6297,6298,1,0,0,0,6298,6299,1,0,0,
  	0,6299,6300,3,888,444,0,6300,885,1,0,0,0,6301,6302,5,237,0,0,6302,6303,
  	5,6,0,0,6303,6306,3,1450,725,0,6304,6305,4,443,155,0,6305,6307,3,890,
  	445,0,6306,6304,1,0,0,0,6306,6307,1,0,0,0,6307,6320,1,0,0,0,6308,6309,
  	4,443,156,0,6309,6320,5,219,0,0,6310,6311,4,443,157,0,6311,6320,5,434,
  	0,0,6312,6313,4,443,158,0,6313,6320,5,60,0,0,6314,6315,4,443,159,0,6315,
  	6316,5,60,0,0,6316,6317,5,237,0,0,6317,6318,5,6,0,0,6318,6320,3,1450,
  	725,0,6319,6301,1,0,0,0,6319,6308,1,0,0,0,6319,6310,1,0,0,0,6319,6312,
  	1,0,0,0,6319,6314,1,0,0,0,6320,887,1,0,0,0,6321,6330,3,296,148,0,6322,
  	6330,3,234,117,0,6323,6330,3,246,123,0,6324,6330,3,294,147,0,6325,6330,
  	3,448,224,0,6326,6327,5,236,0,0,6327,6328,5,128,0,0,6328,6330,3,1404,
  	702,0,6329,6321,1,0,0,0,6329,6322,1,0,0,0,6329,6323,1,0,0,0,6329,6324,
  	1,0,0,0,6329,6325,1,0,0,0,6329,6326,1,0,0,0,6330,889,1,0,0,0,6331,6332,
  	5,283,0,0,6332,6333,5,39,0,0,6333,6334,3,1450,725,0,6334,891,1,0,0,0,
  	6335,6336,5,258,0,0,6336,6337,3,1450,725,0,6337,893,1,0,0,0,6338,6339,
  	5,646,0,0,6339,6340,3,1322,661,0,6340,895,1,0,0,0,6341,6342,5,739,0,0,
  	6342,897,1,0,0,0,6343,6344,6,449,-1,0,6344,6350,3,900,450,0,6345,6347,
  	5,291,0,0,6346,6348,3,992,496,0,6347,6346,1,0,0,0,6347,6348,1,0,0,0,6348,
  	6349,1,0,0,0,6349,6351,7,99,0,0,6350,6345,1,0,0,0,6350,6351,1,0,0,0,6351,
  	6355,1,0,0,0,6352,6353,5,401,0,0,6353,6355,3,898,449,4,6354,6343,1,0,
  	0,0,6354,6352,1,0,0,0,6355,6367,1,0,0,0,6356,6357,10,3,0,0,6357,6358,
  	7,100,0,0,6358,6366,3,898,449,4,6359,6360,10,2,0,0,6360,6361,5,679,0,
  	0,6361,6366,3,898,449,3,6362,6363,10,1,0,0,6363,6364,7,101,0,0,6364,6366,
  	3,898,449,2,6365,6356,1,0,0,0,6365,6359,1,0,0,0,6365,6362,1,0,0,0,6366,
  	6369,1,0,0,0,6367,6365,1,0,0,0,6367,6368,1,0,0,0,6368,899,1,0,0,0,6369,
  	6367,1,0,0,0,6370,6371,6,450,-1,0,6371,6372,3,904,452,0,6372,6390,1,0,
  	0,0,6373,6374,10,3,0,0,6374,6376,5,291,0,0,6375,6377,3,992,496,0,6376,
  	6375,1,0,0,0,6376,6377,1,0,0,0,6377,6378,1,0,0,0,6378,6389,5,406,0,0,
  	6379,6380,10,2,0,0,6380,6381,3,902,451,0,6381,6382,3,904,452,0,6382,6389,
  	1,0,0,0,6383,6384,10,1,0,0,6384,6385,3,902,451,0,6385,6386,7,102,0,0,
  	6386,6387,3,310,155,0,6387,6389,1,0,0,0,6388,6373,1,0,0,0,6388,6379,1,
  	0,0,0,6388,6383,1,0,0,0,6389,6392,1,0,0,0,6390,6388,1,0,0,0,6390,6391,
  	1,0,0,0,6391,901,1,0,0,0,6392,6390,1,0,0,0,6393,6394,7,103,0,0,6394,903,
  	1,0,0,0,6395,6409,3,908,454,0,6396,6398,3,992,496,0,6397,6396,1,0,0,0,
  	6397,6398,1,0,0,0,6398,6399,1,0,0,0,6399,6410,3,906,453,0,6400,6401,4,
  	452,166,0,6401,6403,5,758,0,0,6402,6404,5,693,0,0,6403,6402,1,0,0,0,6403,
  	6404,1,0,0,0,6404,6405,1,0,0,0,6405,6410,3,1004,502,0,6406,6407,5,547,
  	0,0,6407,6408,5,309,0,0,6408,6410,3,908,454,0,6409,6397,1,0,0,0,6409,
  	6400,1,0,0,0,6409,6406,1,0,0,0,6409,6410,1,0,0,0,6410,905,1,0,0,0,6411,
  	6417,5,286,0,0,6412,6418,3,310,155,0,6413,6414,5,32,0,0,6414,6415,3,988,
  	494,0,6415,6416,5,33,0,0,6416,6418,1,0,0,0,6417,6412,1,0,0,0,6417,6413,
  	1,0,0,0,6418,6433,1,0,0,0,6419,6420,5,75,0,0,6420,6421,3,908,454,0,6421,
  	6422,5,61,0,0,6422,6423,3,904,452,0,6423,6433,1,0,0,0,6424,6425,5,309,
  	0,0,6425,6428,3,910,455,0,6426,6427,5,207,0,0,6427,6429,3,910,455,0,6428,
  	6426,1,0,0,0,6428,6429,1,0,0,0,6429,6433,1,0,0,0,6430,6431,5,474,0,0,
  	6431,6433,3,908,454,0,6432,6411,1,0,0,0,6432,6419,1,0,0,0,6432,6424,1,
  	0,0,0,6432,6430,1,0,0,0,6433,907,1,0,0,0,6434,6435,6,454,-1,0,6435,6436,
  	3,910,455,0,6436,6463,1,0,0,0,6437,6438,10,7,0,0,6438,6439,5,25,0,0,6439,
  	6462,3,908,454,8,6440,6441,10,6,0,0,6441,6442,7,104,0,0,6442,6462,3,908,
  	454,7,6443,6444,10,5,0,0,6444,6445,7,105,0,0,6445,6462,3,908,454,6,6446,
  	6447,10,3,0,0,6447,6448,7,106,0,0,6448,6462,3,908,454,4,6449,6450,10,
  	2,0,0,6450,6451,5,24,0,0,6451,6462,3,908,454,3,6452,6453,10,1,0,0,6453,
  	6454,5,27,0,0,6454,6462,3,908,454,2,6455,6456,10,4,0,0,6456,6457,7,105,
  	0,0,6457,6458,5,282,0,0,6458,6459,3,898,449,0,6459,6460,3,996,498,0,6460,
  	6462,1,0,0,0,6461,6437,1,0,0,0,6461,6440,1,0,0,0,6461,6443,1,0,0,0,6461,
  	6446,1,0,0,0,6461,6449,1,0,0,0,6461,6452,1,0,0,0,6461,6455,1,0,0,0,6462,
  	6465,1,0,0,0,6463,6461,1,0,0,0,6463,6464,1,0,0,0,6464,909,1,0,0,0,6465,
  	6463,1,0,0,0,6466,6467,6,455,-1,0,6467,6469,3,1310,655,0,6468,6470,3,
  	914,457,0,6469,6468,1,0,0,0,6469,6470,1,0,0,0,6470,6592,1,0,0,0,6471,
  	6592,3,942,471,0,6472,6592,3,962,481,0,6473,6592,3,1416,708,0,6474,6592,
  	5,42,0,0,6475,6592,3,974,487,0,6476,6592,3,972,486,0,6477,6592,3,916,
  	458,0,6478,6479,4,455,174,0,6479,6592,3,918,459,0,6480,6481,4,455,175,
  	0,6481,6592,3,920,460,0,6482,6483,7,107,0,0,6483,6592,3,910,455,15,6484,
  	6485,3,994,497,0,6485,6486,3,910,455,14,6486,6592,1,0,0,0,6487,6489,5,
  	516,0,0,6488,6487,1,0,0,0,6488,6489,1,0,0,0,6489,6490,1,0,0,0,6490,6491,
  	5,32,0,0,6491,6492,3,988,494,0,6492,6493,5,33,0,0,6493,6592,1,0,0,0,6494,
  	6496,5,213,0,0,6495,6494,1,0,0,0,6495,6496,1,0,0,0,6496,6497,1,0,0,0,
  	6497,6592,3,310,155,0,6498,6499,5,34,0,0,6499,6500,3,1390,695,0,6500,
  	6501,3,898,449,0,6501,6502,5,35,0,0,6502,6592,1,0,0,0,6503,6504,5,352,
  	0,0,6504,6505,3,936,468,0,6505,6506,5,53,0,0,6506,6507,5,32,0,0,6507,
  	6509,3,908,454,0,6508,6510,3,940,470,0,6509,6508,1,0,0,0,6509,6510,1,
  	0,0,0,6510,6511,1,0,0,0,6511,6512,5,33,0,0,6512,6592,1,0,0,0,6513,6514,
  	5,77,0,0,6514,6592,3,910,455,9,6515,6516,5,97,0,0,6516,6517,5,32,0,0,
  	6517,6520,3,898,449,0,6518,6519,5,67,0,0,6519,6521,5,316,0,0,6520,6518,
  	1,0,0,0,6520,6521,1,0,0,0,6521,6522,1,0,0,0,6522,6523,5,63,0,0,6523,6525,
  	3,986,493,0,6524,6526,3,912,456,0,6525,6524,1,0,0,0,6525,6526,1,0,0,0,
  	6526,6527,1,0,0,0,6527,6528,5,33,0,0,6528,6592,1,0,0,0,6529,6530,4,455,
  	176,0,6530,6531,5,97,0,0,6531,6532,5,32,0,0,6532,6533,3,898,449,0,6533,
  	6534,5,67,0,0,6534,6535,5,612,0,0,6535,6537,5,777,0,0,6536,6538,5,282,
  	0,0,6537,6536,1,0,0,0,6537,6538,1,0,0,0,6538,6539,1,0,0,0,6539,6540,3,
  	1422,711,0,6540,6541,5,63,0,0,6541,6542,5,155,0,0,6542,6543,3,1168,584,
  	0,6543,6544,5,33,0,0,6544,6592,1,0,0,0,6545,6547,5,96,0,0,6546,6548,3,
  	898,449,0,6547,6546,1,0,0,0,6547,6548,1,0,0,0,6548,6552,1,0,0,0,6549,
  	6550,3,980,490,0,6550,6551,3,982,491,0,6551,6553,1,0,0,0,6552,6549,1,
  	0,0,0,6553,6554,1,0,0,0,6554,6552,1,0,0,0,6554,6555,1,0,0,0,6555,6557,
  	1,0,0,0,6556,6558,3,984,492,0,6557,6556,1,0,0,0,6557,6558,1,0,0,0,6558,
  	6559,1,0,0,0,6559,6560,5,198,0,0,6560,6592,1,0,0,0,6561,6562,5,137,0,
  	0,6562,6563,5,32,0,0,6563,6564,3,898,449,0,6564,6565,5,29,0,0,6565,6566,
  	3,986,493,0,6566,6567,5,33,0,0,6567,6592,1,0,0,0,6568,6569,5,137,0,0,
  	6569,6570,5,32,0,0,6570,6571,3,898,449,0,6571,6572,5,647,0,0,6572,6573,
  	3,1172,586,0,6573,6574,5,33,0,0,6574,6592,1,0,0,0,6575,6576,5,168,0,0,
  	6576,6577,5,32,0,0,6577,6578,3,1398,699,0,6578,6579,5,33,0,0,6579,6592,
  	1,0,0,0,6580,6581,5,652,0,0,6581,6582,5,32,0,0,6582,6583,3,1398,699,0,
  	6583,6584,5,33,0,0,6584,6592,1,0,0,0,6585,6586,5,282,0,0,6586,6587,3,
  	898,449,0,6587,6588,3,996,498,0,6588,6589,5,14,0,0,6589,6590,3,898,449,
  	0,6590,6592,1,0,0,0,6591,6466,1,0,0,0,6591,6471,1,0,0,0,6591,6472,1,0,
  	0,0,6591,6473,1,0,0,0,6591,6474,1,0,0,0,6591,6475,1,0,0,0,6591,6476,1,
  	0,0,0,6591,6477,1,0,0,0,6591,6478,1,0,0,0,6591,6480,1,0,0,0,6591,6482,
  	1,0,0,0,6591,6484,1,0,0,0,6591,6488,1,0,0,0,6591,6495,1,0,0,0,6591,6498,
  	1,0,0,0,6591,6503,1,0,0,0,6591,6513,1,0,0,0,6591,6515,1,0,0,0,6591,6529,
  	1,0,0,0,6591,6545,1,0,0,0,6591,6561,1,0,0,0,6591,6568,1,0,0,0,6591,6575,
  	1,0,0,0,6591,6580,1,0,0,0,6591,6585,1,0,0,0,6592,6601,1,0,0,0,6593,6594,
  	10,16,0,0,6594,6595,5,2,0,0,6595,6600,3,910,455,17,6596,6597,10,24,0,
  	0,6597,6598,5,113,0,0,6598,6600,3,1450,725,0,6599,6593,1,0,0,0,6599,6596,
  	1,0,0,0,6600,6603,1,0,0,0,6601,6599,1,0,0,0,6601,6602,1,0,0,0,6602,911,
  	1,0,0,0,6603,6601,1,0,0,0,6604,6605,4,456,179,0,6605,6606,5,756,0,0,6606,
  	913,1,0,0,0,6607,6608,4,457,180,0,6608,6609,5,37,0,0,6609,6614,3,1422,
  	711,0,6610,6611,4,457,181,0,6611,6612,5,38,0,0,6612,6614,3,1422,711,0,
  	6613,6607,1,0,0,0,6613,6610,1,0,0,0,6614,915,1,0,0,0,6615,6616,5,71,0,
  	0,6616,6618,5,32,0,0,6617,6619,5,183,0,0,6618,6617,1,0,0,0,6618,6619,
  	1,0,0,0,6619,6620,1,0,0,0,6620,6621,3,934,467,0,6621,6624,5,33,0,0,6622,
  	6623,4,458,182,0,6623,6625,3,922,461,0,6624,6622,1,0,0,0,6624,6625,1,
  	0,0,0,6625,6710,1,0,0,0,6626,6627,7,108,0,0,6627,6628,5,32,0,0,6628,6629,
  	3,934,467,0,6629,6632,5,33,0,0,6630,6631,4,458,183,0,6631,6633,3,922,
  	461,0,6632,6630,1,0,0,0,6632,6633,1,0,0,0,6633,6710,1,0,0,0,6634,6635,
  	4,458,184,0,6635,6710,3,932,466,0,6636,6637,4,458,185,0,6637,6638,5,809,
  	0,0,6638,6640,5,32,0,0,6639,6641,5,183,0,0,6640,6639,1,0,0,0,6640,6641,
  	1,0,0,0,6641,6642,1,0,0,0,6642,6643,3,934,467,0,6643,6645,5,33,0,0,6644,
  	6646,3,922,461,0,6645,6644,1,0,0,0,6645,6646,1,0,0,0,6646,6710,1,0,0,
  	0,6647,6648,5,138,0,0,6648,6656,5,32,0,0,6649,6651,5,56,0,0,6650,6649,
  	1,0,0,0,6650,6651,1,0,0,0,6651,6652,1,0,0,0,6652,6657,5,16,0,0,6653,6657,
  	3,934,467,0,6654,6655,5,183,0,0,6655,6657,3,988,494,0,6656,6650,1,0,0,
  	0,6656,6653,1,0,0,0,6656,6654,1,0,0,0,6657,6658,1,0,0,0,6658,6661,5,33,
  	0,0,6659,6660,4,458,186,0,6660,6662,3,922,461,0,6661,6659,1,0,0,0,6661,
  	6662,1,0,0,0,6662,6710,1,0,0,0,6663,6664,7,109,0,0,6664,6666,5,32,0,0,
  	6665,6667,5,183,0,0,6666,6665,1,0,0,0,6666,6667,1,0,0,0,6667,6668,1,0,
  	0,0,6668,6669,3,934,467,0,6669,6672,5,33,0,0,6670,6671,4,458,187,0,6671,
  	6673,3,922,461,0,6672,6670,1,0,0,0,6672,6673,1,0,0,0,6673,6710,1,0,0,
  	0,6674,6675,7,110,0,0,6675,6676,5,32,0,0,6676,6677,3,934,467,0,6677,6680,
  	5,33,0,0,6678,6679,4,458,188,0,6679,6681,3,922,461,0,6680,6678,1,0,0,
  	0,6680,6681,1,0,0,0,6681,6710,1,0,0,0,6682,6683,5,590,0,0,6683,6684,5,
  	32,0,0,6684,6685,5,183,0,0,6685,6686,3,934,467,0,6686,6689,5,33,0,0,6687,
  	6688,4,458,189,0,6688,6690,3,922,461,0,6689,6687,1,0,0,0,6689,6690,1,
  	0,0,0,6690,6710,1,0,0,0,6691,6692,5,254,0,0,6692,6694,5,32,0,0,6693,6695,
  	5,183,0,0,6694,6693,1,0,0,0,6694,6695,1,0,0,0,6695,6696,1,0,0,0,6696,
  	6698,3,988,494,0,6697,6699,3,358,179,0,6698,6697,1,0,0,0,6698,6699,1,
  	0,0,0,6699,6702,1,0,0,0,6700,6701,5,526,0,0,6701,6703,3,1424,712,0,6702,
  	6700,1,0,0,0,6702,6703,1,0,0,0,6703,6704,1,0,0,0,6704,6707,5,33,0,0,6705,
  	6706,4,458,190,0,6706,6708,3,922,461,0,6707,6705,1,0,0,0,6707,6708,1,
  	0,0,0,6708,6710,1,0,0,0,6709,6615,1,0,0,0,6709,6626,1,0,0,0,6709,6634,
  	1,0,0,0,6709,6636,1,0,0,0,6709,6647,1,0,0,0,6709,6663,1,0,0,0,6709,6674,
  	1,0,0,0,6709,6682,1,0,0,0,6709,6691,1,0,0,0,6710,917,1,0,0,0,6711,6712,
  	5,697,0,0,6712,6713,5,32,0,0,6713,6714,3,988,494,0,6714,6715,5,33,0,0,
  	6715,919,1,0,0,0,6716,6717,7,111,0,0,6717,6718,3,1458,729,0,6718,6719,
  	3,922,461,0,6719,6766,1,0,0,0,6720,6727,5,713,0,0,6721,6722,5,32,0,0,
  	6722,6723,3,926,463,0,6723,6724,5,33,0,0,6724,6728,1,0,0,0,6725,6726,
  	4,460,191,0,6726,6728,3,1004,502,0,6727,6721,1,0,0,0,6727,6725,1,0,0,
  	0,6728,6729,1,0,0,0,6729,6730,3,922,461,0,6730,6766,1,0,0,0,6731,6732,
  	7,112,0,0,6732,6733,5,32,0,0,6733,6735,3,898,449,0,6734,6736,3,924,462,
  	0,6735,6734,1,0,0,0,6735,6736,1,0,0,0,6736,6737,1,0,0,0,6737,6739,5,33,
  	0,0,6738,6740,3,930,465,0,6739,6738,1,0,0,0,6739,6740,1,0,0,0,6740,6741,
  	1,0,0,0,6741,6742,3,922,461,0,6742,6766,1,0,0,0,6743,6744,7,113,0,0,6744,
  	6746,3,1002,501,0,6745,6747,3,930,465,0,6746,6745,1,0,0,0,6746,6747,1,
  	0,0,0,6747,6748,1,0,0,0,6748,6749,3,922,461,0,6749,6766,1,0,0,0,6750,
  	6751,5,712,0,0,6751,6752,5,32,0,0,6752,6753,3,898,449,0,6753,6754,5,29,
  	0,0,6754,6755,3,910,455,0,6755,6758,5,33,0,0,6756,6757,5,239,0,0,6757,
  	6759,7,114,0,0,6758,6756,1,0,0,0,6758,6759,1,0,0,0,6759,6761,1,0,0,0,
  	6760,6762,3,930,465,0,6761,6760,1,0,0,0,6761,6762,1,0,0,0,6762,6763,1,
  	0,0,0,6763,6764,3,922,461,0,6764,6766,1,0,0,0,6765,6716,1,0,0,0,6765,
  	6720,1,0,0,0,6765,6731,1,0,0,0,6765,6743,1,0,0,0,6765,6750,1,0,0,0,6766,
  	921,1,0,0,0,6767,6770,5,716,0,0,6768,6771,3,1386,693,0,6769,6771,3,332,
  	166,0,6770,6768,1,0,0,0,6770,6769,1,0,0,0,6771,923,1,0,0,0,6772,6777,
  	5,29,0,0,6773,6778,3,1406,703,0,6774,6778,5,42,0,0,6775,6776,4,462,192,
  	0,6776,6778,3,926,463,0,6777,6773,1,0,0,0,6777,6774,1,0,0,0,6777,6775,
  	1,0,0,0,6778,6781,1,0,0,0,6779,6780,5,29,0,0,6780,6782,3,898,449,0,6781,
  	6779,1,0,0,0,6781,6782,1,0,0,0,6782,925,1,0,0,0,6783,6786,3,1440,720,
  	0,6784,6786,3,928,464,0,6785,6783,1,0,0,0,6785,6784,1,0,0,0,6786,927,
  	1,0,0,0,6787,6791,5,42,0,0,6788,6791,3,1390,695,0,6789,6791,3,968,484,
  	0,6790,6787,1,0,0,0,6790,6788,1,0,0,0,6790,6789,1,0,0,0,6791,929,1,0,
  	0,0,6792,6793,7,115,0,0,6793,6794,5,714,0,0,6794,931,1,0,0,0,6795,6796,
  	5,692,0,0,6796,6797,5,32,0,0,6797,6798,3,934,467,0,6798,6800,5,33,0,0,
  	6799,6801,3,922,461,0,6800,6799,1,0,0,0,6800,6801,1,0,0,0,6801,6812,1,
  	0,0,0,6802,6803,5,691,0,0,6803,6804,5,32,0,0,6804,6805,3,934,467,0,6805,
  	6806,5,29,0,0,6806,6807,3,934,467,0,6807,6809,5,33,0,0,6808,6810,3,922,
  	461,0,6809,6808,1,0,0,0,6809,6810,1,0,0,0,6810,6812,1,0,0,0,6811,6795,
  	1,0,0,0,6811,6802,1,0,0,0,6812,933,1,0,0,0,6813,6815,5,56,0,0,6814,6813,
  	1,0,0,0,6814,6815,1,0,0,0,6815,6816,1,0,0,0,6816,6817,3,898,449,0,6817,
  	935,1,0,0,0,6818,6824,3,938,469,0,6819,6820,5,32,0,0,6820,6821,3,938,
  	469,0,6821,6822,5,33,0,0,6822,6824,1,0,0,0,6823,6818,1,0,0,0,6823,6819,
  	1,0,0,0,6824,937,1,0,0,0,6825,6830,3,1398,699,0,6826,6827,5,29,0,0,6827,
  	6829,3,1398,699,0,6828,6826,1,0,0,0,6829,6832,1,0,0,0,6830,6828,1,0,0,
  	0,6830,6831,1,0,0,0,6831,939,1,0,0,0,6832,6830,1,0,0,0,6833,6834,5,286,
  	0,0,6834,6835,5,86,0,0,6835,6849,5,377,0,0,6836,6837,5,286,0,0,6837,6838,
  	5,390,0,0,6838,6839,5,301,0,0,6839,6843,5,377,0,0,6840,6841,5,670,0,0,
  	6841,6842,5,460,0,0,6842,6844,5,215,0,0,6843,6840,1,0,0,0,6843,6844,1,
  	0,0,0,6844,6849,1,0,0,0,6845,6846,5,670,0,0,6846,6847,5,460,0,0,6847,
  	6849,5,215,0,0,6848,6833,1,0,0,0,6848,6836,1,0,0,0,6848,6845,1,0,0,0,
  	6849,941,1,0,0,0,6850,6851,5,104,0,0,6851,6852,5,32,0,0,6852,6855,3,988,
  	494,0,6853,6854,5,647,0,0,6854,6856,3,1172,586,0,6855,6853,1,0,0,0,6855,
  	6856,1,0,0,0,6856,6857,1,0,0,0,6857,6858,5,33,0,0,6858,7139,1,0,0,0,6859,
  	6861,5,147,0,0,6860,6862,3,1458,729,0,6861,6860,1,0,0,0,6861,6862,1,0,
  	0,0,6862,7139,1,0,0,0,6863,6864,5,158,0,0,6864,7139,3,1002,501,0,6865,
  	6866,5,163,0,0,6866,7139,3,1002,501,0,6867,6868,5,265,0,0,6868,7139,3,
  	1002,501,0,6869,6870,5,278,0,0,6870,6871,5,32,0,0,6871,6872,3,898,449,
  	0,6872,6873,5,29,0,0,6873,6874,3,898,449,0,6874,6875,5,29,0,0,6875,6876,
  	3,898,449,0,6876,6877,5,29,0,0,6877,6878,3,898,449,0,6878,6879,5,33,0,
  	0,6879,7139,1,0,0,0,6880,6881,5,282,0,0,6881,6882,5,32,0,0,6882,6885,
  	3,898,449,0,6883,6884,5,29,0,0,6884,6886,3,898,449,0,6885,6883,1,0,0,
  	0,6886,6887,1,0,0,0,6887,6885,1,0,0,0,6887,6888,1,0,0,0,6888,6889,1,0,
  	0,0,6889,6890,5,33,0,0,6890,7139,1,0,0,0,6891,6892,4,471,193,0,6892,6893,
  	5,771,0,0,6893,6894,5,32,0,0,6894,6895,3,910,455,0,6895,6896,5,29,0,0,
  	6896,6898,3,1428,714,0,6897,6899,3,944,472,0,6898,6897,1,0,0,0,6898,6899,
  	1,0,0,0,6899,6900,1,0,0,0,6900,6901,3,418,209,0,6901,6902,5,33,0,0,6902,
  	7139,1,0,0,0,6903,6904,5,306,0,0,6904,6905,5,32,0,0,6905,6906,3,898,449,
  	0,6906,6907,5,29,0,0,6907,6908,3,898,449,0,6908,6909,5,33,0,0,6909,7139,
  	1,0,0,0,6910,6911,5,374,0,0,6911,7139,3,1002,501,0,6912,6913,5,381,0,
  	0,6913,7139,3,1002,501,0,6914,6915,5,508,0,0,6915,6916,5,32,0,0,6916,
  	6917,3,898,449,0,6917,6918,5,29,0,0,6918,6919,3,898,449,0,6919,6920,5,
  	33,0,0,6920,7139,1,0,0,0,6921,6922,5,522,0,0,6922,7139,3,1002,501,0,6923,
  	6924,5,612,0,0,6924,7139,3,1002,501,0,6925,6926,5,609,0,0,6926,6927,5,
  	32,0,0,6927,6930,3,898,449,0,6928,6929,5,29,0,0,6929,6931,3,898,449,0,
  	6930,6928,1,0,0,0,6930,6931,1,0,0,0,6931,6932,1,0,0,0,6932,6933,5,33,
  	0,0,6933,7139,1,0,0,0,6934,7139,3,958,479,0,6935,7139,3,626,313,0,6936,
  	6937,5,652,0,0,6937,7139,3,1002,501,0,6938,6939,5,681,0,0,6939,7139,3,
  	1002,501,0,6940,6941,7,116,0,0,6941,6942,5,32,0,0,6942,6943,3,898,449,
  	0,6943,6949,5,29,0,0,6944,6950,3,898,449,0,6945,6946,5,282,0,0,6946,6947,
  	3,898,449,0,6947,6948,3,996,498,0,6948,6950,1,0,0,0,6949,6944,1,0,0,0,
  	6949,6945,1,0,0,0,6950,6951,1,0,0,0,6951,6952,5,33,0,0,6952,7139,1,0,
  	0,0,6953,6955,5,143,0,0,6954,6956,3,1458,729,0,6955,6954,1,0,0,0,6955,
  	6956,1,0,0,0,6956,7139,1,0,0,0,6957,6959,5,150,0,0,6958,6960,3,948,474,
  	0,6959,6958,1,0,0,0,6959,6960,1,0,0,0,6960,7139,1,0,0,0,6961,6962,7,117,
  	0,0,6962,6963,5,32,0,0,6963,6964,3,898,449,0,6964,6965,5,29,0,0,6965,
  	6966,5,282,0,0,6966,6967,3,898,449,0,6967,6968,3,996,498,0,6968,6969,
  	5,33,0,0,6969,7139,1,0,0,0,6970,6971,5,221,0,0,6971,6972,5,32,0,0,6972,
  	6973,3,996,498,0,6973,6974,5,239,0,0,6974,6975,3,898,449,0,6975,6976,
  	5,33,0,0,6976,7139,1,0,0,0,6977,6978,5,249,0,0,6978,6979,5,32,0,0,6979,
  	6980,3,956,478,0,6980,6981,5,29,0,0,6981,6982,3,898,449,0,6982,6983,5,
  	33,0,0,6983,7139,1,0,0,0,6984,6985,4,471,194,0,6985,6986,5,825,0,0,6986,
  	6987,5,32,0,0,6987,6990,3,898,449,0,6988,6989,5,29,0,0,6989,6991,3,898,
  	449,0,6990,6988,1,0,0,0,6990,6991,1,0,0,0,6991,6992,1,0,0,0,6992,6993,
  	5,33,0,0,6993,7139,1,0,0,0,6994,6996,5,402,0,0,6995,6997,3,948,474,0,
  	6996,6995,1,0,0,0,6996,6997,1,0,0,0,6997,7139,1,0,0,0,6998,6999,5,444,
  	0,0,6999,7000,5,32,0,0,7000,7001,3,908,454,0,7001,7002,5,286,0,0,7002,
  	7003,3,898,449,0,7003,7004,5,33,0,0,7004,7139,1,0,0,0,7005,7139,3,960,
  	480,0,7006,7008,5,595,0,0,7007,7009,3,948,474,0,7008,7007,1,0,0,0,7008,
  	7009,1,0,0,0,7009,7139,1,0,0,0,7010,7011,7,118,0,0,7011,7012,5,32,0,0,
  	7012,7013,3,998,499,0,7013,7014,5,29,0,0,7014,7015,3,898,449,0,7015,7016,
  	5,29,0,0,7016,7017,3,898,449,0,7017,7018,5,33,0,0,7018,7139,1,0,0,0,7019,
  	7021,5,648,0,0,7020,7022,3,1458,729,0,7021,7020,1,0,0,0,7021,7022,1,0,
  	0,0,7022,7139,1,0,0,0,7023,7025,5,650,0,0,7024,7026,3,948,474,0,7025,
  	7024,1,0,0,0,7025,7026,1,0,0,0,7026,7139,1,0,0,0,7027,7029,5,649,0,0,
  	7028,7030,3,948,474,0,7029,7028,1,0,0,0,7029,7030,1,0,0,0,7030,7139,1,
  	0,0,0,7031,7032,5,65,0,0,7032,7139,3,1002,501,0,7033,7034,5,103,0,0,7034,
  	7139,3,1002,501,0,7035,7036,5,111,0,0,7036,7139,3,1000,500,0,7037,7038,
  	5,114,0,0,7038,7139,3,1002,501,0,7039,7040,5,151,0,0,7040,7139,3,1458,
  	729,0,7041,7042,5,267,0,0,7042,7043,5,32,0,0,7043,7044,3,898,449,0,7044,
  	7045,5,29,0,0,7045,7046,3,898,449,0,7046,7047,5,29,0,0,7047,7048,3,898,
  	449,0,7048,7049,5,33,0,0,7049,7139,1,0,0,0,7050,7051,5,237,0,0,7051,7052,
  	5,32,0,0,7052,7053,3,898,449,0,7053,7054,5,29,0,0,7054,7057,3,898,449,
  	0,7055,7056,5,29,0,0,7056,7058,3,898,449,0,7057,7055,1,0,0,0,7057,7058,
  	1,0,0,0,7058,7059,1,0,0,0,7059,7060,5,33,0,0,7060,7139,1,0,0,0,7061,7062,
  	5,369,0,0,7062,7139,3,1002,501,0,7063,7064,5,380,0,0,7064,7065,5,32,0,
  	0,7065,7066,3,898,449,0,7066,7067,5,29,0,0,7067,7068,3,898,449,0,7068,
  	7069,5,33,0,0,7069,7139,1,0,0,0,7070,7071,4,471,195,0,7071,7072,5,436,
  	0,0,7072,7139,3,1002,501,0,7073,7074,5,459,0,0,7074,7139,3,1002,501,0,
  	7075,7076,5,487,0,0,7076,7077,5,32,0,0,7077,7078,3,898,449,0,7078,7079,
  	5,29,0,0,7079,7080,3,898,449,0,7080,7081,5,33,0,0,7081,7139,1,0,0,0,7082,
  	7083,5,488,0,0,7083,7084,5,32,0,0,7084,7085,3,898,449,0,7085,7086,5,29,
  	0,0,7086,7087,3,898,449,0,7087,7088,5,29,0,0,7088,7089,3,898,449,0,7089,
  	7090,5,33,0,0,7090,7139,1,0,0,0,7091,7092,5,506,0,0,7092,7139,3,1002,
  	501,0,7093,7094,5,514,0,0,7094,7139,3,1458,729,0,7095,7096,5,623,0,0,
  	7096,7097,5,32,0,0,7097,7098,3,898,449,0,7098,7099,5,29,0,0,7099,7100,
  	3,898,449,0,7100,7101,5,33,0,0,7101,7139,1,0,0,0,7102,7103,5,665,0,0,
  	7103,7104,5,32,0,0,7104,7107,3,898,449,0,7105,7106,5,29,0,0,7106,7108,
  	3,898,449,0,7107,7105,1,0,0,0,7107,7108,1,0,0,0,7108,7109,1,0,0,0,7109,
  	7110,5,33,0,0,7110,7139,1,0,0,0,7111,7112,5,666,0,0,7112,7113,5,32,0,
  	0,7113,7133,3,898,449,0,7114,7115,5,63,0,0,7115,7116,5,104,0,0,7116,7118,
  	3,1166,583,0,7117,7114,1,0,0,0,7117,7118,1,0,0,0,7118,7121,1,0,0,0,7119,
  	7120,4,471,196,0,7120,7122,3,952,476,0,7121,7119,1,0,0,0,7121,7122,1,
  	0,0,0,7122,7134,1,0,0,0,7123,7124,5,63,0,0,7124,7125,5,77,0,0,7125,7134,
  	3,1166,583,0,7126,7127,5,29,0,0,7127,7128,3,1402,701,0,7128,7129,5,29,
  	0,0,7129,7130,3,1402,701,0,7130,7131,5,29,0,0,7131,7132,3,1402,701,0,
  	7132,7134,1,0,0,0,7133,7117,1,0,0,0,7133,7123,1,0,0,0,7133,7126,1,0,0,
  	0,7134,7135,1,0,0,0,7135,7136,5,33,0,0,7136,7139,1,0,0,0,7137,7139,3,
  	946,473,0,7138,6850,1,0,0,0,7138,6859,1,0,0,0,7138,6863,1,0,0,0,7138,
  	6865,1,0,0,0,7138,6867,1,0,0,0,7138,6869,1,0,0,0,7138,6880,1,0,0,0,7138,
  	6891,1,0,0,0,7138,6903,1,0,0,0,7138,6910,1,0,0,0,7138,6912,1,0,0,0,7138,
  	6914,1,0,0,0,7138,6921,1,0,0,0,7138,6923,1,0,0,0,7138,6925,1,0,0,0,7138,
  	6934,1,0,0,0,7138,6935,1,0,0,0,7138,6936,1,0,0,0,7138,6938,1,0,0,0,7138,
  	6940,1,0,0,0,7138,6953,1,0,0,0,7138,6957,1,0,0,0,7138,6961,1,0,0,0,7138,
  	6970,1,0,0,0,7138,6977,1,0,0,0,7138,6984,1,0,0,0,7138,6994,1,0,0,0,7138,
  	6998,1,0,0,0,7138,7005,1,0,0,0,7138,7006,1,0,0,0,7138,7010,1,0,0,0,7138,
  	7019,1,0,0,0,7138,7023,1,0,0,0,7138,7027,1,0,0,0,7138,7031,1,0,0,0,7138,
  	7033,1,0,0,0,7138,7035,1,0,0,0,7138,7037,1,0,0,0,7138,7039,1,0,0,0,7138,
  	7041,1,0,0,0,7138,7050,1,0,0,0,7138,7061,1,0,0,0,7138,7063,1,0,0,0,7138,
  	7070,1,0,0,0,7138,7073,1,0,0,0,7138,7075,1,0,0,0,7138,7082,1,0,0,0,7138,
  	7091,1,0,0,0,7138,7093,1,0,0,0,7138,7095,1,0,0,0,7138,7102,1,0,0,0,7138,
  	7111,1,0,0,0,7138,7137,1,0,0,0,7139,943,1,0,0,0,7140,7141,5,770,0,0,7141,
  	7142,3,986,493,0,7142,945,1,0,0,0,7143,7144,4,473,197,0,7144,7145,5,134,
  	0,0,7145,7146,5,32,0,0,7146,7147,3,898,449,0,7147,7148,5,29,0,0,7148,
  	7149,3,898,449,0,7149,7150,5,33,0,0,7150,7175,1,0,0,0,7151,7152,5,247,
  	0,0,7152,7154,5,32,0,0,7153,7155,3,988,494,0,7154,7153,1,0,0,0,7154,7155,
  	1,0,0,0,7155,7156,1,0,0,0,7156,7175,5,33,0,0,7157,7158,5,313,0,0,7158,
  	7175,3,1000,500,0,7159,7160,5,382,0,0,7160,7175,3,1000,500,0,7161,7162,
  	5,383,0,0,7162,7175,3,1000,500,0,7163,7164,5,384,0,0,7164,7175,3,1000,
  	500,0,7165,7166,5,441,0,0,7166,7167,5,32,0,0,7167,7168,3,898,449,0,7168,
  	7169,5,29,0,0,7169,7170,3,898,449,0,7170,7171,5,33,0,0,7171,7175,1,0,
  	0,0,7172,7173,5,442,0,0,7173,7175,3,1000,500,0,7174,7143,1,0,0,0,7174,
  	7151,1,0,0,0,7174,7157,1,0,0,0,7174,7159,1,0,0,0,7174,7161,1,0,0,0,7174,
  	7163,1,0,0,0,7174,7165,1,0,0,0,7174,7172,1,0,0,0,7175,947,1,0,0,0,7176,
  	7178,5,32,0,0,7177,7179,3,950,475,0,7178,7177,1,0,0,0,7178,7179,1,0,0,
  	0,7179,7180,1,0,0,0,7180,7181,5,33,0,0,7181,949,1,0,0,0,7182,7183,5,3,
  	0,0,7183,951,1,0,0,0,7184,7197,5,308,0,0,7185,7186,3,1404,702,0,7186,
  	7187,5,15,0,0,7187,7188,3,1404,702,0,7188,7198,1,0,0,0,7189,7194,3,954,
  	477,0,7190,7191,5,29,0,0,7191,7193,3,954,477,0,7192,7190,1,0,0,0,7193,
  	7196,1,0,0,0,7194,7192,1,0,0,0,7194,7195,1,0,0,0,7195,7198,1,0,0,0,7196,
  	7194,1,0,0,0,7197,7185,1,0,0,0,7197,7189,1,0,0,0,7198,953,1,0,0,0,7199,
  	7205,3,1404,702,0,7200,7202,7,35,0,0,7201,7203,5,506,0,0,7202,7201,1,
  	0,0,0,7202,7203,1,0,0,0,7203,7206,1,0,0,0,7204,7206,5,506,0,0,7205,7200,
  	1,0,0,0,7205,7204,1,0,0,0,7205,7206,1,0,0,0,7206,955,1,0,0,0,7207,7208,
  	7,119,0,0,7208,957,1,0,0,0,7209,7210,5,621,0,0,7210,7234,5,32,0,0,7211,
  	7214,3,898,449,0,7212,7213,5,239,0,0,7213,7215,3,898,449,0,7214,7212,
  	1,0,0,0,7214,7215,1,0,0,0,7215,7235,1,0,0,0,7216,7218,5,303,0,0,7217,
  	7219,3,898,449,0,7218,7217,1,0,0,0,7218,7219,1,0,0,0,7219,7220,1,0,0,
  	0,7220,7221,5,239,0,0,7221,7235,3,898,449,0,7222,7224,5,617,0,0,7223,
  	7225,3,898,449,0,7224,7223,1,0,0,0,7224,7225,1,0,0,0,7225,7226,1,0,0,
  	0,7226,7227,5,239,0,0,7227,7235,3,898,449,0,7228,7230,5,88,0,0,7229,7231,
  	3,898,449,0,7230,7229,1,0,0,0,7230,7231,1,0,0,0,7231,7232,1,0,0,0,7232,
  	7233,5,239,0,0,7233,7235,3,898,449,0,7234,7211,1,0,0,0,7234,7216,1,0,
  	0,0,7234,7222,1,0,0,0,7234,7228,1,0,0,0,7235,7236,1,0,0,0,7236,7237,5,
  	33,0,0,7237,959,1,0,0,0,7238,7239,5,589,0,0,7239,7240,5,32,0,0,7240,7253,
  	3,898,449,0,7241,7242,5,29,0,0,7242,7245,3,898,449,0,7243,7244,5,29,0,
  	0,7244,7246,3,898,449,0,7245,7243,1,0,0,0,7245,7246,1,0,0,0,7246,7254,
  	1,0,0,0,7247,7248,5,239,0,0,7248,7251,3,898,449,0,7249,7250,5,236,0,0,
  	7250,7252,3,898,449,0,7251,7249,1,0,0,0,7251,7252,1,0,0,0,7252,7254,1,
  	0,0,0,7253,7241,1,0,0,0,7253,7247,1,0,0,0,7254,7255,1,0,0,0,7255,7256,
  	5,33,0,0,7256,961,1,0,0,0,7257,7258,3,1388,694,0,7258,7260,5,32,0,0,7259,
  	7261,3,964,482,0,7260,7259,1,0,0,0,7260,7261,1,0,0,0,7261,7262,1,0,0,
  	0,7262,7263,5,33,0,0,7263,7272,1,0,0,0,7264,7265,3,1396,698,0,7265,7267,
  	5,32,0,0,7266,7268,3,988,494,0,7267,7266,1,0,0,0,7267,7268,1,0,0,0,7268,
  	7269,1,0,0,0,7269,7270,5,33,0,0,7270,7272,1,0,0,0,7271,7257,1,0,0,0,7271,
  	7264,1,0,0,0,7272,963,1,0,0,0,7273,7278,3,966,483,0,7274,7275,5,29,0,
  	0,7275,7277,3,966,483,0,7276,7274,1,0,0,0,7277,7280,1,0,0,0,7278,7276,
  	1,0,0,0,7278,7279,1,0,0,0,7279,965,1,0,0,0,7280,7278,1,0,0,0,7281,7283,
  	3,898,449,0,7282,7284,3,386,193,0,7283,7282,1,0,0,0,7283,7284,1,0,0,0,
  	7284,967,1,0,0,0,7285,7286,5,39,0,0,7286,7287,3,970,485,0,7287,969,1,
  	0,0,0,7288,7291,3,1450,725,0,7289,7291,5,845,0,0,7290,7288,1,0,0,0,7290,
  	7289,1,0,0,0,7291,971,1,0,0,0,7292,7293,3,968,484,0,7293,7294,5,7,0,0,
  	7294,7295,3,898,449,0,7295,973,1,0,0,0,7296,7304,3,968,484,0,7297,7298,
  	5,39,0,0,7298,7300,5,39,0,0,7299,7301,3,1464,732,0,7300,7299,1,0,0,0,
  	7300,7301,1,0,0,0,7301,7302,1,0,0,0,7302,7304,3,978,489,0,7303,7296,1,
  	0,0,0,7303,7297,1,0,0,0,7304,975,1,0,0,0,7305,7307,3,1390,695,0,7306,
  	7308,3,1400,700,0,7307,7306,1,0,0,0,7307,7308,1,0,0,0,7308,7315,1,0,0,
  	0,7309,7310,4,488,198,0,7310,7312,3,1452,726,0,7311,7313,3,1400,700,0,
  	7312,7311,1,0,0,0,7312,7313,1,0,0,0,7313,7315,1,0,0,0,7314,7305,1,0,0,
  	0,7314,7309,1,0,0,0,7315,7319,1,0,0,0,7316,7317,5,168,0,0,7317,7319,3,
  	1400,700,0,7318,7314,1,0,0,0,7318,7316,1,0,0,0,7319,977,1,0,0,0,7320,
  	7322,3,1450,725,0,7321,7323,3,1400,700,0,7322,7321,1,0,0,0,7322,7323,
  	1,0,0,0,7323,979,1,0,0,0,7324,7325,5,667,0,0,7325,7326,3,898,449,0,7326,
  	981,1,0,0,0,7327,7328,5,608,0,0,7328,7329,3,898,449,0,7329,983,1,0,0,
  	0,7330,7331,5,193,0,0,7331,7332,3,898,449,0,7332,985,1,0,0,0,7333,7335,
  	5,77,0,0,7334,7336,3,1156,578,0,7335,7334,1,0,0,0,7335,7336,1,0,0,0,7336,
  	7383,1,0,0,0,7337,7339,5,104,0,0,7338,7340,3,1156,578,0,7339,7338,1,0,
  	0,0,7339,7340,1,0,0,0,7340,7342,1,0,0,0,7341,7343,3,1160,580,0,7342,7341,
  	1,0,0,0,7342,7343,1,0,0,0,7343,7383,1,0,0,0,7344,7346,3,1152,576,0,7345,
  	7347,3,1156,578,0,7346,7345,1,0,0,0,7346,7347,1,0,0,0,7347,7383,1,0,0,
  	0,7348,7350,5,539,0,0,7349,7351,5,284,0,0,7350,7349,1,0,0,0,7350,7351,
  	1,0,0,0,7351,7383,1,0,0,0,7352,7354,5,638,0,0,7353,7355,5,284,0,0,7354,
  	7353,1,0,0,0,7354,7355,1,0,0,0,7355,7383,1,0,0,0,7356,7383,5,158,0,0,
  	7357,7358,4,493,199,0,7358,7383,5,681,0,0,7359,7361,5,612,0,0,7360,7362,
  	3,1168,584,0,7361,7360,1,0,0,0,7361,7362,1,0,0,0,7362,7383,1,0,0,0,7363,
  	7365,5,155,0,0,7364,7366,3,1168,584,0,7365,7364,1,0,0,0,7365,7366,1,0,
  	0,0,7366,7383,1,0,0,0,7367,7369,5,166,0,0,7368,7370,3,1444,722,0,7369,
  	7368,1,0,0,0,7369,7370,1,0,0,0,7370,7383,1,0,0,0,7371,7372,4,493,200,
  	0,7372,7383,5,296,0,0,7373,7374,4,493,201,0,7374,7383,3,1154,577,0,7375,
  	7376,4,493,202,0,7376,7378,5,231,0,0,7377,7379,3,1446,723,0,7378,7377,
  	1,0,0,0,7378,7379,1,0,0,0,7379,7383,1,0,0,0,7380,7381,4,493,203,0,7381,
  	7383,7,120,0,0,7382,7333,1,0,0,0,7382,7337,1,0,0,0,7382,7344,1,0,0,0,
  	7382,7348,1,0,0,0,7382,7352,1,0,0,0,7382,7356,1,0,0,0,7382,7357,1,0,0,
  	0,7382,7359,1,0,0,0,7382,7363,1,0,0,0,7382,7367,1,0,0,0,7382,7371,1,0,
  	0,0,7382,7373,1,0,0,0,7382,7375,1,0,0,0,7382,7380,1,0,0,0,7383,987,1,
  	0,0,0,7384,7389,3,898,449,0,7385,7386,5,29,0,0,7386,7388,3,898,449,0,
  	7387,7385,1,0,0,0,7388,7391,1,0,0,0,7389,7387,1,0,0,0,7389,7390,1,0,0,
  	0,7390,989,1,0,0,0,7391,7389,1,0,0,0,7392,7393,5,104,0,0,7393,7396,5,
  	533,0,0,7394,7396,5,103,0,0,7395,7392,1,0,0,0,7395,7394,1,0,0,0,7396,
  	991,1,0,0,0,7397,7398,7,121,0,0,7398,993,1,0,0,0,7399,7400,7,122,0,0,
  	7400,995,1,0,0,0,7401,7404,3,998,499,0,7402,7404,7,123,0,0,7403,7401,
  	1,0,0,0,7403,7402,1,0,0,0,7404,997,1,0,0,0,7405,7406,7,124,0,0,7406,999,
  	1,0,0,0,7407,7408,5,32,0,0,7408,7409,3,988,494,0,7409,7410,5,33,0,0,7410,
  	1001,1,0,0,0,7411,7412,5,32,0,0,7412,7413,3,898,449,0,7413,7414,5,33,
  	0,0,7414,1003,1,0,0,0,7415,7416,5,32,0,0,7416,7417,3,910,455,0,7417,7418,
  	5,33,0,0,7418,1005,1,0,0,0,7419,7424,3,1008,504,0,7420,7421,5,29,0,0,
  	7421,7423,3,1008,504,0,7422,7420,1,0,0,0,7423,7426,1,0,0,0,7424,7422,
  	1,0,0,0,7424,7425,1,0,0,0,7425,1007,1,0,0,0,7426,7424,1,0,0,0,7427,7429,
  	3,898,449,0,7428,7430,3,360,180,0,7429,7428,1,0,0,0,7429,7430,1,0,0,0,
  	7430,1009,1,0,0,0,7431,7436,3,1012,506,0,7432,7433,5,29,0,0,7433,7435,
  	3,1012,506,0,7434,7432,1,0,0,0,7435,7438,1,0,0,0,7436,7434,1,0,0,0,7436,
  	7437,1,0,0,0,7437,1011,1,0,0,0,7438,7436,1,0,0,0,7439,7440,3,898,449,
  	0,7440,1013,1,0,0,0,7441,7442,4,507,204,0,7442,7443,5,236,0,0,7443,7444,
  	5,102,0,0,7444,7445,3,1430,715,0,7445,1015,1,0,0,0,7446,7460,3,2,1,0,
  	7447,7460,3,1018,509,0,7448,7460,3,1020,510,0,7449,7460,3,1028,514,0,
  	7450,7460,3,1032,516,0,7451,7460,3,1034,517,0,7452,7460,3,1040,520,0,
  	7453,7460,3,1042,521,0,7454,7460,3,1070,535,0,7455,7460,3,1068,534,0,
  	7456,7460,3,1088,544,0,7457,7460,3,1092,546,0,7458,7460,3,1090,545,0,
  	7459,7446,1,0,0,0,7459,7447,1,0,0,0,7459,7448,1,0,0,0,7459,7449,1,0,0,
  	0,7459,7450,1,0,0,0,7459,7451,1,0,0,0,7459,7452,1,0,0,0,7459,7453,1,0,
  	0,0,7459,7454,1,0,0,0,7459,7455,1,0,0,0,7459,7456,1,0,0,0,7459,7457,1,
  	0,0,0,7459,7458,1,0,0,0,7460,1017,1,0,0,0,7461,7462,5,505,0,0,7462,7463,
  	3,898,449,0,7463,1019,1,0,0,0,7464,7465,5,267,0,0,7465,7466,3,1022,511,
  	0,7466,7467,5,198,0,0,7467,7468,5,267,0,0,7468,1021,1,0,0,0,7469,7470,
  	3,898,449,0,7470,7475,3,1024,512,0,7471,7472,5,194,0,0,7472,7476,3,1022,
  	511,0,7473,7474,5,193,0,0,7474,7476,3,1026,513,0,7475,7471,1,0,0,0,7475,
  	7473,1,0,0,0,7475,7476,1,0,0,0,7476,1023,1,0,0,0,7477,7478,5,608,0,0,
  	7478,7479,3,1026,513,0,7479,1025,1,0,0,0,7480,7481,3,1016,508,0,7481,
  	7482,5,30,0,0,7482,7484,1,0,0,0,7483,7480,1,0,0,0,7484,7485,1,0,0,0,7485,
  	7483,1,0,0,0,7485,7486,1,0,0,0,7486,1027,1,0,0,0,7487,7489,5,96,0,0,7488,
  	7490,3,898,449,0,7489,7488,1,0,0,0,7489,7490,1,0,0,0,7490,7494,1,0,0,
  	0,7491,7492,3,980,490,0,7492,7493,3,1024,512,0,7493,7495,1,0,0,0,7494,
  	7491,1,0,0,0,7495,7496,1,0,0,0,7496,7494,1,0,0,0,7496,7497,1,0,0,0,7497,
  	7499,1,0,0,0,7498,7500,3,1030,515,0,7499,7498,1,0,0,0,7499,7500,1,0,0,
  	0,7500,7501,1,0,0,0,7501,7502,5,198,0,0,7502,7503,5,96,0,0,7503,1029,
  	1,0,0,0,7504,7505,5,193,0,0,7505,7506,3,1026,513,0,7506,1031,1,0,0,0,
  	7507,7508,3,1036,518,0,7508,7510,3,1038,519,0,7509,7511,3,1376,688,0,
  	7510,7509,1,0,0,0,7510,7511,1,0,0,0,7511,1033,1,0,0,0,7512,7513,3,1038,
  	519,0,7513,1035,1,0,0,0,7514,7515,3,1374,687,0,7515,7516,5,31,0,0,7516,
  	1037,1,0,0,0,7517,7519,5,74,0,0,7518,7520,3,1050,525,0,7519,7518,1,0,
  	0,0,7519,7520,1,0,0,0,7520,7522,1,0,0,0,7521,7523,3,1026,513,0,7522,7521,
  	1,0,0,0,7522,7523,1,0,0,0,7523,7524,1,0,0,0,7524,7525,5,198,0,0,7525,
  	1039,1,0,0,0,7526,7527,3,1036,518,0,7527,7529,3,1042,521,0,7528,7530,
  	3,1376,688,0,7529,7528,1,0,0,0,7529,7530,1,0,0,0,7530,1041,1,0,0,0,7531,
  	7535,3,1044,522,0,7532,7535,3,1046,523,0,7533,7535,3,1048,524,0,7534,
  	7531,1,0,0,0,7534,7532,1,0,0,0,7534,7533,1,0,0,0,7535,1043,1,0,0,0,7536,
  	7537,5,326,0,0,7537,7538,3,1026,513,0,7538,7539,5,198,0,0,7539,7540,5,
  	326,0,0,7540,1045,1,0,0,0,7541,7542,5,669,0,0,7542,7543,3,898,449,0,7543,
  	7544,5,186,0,0,7544,7545,3,1026,513,0,7545,7546,5,198,0,0,7546,7547,5,
  	669,0,0,7547,1047,1,0,0,0,7548,7549,5,487,0,0,7549,7550,3,1026,513,0,
  	7550,7551,5,639,0,0,7551,7552,3,898,449,0,7552,7553,5,198,0,0,7553,7554,
  	5,487,0,0,7554,1049,1,0,0,0,7555,7556,3,1052,526,0,7556,7557,5,30,0,0,
  	7557,7559,1,0,0,0,7558,7555,1,0,0,0,7559,7560,1,0,0,0,7560,7558,1,0,0,
  	0,7560,7561,1,0,0,0,7561,1051,1,0,0,0,7562,7567,3,1054,527,0,7563,7567,
  	3,1056,528,0,7564,7567,3,1062,531,0,7565,7567,3,1066,533,0,7566,7562,
  	1,0,0,0,7566,7563,1,0,0,0,7566,7564,1,0,0,0,7566,7565,1,0,0,0,7567,1053,
  	1,0,0,0,7568,7569,5,167,0,0,7569,7570,3,1392,696,0,7570,7572,3,1150,575,
  	0,7571,7573,3,1232,616,0,7572,7571,1,0,0,0,7572,7573,1,0,0,0,7573,7576,
  	1,0,0,0,7574,7575,5,168,0,0,7575,7577,3,898,449,0,7576,7574,1,0,0,0,7576,
  	7577,1,0,0,0,7577,1055,1,0,0,0,7578,7579,5,167,0,0,7579,7580,3,1390,695,
  	0,7580,7581,5,127,0,0,7581,7582,5,236,0,0,7582,7583,3,1058,529,0,7583,
  	1057,1,0,0,0,7584,7587,3,1402,701,0,7585,7587,3,1060,530,0,7586,7584,
  	1,0,0,0,7586,7585,1,0,0,0,7587,1059,1,0,0,0,7588,7590,5,552,0,0,7589,
  	7591,5,653,0,0,7590,7589,1,0,0,0,7590,7591,1,0,0,0,7591,7592,1,0,0,0,
  	7592,7593,3,1428,714,0,7593,1061,1,0,0,0,7594,7595,5,167,0,0,7595,7596,
  	7,125,0,0,7596,7597,5,255,0,0,7597,7598,5,236,0,0,7598,7603,3,1064,532,
  	0,7599,7600,5,29,0,0,7600,7602,3,1064,532,0,7601,7599,1,0,0,0,7602,7605,
  	1,0,0,0,7603,7601,1,0,0,0,7603,7604,1,0,0,0,7604,7606,1,0,0,0,7605,7603,
  	1,0,0,0,7606,7607,3,1016,508,0,7607,1063,1,0,0,0,7608,7616,3,1058,529,
  	0,7609,7616,3,1390,695,0,7610,7616,5,553,0,0,7611,7612,3,992,496,0,7612,
  	7613,5,238,0,0,7613,7616,1,0,0,0,7614,7616,5,551,0,0,7615,7608,1,0,0,
  	0,7615,7609,1,0,0,0,7615,7610,1,0,0,0,7615,7611,1,0,0,0,7615,7614,1,0,
  	0,0,7616,1065,1,0,0,0,7617,7618,5,167,0,0,7618,7619,3,1390,695,0,7619,
  	7620,5,148,0,0,7620,7621,5,236,0,0,7621,7622,3,296,148,0,7622,1067,1,
  	0,0,0,7623,7624,5,294,0,0,7624,7625,3,1376,688,0,7625,1069,1,0,0,0,7626,
  	7627,5,305,0,0,7627,7628,3,1376,688,0,7628,1071,1,0,0,0,7629,7631,5,243,
  	0,0,7630,7632,7,126,0,0,7631,7630,1,0,0,0,7631,7632,1,0,0,0,7632,7633,
  	1,0,0,0,7633,7652,5,178,0,0,7634,7639,3,1076,538,0,7635,7636,5,29,0,0,
  	7636,7638,3,1076,538,0,7637,7635,1,0,0,0,7638,7641,1,0,0,0,7639,7637,
  	1,0,0,0,7639,7640,1,0,0,0,7640,7653,1,0,0,0,7641,7639,1,0,0,0,7642,7643,
  	5,127,0,0,7643,7644,3,1074,537,0,7644,7649,3,1078,539,0,7645,7646,5,29,
  	0,0,7646,7648,3,1078,539,0,7647,7645,1,0,0,0,7648,7651,1,0,0,0,7649,7647,
  	1,0,0,0,7649,7650,1,0,0,0,7650,7653,1,0,0,0,7651,7649,1,0,0,0,7652,7634,
  	1,0,0,0,7652,7642,1,0,0,0,7653,1073,1,0,0,0,7654,7658,3,1414,707,0,7655,
  	7658,3,974,487,0,7656,7658,3,1396,698,0,7657,7654,1,0,0,0,7657,7655,1,
  	0,0,0,7657,7656,1,0,0,0,7658,1075,1,0,0,0,7659,7662,3,968,484,0,7660,
  	7662,3,1390,695,0,7661,7659,1,0,0,0,7661,7660,1,0,0,0,7662,7663,1,0,0,
  	0,7663,7664,5,6,0,0,7664,7665,7,127,0,0,7665,1077,1,0,0,0,7666,7669,3,
  	968,484,0,7667,7669,3,1390,695,0,7668,7666,1,0,0,0,7668,7667,1,0,0,0,
  	7669,7670,1,0,0,0,7670,7673,5,6,0,0,7671,7674,3,1080,540,0,7672,7674,
  	5,503,0,0,7673,7671,1,0,0,0,7673,7672,1,0,0,0,7674,1079,1,0,0,0,7675,
  	7676,7,128,0,0,7676,1081,1,0,0,0,7677,7680,5,538,0,0,7678,7681,3,1390,
  	695,0,7679,7681,3,1060,530,0,7680,7678,1,0,0,0,7680,7679,1,0,0,0,7681,
  	7691,1,0,0,0,7682,7683,5,533,0,0,7683,7688,3,1086,543,0,7684,7685,5,29,
  	0,0,7685,7687,3,1086,543,0,7686,7684,1,0,0,0,7687,7690,1,0,0,0,7688,7686,
  	1,0,0,0,7688,7689,1,0,0,0,7689,7692,1,0,0,0,7690,7688,1,0,0,0,7691,7682,
  	1,0,0,0,7691,7692,1,0,0,0,7692,1083,1,0,0,0,7693,7696,5,499,0,0,7694,
  	7697,3,1390,695,0,7695,7697,3,1060,530,0,7696,7694,1,0,0,0,7696,7695,
  	1,0,0,0,7696,7697,1,0,0,0,7697,7707,1,0,0,0,7698,7699,5,533,0,0,7699,
  	7704,3,1086,543,0,7700,7701,5,29,0,0,7701,7703,3,1086,543,0,7702,7700,
  	1,0,0,0,7703,7706,1,0,0,0,7704,7702,1,0,0,0,7704,7705,1,0,0,0,7705,7708,
  	1,0,0,0,7706,7704,1,0,0,0,7707,7698,1,0,0,0,7707,7708,1,0,0,0,7708,1085,
  	1,0,0,0,7709,7710,3,1080,540,0,7710,7711,5,6,0,0,7711,7712,3,1074,537,
  	0,7712,1087,1,0,0,0,7713,7714,5,417,0,0,7714,7715,3,1390,695,0,7715,1089,
  	1,0,0,0,7716,7717,5,110,0,0,7717,7718,3,1390,695,0,7718,1091,1,0,0,0,
  	7719,7724,5,225,0,0,7720,7722,5,397,0,0,7721,7720,1,0,0,0,7721,7722,1,
  	0,0,0,7722,7723,1,0,0,0,7723,7725,5,239,0,0,7724,7721,1,0,0,0,7724,7725,
  	1,0,0,0,7725,7726,1,0,0,0,7726,7727,3,1390,695,0,7727,7728,5,283,0,0,
  	7728,7729,3,1392,696,0,7729,1093,1,0,0,0,7730,7731,5,67,0,0,7731,7744,
  	3,898,449,0,7732,7733,5,210,0,0,7733,7734,3,898,449,0,7734,7737,3,996,
  	498,0,7735,7736,5,568,0,0,7736,7738,3,898,449,0,7737,7735,1,0,0,0,7737,
  	7738,1,0,0,0,7738,7741,1,0,0,0,7739,7740,5,199,0,0,7740,7742,3,898,449,
  	0,7741,7739,1,0,0,0,7741,7742,1,0,0,0,7742,7744,1,0,0,0,7743,7730,1,0,
  	0,0,7743,7732,1,0,0,0,7744,1095,1,0,0,0,7745,7746,3,1304,652,0,7746,7748,
  	3,1108,554,0,7747,7749,3,1098,549,0,7748,7747,1,0,0,0,7748,7749,1,0,0,
  	0,7749,1097,1,0,0,0,7750,7751,4,549,205,0,7751,7754,3,1100,550,0,7752,
  	7754,3,1122,561,0,7753,7750,1,0,0,0,7753,7752,1,0,0,0,7754,1099,1,0,0,
  	0,7755,7756,5,106,0,0,7756,7757,3,1002,501,0,7757,1101,1,0,0,0,7758,7760,
  	4,551,206,0,7759,7761,5,401,0,0,7760,7759,1,0,0,0,7760,7761,1,0,0,0,7761,
  	7762,1,0,0,0,7762,7763,5,755,0,0,7763,1103,1,0,0,0,7764,7766,7,40,0,0,
  	7765,7767,3,120,60,0,7766,7765,1,0,0,0,7766,7767,1,0,0,0,7767,7768,1,
  	0,0,0,7768,7772,3,1130,565,0,7769,7771,3,1136,568,0,7770,7769,1,0,0,0,
  	7771,7774,1,0,0,0,7772,7770,1,0,0,0,7772,7773,1,0,0,0,7773,7839,1,0,0,
  	0,7774,7772,1,0,0,0,7775,7777,5,241,0,0,7776,7778,3,438,219,0,7777,7776,
  	1,0,0,0,7777,7778,1,0,0,0,7778,7780,1,0,0,0,7779,7781,3,1314,657,0,7780,
  	7779,1,0,0,0,7780,7781,1,0,0,0,7781,7782,1,0,0,0,7782,7786,3,1130,565,
  	0,7783,7785,3,1144,572,0,7784,7783,1,0,0,0,7785,7788,1,0,0,0,7786,7784,
  	1,0,0,0,7786,7787,1,0,0,0,7787,7839,1,0,0,0,7788,7786,1,0,0,0,7789,7791,
  	5,549,0,0,7790,7792,3,438,219,0,7791,7790,1,0,0,0,7791,7792,1,0,0,0,7792,
  	7794,1,0,0,0,7793,7795,3,1314,657,0,7794,7793,1,0,0,0,7794,7795,1,0,0,
  	0,7795,7796,1,0,0,0,7796,7800,3,1130,565,0,7797,7799,3,1146,573,0,7798,
  	7797,1,0,0,0,7799,7802,1,0,0,0,7800,7798,1,0,0,0,7800,7801,1,0,0,0,7801,
  	7839,1,0,0,0,7802,7800,1,0,0,0,7803,7805,3,1106,553,0,7804,7803,1,0,0,
  	0,7804,7805,1,0,0,0,7805,7836,1,0,0,0,7806,7807,5,450,0,0,7807,7813,5,
  	299,0,0,7808,7810,5,635,0,0,7809,7811,3,438,219,0,7810,7809,1,0,0,0,7810,
  	7811,1,0,0,0,7811,7813,1,0,0,0,7812,7806,1,0,0,0,7812,7808,1,0,0,0,7813,
  	7815,1,0,0,0,7814,7816,3,120,60,0,7815,7814,1,0,0,0,7815,7816,1,0,0,0,
  	7816,7817,1,0,0,0,7817,7821,3,1130,565,0,7818,7820,3,1136,568,0,7819,
  	7818,1,0,0,0,7820,7823,1,0,0,0,7821,7819,1,0,0,0,7821,7822,1,0,0,0,7822,
  	7837,1,0,0,0,7823,7821,1,0,0,0,7824,7825,5,235,0,0,7825,7827,5,299,0,
  	0,7826,7828,3,1314,657,0,7827,7826,1,0,0,0,7827,7828,1,0,0,0,7828,7829,
  	1,0,0,0,7829,7830,3,1126,563,0,7830,7831,3,1122,561,0,7831,7837,1,0,0,
  	0,7832,7834,3,1100,550,0,7833,7835,3,1102,551,0,7834,7833,1,0,0,0,7834,
  	7835,1,0,0,0,7835,7837,1,0,0,0,7836,7812,1,0,0,0,7836,7824,1,0,0,0,7836,
  	7832,1,0,0,0,7837,7839,1,0,0,0,7838,7764,1,0,0,0,7838,7775,1,0,0,0,7838,
  	7789,1,0,0,0,7838,7804,1,0,0,0,7839,1105,1,0,0,0,7840,7842,5,130,0,0,
  	7841,7843,3,1390,695,0,7842,7841,1,0,0,0,7842,7843,1,0,0,0,7843,1107,
  	1,0,0,0,7844,7880,3,1150,575,0,7845,7847,3,1110,555,0,7846,7845,1,0,0,
  	0,7847,7850,1,0,0,0,7848,7846,1,0,0,0,7848,7849,1,0,0,0,7849,7881,1,0,
  	0,0,7850,7848,1,0,0,0,7851,7853,4,554,207,0,7852,7854,3,1232,616,0,7853,
  	7852,1,0,0,0,7853,7854,1,0,0,0,7854,7857,1,0,0,0,7855,7856,5,245,0,0,
  	7856,7858,5,58,0,0,7857,7855,1,0,0,0,7857,7858,1,0,0,0,7858,7859,1,0,
  	0,0,7859,7860,5,63,0,0,7860,7862,3,1002,501,0,7861,7863,7,129,0,0,7862,
  	7861,1,0,0,0,7862,7863,1,0,0,0,7863,7878,1,0,0,0,7864,7868,4,554,208,
  	0,7865,7867,3,1120,560,0,7866,7865,1,0,0,0,7867,7870,1,0,0,0,7868,7866,
  	1,0,0,0,7868,7869,1,0,0,0,7869,7879,1,0,0,0,7870,7868,1,0,0,0,7871,7875,
  	4,554,209,0,7872,7874,3,1110,555,0,7873,7872,1,0,0,0,7874,7877,1,0,0,
  	0,7875,7873,1,0,0,0,7875,7876,1,0,0,0,7876,7879,1,0,0,0,7877,7875,1,0,
  	0,0,7878,7864,1,0,0,0,7878,7871,1,0,0,0,7879,7881,1,0,0,0,7880,7848,1,
  	0,0,0,7880,7851,1,0,0,0,7881,1109,1,0,0,0,7882,7884,5,401,0,0,7883,7882,
  	1,0,0,0,7883,7884,1,0,0,0,7884,7885,1,0,0,0,7885,7945,3,1438,719,0,7886,
  	7887,4,555,210,0,7887,7888,5,401,0,0,7888,7945,5,745,0,0,7889,7893,5,
  	168,0,0,7890,7894,3,1118,559,0,7891,7892,4,555,211,0,7892,7894,3,1002,
  	501,0,7893,7890,1,0,0,0,7893,7891,1,0,0,0,7894,7945,1,0,0,0,7895,7896,
  	5,413,0,0,7896,7897,5,640,0,0,7897,7899,5,402,0,0,7898,7900,3,948,474,
  	0,7899,7898,1,0,0,0,7899,7900,1,0,0,0,7900,7945,1,0,0,0,7901,7945,5,69,
  	0,0,7902,7903,5,528,0,0,7903,7904,5,168,0,0,7904,7945,5,653,0,0,7905,
  	7907,5,450,0,0,7906,7905,1,0,0,0,7906,7907,1,0,0,0,7907,7908,1,0,0,0,
  	7908,7945,5,299,0,0,7909,7911,5,635,0,0,7910,7912,5,299,0,0,7911,7910,
  	1,0,0,0,7911,7912,1,0,0,0,7912,7945,1,0,0,0,7913,7914,5,119,0,0,7914,
  	7945,3,1428,714,0,7915,7945,3,1232,616,0,7916,7917,5,118,0,0,7917,7945,
  	3,1112,556,0,7918,7919,5,579,0,0,7919,7945,3,1114,557,0,7920,7921,4,555,
  	212,0,7921,7922,5,732,0,0,7922,7945,3,1408,704,0,7923,7925,4,555,213,
  	0,7924,7926,3,1106,553,0,7925,7924,1,0,0,0,7925,7926,1,0,0,0,7926,7927,
  	1,0,0,0,7927,7945,3,1100,550,0,7928,7929,4,555,214,0,7929,7945,3,1102,
  	551,0,7930,7931,4,555,215,0,7931,7933,5,774,0,0,7932,7934,5,6,0,0,7933,
  	7932,1,0,0,0,7933,7934,1,0,0,0,7934,7935,1,0,0,0,7935,7945,3,1468,734,
  	0,7936,7937,4,555,216,0,7937,7939,5,775,0,0,7938,7940,5,6,0,0,7939,7938,
  	1,0,0,0,7939,7940,1,0,0,0,7940,7941,1,0,0,0,7941,7945,3,1468,734,0,7942,
  	7943,4,555,217,0,7943,7945,3,1140,570,0,7944,7883,1,0,0,0,7944,7886,1,
  	0,0,0,7944,7889,1,0,0,0,7944,7895,1,0,0,0,7944,7901,1,0,0,0,7944,7902,
  	1,0,0,0,7944,7906,1,0,0,0,7944,7909,1,0,0,0,7944,7913,1,0,0,0,7944,7915,
  	1,0,0,0,7944,7916,1,0,0,0,7944,7918,1,0,0,0,7944,7920,1,0,0,0,7944,7923,
  	1,0,0,0,7944,7928,1,0,0,0,7944,7930,1,0,0,0,7944,7936,1,0,0,0,7944,7942,
  	1,0,0,0,7945,1111,1,0,0,0,7946,7947,7,130,0,0,7947,1113,1,0,0,0,7948,
  	7949,7,131,0,0,7949,1115,1,0,0,0,7950,7951,5,402,0,0,7951,7952,3,1170,
  	585,0,7952,1117,1,0,0,0,7953,7956,3,1116,558,0,7954,7956,3,1412,706,0,
  	7955,7953,1,0,0,0,7955,7954,1,0,0,0,7956,1119,1,0,0,0,7957,7959,5,635,
  	0,0,7958,7960,5,299,0,0,7959,7958,1,0,0,0,7959,7960,1,0,0,0,7960,7972,
  	1,0,0,0,7961,7962,5,119,0,0,7962,7972,3,1424,712,0,7963,7965,3,992,496,
  	0,7964,7963,1,0,0,0,7964,7965,1,0,0,0,7965,7966,1,0,0,0,7966,7972,5,406,
  	0,0,7967,7969,5,450,0,0,7968,7967,1,0,0,0,7968,7969,1,0,0,0,7969,7970,
  	1,0,0,0,7970,7972,5,299,0,0,7971,7957,1,0,0,0,7971,7961,1,0,0,0,7971,
  	7964,1,0,0,0,7971,7968,1,0,0,0,7972,1121,1,0,0,0,7973,7974,5,473,0,0,
  	7974,7976,3,1366,683,0,7975,7977,3,1394,697,0,7976,7975,1,0,0,0,7976,
  	7977,1,0,0,0,7977,7980,1,0,0,0,7978,7979,5,352,0,0,7979,7981,7,132,0,
  	0,7980,7978,1,0,0,0,7980,7981,1,0,0,0,7981,7998,1,0,0,0,7982,7983,5,413,
  	0,0,7983,7984,5,640,0,0,7984,7988,3,1124,562,0,7985,7986,5,413,0,0,7986,
  	7987,5,173,0,0,7987,7989,3,1124,562,0,7988,7985,1,0,0,0,7988,7989,1,0,
  	0,0,7989,7999,1,0,0,0,7990,7991,5,413,0,0,7991,7992,5,173,0,0,7992,7996,
  	3,1124,562,0,7993,7994,5,413,0,0,7994,7995,5,640,0,0,7995,7997,3,1124,
  	562,0,7996,7993,1,0,0,0,7996,7997,1,0,0,0,7997,7999,1,0,0,0,7998,7982,
  	1,0,0,0,7998,7990,1,0,0,0,7998,7999,1,0,0,0,7999,1123,1,0,0,0,8000,8008,
  	7,2,0,0,8001,8002,5,533,0,0,8002,8008,3,1438,719,0,8003,8004,5,533,0,
  	0,8004,8008,5,168,0,0,8005,8006,5,403,0,0,8006,8008,5,49,0,0,8007,8000,
  	1,0,0,0,8007,8001,1,0,0,0,8007,8003,1,0,0,0,8007,8005,1,0,0,0,8008,1125,
  	1,0,0,0,8009,8010,5,32,0,0,8010,8015,3,1128,564,0,8011,8012,5,29,0,0,
  	8012,8014,3,1128,564,0,8013,8011,1,0,0,0,8014,8017,1,0,0,0,8015,8013,
  	1,0,0,0,8015,8016,1,0,0,0,8016,8018,1,0,0,0,8017,8015,1,0,0,0,8018,8019,
  	5,33,0,0,8019,1127,1,0,0,0,8020,8022,3,1390,695,0,8021,8023,3,1156,578,
  	0,8022,8021,1,0,0,0,8022,8023,1,0,0,0,8023,8025,1,0,0,0,8024,8026,3,360,
  	180,0,8025,8024,1,0,0,0,8025,8026,1,0,0,0,8026,1129,1,0,0,0,8027,8028,
  	5,32,0,0,8028,8033,3,1132,566,0,8029,8030,5,29,0,0,8030,8032,3,1132,566,
  	0,8031,8029,1,0,0,0,8032,8035,1,0,0,0,8033,8031,1,0,0,0,8033,8034,1,0,
  	0,0,8034,8036,1,0,0,0,8035,8033,1,0,0,0,8036,8037,5,33,0,0,8037,1131,
  	1,0,0,0,8038,8045,3,1128,564,0,8039,8040,4,566,218,0,8040,8042,3,1002,
  	501,0,8041,8043,3,360,180,0,8042,8041,1,0,0,0,8042,8043,1,0,0,0,8043,
  	8045,1,0,0,0,8044,8038,1,0,0,0,8044,8039,1,0,0,0,8045,1133,1,0,0,0,8046,
  	8047,7,133,0,0,8047,1135,1,0,0,0,8048,8051,3,1138,569,0,8049,8051,3,1142,
  	571,0,8050,8048,1,0,0,0,8050,8049,1,0,0,0,8051,1137,1,0,0,0,8052,8054,
  	5,298,0,0,8053,8055,5,6,0,0,8054,8053,1,0,0,0,8054,8055,1,0,0,0,8055,
  	8056,1,0,0,0,8056,8074,3,1402,701,0,8057,8058,5,119,0,0,8058,8074,3,1428,
  	714,0,8059,8060,4,569,219,0,8060,8074,3,1140,570,0,8061,8062,4,569,220,
  	0,8062,8064,5,774,0,0,8063,8065,5,6,0,0,8064,8063,1,0,0,0,8064,8065,1,
  	0,0,0,8065,8066,1,0,0,0,8066,8074,3,1468,734,0,8067,8068,4,569,221,0,
  	8068,8070,5,775,0,0,8069,8071,5,6,0,0,8070,8069,1,0,0,0,8070,8071,1,0,
  	0,0,8071,8072,1,0,0,0,8072,8074,3,1468,734,0,8073,8052,1,0,0,0,8073,8057,
  	1,0,0,0,8073,8059,1,0,0,0,8073,8061,1,0,0,0,8073,8067,1,0,0,0,8074,1139,
  	1,0,0,0,8075,8076,7,134,0,0,8076,1141,1,0,0,0,8077,8078,7,135,0,0,8078,
  	8079,3,1134,567,0,8079,1143,1,0,0,0,8080,8085,3,1138,569,0,8081,8082,
  	5,670,0,0,8082,8083,5,431,0,0,8083,8085,3,1390,695,0,8084,8080,1,0,0,
  	0,8084,8081,1,0,0,0,8085,1145,1,0,0,0,8086,8087,3,1138,569,0,8087,1147,
  	1,0,0,0,8088,8089,3,1150,575,0,8089,8090,5,0,0,1,8090,1149,1,0,0,0,8091,
  	8093,7,136,0,0,8092,8094,3,1156,578,0,8093,8092,1,0,0,0,8093,8094,1,0,
  	0,0,8094,8096,1,0,0,0,8095,8097,3,1158,579,0,8096,8095,1,0,0,0,8096,8097,
  	1,0,0,0,8097,8239,1,0,0,0,8098,8104,5,467,0,0,8099,8101,5,185,0,0,8100,
  	8102,5,446,0,0,8101,8100,1,0,0,0,8101,8102,1,0,0,0,8102,8104,1,0,0,0,
  	8103,8098,1,0,0,0,8103,8099,1,0,0,0,8104,8106,1,0,0,0,8105,8107,3,1448,
  	724,0,8106,8105,1,0,0,0,8106,8107,1,0,0,0,8107,8109,1,0,0,0,8108,8110,
  	3,1158,579,0,8109,8108,1,0,0,0,8109,8110,1,0,0,0,8110,8239,1,0,0,0,8111,
  	8113,7,137,0,0,8112,8114,3,1444,722,0,8113,8112,1,0,0,0,8113,8114,1,0,
  	0,0,8114,8116,1,0,0,0,8115,8117,3,1158,579,0,8116,8115,1,0,0,0,8116,8117,
  	1,0,0,0,8117,8239,1,0,0,0,8118,8120,5,82,0,0,8119,8121,3,1156,578,0,8120,
  	8119,1,0,0,0,8120,8121,1,0,0,0,8121,8239,1,0,0,0,8122,8239,7,138,0,0,
  	8123,8125,5,104,0,0,8124,8126,3,1156,578,0,8125,8124,1,0,0,0,8125,8126,
  	1,0,0,0,8126,8128,1,0,0,0,8127,8129,3,1160,580,0,8128,8127,1,0,0,0,8128,
  	8129,1,0,0,0,8129,8239,1,0,0,0,8130,8132,3,1152,576,0,8131,8133,3,1156,
  	578,0,8132,8131,1,0,0,0,8132,8133,1,0,0,0,8133,8135,1,0,0,0,8134,8136,
  	5,77,0,0,8135,8134,1,0,0,0,8135,8136,1,0,0,0,8136,8239,1,0,0,0,8137,8139,
  	5,77,0,0,8138,8140,3,1156,578,0,8139,8138,1,0,0,0,8139,8140,1,0,0,0,8140,
  	8239,1,0,0,0,8141,8142,5,104,0,0,8142,8145,5,658,0,0,8143,8145,5,655,
  	0,0,8144,8141,1,0,0,0,8144,8143,1,0,0,0,8145,8146,1,0,0,0,8146,8148,3,
  	1156,578,0,8147,8149,3,1160,580,0,8148,8147,1,0,0,0,8148,8149,1,0,0,0,
  	8149,8239,1,0,0,0,8150,8151,5,389,0,0,8151,8161,5,655,0,0,8152,8161,5,
  	409,0,0,8153,8154,5,392,0,0,8154,8161,5,655,0,0,8155,8156,5,389,0,0,8156,
  	8157,5,104,0,0,8157,8161,5,658,0,0,8158,8159,5,392,0,0,8159,8161,5,658,
  	0,0,8160,8150,1,0,0,0,8160,8152,1,0,0,0,8160,8153,1,0,0,0,8160,8155,1,
  	0,0,0,8160,8158,1,0,0,0,8161,8162,1,0,0,0,8162,8164,3,1156,578,0,8163,
  	8165,5,77,0,0,8164,8163,1,0,0,0,8164,8165,1,0,0,0,8165,8239,1,0,0,0,8166,
  	8167,5,654,0,0,8167,8239,3,1156,578,0,8168,8170,5,681,0,0,8169,8171,3,
  	1156,578,0,8170,8169,1,0,0,0,8170,8171,1,0,0,0,8171,8173,1,0,0,0,8172,
  	8174,3,1158,579,0,8173,8172,1,0,0,0,8173,8174,1,0,0,0,8174,8239,1,0,0,
  	0,8175,8239,5,158,0,0,8176,8178,5,612,0,0,8177,8179,3,1168,584,0,8178,
  	8177,1,0,0,0,8178,8179,1,0,0,0,8179,8239,1,0,0,0,8180,8182,5,609,0,0,
  	8181,8183,3,1168,584,0,8182,8181,1,0,0,0,8182,8183,1,0,0,0,8183,8239,
  	1,0,0,0,8184,8186,5,155,0,0,8185,8187,3,1168,584,0,8186,8185,1,0,0,0,
  	8186,8187,1,0,0,0,8187,8239,1,0,0,0,8188,8239,5,613,0,0,8189,8191,5,84,
  	0,0,8190,8192,3,1156,578,0,8191,8190,1,0,0,0,8191,8192,1,0,0,0,8192,8239,
  	1,0,0,0,8193,8239,7,139,0,0,8194,8195,5,325,0,0,8195,8239,5,654,0,0,8196,
  	8200,5,325,0,0,8197,8198,5,104,0,0,8198,8201,5,658,0,0,8199,8201,5,655,
  	0,0,8200,8197,1,0,0,0,8200,8199,1,0,0,0,8200,8201,1,0,0,0,8201,8203,1,
  	0,0,0,8202,8204,3,1160,580,0,8203,8202,1,0,0,0,8203,8204,1,0,0,0,8204,
  	8239,1,0,0,0,8205,8207,5,615,0,0,8206,8208,3,1160,580,0,8207,8206,1,0,
  	0,0,8207,8208,1,0,0,0,8208,8239,1,0,0,0,8209,8211,5,606,0,0,8210,8212,
  	3,1156,578,0,8211,8210,1,0,0,0,8211,8212,1,0,0,0,8212,8214,1,0,0,0,8213,
  	8215,3,1160,580,0,8214,8213,1,0,0,0,8214,8215,1,0,0,0,8215,8239,1,0,0,
  	0,8216,8218,5,364,0,0,8217,8219,3,1160,580,0,8218,8217,1,0,0,0,8218,8219,
  	1,0,0,0,8219,8239,1,0,0,0,8220,8222,5,323,0,0,8221,8223,3,1160,580,0,
  	8222,8221,1,0,0,0,8222,8223,1,0,0,0,8223,8239,1,0,0,0,8224,8225,5,203,
  	0,0,8225,8227,3,1420,710,0,8226,8228,3,1160,580,0,8227,8226,1,0,0,0,8227,
  	8228,1,0,0,0,8228,8239,1,0,0,0,8229,8230,5,533,0,0,8230,8232,3,1420,710,
  	0,8231,8233,3,1160,580,0,8232,8231,1,0,0,0,8232,8233,1,0,0,0,8233,8239,
  	1,0,0,0,8234,8239,5,528,0,0,8235,8236,4,575,222,0,8236,8239,5,296,0,0,
  	8237,8239,7,140,0,0,8238,8091,1,0,0,0,8238,8103,1,0,0,0,8238,8111,1,0,
  	0,0,8238,8118,1,0,0,0,8238,8122,1,0,0,0,8238,8123,1,0,0,0,8238,8130,1,
  	0,0,0,8238,8137,1,0,0,0,8238,8144,1,0,0,0,8238,8160,1,0,0,0,8238,8166,
  	1,0,0,0,8238,8168,1,0,0,0,8238,8175,1,0,0,0,8238,8176,1,0,0,0,8238,8180,
  	1,0,0,0,8238,8184,1,0,0,0,8238,8188,1,0,0,0,8238,8189,1,0,0,0,8238,8193,
  	1,0,0,0,8238,8194,1,0,0,0,8238,8196,1,0,0,0,8238,8205,1,0,0,0,8238,8209,
  	1,0,0,0,8238,8216,1,0,0,0,8238,8220,1,0,0,0,8238,8224,1,0,0,0,8238,8229,
  	1,0,0,0,8238,8234,1,0,0,0,8238,8235,1,0,0,0,8238,8237,1,0,0,0,8239,1151,
  	1,0,0,0,8240,8244,5,392,0,0,8241,8242,5,389,0,0,8242,8244,5,104,0,0,8243,
  	8240,1,0,0,0,8243,8241,1,0,0,0,8244,1153,1,0,0,0,8245,8251,5,467,0,0,
  	8246,8248,5,185,0,0,8247,8249,5,446,0,0,8248,8247,1,0,0,0,8248,8249,1,
  	0,0,0,8249,8251,1,0,0,0,8250,8245,1,0,0,0,8250,8246,1,0,0,0,8251,1155,
  	1,0,0,0,8252,8255,5,32,0,0,8253,8256,3,1408,704,0,8254,8256,5,45,0,0,
  	8255,8253,1,0,0,0,8255,8254,1,0,0,0,8256,8257,1,0,0,0,8257,8258,5,33,
  	0,0,8258,1157,1,0,0,0,8259,8261,7,141,0,0,8260,8259,1,0,0,0,8261,8262,
  	1,0,0,0,8262,8260,1,0,0,0,8262,8263,1,0,0,0,8263,1159,1,0,0,0,8264,8279,
  	3,1162,581,0,8265,8279,3,1164,582,0,8266,8279,5,91,0,0,8267,8268,3,990,
  	495,0,8268,8270,3,1172,586,0,8269,8271,5,77,0,0,8270,8269,1,0,0,0,8270,
  	8271,1,0,0,0,8271,8279,1,0,0,0,8272,8276,5,77,0,0,8273,8274,3,990,495,
  	0,8274,8275,3,1172,586,0,8275,8277,1,0,0,0,8276,8273,1,0,0,0,8276,8277,
  	1,0,0,0,8277,8279,1,0,0,0,8278,8264,1,0,0,0,8278,8265,1,0,0,0,8278,8266,
  	1,0,0,0,8278,8267,1,0,0,0,8278,8272,1,0,0,0,8279,1161,1,0,0,0,8280,8282,
  	5,65,0,0,8281,8283,5,77,0,0,8282,8281,1,0,0,0,8282,8283,1,0,0,0,8283,
  	8287,1,0,0,0,8284,8285,5,77,0,0,8285,8287,5,65,0,0,8286,8280,1,0,0,0,
  	8286,8284,1,0,0,0,8287,1163,1,0,0,0,8288,8290,5,632,0,0,8289,8291,5,77,
  	0,0,8290,8289,1,0,0,0,8290,8291,1,0,0,0,8291,8295,1,0,0,0,8292,8293,5,
  	77,0,0,8293,8295,5,632,0,0,8294,8288,1,0,0,0,8294,8292,1,0,0,0,8295,1165,
  	1,0,0,0,8296,8297,5,32,0,0,8297,8298,3,1404,702,0,8298,8299,5,33,0,0,
  	8299,1167,1,0,0,0,8300,8301,5,32,0,0,8301,8302,5,3,0,0,8302,8303,5,33,
  	0,0,8303,1169,1,0,0,0,8304,8310,1,0,0,0,8305,8310,3,1458,729,0,8306,8307,
  	5,32,0,0,8307,8308,5,3,0,0,8308,8310,5,33,0,0,8309,8304,1,0,0,0,8309,
  	8305,1,0,0,0,8309,8306,1,0,0,0,8310,1171,1,0,0,0,8311,8316,3,1450,725,
  	0,8312,8316,5,77,0,0,8313,8314,4,586,223,0,8314,8316,5,168,0,0,8315,8311,
  	1,0,0,0,8315,8312,1,0,0,0,8315,8313,1,0,0,0,8316,1173,1,0,0,0,8317,8323,
  	3,1450,725,0,8318,8319,4,587,224,0,8319,8323,5,168,0,0,8320,8321,4,587,
  	225,0,8321,8323,5,77,0,0,8322,8317,1,0,0,0,8322,8318,1,0,0,0,8322,8320,
  	1,0,0,0,8323,1175,1,0,0,0,8324,8331,3,1184,592,0,8325,8327,5,29,0,0,8326,
  	8325,1,0,0,0,8326,8327,1,0,0,0,8327,8328,1,0,0,0,8328,8330,3,1184,592,
  	0,8329,8326,1,0,0,0,8330,8333,1,0,0,0,8331,8329,1,0,0,0,8331,8332,1,0,
  	0,0,8332,1177,1,0,0,0,8333,8331,1,0,0,0,8334,8336,3,1176,588,0,8335,8337,
  	3,1180,590,0,8336,8335,1,0,0,0,8336,8337,1,0,0,0,8337,8340,1,0,0,0,8338,
  	8340,3,1180,590,0,8339,8334,1,0,0,0,8339,8338,1,0,0,0,8340,1179,1,0,0,
  	0,8341,8343,3,1194,597,0,8342,8344,3,92,46,0,8343,8342,1,0,0,0,8343,8344,
  	1,0,0,0,8344,8347,1,0,0,0,8345,8347,3,92,46,0,8346,8341,1,0,0,0,8346,
  	8345,1,0,0,0,8347,1181,1,0,0,0,8348,8350,3,1184,592,0,8349,8348,1,0,0,
  	0,8350,8351,1,0,0,0,8351,8349,1,0,0,0,8351,8352,1,0,0,0,8352,1183,1,0,
  	0,0,8353,8355,5,202,0,0,8354,8356,5,6,0,0,8355,8354,1,0,0,0,8355,8356,
  	1,0,0,0,8356,8357,1,0,0,0,8357,8500,3,1358,679,0,8358,8359,4,592,226,
  	0,8359,8361,5,746,0,0,8360,8362,3,1460,730,0,8361,8360,1,0,0,0,8361,8362,
  	1,0,0,0,8362,8365,1,0,0,0,8363,8366,5,406,0,0,8364,8366,3,1450,725,0,
  	8365,8363,1,0,0,0,8365,8364,1,0,0,0,8366,8500,1,0,0,0,8367,8369,5,355,
  	0,0,8368,8370,5,6,0,0,8369,8368,1,0,0,0,8369,8370,1,0,0,0,8370,8371,1,
  	0,0,0,8371,8500,3,1406,703,0,8372,8374,5,375,0,0,8373,8375,5,6,0,0,8374,
  	8373,1,0,0,0,8374,8375,1,0,0,0,8375,8376,1,0,0,0,8376,8500,3,1406,703,
  	0,8377,8379,5,70,0,0,8378,8380,5,6,0,0,8379,8378,1,0,0,0,8379,8380,1,
  	0,0,0,8380,8381,1,0,0,0,8381,8500,3,1406,703,0,8382,8384,5,436,0,0,8383,
  	8385,5,6,0,0,8384,8383,1,0,0,0,8384,8385,1,0,0,0,8385,8386,1,0,0,0,8386,
  	8500,3,1422,711,0,8387,8389,5,119,0,0,8388,8390,5,6,0,0,8389,8388,1,0,
  	0,0,8389,8390,1,0,0,0,8390,8391,1,0,0,0,8391,8500,3,1422,711,0,8392,8393,
  	4,592,227,0,8393,8395,5,125,0,0,8394,8396,5,6,0,0,8395,8394,1,0,0,0,8395,
  	8396,1,0,0,0,8396,8397,1,0,0,0,8397,8500,3,1424,712,0,8398,8399,4,592,
  	228,0,8399,8401,5,197,0,0,8400,8402,5,6,0,0,8401,8400,1,0,0,0,8401,8402,
  	1,0,0,0,8402,8403,1,0,0,0,8403,8500,3,1424,712,0,8404,8406,5,69,0,0,8405,
  	8407,5,6,0,0,8406,8405,1,0,0,0,8406,8407,1,0,0,0,8407,8408,1,0,0,0,8408,
  	8500,3,1406,703,0,8409,8411,5,429,0,0,8410,8412,5,6,0,0,8411,8410,1,0,
  	0,0,8411,8412,1,0,0,0,8412,8413,1,0,0,0,8413,8500,3,1186,593,0,8414,8416,
  	7,142,0,0,8415,8417,5,6,0,0,8416,8415,1,0,0,0,8416,8417,1,0,0,0,8417,
  	8418,1,0,0,0,8418,8500,3,1186,593,0,8419,8421,7,143,0,0,8420,8422,5,6,
  	0,0,8421,8420,1,0,0,0,8421,8422,1,0,0,0,8422,8423,1,0,0,0,8423,8500,3,
  	1402,701,0,8424,8426,5,172,0,0,8425,8427,5,6,0,0,8426,8425,1,0,0,0,8426,
  	8427,1,0,0,0,8427,8428,1,0,0,0,8428,8500,3,1402,701,0,8429,8431,5,515,
  	0,0,8430,8432,5,6,0,0,8431,8430,1,0,0,0,8431,8432,1,0,0,0,8432,8433,1,
  	0,0,0,8433,8500,7,144,0,0,8434,8436,5,634,0,0,8435,8437,5,6,0,0,8436,
  	8435,1,0,0,0,8436,8437,1,0,0,0,8437,8438,1,0,0,0,8438,8439,5,32,0,0,8439,
  	8440,3,1368,684,0,8440,8441,5,33,0,0,8441,8500,1,0,0,0,8442,8500,3,1192,
  	596,0,8443,8500,3,1188,594,0,8444,8446,5,279,0,0,8445,8447,5,6,0,0,8446,
  	8445,1,0,0,0,8446,8447,1,0,0,0,8447,8448,1,0,0,0,8448,8500,7,145,0,0,
  	8449,8450,5,154,0,0,8450,8452,5,179,0,0,8451,8453,5,6,0,0,8452,8451,1,
  	0,0,0,8452,8453,1,0,0,0,8453,8454,1,0,0,0,8454,8500,3,1424,712,0,8455,
  	8456,5,272,0,0,8456,8458,5,179,0,0,8457,8459,5,6,0,0,8458,8457,1,0,0,
  	0,8458,8459,1,0,0,0,8459,8460,1,0,0,0,8460,8500,3,1424,712,0,8461,8467,
  	5,598,0,0,8462,8464,4,592,229,0,8463,8465,5,6,0,0,8464,8463,1,0,0,0,8464,
  	8465,1,0,0,0,8465,8468,1,0,0,0,8466,8468,1,0,0,0,8467,8462,1,0,0,0,8467,
  	8466,1,0,0,0,8468,8469,1,0,0,0,8469,8500,3,1390,695,0,8470,8471,5,579,
  	0,0,8471,8500,7,146,0,0,8472,8474,5,128,0,0,8473,8475,5,6,0,0,8474,8473,
  	1,0,0,0,8474,8475,1,0,0,0,8475,8476,1,0,0,0,8476,8500,3,1424,712,0,8477,
  	8479,5,298,0,0,8478,8480,5,6,0,0,8479,8478,1,0,0,0,8479,8480,1,0,0,0,
  	8480,8481,1,0,0,0,8481,8500,3,1406,703,0,8482,8483,4,592,230,0,8483,8484,
  	5,569,0,0,8484,8500,5,618,0,0,8485,8486,4,592,231,0,8486,8488,5,774,0,
  	0,8487,8489,5,6,0,0,8488,8487,1,0,0,0,8488,8489,1,0,0,0,8489,8490,1,0,
  	0,0,8490,8500,3,1468,734,0,8491,8492,4,592,232,0,8492,8494,5,775,0,0,
  	8493,8495,5,6,0,0,8494,8493,1,0,0,0,8494,8495,1,0,0,0,8495,8496,1,0,0,
  	0,8496,8500,3,1468,734,0,8497,8498,4,592,233,0,8498,8500,3,152,76,0,8499,
  	8353,1,0,0,0,8499,8358,1,0,0,0,8499,8367,1,0,0,0,8499,8372,1,0,0,0,8499,
  	8377,1,0,0,0,8499,8382,1,0,0,0,8499,8387,1,0,0,0,8499,8392,1,0,0,0,8499,
  	8398,1,0,0,0,8499,8404,1,0,0,0,8499,8409,1,0,0,0,8499,8414,1,0,0,0,8499,
  	8419,1,0,0,0,8499,8424,1,0,0,0,8499,8429,1,0,0,0,8499,8434,1,0,0,0,8499,
  	8442,1,0,0,0,8499,8443,1,0,0,0,8499,8444,1,0,0,0,8499,8449,1,0,0,0,8499,
  	8455,1,0,0,0,8499,8461,1,0,0,0,8499,8470,1,0,0,0,8499,8472,1,0,0,0,8499,
  	8477,1,0,0,0,8499,8482,1,0,0,0,8499,8485,1,0,0,0,8499,8491,1,0,0,0,8499,
  	8497,1,0,0,0,8500,1185,1,0,0,0,8501,8504,3,1402,701,0,8502,8504,5,168,
  	0,0,8503,8501,1,0,0,0,8503,8502,1,0,0,0,8504,1187,1,0,0,0,8505,8507,5,
  	168,0,0,8506,8505,1,0,0,0,8506,8507,1,0,0,0,8507,8508,1,0,0,0,8508,8510,
  	5,113,0,0,8509,8511,5,6,0,0,8510,8509,1,0,0,0,8510,8511,1,0,0,0,8511,
  	8512,1,0,0,0,8512,8513,3,1174,587,0,8513,1189,1,0,0,0,8514,8516,5,168,
  	0,0,8515,8514,1,0,0,0,8515,8516,1,0,0,0,8516,8517,1,0,0,0,8517,8519,5,
  	197,0,0,8518,8520,5,6,0,0,8519,8518,1,0,0,0,8519,8520,1,0,0,0,8520,8521,
  	1,0,0,0,8521,8522,3,1422,711,0,8522,1191,1,0,0,0,8523,8525,5,168,0,0,
  	8524,8523,1,0,0,0,8524,8525,1,0,0,0,8525,8526,1,0,0,0,8526,8528,3,990,
  	495,0,8527,8529,5,6,0,0,8528,8527,1,0,0,0,8528,8529,1,0,0,0,8529,8530,
  	1,0,0,0,8530,8531,3,1172,586,0,8531,1193,1,0,0,0,8532,8533,5,435,0,0,
  	8533,8534,5,90,0,0,8534,8537,3,1196,598,0,8535,8536,5,434,0,0,8536,8538,
  	3,1404,702,0,8537,8535,1,0,0,0,8537,8538,1,0,0,0,8538,8540,1,0,0,0,8539,
  	8541,3,1198,599,0,8540,8539,1,0,0,0,8540,8541,1,0,0,0,8541,8543,1,0,0,
  	0,8542,8544,3,1202,601,0,8543,8542,1,0,0,0,8543,8544,1,0,0,0,8544,1195,
  	1,0,0,0,8545,8547,5,311,0,0,8546,8545,1,0,0,0,8546,8547,1,0,0,0,8547,
  	8548,1,0,0,0,8548,8550,5,299,0,0,8549,8551,3,1200,600,0,8550,8549,1,0,
  	0,0,8550,8551,1,0,0,0,8551,8552,1,0,0,0,8552,8554,5,32,0,0,8553,8555,
  	3,1392,696,0,8554,8553,1,0,0,0,8554,8555,1,0,0,0,8555,8556,1,0,0,0,8556,
  	8579,5,33,0,0,8557,8559,5,311,0,0,8558,8557,1,0,0,0,8558,8559,1,0,0,0,
  	8559,8560,1,0,0,0,8560,8561,5,256,0,0,8561,8562,5,32,0,0,8562,8563,3,
  	908,454,0,8563,8564,5,33,0,0,8564,8579,1,0,0,0,8565,8576,7,147,0,0,8566,
  	8567,5,32,0,0,8567,8568,3,908,454,0,8568,8569,5,33,0,0,8569,8577,1,0,
  	0,0,8570,8571,5,115,0,0,8571,8573,5,32,0,0,8572,8574,3,1392,696,0,8573,
  	8572,1,0,0,0,8573,8574,1,0,0,0,8574,8575,1,0,0,0,8575,8577,5,33,0,0,8576,
  	8566,1,0,0,0,8576,8570,1,0,0,0,8577,8579,1,0,0,0,8578,8546,1,0,0,0,8578,
  	8558,1,0,0,0,8578,8565,1,0,0,0,8579,1197,1,0,0,0,8580,8581,5,587,0,0,
  	8581,8583,5,90,0,0,8582,8584,5,311,0,0,8583,8582,1,0,0,0,8583,8584,1,
  	0,0,0,8584,8595,1,0,0,0,8585,8586,5,256,0,0,8586,8587,5,32,0,0,8587,8588,
  	3,908,454,0,8588,8589,5,33,0,0,8589,8596,1,0,0,0,8590,8592,5,299,0,0,
  	8591,8593,3,1200,600,0,8592,8591,1,0,0,0,8592,8593,1,0,0,0,8593,8594,
  	1,0,0,0,8594,8596,3,1394,697,0,8595,8585,1,0,0,0,8595,8590,1,0,0,0,8596,
  	8599,1,0,0,0,8597,8598,5,586,0,0,8598,8600,3,1404,702,0,8599,8597,1,0,
  	0,0,8599,8600,1,0,0,0,8600,1199,1,0,0,0,8601,8602,5,55,0,0,8602,8603,
  	5,6,0,0,8603,8604,3,1404,702,0,8604,1201,1,0,0,0,8605,8606,5,32,0,0,8606,
  	8611,3,1204,602,0,8607,8608,5,29,0,0,8608,8610,3,1204,602,0,8609,8607,
  	1,0,0,0,8610,8613,1,0,0,0,8611,8609,1,0,0,0,8611,8612,1,0,0,0,8612,8614,
  	1,0,0,0,8613,8611,1,0,0,0,8614,8615,5,33,0,0,8615,1203,1,0,0,0,8616,8617,
  	5,435,0,0,8617,8628,3,1390,695,0,8618,8619,5,652,0,0,8619,8620,5,307,
  	0,0,8620,8623,5,607,0,0,8621,8624,3,1212,606,0,8622,8624,5,361,0,0,8623,
  	8621,1,0,0,0,8623,8622,1,0,0,0,8624,8629,1,0,0,0,8625,8626,5,652,0,0,
  	8626,8627,5,286,0,0,8627,8629,3,1206,603,0,8628,8618,1,0,0,0,8628,8625,
  	1,0,0,0,8628,8629,1,0,0,0,8629,8633,1,0,0,0,8630,8632,3,1208,604,0,8631,
  	8630,1,0,0,0,8632,8635,1,0,0,0,8633,8631,1,0,0,0,8633,8634,1,0,0,0,8634,
  	8647,1,0,0,0,8635,8633,1,0,0,0,8636,8637,5,32,0,0,8637,8642,3,1210,605,
  	0,8638,8639,5,29,0,0,8639,8641,3,1210,605,0,8640,8638,1,0,0,0,8641,8644,
  	1,0,0,0,8642,8640,1,0,0,0,8642,8643,1,0,0,0,8643,8645,1,0,0,0,8644,8642,
  	1,0,0,0,8645,8646,5,33,0,0,8646,8648,1,0,0,0,8647,8636,1,0,0,0,8647,8648,
  	1,0,0,0,8648,1205,1,0,0,0,8649,8662,3,1212,606,0,8650,8651,5,32,0,0,8651,
  	8656,3,1212,606,0,8652,8653,5,29,0,0,8653,8655,3,1212,606,0,8654,8652,
  	1,0,0,0,8655,8658,1,0,0,0,8656,8654,1,0,0,0,8656,8657,1,0,0,0,8657,8659,
  	1,0,0,0,8658,8656,1,0,0,0,8659,8660,5,33,0,0,8660,8662,1,0,0,0,8661,8649,
  	1,0,0,0,8661,8650,1,0,0,0,8662,1207,1,0,0,0,8663,8665,5,598,0,0,8664,
  	8666,5,6,0,0,8665,8664,1,0,0,0,8665,8666,1,0,0,0,8666,8667,1,0,0,0,8667,
  	8698,3,1390,695,0,8668,8670,5,579,0,0,8669,8668,1,0,0,0,8669,8670,1,0,
  	0,0,8670,8671,1,0,0,0,8671,8673,5,202,0,0,8672,8674,5,6,0,0,8673,8672,
  	1,0,0,0,8673,8674,1,0,0,0,8674,8675,1,0,0,0,8675,8698,3,1358,679,0,8676,
  	8678,5,398,0,0,8677,8679,5,6,0,0,8678,8677,1,0,0,0,8678,8679,1,0,0,0,
  	8679,8680,1,0,0,0,8680,8698,3,1404,702,0,8681,8683,7,148,0,0,8682,8684,
  	5,6,0,0,8683,8682,1,0,0,0,8683,8684,1,0,0,0,8684,8685,1,0,0,0,8685,8698,
  	3,1404,702,0,8686,8687,7,149,0,0,8687,8689,5,179,0,0,8688,8690,5,6,0,
  	0,8689,8688,1,0,0,0,8689,8690,1,0,0,0,8690,8691,1,0,0,0,8691,8698,3,1428,
  	714,0,8692,8694,5,119,0,0,8693,8695,5,6,0,0,8694,8693,1,0,0,0,8694,8695,
  	1,0,0,0,8695,8696,1,0,0,0,8696,8698,3,1428,714,0,8697,8663,1,0,0,0,8697,
  	8669,1,0,0,0,8697,8676,1,0,0,0,8697,8681,1,0,0,0,8697,8686,1,0,0,0,8697,
  	8692,1,0,0,0,8698,1209,1,0,0,0,8699,8700,5,587,0,0,8700,8704,3,1450,725,
  	0,8701,8703,3,1208,604,0,8702,8701,1,0,0,0,8703,8706,1,0,0,0,8704,8702,
  	1,0,0,0,8704,8705,1,0,0,0,8705,1211,1,0,0,0,8706,8704,1,0,0,0,8707,8708,
  	5,32,0,0,8708,8713,3,1214,607,0,8709,8710,5,29,0,0,8710,8712,3,1214,607,
  	0,8711,8709,1,0,0,0,8712,8715,1,0,0,0,8713,8711,1,0,0,0,8713,8714,1,0,
  	0,0,8714,8716,1,0,0,0,8715,8713,1,0,0,0,8716,8717,5,33,0,0,8717,1213,
  	1,0,0,0,8718,8721,3,908,454,0,8719,8721,5,361,0,0,8720,8718,1,0,0,0,8720,
  	8719,1,0,0,0,8721,1215,1,0,0,0,8722,8723,5,170,0,0,8723,8724,5,6,0,0,
  	8724,8725,3,1290,645,0,8725,1217,1,0,0,0,8726,8727,5,267,0,0,8727,8728,
  	5,213,0,0,8728,1219,1,0,0,0,8729,8731,3,1218,609,0,8730,8729,1,0,0,0,
  	8730,8731,1,0,0,0,8731,8732,1,0,0,0,8732,8733,3,1222,611,0,8733,1221,
  	1,0,0,0,8734,8742,3,1390,695,0,8735,8739,4,611,234,0,8736,8740,3,1396,
  	698,0,8737,8738,5,168,0,0,8738,8740,3,1400,700,0,8739,8736,1,0,0,0,8739,
  	8737,1,0,0,0,8740,8742,1,0,0,0,8741,8734,1,0,0,0,8741,8735,1,0,0,0,8742,
  	1223,1,0,0,0,8743,8744,5,267,0,0,8744,8745,3,992,496,0,8745,8746,5,213,
  	0,0,8746,1225,1,0,0,0,8747,8748,5,268,0,0,8748,8749,5,636,0,0,8749,8750,
  	5,644,0,0,8750,1227,1,0,0,0,8751,8753,7,150,0,0,8752,8751,1,0,0,0,8752,
  	8753,1,0,0,0,8753,8754,1,0,0,0,8754,8755,3,1230,615,0,8755,1229,1,0,0,
  	0,8756,8757,3,1372,686,0,8757,8758,3,1234,617,0,8758,1231,1,0,0,0,8759,
  	8760,5,113,0,0,8760,8761,3,1174,587,0,8761,1233,1,0,0,0,8762,8764,3,1150,
  	575,0,8763,8765,3,1232,616,0,8764,8763,1,0,0,0,8764,8765,1,0,0,0,8765,
  	1235,1,0,0,0,8766,8767,5,32,0,0,8767,8768,3,1322,661,0,8768,8769,5,29,
  	0,0,8769,8770,3,1322,661,0,8770,8771,5,33,0,0,8771,1237,1,0,0,0,8772,
  	8777,3,1338,669,0,8773,8774,5,29,0,0,8774,8776,3,1338,669,0,8775,8773,
  	1,0,0,0,8776,8779,1,0,0,0,8777,8775,1,0,0,0,8777,8778,1,0,0,0,8778,1239,
  	1,0,0,0,8779,8777,1,0,0,0,8780,8785,3,1242,621,0,8781,8782,5,29,0,0,8782,
  	8784,3,1242,621,0,8783,8781,1,0,0,0,8784,8787,1,0,0,0,8785,8783,1,0,0,
  	0,8785,8786,1,0,0,0,8786,1241,1,0,0,0,8787,8785,1,0,0,0,8788,8789,3,1310,
  	655,0,8789,8792,5,6,0,0,8790,8793,3,898,449,0,8791,8793,5,168,0,0,8792,
  	8790,1,0,0,0,8792,8791,1,0,0,0,8793,1243,1,0,0,0,8794,8795,3,990,495,
  	0,8795,8796,3,1172,586,0,8796,1245,1,0,0,0,8797,8799,5,115,0,0,8798,8800,
  	3,1248,624,0,8799,8798,1,0,0,0,8800,8801,1,0,0,0,8801,8799,1,0,0,0,8801,
  	8802,1,0,0,0,8802,1247,1,0,0,0,8803,8804,5,605,0,0,8804,8805,5,90,0,0,
  	8805,8816,3,1424,712,0,8806,8808,5,422,0,0,8807,8806,1,0,0,0,8807,8808,
  	1,0,0,0,8808,8809,1,0,0,0,8809,8810,5,196,0,0,8810,8811,5,90,0,0,8811,
  	8816,3,1424,712,0,8812,8813,5,206,0,0,8813,8814,5,90,0,0,8814,8816,3,
  	1424,712,0,8815,8803,1,0,0,0,8815,8807,1,0,0,0,8815,8812,1,0,0,0,8816,
  	1249,1,0,0,0,8817,8819,5,312,0,0,8818,8820,3,1252,626,0,8819,8818,1,0,
  	0,0,8820,8821,1,0,0,0,8821,8819,1,0,0,0,8821,8822,1,0,0,0,8822,1251,1,
  	0,0,0,8823,8824,7,151,0,0,8824,8825,5,90,0,0,8825,8826,3,1424,712,0,8826,
  	1253,1,0,0,0,8827,8832,3,1290,645,0,8828,8829,5,29,0,0,8829,8831,3,1290,
  	645,0,8830,8828,1,0,0,0,8831,8834,1,0,0,0,8832,8830,1,0,0,0,8832,8833,
  	1,0,0,0,8833,1255,1,0,0,0,8834,8832,1,0,0,0,8835,8840,3,1258,629,0,8836,
  	8837,5,29,0,0,8837,8839,3,1258,629,0,8838,8836,1,0,0,0,8839,8842,1,0,
  	0,0,8840,8838,1,0,0,0,8840,8841,1,0,0,0,8841,1257,1,0,0,0,8842,8840,1,
  	0,0,0,8843,8856,3,1290,645,0,8844,8847,3,1262,631,0,8845,8846,4,629,235,
  	0,8846,8848,3,1260,630,0,8847,8845,1,0,0,0,8847,8848,1,0,0,0,8848,8857,
  	1,0,0,0,8849,8852,3,1268,634,0,8850,8851,4,629,236,0,8851,8853,3,1276,
  	638,0,8852,8850,1,0,0,0,8852,8853,1,0,0,0,8853,8857,1,0,0,0,8854,8855,
  	4,629,237,0,8855,8857,3,1260,630,0,8856,8844,1,0,0,0,8856,8849,1,0,0,
  	0,8856,8854,1,0,0,0,8856,8857,1,0,0,0,8857,1259,1,0,0,0,8858,8859,5,61,
  	0,0,8859,8862,3,1262,631,0,8860,8861,5,61,0,0,8861,8863,3,1262,631,0,
  	8862,8860,1,0,0,0,8862,8863,1,0,0,0,8863,1261,1,0,0,0,8864,8874,3,1264,
  	632,0,8865,8866,4,631,238,0,8866,8874,3,1266,633,0,8867,8874,3,1268,634,
  	0,8868,8874,3,1270,635,0,8869,8870,4,631,239,0,8870,8874,3,1272,636,0,
  	8871,8872,4,631,240,0,8872,8874,3,1274,637,0,8873,8864,1,0,0,0,8873,8865,
  	1,0,0,0,8873,8867,1,0,0,0,8873,8868,1,0,0,0,8873,8869,1,0,0,0,8873,8871,
  	1,0,0,0,8874,1263,1,0,0,0,8875,8876,5,266,0,0,8876,8879,5,90,0,0,8877,
  	8878,4,632,241,0,8878,8880,5,436,0,0,8879,8877,1,0,0,0,8879,8880,1,0,
  	0,0,8880,8881,1,0,0,0,8881,8882,3,1422,711,0,8882,1265,1,0,0,0,8883,8884,
  	5,266,0,0,8884,8885,5,90,0,0,8885,8886,5,759,0,0,8886,8887,5,436,0,0,
  	8887,1267,1,0,0,0,8888,8889,5,266,0,0,8889,8890,5,670,0,0,8890,8891,3,
  	1450,725,0,8891,1269,1,0,0,0,8892,8893,5,266,0,0,8893,8894,5,670,0,0,
  	8894,8895,3,1450,725,0,8895,8896,5,63,0,0,8896,8897,3,1426,713,0,8897,
  	1271,1,0,0,0,8898,8899,5,266,0,0,8899,8900,5,670,0,0,8900,8901,3,1450,
  	725,0,8901,8902,5,90,0,0,8902,8903,3,1422,711,0,8903,1273,1,0,0,0,8904,
  	8905,5,266,0,0,8905,8906,5,670,0,0,8906,8907,3,1450,725,0,8907,8908,5,
  	90,0,0,8908,8909,5,759,0,0,8909,8910,5,436,0,0,8910,1275,1,0,0,0,8911,
  	8912,5,817,0,0,8912,8916,5,811,0,0,8913,8917,3,1266,633,0,8914,8917,3,
  	1270,635,0,8915,8917,3,1264,632,0,8916,8913,1,0,0,0,8916,8914,1,0,0,0,
  	8916,8915,1,0,0,0,8917,1277,1,0,0,0,8918,8919,5,752,0,0,8919,8920,5,144,
  	0,0,8920,8921,5,436,0,0,8921,1279,1,0,0,0,8922,8923,5,181,0,0,8923,8924,
  	5,753,0,0,8924,8925,5,436,0,0,8925,1281,1,0,0,0,8926,8927,3,1284,642,
  	0,8927,8928,5,814,0,0,8928,8929,5,815,0,0,8929,8942,1,0,0,0,8930,8931,
  	3,1284,642,0,8931,8932,5,816,0,0,8932,8942,1,0,0,0,8933,8934,3,1284,642,
  	0,8934,8935,5,813,0,0,8935,8936,5,815,0,0,8936,8937,5,533,0,0,8937,8938,
  	5,818,0,0,8938,8939,5,63,0,0,8939,8940,3,1426,713,0,8940,8942,1,0,0,0,
  	8941,8926,1,0,0,0,8941,8930,1,0,0,0,8941,8933,1,0,0,0,8942,1283,1,0,0,
  	0,8943,8944,3,1434,717,0,8944,8945,5,812,0,0,8945,1285,1,0,0,0,8946,8947,
  	5,488,0,0,8947,8948,3,1424,712,0,8948,1287,1,0,0,0,8949,8955,3,1450,725,
  	0,8950,8953,5,39,0,0,8951,8954,3,1450,725,0,8952,8954,5,845,0,0,8953,
  	8951,1,0,0,0,8953,8952,1,0,0,0,8954,8956,1,0,0,0,8955,8950,1,0,0,0,8955,
  	8956,1,0,0,0,8956,1289,1,0,0,0,8957,8963,3,1288,644,0,8958,8960,5,147,
  	0,0,8959,8961,3,1458,729,0,8960,8959,1,0,0,0,8960,8961,1,0,0,0,8961,8963,
  	1,0,0,0,8962,8957,1,0,0,0,8962,8958,1,0,0,0,8963,1291,1,0,0,0,8964,8965,
  	5,309,0,0,8965,8966,3,1422,711,0,8966,1293,1,0,0,0,8967,8970,3,1292,646,
  	0,8968,8970,3,388,194,0,8969,8967,1,0,0,0,8969,8968,1,0,0,0,8970,1295,
  	1,0,0,0,8971,8972,7,152,0,0,8972,1297,1,0,0,0,8973,8974,7,153,0,0,8974,
  	1299,1,0,0,0,8975,8976,5,435,0,0,8976,8977,3,1394,697,0,8977,1301,1,0,
  	0,0,8978,8984,3,1400,700,0,8979,8981,3,1396,698,0,8980,8982,3,1400,700,
  	0,8981,8980,1,0,0,0,8981,8982,1,0,0,0,8982,8984,1,0,0,0,8983,8978,1,0,
  	0,0,8983,8979,1,0,0,0,8984,1303,1,0,0,0,8985,8986,4,652,242,0,8986,8990,
  	3,1390,695,0,8987,8988,4,652,243,0,8988,8990,3,1302,651,0,8989,8985,1,
  	0,0,0,8989,8987,1,0,0,0,8990,1305,1,0,0,0,8991,8992,3,1390,695,0,8992,
  	1307,1,0,0,0,8993,8994,5,32,0,0,8994,8999,3,1306,653,0,8995,8996,5,29,
  	0,0,8996,8998,3,1306,653,0,8997,8995,1,0,0,0,8998,9001,1,0,0,0,8999,8997,
  	1,0,0,0,8999,9000,1,0,0,0,9000,9002,1,0,0,0,9001,8999,1,0,0,0,9002,9003,
  	5,33,0,0,9003,1309,1,0,0,0,9004,9005,3,1302,651,0,9005,1311,1,0,0,0,9006,
  	9009,3,1310,655,0,9007,9009,3,1318,659,0,9008,9006,1,0,0,0,9008,9007,
  	1,0,0,0,9009,1313,1,0,0,0,9010,9011,3,1390,695,0,9011,1315,1,0,0,0,9012,
  	9013,3,1302,651,0,9013,1317,1,0,0,0,9014,9015,3,1390,695,0,9015,9019,
  	5,28,0,0,9016,9017,3,1390,695,0,9017,9018,5,28,0,0,9018,9020,1,0,0,0,
  	9019,9016,1,0,0,0,9019,9020,1,0,0,0,9020,9021,1,0,0,0,9021,9022,5,16,
  	0,0,9022,1319,1,0,0,0,9023,9024,3,1390,695,0,9024,1321,1,0,0,0,9025,9026,
  	3,1390,695,0,9026,1323,1,0,0,0,9027,9028,3,1396,698,0,9028,1325,1,0,0,
  	0,9029,9030,3,1396,698,0,9030,1327,1,0,0,0,9031,9032,3,1396,698,0,9032,
  	1329,1,0,0,0,9033,9034,3,1396,698,0,9034,1331,1,0,0,0,9035,9036,3,1396,
  	698,0,9036,1333,1,0,0,0,9037,9038,3,1396,698,0,9038,1335,1,0,0,0,9039,
  	9042,3,1396,698,0,9040,9042,3,1400,700,0,9041,9039,1,0,0,0,9041,9040,
  	1,0,0,0,9042,1337,1,0,0,0,9043,9046,3,1396,698,0,9044,9046,3,1400,700,
  	0,9045,9043,1,0,0,0,9045,9044,1,0,0,0,9046,1339,1,0,0,0,9047,9048,3,1390,
  	695,0,9048,1341,1,0,0,0,9049,9050,3,1390,695,0,9050,1343,1,0,0,0,9051,
  	9052,3,1390,695,0,9052,1345,1,0,0,0,9053,9054,3,1390,695,0,9054,1347,
  	1,0,0,0,9055,9056,3,1396,698,0,9056,1349,1,0,0,0,9057,9058,3,1396,698,
  	0,9058,1351,1,0,0,0,9059,9060,3,1390,695,0,9060,1353,1,0,0,0,9061,9062,
  	3,1450,725,0,9062,1355,1,0,0,0,9063,9064,3,1450,725,0,9064,1357,1,0,0,
  	0,9065,9066,3,1450,725,0,9066,1359,1,0,0,0,9067,9070,3,1396,698,0,9068,
  	9070,3,1400,700,0,9069,9067,1,0,0,0,9069,9068,1,0,0,0,9070,1361,1,0,0,
  	0,9071,9072,3,1322,661,0,9072,9073,3,1400,700,0,9073,1363,1,0,0,0,9074,
  	9082,3,1390,695,0,9075,9076,5,28,0,0,9076,9083,5,16,0,0,9077,9080,3,1400,
  	700,0,9078,9079,5,28,0,0,9079,9081,5,16,0,0,9080,9078,1,0,0,0,9080,9081,
  	1,0,0,0,9081,9083,1,0,0,0,9082,9075,1,0,0,0,9082,9077,1,0,0,0,9082,9083,
  	1,0,0,0,9083,1365,1,0,0,0,9084,9087,3,1396,698,0,9085,9087,3,1400,700,
  	0,9086,9084,1,0,0,0,9086,9085,1,0,0,0,9087,1367,1,0,0,0,9088,9093,3,1366,
  	683,0,9089,9090,5,29,0,0,9090,9092,3,1366,683,0,9091,9089,1,0,0,0,9092,
  	9095,1,0,0,0,9093,9091,1,0,0,0,9093,9094,1,0,0,0,9094,1369,1,0,0,0,9095,
  	9093,1,0,0,0,9096,9101,3,1364,682,0,9097,9098,5,29,0,0,9098,9100,3,1364,
  	682,0,9099,9097,1,0,0,0,9100,9103,1,0,0,0,9101,9099,1,0,0,0,9101,9102,
  	1,0,0,0,9102,1371,1,0,0,0,9103,9101,1,0,0,0,9104,9105,3,1390,695,0,9105,
  	1373,1,0,0,0,9106,9109,3,1388,694,0,9107,9109,3,1476,738,0,9108,9106,
  	1,0,0,0,9108,9107,1,0,0,0,9109,1375,1,0,0,0,9110,9111,3,1374,687,0,9111,
  	1377,1,0,0,0,9112,9115,3,1388,694,0,9113,9115,3,1482,741,0,9114,9112,
  	1,0,0,0,9114,9113,1,0,0,0,9115,1379,1,0,0,0,9116,9117,3,1390,695,0,9117,
  	1381,1,0,0,0,9118,9119,3,1422,711,0,9119,1383,1,0,0,0,9120,9121,3,1390,
  	695,0,9121,1385,1,0,0,0,9122,9123,3,1390,695,0,9123,1387,1,0,0,0,9124,
  	9128,7,154,0,0,9125,9126,4,694,244,0,9126,9128,5,835,0,0,9127,9124,1,
  	0,0,0,9127,9125,1,0,0,0,9128,1389,1,0,0,0,9129,9132,3,1388,694,0,9130,
  	9132,3,1470,735,0,9131,9129,1,0,0,0,9131,9130,1,0,0,0,9132,1391,1,0,0,
  	0,9133,9138,3,1390,695,0,9134,9135,5,29,0,0,9135,9137,3,1390,695,0,9136,
  	9134,1,0,0,0,9137,9140,1,0,0,0,9138,9136,1,0,0,0,9138,9139,1,0,0,0,9139,
  	1393,1,0,0,0,9140,9138,1,0,0,0,9141,9142,5,32,0,0,9142,9143,3,1392,696,
  	0,9143,9144,5,33,0,0,9144,1395,1,0,0,0,9145,9147,3,1390,695,0,9146,9148,
  	3,1400,700,0,9147,9146,1,0,0,0,9147,9148,1,0,0,0,9148,1397,1,0,0,0,9149,
  	9154,3,1390,695,0,9150,9152,3,1400,700,0,9151,9153,3,1400,700,0,9152,
  	9151,1,0,0,0,9152,9153,1,0,0,0,9153,9155,1,0,0,0,9154,9150,1,0,0,0,9154,
  	9155,1,0,0,0,9155,9161,1,0,0,0,9156,9157,4,699,245,0,9157,9158,3,1400,
  	700,0,9158,9159,3,1400,700,0,9159,9161,1,0,0,0,9160,9149,1,0,0,0,9160,
  	9156,1,0,0,0,9161,1399,1,0,0,0,9162,9163,5,28,0,0,9163,9164,3,1390,695,
  	0,9164,1401,1,0,0,0,9165,9166,7,155,0,0,9166,1403,1,0,0,0,9167,9168,7,
  	156,0,0,9168,1405,1,0,0,0,9169,9170,7,157,0,0,9170,1407,1,0,0,0,9171,
  	9177,5,3,0,0,9172,9173,4,704,246,0,9173,9177,5,43,0,0,9174,9177,5,5,0,
  	0,9175,9177,5,4,0,0,9176,9171,1,0,0,0,9176,9172,1,0,0,0,9176,9174,1,0,
  	0,0,9176,9175,1,0,0,0,9177,1409,1,0,0,0,9178,9184,3,1414,707,0,9179,9180,
  	5,14,0,0,9180,9184,3,1402,701,0,9181,9182,5,15,0,0,9182,9184,3,1402,701,
  	0,9183,9178,1,0,0,0,9183,9179,1,0,0,0,9183,9181,1,0,0,0,9184,1411,1,0,
  	0,0,9185,9189,3,1410,705,0,9186,9187,4,706,247,0,9187,9189,3,1418,709,
  	0,9188,9185,1,0,0,0,9188,9186,1,0,0,0,9189,1413,1,0,0,0,9190,9200,3,1428,
  	714,0,9191,9200,3,1434,717,0,9192,9200,3,1442,721,0,9193,9200,3,1438,
  	719,0,9194,9200,3,1436,718,0,9195,9197,5,831,0,0,9196,9195,1,0,0,0,9196,
  	9197,1,0,0,0,9197,9198,1,0,0,0,9198,9200,7,158,0,0,9199,9190,1,0,0,0,
  	9199,9191,1,0,0,0,9199,9192,1,0,0,0,9199,9193,1,0,0,0,9199,9194,1,0,0,
  	0,9199,9196,1,0,0,0,9200,1415,1,0,0,0,9201,9205,3,1414,707,0,9202,9203,
  	4,708,248,0,9203,9205,3,1418,709,0,9204,9201,1,0,0,0,9204,9202,1,0,0,
  	0,9205,1417,1,0,0,0,9206,9207,5,406,0,0,9207,1419,1,0,0,0,9208,9209,5,
  	32,0,0,9209,9214,3,1424,712,0,9210,9211,5,29,0,0,9211,9213,3,1424,712,
  	0,9212,9210,1,0,0,0,9213,9216,1,0,0,0,9214,9212,1,0,0,0,9214,9215,1,0,
  	0,0,9215,9217,1,0,0,0,9216,9214,1,0,0,0,9217,9218,5,33,0,0,9218,1421,
  	1,0,0,0,9219,9223,5,836,0,0,9220,9221,4,711,249,0,9221,9223,5,835,0,0,
  	9222,9219,1,0,0,0,9222,9220,1,0,0,0,9223,1423,1,0,0,0,9224,9228,3,1422,
  	711,0,9225,9228,5,43,0,0,9226,9228,5,44,0,0,9227,9224,1,0,0,0,9227,9225,
  	1,0,0,0,9227,9226,1,0,0,0,9228,1425,1,0,0,0,9229,9233,3,1422,711,0,9230,
  	9231,4,713,250,0,9231,9233,5,43,0,0,9232,9229,1,0,0,0,9232,9230,1,0,0,
  	0,9233,1427,1,0,0,0,9234,9236,5,831,0,0,9235,9234,1,0,0,0,9235,9236,1,
  	0,0,0,9236,9237,1,0,0,0,9237,9240,3,1422,711,0,9238,9240,5,833,0,0,9239,
  	9235,1,0,0,0,9239,9238,1,0,0,0,9240,9244,1,0,0,0,9241,9243,3,1422,711,
  	0,9242,9241,1,0,0,0,9243,9246,1,0,0,0,9244,9242,1,0,0,0,9244,9245,1,0,
  	0,0,9245,1429,1,0,0,0,9246,9244,1,0,0,0,9247,9248,3,1422,711,0,9248,1431,
  	1,0,0,0,9249,9254,3,1422,711,0,9250,9251,5,29,0,0,9251,9253,3,1422,711,
  	0,9252,9250,1,0,0,0,9253,9256,1,0,0,0,9254,9252,1,0,0,0,9254,9255,1,0,
  	0,0,9255,1433,1,0,0,0,9256,9254,1,0,0,0,9257,9261,3,1440,720,0,9258,9261,
  	5,45,0,0,9259,9261,5,46,0,0,9260,9257,1,0,0,0,9260,9258,1,0,0,0,9260,
  	9259,1,0,0,0,9261,1435,1,0,0,0,9262,9263,7,159,0,0,9263,1437,1,0,0,0,
  	9264,9265,7,160,0,0,9265,1439,1,0,0,0,9266,9267,7,161,0,0,9267,1441,1,
  	0,0,0,9268,9269,5,158,0,0,9269,9275,5,836,0,0,9270,9271,5,612,0,0,9271,
  	9275,5,836,0,0,9272,9273,5,609,0,0,9273,9275,5,836,0,0,9274,9268,1,0,
  	0,0,9274,9270,1,0,0,0,9274,9272,1,0,0,0,9275,1443,1,0,0,0,9276,9279,3,
  	1156,578,0,9277,9279,3,1448,724,0,9278,9276,1,0,0,0,9278,9277,1,0,0,0,
  	9279,1445,1,0,0,0,9280,9281,3,1448,724,0,9281,1447,1,0,0,0,9282,9283,
  	5,32,0,0,9283,9284,5,3,0,0,9284,9285,5,29,0,0,9285,9286,5,3,0,0,9286,
  	9287,5,33,0,0,9287,1449,1,0,0,0,9288,9291,3,1390,695,0,9289,9291,3,1422,
  	711,0,9290,9288,1,0,0,0,9290,9289,1,0,0,0,9291,1451,1,0,0,0,9292,9295,
  	3,1388,694,0,9293,9295,3,1484,742,0,9294,9292,1,0,0,0,9294,9293,1,0,0,
  	0,9295,1453,1,0,0,0,9296,9299,3,1378,689,0,9297,9299,3,1422,711,0,9298,
  	9296,1,0,0,0,9298,9297,1,0,0,0,9299,1455,1,0,0,0,9300,9303,3,1408,704,
  	0,9301,9303,3,1388,694,0,9302,9300,1,0,0,0,9302,9301,1,0,0,0,9303,1457,
  	1,0,0,0,9304,9305,5,32,0,0,9305,9306,5,33,0,0,9306,1459,1,0,0,0,9307,
  	9308,7,162,0,0,9308,1461,1,0,0,0,9309,9310,4,731,251,0,9310,9317,5,683,
  	0,0,9311,9312,4,731,252,0,9312,9317,5,698,0,0,9313,9317,5,250,0,0,9314,
  	9317,5,316,0,0,9315,9317,5,529,0,0,9316,9309,1,0,0,0,9316,9311,1,0,0,
  	0,9316,9313,1,0,0,0,9316,9314,1,0,0,0,9316,9315,1,0,0,0,9317,1463,1,0,
  	0,0,9318,9319,5,250,0,0,9319,9325,5,28,0,0,9320,9321,5,316,0,0,9321,9325,
  	5,28,0,0,9322,9323,5,529,0,0,9323,9325,5,28,0,0,9324,9318,1,0,0,0,9324,
  	9320,1,0,0,0,9324,9322,1,0,0,0,9325,1465,1,0,0,0,9326,9327,4,733,253,
  	0,9327,9334,5,683,0,0,9328,9329,4,733,254,0,9329,9334,5,698,0,0,9330,
  	9334,5,250,0,0,9331,9334,5,316,0,0,9332,9334,5,529,0,0,9333,9326,1,0,
  	0,0,9333,9328,1,0,0,0,9333,9330,1,0,0,0,9333,9331,1,0,0,0,9333,9332,1,
  	0,0,0,9334,9335,1,0,0,0,9335,9336,5,28,0,0,9336,1467,1,0,0,0,9337,9338,
  	3,1422,711,0,9338,1469,1,0,0,0,9339,9347,4,735,255,0,9340,9348,3,1476,
  	738,0,9341,9348,3,1488,744,0,9342,9348,5,212,0,0,9343,9344,4,735,256,
  	0,9344,9348,5,537,0,0,9345,9346,4,735,257,0,9346,9348,5,739,0,0,9347,
  	9340,1,0,0,0,9347,9341,1,0,0,0,9347,9342,1,0,0,0,9347,9343,1,0,0,0,9347,
  	9345,1,0,0,0,9348,9357,1,0,0,0,9349,9355,3,1480,740,0,9350,9355,3,1472,
  	736,0,9351,9355,3,1474,737,0,9352,9355,3,1478,739,0,9353,9355,3,1486,
  	743,0,9354,9349,1,0,0,0,9354,9350,1,0,0,0,9354,9351,1,0,0,0,9354,9352,
  	1,0,0,0,9354,9353,1,0,0,0,9355,9357,1,0,0,0,9356,9339,1,0,0,0,9356,9354,
  	1,0,0,0,9357,1471,1,0,0,0,9358,9359,7,163,0,0,9359,1473,1,0,0,0,9360,
  	9361,7,164,0,0,9361,1475,1,0,0,0,9362,9373,4,738,258,0,9363,9374,3,1490,
  	745,0,9364,9374,5,209,0,0,9365,9374,5,226,0,0,9366,9374,5,399,0,0,9367,
  	9374,5,453,0,0,9368,9374,5,457,0,0,9369,9374,5,481,0,0,9370,9374,5,489,
  	0,0,9371,9374,5,734,0,0,9372,9374,5,591,0,0,9373,9363,1,0,0,0,9373,9364,
  	1,0,0,0,9373,9365,1,0,0,0,9373,9366,1,0,0,0,9373,9367,1,0,0,0,9373,9368,
  	1,0,0,0,9373,9369,1,0,0,0,9373,9370,1,0,0,0,9373,9371,1,0,0,0,9373,9372,
  	1,0,0,0,9374,9381,1,0,0,0,9375,9379,3,1480,740,0,9376,9379,3,1478,739,
  	0,9377,9379,3,1486,743,0,9378,9375,1,0,0,0,9378,9376,1,0,0,0,9378,9377,
  	1,0,0,0,9379,9381,1,0,0,0,9380,9362,1,0,0,0,9380,9378,1,0,0,0,9381,1477,
  	1,0,0,0,9382,9383,7,165,0,0,9383,1479,1,0,0,0,9384,9390,7,166,0,0,9385,
  	9386,4,740,259,0,9386,9390,7,167,0,0,9387,9388,4,740,260,0,9388,9390,
  	7,168,0,0,9389,9384,1,0,0,0,9389,9385,1,0,0,0,9389,9387,1,0,0,0,9390,
  	1481,1,0,0,0,9391,9394,4,741,261,0,9392,9395,3,1490,745,0,9393,9395,3,
  	1488,744,0,9394,9392,1,0,0,0,9394,9393,1,0,0,0,9395,9402,1,0,0,0,9396,
  	9400,3,1480,740,0,9397,9400,3,1474,737,0,9398,9400,3,1486,743,0,9399,
  	9396,1,0,0,0,9399,9397,1,0,0,0,9399,9398,1,0,0,0,9400,9402,1,0,0,0,9401,
  	9391,1,0,0,0,9401,9399,1,0,0,0,9402,1483,1,0,0,0,9403,9408,3,1480,740,
  	0,9404,9408,3,1472,736,0,9405,9408,3,1474,737,0,9406,9408,3,1478,739,
  	0,9407,9403,1,0,0,0,9407,9404,1,0,0,0,9407,9405,1,0,0,0,9407,9406,1,0,
  	0,0,9408,1485,1,0,0,0,9409,9410,7,169,0,0,9410,1487,1,0,0,0,9411,9417,
  	7,170,0,0,9412,9413,4,744,262,0,9413,9417,5,537,0,0,9414,9415,4,744,263,
  	0,9415,9417,5,270,0,0,9416,9411,1,0,0,0,9416,9412,1,0,0,0,9416,9414,1,
  	0,0,0,9417,1489,1,0,0,0,9418,9430,7,171,0,0,9419,9420,4,745,264,0,9420,
  	9430,5,537,0,0,9421,9422,4,745,265,0,9422,9430,7,172,0,0,9423,9424,4,
  	745,266,0,9424,9430,7,173,0,0,9425,9426,4,745,267,0,9426,9430,5,685,0,
  	0,9427,9428,4,745,268,0,9428,9430,5,338,0,0,9429,9418,1,0,0,0,9429,9419,
  	1,0,0,0,9429,9421,1,0,0,0,9429,9423,1,0,0,0,9429,9425,1,0,0,0,9429,9427,
  	1,0,0,0,9430,1491,1,0,0,0,1193,1494,1497,1499,1583,1591,1596,1606,1613,
  	1620,1626,1629,1632,1639,1644,1647,1652,1658,1660,1664,1668,1677,1681,
  	1686,1692,1699,1704,1709,1716,1719,1725,1728,1735,1745,1750,1755,1763,
  	1769,1773,1778,1787,1793,1799,1805,1814,1820,1829,1843,1847,1853,1857,
  	1863,1867,1872,1875,1881,1887,1893,1897,1902,1906,1910,1926,1934,1942,
  	1949,1978,1993,1996,2005,2010,2016,2021,2025,2030,2034,2038,2042,2046,
  	2050,2052,2063,2071,2078,2086,2090,2095,2102,2107,2112,2122,2126,2131,
  	2134,2137,2140,2147,2154,2158,2177,2183,2193,2196,2217,2221,2227,2234,
  	2237,2241,2248,2251,2260,2267,2272,2275,2280,2286,2289,2293,2299,2302,
  	2307,2312,2321,2324,2330,2337,2343,2346,2351,2360,2363,2371,2377,2382,
  	2392,2395,2400,2408,2423,2426,2429,2434,2440,2450,2460,2463,2466,2470,
  	2478,2491,2495,2500,2509,2526,2545,2554,2557,2565,2572,2574,2581,2586,
  	2601,2605,2611,2617,2623,2629,2635,2640,2644,2652,2658,2664,2670,2675,
  	2678,2681,2690,2693,2704,2709,2720,2728,2732,2741,2744,2750,2752,2756,
  	2763,2776,2783,2789,2792,2809,2829,2833,2839,2845,2851,2856,2863,2870,
  	2875,2878,2882,2886,2891,2895,2899,2905,2910,2913,2917,2923,2927,2931,
  	2939,2947,2956,2965,2978,2981,2985,2991,2999,3004,3007,3010,3013,3016,
  	3018,3024,3026,3040,3046,3053,3056,3058,3060,3070,3072,3076,3079,3082,
  	3086,3090,3095,3098,3101,3107,3110,3119,3129,3132,3135,3139,3145,3150,
  	3155,3160,3164,3171,3182,3185,3188,3191,3195,3198,3201,3207,3210,3213,
  	3216,3219,3223,3226,3229,3241,3249,3265,3268,3272,3276,3282,3287,3291,
  	3311,3314,3318,3324,3328,3331,3340,3350,3354,3358,3361,3365,3369,3374,
  	3377,3382,3388,3397,3403,3408,3411,3414,3417,3420,3424,3439,3443,3449,
  	3452,3455,3461,3466,3470,3473,3481,3483,3496,3508,3513,3516,3519,3524,
  	3530,3546,3566,3575,3579,3586,3591,3600,3610,3617,3628,3635,3644,3653,
  	3665,3671,3678,3682,3688,3693,3698,3702,3708,3714,3716,3719,3723,3733,
  	3738,3743,3750,3759,3767,3772,3776,3782,3785,3788,3792,3796,3806,3810,
  	3813,3816,3821,3827,3831,3837,3840,3842,3847,3859,3868,3881,3884,3889,
  	3896,3900,3903,3909,3923,3930,3939,3945,3954,3958,3962,3972,3974,3982,
  	3989,3994,3998,4002,4005,4011,4014,4017,4023,4030,4035,4039,4042,4045,
  	4048,4050,4054,4061,4067,4071,4076,4079,4082,4085,4087,4092,4101,4114,
  	4116,4120,4126,4129,4132,4138,4145,4147,4155,4161,4166,4169,4176,4178,
  	4189,4196,4204,4212,4216,4223,4226,4228,4236,4246,4255,4262,4269,4400,
  	4454,4461,4465,4481,4493,4496,4508,4513,4519,4526,4533,4540,4547,4554,
  	4561,4564,4571,4579,4587,4597,4603,4607,4610,4613,4616,4619,4622,4627,
  	4630,4637,4643,4667,4676,4680,4687,4693,4714,4720,4726,4733,4741,4747,
  	4759,4761,4767,4771,4773,4777,4789,4795,4801,4809,4813,4817,4823,4825,
  	4838,4842,4844,4846,4853,4864,4867,4869,4873,4878,4880,4885,4891,4894,
  	4896,4900,4903,4913,4923,4930,4932,4934,4942,4946,4952,4955,4957,4967,
  	4971,4977,4984,4986,4991,4993,5002,5010,5013,5018,5023,5026,5032,5038,
  	5041,5046,5057,5059,5071,5076,5084,5090,5092,5101,5103,5109,5121,5126,
  	5128,5132,5138,5141,5144,5154,5156,5162,5175,5179,5184,5201,5207,5217,
  	5225,5230,5236,5246,5250,5259,5265,5271,5273,5277,5288,5295,5301,5306,
  	5311,5316,5324,5328,5333,5342,5355,5357,5371,5380,5382,5389,5396,5398,
  	5402,5408,5416,5423,5427,5433,5440,5443,5456,5462,5467,5480,5483,5494,
  	5496,5502,5516,5533,5538,5541,5545,5548,5562,5568,5573,5576,5578,5582,
  	5587,5589,5601,5607,5622,5634,5638,5640,5648,5655,5670,5675,5679,5683,
  	5686,5690,5694,5697,5702,5705,5711,5714,5720,5723,5750,5756,5759,5774,
  	5781,5785,5788,5791,5798,5802,5805,5808,5813,5819,5822,5826,5847,5852,
  	5860,5865,5868,5872,5876,5880,5886,5890,5895,5900,5911,5913,5919,5942,
  	5945,5967,5974,6002,6004,6008,6020,6030,6040,6044,6052,6055,6059,6069,
  	6073,6080,6085,6093,6098,6104,6111,6116,6122,6129,6139,6141,6148,6153,
  	6157,6160,6167,6172,6176,6187,6195,6199,6202,6205,6209,6213,6218,6224,
  	6228,6239,6242,6245,6248,6256,6260,6265,6273,6281,6287,6291,6297,6306,
  	6319,6329,6347,6350,6354,6365,6367,6376,6388,6390,6397,6403,6409,6417,
  	6428,6432,6461,6463,6469,6488,6495,6509,6520,6525,6537,6547,6554,6557,
  	6591,6599,6601,6613,6618,6624,6632,6640,6645,6650,6656,6661,6666,6672,
  	6680,6689,6694,6698,6702,6707,6709,6727,6735,6739,6746,6758,6761,6765,
  	6770,6777,6781,6785,6790,6800,6809,6811,6814,6823,6830,6843,6848,6855,
  	6861,6887,6898,6930,6949,6955,6959,6990,6996,7008,7021,7025,7029,7057,
  	7107,7117,7121,7133,7138,7154,7174,7178,7194,7197,7202,7205,7214,7218,
  	7224,7230,7234,7245,7251,7253,7260,7267,7271,7278,7283,7290,7300,7303,
  	7307,7312,7314,7318,7322,7335,7339,7342,7346,7350,7354,7361,7365,7369,
  	7378,7382,7389,7395,7403,7424,7429,7436,7459,7475,7485,7489,7496,7499,
  	7510,7519,7522,7529,7534,7560,7566,7572,7576,7586,7590,7603,7615,7631,
  	7639,7649,7652,7657,7661,7668,7673,7680,7688,7691,7696,7704,7707,7721,
  	7724,7737,7741,7743,7748,7753,7760,7766,7772,7777,7780,7786,7791,7794,
  	7800,7804,7810,7812,7815,7821,7827,7834,7836,7838,7842,7848,7853,7857,
  	7862,7868,7875,7878,7880,7883,7893,7899,7906,7911,7925,7933,7939,7944,
  	7955,7959,7964,7968,7971,7976,7980,7988,7996,7998,8007,8015,8022,8025,
  	8033,8042,8044,8050,8054,8064,8070,8073,8084,8093,8096,8101,8103,8106,
  	8109,8113,8116,8120,8125,8128,8132,8135,8139,8144,8148,8160,8164,8170,
  	8173,8178,8182,8186,8191,8200,8203,8207,8211,8214,8218,8222,8227,8232,
  	8238,8243,8248,8250,8255,8262,8270,8276,8278,8282,8286,8290,8294,8309,
  	8315,8322,8326,8331,8336,8339,8343,8346,8351,8355,8361,8365,8369,8374,
  	8379,8384,8389,8395,8401,8406,8411,8416,8421,8426,8431,8436,8446,8452,
  	8458,8464,8467,8474,8479,8488,8494,8499,8503,8506,8510,8515,8519,8524,
  	8528,8537,8540,8543,8546,8550,8554,8558,8573,8576,8578,8583,8592,8595,
  	8599,8611,8623,8628,8633,8642,8647,8656,8661,8665,8669,8673,8678,8683,
  	8689,8694,8697,8704,8713,8720,8730,8739,8741,8752,8764,8777,8785,8792,
  	8801,8807,8815,8821,8832,8840,8847,8852,8856,8862,8873,8879,8916,8941,
  	8953,8955,8960,8962,8969,8981,8983,8989,8999,9008,9019,9041,9045,9069,
  	9080,9082,9086,9093,9101,9108,9114,9127,9131,9138,9147,9152,9154,9160,
  	9176,9183,9188,9196,9199,9204,9214,9222,9227,9232,9235,9239,9244,9254,
  	9260,9274,9278,9290,9294,9298,9302,9316,9324,9333,9347,9354,9356,9373,
  	9378,9380,9389,9394,9399,9401,9407,9416,9429
  };
  staticData->serializedATN = antlr4::atn::SerializedATNView(serializedATNSegment, sizeof(serializedATNSegment) / sizeof(serializedATNSegment[0]));

  antlr4::atn::ATNDeserializer deserializer;
  staticData->atn = deserializer.deserialize(staticData->serializedATN);

  const size_t count = staticData->atn->getNumberOfDecisions();
  staticData->decisionToDFA.reserve(count);
  for (size_t i = 0; i < count; i++) { 
    staticData->decisionToDFA.emplace_back(staticData->atn->getDecisionState(i), i);
  }
  mysqlparserParserStaticData = staticData.release();
}

}

MySQLParser::MySQLParser(TokenStream *input) : MySQLParser(input, antlr4::atn::ParserATNSimulatorOptions()) {}

MySQLParser::MySQLParser(TokenStream *input, const antlr4::atn::ParserATNSimulatorOptions &options) : MySQLBaseRecognizer(input) {
  MySQLParser::initialize();
  _interpreter = new atn::ParserATNSimulator(this, *mysqlparserParserStaticData->atn, mysqlparserParserStaticData->decisionToDFA, mysqlparserParserStaticData->sharedContextCache, options);
}

MySQLParser::~MySQLParser() {
  delete _interpreter;
}

const atn::ATN& MySQLParser::getATN() const {
  return *mysqlparserParserStaticData->atn;
}

std::string MySQLParser::getGrammarFileName() const {
  return "MySQLParser.g4";
}

const std::vector<std::string>& MySQLParser::getRuleNames() const {
  return mysqlparserParserStaticData->ruleNames;
}

const dfa::Vocabulary& MySQLParser::getVocabulary() const {
  return mysqlparserParserStaticData->vocabulary;
}

antlr4::atn::SerializedATNView MySQLParser::getSerializedATN() const {
  return mysqlparserParserStaticData->serializedATN;
}


//----------------- QueryContext ------------------------------------------------------------------

MySQLParser::QueryContext::QueryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QueryContext::EOF() {
  return getToken(MySQLParser::EOF, 0);
}

MySQLParser::SimpleStatementContext* MySQLParser::QueryContext::simpleStatement() {
  return getRuleContext<MySQLParser::SimpleStatementContext>(0);
}

MySQLParser::BeginWorkContext* MySQLParser::QueryContext::beginWork() {
  return getRuleContext<MySQLParser::BeginWorkContext>(0);
}

tree::TerminalNode* MySQLParser::QueryContext::SEMICOLON_SYMBOL() {
  return getToken(MySQLParser::SEMICOLON_SYMBOL, 0);
}


size_t MySQLParser::QueryContext::getRuleIndex() const {
  return MySQLParser::RuleQuery;
}

void MySQLParser::QueryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuery(this);
}

void MySQLParser::QueryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuery(this);
}


std::any MySQLParser::QueryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuery(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryContext* MySQLParser::query() {
  QueryContext *_localctx = _tracker.createInstance<QueryContext>(_ctx, getState());
  enterRule(_localctx, 0, MySQLParser::RuleQuery);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1499);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 2, _ctx)) {
    case 1: {
      setState(1494);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 0, _ctx)) {
      case 1: {
        setState(1492);
        simpleStatement();
        break;
      }

      case 2: {
        setState(1493);
        beginWork();
        break;
      }

      default:
        break;
      }
      setState(1497);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::SEMICOLON_SYMBOL) {
        setState(1496);
        match(MySQLParser::SEMICOLON_SYMBOL);
      }
      break;
    }

    default:
      break;
    }
    setState(1501);
    match(MySQLParser::EOF);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SimpleStatementContext ------------------------------------------------------------------

MySQLParser::SimpleStatementContext::SimpleStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterStatementContext* MySQLParser::SimpleStatementContext::alterStatement() {
  return getRuleContext<MySQLParser::AlterStatementContext>(0);
}

MySQLParser::CreateStatementContext* MySQLParser::SimpleStatementContext::createStatement() {
  return getRuleContext<MySQLParser::CreateStatementContext>(0);
}

MySQLParser::DropStatementContext* MySQLParser::SimpleStatementContext::dropStatement() {
  return getRuleContext<MySQLParser::DropStatementContext>(0);
}

MySQLParser::RenameTableStatementContext* MySQLParser::SimpleStatementContext::renameTableStatement() {
  return getRuleContext<MySQLParser::RenameTableStatementContext>(0);
}

MySQLParser::TruncateTableStatementContext* MySQLParser::SimpleStatementContext::truncateTableStatement() {
  return getRuleContext<MySQLParser::TruncateTableStatementContext>(0);
}

MySQLParser::ImportStatementContext* MySQLParser::SimpleStatementContext::importStatement() {
  return getRuleContext<MySQLParser::ImportStatementContext>(0);
}

MySQLParser::CallStatementContext* MySQLParser::SimpleStatementContext::callStatement() {
  return getRuleContext<MySQLParser::CallStatementContext>(0);
}

MySQLParser::DeleteStatementContext* MySQLParser::SimpleStatementContext::deleteStatement() {
  return getRuleContext<MySQLParser::DeleteStatementContext>(0);
}

MySQLParser::DoStatementContext* MySQLParser::SimpleStatementContext::doStatement() {
  return getRuleContext<MySQLParser::DoStatementContext>(0);
}

MySQLParser::HandlerStatementContext* MySQLParser::SimpleStatementContext::handlerStatement() {
  return getRuleContext<MySQLParser::HandlerStatementContext>(0);
}

MySQLParser::InsertStatementContext* MySQLParser::SimpleStatementContext::insertStatement() {
  return getRuleContext<MySQLParser::InsertStatementContext>(0);
}

MySQLParser::LoadStatementContext* MySQLParser::SimpleStatementContext::loadStatement() {
  return getRuleContext<MySQLParser::LoadStatementContext>(0);
}

MySQLParser::ReplaceStatementContext* MySQLParser::SimpleStatementContext::replaceStatement() {
  return getRuleContext<MySQLParser::ReplaceStatementContext>(0);
}

MySQLParser::SelectStatementContext* MySQLParser::SimpleStatementContext::selectStatement() {
  return getRuleContext<MySQLParser::SelectStatementContext>(0);
}

MySQLParser::UpdateStatementContext* MySQLParser::SimpleStatementContext::updateStatement() {
  return getRuleContext<MySQLParser::UpdateStatementContext>(0);
}

MySQLParser::TransactionOrLockingStatementContext* MySQLParser::SimpleStatementContext::transactionOrLockingStatement() {
  return getRuleContext<MySQLParser::TransactionOrLockingStatementContext>(0);
}

MySQLParser::ReplicationStatementContext* MySQLParser::SimpleStatementContext::replicationStatement() {
  return getRuleContext<MySQLParser::ReplicationStatementContext>(0);
}

MySQLParser::PreparedStatementContext* MySQLParser::SimpleStatementContext::preparedStatement() {
  return getRuleContext<MySQLParser::PreparedStatementContext>(0);
}

MySQLParser::CloneStatementContext* MySQLParser::SimpleStatementContext::cloneStatement() {
  return getRuleContext<MySQLParser::CloneStatementContext>(0);
}

MySQLParser::AccountManagementStatementContext* MySQLParser::SimpleStatementContext::accountManagementStatement() {
  return getRuleContext<MySQLParser::AccountManagementStatementContext>(0);
}

MySQLParser::TableAdministrationStatementContext* MySQLParser::SimpleStatementContext::tableAdministrationStatement() {
  return getRuleContext<MySQLParser::TableAdministrationStatementContext>(0);
}

MySQLParser::UninstallStatementContext* MySQLParser::SimpleStatementContext::uninstallStatement() {
  return getRuleContext<MySQLParser::UninstallStatementContext>(0);
}

MySQLParser::InstallStatementContext* MySQLParser::SimpleStatementContext::installStatement() {
  return getRuleContext<MySQLParser::InstallStatementContext>(0);
}

MySQLParser::SetStatementContext* MySQLParser::SimpleStatementContext::setStatement() {
  return getRuleContext<MySQLParser::SetStatementContext>(0);
}

MySQLParser::ShowDatabasesStatementContext* MySQLParser::SimpleStatementContext::showDatabasesStatement() {
  return getRuleContext<MySQLParser::ShowDatabasesStatementContext>(0);
}

MySQLParser::ShowTablesStatementContext* MySQLParser::SimpleStatementContext::showTablesStatement() {
  return getRuleContext<MySQLParser::ShowTablesStatementContext>(0);
}

MySQLParser::ShowTriggersStatementContext* MySQLParser::SimpleStatementContext::showTriggersStatement() {
  return getRuleContext<MySQLParser::ShowTriggersStatementContext>(0);
}

MySQLParser::ShowEventsStatementContext* MySQLParser::SimpleStatementContext::showEventsStatement() {
  return getRuleContext<MySQLParser::ShowEventsStatementContext>(0);
}

MySQLParser::ShowTableStatusStatementContext* MySQLParser::SimpleStatementContext::showTableStatusStatement() {
  return getRuleContext<MySQLParser::ShowTableStatusStatementContext>(0);
}

MySQLParser::ShowOpenTablesStatementContext* MySQLParser::SimpleStatementContext::showOpenTablesStatement() {
  return getRuleContext<MySQLParser::ShowOpenTablesStatementContext>(0);
}

MySQLParser::ShowParseTreeStatementContext* MySQLParser::SimpleStatementContext::showParseTreeStatement() {
  return getRuleContext<MySQLParser::ShowParseTreeStatementContext>(0);
}

MySQLParser::ShowPluginsStatementContext* MySQLParser::SimpleStatementContext::showPluginsStatement() {
  return getRuleContext<MySQLParser::ShowPluginsStatementContext>(0);
}

MySQLParser::ShowEngineLogsStatementContext* MySQLParser::SimpleStatementContext::showEngineLogsStatement() {
  return getRuleContext<MySQLParser::ShowEngineLogsStatementContext>(0);
}

MySQLParser::ShowEngineMutexStatementContext* MySQLParser::SimpleStatementContext::showEngineMutexStatement() {
  return getRuleContext<MySQLParser::ShowEngineMutexStatementContext>(0);
}

MySQLParser::ShowEngineStatusStatementContext* MySQLParser::SimpleStatementContext::showEngineStatusStatement() {
  return getRuleContext<MySQLParser::ShowEngineStatusStatementContext>(0);
}

MySQLParser::ShowColumnsStatementContext* MySQLParser::SimpleStatementContext::showColumnsStatement() {
  return getRuleContext<MySQLParser::ShowColumnsStatementContext>(0);
}

MySQLParser::ShowBinaryLogsStatementContext* MySQLParser::SimpleStatementContext::showBinaryLogsStatement() {
  return getRuleContext<MySQLParser::ShowBinaryLogsStatementContext>(0);
}

MySQLParser::ShowBinaryLogStatusStatementContext* MySQLParser::SimpleStatementContext::showBinaryLogStatusStatement() {
  return getRuleContext<MySQLParser::ShowBinaryLogStatusStatementContext>(0);
}

MySQLParser::ShowReplicasStatementContext* MySQLParser::SimpleStatementContext::showReplicasStatement() {
  return getRuleContext<MySQLParser::ShowReplicasStatementContext>(0);
}

MySQLParser::ShowBinlogEventsStatementContext* MySQLParser::SimpleStatementContext::showBinlogEventsStatement() {
  return getRuleContext<MySQLParser::ShowBinlogEventsStatementContext>(0);
}

MySQLParser::ShowRelaylogEventsStatementContext* MySQLParser::SimpleStatementContext::showRelaylogEventsStatement() {
  return getRuleContext<MySQLParser::ShowRelaylogEventsStatementContext>(0);
}

MySQLParser::ShowKeysStatementContext* MySQLParser::SimpleStatementContext::showKeysStatement() {
  return getRuleContext<MySQLParser::ShowKeysStatementContext>(0);
}

MySQLParser::ShowEnginesStatementContext* MySQLParser::SimpleStatementContext::showEnginesStatement() {
  return getRuleContext<MySQLParser::ShowEnginesStatementContext>(0);
}

MySQLParser::ShowCountWarningsStatementContext* MySQLParser::SimpleStatementContext::showCountWarningsStatement() {
  return getRuleContext<MySQLParser::ShowCountWarningsStatementContext>(0);
}

MySQLParser::ShowCountErrorsStatementContext* MySQLParser::SimpleStatementContext::showCountErrorsStatement() {
  return getRuleContext<MySQLParser::ShowCountErrorsStatementContext>(0);
}

MySQLParser::ShowWarningsStatementContext* MySQLParser::SimpleStatementContext::showWarningsStatement() {
  return getRuleContext<MySQLParser::ShowWarningsStatementContext>(0);
}

MySQLParser::ShowErrorsStatementContext* MySQLParser::SimpleStatementContext::showErrorsStatement() {
  return getRuleContext<MySQLParser::ShowErrorsStatementContext>(0);
}

MySQLParser::ShowProfilesStatementContext* MySQLParser::SimpleStatementContext::showProfilesStatement() {
  return getRuleContext<MySQLParser::ShowProfilesStatementContext>(0);
}

MySQLParser::ShowProfileStatementContext* MySQLParser::SimpleStatementContext::showProfileStatement() {
  return getRuleContext<MySQLParser::ShowProfileStatementContext>(0);
}

MySQLParser::ShowStatusStatementContext* MySQLParser::SimpleStatementContext::showStatusStatement() {
  return getRuleContext<MySQLParser::ShowStatusStatementContext>(0);
}

MySQLParser::ShowProcessListStatementContext* MySQLParser::SimpleStatementContext::showProcessListStatement() {
  return getRuleContext<MySQLParser::ShowProcessListStatementContext>(0);
}

MySQLParser::ShowVariablesStatementContext* MySQLParser::SimpleStatementContext::showVariablesStatement() {
  return getRuleContext<MySQLParser::ShowVariablesStatementContext>(0);
}

MySQLParser::ShowCharacterSetStatementContext* MySQLParser::SimpleStatementContext::showCharacterSetStatement() {
  return getRuleContext<MySQLParser::ShowCharacterSetStatementContext>(0);
}

MySQLParser::ShowCollationStatementContext* MySQLParser::SimpleStatementContext::showCollationStatement() {
  return getRuleContext<MySQLParser::ShowCollationStatementContext>(0);
}

MySQLParser::ShowPrivilegesStatementContext* MySQLParser::SimpleStatementContext::showPrivilegesStatement() {
  return getRuleContext<MySQLParser::ShowPrivilegesStatementContext>(0);
}

MySQLParser::ShowGrantsStatementContext* MySQLParser::SimpleStatementContext::showGrantsStatement() {
  return getRuleContext<MySQLParser::ShowGrantsStatementContext>(0);
}

MySQLParser::ShowCreateDatabaseStatementContext* MySQLParser::SimpleStatementContext::showCreateDatabaseStatement() {
  return getRuleContext<MySQLParser::ShowCreateDatabaseStatementContext>(0);
}

MySQLParser::ShowCreateTableStatementContext* MySQLParser::SimpleStatementContext::showCreateTableStatement() {
  return getRuleContext<MySQLParser::ShowCreateTableStatementContext>(0);
}

MySQLParser::ShowCreateViewStatementContext* MySQLParser::SimpleStatementContext::showCreateViewStatement() {
  return getRuleContext<MySQLParser::ShowCreateViewStatementContext>(0);
}

MySQLParser::ShowMasterStatusStatementContext* MySQLParser::SimpleStatementContext::showMasterStatusStatement() {
  return getRuleContext<MySQLParser::ShowMasterStatusStatementContext>(0);
}

MySQLParser::ShowReplicaStatusStatementContext* MySQLParser::SimpleStatementContext::showReplicaStatusStatement() {
  return getRuleContext<MySQLParser::ShowReplicaStatusStatementContext>(0);
}

MySQLParser::ShowCreateProcedureStatementContext* MySQLParser::SimpleStatementContext::showCreateProcedureStatement() {
  return getRuleContext<MySQLParser::ShowCreateProcedureStatementContext>(0);
}

MySQLParser::ShowCreateFunctionStatementContext* MySQLParser::SimpleStatementContext::showCreateFunctionStatement() {
  return getRuleContext<MySQLParser::ShowCreateFunctionStatementContext>(0);
}

MySQLParser::ShowCreateTriggerStatementContext* MySQLParser::SimpleStatementContext::showCreateTriggerStatement() {
  return getRuleContext<MySQLParser::ShowCreateTriggerStatementContext>(0);
}

MySQLParser::ShowCreateProcedureStatusStatementContext* MySQLParser::SimpleStatementContext::showCreateProcedureStatusStatement() {
  return getRuleContext<MySQLParser::ShowCreateProcedureStatusStatementContext>(0);
}

MySQLParser::ShowCreateFunctionStatusStatementContext* MySQLParser::SimpleStatementContext::showCreateFunctionStatusStatement() {
  return getRuleContext<MySQLParser::ShowCreateFunctionStatusStatementContext>(0);
}

MySQLParser::ShowCreateProcedureCodeStatementContext* MySQLParser::SimpleStatementContext::showCreateProcedureCodeStatement() {
  return getRuleContext<MySQLParser::ShowCreateProcedureCodeStatementContext>(0);
}

MySQLParser::ShowCreateFunctionCodeStatementContext* MySQLParser::SimpleStatementContext::showCreateFunctionCodeStatement() {
  return getRuleContext<MySQLParser::ShowCreateFunctionCodeStatementContext>(0);
}

MySQLParser::ShowCreateEventStatementContext* MySQLParser::SimpleStatementContext::showCreateEventStatement() {
  return getRuleContext<MySQLParser::ShowCreateEventStatementContext>(0);
}

MySQLParser::ShowCreateUserStatementContext* MySQLParser::SimpleStatementContext::showCreateUserStatement() {
  return getRuleContext<MySQLParser::ShowCreateUserStatementContext>(0);
}

MySQLParser::ResourceGroupManagementContext* MySQLParser::SimpleStatementContext::resourceGroupManagement() {
  return getRuleContext<MySQLParser::ResourceGroupManagementContext>(0);
}

MySQLParser::OtherAdministrativeStatementContext* MySQLParser::SimpleStatementContext::otherAdministrativeStatement() {
  return getRuleContext<MySQLParser::OtherAdministrativeStatementContext>(0);
}

MySQLParser::UtilityStatementContext* MySQLParser::SimpleStatementContext::utilityStatement() {
  return getRuleContext<MySQLParser::UtilityStatementContext>(0);
}

MySQLParser::GetDiagnosticsStatementContext* MySQLParser::SimpleStatementContext::getDiagnosticsStatement() {
  return getRuleContext<MySQLParser::GetDiagnosticsStatementContext>(0);
}

MySQLParser::SignalStatementContext* MySQLParser::SimpleStatementContext::signalStatement() {
  return getRuleContext<MySQLParser::SignalStatementContext>(0);
}

MySQLParser::ResignalStatementContext* MySQLParser::SimpleStatementContext::resignalStatement() {
  return getRuleContext<MySQLParser::ResignalStatementContext>(0);
}


size_t MySQLParser::SimpleStatementContext::getRuleIndex() const {
  return MySQLParser::RuleSimpleStatement;
}

void MySQLParser::SimpleStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSimpleStatement(this);
}

void MySQLParser::SimpleStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSimpleStatement(this);
}


std::any MySQLParser::SimpleStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSimpleStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SimpleStatementContext* MySQLParser::simpleStatement() {
  SimpleStatementContext *_localctx = _tracker.createInstance<SimpleStatementContext>(_ctx, getState());
  enterRule(_localctx, 2, MySQLParser::RuleSimpleStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1583);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 3, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1503);
      alterStatement();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1504);
      createStatement();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1505);
      dropStatement();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1506);
      renameTableStatement();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1507);
      truncateTableStatement();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1508);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1509);
      importStatement();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1510);
      callStatement();
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1511);
      deleteStatement();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1512);
      doStatement();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1513);
      handlerStatement();
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1514);
      insertStatement();
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1515);
      loadStatement();
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1516);
      replaceStatement();
      break;
    }

    case 14: {
      enterOuterAlt(_localctx, 14);
      setState(1517);
      selectStatement();
      break;
    }

    case 15: {
      enterOuterAlt(_localctx, 15);
      setState(1518);
      updateStatement();
      break;
    }

    case 16: {
      enterOuterAlt(_localctx, 16);
      setState(1519);
      transactionOrLockingStatement();
      break;
    }

    case 17: {
      enterOuterAlt(_localctx, 17);
      setState(1520);
      replicationStatement();
      break;
    }

    case 18: {
      enterOuterAlt(_localctx, 18);
      setState(1521);
      preparedStatement();
      break;
    }

    case 19: {
      enterOuterAlt(_localctx, 19);
      setState(1522);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1523);
      cloneStatement();
      break;
    }

    case 20: {
      enterOuterAlt(_localctx, 20);
      setState(1524);
      accountManagementStatement();
      break;
    }

    case 21: {
      enterOuterAlt(_localctx, 21);
      setState(1525);
      tableAdministrationStatement();
      break;
    }

    case 22: {
      enterOuterAlt(_localctx, 22);
      setState(1526);
      uninstallStatement();
      break;
    }

    case 23: {
      enterOuterAlt(_localctx, 23);
      setState(1527);
      installStatement();
      break;
    }

    case 24: {
      enterOuterAlt(_localctx, 24);
      setState(1528);
      setStatement();
      break;
    }

    case 25: {
      enterOuterAlt(_localctx, 25);
      setState(1529);
      showDatabasesStatement();
      break;
    }

    case 26: {
      enterOuterAlt(_localctx, 26);
      setState(1530);
      showTablesStatement();
      break;
    }

    case 27: {
      enterOuterAlt(_localctx, 27);
      setState(1531);
      showTriggersStatement();
      break;
    }

    case 28: {
      enterOuterAlt(_localctx, 28);
      setState(1532);
      showEventsStatement();
      break;
    }

    case 29: {
      enterOuterAlt(_localctx, 29);
      setState(1533);
      showTableStatusStatement();
      break;
    }

    case 30: {
      enterOuterAlt(_localctx, 30);
      setState(1534);
      showOpenTablesStatement();
      break;
    }

    case 31: {
      enterOuterAlt(_localctx, 31);
      setState(1535);
      showParseTreeStatement();
      break;
    }

    case 32: {
      enterOuterAlt(_localctx, 32);
      setState(1536);
      showPluginsStatement();
      break;
    }

    case 33: {
      enterOuterAlt(_localctx, 33);
      setState(1537);
      showEngineLogsStatement();
      break;
    }

    case 34: {
      enterOuterAlt(_localctx, 34);
      setState(1538);
      showEngineMutexStatement();
      break;
    }

    case 35: {
      enterOuterAlt(_localctx, 35);
      setState(1539);
      showEngineStatusStatement();
      break;
    }

    case 36: {
      enterOuterAlt(_localctx, 36);
      setState(1540);
      showColumnsStatement();
      break;
    }

    case 37: {
      enterOuterAlt(_localctx, 37);
      setState(1541);
      showBinaryLogsStatement();
      break;
    }

    case 38: {
      enterOuterAlt(_localctx, 38);
      setState(1542);
      showBinaryLogStatusStatement();
      break;
    }

    case 39: {
      enterOuterAlt(_localctx, 39);
      setState(1543);
      showReplicasStatement();
      break;
    }

    case 40: {
      enterOuterAlt(_localctx, 40);
      setState(1544);
      showBinlogEventsStatement();
      break;
    }

    case 41: {
      enterOuterAlt(_localctx, 41);
      setState(1545);
      showRelaylogEventsStatement();
      break;
    }

    case 42: {
      enterOuterAlt(_localctx, 42);
      setState(1546);
      showKeysStatement();
      break;
    }

    case 43: {
      enterOuterAlt(_localctx, 43);
      setState(1547);
      showEnginesStatement();
      break;
    }

    case 44: {
      enterOuterAlt(_localctx, 44);
      setState(1548);
      showCountWarningsStatement();
      break;
    }

    case 45: {
      enterOuterAlt(_localctx, 45);
      setState(1549);
      showCountErrorsStatement();
      break;
    }

    case 46: {
      enterOuterAlt(_localctx, 46);
      setState(1550);
      showWarningsStatement();
      break;
    }

    case 47: {
      enterOuterAlt(_localctx, 47);
      setState(1551);
      showErrorsStatement();
      break;
    }

    case 48: {
      enterOuterAlt(_localctx, 48);
      setState(1552);
      showProfilesStatement();
      break;
    }

    case 49: {
      enterOuterAlt(_localctx, 49);
      setState(1553);
      showProfileStatement();
      break;
    }

    case 50: {
      enterOuterAlt(_localctx, 50);
      setState(1554);
      showStatusStatement();
      break;
    }

    case 51: {
      enterOuterAlt(_localctx, 51);
      setState(1555);
      showProcessListStatement();
      break;
    }

    case 52: {
      enterOuterAlt(_localctx, 52);
      setState(1556);
      showVariablesStatement();
      break;
    }

    case 53: {
      enterOuterAlt(_localctx, 53);
      setState(1557);
      showCharacterSetStatement();
      break;
    }

    case 54: {
      enterOuterAlt(_localctx, 54);
      setState(1558);
      showCollationStatement();
      break;
    }

    case 55: {
      enterOuterAlt(_localctx, 55);
      setState(1559);
      showPrivilegesStatement();
      break;
    }

    case 56: {
      enterOuterAlt(_localctx, 56);
      setState(1560);
      showGrantsStatement();
      break;
    }

    case 57: {
      enterOuterAlt(_localctx, 57);
      setState(1561);
      showCreateDatabaseStatement();
      break;
    }

    case 58: {
      enterOuterAlt(_localctx, 58);
      setState(1562);
      showCreateTableStatement();
      break;
    }

    case 59: {
      enterOuterAlt(_localctx, 59);
      setState(1563);
      showCreateViewStatement();
      break;
    }

    case 60: {
      enterOuterAlt(_localctx, 60);
      setState(1564);
      showMasterStatusStatement();
      break;
    }

    case 61: {
      enterOuterAlt(_localctx, 61);
      setState(1565);
      showReplicaStatusStatement();
      break;
    }

    case 62: {
      enterOuterAlt(_localctx, 62);
      setState(1566);
      showCreateProcedureStatement();
      break;
    }

    case 63: {
      enterOuterAlt(_localctx, 63);
      setState(1567);
      showCreateFunctionStatement();
      break;
    }

    case 64: {
      enterOuterAlt(_localctx, 64);
      setState(1568);
      showCreateTriggerStatement();
      break;
    }

    case 65: {
      enterOuterAlt(_localctx, 65);
      setState(1569);
      showCreateProcedureStatusStatement();
      break;
    }

    case 66: {
      enterOuterAlt(_localctx, 66);
      setState(1570);
      showCreateFunctionStatusStatement();
      break;
    }

    case 67: {
      enterOuterAlt(_localctx, 67);
      setState(1571);
      showCreateProcedureCodeStatement();
      break;
    }

    case 68: {
      enterOuterAlt(_localctx, 68);
      setState(1572);
      showCreateFunctionCodeStatement();
      break;
    }

    case 69: {
      enterOuterAlt(_localctx, 69);
      setState(1573);
      showCreateEventStatement();
      break;
    }

    case 70: {
      enterOuterAlt(_localctx, 70);
      setState(1574);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1575);
      showCreateUserStatement();
      break;
    }

    case 71: {
      enterOuterAlt(_localctx, 71);
      setState(1576);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1577);
      resourceGroupManagement();
      break;
    }

    case 72: {
      enterOuterAlt(_localctx, 72);
      setState(1578);
      otherAdministrativeStatement();
      break;
    }

    case 73: {
      enterOuterAlt(_localctx, 73);
      setState(1579);
      utilityStatement();
      break;
    }

    case 74: {
      enterOuterAlt(_localctx, 74);
      setState(1580);
      getDiagnosticsStatement();
      break;
    }

    case 75: {
      enterOuterAlt(_localctx, 75);
      setState(1581);
      signalStatement();
      break;
    }

    case 76: {
      enterOuterAlt(_localctx, 76);
      setState(1582);
      resignalStatement();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterStatementContext ------------------------------------------------------------------

MySQLParser::AlterStatementContext::AlterStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterStatementContext::ALTER_SYMBOL() {
  return getToken(MySQLParser::ALTER_SYMBOL, 0);
}

MySQLParser::AlterTableContext* MySQLParser::AlterStatementContext::alterTable() {
  return getRuleContext<MySQLParser::AlterTableContext>(0);
}

MySQLParser::AlterDatabaseContext* MySQLParser::AlterStatementContext::alterDatabase() {
  return getRuleContext<MySQLParser::AlterDatabaseContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::AlterStatementContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionRefContext* MySQLParser::AlterStatementContext::functionRef() {
  return getRuleContext<MySQLParser::FunctionRefContext>(0);
}

MySQLParser::AlterViewContext* MySQLParser::AlterStatementContext::alterView() {
  return getRuleContext<MySQLParser::AlterViewContext>(0);
}

MySQLParser::AlterEventContext* MySQLParser::AlterStatementContext::alterEvent() {
  return getRuleContext<MySQLParser::AlterEventContext>(0);
}

MySQLParser::AlterTablespaceContext* MySQLParser::AlterStatementContext::alterTablespace() {
  return getRuleContext<MySQLParser::AlterTablespaceContext>(0);
}

MySQLParser::AlterUndoTablespaceContext* MySQLParser::AlterStatementContext::alterUndoTablespace() {
  return getRuleContext<MySQLParser::AlterUndoTablespaceContext>(0);
}

MySQLParser::AlterLogfileGroupContext* MySQLParser::AlterStatementContext::alterLogfileGroup() {
  return getRuleContext<MySQLParser::AlterLogfileGroupContext>(0);
}

MySQLParser::AlterServerContext* MySQLParser::AlterStatementContext::alterServer() {
  return getRuleContext<MySQLParser::AlterServerContext>(0);
}

MySQLParser::AlterInstanceStatementContext* MySQLParser::AlterStatementContext::alterInstanceStatement() {
  return getRuleContext<MySQLParser::AlterInstanceStatementContext>(0);
}

MySQLParser::RoutineAlterOptionsContext* MySQLParser::AlterStatementContext::routineAlterOptions() {
  return getRuleContext<MySQLParser::RoutineAlterOptionsContext>(0);
}


size_t MySQLParser::AlterStatementContext::getRuleIndex() const {
  return MySQLParser::RuleAlterStatement;
}

void MySQLParser::AlterStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterStatement(this);
}

void MySQLParser::AlterStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterStatement(this);
}


std::any MySQLParser::AlterStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterStatementContext* MySQLParser::alterStatement() {
  AlterStatementContext *_localctx = _tracker.createInstance<AlterStatementContext>(_ctx, getState());
  enterRule(_localctx, 4, MySQLParser::RuleAlterStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1585);
    match(MySQLParser::ALTER_SYMBOL);
    setState(1606);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 6, _ctx)) {
    case 1: {
      setState(1586);
      alterTable();
      break;
    }

    case 2: {
      setState(1587);
      alterDatabase();
      break;
    }

    case 3: {
      setState(1588);
      match(MySQLParser::PROCEDURE_SYMBOL);
      setState(1589);
      procedureRef();
      setState(1591);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (((((_la - 119) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 119)) & ((1ULL << (MySQLParser::COMMENT_SYMBOL - 119))
        | (1ULL << (MySQLParser::CONTAINS_SYMBOL - 119))
        | (1ULL << (MySQLParser::DETERMINISTIC_SYMBOL - 119)))) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 378) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 378)) & ((1ULL << (MySQLParser::MODIFIES_SYMBOL - 378))
        | (1ULL << (MySQLParser::NOT_SYMBOL - 378))
        | (1ULL << (MySQLParser::NO_SYMBOL - 378)))) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL) {
        setState(1590);
        routineAlterOptions();
      }
      break;
    }

    case 4: {
      setState(1593);
      match(MySQLParser::FUNCTION_SYMBOL);
      setState(1594);
      functionRef();
      setState(1596);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (((((_la - 119) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 119)) & ((1ULL << (MySQLParser::COMMENT_SYMBOL - 119))
        | (1ULL << (MySQLParser::CONTAINS_SYMBOL - 119))
        | (1ULL << (MySQLParser::DETERMINISTIC_SYMBOL - 119)))) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 378) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 378)) & ((1ULL << (MySQLParser::MODIFIES_SYMBOL - 378))
        | (1ULL << (MySQLParser::NOT_SYMBOL - 378))
        | (1ULL << (MySQLParser::NO_SYMBOL - 378)))) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL) {
        setState(1595);
        routineAlterOptions();
      }
      break;
    }

    case 5: {
      setState(1598);
      alterView();
      break;
    }

    case 6: {
      setState(1599);
      alterEvent();
      break;
    }

    case 7: {
      setState(1600);
      alterTablespace();
      break;
    }

    case 8: {
      setState(1601);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1602);
      alterUndoTablespace();
      break;
    }

    case 9: {
      setState(1603);
      alterLogfileGroup();
      break;
    }

    case 10: {
      setState(1604);
      alterServer();
      break;
    }

    case 11: {
      setState(1605);
      alterInstanceStatement();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterDatabaseContext ------------------------------------------------------------------

MySQLParser::AlterDatabaseContext::AlterDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaRefContext* MySQLParser::AlterDatabaseContext::schemaRef() {
  return getRuleContext<MySQLParser::SchemaRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::UPGRADE_SYMBOL() {
  return getToken(MySQLParser::UPGRADE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DIRECTORY_SYMBOL() {
  return getToken(MySQLParser::DIRECTORY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::NAME_SYMBOL() {
  return getToken(MySQLParser::NAME_SYMBOL, 0);
}

std::vector<MySQLParser::AlterDatabaseOptionContext *> MySQLParser::AlterDatabaseContext::alterDatabaseOption() {
  return getRuleContexts<MySQLParser::AlterDatabaseOptionContext>();
}

MySQLParser::AlterDatabaseOptionContext* MySQLParser::AlterDatabaseContext::alterDatabaseOption(size_t i) {
  return getRuleContext<MySQLParser::AlterDatabaseOptionContext>(i);
}


size_t MySQLParser::AlterDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleAlterDatabase;
}

void MySQLParser::AlterDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterDatabase(this);
}

void MySQLParser::AlterDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterDatabase(this);
}


std::any MySQLParser::AlterDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterDatabaseContext* MySQLParser::alterDatabase() {
  AlterDatabaseContext *_localctx = _tracker.createInstance<AlterDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 6, MySQLParser::RuleAlterDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1608);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(1609);
    schemaRef();
    setState(1620);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 8, _ctx)) {
    case 1: {
      setState(1611); 
      _errHandler->sync(this);
      alt = 1;
      do {
        switch (alt) {
          case 1: {
                setState(1610);
                alterDatabaseOption();
                break;
              }

        default:
          throw NoViableAltException(this);
        }
        setState(1613); 
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 7, _ctx);
      } while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER);
      break;
    }

    case 2: {
      setState(1615);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(1616);
      match(MySQLParser::UPGRADE_SYMBOL);
      setState(1617);
      match(MySQLParser::DATA_SYMBOL);
      setState(1618);
      match(MySQLParser::DIRECTORY_SYMBOL);
      setState(1619);
      match(MySQLParser::NAME_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterDatabaseOptionContext ------------------------------------------------------------------

MySQLParser::AlterDatabaseOptionContext::AlterDatabaseOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::AlterDatabaseOptionContext::createDatabaseOption() {
  return getRuleContext<MySQLParser::CreateDatabaseOptionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseOptionContext::READ_SYMBOL() {
  return getToken(MySQLParser::READ_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseOptionContext::ONLY_SYMBOL() {
  return getToken(MySQLParser::ONLY_SYMBOL, 0);
}

MySQLParser::TernaryOptionContext* MySQLParser::AlterDatabaseOptionContext::ternaryOption() {
  return getRuleContext<MySQLParser::TernaryOptionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterDatabaseOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterDatabaseOption;
}

void MySQLParser::AlterDatabaseOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterDatabaseOption(this);
}

void MySQLParser::AlterDatabaseOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterDatabaseOption(this);
}


std::any MySQLParser::AlterDatabaseOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterDatabaseOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterDatabaseOptionContext* MySQLParser::alterDatabaseOption() {
  AlterDatabaseOptionContext *_localctx = _tracker.createInstance<AlterDatabaseOptionContext>(_ctx, getState());
  enterRule(_localctx, 8, MySQLParser::RuleAlterDatabaseOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1629);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 10, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1622);
      createDatabaseOption();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1623);
      match(MySQLParser::READ_SYMBOL);
      setState(1624);
      match(MySQLParser::ONLY_SYMBOL);
      setState(1626);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::EQUAL_OPERATOR) {
        setState(1625);
        match(MySQLParser::EQUAL_OPERATOR);
      }
      setState(1628);
      ternaryOption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterEventContext ------------------------------------------------------------------

MySQLParser::AlterEventContext::AlterEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventRefContext* MySQLParser::AlterEventContext::eventRef() {
  return getRuleContext<MySQLParser::EventRefContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::AlterEventContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterEventContext::ON_SYMBOL() {
  return getTokens(MySQLParser::ON_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterEventContext::ON_SYMBOL(size_t i) {
  return getToken(MySQLParser::ON_SYMBOL, i);
}

tree::TerminalNode* MySQLParser::AlterEventContext::SCHEDULE_SYMBOL() {
  return getToken(MySQLParser::SCHEDULE_SYMBOL, 0);
}

MySQLParser::ScheduleContext* MySQLParser::AlterEventContext::schedule() {
  return getRuleContext<MySQLParser::ScheduleContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::COMPLETION_SYMBOL() {
  return getToken(MySQLParser::COMPLETION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::PRESERVE_SYMBOL() {
  return getToken(MySQLParser::PRESERVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterEventContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterEventContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::AlterEventContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}

MySQLParser::ReplicaContext* MySQLParser::AlterEventContext::replica() {
  return getRuleContext<MySQLParser::ReplicaContext>(0);
}


size_t MySQLParser::AlterEventContext::getRuleIndex() const {
  return MySQLParser::RuleAlterEvent;
}

void MySQLParser::AlterEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterEvent(this);
}

void MySQLParser::AlterEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterEvent(this);
}


std::any MySQLParser::AlterEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterEventContext* MySQLParser::alterEvent() {
  AlterEventContext *_localctx = _tracker.createInstance<AlterEventContext>(_ctx, getState());
  enterRule(_localctx, 10, MySQLParser::RuleAlterEvent);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1632);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(1631);
      definerClause();
    }
    setState(1634);
    match(MySQLParser::EVENT_SYMBOL);
    setState(1635);
    eventRef();
    setState(1639);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 12, _ctx)) {
    case 1: {
      setState(1636);
      match(MySQLParser::ON_SYMBOL);
      setState(1637);
      match(MySQLParser::SCHEDULE_SYMBOL);
      setState(1638);
      schedule();
      break;
    }

    default:
      break;
    }
    setState(1647);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(1641);
      match(MySQLParser::ON_SYMBOL);
      setState(1642);
      match(MySQLParser::COMPLETION_SYMBOL);
      setState(1644);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::NOT_SYMBOL) {
        setState(1643);
        match(MySQLParser::NOT_SYMBOL);
      }
      setState(1646);
      match(MySQLParser::PRESERVE_SYMBOL);
    }
    setState(1652);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::RENAME_SYMBOL) {
      setState(1649);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1650);
      match(MySQLParser::TO_SYMBOL);
      setState(1651);
      identifier();
    }
    setState(1660);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ENABLE_SYMBOL: {
        setState(1654);
        match(MySQLParser::ENABLE_SYMBOL);
        break;
      }

      case MySQLParser::DISABLE_SYMBOL: {
        setState(1655);
        match(MySQLParser::DISABLE_SYMBOL);
        setState(1658);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ON_SYMBOL) {
          setState(1656);
          match(MySQLParser::ON_SYMBOL);
          setState(1657);
          replica();
        }
        break;
      }

      case MySQLParser::EOF:
      case MySQLParser::SEMICOLON_SYMBOL:
      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::DO_SYMBOL: {
        break;
      }

    default:
      break;
    }
    setState(1664);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL) {
      setState(1662);
      match(MySQLParser::COMMENT_SYMBOL);
      setState(1663);
      textLiteral();
    }
    setState(1668);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DO_SYMBOL) {
      setState(1666);
      match(MySQLParser::DO_SYMBOL);
      setState(1667);
      compoundStatement();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupContext::AlterLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::AlterLogfileGroupContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::UNDOFILE_SYMBOL() {
  return getToken(MySQLParser::UNDOFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterLogfileGroupContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

MySQLParser::AlterLogfileGroupOptionsContext* MySQLParser::AlterLogfileGroupContext::alterLogfileGroupOptions() {
  return getRuleContext<MySQLParser::AlterLogfileGroupOptionsContext>(0);
}


size_t MySQLParser::AlterLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroup;
}

void MySQLParser::AlterLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroup(this);
}

void MySQLParser::AlterLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroup(this);
}


std::any MySQLParser::AlterLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupContext* MySQLParser::alterLogfileGroup() {
  AlterLogfileGroupContext *_localctx = _tracker.createInstance<AlterLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 12, MySQLParser::RuleAlterLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1670);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(1671);
    match(MySQLParser::GROUP_SYMBOL);
    setState(1672);
    logfileGroupRef();
    setState(1673);
    match(MySQLParser::ADD_SYMBOL);
    setState(1674);
    match(MySQLParser::UNDOFILE_SYMBOL);
    setState(1675);
    textLiteral();
    setState(1677);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(1676);
      alterLogfileGroupOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupOptionsContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupOptionsContext::AlterLogfileGroupOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterLogfileGroupOptionContext *> MySQLParser::AlterLogfileGroupOptionsContext::alterLogfileGroupOption() {
  return getRuleContexts<MySQLParser::AlterLogfileGroupOptionContext>();
}

MySQLParser::AlterLogfileGroupOptionContext* MySQLParser::AlterLogfileGroupOptionsContext::alterLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::AlterLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterLogfileGroupOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterLogfileGroupOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroupOptions;
}

void MySQLParser::AlterLogfileGroupOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroupOptions(this);
}

void MySQLParser::AlterLogfileGroupOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroupOptions(this);
}


std::any MySQLParser::AlterLogfileGroupOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroupOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupOptionsContext* MySQLParser::alterLogfileGroupOptions() {
  AlterLogfileGroupOptionsContext *_localctx = _tracker.createInstance<AlterLogfileGroupOptionsContext>(_ctx, getState());
  enterRule(_localctx, 14, MySQLParser::RuleAlterLogfileGroupOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1679);
    alterLogfileGroupOption();
    setState(1686);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(1681);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(1680);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(1683);
      alterLogfileGroupOption();
      setState(1688);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupOptionContext::AlterLogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}


size_t MySQLParser::AlterLogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroupOption;
}

void MySQLParser::AlterLogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroupOption(this);
}

void MySQLParser::AlterLogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroupOption(this);
}


std::any MySQLParser::AlterLogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupOptionContext* MySQLParser::alterLogfileGroupOption() {
  AlterLogfileGroupOptionContext *_localctx = _tracker.createInstance<AlterLogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 16, MySQLParser::RuleAlterLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1692);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1689);
        tsOptionInitialSize();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1690);
        tsOptionEngine();
        break;
      }

      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(1691);
        tsOptionWait();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterServerContext ------------------------------------------------------------------

MySQLParser::AlterServerContext::AlterServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerRefContext* MySQLParser::AlterServerContext::serverRef() {
  return getRuleContext<MySQLParser::ServerRefContext>(0);
}

MySQLParser::ServerOptionsContext* MySQLParser::AlterServerContext::serverOptions() {
  return getRuleContext<MySQLParser::ServerOptionsContext>(0);
}


size_t MySQLParser::AlterServerContext::getRuleIndex() const {
  return MySQLParser::RuleAlterServer;
}

void MySQLParser::AlterServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterServer(this);
}

void MySQLParser::AlterServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterServer(this);
}


std::any MySQLParser::AlterServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterServerContext* MySQLParser::alterServer() {
  AlterServerContext *_localctx = _tracker.createInstance<AlterServerContext>(_ctx, getState());
  enterRule(_localctx, 18, MySQLParser::RuleAlterServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1694);
    match(MySQLParser::SERVER_SYMBOL);
    setState(1695);
    serverRef();
    setState(1696);
    serverOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTableContext ------------------------------------------------------------------

MySQLParser::AlterTableContext::AlterTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::AlterTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::OnlineOptionContext* MySQLParser::AlterTableContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

MySQLParser::AlterTableActionsContext* MySQLParser::AlterTableContext::alterTableActions() {
  return getRuleContext<MySQLParser::AlterTableActionsContext>(0);
}


size_t MySQLParser::AlterTableContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTable;
}

void MySQLParser::AlterTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTable(this);
}

void MySQLParser::AlterTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTable(this);
}


std::any MySQLParser::AlterTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTableContext* MySQLParser::alterTable() {
  AlterTableContext *_localctx = _tracker.createInstance<AlterTableContext>(_ctx, getState());
  enterRule(_localctx, 20, MySQLParser::RuleAlterTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1699);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(1698);
      onlineOption();
    }
    setState(1701);
    match(MySQLParser::TABLE_SYMBOL);
    setState(1702);
    tableRef();
    setState(1704);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 25, _ctx)) {
    case 1: {
      setState(1703);
      alterTableActions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTableActionsContext ------------------------------------------------------------------

MySQLParser::AlterTableActionsContext::AlterTableActionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterCommandListContext* MySQLParser::AlterTableActionsContext::alterCommandList() {
  return getRuleContext<MySQLParser::AlterCommandListContext>(0);
}

MySQLParser::PartitionClauseContext* MySQLParser::AlterTableActionsContext::partitionClause() {
  return getRuleContext<MySQLParser::PartitionClauseContext>(0);
}

MySQLParser::RemovePartitioningContext* MySQLParser::AlterTableActionsContext::removePartitioning() {
  return getRuleContext<MySQLParser::RemovePartitioningContext>(0);
}

MySQLParser::StandaloneAlterCommandsContext* MySQLParser::AlterTableActionsContext::standaloneAlterCommands() {
  return getRuleContext<MySQLParser::StandaloneAlterCommandsContext>(0);
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::AlterTableActionsContext::alterCommandsModifierList() {
  return getRuleContext<MySQLParser::AlterCommandsModifierListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTableActionsContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::AlterTableActionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTableActions;
}

void MySQLParser::AlterTableActionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTableActions(this);
}

void MySQLParser::AlterTableActionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTableActions(this);
}


std::any MySQLParser::AlterTableActionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTableActions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTableActionsContext* MySQLParser::alterTableActions() {
  AlterTableActionsContext *_localctx = _tracker.createInstance<AlterTableActionsContext>(_ctx, getState());
  enterRule(_localctx, 22, MySQLParser::RuleAlterTableActions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1719);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 28, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1706);
      alterCommandList();
      setState(1709);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::PARTITION_SYMBOL: {
          setState(1707);
          partitionClause();
          break;
        }

        case MySQLParser::REMOVE_SYMBOL: {
          setState(1708);
          removePartitioning();
          break;
        }

        case MySQLParser::EOF:
        case MySQLParser::SEMICOLON_SYMBOL: {
          break;
        }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1711);
      partitionClause();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1712);
      removePartitioning();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1716);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 27, _ctx)) {
      case 1: {
        setState(1713);
        alterCommandsModifierList();
        setState(1714);
        match(MySQLParser::COMMA_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1718);
      standaloneAlterCommands();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandListContext ------------------------------------------------------------------

MySQLParser::AlterCommandListContext::AlterCommandListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::AlterCommandListContext::alterCommandsModifierList() {
  return getRuleContext<MySQLParser::AlterCommandsModifierListContext>(0);
}

MySQLParser::AlterListContext* MySQLParser::AlterCommandListContext::alterList() {
  return getRuleContext<MySQLParser::AlterListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterCommandListContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::AlterCommandListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandList;
}

void MySQLParser::AlterCommandListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandList(this);
}

void MySQLParser::AlterCommandListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandList(this);
}


std::any MySQLParser::AlterCommandListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandListContext* MySQLParser::alterCommandList() {
  AlterCommandListContext *_localctx = _tracker.createInstance<AlterCommandListContext>(_ctx, getState());
  enterRule(_localctx, 24, MySQLParser::RuleAlterCommandList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1728);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 30, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1721);
      alterCommandsModifierList();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1725);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 29, _ctx)) {
      case 1: {
        setState(1722);
        alterCommandsModifierList();
        setState(1723);
        match(MySQLParser::COMMA_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1727);
      alterList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandsModifierListContext ------------------------------------------------------------------

MySQLParser::AlterCommandsModifierListContext::AlterCommandsModifierListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterCommandsModifierContext *> MySQLParser::AlterCommandsModifierListContext::alterCommandsModifier() {
  return getRuleContexts<MySQLParser::AlterCommandsModifierContext>();
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::AlterCommandsModifierListContext::alterCommandsModifier(size_t i) {
  return getRuleContext<MySQLParser::AlterCommandsModifierContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterCommandsModifierListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterCommandsModifierListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterCommandsModifierListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandsModifierList;
}

void MySQLParser::AlterCommandsModifierListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandsModifierList(this);
}

void MySQLParser::AlterCommandsModifierListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandsModifierList(this);
}


std::any MySQLParser::AlterCommandsModifierListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandsModifierList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::alterCommandsModifierList() {
  AlterCommandsModifierListContext *_localctx = _tracker.createInstance<AlterCommandsModifierListContext>(_ctx, getState());
  enterRule(_localctx, 26, MySQLParser::RuleAlterCommandsModifierList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1730);
    alterCommandsModifier();
    setState(1735);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 31, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(1731);
        match(MySQLParser::COMMA_SYMBOL);
        setState(1732);
        alterCommandsModifier(); 
      }
      setState(1737);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 31, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- StandaloneAlterCommandsContext ------------------------------------------------------------------

MySQLParser::StandaloneAlterCommandsContext::StandaloneAlterCommandsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::DISCARD_SYMBOL() {
  return getToken(MySQLParser::DISCARD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}

MySQLParser::AlterPartitionContext* MySQLParser::StandaloneAlterCommandsContext::alterPartition() {
  return getRuleContext<MySQLParser::AlterPartitionContext>(0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::SECONDARY_LOAD_SYMBOL() {
  return getToken(MySQLParser::SECONDARY_LOAD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::SECONDARY_UNLOAD_SYMBOL() {
  return getToken(MySQLParser::SECONDARY_UNLOAD_SYMBOL, 0);
}


size_t MySQLParser::StandaloneAlterCommandsContext::getRuleIndex() const {
  return MySQLParser::RuleStandaloneAlterCommands;
}

void MySQLParser::StandaloneAlterCommandsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterStandaloneAlterCommands(this);
}

void MySQLParser::StandaloneAlterCommandsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitStandaloneAlterCommands(this);
}


std::any MySQLParser::StandaloneAlterCommandsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitStandaloneAlterCommands(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::StandaloneAlterCommandsContext* MySQLParser::standaloneAlterCommands() {
  StandaloneAlterCommandsContext *_localctx = _tracker.createInstance<StandaloneAlterCommandsContext>(_ctx, getState());
  enterRule(_localctx, 28, MySQLParser::RuleStandaloneAlterCommands);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1745);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 32, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1738);
      match(MySQLParser::DISCARD_SYMBOL);
      setState(1739);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1740);
      match(MySQLParser::IMPORT_SYMBOL);
      setState(1741);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1742);
      alterPartition();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1743);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1744);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::SECONDARY_LOAD_SYMBOL

      || _la == MySQLParser::SECONDARY_UNLOAD_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterPartitionContext ------------------------------------------------------------------

MySQLParser::AlterPartitionContext::AlterPartitionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

MySQLParser::PartitionDefinitionsContext* MySQLParser::AlterPartitionContext::partitionDefinitions() {
  return getRuleContext<MySQLParser::PartitionDefinitionsContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::PARTITIONS_SYMBOL() {
  return getToken(MySQLParser::PARTITIONS_SYMBOL, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::AlterPartitionContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}

std::vector<MySQLParser::NoWriteToBinLogContext *> MySQLParser::AlterPartitionContext::noWriteToBinLog() {
  return getRuleContexts<MySQLParser::NoWriteToBinLogContext>();
}

MySQLParser::NoWriteToBinLogContext* MySQLParser::AlterPartitionContext::noWriteToBinLog(size_t i) {
  return getRuleContext<MySQLParser::NoWriteToBinLogContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::AlterPartitionContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REBUILD_SYMBOL() {
  return getToken(MySQLParser::REBUILD_SYMBOL, 0);
}

MySQLParser::AllOrPartitionNameListContext* MySQLParser::AlterPartitionContext::allOrPartitionNameList() {
  return getRuleContext<MySQLParser::AllOrPartitionNameListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::OPTIMIZE_SYMBOL() {
  return getToken(MySQLParser::OPTIMIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::ANALYZE_SYMBOL() {
  return getToken(MySQLParser::ANALYZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

std::vector<MySQLParser::CheckOptionContext *> MySQLParser::AlterPartitionContext::checkOption() {
  return getRuleContexts<MySQLParser::CheckOptionContext>();
}

MySQLParser::CheckOptionContext* MySQLParser::AlterPartitionContext::checkOption(size_t i) {
  return getRuleContext<MySQLParser::CheckOptionContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REPAIR_SYMBOL() {
  return getToken(MySQLParser::REPAIR_SYMBOL, 0);
}

std::vector<MySQLParser::RepairTypeContext *> MySQLParser::AlterPartitionContext::repairType() {
  return getRuleContexts<MySQLParser::RepairTypeContext>();
}

MySQLParser::RepairTypeContext* MySQLParser::AlterPartitionContext::repairType(size_t i) {
  return getRuleContext<MySQLParser::RepairTypeContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::COALESCE_SYMBOL() {
  return getToken(MySQLParser::COALESCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TRUNCATE_SYMBOL() {
  return getToken(MySQLParser::TRUNCATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REORGANIZE_SYMBOL() {
  return getToken(MySQLParser::REORGANIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::EXCHANGE_SYMBOL() {
  return getToken(MySQLParser::EXCHANGE_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterPartitionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::AlterPartitionContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::WithValidationContext* MySQLParser::AlterPartitionContext::withValidation() {
  return getRuleContext<MySQLParser::WithValidationContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::DISCARD_SYMBOL() {
  return getToken(MySQLParser::DISCARD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}


size_t MySQLParser::AlterPartitionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterPartition;
}

void MySQLParser::AlterPartitionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterPartition(this);
}

void MySQLParser::AlterPartitionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterPartition(this);
}


std::any MySQLParser::AlterPartitionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterPartition(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterPartitionContext* MySQLParser::alterPartition() {
  AlterPartitionContext *_localctx = _tracker.createInstance<AlterPartitionContext>(_ctx, getState());
  enterRule(_localctx, 30, MySQLParser::RuleAlterPartition);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1843);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 46, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1747);
      match(MySQLParser::ADD_SYMBOL);
      setState(1748);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1750);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1749);
        noWriteToBinLog();
      }
      setState(1755);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::OPEN_PAR_SYMBOL: {
          setState(1752);
          partitionDefinitions();
          break;
        }

        case MySQLParser::PARTITIONS_SYMBOL: {
          setState(1753);
          match(MySQLParser::PARTITIONS_SYMBOL);
          setState(1754);
          real_ulong_number();
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1757);
      match(MySQLParser::DROP_SYMBOL);
      setState(1758);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1759);
      identifierList();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1760);
      match(MySQLParser::REBUILD_SYMBOL);
      setState(1761);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1763);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 35, _ctx)) {
      case 1: {
        setState(1762);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1765);
      allOrPartitionNameList();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1766);
      match(MySQLParser::OPTIMIZE_SYMBOL);
      setState(1767);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1769);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 36, _ctx)) {
      case 1: {
        setState(1768);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1771);
      allOrPartitionNameList();
      setState(1773);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1772);
        noWriteToBinLog();
      }
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1775);
      match(MySQLParser::ANALYZE_SYMBOL);
      setState(1776);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1778);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 38, _ctx)) {
      case 1: {
        setState(1777);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1780);
      allOrPartitionNameList();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1781);
      match(MySQLParser::CHECK_SYMBOL);
      setState(1782);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1783);
      allOrPartitionNameList();
      setState(1787);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::CHANGED_SYMBOL || ((((_la - 219) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 219)) & ((1ULL << (MySQLParser::EXTENDED_SYMBOL - 219))
        | (1ULL << (MySQLParser::FAST_SYMBOL - 219))
        | (1ULL << (MySQLParser::FOR_SYMBOL - 219)))) != 0) || _la == MySQLParser::MEDIUM_SYMBOL || _la == MySQLParser::QUICK_SYMBOL) {
        setState(1784);
        checkOption();
        setState(1789);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1790);
      match(MySQLParser::REPAIR_SYMBOL);
      setState(1791);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1793);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 40, _ctx)) {
      case 1: {
        setState(1792);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1795);
      allOrPartitionNameList();
      setState(1799);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::EXTENDED_SYMBOL || _la == MySQLParser::QUICK_SYMBOL || _la == MySQLParser::USE_FRM_SYMBOL) {
        setState(1796);
        repairType();
        setState(1801);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1802);
      match(MySQLParser::COALESCE_SYMBOL);
      setState(1803);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1805);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1804);
        noWriteToBinLog();
      }
      setState(1807);
      real_ulong_number();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1808);
      match(MySQLParser::TRUNCATE_SYMBOL);
      setState(1809);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1810);
      allOrPartitionNameList();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1811);
      match(MySQLParser::REORGANIZE_SYMBOL);
      setState(1812);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1814);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 43, _ctx)) {
      case 1: {
        setState(1813);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1820);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 44, _ctx)) {
      case 1: {
        setState(1816);
        identifierList();
        setState(1817);
        match(MySQLParser::INTO_SYMBOL);
        setState(1818);
        partitionDefinitions();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1822);
      match(MySQLParser::EXCHANGE_SYMBOL);
      setState(1823);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1824);
      identifier();
      setState(1825);
      match(MySQLParser::WITH_SYMBOL);
      setState(1826);
      match(MySQLParser::TABLE_SYMBOL);
      setState(1827);
      tableRef();
      setState(1829);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 45, _ctx)) {
      case 1: {
        setState(1828);
        withValidation();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1831);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1832);
      match(MySQLParser::DISCARD_SYMBOL);
      setState(1833);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1834);
      allOrPartitionNameList();
      setState(1835);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1837);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1838);
      match(MySQLParser::IMPORT_SYMBOL);
      setState(1839);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1840);
      allOrPartitionNameList();
      setState(1841);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterListContext ------------------------------------------------------------------

MySQLParser::AlterListContext::AlterListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterListItemContext *> MySQLParser::AlterListContext::alterListItem() {
  return getRuleContexts<MySQLParser::AlterListItemContext>();
}

MySQLParser::AlterListItemContext* MySQLParser::AlterListContext::alterListItem(size_t i) {
  return getRuleContext<MySQLParser::AlterListItemContext>(i);
}

std::vector<MySQLParser::CreateTableOptionsSpaceSeparatedContext *> MySQLParser::AlterListContext::createTableOptionsSpaceSeparated() {
  return getRuleContexts<MySQLParser::CreateTableOptionsSpaceSeparatedContext>();
}

MySQLParser::CreateTableOptionsSpaceSeparatedContext* MySQLParser::AlterListContext::createTableOptionsSpaceSeparated(size_t i) {
  return getRuleContext<MySQLParser::CreateTableOptionsSpaceSeparatedContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}

std::vector<MySQLParser::AlterCommandsModifierContext *> MySQLParser::AlterListContext::alterCommandsModifier() {
  return getRuleContexts<MySQLParser::AlterCommandsModifierContext>();
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::AlterListContext::alterCommandsModifier(size_t i) {
  return getRuleContext<MySQLParser::AlterCommandsModifierContext>(i);
}


size_t MySQLParser::AlterListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterList;
}

void MySQLParser::AlterListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterList(this);
}

void MySQLParser::AlterListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterList(this);
}


std::any MySQLParser::AlterListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterListContext* MySQLParser::alterList() {
  AlterListContext *_localctx = _tracker.createInstance<AlterListContext>(_ctx, getState());
  enterRule(_localctx, 32, MySQLParser::RuleAlterList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1847);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 47, _ctx)) {
    case 1: {
      setState(1845);
      alterListItem();
      break;
    }

    case 2: {
      setState(1846);
      createTableOptionsSpaceSeparated();
      break;
    }

    default:
      break;
    }
    setState(1857);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(1849);
      match(MySQLParser::COMMA_SYMBOL);
      setState(1853);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 48, _ctx)) {
      case 1: {
        setState(1850);
        alterListItem();
        break;
      }

      case 2: {
        setState(1851);
        alterCommandsModifier();
        break;
      }

      case 3: {
        setState(1852);
        createTableOptionsSpaceSeparated();
        break;
      }

      default:
        break;
      }
      setState(1859);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandsModifierContext ------------------------------------------------------------------

MySQLParser::AlterCommandsModifierContext::AlterCommandsModifierContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::AlterCommandsModifierContext::alterAlgorithmOption() {
  return getRuleContext<MySQLParser::AlterAlgorithmOptionContext>(0);
}

MySQLParser::AlterLockOptionContext* MySQLParser::AlterCommandsModifierContext::alterLockOption() {
  return getRuleContext<MySQLParser::AlterLockOptionContext>(0);
}

MySQLParser::WithValidationContext* MySQLParser::AlterCommandsModifierContext::withValidation() {
  return getRuleContext<MySQLParser::WithValidationContext>(0);
}


size_t MySQLParser::AlterCommandsModifierContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandsModifier;
}

void MySQLParser::AlterCommandsModifierContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandsModifier(this);
}

void MySQLParser::AlterCommandsModifierContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandsModifier(this);
}


std::any MySQLParser::AlterCommandsModifierContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandsModifier(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::alterCommandsModifier() {
  AlterCommandsModifierContext *_localctx = _tracker.createInstance<AlterCommandsModifierContext>(_ctx, getState());
  enterRule(_localctx, 34, MySQLParser::RuleAlterCommandsModifier);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1863);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 50, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1860);
      alterAlgorithmOption();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1861);
      alterLockOption();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1862);
      withValidation();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterListItemContext ------------------------------------------------------------------

MySQLParser::AlterListItemContext::AlterListItemContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterListItemContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::FieldDefinitionContext* MySQLParser::AlterListItemContext::fieldDefinition() {
  return getRuleContext<MySQLParser::FieldDefinitionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::TableElementListContext* MySQLParser::AlterListItemContext::tableElementList() {
  return getRuleContext<MySQLParser::TableElementListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::COLUMN_SYMBOL() {
  return getToken(MySQLParser::COLUMN_SYMBOL, 0);
}

MySQLParser::CheckOrReferencesContext* MySQLParser::AlterListItemContext::checkOrReferences() {
  return getRuleContext<MySQLParser::CheckOrReferencesContext>(0);
}

MySQLParser::PlaceContext* MySQLParser::AlterListItemContext::place() {
  return getRuleContext<MySQLParser::PlaceContext>(0);
}

MySQLParser::TableConstraintDefContext* MySQLParser::AlterListItemContext::tableConstraintDef() {
  return getRuleContext<MySQLParser::TableConstraintDefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CHANGE_SYMBOL() {
  return getToken(MySQLParser::CHANGE_SYMBOL, 0);
}

MySQLParser::ColumnInternalRefContext* MySQLParser::AlterListItemContext::columnInternalRef() {
  return getRuleContext<MySQLParser::ColumnInternalRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::MODIFY_SYMBOL() {
  return getToken(MySQLParser::MODIFY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::FOREIGN_SYMBOL() {
  return getToken(MySQLParser::FOREIGN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::PRIMARY_SYMBOL() {
  return getToken(MySQLParser::PRIMARY_SYMBOL, 0);
}

MySQLParser::KeyOrIndexContext* MySQLParser::AlterListItemContext::keyOrIndex() {
  return getRuleContext<MySQLParser::KeyOrIndexContext>(0);
}

MySQLParser::IndexRefContext* MySQLParser::AlterListItemContext::indexRef() {
  return getRuleContext<MySQLParser::IndexRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CONSTRAINT_SYMBOL() {
  return getToken(MySQLParser::CONSTRAINT_SYMBOL, 0);
}

MySQLParser::RestrictContext* MySQLParser::AlterListItemContext::restrict() {
  return getRuleContext<MySQLParser::RestrictContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::KEYS_SYMBOL() {
  return getToken(MySQLParser::KEYS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ALTER_SYMBOL() {
  return getToken(MySQLParser::ALTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::VisibilityContext* MySQLParser::AlterListItemContext::visibility() {
  return getRuleContext<MySQLParser::VisibilityContext>(0);
}

MySQLParser::ExprWithParenthesesContext* MySQLParser::AlterListItemContext::exprWithParentheses() {
  return getRuleContext<MySQLParser::ExprWithParenthesesContext>(0);
}

MySQLParser::SignedLiteralOrNullContext* MySQLParser::AlterListItemContext::signedLiteralOrNull() {
  return getRuleContext<MySQLParser::SignedLiteralOrNullContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::ConstraintEnforcementContext* MySQLParser::AlterListItemContext::constraintEnforcement() {
  return getRuleContext<MySQLParser::ConstraintEnforcementContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::AlterListItemContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::IndexNameContext* MySQLParser::AlterListItemContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CONVERT_SYMBOL() {
  return getToken(MySQLParser::CONVERT_SYMBOL, 0);
}

MySQLParser::CharsetContext* MySQLParser::AlterListItemContext::charset() {
  return getRuleContext<MySQLParser::CharsetContext>(0);
}

MySQLParser::CharsetNameContext* MySQLParser::AlterListItemContext::charsetName() {
  return getRuleContext<MySQLParser::CharsetNameContext>(0);
}

MySQLParser::CollateContext* MySQLParser::AlterListItemContext::collate() {
  return getRuleContext<MySQLParser::CollateContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::FORCE_SYMBOL() {
  return getToken(MySQLParser::FORCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ORDER_SYMBOL() {
  return getToken(MySQLParser::ORDER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::AlterOrderListContext* MySQLParser::AlterListItemContext::alterOrderList() {
  return getRuleContext<MySQLParser::AlterOrderListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::UPGRADE_SYMBOL() {
  return getToken(MySQLParser::UPGRADE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::PARTITIONING_SYMBOL() {
  return getToken(MySQLParser::PARTITIONING_SYMBOL, 0);
}


size_t MySQLParser::AlterListItemContext::getRuleIndex() const {
  return MySQLParser::RuleAlterListItem;
}

void MySQLParser::AlterListItemContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterListItem(this);
}

void MySQLParser::AlterListItemContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterListItem(this);
}


std::any MySQLParser::AlterListItemContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterListItem(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterListItemContext* MySQLParser::alterListItem() {
  AlterListItemContext *_localctx = _tracker.createInstance<AlterListItemContext>(_ctx, getState());
  enterRule(_localctx, 36, MySQLParser::RuleAlterListItem);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2005);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 68, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1865);
      match(MySQLParser::ADD_SYMBOL);
      setState(1867);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 51, _ctx)) {
      case 1: {
        setState(1866);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1881);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 54, _ctx)) {
      case 1: {
        setState(1869);
        identifier();
        setState(1870);
        fieldDefinition();
        setState(1872);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 52, _ctx)) {
        case 1: {
          setState(1871);
          checkOrReferences();
          break;
        }

        default:
          break;
        }
        setState(1875);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
          setState(1874);
          place();
        }
        break;
      }

      case 2: {
        setState(1877);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(1878);
        tableElementList();
        setState(1879);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1883);
      match(MySQLParser::ADD_SYMBOL);
      setState(1884);
      tableConstraintDef();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1885);
      match(MySQLParser::CHANGE_SYMBOL);
      setState(1887);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 55, _ctx)) {
      case 1: {
        setState(1886);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1889);
      columnInternalRef();
      setState(1890);
      identifier();
      setState(1891);
      fieldDefinition();
      setState(1893);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
        setState(1892);
        place();
      }
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1895);
      match(MySQLParser::MODIFY_SYMBOL);
      setState(1897);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 57, _ctx)) {
      case 1: {
        setState(1896);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1899);
      columnInternalRef();
      setState(1900);
      fieldDefinition();
      setState(1902);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
        setState(1901);
        place();
      }
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1904);
      match(MySQLParser::DROP_SYMBOL);
      setState(1926);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 61, _ctx)) {
      case 1: {
        setState(1906);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 59, _ctx)) {
        case 1: {
          setState(1905);
          match(MySQLParser::COLUMN_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(1908);
        columnInternalRef();
        setState(1910);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
          setState(1909);
          restrict();
        }
        break;
      }

      case 2: {
        setState(1912);
        match(MySQLParser::FOREIGN_SYMBOL);
        setState(1913);
        match(MySQLParser::KEY_SYMBOL);
        setState(1914);
        columnInternalRef();
        break;
      }

      case 3: {
        setState(1915);
        match(MySQLParser::PRIMARY_SYMBOL);
        setState(1916);
        match(MySQLParser::KEY_SYMBOL);
        break;
      }

      case 4: {
        setState(1917);
        keyOrIndex();
        setState(1918);
        indexRef();
        break;
      }

      case 5: {
        setState(1920);

        if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
        setState(1921);
        match(MySQLParser::CHECK_SYMBOL);
        setState(1922);
        identifier();
        break;
      }

      case 6: {
        setState(1923);

        if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
        setState(1924);
        match(MySQLParser::CONSTRAINT_SYMBOL);
        setState(1925);
        identifier();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1928);
      match(MySQLParser::DISABLE_SYMBOL);
      setState(1929);
      match(MySQLParser::KEYS_SYMBOL);
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1930);
      match(MySQLParser::ENABLE_SYMBOL);
      setState(1931);
      match(MySQLParser::KEYS_SYMBOL);
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1932);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1934);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 62, _ctx)) {
      case 1: {
        setState(1933);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1936);
      columnInternalRef();
      setState(1949);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 64, _ctx)) {
      case 1: {
        setState(1937);
        match(MySQLParser::SET_SYMBOL);
        setState(1938);
        match(MySQLParser::DEFAULT_SYMBOL);
        setState(1942);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 63, _ctx)) {
        case 1: {
          setState(1939);

          if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
          setState(1940);
          exprWithParentheses();
          break;
        }

        case 2: {
          setState(1941);
          signedLiteralOrNull();
          break;
        }

        default:
          break;
        }
        break;
      }

      case 2: {
        setState(1944);
        match(MySQLParser::DROP_SYMBOL);
        setState(1945);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      case 3: {
        setState(1946);

        if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
        setState(1947);
        match(MySQLParser::SET_SYMBOL);
        setState(1948);
        visibility();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1951);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1952);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1953);
      match(MySQLParser::INDEX_SYMBOL);
      setState(1954);
      indexRef();
      setState(1955);
      visibility();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1957);

      if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
      setState(1958);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1959);
      match(MySQLParser::CHECK_SYMBOL);
      setState(1960);
      identifier();
      setState(1961);
      constraintEnforcement();
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1963);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(1964);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1965);
      match(MySQLParser::CONSTRAINT_SYMBOL);
      setState(1966);
      identifier();
      setState(1967);
      constraintEnforcement();
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1969);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1970);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1971);
      match(MySQLParser::COLUMN_SYMBOL);
      setState(1972);
      columnInternalRef();
      setState(1973);
      match(MySQLParser::TO_SYMBOL);
      setState(1974);
      identifier();
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1976);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1978);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 65, _ctx)) {
      case 1: {
        setState(1977);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::AS_SYMBOL || _la == MySQLParser::TO_SYMBOL)) {
        _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        break;
      }

      default:
        break;
      }
      setState(1980);
      tableName();
      break;
    }

    case 14: {
      enterOuterAlt(_localctx, 14);
      setState(1981);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1982);
      keyOrIndex();
      setState(1983);
      indexRef();
      setState(1984);
      match(MySQLParser::TO_SYMBOL);
      setState(1985);
      indexName();
      break;
    }

    case 15: {
      enterOuterAlt(_localctx, 15);
      setState(1987);
      match(MySQLParser::CONVERT_SYMBOL);
      setState(1988);
      match(MySQLParser::TO_SYMBOL);
      setState(1989);
      charset();
      setState(1993);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 66, _ctx)) {
      case 1: {
        setState(1990);

        if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
        setState(1991);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      case 2: {
        setState(1992);
        charsetName();
        break;
      }

      default:
        break;
      }
      setState(1996);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COLLATE_SYMBOL) {
        setState(1995);
        collate();
      }
      break;
    }

    case 16: {
      enterOuterAlt(_localctx, 16);
      setState(1998);
      match(MySQLParser::FORCE_SYMBOL);
      break;
    }

    case 17: {
      enterOuterAlt(_localctx, 17);
      setState(1999);
      match(MySQLParser::ORDER_SYMBOL);
      setState(2000);
      match(MySQLParser::BY_SYMBOL);
      setState(2001);
      alterOrderList();
      break;
    }

    case 18: {
      enterOuterAlt(_localctx, 18);
      setState(2002);

      if (!(serverVersion >= 50708 && serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion >= 50708 && serverVersion < 80000");
      setState(2003);
      match(MySQLParser::UPGRADE_SYMBOL);
      setState(2004);
      match(MySQLParser::PARTITIONING_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- PlaceContext ------------------------------------------------------------------

MySQLParser::PlaceContext::PlaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::PlaceContext::AFTER_SYMBOL() {
  return getToken(MySQLParser::AFTER_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::PlaceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::PlaceContext::FIRST_SYMBOL() {
  return getToken(MySQLParser::FIRST_SYMBOL, 0);
}


size_t MySQLParser::PlaceContext::getRuleIndex() const {
  return MySQLParser::RulePlace;
}

void MySQLParser::PlaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterPlace(this);
}

void MySQLParser::PlaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitPlace(this);
}


std::any MySQLParser::PlaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitPlace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::PlaceContext* MySQLParser::place() {
  PlaceContext *_localctx = _tracker.createInstance<PlaceContext>(_ctx, getState());
  enterRule(_localctx, 38, MySQLParser::RulePlace);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2010);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::AFTER_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2007);
        match(MySQLParser::AFTER_SYMBOL);
        setState(2008);
        identifier();
        break;
      }

      case MySQLParser::FIRST_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2009);
        match(MySQLParser::FIRST_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RestrictContext ------------------------------------------------------------------

MySQLParser::RestrictContext::RestrictContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RestrictContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RestrictContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::RestrictContext::getRuleIndex() const {
  return MySQLParser::RuleRestrict;
}

void MySQLParser::RestrictContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRestrict(this);
}

void MySQLParser::RestrictContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRestrict(this);
}


std::any MySQLParser::RestrictContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRestrict(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RestrictContext* MySQLParser::restrict() {
  RestrictContext *_localctx = _tracker.createInstance<RestrictContext>(_ctx, getState());
  enterRule(_localctx, 40, MySQLParser::RuleRestrict);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2012);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterOrderListContext ------------------------------------------------------------------

MySQLParser::AlterOrderListContext::AlterOrderListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::IdentifierContext *> MySQLParser::AlterOrderListContext::identifier() {
  return getRuleContexts<MySQLParser::IdentifierContext>();
}

MySQLParser::IdentifierContext* MySQLParser::AlterOrderListContext::identifier(size_t i) {
  return getRuleContext<MySQLParser::IdentifierContext>(i);
}

std::vector<MySQLParser::DirectionContext *> MySQLParser::AlterOrderListContext::direction() {
  return getRuleContexts<MySQLParser::DirectionContext>();
}

MySQLParser::DirectionContext* MySQLParser::AlterOrderListContext::direction(size_t i) {
  return getRuleContext<MySQLParser::DirectionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterOrderListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterOrderListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterOrderListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterOrderList;
}

void MySQLParser::AlterOrderListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterOrderList(this);
}

void MySQLParser::AlterOrderListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterOrderList(this);
}


std::any MySQLParser::AlterOrderListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterOrderList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterOrderListContext* MySQLParser::alterOrderList() {
  AlterOrderListContext *_localctx = _tracker.createInstance<AlterOrderListContext>(_ctx, getState());
  enterRule(_localctx, 42, MySQLParser::RuleAlterOrderList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2014);
    identifier();
    setState(2016);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL) {
      setState(2015);
      direction();
    }
    setState(2025);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 72, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2018);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2019);
        identifier();
        setState(2021);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL) {
          setState(2020);
          direction();
        } 
      }
      setState(2027);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 72, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterAlgorithmOptionContext ------------------------------------------------------------------

MySQLParser::AlterAlgorithmOptionContext::AlterAlgorithmOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterAlgorithmOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterAlgorithmOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterAlgorithmOption;
}

void MySQLParser::AlterAlgorithmOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterAlgorithmOption(this);
}

void MySQLParser::AlterAlgorithmOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterAlgorithmOption(this);
}


std::any MySQLParser::AlterAlgorithmOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterAlgorithmOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::alterAlgorithmOption() {
  AlterAlgorithmOptionContext *_localctx = _tracker.createInstance<AlterAlgorithmOptionContext>(_ctx, getState());
  enterRule(_localctx, 44, MySQLParser::RuleAlterAlgorithmOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2028);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(2030);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 73, _ctx)) {
    case 1: {
      setState(2029);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2034);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 74, _ctx)) {
    case 1: {
      setState(2032);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    case 2: {
      setState(2033);
      identifier();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLockOptionContext ------------------------------------------------------------------

MySQLParser::AlterLockOptionContext::AlterLockOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::LOCK_SYMBOL() {
  return getToken(MySQLParser::LOCK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterLockOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterLockOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLockOption;
}

void MySQLParser::AlterLockOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLockOption(this);
}

void MySQLParser::AlterLockOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLockOption(this);
}


std::any MySQLParser::AlterLockOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLockOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLockOptionContext* MySQLParser::alterLockOption() {
  AlterLockOptionContext *_localctx = _tracker.createInstance<AlterLockOptionContext>(_ctx, getState());
  enterRule(_localctx, 46, MySQLParser::RuleAlterLockOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2036);
    match(MySQLParser::LOCK_SYMBOL);
    setState(2038);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 75, _ctx)) {
    case 1: {
      setState(2037);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2042);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 76, _ctx)) {
    case 1: {
      setState(2040);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    case 2: {
      setState(2041);
      identifier();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IndexLockAndAlgorithmContext ------------------------------------------------------------------

MySQLParser::IndexLockAndAlgorithmContext::IndexLockAndAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::IndexLockAndAlgorithmContext::alterAlgorithmOption() {
  return getRuleContext<MySQLParser::AlterAlgorithmOptionContext>(0);
}

MySQLParser::AlterLockOptionContext* MySQLParser::IndexLockAndAlgorithmContext::alterLockOption() {
  return getRuleContext<MySQLParser::AlterLockOptionContext>(0);
}


size_t MySQLParser::IndexLockAndAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleIndexLockAndAlgorithm;
}

void MySQLParser::IndexLockAndAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIndexLockAndAlgorithm(this);
}

void MySQLParser::IndexLockAndAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIndexLockAndAlgorithm(this);
}


std::any MySQLParser::IndexLockAndAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIndexLockAndAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::indexLockAndAlgorithm() {
  IndexLockAndAlgorithmContext *_localctx = _tracker.createInstance<IndexLockAndAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 48, MySQLParser::RuleIndexLockAndAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2052);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ALGORITHM_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2044);
        alterAlgorithmOption();
        setState(2046);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::LOCK_SYMBOL) {
          setState(2045);
          alterLockOption();
        }
        break;
      }

      case MySQLParser::LOCK_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2048);
        alterLockOption();
        setState(2050);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ALGORITHM_SYMBOL) {
          setState(2049);
          alterAlgorithmOption();
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WithValidationContext ------------------------------------------------------------------

MySQLParser::WithValidationContext::WithValidationContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WithValidationContext::VALIDATION_SYMBOL() {
  return getToken(MySQLParser::VALIDATION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WithValidationContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WithValidationContext::WITHOUT_SYMBOL() {
  return getToken(MySQLParser::WITHOUT_SYMBOL, 0);
}


size_t MySQLParser::WithValidationContext::getRuleIndex() const {
  return MySQLParser::RuleWithValidation;
}

void MySQLParser::WithValidationContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWithValidation(this);
}

void MySQLParser::WithValidationContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWithValidation(this);
}


std::any MySQLParser::WithValidationContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWithValidation(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WithValidationContext* MySQLParser::withValidation() {
  WithValidationContext *_localctx = _tracker.createInstance<WithValidationContext>(_ctx, getState());
  enterRule(_localctx, 50, MySQLParser::RuleWithValidation);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2054);

    if (!(serverVersion >= 50706)) throw FailedPredicateException(this, "serverVersion >= 50706");
    setState(2055);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::WITH_SYMBOL

    || _la == MySQLParser::WITHOUT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2056);
    match(MySQLParser::VALIDATION_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RemovePartitioningContext ------------------------------------------------------------------

MySQLParser::RemovePartitioningContext::RemovePartitioningContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RemovePartitioningContext::REMOVE_SYMBOL() {
  return getToken(MySQLParser::REMOVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RemovePartitioningContext::PARTITIONING_SYMBOL() {
  return getToken(MySQLParser::PARTITIONING_SYMBOL, 0);
}


size_t MySQLParser::RemovePartitioningContext::getRuleIndex() const {
  return MySQLParser::RuleRemovePartitioning;
}

void MySQLParser::RemovePartitioningContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRemovePartitioning(this);
}

void MySQLParser::RemovePartitioningContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRemovePartitioning(this);
}


std::any MySQLParser::RemovePartitioningContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRemovePartitioning(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RemovePartitioningContext* MySQLParser::removePartitioning() {
  RemovePartitioningContext *_localctx = _tracker.createInstance<RemovePartitioningContext>(_ctx, getState());
  enterRule(_localctx, 52, MySQLParser::RuleRemovePartitioning);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2058);
    match(MySQLParser::REMOVE_SYMBOL);
    setState(2059);
    match(MySQLParser::PARTITIONING_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AllOrPartitionNameListContext ------------------------------------------------------------------

MySQLParser::AllOrPartitionNameListContext::AllOrPartitionNameListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AllOrPartitionNameListContext::ALL_SYMBOL() {
  return getToken(MySQLParser::ALL_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::AllOrPartitionNameListContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}


size_t MySQLParser::AllOrPartitionNameListContext::getRuleIndex() const {
  return MySQLParser::RuleAllOrPartitionNameList;
}

void MySQLParser::AllOrPartitionNameListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAllOrPartitionNameList(this);
}

void MySQLParser::AllOrPartitionNameListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAllOrPartitionNameList(this);
}


std::any MySQLParser::AllOrPartitionNameListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAllOrPartitionNameList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AllOrPartitionNameListContext* MySQLParser::allOrPartitionNameList() {
  AllOrPartitionNameListContext *_localctx = _tracker.createInstance<AllOrPartitionNameListContext>(_ctx, getState());
  enterRule(_localctx, 54, MySQLParser::RuleAllOrPartitionNameList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2063);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 80, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2061);
      match(MySQLParser::ALL_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2062);
      identifierList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceContext::AlterTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::AlterTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::DATAFILE_SYMBOL() {
  return getToken(MySQLParser::DATAFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterTablespaceContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterTablespaceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::AlterTablespaceOptionsContext* MySQLParser::AlterTablespaceContext::alterTablespaceOptions() {
  return getRuleContext<MySQLParser::AlterTablespaceOptionsContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}


size_t MySQLParser::AlterTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespace;
}

void MySQLParser::AlterTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespace(this);
}

void MySQLParser::AlterTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespace(this);
}


std::any MySQLParser::AlterTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceContext* MySQLParser::alterTablespace() {
  AlterTablespaceContext *_localctx = _tracker.createInstance<AlterTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 56, MySQLParser::RuleAlterTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2065);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2066);
    tablespaceRef();
    setState(2078);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 82, _ctx)) {
    case 1: {
      setState(2067);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::ADD_SYMBOL || _la == MySQLParser::DROP_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(2068);
      match(MySQLParser::DATAFILE_SYMBOL);
      setState(2069);
      textLiteral();
      setState(2071);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 81, _ctx)) {
      case 1: {
        setState(2070);
        alterTablespaceOptions();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2073);
      match(MySQLParser::RENAME_SYMBOL);
      setState(2074);
      match(MySQLParser::TO_SYMBOL);
      setState(2075);
      identifier();
      break;
    }

    case 3: {
      setState(2076);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2077);
      alterTablespaceOptions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::AlterUndoTablespaceContext::AlterUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::AlterUndoTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::ACTIVE_SYMBOL() {
  return getToken(MySQLParser::ACTIVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::INACTIVE_SYMBOL() {
  return getToken(MySQLParser::INACTIVE_SYMBOL, 0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::AlterUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::AlterUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleAlterUndoTablespace;
}

void MySQLParser::AlterUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterUndoTablespace(this);
}

void MySQLParser::AlterUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterUndoTablespace(this);
}


std::any MySQLParser::AlterUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterUndoTablespaceContext* MySQLParser::alterUndoTablespace() {
  AlterUndoTablespaceContext *_localctx = _tracker.createInstance<AlterUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 58, MySQLParser::RuleAlterUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2080);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2081);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2082);
    tablespaceRef();
    setState(2083);
    match(MySQLParser::SET_SYMBOL);
    setState(2084);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ACTIVE_SYMBOL

    || _la == MySQLParser::INACTIVE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2086);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2085);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- UndoTableSpaceOptionsContext ------------------------------------------------------------------

MySQLParser::UndoTableSpaceOptionsContext::UndoTableSpaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::UndoTableSpaceOptionContext *> MySQLParser::UndoTableSpaceOptionsContext::undoTableSpaceOption() {
  return getRuleContexts<MySQLParser::UndoTableSpaceOptionContext>();
}

MySQLParser::UndoTableSpaceOptionContext* MySQLParser::UndoTableSpaceOptionsContext::undoTableSpaceOption(size_t i) {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::UndoTableSpaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::UndoTableSpaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::UndoTableSpaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleUndoTableSpaceOptions;
}

void MySQLParser::UndoTableSpaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterUndoTableSpaceOptions(this);
}

void MySQLParser::UndoTableSpaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitUndoTableSpaceOptions(this);
}


std::any MySQLParser::UndoTableSpaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitUndoTableSpaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::undoTableSpaceOptions() {
  UndoTableSpaceOptionsContext *_localctx = _tracker.createInstance<UndoTableSpaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 60, MySQLParser::RuleUndoTableSpaceOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2088);
    undoTableSpaceOption();
    setState(2095);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2090);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2089);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(2092);
      undoTableSpaceOption();
      setState(2097);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- UndoTableSpaceOptionContext ------------------------------------------------------------------

MySQLParser::UndoTableSpaceOptionContext::UndoTableSpaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionEngineContext* MySQLParser::UndoTableSpaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}


size_t MySQLParser::UndoTableSpaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleUndoTableSpaceOption;
}

void MySQLParser::UndoTableSpaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterUndoTableSpaceOption(this);
}

void MySQLParser::UndoTableSpaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitUndoTableSpaceOption(this);
}


std::any MySQLParser::UndoTableSpaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitUndoTableSpaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::UndoTableSpaceOptionContext* MySQLParser::undoTableSpaceOption() {
  UndoTableSpaceOptionContext *_localctx = _tracker.createInstance<UndoTableSpaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 62, MySQLParser::RuleUndoTableSpaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2098);
    tsOptionEngine();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceOptionsContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceOptionsContext::AlterTablespaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterTablespaceOptionContext *> MySQLParser::AlterTablespaceOptionsContext::alterTablespaceOption() {
  return getRuleContexts<MySQLParser::AlterTablespaceOptionContext>();
}

MySQLParser::AlterTablespaceOptionContext* MySQLParser::AlterTablespaceOptionsContext::alterTablespaceOption(size_t i) {
  return getRuleContext<MySQLParser::AlterTablespaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterTablespaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterTablespaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespaceOptions;
}

void MySQLParser::AlterTablespaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespaceOptions(this);
}

void MySQLParser::AlterTablespaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespaceOptions(this);
}


std::any MySQLParser::AlterTablespaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceOptionsContext* MySQLParser::alterTablespaceOptions() {
  AlterTablespaceOptionsContext *_localctx = _tracker.createInstance<AlterTablespaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 64, MySQLParser::RuleAlterTablespaceOptions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2100);
    alterTablespaceOption();
    setState(2107);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 87, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2102);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 86, _ctx)) {
        case 1: {
          setState(2101);
          match(MySQLParser::COMMA_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(2104);
        alterTablespaceOption(); 
      }
      setState(2109);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 87, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceOptionContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceOptionContext::AlterTablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::AlterTablespaceOptionContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::AlterTablespaceOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEncryption() {
  return getRuleContext<MySQLParser::TsOptionEncryptionContext>(0);
}

MySQLParser::TsOptionEngineAttributeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEngineAttribute() {
  return getRuleContext<MySQLParser::TsOptionEngineAttributeContext>(0);
}


size_t MySQLParser::AlterTablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespaceOption;
}

void MySQLParser::AlterTablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespaceOption(this);
}

void MySQLParser::AlterTablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespaceOption(this);
}


std::any MySQLParser::AlterTablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceOptionContext* MySQLParser::alterTablespaceOption() {
  AlterTablespaceOptionContext *_localctx = _tracker.createInstance<AlterTablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 66, MySQLParser::RuleAlterTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2122);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 89, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2110);
      match(MySQLParser::INITIAL_SIZE_SYMBOL);
      setState(2112);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 88, _ctx)) {
      case 1: {
        setState(2111);
        match(MySQLParser::EQUAL_OPERATOR);
        break;
      }

      default:
        break;
      }
      setState(2114);
      sizeNumber();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2115);
      tsOptionAutoextendSize();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2116);
      tsOptionMaxSize();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(2117);
      tsOptionEngine();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(2118);
      tsOptionWait();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(2119);
      tsOptionEncryption();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(2120);

      if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
      setState(2121);
      tsOptionEngineAttribute();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ChangeTablespaceOptionContext ------------------------------------------------------------------

MySQLParser::ChangeTablespaceOptionContext::ChangeTablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ChangeTablespaceOptionContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::ChangeTablespaceOptionContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::ChangeTablespaceOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::ChangeTablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::ChangeTablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}


size_t MySQLParser::ChangeTablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleChangeTablespaceOption;
}

void MySQLParser::ChangeTablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterChangeTablespaceOption(this);
}

void MySQLParser::ChangeTablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitChangeTablespaceOption(this);
}


std::any MySQLParser::ChangeTablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitChangeTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ChangeTablespaceOptionContext* MySQLParser::changeTablespaceOption() {
  ChangeTablespaceOptionContext *_localctx = _tracker.createInstance<ChangeTablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 68, MySQLParser::RuleChangeTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2131);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2124);
        match(MySQLParser::INITIAL_SIZE_SYMBOL);
        setState(2126);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 90, _ctx)) {
        case 1: {
          setState(2125);
          match(MySQLParser::EQUAL_OPERATOR);
          break;
        }

        default:
          break;
        }
        setState(2128);
        sizeNumber();
        break;
      }

      case MySQLParser::AUTOEXTEND_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2129);
        tsOptionAutoextendSize();
        break;
      }

      case MySQLParser::MAX_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2130);
        tsOptionMaxSize();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterViewContext ------------------------------------------------------------------

MySQLParser::AlterViewContext::AlterViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewRefContext* MySQLParser::AlterViewContext::viewRef() {
  return getRuleContext<MySQLParser::ViewRefContext>(0);
}

MySQLParser::ViewTailContext* MySQLParser::AlterViewContext::viewTail() {
  return getRuleContext<MySQLParser::ViewTailContext>(0);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::AlterViewContext::viewAlgorithm() {
  return getRuleContext<MySQLParser::ViewAlgorithmContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::AlterViewContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::ViewSuidContext* MySQLParser::AlterViewContext::viewSuid() {
  return getRuleContext<MySQLParser::ViewSuidContext>(0);
}


size_t MySQLParser::AlterViewContext::getRuleIndex() const {
  return MySQLParser::RuleAlterView;
}

void MySQLParser::AlterViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterView(this);
}

void MySQLParser::AlterViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterView(this);
}


std::any MySQLParser::AlterViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterViewContext* MySQLParser::alterView() {
  AlterViewContext *_localctx = _tracker.createInstance<AlterViewContext>(_ctx, getState());
  enterRule(_localctx, 70, MySQLParser::RuleAlterView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2134);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL) {
      setState(2133);
      viewAlgorithm();
    }
    setState(2137);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2136);
      definerClause();
    }
    setState(2140);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SQL_SYMBOL) {
      setState(2139);
      viewSuid();
    }
    setState(2142);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2143);
    viewRef();
    setState(2144);
    viewTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewTailContext ------------------------------------------------------------------

MySQLParser::ViewTailContext::ViewTailContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewTailContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::ViewQueryBlockContext* MySQLParser::ViewTailContext::viewQueryBlock() {
  return getRuleContext<MySQLParser::ViewQueryBlockContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::ViewTailContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::ViewTailContext::getRuleIndex() const {
  return MySQLParser::RuleViewTail;
}

void MySQLParser::ViewTailContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewTail(this);
}

void MySQLParser::ViewTailContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewTail(this);
}


std::any MySQLParser::ViewTailContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewTail(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewTailContext* MySQLParser::viewTail() {
  ViewTailContext *_localctx = _tracker.createInstance<ViewTailContext>(_ctx, getState());
  enterRule(_localctx, 72, MySQLParser::RuleViewTail);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2147);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2146);
      columnInternalRefList();
    }
    setState(2149);
    match(MySQLParser::AS_SYMBOL);
    setState(2150);
    viewQueryBlock();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewQueryBlockContext ------------------------------------------------------------------

MySQLParser::ViewQueryBlockContext::ViewQueryBlockContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::ViewQueryBlockContext::queryExpressionWithOptLockingClauses() {
  return getRuleContext<MySQLParser::QueryExpressionWithOptLockingClausesContext>(0);
}

MySQLParser::ViewCheckOptionContext* MySQLParser::ViewQueryBlockContext::viewCheckOption() {
  return getRuleContext<MySQLParser::ViewCheckOptionContext>(0);
}


size_t MySQLParser::ViewQueryBlockContext::getRuleIndex() const {
  return MySQLParser::RuleViewQueryBlock;
}

void MySQLParser::ViewQueryBlockContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewQueryBlock(this);
}

void MySQLParser::ViewQueryBlockContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewQueryBlock(this);
}


std::any MySQLParser::ViewQueryBlockContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewQueryBlock(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewQueryBlockContext* MySQLParser::viewQueryBlock() {
  ViewQueryBlockContext *_localctx = _tracker.createInstance<ViewQueryBlockContext>(_ctx, getState());
  enterRule(_localctx, 74, MySQLParser::RuleViewQueryBlock);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2152);
    queryExpressionWithOptLockingClauses();
    setState(2154);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::WITH_SYMBOL) {
      setState(2153);
      viewCheckOption();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewCheckOptionContext ------------------------------------------------------------------

MySQLParser::ViewCheckOptionContext::ViewCheckOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::OPTION_SYMBOL() {
  return getToken(MySQLParser::OPTION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::CASCADED_SYMBOL() {
  return getToken(MySQLParser::CASCADED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::LOCAL_SYMBOL() {
  return getToken(MySQLParser::LOCAL_SYMBOL, 0);
}


size_t MySQLParser::ViewCheckOptionContext::getRuleIndex() const {
  return MySQLParser::RuleViewCheckOption;
}

void MySQLParser::ViewCheckOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewCheckOption(this);
}

void MySQLParser::ViewCheckOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewCheckOption(this);
}


std::any MySQLParser::ViewCheckOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewCheckOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewCheckOptionContext* MySQLParser::viewCheckOption() {
  ViewCheckOptionContext *_localctx = _tracker.createInstance<ViewCheckOptionContext>(_ctx, getState());
  enterRule(_localctx, 76, MySQLParser::RuleViewCheckOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2156);
    match(MySQLParser::WITH_SYMBOL);
    setState(2158);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADED_SYMBOL || _la == MySQLParser::LOCAL_SYMBOL) {
      setState(2157);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADED_SYMBOL || _la == MySQLParser::LOCAL_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(2160);
    match(MySQLParser::CHECK_SYMBOL);
    setState(2161);
    match(MySQLParser::OPTION_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterInstanceStatementContext ------------------------------------------------------------------

MySQLParser::AlterInstanceStatementContext::AlterInstanceStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::INSTANCE_SYMBOL() {
  return getToken(MySQLParser::INSTANCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ROTATE_SYMBOL() {
  return getToken(MySQLParser::ROTATE_SYMBOL, 0);
}

MySQLParser::TextOrIdentifierContext* MySQLParser::AlterInstanceStatementContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::MASTER_SYMBOL() {
  return getToken(MySQLParser::MASTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::RELOAD_SYMBOL() {
  return getToken(MySQLParser::RELOAD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::TLS_SYMBOL() {
  return getToken(MySQLParser::TLS_SYMBOL, 0);
}

std::vector<MySQLParser::IdentifierContext *> MySQLParser::AlterInstanceStatementContext::identifier() {
  return getRuleContexts<MySQLParser::IdentifierContext>();
}

MySQLParser::IdentifierContext* MySQLParser::AlterInstanceStatementContext::identifier(size_t i) {
  return getRuleContext<MySQLParser::IdentifierContext>(i);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::KEYRING_SYMBOL() {
  return getToken(MySQLParser::KEYRING_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::CHANNEL_SYMBOL() {
  return getToken(MySQLParser::CHANNEL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ROLLBACK_SYMBOL() {
  return getToken(MySQLParser::ROLLBACK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterInstanceStatementContext::ERROR_SYMBOL() {
  return getToken(MySQLParser::ERROR_SYMBOL, 0);
}


size_t MySQLParser::AlterInstanceStatementContext::getRuleIndex() const {
  return MySQLParser::RuleAlterInstanceStatement;
}

void MySQLParser::AlterInstanceStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterInstanceStatement(this);
}

void MySQLParser::AlterInstanceStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterInstanceStatement(this);
}


std::any MySQLParser::AlterInstanceStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterInstanceStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterInstanceStatementContext* MySQLParser::alterInstanceStatement() {
  AlterInstanceStatementContext *_localctx = _tracker.createInstance<AlterInstanceStatementContext>(_ctx, getState());
  enterRule(_localctx, 78, MySQLParser::RuleAlterInstanceStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2196);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 101, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2163);

      if (!(serverVersion >= 50713)) throw FailedPredicateException(this, "serverVersion >= 50713");
      setState(2164);
      match(MySQLParser::INSTANCE_SYMBOL);
      setState(2193);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 100, _ctx)) {
      case 1: {
        setState(2165);
        match(MySQLParser::ROTATE_SYMBOL);
        setState(2166);
        textOrIdentifier();
        setState(2167);
        match(MySQLParser::MASTER_SYMBOL);
        setState(2168);
        match(MySQLParser::KEY_SYMBOL);
        break;
      }

      case 2: {
        setState(2170);

        if (!(serverVersion >= 80016)) throw FailedPredicateException(this, "serverVersion >= 80016");
        setState(2171);
        match(MySQLParser::RELOAD_SYMBOL);
        setState(2172);
        match(MySQLParser::TLS_SYMBOL);
        setState(2177);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 98, _ctx)) {
        case 1: {
          setState(2173);

          if (!(serverVersion >= 80021)) throw FailedPredicateException(this, "serverVersion >= 80021");
          setState(2174);
          match(MySQLParser::FOR_SYMBOL);
          setState(2175);
          match(MySQLParser::CHANNEL_SYMBOL);
          setState(2176);
          identifier();
          break;
        }

        default:
          break;
        }
        setState(2183);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::NO_SYMBOL) {
          setState(2179);
          match(MySQLParser::NO_SYMBOL);
          setState(2180);
          match(MySQLParser::ROLLBACK_SYMBOL);
          setState(2181);
          match(MySQLParser::ON_SYMBOL);
          setState(2182);
          match(MySQLParser::ERROR_SYMBOL);
        }
        break;
      }

      case 3: {
        setState(2185);

        if (!(serverVersion >= 80021)) throw FailedPredicateException(this, "serverVersion >= 80021");
        setState(2186);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::DISABLE_SYMBOL

        || _la == MySQLParser::ENABLE_SYMBOL)) {
        _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        setState(2187);
        identifier();
        setState(2188);
        identifier();
        break;
      }

      case 4: {
        setState(2190);

        if (!(serverVersion >= 80024)) throw FailedPredicateException(this, "serverVersion >= 80024");
        setState(2191);
        match(MySQLParser::RELOAD_SYMBOL);
        setState(2192);
        match(MySQLParser::KEYRING_SYMBOL);
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);

      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateStatementContext ------------------------------------------------------------------

MySQLParser::CreateStatementContext::CreateStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateStatementContext::CREATE_SYMBOL() {
  return getToken(MySQLParser::CREATE_SYMBOL, 0);
}

MySQLParser::CreateDatabaseContext* MySQLParser::CreateStatementContext::createDatabase() {
  return getRuleContext<MySQLParser::CreateDatabaseContext>(0);
}

MySQLParser::CreateTableContext* MySQLParser::CreateStatementContext::createTable() {
  return getRuleContext<MySQLParser::CreateTableContext>(0);
}

MySQLParser::CreateFunctionContext* MySQLParser::CreateStatementContext::createFunction() {
  return getRuleContext<MySQLParser::CreateFunctionContext>(0);
}

MySQLParser::CreateProcedureContext* MySQLParser::CreateStatementContext::createProcedure() {
  return getRuleContext<MySQLParser::CreateProcedureContext>(0);
}

MySQLParser::CreateUdfContext* MySQLParser::CreateStatementContext::createUdf() {
  return getRuleContext<MySQLParser::CreateUdfContext>(0);
}

MySQLParser::CreateLogfileGroupContext* MySQLParser::CreateStatementContext::createLogfileGroup() {
  return getRuleContext<MySQLParser::CreateLogfileGroupContext>(0);
}

MySQLParser::CreateViewContext* MySQLParser::CreateStatementContext::createView() {
  return getRuleContext<MySQLParser::CreateViewContext>(0);
}

MySQLParser::CreateTriggerContext* MySQLParser::CreateStatementContext::createTrigger() {
  return getRuleContext<MySQLParser::CreateTriggerContext>(0);
}

MySQLParser::CreateIndexContext* MySQLParser::CreateStatementContext::createIndex() {
  return getRuleContext<MySQLParser::CreateIndexContext>(0);
}

MySQLParser::CreateServerContext* MySQLParser::CreateStatementContext::createServer() {
  return getRuleContext<MySQLParser::CreateServerContext>(0);
}

MySQLParser::CreateTablespaceContext* MySQLParser::CreateStatementContext::createTablespace() {
  return getRuleContext<MySQLParser::CreateTablespaceContext>(0);
}

MySQLParser::CreateEventContext* MySQLParser::CreateStatementContext::createEvent() {
  return getRuleContext<MySQLParser::CreateEventContext>(0);
}

MySQLParser::CreateRoleContext* MySQLParser::CreateStatementContext::createRole() {
  return getRuleContext<MySQLParser::CreateRoleContext>(0);
}

MySQLParser::CreateSpatialReferenceContext* MySQLParser::CreateStatementContext::createSpatialReference() {
  return getRuleContext<MySQLParser::CreateSpatialReferenceContext>(0);
}

MySQLParser::CreateUndoTablespaceContext* MySQLParser::CreateStatementContext::createUndoTablespace() {
  return getRuleContext<MySQLParser::CreateUndoTablespaceContext>(0);
}


size_t MySQLParser::CreateStatementContext::getRuleIndex() const {
  return MySQLParser::RuleCreateStatement;
}

void MySQLParser::CreateStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateStatement(this);
}

void MySQLParser::CreateStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateStatement(this);
}


std::any MySQLParser::CreateStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateStatementContext* MySQLParser::createStatement() {
  CreateStatementContext *_localctx = _tracker.createInstance<CreateStatementContext>(_ctx, getState());
  enterRule(_localctx, 80, MySQLParser::RuleCreateStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2198);
    match(MySQLParser::CREATE_SYMBOL);
    setState(2217);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 102, _ctx)) {
    case 1: {
      setState(2199);
      createDatabase();
      break;
    }

    case 2: {
      setState(2200);
      createTable();
      break;
    }

    case 3: {
      setState(2201);
      createFunction();
      break;
    }

    case 4: {
      setState(2202);
      createProcedure();
      break;
    }

    case 5: {
      setState(2203);
      createUdf();
      break;
    }

    case 6: {
      setState(2204);
      createLogfileGroup();
      break;
    }

    case 7: {
      setState(2205);
      createView();
      break;
    }

    case 8: {
      setState(2206);
      createTrigger();
      break;
    }

    case 9: {
      setState(2207);
      createIndex();
      break;
    }

    case 10: {
      setState(2208);
      createServer();
      break;
    }

    case 11: {
      setState(2209);
      createTablespace();
      break;
    }

    case 12: {
      setState(2210);
      createEvent();
      break;
    }

    case 13: {
      setState(2211);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2212);
      createRole();
      break;
    }

    case 14: {
      setState(2213);

      if (!(serverVersion >= 80011)) throw FailedPredicateException(this, "serverVersion >= 80011");
      setState(2214);
      createSpatialReference();
      break;
    }

    case 15: {
      setState(2215);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2216);
      createUndoTablespace();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateDatabaseContext ------------------------------------------------------------------

MySQLParser::CreateDatabaseContext::CreateDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaNameContext* MySQLParser::CreateDatabaseContext::schemaName() {
  return getRuleContext<MySQLParser::SchemaNameContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateDatabaseContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::CreateDatabaseOptionContext *> MySQLParser::CreateDatabaseContext::createDatabaseOption() {
  return getRuleContexts<MySQLParser::CreateDatabaseOptionContext>();
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::CreateDatabaseContext::createDatabaseOption(size_t i) {
  return getRuleContext<MySQLParser::CreateDatabaseOptionContext>(i);
}


size_t MySQLParser::CreateDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleCreateDatabase;
}

void MySQLParser::CreateDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateDatabase(this);
}

void MySQLParser::CreateDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateDatabase(this);
}


std::any MySQLParser::CreateDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateDatabaseContext* MySQLParser::createDatabase() {
  CreateDatabaseContext *_localctx = _tracker.createInstance<CreateDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 82, MySQLParser::RuleCreateDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2219);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(2221);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 103, _ctx)) {
    case 1: {
      setState(2220);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2223);
    schemaName();
    setState(2227);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 104, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2224);
        createDatabaseOption(); 
      }
      setState(2229);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 104, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateDatabaseOptionContext ------------------------------------------------------------------

MySQLParser::CreateDatabaseOptionContext::CreateDatabaseOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::DefaultCharsetContext* MySQLParser::CreateDatabaseOptionContext::defaultCharset() {
  return getRuleContext<MySQLParser::DefaultCharsetContext>(0);
}

MySQLParser::DefaultCollationContext* MySQLParser::CreateDatabaseOptionContext::defaultCollation() {
  return getRuleContext<MySQLParser::DefaultCollationContext>(0);
}

MySQLParser::DefaultEncryptionContext* MySQLParser::CreateDatabaseOptionContext::defaultEncryption() {
  return getRuleContext<MySQLParser::DefaultEncryptionContext>(0);
}


size_t MySQLParser::CreateDatabaseOptionContext::getRuleIndex() const {
  return MySQLParser::RuleCreateDatabaseOption;
}

void MySQLParser::CreateDatabaseOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateDatabaseOption(this);
}

void MySQLParser::CreateDatabaseOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateDatabaseOption(this);
}


std::any MySQLParser::CreateDatabaseOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateDatabaseOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::createDatabaseOption() {
  CreateDatabaseOptionContext *_localctx = _tracker.createInstance<CreateDatabaseOptionContext>(_ctx, getState());
  enterRule(_localctx, 84, MySQLParser::RuleCreateDatabaseOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2234);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 105, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2230);
      defaultCharset();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2231);
      defaultCollation();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2232);

      if (!(serverVersion >= 80016)) throw FailedPredicateException(this, "serverVersion >= 80016");
      setState(2233);
      defaultEncryption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTableContext ------------------------------------------------------------------

MySQLParser::CreateTableContext::CreateTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::CreateTableContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::LIKE_SYMBOL() {
  return getToken(MySQLParser::LIKE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::TEMPORARY_SYMBOL() {
  return getToken(MySQLParser::TEMPORARY_SYMBOL, 0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateTableContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

MySQLParser::TableElementListContext* MySQLParser::CreateTableContext::tableElementList() {
  return getRuleContext<MySQLParser::TableElementListContext>(0);
}

MySQLParser::CreateTableOptionsEtcContext* MySQLParser::CreateTableContext::createTableOptionsEtc() {
  return getRuleContext<MySQLParser::CreateTableOptionsEtcContext>(0);
}


size_t MySQLParser::CreateTableContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTable;
}

void MySQLParser::CreateTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTable(this);
}

void MySQLParser::CreateTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTable(this);
}


std::any MySQLParser::CreateTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTableContext* MySQLParser::createTable() {
  CreateTableContext *_localctx = _tracker.createInstance<CreateTableContext>(_ctx, getState());
  enterRule(_localctx, 86, MySQLParser::RuleCreateTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2237);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::TEMPORARY_SYMBOL) {
      setState(2236);
      match(MySQLParser::TEMPORARY_SYMBOL);
    }
    setState(2239);
    match(MySQLParser::TABLE_SYMBOL);
    setState(2241);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 107, _ctx)) {
    case 1: {
      setState(2240);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2243);
    tableName();
    setState(2260);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 110, _ctx)) {
    case 1: {
      setState(2248);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 108, _ctx)) {
      case 1: {
        setState(2244);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(2245);
        tableElementList();
        setState(2246);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(2251);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 109, _ctx)) {
      case 1: {
        setState(2250);
        createTableOptionsEtc();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2253);
      match(MySQLParser::LIKE_SYMBOL);
      setState(2254);
      tableRef();
      break;
    }

    case 3: {
      setState(2255);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2256);
      match(MySQLParser::LIKE_SYMBOL);
      setState(2257);
      tableRef();
      setState(2258);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableElementListContext ------------------------------------------------------------------

MySQLParser::TableElementListContext::TableElementListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TableElementContext *> MySQLParser::TableElementListContext::tableElement() {
  return getRuleContexts<MySQLParser::TableElementContext>();
}

MySQLParser::TableElementContext* MySQLParser::TableElementListContext::tableElement(size_t i) {
  return getRuleContext<MySQLParser::TableElementContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TableElementListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TableElementListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TableElementListContext::getRuleIndex() const {
  return MySQLParser::RuleTableElementList;
}

void MySQLParser::TableElementListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableElementList(this);
}

void MySQLParser::TableElementListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableElementList(this);
}


std::any MySQLParser::TableElementListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableElementList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableElementListContext* MySQLParser::tableElementList() {
  TableElementListContext *_localctx = _tracker.createInstance<TableElementListContext>(_ctx, getState());
  enterRule(_localctx, 88, MySQLParser::RuleTableElementList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2262);
    tableElement();
    setState(2267);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2263);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2264);
      tableElement();
      setState(2269);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableElementContext ------------------------------------------------------------------

MySQLParser::TableElementContext::TableElementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::ColumnDefinitionContext* MySQLParser::TableElementContext::columnDefinition() {
  return getRuleContext<MySQLParser::ColumnDefinitionContext>(0);
}

MySQLParser::TableConstraintDefContext* MySQLParser::TableElementContext::tableConstraintDef() {
  return getRuleContext<MySQLParser::TableConstraintDefContext>(0);
}


size_t MySQLParser::TableElementContext::getRuleIndex() const {
  return MySQLParser::RuleTableElement;
}

void MySQLParser::TableElementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableElement(this);
}

void MySQLParser::TableElementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableElement(this);
}


std::any MySQLParser::TableElementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableElement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableElementContext* MySQLParser::tableElement() {
  TableElementContext *_localctx = _tracker.createInstance<TableElementContext>(_ctx, getState());
  enterRule(_localctx, 90, MySQLParser::RuleTableElement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2272);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 112, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2270);
      columnDefinition();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2271);
      tableConstraintDef();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DuplicateAsQeContext ------------------------------------------------------------------

MySQLParser::DuplicateAsQeContext::DuplicateAsQeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AsCreateQueryExpressionContext* MySQLParser::DuplicateAsQeContext::asCreateQueryExpression() {
  return getRuleContext<MySQLParser::AsCreateQueryExpressionContext>(0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQeContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQeContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::DuplicateAsQeContext::getRuleIndex() const {
  return MySQLParser::RuleDuplicateAsQe;
}

void MySQLParser::DuplicateAsQeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDuplicateAsQe(this);
}

void MySQLParser::DuplicateAsQeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDuplicateAsQe(this);
}


std::any MySQLParser::DuplicateAsQeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDuplicateAsQe(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DuplicateAsQeContext* MySQLParser::duplicateAsQe() {
  DuplicateAsQeContext *_localctx = _tracker.createInstance<DuplicateAsQeContext>(_ctx, getState());
  enterRule(_localctx, 92, MySQLParser::RuleDuplicateAsQe);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2275);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 113, _ctx)) {
    case 1: {
      setState(2274);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(2277);
    asCreateQueryExpression();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AsCreateQueryExpressionContext ------------------------------------------------------------------

MySQLParser::AsCreateQueryExpressionContext::AsCreateQueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::AsCreateQueryExpressionContext::queryExpressionWithOptLockingClauses() {
  return getRuleContext<MySQLParser::QueryExpressionWithOptLockingClausesContext>(0);
}

tree::TerminalNode* MySQLParser::AsCreateQueryExpressionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}


size_t MySQLParser::AsCreateQueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleAsCreateQueryExpression;
}

void MySQLParser::AsCreateQueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAsCreateQueryExpression(this);
}

void MySQLParser::AsCreateQueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAsCreateQueryExpression(this);
}


std::any MySQLParser::AsCreateQueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAsCreateQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AsCreateQueryExpressionContext* MySQLParser::asCreateQueryExpression() {
  AsCreateQueryExpressionContext *_localctx = _tracker.createInstance<AsCreateQueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 94, MySQLParser::RuleAsCreateQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2280);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 114, _ctx)) {
    case 1: {
      setState(2279);
      match(MySQLParser::AS_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2282);
    queryExpressionWithOptLockingClauses();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionOrParensContext ------------------------------------------------------------------

MySQLParser::QueryExpressionOrParensContext::QueryExpressionOrParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::QueryExpressionOrParensContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::QueryExpressionOrParensContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionOrParensContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::QueryExpressionOrParensContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionOrParens;
}

void MySQLParser::QueryExpressionOrParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionOrParens(this);
}

void MySQLParser::QueryExpressionOrParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionOrParens(this);
}


std::any MySQLParser::QueryExpressionOrParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionOrParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::queryExpressionOrParens() {
  QueryExpressionOrParensContext *_localctx = _tracker.createInstance<QueryExpressionOrParensContext>(_ctx, getState());
  enterRule(_localctx, 96, MySQLParser::RuleQueryExpressionOrParens);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2289);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 116, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2284);
      queryExpression();
      setState(2286);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 115, _ctx)) {
      case 1: {
        setState(2285);
        lockingClauseList();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2288);
      queryExpressionParens();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionWithOptLockingClausesContext ------------------------------------------------------------------

MySQLParser::QueryExpressionWithOptLockingClausesContext::QueryExpressionWithOptLockingClausesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::QueryExpressionWithOptLockingClausesContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::QueryExpressionWithOptLockingClausesContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}


size_t MySQLParser::QueryExpressionWithOptLockingClausesContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionWithOptLockingClauses;
}

void MySQLParser::QueryExpressionWithOptLockingClausesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionWithOptLockingClauses(this);
}

void MySQLParser::QueryExpressionWithOptLockingClausesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionWithOptLockingClauses(this);
}


std::any MySQLParser::QueryExpressionWithOptLockingClausesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionWithOptLockingClauses(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::queryExpressionWithOptLockingClauses() {
  QueryExpressionWithOptLockingClausesContext *_localctx = _tracker.createInstance<QueryExpressionWithOptLockingClausesContext>(_ctx, getState());
  enterRule(_localctx, 98, MySQLParser::RuleQueryExpressionWithOptLockingClauses);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2291);
    queryExpression();
    setState(2293);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 117, _ctx)) {
    case 1: {
      setState(2292);
      lockingClauseList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateRoutineContext ------------------------------------------------------------------

MySQLParser::CreateRoutineContext::CreateRoutineContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::CREATE_SYMBOL() {
  return getToken(MySQLParser::CREATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::EOF() {
  return getToken(MySQLParser::EOF, 0);
}

MySQLParser::CreateProcedureContext* MySQLParser::CreateRoutineContext::createProcedure() {
  return getRuleContext<MySQLParser::CreateProcedureContext>(0);
}

MySQLParser::CreateFunctionContext* MySQLParser::CreateRoutineContext::createFunction() {
  return getRuleContext<MySQLParser::CreateFunctionContext>(0);
}

MySQLParser::CreateUdfContext* MySQLParser::CreateRoutineContext::createUdf() {
  return getRuleContext<MySQLParser::CreateUdfContext>(0);
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::SEMICOLON_SYMBOL() {
  return getToken(MySQLParser::SEMICOLON_SYMBOL, 0);
}


size_t MySQLParser::CreateRoutineContext::getRuleIndex() const {
  return MySQLParser::RuleCreateRoutine;
}

void MySQLParser::CreateRoutineContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateRoutine(this);
}

void MySQLParser::CreateRoutineContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateRoutine(this);
}


std::any MySQLParser::CreateRoutineContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateRoutine(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateRoutineContext* MySQLParser::createRoutine() {
  CreateRoutineContext *_localctx = _tracker.createInstance<CreateRoutineContext>(_ctx, getState());
  enterRule(_localctx, 100, MySQLParser::RuleCreateRoutine);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2295);
    match(MySQLParser::CREATE_SYMBOL);
    setState(2299);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 118, _ctx)) {
    case 1: {
      setState(2296);
      createProcedure();
      break;
    }

    case 2: {
      setState(2297);
      createFunction();
      break;
    }

    case 3: {
      setState(2298);
      createUdf();
      break;
    }

    default:
      break;
    }
    setState(2302);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SEMICOLON_SYMBOL) {
      setState(2301);
      match(MySQLParser::SEMICOLON_SYMBOL);
    }
    setState(2304);
    match(MySQLParser::EOF);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateProcedureContext ------------------------------------------------------------------

MySQLParser::CreateProcedureContext::CreateProcedureContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureNameContext* MySQLParser::CreateProcedureContext::procedureName() {
  return getRuleContext<MySQLParser::ProcedureNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::StoredRoutineBodyContext* MySQLParser::CreateProcedureContext::storedRoutineBody() {
  return getRuleContext<MySQLParser::StoredRoutineBodyContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateProcedureContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateProcedureContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::ProcedureParameterContext *> MySQLParser::CreateProcedureContext::procedureParameter() {
  return getRuleContexts<MySQLParser::ProcedureParameterContext>();
}

MySQLParser::ProcedureParameterContext* MySQLParser::CreateProcedureContext::procedureParameter(size_t i) {
  return getRuleContext<MySQLParser::ProcedureParameterContext>(i);
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::CreateProcedureContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::CreateProcedureContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateProcedureContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::CreateProcedureContext::getRuleIndex() const {
  return MySQLParser::RuleCreateProcedure;
}

void MySQLParser::CreateProcedureContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateProcedure(this);
}

void MySQLParser::CreateProcedureContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateProcedure(this);
}


std::any MySQLParser::CreateProcedureContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateProcedure(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateProcedureContext* MySQLParser::createProcedure() {
  CreateProcedureContext *_localctx = _tracker.createInstance<CreateProcedureContext>(_ctx, getState());
  enterRule(_localctx, 102, MySQLParser::RuleCreateProcedure);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2307);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2306);
      definerClause();
    }
    setState(2309);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(2312);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 121, _ctx)) {
    case 1: {
      setState(2310);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2311);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2314);
    procedureName();
    setState(2315);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2324);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 123, _ctx)) {
    case 1: {
      setState(2316);
      procedureParameter();
      setState(2321);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2317);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2318);
        procedureParameter();
        setState(2323);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    default:
      break;
    }
    setState(2326);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(2330);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 124, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2327);
        routineCreateOption(); 
      }
      setState(2332);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 124, _ctx);
    }
    setState(2333);
    storedRoutineBody();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineStringContext ------------------------------------------------------------------

MySQLParser::RoutineStringContext::RoutineStringContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextStringLiteralContext* MySQLParser::RoutineStringContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineStringContext::DOLLAR_QUOTED_STRING_TEXT() {
  return getToken(MySQLParser::DOLLAR_QUOTED_STRING_TEXT, 0);
}


size_t MySQLParser::RoutineStringContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineString;
}

void MySQLParser::RoutineStringContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineString(this);
}

void MySQLParser::RoutineStringContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineString(this);
}


std::any MySQLParser::RoutineStringContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineString(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineStringContext* MySQLParser::routineString() {
  RoutineStringContext *_localctx = _tracker.createInstance<RoutineStringContext>(_ctx, getState());
  enterRule(_localctx, 104, MySQLParser::RuleRoutineString);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2337);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 125, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2335);
      textStringLiteral();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2336);
      match(MySQLParser::DOLLAR_QUOTED_STRING_TEXT);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- StoredRoutineBodyContext ------------------------------------------------------------------

MySQLParser::StoredRoutineBodyContext::StoredRoutineBodyContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::CompoundStatementContext* MySQLParser::StoredRoutineBodyContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::StoredRoutineBodyContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::RoutineStringContext* MySQLParser::StoredRoutineBodyContext::routineString() {
  return getRuleContext<MySQLParser::RoutineStringContext>(0);
}


size_t MySQLParser::StoredRoutineBodyContext::getRuleIndex() const {
  return MySQLParser::RuleStoredRoutineBody;
}

void MySQLParser::StoredRoutineBodyContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterStoredRoutineBody(this);
}

void MySQLParser::StoredRoutineBodyContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitStoredRoutineBody(this);
}


std::any MySQLParser::StoredRoutineBodyContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitStoredRoutineBody(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::StoredRoutineBodyContext* MySQLParser::storedRoutineBody() {
  StoredRoutineBodyContext *_localctx = _tracker.createInstance<StoredRoutineBodyContext>(_ctx, getState());
  enterRule(_localctx, 106, MySQLParser::RuleStoredRoutineBody);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2343);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 126, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2339);
      compoundStatement();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2340);

      if (!(serverVersion >= 80032 && supportMle)) throw FailedPredicateException(this, "serverVersion >= 80032 && supportMle");
      setState(2341);
      match(MySQLParser::AS_SYMBOL);
      setState(2342);
      routineString();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateFunctionContext ------------------------------------------------------------------

MySQLParser::CreateFunctionContext::CreateFunctionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionNameContext* MySQLParser::CreateFunctionContext::functionName() {
  return getRuleContext<MySQLParser::FunctionNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::RETURNS_SYMBOL() {
  return getToken(MySQLParser::RETURNS_SYMBOL, 0);
}

MySQLParser::TypeWithOptCollateContext* MySQLParser::CreateFunctionContext::typeWithOptCollate() {
  return getRuleContext<MySQLParser::TypeWithOptCollateContext>(0);
}

MySQLParser::StoredRoutineBodyContext* MySQLParser::CreateFunctionContext::storedRoutineBody() {
  return getRuleContext<MySQLParser::StoredRoutineBodyContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateFunctionContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateFunctionContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::FunctionParameterContext *> MySQLParser::CreateFunctionContext::functionParameter() {
  return getRuleContexts<MySQLParser::FunctionParameterContext>();
}

MySQLParser::FunctionParameterContext* MySQLParser::CreateFunctionContext::functionParameter(size_t i) {
  return getRuleContext<MySQLParser::FunctionParameterContext>(i);
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::CreateFunctionContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::CreateFunctionContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateFunctionContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::CreateFunctionContext::getRuleIndex() const {
  return MySQLParser::RuleCreateFunction;
}

void MySQLParser::CreateFunctionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateFunction(this);
}

void MySQLParser::CreateFunctionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateFunction(this);
}


std::any MySQLParser::CreateFunctionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateFunction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateFunctionContext* MySQLParser::createFunction() {
  CreateFunctionContext *_localctx = _tracker.createInstance<CreateFunctionContext>(_ctx, getState());
  enterRule(_localctx, 108, MySQLParser::RuleCreateFunction);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2346);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2345);
      definerClause();
    }
    setState(2348);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2351);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 128, _ctx)) {
    case 1: {
      setState(2349);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2350);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2353);
    functionName();
    setState(2354);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2363);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 130, _ctx)) {
    case 1: {
      setState(2355);
      functionParameter();
      setState(2360);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2356);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2357);
        functionParameter();
        setState(2362);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    default:
      break;
    }
    setState(2365);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(2366);
    match(MySQLParser::RETURNS_SYMBOL);
    setState(2367);
    typeWithOptCollate();
    setState(2371);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 131, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2368);
        routineCreateOption(); 
      }
      setState(2373);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 131, _ctx);
    }
    setState(2374);
    storedRoutineBody();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateUdfContext ------------------------------------------------------------------

MySQLParser::CreateUdfContext::CreateUdfContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateUdfContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::UdfNameContext* MySQLParser::CreateUdfContext::udfName() {
  return getRuleContext<MySQLParser::UdfNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::RETURNS_SYMBOL() {
  return getToken(MySQLParser::RETURNS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::SONAME_SYMBOL() {
  return getToken(MySQLParser::SONAME_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateUdfContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::STRING_SYMBOL() {
  return getToken(MySQLParser::STRING_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::INT_SYMBOL() {
  return getToken(MySQLParser::INT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::REAL_SYMBOL() {
  return getToken(MySQLParser::REAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::DECIMAL_SYMBOL() {
  return getToken(MySQLParser::DECIMAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::AGGREGATE_SYMBOL() {
  return getToken(MySQLParser::AGGREGATE_SYMBOL, 0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateUdfContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateUdfContext::getRuleIndex() const {
  return MySQLParser::RuleCreateUdf;
}

void MySQLParser::CreateUdfContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateUdf(this);
}

void MySQLParser::CreateUdfContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateUdf(this);
}


std::any MySQLParser::CreateUdfContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateUdf(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateUdfContext* MySQLParser::createUdf() {
  CreateUdfContext *_localctx = _tracker.createInstance<CreateUdfContext>(_ctx, getState());
  enterRule(_localctx, 110, MySQLParser::RuleCreateUdf);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2377);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::AGGREGATE_SYMBOL) {
      setState(2376);
      match(MySQLParser::AGGREGATE_SYMBOL);
    }
    setState(2379);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2382);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 133, _ctx)) {
    case 1: {
      setState(2380);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2381);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2384);
    udfName();
    setState(2385);
    match(MySQLParser::RETURNS_SYMBOL);
    setState(2386);
    antlrcpp::downCast<CreateUdfContext *>(_localctx)->type = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DECIMAL_SYMBOL || _la == MySQLParser::INT_SYMBOL || _la == MySQLParser::REAL_SYMBOL || _la == MySQLParser::STRING_SYMBOL)) {
      antlrcpp::downCast<CreateUdfContext *>(_localctx)->type = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2387);
    match(MySQLParser::SONAME_SYMBOL);
    setState(2388);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineCreateOptionContext ------------------------------------------------------------------

MySQLParser::RoutineCreateOptionContext::RoutineCreateOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::RoutineOptionContext* MySQLParser::RoutineCreateOptionContext::routineOption() {
  return getRuleContext<MySQLParser::RoutineOptionContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineCreateOptionContext::DETERMINISTIC_SYMBOL() {
  return getToken(MySQLParser::DETERMINISTIC_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineCreateOptionContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}


size_t MySQLParser::RoutineCreateOptionContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineCreateOption;
}

void MySQLParser::RoutineCreateOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineCreateOption(this);
}

void MySQLParser::RoutineCreateOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineCreateOption(this);
}


std::any MySQLParser::RoutineCreateOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineCreateOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::routineCreateOption() {
  RoutineCreateOptionContext *_localctx = _tracker.createInstance<RoutineCreateOptionContext>(_ctx, getState());
  enterRule(_localctx, 112, MySQLParser::RuleRoutineCreateOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2395);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::CONTAINS_SYMBOL:
      case MySQLParser::LANGUAGE_SYMBOL:
      case MySQLParser::MODIFIES_SYMBOL:
      case MySQLParser::NO_SYMBOL:
      case MySQLParser::READS_SYMBOL:
      case MySQLParser::SQL_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2390);
        routineOption();
        break;
      }

      case MySQLParser::DETERMINISTIC_SYMBOL:
      case MySQLParser::NOT_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2392);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::NOT_SYMBOL) {
          setState(2391);
          match(MySQLParser::NOT_SYMBOL);
        }
        setState(2394);
        match(MySQLParser::DETERMINISTIC_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineAlterOptionsContext ------------------------------------------------------------------

MySQLParser::RoutineAlterOptionsContext::RoutineAlterOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::RoutineAlterOptionsContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::RoutineAlterOptionsContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}


size_t MySQLParser::RoutineAlterOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineAlterOptions;
}

void MySQLParser::RoutineAlterOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineAlterOptions(this);
}

void MySQLParser::RoutineAlterOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineAlterOptions(this);
}


std::any MySQLParser::RoutineAlterOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineAlterOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineAlterOptionsContext* MySQLParser::routineAlterOptions() {
  RoutineAlterOptionsContext *_localctx = _tracker.createInstance<RoutineAlterOptionsContext>(_ctx, getState());
  enterRule(_localctx, 114, MySQLParser::RuleRoutineAlterOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2398); 
    _errHandler->sync(this);
    _la = _input->LA(1);
    do {
      setState(2397);
      routineCreateOption();
      setState(2400); 
      _errHandler->sync(this);
      _la = _input->LA(1);
    } while (((((_la - 119) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 119)) & ((1ULL << (MySQLParser::COMMENT_SYMBOL - 119))
      | (1ULL << (MySQLParser::CONTAINS_SYMBOL - 119))
      | (1ULL << (MySQLParser::DETERMINISTIC_SYMBOL - 119)))) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 378) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 378)) & ((1ULL << (MySQLParser::MODIFIES_SYMBOL - 378))
      | (1ULL << (MySQLParser::NOT_SYMBOL - 378))
      | (1ULL << (MySQLParser::NO_SYMBOL - 378)))) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineOptionContext ------------------------------------------------------------------

MySQLParser::RoutineOptionContext::RoutineOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextLiteralContext* MySQLParser::RoutineOptionContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::LANGUAGE_SYMBOL() {
  return getToken(MySQLParser::LANGUAGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::SQL_SYMBOL() {
  return getToken(MySQLParser::SQL_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::RoutineOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::CONTAINS_SYMBOL() {
  return getToken(MySQLParser::CONTAINS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::READS_SYMBOL() {
  return getToken(MySQLParser::READS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::MODIFIES_SYMBOL() {
  return getToken(MySQLParser::MODIFIES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::SECURITY_SYMBOL() {
  return getToken(MySQLParser::SECURITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::DEFINER_SYMBOL() {
  return getToken(MySQLParser::DEFINER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::INVOKER_SYMBOL() {
  return getToken(MySQLParser::INVOKER_SYMBOL, 0);
}


size_t MySQLParser::RoutineOptionContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineOption;
}

void MySQLParser::RoutineOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineOption(this);
}

void MySQLParser::RoutineOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineOption(this);
}


std::any MySQLParser::RoutineOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineOptionContext* MySQLParser::routineOption() {
  RoutineOptionContext *_localctx = _tracker.createInstance<RoutineOptionContext>(_ctx, getState());
  enterRule(_localctx, 116, MySQLParser::RuleRoutineOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2423);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::COMMENT_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2402);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::COMMENT_SYMBOL);
        setState(2403);
        textLiteral();
        break;
      }

      case MySQLParser::LANGUAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2404);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::LANGUAGE_SYMBOL);
        setState(2408);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 137, _ctx)) {
        case 1: {
          setState(2405);
          match(MySQLParser::SQL_SYMBOL);
          break;
        }

        case 2: {
          setState(2406);

          if (!(serverVersion >= 80032)) throw FailedPredicateException(this, "serverVersion >= 80032");
          setState(2407);
          identifier();
          break;
        }

        default:
          break;
        }
        break;
      }

      case MySQLParser::NO_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2410);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::NO_SYMBOL);
        setState(2411);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::CONTAINS_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2412);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::CONTAINS_SYMBOL);
        setState(2413);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::READS_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2414);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::READS_SYMBOL);
        setState(2415);
        match(MySQLParser::SQL_SYMBOL);
        setState(2416);
        match(MySQLParser::DATA_SYMBOL);
        break;
      }

      case MySQLParser::MODIFIES_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2417);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::MODIFIES_SYMBOL);
        setState(2418);
        match(MySQLParser::SQL_SYMBOL);
        setState(2419);
        match(MySQLParser::DATA_SYMBOL);
        break;
      }

      case MySQLParser::SQL_SYMBOL: {
        enterOuterAlt(_localctx, 7);
        setState(2420);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::SQL_SYMBOL);
        setState(2421);
        match(MySQLParser::SECURITY_SYMBOL);
        setState(2422);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->security = _input->LT(1);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::DEFINER_SYMBOL || _la == MySQLParser::INVOKER_SYMBOL)) {
          antlrcpp::downCast<RoutineOptionContext *>(_localctx)->security = _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateIndexContext ------------------------------------------------------------------

MySQLParser::CreateIndexContext::CreateIndexContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexNameContext* MySQLParser::CreateIndexContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

MySQLParser::CreateIndexTargetContext* MySQLParser::CreateIndexContext::createIndexTarget() {
  return getRuleContext<MySQLParser::CreateIndexTargetContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::OnlineOptionContext* MySQLParser::CreateIndexContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::FULLTEXT_SYMBOL() {
  return getToken(MySQLParser::FULLTEXT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::CreateIndexContext::indexLockAndAlgorithm() {
  return getRuleContext<MySQLParser::IndexLockAndAlgorithmContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::UNIQUE_SYMBOL() {
  return getToken(MySQLParser::UNIQUE_SYMBOL, 0);
}

MySQLParser::IndexTypeClauseContext* MySQLParser::CreateIndexContext::indexTypeClause() {
  return getRuleContext<MySQLParser::IndexTypeClauseContext>(0);
}

std::vector<MySQLParser::IndexOptionContext *> MySQLParser::CreateIndexContext::indexOption() {
  return getRuleContexts<MySQLParser::IndexOptionContext>();
}

MySQLParser::IndexOptionContext* MySQLParser::CreateIndexContext::indexOption(size_t i) {
  return getRuleContext<MySQLParser::IndexOptionContext>(i);
}

std::vector<MySQLParser::FulltextIndexOptionContext *> MySQLParser::CreateIndexContext::fulltextIndexOption() {
  return getRuleContexts<MySQLParser::FulltextIndexOptionContext>();
}

MySQLParser::FulltextIndexOptionContext* MySQLParser::CreateIndexContext::fulltextIndexOption(size_t i) {
  return getRuleContext<MySQLParser::FulltextIndexOptionContext>(i);
}

std::vector<MySQLParser::SpatialIndexOptionContext *> MySQLParser::CreateIndexContext::spatialIndexOption() {
  return getRuleContexts<MySQLParser::SpatialIndexOptionContext>();
}

MySQLParser::SpatialIndexOptionContext* MySQLParser::CreateIndexContext::spatialIndexOption(size_t i) {
  return getRuleContext<MySQLParser::SpatialIndexOptionContext>(i);
}


size_t MySQLParser::CreateIndexContext::getRuleIndex() const {
  return MySQLParser::RuleCreateIndex;
}

void MySQLParser::CreateIndexContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateIndex(this);
}

void MySQLParser::CreateIndexContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateIndex(this);
}


std::any MySQLParser::CreateIndexContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateIndex(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateIndexContext* MySQLParser::createIndex() {
  CreateIndexContext *_localctx = _tracker.createInstance<CreateIndexContext>(_ctx, getState());
  enterRule(_localctx, 118, MySQLParser::RuleCreateIndex);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2426);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(2425);
      onlineOption();
    }
    setState(2463);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INDEX_SYMBOL:
      case MySQLParser::UNIQUE_SYMBOL: {
        setState(2429);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::UNIQUE_SYMBOL) {
          setState(2428);
          match(MySQLParser::UNIQUE_SYMBOL);
        }
        setState(2431);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::INDEX_SYMBOL);
        setState(2432);
        indexName();
        setState(2434);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::TYPE_SYMBOL

        || _la == MySQLParser::USING_SYMBOL) {
          setState(2433);
          indexTypeClause();
        }
        setState(2436);
        createIndexTarget();
        setState(2440);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 142, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2437);
            indexOption(); 
          }
          setState(2442);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 142, _ctx);
        }
        break;
      }

      case MySQLParser::FULLTEXT_SYMBOL: {
        setState(2443);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::FULLTEXT_SYMBOL);
        setState(2444);
        match(MySQLParser::INDEX_SYMBOL);
        setState(2445);
        indexName();
        setState(2446);
        createIndexTarget();
        setState(2450);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 143, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2447);
            fulltextIndexOption(); 
          }
          setState(2452);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 143, _ctx);
        }
        break;
      }

      case MySQLParser::SPATIAL_SYMBOL: {
        setState(2453);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::SPATIAL_SYMBOL);
        setState(2454);
        match(MySQLParser::INDEX_SYMBOL);
        setState(2455);
        indexName();
        setState(2456);
        createIndexTarget();
        setState(2460);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 144, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2457);
            spatialIndexOption(); 
          }
          setState(2462);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 144, _ctx);
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
    setState(2466);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
      setState(2465);
      indexLockAndAlgorithm();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IndexNameAndTypeContext ------------------------------------------------------------------

MySQLParser::IndexNameAndTypeContext::IndexNameAndTypeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexNameContext* MySQLParser::IndexNameAndTypeContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

tree::TerminalNode* MySQLParser::IndexNameAndTypeContext::USING_SYMBOL() {
  return getToken(MySQLParser::USING_SYMBOL, 0);
}

MySQLParser::IndexTypeContext* MySQLParser::IndexNameAndTypeContext::indexType() {
  return getRuleContext<MySQLParser::IndexTypeContext>(0);
}

tree::TerminalNode* MySQLParser::IndexNameAndTypeContext::TYPE_SYMBOL() {
  return getToken(MySQLParser::TYPE_SYMBOL, 0);
}


size_t MySQLParser::IndexNameAndTypeContext::getRuleIndex() const {
  return MySQLParser::RuleIndexNameAndType;
}

void MySQLParser::IndexNameAndTypeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIndexNameAndType(this);
}

void MySQLParser::IndexNameAndTypeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIndexNameAndType(this);
}


std::any MySQLParser::IndexNameAndTypeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIndexNameAndType(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IndexNameAndTypeContext* MySQLParser::indexNameAndType() {
  IndexNameAndTypeContext *_localctx = _tracker.createInstance<IndexNameAndTypeContext>(_ctx, getState());
  enterRule(_localctx, 120, MySQLParser::RuleIndexNameAndType);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2478);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 148, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2468);
      indexName();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2470);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 147, _ctx)) {
      case 1: {
        setState(2469);
        indexName();
        break;
      }

      default:
        break;
      }
      setState(2472);
      match(MySQLParser::USING_SYMBOL);
      setState(2473);
      indexType();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2474);
      indexName();
      setState(2475);
      match(MySQLParser::TYPE_SYMBOL);
      setState(2476);
      indexType();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateIndexTargetContext ------------------------------------------------------------------

MySQLParser::CreateIndexTargetContext::CreateIndexTargetContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateIndexTargetContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateIndexTargetContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::KeyListWithExpressionContext* MySQLParser::CreateIndexTargetContext::keyListWithExpression() {
  return getRuleContext<MySQLParser::KeyListWithExpressionContext>(0);
}


size_t MySQLParser::CreateIndexTargetContext::getRuleIndex() const {
  return MySQLParser::RuleCreateIndexTarget;
}

void MySQLParser::CreateIndexTargetContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateIndexTarget(this);
}

void MySQLParser::CreateIndexTargetContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateIndexTarget(this);
}


std::any MySQLParser::CreateIndexTargetContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateIndexTarget(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateIndexTargetContext* MySQLParser::createIndexTarget() {
  CreateIndexTargetContext *_localctx = _tracker.createInstance<CreateIndexTargetContext>(_ctx, getState());
  enterRule(_localctx, 122, MySQLParser::RuleCreateIndexTarget);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2480);
    match(MySQLParser::ON_SYMBOL);
    setState(2481);
    tableRef();
    setState(2482);
    keyListWithExpression();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateLogfileGroupContext ------------------------------------------------------------------

MySQLParser::CreateLogfileGroupContext::CreateLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupNameContext* MySQLParser::CreateLogfileGroupContext::logfileGroupName() {
  return getRuleContext<MySQLParser::LogfileGroupNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::UNDOFILE_SYMBOL() {
  return getToken(MySQLParser::UNDOFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateLogfileGroupContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

MySQLParser::LogfileGroupOptionsContext* MySQLParser::CreateLogfileGroupContext::logfileGroupOptions() {
  return getRuleContext<MySQLParser::LogfileGroupOptionsContext>(0);
}


size_t MySQLParser::CreateLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleCreateLogfileGroup;
}

void MySQLParser::CreateLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateLogfileGroup(this);
}

void MySQLParser::CreateLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateLogfileGroup(this);
}


std::any MySQLParser::CreateLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateLogfileGroupContext* MySQLParser::createLogfileGroup() {
  CreateLogfileGroupContext *_localctx = _tracker.createInstance<CreateLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 124, MySQLParser::RuleCreateLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2484);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(2485);
    match(MySQLParser::GROUP_SYMBOL);
    setState(2486);
    logfileGroupName();
    setState(2487);
    match(MySQLParser::ADD_SYMBOL);
    setState(2488);
    match(MySQLParser::UNDOFILE_SYMBOL);
    setState(2489);
    textLiteral();
    setState(2491);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NODEGROUP_SYMBOL

    || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL

    || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2490);
      logfileGroupOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LogfileGroupOptionsContext ------------------------------------------------------------------

MySQLParser::LogfileGroupOptionsContext::LogfileGroupOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LogfileGroupOptionContext *> MySQLParser::LogfileGroupOptionsContext::logfileGroupOption() {
  return getRuleContexts<MySQLParser::LogfileGroupOptionContext>();
}

MySQLParser::LogfileGroupOptionContext* MySQLParser::LogfileGroupOptionsContext::logfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::LogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::LogfileGroupOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::LogfileGroupOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::LogfileGroupOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleLogfileGroupOptions;
}

void MySQLParser::LogfileGroupOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLogfileGroupOptions(this);
}

void MySQLParser::LogfileGroupOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLogfileGroupOptions(this);
}


std::any MySQLParser::LogfileGroupOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLogfileGroupOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LogfileGroupOptionsContext* MySQLParser::logfileGroupOptions() {
  LogfileGroupOptionsContext *_localctx = _tracker.createInstance<LogfileGroupOptionsContext>(_ctx, getState());
  enterRule(_localctx, 126, MySQLParser::RuleLogfileGroupOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2493);
    logfileGroupOption();
    setState(2500);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::COMMENT_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NODEGROUP_SYMBOL

    || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL

    || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2495);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2494);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(2497);
      logfileGroupOption();
      setState(2502);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::LogfileGroupOptionContext::LogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::LogfileGroupOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionUndoRedoBufferSizeContext* MySQLParser::LogfileGroupOptionContext::tsOptionUndoRedoBufferSize() {
  return getRuleContext<MySQLParser::TsOptionUndoRedoBufferSizeContext>(0);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::LogfileGroupOptionContext::tsOptionNodegroup() {
  return getRuleContext<MySQLParser::TsOptionNodegroupContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::LogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::LogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionCommentContext* MySQLParser::LogfileGroupOptionContext::tsOptionComment() {
  return getRuleContext<MySQLParser::TsOptionCommentContext>(0);
}


size_t MySQLParser::LogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleLogfileGroupOption;
}

void MySQLParser::LogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLogfileGroupOption(this);
}

void MySQLParser::LogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLogfileGroupOption(this);
}


std::any MySQLParser::LogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LogfileGroupOptionContext* MySQLParser::logfileGroupOption() {
  LogfileGroupOptionContext *_localctx = _tracker.createInstance<LogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 128, MySQLParser::RuleLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2509);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2503);
        tsOptionInitialSize();
        break;
      }

      case MySQLParser::REDO_BUFFER_SIZE_SYMBOL:
      case MySQLParser::UNDO_BUFFER_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2504);
        tsOptionUndoRedoBufferSize();
        break;
      }

      case MySQLParser::NODEGROUP_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2505);
        tsOptionNodegroup();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2506);
        tsOptionEngine();
        break;
      }

      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2507);
        tsOptionWait();
        break;
      }

      case MySQLParser::COMMENT_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2508);
        tsOptionComment();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateServerContext ------------------------------------------------------------------

MySQLParser::CreateServerContext::CreateServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerNameContext* MySQLParser::CreateServerContext::serverName() {
  return getRuleContext<MySQLParser::ServerNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::FOREIGN_SYMBOL() {
  return getToken(MySQLParser::FOREIGN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::WRAPPER_SYMBOL() {
  return getToken(MySQLParser::WRAPPER_SYMBOL, 0);
}

MySQLParser::TextOrIdentifierContext* MySQLParser::CreateServerContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

MySQLParser::ServerOptionsContext* MySQLParser::CreateServerContext::serverOptions() {
  return getRuleContext<MySQLParser::ServerOptionsContext>(0);
}


size_t MySQLParser::CreateServerContext::getRuleIndex() const {
  return MySQLParser::RuleCreateServer;
}

void MySQLParser::CreateServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateServer(this);
}

void MySQLParser::CreateServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateServer(this);
}


std::any MySQLParser::CreateServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateServerContext* MySQLParser::createServer() {
  CreateServerContext *_localctx = _tracker.createInstance<CreateServerContext>(_ctx, getState());
  enterRule(_localctx, 130, MySQLParser::RuleCreateServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2511);
    match(MySQLParser::SERVER_SYMBOL);
    setState(2512);
    serverName();
    setState(2513);
    match(MySQLParser::FOREIGN_SYMBOL);
    setState(2514);
    match(MySQLParser::DATA_SYMBOL);
    setState(2515);
    match(MySQLParser::WRAPPER_SYMBOL);
    setState(2516);
    textOrIdentifier();
    setState(2517);
    serverOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ServerOptionsContext ------------------------------------------------------------------

MySQLParser::ServerOptionsContext::ServerOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::OPTIONS_SYMBOL() {
  return getToken(MySQLParser::OPTIONS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

std::vector<MySQLParser::ServerOptionContext *> MySQLParser::ServerOptionsContext::serverOption() {
  return getRuleContexts<MySQLParser::ServerOptionContext>();
}

MySQLParser::ServerOptionContext* MySQLParser::ServerOptionsContext::serverOption(size_t i) {
  return getRuleContext<MySQLParser::ServerOptionContext>(i);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::ServerOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ServerOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleServerOptions;
}

void MySQLParser::ServerOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterServerOptions(this);
}

void MySQLParser::ServerOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitServerOptions(this);
}


std::any MySQLParser::ServerOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitServerOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ServerOptionsContext* MySQLParser::serverOptions() {
  ServerOptionsContext *_localctx = _tracker.createInstance<ServerOptionsContext>(_ctx, getState());
  enterRule(_localctx, 132, MySQLParser::RuleServerOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2519);
    match(MySQLParser::OPTIONS_SYMBOL);
    setState(2520);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2521);
    serverOption();
    setState(2526);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2522);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2523);
      serverOption();
      setState(2528);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
    setState(2529);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ServerOptionContext ------------------------------------------------------------------

MySQLParser::ServerOptionContext::ServerOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextLiteralContext* MySQLParser::ServerOptionContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::HOST_SYMBOL() {
  return getToken(MySQLParser::HOST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::USER_SYMBOL() {
  return getToken(MySQLParser::USER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::PASSWORD_SYMBOL() {
  return getToken(MySQLParser::PASSWORD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::SOCKET_SYMBOL() {
  return getToken(MySQLParser::SOCKET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::OWNER_SYMBOL() {
  return getToken(MySQLParser::OWNER_SYMBOL, 0);
}

MySQLParser::Ulong_numberContext* MySQLParser::ServerOptionContext::ulong_number() {
  return getRuleContext<MySQLParser::Ulong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::PORT_SYMBOL() {
  return getToken(MySQLParser::PORT_SYMBOL, 0);
}


size_t MySQLParser::ServerOptionContext::getRuleIndex() const {
  return MySQLParser::RuleServerOption;
}

void MySQLParser::ServerOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterServerOption(this);
}

void MySQLParser::ServerOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitServerOption(this);
}


std::any MySQLParser::ServerOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitServerOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ServerOptionContext* MySQLParser::serverOption() {
  ServerOptionContext *_localctx = _tracker.createInstance<ServerOptionContext>(_ctx, getState());
  enterRule(_localctx, 134, MySQLParser::RuleServerOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2545);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::HOST_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2531);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::HOST_SYMBOL);
        setState(2532);
        textLiteral();
        break;
      }

      case MySQLParser::DATABASE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2533);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::DATABASE_SYMBOL);
        setState(2534);
        textLiteral();
        break;
      }

      case MySQLParser::USER_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2535);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::USER_SYMBOL);
        setState(2536);
        textLiteral();
        break;
      }

      case MySQLParser::PASSWORD_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2537);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::PASSWORD_SYMBOL);
        setState(2538);
        textLiteral();
        break;
      }

      case MySQLParser::SOCKET_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2539);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::SOCKET_SYMBOL);
        setState(2540);
        textLiteral();
        break;
      }

      case MySQLParser::OWNER_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2541);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::OWNER_SYMBOL);
        setState(2542);
        textLiteral();
        break;
      }

      case MySQLParser::PORT_SYMBOL: {
        enterOuterAlt(_localctx, 7);
        setState(2543);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::PORT_SYMBOL);
        setState(2544);
        ulong_number();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTablespaceContext ------------------------------------------------------------------

MySQLParser::CreateTablespaceContext::CreateTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceNameContext* MySQLParser::CreateTablespaceContext::tablespaceName() {
  return getRuleContext<MySQLParser::TablespaceNameContext>(0);
}

MySQLParser::TsDataFileNameContext* MySQLParser::CreateTablespaceContext::tsDataFileName() {
  return getRuleContext<MySQLParser::TsDataFileNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::USE_SYMBOL() {
  return getToken(MySQLParser::USE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::CreateTablespaceContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

MySQLParser::TablespaceOptionsContext* MySQLParser::CreateTablespaceContext::tablespaceOptions() {
  return getRuleContext<MySQLParser::TablespaceOptionsContext>(0);
}


size_t MySQLParser::CreateTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTablespace;
}

void MySQLParser::CreateTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTablespace(this);
}

void MySQLParser::CreateTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTablespace(this);
}


std::any MySQLParser::CreateTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTablespaceContext* MySQLParser::createTablespace() {
  CreateTablespaceContext *_localctx = _tracker.createInstance<CreateTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 136, MySQLParser::RuleCreateTablespace);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2547);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2548);
    tablespaceName();
    setState(2549);
    tsDataFileName();
    setState(2554);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 155, _ctx)) {
    case 1: {
      setState(2550);
      match(MySQLParser::USE_SYMBOL);
      setState(2551);
      match(MySQLParser::LOGFILE_SYMBOL);
      setState(2552);
      match(MySQLParser::GROUP_SYMBOL);
      setState(2553);
      logfileGroupRef();
      break;
    }

    default:
      break;
    }
    setState(2557);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 156, _ctx)) {
    case 1: {
      setState(2556);
      tablespaceOptions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::CreateUndoTablespaceContext::CreateUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceNameContext* MySQLParser::CreateUndoTablespaceContext::tablespaceName() {
  return getRuleContext<MySQLParser::TablespaceNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::TsDataFileContext* MySQLParser::CreateUndoTablespaceContext::tsDataFile() {
  return getRuleContext<MySQLParser::TsDataFileContext>(0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::CreateUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::CreateUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateUndoTablespace;
}

void MySQLParser::CreateUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateUndoTablespace(this);
}

void MySQLParser::CreateUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateUndoTablespace(this);
}


std::any MySQLParser::CreateUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateUndoTablespaceContext* MySQLParser::createUndoTablespace() {
  CreateUndoTablespaceContext *_localctx = _tracker.createInstance<CreateUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 138, MySQLParser::RuleCreateUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2559);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2560);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2561);
    tablespaceName();
    setState(2562);
    match(MySQLParser::ADD_SYMBOL);
    setState(2563);
    tsDataFile();
    setState(2565);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2564);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsDataFileNameContext ------------------------------------------------------------------

MySQLParser::TsDataFileNameContext::TsDataFileNameContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsDataFileNameContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::TsDataFileContext* MySQLParser::TsDataFileNameContext::tsDataFile() {
  return getRuleContext<MySQLParser::TsDataFileContext>(0);
}


size_t MySQLParser::TsDataFileNameContext::getRuleIndex() const {
  return MySQLParser::RuleTsDataFileName;
}

void MySQLParser::TsDataFileNameContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsDataFileName(this);
}

void MySQLParser::TsDataFileNameContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsDataFileName(this);
}


std::any MySQLParser::TsDataFileNameContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsDataFileName(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsDataFileNameContext* MySQLParser::tsDataFileName() {
  TsDataFileNameContext *_localctx = _tracker.createInstance<TsDataFileNameContext>(_ctx, getState());
  enterRule(_localctx, 140, MySQLParser::RuleTsDataFileName);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2574);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 159, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2567);
      match(MySQLParser::ADD_SYMBOL);
      setState(2568);
      tsDataFile();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2569);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2572);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 158, _ctx)) {
      case 1: {
        setState(2570);
        match(MySQLParser::ADD_SYMBOL);
        setState(2571);
        tsDataFile();
        break;
      }

      default:
        break;
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsDataFileContext ------------------------------------------------------------------

MySQLParser::TsDataFileContext::TsDataFileContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsDataFileContext::DATAFILE_SYMBOL() {
  return getToken(MySQLParser::DATAFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::TsDataFileContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}


size_t MySQLParser::TsDataFileContext::getRuleIndex() const {
  return MySQLParser::RuleTsDataFile;
}

void MySQLParser::TsDataFileContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsDataFile(this);
}

void MySQLParser::TsDataFileContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsDataFile(this);
}


std::any MySQLParser::TsDataFileContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsDataFile(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsDataFileContext* MySQLParser::tsDataFile() {
  TsDataFileContext *_localctx = _tracker.createInstance<TsDataFileContext>(_ctx, getState());
  enterRule(_localctx, 142, MySQLParser::RuleTsDataFile);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2576);
    match(MySQLParser::DATAFILE_SYMBOL);
    setState(2577);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TablespaceOptionsContext ------------------------------------------------------------------

MySQLParser::TablespaceOptionsContext::TablespaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TablespaceOptionContext *> MySQLParser::TablespaceOptionsContext::tablespaceOption() {
  return getRuleContexts<MySQLParser::TablespaceOptionContext>();
}

MySQLParser::TablespaceOptionContext* MySQLParser::TablespaceOptionsContext::tablespaceOption(size_t i) {
  return getRuleContext<MySQLParser::TablespaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TablespaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TablespaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TablespaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleTablespaceOptions;
}

void MySQLParser::TablespaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTablespaceOptions(this);
}

void MySQLParser::TablespaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTablespaceOptions(this);
}


std::any MySQLParser::TablespaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTablespaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TablespaceOptionsContext* MySQLParser::tablespaceOptions() {
  TablespaceOptionsContext *_localctx = _tracker.createInstance<TablespaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 144, MySQLParser::RuleTablespaceOptions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2579);
    tablespaceOption();
    setState(2586);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 161, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2581);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 160, _ctx)) {
        case 1: {
          setState(2580);
          match(MySQLParser::COMMA_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(2583);
        tablespaceOption(); 
      }
      setState(2588);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 161, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TablespaceOptionContext ------------------------------------------------------------------

MySQLParser::TablespaceOptionContext::TablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::TablespaceOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::TablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::TablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}

MySQLParser::TsOptionExtentSizeContext* MySQLParser::TablespaceOptionContext::tsOptionExtentSize() {
  return getRuleContext<MySQLParser::TsOptionExtentSizeContext>(0);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::TablespaceOptionContext::tsOptionNodegroup() {
  return getRuleContext<MySQLParser::TsOptionNodegroupContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::TablespaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::TablespaceOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionCommentContext* MySQLParser::TablespaceOptionContext::tsOptionComment() {
  return getRuleContext<MySQLParser::TsOptionCommentContext>(0);
}

MySQLParser::TsOptionFileblockSizeContext* MySQLParser::TablespaceOptionContext::tsOptionFileblockSize() {
  return getRuleContext<MySQLParser::TsOptionFileblockSizeContext>(0);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::TablespaceOptionContext::tsOptionEncryption() {
  return getRuleContext<MySQLParser::TsOptionEncryptionContext>(0);
}


size_t MySQLParser::TablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleTablespaceOption;
}

void MySQLParser::TablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTablespaceOption(this);
}

void MySQLParser::TablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTablespaceOption(this);
}


std::any MySQLParser::TablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TablespaceOptionContext* MySQLParser::tablespaceOption() {
  TablespaceOptionContext *_localctx = _tracker.createInstance<TablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 146, MySQLParser::RuleTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2601);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 162, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2589);
      tsOptionInitialSize();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2590);
      tsOptionAutoextendSize();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2591);
      tsOptionMaxSize();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(2592);
      tsOptionExtentSize();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(2593);
      tsOptionNodegroup();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(2594);
      tsOptionEngine();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(2595);
      tsOptionWait();
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(2596);
      tsOptionComment();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(2597);

      if (!(serverVersion >= 50707)) throw FailedPredicateException(this, "serverVersion >= 50707");
      setState(2598);
      tsOptionFileblockSize();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(2599);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2600);
      tsOptionEncryption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionInitialSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionInitialSizeContext::TsOptionInitialSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionInitialSizeContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionInitialSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionInitialSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionInitialSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionInitialSize;
}

void MySQLParser::TsOptionInitialSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionInitialSize(this);
}

void MySQLParser::TsOptionInitialSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionInitialSize(this);
}


std::any MySQLParser::TsOptionInitialSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionInitialSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::tsOptionInitialSize() {
  TsOptionInitialSizeContext *_localctx = _tracker.createInstance<TsOptionInitialSizeContext>(_ctx, getState());
  enterRule(_localctx, 148, MySQLParser::RuleTsOptionInitialSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2603);
    match(MySQLParser::INITIAL_SIZE_SYMBOL);
    setState(2605);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 163, _ctx)) {
    case 1: {
      setState(2604);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2607);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionUndoRedoBufferSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionUndoRedoBufferSizeContext::TsOptionUndoRedoBufferSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionUndoRedoBufferSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::UNDO_BUFFER_SIZE_SYMBOL() {
  return getToken(MySQLParser::UNDO_BUFFER_SIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::REDO_BUFFER_SIZE_SYMBOL() {
  return getToken(MySQLParser::REDO_BUFFER_SIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionUndoRedoBufferSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionUndoRedoBufferSize;
}

void MySQLParser::TsOptionUndoRedoBufferSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionUndoRedoBufferSize(this);
}

void MySQLParser::TsOptionUndoRedoBufferSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionUndoRedoBufferSize(this);
}


std::any MySQLParser::TsOptionUndoRedoBufferSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionUndoRedoBufferSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionUndoRedoBufferSizeContext* MySQLParser::tsOptionUndoRedoBufferSize() {
  TsOptionUndoRedoBufferSizeContext *_localctx = _tracker.createInstance<TsOptionUndoRedoBufferSizeContext>(_ctx, getState());
  enterRule(_localctx, 150, MySQLParser::RuleTsOptionUndoRedoBufferSize);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2609);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2611);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 164, _ctx)) {
    case 1: {
      setState(2610);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2613);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionAutoextendSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionAutoextendSizeContext::TsOptionAutoextendSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionAutoextendSizeContext::AUTOEXTEND_SIZE_SYMBOL() {
  return getToken(MySQLParser::AUTOEXTEND_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionAutoextendSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionAutoextendSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionAutoextendSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionAutoextendSize;
}

void MySQLParser::TsOptionAutoextendSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionAutoextendSize(this);
}

void MySQLParser::TsOptionAutoextendSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionAutoextendSize(this);
}


std::any MySQLParser::TsOptionAutoextendSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionAutoextendSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::tsOptionAutoextendSize() {
  TsOptionAutoextendSizeContext *_localctx = _tracker.createInstance<TsOptionAutoextendSizeContext>(_ctx, getState());
  enterRule(_localctx, 152, MySQLParser::RuleTsOptionAutoextendSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2615);
    match(MySQLParser::AUTOEXTEND_SIZE_SYMBOL);
    setState(2617);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 165, _ctx)) {
    case 1: {
      setState(2616);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2619);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionMaxSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionMaxSizeContext::TsOptionMaxSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionMaxSizeContext::MAX_SIZE_SYMBOL() {
  return getToken(MySQLParser::MAX_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionMaxSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionMaxSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionMaxSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionMaxSize;
}

void MySQLParser::TsOptionMaxSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionMaxSize(this);
}

void MySQLParser::TsOptionMaxSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionMaxSize(this);
}


std::any MySQLParser::TsOptionMaxSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionMaxSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::tsOptionMaxSize() {
  TsOptionMaxSizeContext *_localctx = _tracker.createInstance<TsOptionMaxSizeContext>(_ctx, getState());
  enterRule(_localctx, 154, MySQLParser::RuleTsOptionMaxSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2621);
    match(MySQLParser::MAX_SIZE_SYMBOL);
    setState(2623);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 166, _ctx)) {
    case 1: {
      setState(2622);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2625);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionExtentSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionExtentSizeContext::TsOptionExtentSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionExtentSizeContext::EXTENT_SIZE_SYMBOL() {
  return getToken(MySQLParser::EXTENT_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionExtentSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionExtentSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionExtentSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionExtentSize;
}

void MySQLParser::TsOptionExtentSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionExtentSize(this);
}

void MySQLParser::TsOptionExtentSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionExtentSize(this);
}


std::any MySQLParser::TsOptionExtentSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionExtentSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionExtentSizeContext* MySQLParser::tsOptionExtentSize() {
  TsOptionExtentSizeContext *_localctx = _tracker.createInstance<TsOptionExtentSizeContext>(_ctx, getState());
  enterRule(_localctx, 156, MySQLParser::RuleTsOptionExtentSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2627);
    match(MySQLParser::EXTENT_SIZE_SYMBOL);
    setState(2629);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 167, _ctx)) {
    case 1: {
      setState(2628);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2631);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionNodegroupContext ------------------------------------------------------------------

MySQLParser::TsOptionNodegroupContext::TsOptionNodegroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionNodegroupContext::NODEGROUP_SYMBOL() {
  return getToken(MySQLParser::NODEGROUP_SYMBOL, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::TsOptionNodegroupContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionNodegroupContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionNodegroupContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionNodegroup;
}

void MySQLParser::TsOptionNodegroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionNodegroup(this);
}

void MySQLParser::TsOptionNodegroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionNodegroup(this);
}


std::any MySQLParser::TsOptionNodegroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionNodegroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::tsOptionNodegroup() {
  TsOptionNodegroupContext *_localctx = _tracker.createInstance<TsOptionNodegroupContext>(_ctx, getState());
  enterRule(_localctx, 158, MySQLParser::RuleTsOptionNodegroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2633);
    match(MySQLParser::NODEGROUP_SYMBOL);
    setState(2635);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::EQUAL_OPERATOR) {
      setState(2634);
      match(MySQLParser::EQUAL_OPERATOR);
    }
    setState(2637);
    real_ulong_number();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEngineContext ------------------------------------------------------------------

MySQLParser::TsOptionEngineContext::TsOptionEngineContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::ENGINE_SYMBOL() {
  return getToken(MySQLParser::ENGINE_SYMBOL, 0);
}

MySQLParser::EngineRefContext* MySQLParser::TsOptionEngineContext::engineRef() {
  return getRuleContext<MySQLParser::EngineRefContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::STORAGE_SYMBOL() {
  return getToken(MySQLParser::STORAGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEngineContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEngine;
}

void MySQLParser::TsOptionEngineContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEngine(this);
}

void MySQLParser::TsOptionEngineContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEngine(this);
}


std::any MySQLParser::TsOptionEngineContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEngine(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEngineContext* MySQLParser::tsOptionEngine() {
  TsOptionEngineContext *_localctx = _tracker.createInstance<TsOptionEngineContext>(_ctx, getState());
  enterRule(_localctx, 160, MySQLParser::RuleTsOptionEngine);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2640);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::STORAGE_SYMBOL) {
      setState(2639);
      match(MySQLParser::STORAGE_SYMBOL);
    }
    setState(2642);
    match(MySQLParser::ENGINE_SYMBOL);
    setState(2644);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 170, _ctx)) {
    case 1: {
      setState(2643);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2646);
    engineRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionWaitContext ------------------------------------------------------------------

MySQLParser::TsOptionWaitContext::TsOptionWaitContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionWaitContext::WAIT_SYMBOL() {
  return getToken(MySQLParser::WAIT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionWaitContext::NO_WAIT_SYMBOL() {
  return getToken(MySQLParser::NO_WAIT_SYMBOL, 0);
}


size_t MySQLParser::TsOptionWaitContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionWait;
}

void MySQLParser::TsOptionWaitContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionWait(this);
}

void MySQLParser::TsOptionWaitContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionWait(this);
}


std::any MySQLParser::TsOptionWaitContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionWait(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionWaitContext* MySQLParser::tsOptionWait() {
  TsOptionWaitContext *_localctx = _tracker.createInstance<TsOptionWaitContext>(_ctx, getState());
  enterRule(_localctx, 162, MySQLParser::RuleTsOptionWait);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2648);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::WAIT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionCommentContext ------------------------------------------------------------------

MySQLParser::TsOptionCommentContext::TsOptionCommentContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionCommentContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::TsOptionCommentContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionCommentContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionCommentContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionComment;
}

void MySQLParser::TsOptionCommentContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionComment(this);
}

void MySQLParser::TsOptionCommentContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionComment(this);
}


std::any MySQLParser::TsOptionCommentContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionComment(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionCommentContext* MySQLParser::tsOptionComment() {
  TsOptionCommentContext *_localctx = _tracker.createInstance<TsOptionCommentContext>(_ctx, getState());
  enterRule(_localctx, 164, MySQLParser::RuleTsOptionComment);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2650);
    match(MySQLParser::COMMENT_SYMBOL);
    setState(2652);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 171, _ctx)) {
    case 1: {
      setState(2651);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2654);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionFileblockSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionFileblockSizeContext::TsOptionFileblockSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionFileblockSizeContext::FILE_BLOCK_SIZE_SYMBOL() {
  return getToken(MySQLParser::FILE_BLOCK_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionFileblockSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionFileblockSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionFileblockSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionFileblockSize;
}

void MySQLParser::TsOptionFileblockSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionFileblockSize(this);
}

void MySQLParser::TsOptionFileblockSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionFileblockSize(this);
}


std::any MySQLParser::TsOptionFileblockSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionFileblockSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionFileblockSizeContext* MySQLParser::tsOptionFileblockSize() {
  TsOptionFileblockSizeContext *_localctx = _tracker.createInstance<TsOptionFileblockSizeContext>(_ctx, getState());
  enterRule(_localctx, 166, MySQLParser::RuleTsOptionFileblockSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2656);
    match(MySQLParser::FILE_BLOCK_SIZE_SYMBOL);
    setState(2658);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 172, _ctx)) {
    case 1: {
      setState(2657);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2660);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEncryptionContext ------------------------------------------------------------------

MySQLParser::TsOptionEncryptionContext::TsOptionEncryptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEncryptionContext::ENCRYPTION_SYMBOL() {
  return getToken(MySQLParser::ENCRYPTION_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::TsOptionEncryptionContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEncryptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEncryptionContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEncryption;
}

void MySQLParser::TsOptionEncryptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEncryption(this);
}

void MySQLParser::TsOptionEncryptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEncryption(this);
}


std::any MySQLParser::TsOptionEncryptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEncryption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::tsOptionEncryption() {
  TsOptionEncryptionContext *_localctx = _tracker.createInstance<TsOptionEncryptionContext>(_ctx, getState());
  enterRule(_localctx, 168, MySQLParser::RuleTsOptionEncryption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2662);
    match(MySQLParser::ENCRYPTION_SYMBOL);
    setState(2664);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 173, _ctx)) {
    case 1: {
      setState(2663);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2666);
    textStringLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEngineAttributeContext ------------------------------------------------------------------

MySQLParser::TsOptionEngineAttributeContext::TsOptionEngineAttributeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEngineAttributeContext::ENGINE_SYMBOL() {
  return getToken(MySQLParser::ENGINE_SYMBOL, 0);
}

MySQLParser::JsonAttributeContext* MySQLParser::TsOptionEngineAttributeContext::jsonAttribute() {
  return getRuleContext<MySQLParser::JsonAttributeContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineAttributeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEngineAttributeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEngineAttribute;
}

void MySQLParser::TsOptionEngineAttributeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEngineAttribute(this);
}

void MySQLParser::TsOptionEngineAttributeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEngineAttribute(this);
}


std::any MySQLParser::TsOptionEngineAttributeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEngineAttribute(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEngineAttributeContext* MySQLParser::tsOptionEngineAttribute() {
  TsOptionEngineAttributeContext *_localctx = _tracker.createInstance<TsOptionEngineAttributeContext>(_ctx, getState());
  enterRule(_localctx, 170, MySQLParser::RuleTsOptionEngineAttribute);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2668);
    match(MySQLParser::ENGINE_SYMBOL);
    setState(2670);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 174, _ctx)) {
    case 1: {
      setState(2669);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2672);
    jsonAttribute();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateViewContext ------------------------------------------------------------------

MySQLParser::CreateViewContext::CreateViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewNameContext* MySQLParser::CreateViewContext::viewName() {
  return getRuleContext<MySQLParser::ViewNameContext>(0);
}

MySQLParser::ViewTailContext* MySQLParser::CreateViewContext::viewTail() {
  return getRuleContext<MySQLParser::ViewTailContext>(0);
}

MySQLParser::ViewReplaceOrAlgorithmContext* MySQLParser::CreateViewContext::viewReplaceOrAlgorithm() {
  return getRuleContext<MySQLParser::ViewReplaceOrAlgorithmContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateViewContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::ViewSuidContext* MySQLParser::CreateViewContext::viewSuid() {
  return getRuleContext<MySQLParser::ViewSuidContext>(0);
}


size_t MySQLParser::CreateViewContext::getRuleIndex() const {
  return MySQLParser::RuleCreateView;
}

void MySQLParser::CreateViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateView(this);
}

void MySQLParser::CreateViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateView(this);
}


std::any MySQLParser::CreateViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateViewContext* MySQLParser::createView() {
  CreateViewContext *_localctx = _tracker.createInstance<CreateViewContext>(_ctx, getState());
  enterRule(_localctx, 172, MySQLParser::RuleCreateView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2675);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::OR_SYMBOL) {
      setState(2674);
      viewReplaceOrAlgorithm();
    }
    setState(2678);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2677);
      definerClause();
    }
    setState(2681);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SQL_SYMBOL) {
      setState(2680);
      viewSuid();
    }
    setState(2683);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2684);
    viewName();
    setState(2685);
    viewTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewReplaceOrAlgorithmContext ------------------------------------------------------------------

MySQLParser::ViewReplaceOrAlgorithmContext::ViewReplaceOrAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewReplaceOrAlgorithmContext::OR_SYMBOL() {
  return getToken(MySQLParser::OR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewReplaceOrAlgorithmContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::ViewReplaceOrAlgorithmContext::viewAlgorithm() {
  return getRuleContext<MySQLParser::ViewAlgorithmContext>(0);
}


size_t MySQLParser::ViewReplaceOrAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleViewReplaceOrAlgorithm;
}

void MySQLParser::ViewReplaceOrAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewReplaceOrAlgorithm(this);
}

void MySQLParser::ViewReplaceOrAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewReplaceOrAlgorithm(this);
}


std::any MySQLParser::ViewReplaceOrAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewReplaceOrAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewReplaceOrAlgorithmContext* MySQLParser::viewReplaceOrAlgorithm() {
  ViewReplaceOrAlgorithmContext *_localctx = _tracker.createInstance<ViewReplaceOrAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 174, MySQLParser::RuleViewReplaceOrAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2693);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::OR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2687);
        match(MySQLParser::OR_SYMBOL);
        setState(2688);
        match(MySQLParser::REPLACE_SYMBOL);
        setState(2690);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ALGORITHM_SYMBOL) {
          setState(2689);
          viewAlgorithm();
        }
        break;
      }

      case MySQLParser::ALGORITHM_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2692);
        viewAlgorithm();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewAlgorithmContext ------------------------------------------------------------------

MySQLParser::ViewAlgorithmContext::ViewAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::UNDEFINED_SYMBOL() {
  return getToken(MySQLParser::UNDEFINED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::MERGE_SYMBOL() {
  return getToken(MySQLParser::MERGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::TEMPTABLE_SYMBOL() {
  return getToken(MySQLParser::TEMPTABLE_SYMBOL, 0);
}


size_t MySQLParser::ViewAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleViewAlgorithm;
}

void MySQLParser::ViewAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewAlgorithm(this);
}

void MySQLParser::ViewAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewAlgorithm(this);
}


std::any MySQLParser::ViewAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::viewAlgorithm() {
  ViewAlgorithmContext *_localctx = _tracker.createInstance<ViewAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 176, MySQLParser::RuleViewAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2695);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(2696);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(2697);
    antlrcpp::downCast<ViewAlgorithmContext *>(_localctx)->algorithm = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::MERGE_SYMBOL || _la == MySQLParser::TEMPTABLE_SYMBOL

    || _la == MySQLParser::UNDEFINED_SYMBOL)) {
      antlrcpp::downCast<ViewAlgorithmContext *>(_localctx)->algorithm = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewSuidContext ------------------------------------------------------------------

MySQLParser::ViewSuidContext::ViewSuidContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewSuidContext::SQL_SYMBOL() {
  return getToken(MySQLParser::SQL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::SECURITY_SYMBOL() {
  return getToken(MySQLParser::SECURITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::DEFINER_SYMBOL() {
  return getToken(MySQLParser::DEFINER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::INVOKER_SYMBOL() {
  return getToken(MySQLParser::INVOKER_SYMBOL, 0);
}


size_t MySQLParser::ViewSuidContext::getRuleIndex() const {
  return MySQLParser::RuleViewSuid;
}

void MySQLParser::ViewSuidContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewSuid(this);
}

void MySQLParser::ViewSuidContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewSuid(this);
}


std::any MySQLParser::ViewSuidContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewSuid(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewSuidContext* MySQLParser::viewSuid() {
  ViewSuidContext *_localctx = _tracker.createInstance<ViewSuidContext>(_ctx, getState());
  enterRule(_localctx, 178, MySQLParser::RuleViewSuid);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2699);
    match(MySQLParser::SQL_SYMBOL);
    setState(2700);
    match(MySQLParser::SECURITY_SYMBOL);
    setState(2701);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DEFINER_SYMBOL || _la == MySQLParser::INVOKER_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTriggerContext ------------------------------------------------------------------

MySQLParser::CreateTriggerContext::CreateTriggerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::TRIGGER_SYMBOL() {
  return getToken(MySQLParser::TRIGGER_SYMBOL, 0);
}

MySQLParser::TriggerNameContext* MySQLParser::CreateTriggerContext::triggerName() {
  return getRuleContext<MySQLParser::TriggerNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateTriggerContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::EACH_SYMBOL() {
  return getToken(MySQLParser::EACH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateTriggerContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::BEFORE_SYMBOL() {
  return getToken(MySQLParser::BEFORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::AFTER_SYMBOL() {
  return getToken(MySQLParser::AFTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::INSERT_SYMBOL() {
  return getToken(MySQLParser::INSERT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::DELETE_SYMBOL() {
  return getToken(MySQLParser::DELETE_SYMBOL, 0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateTriggerContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateTriggerContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

MySQLParser::TriggerFollowsPrecedesClauseContext* MySQLParser::CreateTriggerContext::triggerFollowsPrecedesClause() {
  return getRuleContext<MySQLParser::TriggerFollowsPrecedesClauseContext>(0);
}


size_t MySQLParser::CreateTriggerContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTrigger;
}

void MySQLParser::CreateTriggerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTrigger(this);
}

void MySQLParser::CreateTriggerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTrigger(this);
}


std::any MySQLParser::CreateTriggerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTrigger(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTriggerContext* MySQLParser::createTrigger() {
  CreateTriggerContext *_localctx = _tracker.createInstance<CreateTriggerContext>(_ctx, getState());
  enterRule(_localctx, 180, MySQLParser::RuleCreateTrigger);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2704);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2703);
      definerClause();
    }
    setState(2706);
    match(MySQLParser::TRIGGER_SYMBOL);
    setState(2709);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 181, _ctx)) {
    case 1: {
      setState(2707);

      if (!(serverVersion >= 80029)) throw FailedPredicateException(this, "serverVersion >= 80029");
      setState(2708);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2711);
    triggerName();
    setState(2712);
    antlrcpp::downCast<CreateTriggerContext *>(_localctx)->timing = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::AFTER_SYMBOL

    || _la == MySQLParser::BEFORE_SYMBOL)) {
      antlrcpp::downCast<CreateTriggerContext *>(_localctx)->timing = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2713);
    antlrcpp::downCast<CreateTriggerContext *>(_localctx)->event = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DELETE_SYMBOL || _la == MySQLParser::INSERT_SYMBOL || _la == MySQLParser::UPDATE_SYMBOL)) {
      antlrcpp::downCast<CreateTriggerContext *>(_localctx)->event = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2714);
    match(MySQLParser::ON_SYMBOL);
    setState(2715);
    tableRef();
    setState(2716);
    match(MySQLParser::FOR_SYMBOL);
    setState(2717);
    match(MySQLParser::EACH_SYMBOL);
    setState(2718);
    match(MySQLParser::ROW_SYMBOL);
    setState(2720);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 182, _ctx)) {
    case 1: {
      setState(2719);
      triggerFollowsPrecedesClause();
      break;
    }

    default:
      break;
    }
    setState(2722);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TriggerFollowsPrecedesClauseContext ------------------------------------------------------------------

MySQLParser::TriggerFollowsPrecedesClauseContext::TriggerFollowsPrecedesClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextOrIdentifierContext* MySQLParser::TriggerFollowsPrecedesClauseContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::TriggerFollowsPrecedesClauseContext::FOLLOWS_SYMBOL() {
  return getToken(MySQLParser::FOLLOWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TriggerFollowsPrecedesClauseContext::PRECEDES_SYMBOL() {
  return getToken(MySQLParser::PRECEDES_SYMBOL, 0);
}


size_t MySQLParser::TriggerFollowsPrecedesClauseContext::getRuleIndex() const {
  return MySQLParser::RuleTriggerFollowsPrecedesClause;
}

void MySQLParser::TriggerFollowsPrecedesClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTriggerFollowsPrecedesClause(this);
}

void MySQLParser::TriggerFollowsPrecedesClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTriggerFollowsPrecedesClause(this);
}


std::any MySQLParser::TriggerFollowsPrecedesClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTriggerFollowsPrecedesClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TriggerFollowsPrecedesClauseContext* MySQLParser::triggerFollowsPrecedesClause() {
  TriggerFollowsPrecedesClauseContext *_localctx = _tracker.createInstance<TriggerFollowsPrecedesClauseContext>(_ctx, getState());
  enterRule(_localctx, 182, MySQLParser::RuleTriggerFollowsPrecedesClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2724);
    antlrcpp::downCast<TriggerFollowsPrecedesClauseContext *>(_localctx)->ordering = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::FOLLOWS_SYMBOL || _la == MySQLParser::PRECEDES_SYMBOL)) {
      antlrcpp::downCast<TriggerFollowsPrecedesClauseContext *>(_localctx)->ordering = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2725);
    textOrIdentifier();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateEventContext ------------------------------------------------------------------

MySQLParser::CreateEventContext::CreateEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventNameContext* MySQLParser::CreateEventContext::eventName() {
  return getRuleContext<MySQLParser::EventNameContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateEventContext::ON_SYMBOL() {
  return getTokens(MySQLParser::ON_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateEventContext::ON_SYMBOL(size_t i) {
  return getToken(MySQLParser::ON_SYMBOL, i);
}

tree::TerminalNode* MySQLParser::CreateEventContext::SCHEDULE_SYMBOL() {
  return getToken(MySQLParser::SCHEDULE_SYMBOL, 0);
}

MySQLParser::ScheduleContext* MySQLParser::CreateEventContext::schedule() {
  return getRuleContext<MySQLParser::ScheduleContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateEventContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateEventContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateEventContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::COMPLETION_SYMBOL() {
  return getToken(MySQLParser::COMPLETION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::PRESERVE_SYMBOL() {
  return getToken(MySQLParser::PRESERVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateEventContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}

MySQLParser::ReplicaContext* MySQLParser::CreateEventContext::replica() {
  return getRuleContext<MySQLParser::ReplicaContext>(0);
}


size_t MySQLParser::CreateEventContext::getRuleIndex() const {
  return MySQLParser::RuleCreateEvent;
}

void MySQLParser::CreateEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateEvent(this);
}

void MySQLParser::CreateEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateEvent(this);
}


std::any MySQLParser::CreateEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateEventContext* MySQLParser::createEvent() {
  CreateEventContext *_localctx = _tracker.createInstance<CreateEventContext>(_ctx, getState());
  enterRule(_localctx, 184, MySQLParser::RuleCreateEvent);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2728);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2727);
      definerClause();
    }
    setState(2730);
    match(MySQLParser::EVENT_SYMBOL);
    setState(2732);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 184, _ctx)) {
    case 1: {
      setState(2731);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2734);
    eventName();
    setState(2735);
    match(MySQLParser::ON_SYMBOL);
    setState(2736);
    match(MySQLParser::SCHEDULE_SYMBOL);
    setState(2737);
    schedule();
    setState(2744);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(2738);
      match(MySQLParser::ON_SYMBOL);
      setState(2739);
      match(MySQLParser::COMPLETION_SYMBOL);
      setState(2741);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::NOT_SYMBOL) {
        setState(2740);
        match(MySQLParser::NOT_SYMBOL);
      }
      setState(2743);
      match(MySQLParser::PRESERVE_SYMBOL);
    }
    setState(2752);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ENABLE_SYMBOL: {
        setState(2746);
        match(MySQLParser::ENABLE_SYMBOL);
        break;
      }

      case MySQLParser::DISABLE_SYMBOL: {
        setState(2747);
        match(MySQLParser::DISABLE_SYMBOL);
        setState(2750);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ON_SYMBOL) {
          setState(2748);
          match(MySQLParser::ON_SYMBOL);
          setState(2749);
          replica();
        }
        break;
      }

      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::DO_SYMBOL: {
        break;
      }

    default:
      break;
    }
    setState(2756);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL) {
      setState(2754);
      match(MySQLParser::COMMENT_SYMBOL);
      setState(2755);
      textLiteral();
    }
    setState(2758);
    match(MySQLParser::DO_SYMBOL);
    setState(2759);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateRoleContext ------------------------------------------------------------------

MySQLParser::CreateRoleContext::CreateRoleContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateRoleContext::ROLE_SYMBOL() {
  return getToken(MySQLParser::ROLE_SYMBOL, 0);
}

MySQLParser::RoleListContext* MySQLParser::CreateRoleContext::roleList() {
  return getRuleContext<MySQLParser::RoleListContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateRoleContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateRoleContext::getRuleIndex() const {
  return MySQLParser::RuleCreateRole;
}

void MySQLParser::CreateRoleContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateRole(this);
}

void MySQLParser::CreateRoleContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateRole(this);
}


std::any MySQLParser::CreateRoleContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateRole(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateRoleContext* MySQLParser::createRole() {
  CreateRoleContext *_localctx = _tracker.createInstance<CreateRoleContext>(_ctx, getState());
  enterRule(_localctx, 186, MySQLParser::RuleCreateRole);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2761);
    match(MySQLParser::ROLE_SYMBOL);
    setState(2763);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 190, _ctx)) {
    case 1: {
      setState(2762);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2765);
    roleList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateSpatialReferenceContext ------------------------------------------------------------------

MySQLParser::CreateSpatialReferenceContext::CreateSpatialReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::OR_SYMBOL() {
  return getToken(MySQLParser::OR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::REFERENCE_SYMBOL() {
  return getToken(MySQLParser::REFERENCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::SYSTEM_SYMBOL() {
  return getToken(MySQLParser::SYSTEM_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::CreateSpatialReferenceContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

std::vector<MySQLParser::SrsAttributeContext *> MySQLParser::CreateSpatialReferenceContext::srsAttribute() {
  return getRuleContexts<MySQLParser::SrsAttributeContext>();
}

MySQLParser::SrsAttributeContext* MySQLParser::CreateSpatialReferenceContext::srsAttribute(size_t i) {
  return getRuleContext<MySQLParser::SrsAttributeContext>(i);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateSpatialReferenceContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateSpatialReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateSpatialReference;
}

void MySQLParser::CreateSpatialReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateSpatialReference(this);
}

void MySQLParser::CreateSpatialReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateSpatialReference(this);
}


std::any MySQLParser::CreateSpatialReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateSpatialReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateSpatialReferenceContext* MySQLParser::createSpatialReference() {
  CreateSpatialReferenceContext *_localctx = _tracker.createInstance<CreateSpatialReferenceContext>(_ctx, getState());
  enterRule(_localctx, 188, MySQLParser::RuleCreateSpatialReference);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2792);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::OR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2767);
        match(MySQLParser::OR_SYMBOL);
        setState(2768);
        match(MySQLParser::REPLACE_SYMBOL);
        setState(2769);
        match(MySQLParser::SPATIAL_SYMBOL);
        setState(2770);
        match(MySQLParser::REFERENCE_SYMBOL);
        setState(2771);
        match(MySQLParser::SYSTEM_SYMBOL);
        setState(2772);
        real_ulonglong_number();
        setState(2776);
        _errHandler->sync(this);
        _la = _input->LA(1);
        while (_la == MySQLParser::NAME_SYMBOL || ((((_la - 740) & ~ 0x3fULL) == 0) &&
          ((1ULL << (_la - 740)) & ((1ULL << (MySQLParser::DEFINITION_SYMBOL - 740))
          | (1ULL << (MySQLParser::DESCRIPTION_SYMBOL - 740))
          | (1ULL << (MySQLParser::ORGANIZATION_SYMBOL - 740)))) != 0)) {
          setState(2773);
          srsAttribute();
          setState(2778);
          _errHandler->sync(this);
          _la = _input->LA(1);
        }
        break;
      }

      case MySQLParser::SPATIAL_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2779);
        match(MySQLParser::SPATIAL_SYMBOL);
        setState(2780);
        match(MySQLParser::REFERENCE_SYMBOL);
        setState(2781);
        match(MySQLParser::SYSTEM_SYMBOL);
        setState(2783);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 192, _ctx)) {
        case 1: {
          setState(2782);
          ifNotExists();
          break;
        }

        default:
          break;
        }
        setState(2785);
        real_ulonglong_number();
        setState(2789);
        _errHandler->sync(this);
        _la = _input->LA(1);
        while (_la == MySQLParser::NAME_SYMBOL || ((((_la - 740) & ~ 0x3fULL) == 0) &&
          ((1ULL << (_la - 740)) & ((1ULL << (MySQLParser::DEFINITION_SYMBOL - 740))
          | (1ULL << (MySQLParser::DESCRIPTION_SYMBOL - 740))
          | (1ULL << (MySQLParser::ORGANIZATION_SYMBOL - 740)))) != 0)) {
          setState(2786);
          srsAttribute();
          setState(2791);
          _errHandler->sync(this);
          _la = _input->LA(1);
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SrsAttributeContext ------------------------------------------------------------------

MySQLParser::SrsAttributeContext::SrsAttributeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::NAME_SYMBOL() {
  return getToken(MySQLParser::NAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::TEXT_SYMBOL() {
  return getToken(MySQLParser::TEXT_SYMBOL, 0);
}

MySQLParser::TextStringNoLinebreakContext* MySQLParser::SrsAttributeContext::textStringNoLinebreak() {
  return getRuleContext<MySQLParser::TextStringNoLinebreakContext>(0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::DEFINITION_SYMBOL() {
  return getToken(MySQLParser::DEFINITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::ORGANIZATION_SYMBOL() {
  return getToken(MySQLParser::ORGANIZATION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::IDENTIFIED_SYMBOL() {
  return getToken(MySQLParser::IDENTIFIED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::SrsAttributeContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::DESCRIPTION_SYMBOL() {
  return getToken(MySQLParser::DESCRIPTION_SYMBOL, 0);
}


size_t MySQLParser::SrsAttributeContext::getRuleIndex() const {
  return MySQLParser::RuleSrsAttribute;
}

void MySQLParser::SrsAttributeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSrsAttribute(this);
}

void MySQLParser::SrsAttributeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSrsAttribute(this);
}


std::any MySQLParser::SrsAttributeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSrsAttribute(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SrsAttributeContext* MySQLParser::srsAttribute() {
  SrsAttributeContext *_localctx = _tracker.createInstance<SrsAttributeContext>(_ctx, getState());
  enterRule(_localctx, 190, MySQLParser::RuleSrsAttribute);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2809);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::NAME_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2794);
        match(MySQLParser::NAME_SYMBOL);
        setState(2795);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2796);
        textStringNoLinebreak();
        break;
      }

      case MySQLParser::DEFINITION_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2797);
        match(MySQLParser::DEFINITION_SYMBOL);
        setState(2798);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2799);
        textStringNoLinebreak();
        break;
      }

      case MySQLParser::ORGANIZATION_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2800);
        match(MySQLParser::ORGANIZATION_SYMBOL);
        setState(2801);
        textStringNoLinebreak();
        setState(2802);
        match(MySQLParser::IDENTIFIED_SYMBOL);
        setState(2803);
        match(MySQLParser::BY_SYMBOL);
        setState(2804);
        real_ulonglong_number();
        break;
      }

      case MySQLParser::DESCRIPTION_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2806);
        match(MySQLParser::DESCRIPTION_SYMBOL);
        setState(2807);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2808);
        textStringNoLinebreak();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropStatementContext ------------------------------------------------------------------

MySQLParser::DropStatementContext::DropStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropStatementContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

MySQLParser::DropDatabaseContext* MySQLParser::DropStatementContext::dropDatabase() {
  return getRuleContext<MySQLParser::DropDatabaseContext>(0);
}

MySQLParser::DropEventContext* MySQLParser::DropStatementContext::dropEvent() {
  return getRuleContext<MySQLParser::DropEventContext>(0);
}

MySQLParser::DropFunctionContext* MySQLParser::DropStatementContext::dropFunction() {
  return getRuleContext<MySQLParser::DropFunctionContext>(0);
}

MySQLParser::DropProcedureContext* MySQLParser::DropStatementContext::dropProcedure() {
  return getRuleContext<MySQLParser::DropProcedureContext>(0);
}

MySQLParser::DropIndexContext* MySQLParser::DropStatementContext::dropIndex() {
  return getRuleContext<MySQLParser::DropIndexContext>(0);
}

MySQLParser::DropLogfileGroupContext* MySQLParser::DropStatementContext::dropLogfileGroup() {
  return getRuleContext<MySQLParser::DropLogfileGroupContext>(0);
}

MySQLParser::DropServerContext* MySQLParser::DropStatementContext::dropServer() {
  return getRuleContext<MySQLParser::DropServerContext>(0);
}

MySQLParser::DropTableContext* MySQLParser::DropStatementContext::dropTable() {
  return getRuleContext<MySQLParser::DropTableContext>(0);
}

MySQLParser::DropTableSpaceContext* MySQLParser::DropStatementContext::dropTableSpace() {
  return getRuleContext<MySQLParser::DropTableSpaceContext>(0);
}

MySQLParser::DropTriggerContext* MySQLParser::DropStatementContext::dropTrigger() {
  return getRuleContext<MySQLParser::DropTriggerContext>(0);
}

MySQLParser::DropViewContext* MySQLParser::DropStatementContext::dropView() {
  return getRuleContext<MySQLParser::DropViewContext>(0);
}

MySQLParser::DropRoleContext* MySQLParser::DropStatementContext::dropRole() {
  return getRuleContext<MySQLParser::DropRoleContext>(0);
}

MySQLParser::DropSpatialReferenceContext* MySQLParser::DropStatementContext::dropSpatialReference() {
  return getRuleContext<MySQLParser::DropSpatialReferenceContext>(0);
}

MySQLParser::DropUndoTablespaceContext* MySQLParser::DropStatementContext::dropUndoTablespace() {
  return getRuleContext<MySQLParser::DropUndoTablespaceContext>(0);
}


size_t MySQLParser::DropStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDropStatement;
}

void MySQLParser::DropStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropStatement(this);
}

void MySQLParser::DropStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropStatement(this);
}


std::any MySQLParser::DropStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropStatementContext* MySQLParser::dropStatement() {
  DropStatementContext *_localctx = _tracker.createInstance<DropStatementContext>(_ctx, getState());
  enterRule(_localctx, 192, MySQLParser::RuleDropStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2811);
    match(MySQLParser::DROP_SYMBOL);
    setState(2829);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 196, _ctx)) {
    case 1: {
      setState(2812);
      dropDatabase();
      break;
    }

    case 2: {
      setState(2813);
      dropEvent();
      break;
    }

    case 3: {
      setState(2814);
      dropFunction();
      break;
    }

    case 4: {
      setState(2815);
      dropProcedure();
      break;
    }

    case 5: {
      setState(2816);
      dropIndex();
      break;
    }

    case 6: {
      setState(2817);
      dropLogfileGroup();
      break;
    }

    case 7: {
      setState(2818);
      dropServer();
      break;
    }

    case 8: {
      setState(2819);
      dropTable();
      break;
    }

    case 9: {
      setState(2820);
      dropTableSpace();
      break;
    }

    case 10: {
      setState(2821);
      dropTrigger();
      break;
    }

    case 11: {
      setState(2822);
      dropView();
      break;
    }

    case 12: {
      setState(2823);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2824);
      dropRole();
      break;
    }

    case 13: {
      setState(2825);

      if (!(serverVersion >= 80011)) throw FailedPredicateException(this, "serverVersion >= 80011");
      setState(2826);
      dropSpatialReference();
      break;
    }

    case 14: {
      setState(2827);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2828);
      dropUndoTablespace();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropDatabaseContext ------------------------------------------------------------------

MySQLParser::DropDatabaseContext::DropDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaRefContext* MySQLParser::DropDatabaseContext::schemaRef() {
  return getRuleContext<MySQLParser::SchemaRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropDatabaseContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleDropDatabase;
}

void MySQLParser::DropDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropDatabase(this);
}

void MySQLParser::DropDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropDatabase(this);
}


std::any MySQLParser::DropDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropDatabaseContext* MySQLParser::dropDatabase() {
  DropDatabaseContext *_localctx = _tracker.createInstance<DropDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 194, MySQLParser::RuleDropDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2831);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(2833);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 197, _ctx)) {
    case 1: {
      setState(2832);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2835);
    schemaRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropEventContext ------------------------------------------------------------------

MySQLParser::DropEventContext::DropEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventRefContext* MySQLParser::DropEventContext::eventRef() {
  return getRuleContext<MySQLParser::EventRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropEventContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropEventContext::getRuleIndex() const {
  return MySQLParser::RuleDropEvent;
}

void MySQLParser::DropEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropEvent(this);
}

void MySQLParser::DropEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropEvent(this);
}


std::any MySQLParser::DropEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropEventContext* MySQLParser::dropEvent() {
  DropEventContext *_localctx = _tracker.createInstance<DropEventContext>(_ctx, getState());
  enterRule(_localctx, 196, MySQLParser::RuleDropEvent);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2837);
    match(MySQLParser::EVENT_SYMBOL);
    setState(2839);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 198, _ctx)) {
    case 1: {
      setState(2838);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2841);
    eventRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropFunctionContext ------------------------------------------------------------------

MySQLParser::DropFunctionContext::DropFunctionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropFunctionContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionRefContext* MySQLParser::DropFunctionContext::functionRef() {
  return getRuleContext<MySQLParser::FunctionRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropFunctionContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropFunctionContext::getRuleIndex() const {
  return MySQLParser::RuleDropFunction;
}

void MySQLParser::DropFunctionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropFunction(this);
}

void MySQLParser::DropFunctionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropFunction(this);
}


std::any MySQLParser::DropFunctionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropFunction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropFunctionContext* MySQLParser::dropFunction() {
  DropFunctionContext *_localctx = _tracker.createInstance<DropFunctionContext>(_ctx, getState());
  enterRule(_localctx, 198, MySQLParser::RuleDropFunction);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2843);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2845);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 199, _ctx)) {
    case 1: {
      setState(2844);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2847);
    functionRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropProcedureContext ------------------------------------------------------------------

MySQLParser::DropProcedureContext::DropProcedureContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropProcedureContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::DropProcedureContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropProcedureContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropProcedureContext::getRuleIndex() const {
  return MySQLParser::RuleDropProcedure;
}

void MySQLParser::DropProcedureContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropProcedure(this);
}

void MySQLParser::DropProcedureContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropProcedure(this);
}


std::any MySQLParser::DropProcedureContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropProcedure(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropProcedureContext* MySQLParser::dropProcedure() {
  DropProcedureContext *_localctx = _tracker.createInstance<DropProcedureContext>(_ctx, getState());
  enterRule(_localctx, 200, MySQLParser::RuleDropProcedure);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2849);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(2851);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 200, _ctx)) {
    case 1: {
      setState(2850);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2853);
    procedureRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropIndexContext ------------------------------------------------------------------

MySQLParser::DropIndexContext::DropIndexContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexRefContext* MySQLParser::DropIndexContext::indexRef() {
  return getRuleContext<MySQLParser::IndexRefContext>(0);
}

tree::TerminalNode* MySQLParser::DropIndexContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::DropIndexContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::DropIndexContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::OnlineOptionContext* MySQLParser::DropIndexContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::DropIndexContext::indexLockAndAlgorithm() {
  return getRuleContext<MySQLParser::IndexLockAndAlgorithmContext>(0);
}


size_t MySQLParser::DropIndexContext::getRuleIndex() const {
  return MySQLParser::RuleDropIndex;
}

void MySQLParser::DropIndexContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropIndex(this);
}

void MySQLParser::DropIndexContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropIndex(this);
}


std::any MySQLParser::DropIndexContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropIndex(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropIndexContext* MySQLParser::dropIndex() {
  DropIndexContext *_localctx = _tracker.createInstance<DropIndexContext>(_ctx, getState());
  enterRule(_localctx, 202, MySQLParser::RuleDropIndex);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2856);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(2855);
      onlineOption();
    }
    setState(2858);
    antlrcpp::downCast<DropIndexContext *>(_localctx)->type = match(MySQLParser::INDEX_SYMBOL);
    setState(2859);
    indexRef();
    setState(2860);
    match(MySQLParser::ON_SYMBOL);
    setState(2861);
    tableRef();
    setState(2863);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
      setState(2862);
      indexLockAndAlgorithm();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropLogfileGroupContext ------------------------------------------------------------------

MySQLParser::DropLogfileGroupContext::DropLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::DropLogfileGroupContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

std::vector<MySQLParser::DropLogfileGroupOptionContext *> MySQLParser::DropLogfileGroupContext::dropLogfileGroupOption() {
  return getRuleContexts<MySQLParser::DropLogfileGroupOptionContext>();
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::DropLogfileGroupContext::dropLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::DropLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::DropLogfileGroupContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::DropLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleDropLogfileGroup;
}

void MySQLParser::DropLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropLogfileGroup(this);
}

void MySQLParser::DropLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropLogfileGroup(this);
}


std::any MySQLParser::DropLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropLogfileGroupContext* MySQLParser::dropLogfileGroup() {
  DropLogfileGroupContext *_localctx = _tracker.createInstance<DropLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 204, MySQLParser::RuleDropLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2865);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(2866);
    match(MySQLParser::GROUP_SYMBOL);
    setState(2867);
    logfileGroupRef();
    setState(2878);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2868);
      dropLogfileGroupOption();
      setState(2875);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
        setState(2870);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::COMMA_SYMBOL) {
          setState(2869);
          match(MySQLParser::COMMA_SYMBOL);
        }
        setState(2872);
        dropLogfileGroupOption();
        setState(2877);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropLogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::DropLogfileGroupOptionContext::DropLogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionWaitContext* MySQLParser::DropLogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::DropLogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}


size_t MySQLParser::DropLogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleDropLogfileGroupOption;
}

void MySQLParser::DropLogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropLogfileGroupOption(this);
}

void MySQLParser::DropLogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropLogfileGroupOption(this);
}


std::any MySQLParser::DropLogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::dropLogfileGroupOption() {
  DropLogfileGroupOptionContext *_localctx = _tracker.createInstance<DropLogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 206, MySQLParser::RuleDropLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2882);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2880);
        tsOptionWait();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2881);
        tsOptionEngine();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropServerContext ------------------------------------------------------------------

MySQLParser::DropServerContext::DropServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerRefContext* MySQLParser::DropServerContext::serverRef() {
  return getRuleContext<MySQLParser::ServerRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropServerContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropServerContext::getRuleIndex() const {
  return MySQLParser::RuleDropServer;
}

void MySQLParser::DropServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropServer(this);
}

void MySQLParser::DropServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropServer(this);
}


std::any MySQLParser::DropServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropServerContext* MySQLParser::dropServer() {
  DropServerContext *_localctx = _tracker.createInstance<DropServerContext>(_ctx, getState());
  enterRule(_localctx, 208, MySQLParser::RuleDropServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2884);
    match(MySQLParser::SERVER_SYMBOL);
    setState(2886);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 207, _ctx)) {
    case 1: {
      setState(2885);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2888);
    serverRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTableContext ------------------------------------------------------------------

MySQLParser::DropTableContext::DropTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableRefListContext* MySQLParser::DropTableContext::tableRefList() {
  return getRuleContext<MySQLParser::TableRefListContext>(0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TABLES_SYMBOL() {
  return getToken(MySQLParser::TABLES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TEMPORARY_SYMBOL() {
  return getToken(MySQLParser::TEMPORARY_SYMBOL, 0);
}

MySQLParser::IfExistsContext* MySQLParser::DropTableContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}

tree::TerminalNode* MySQLParser::DropTableContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::DropTableContext::getRuleIndex() const {
  return MySQLParser::RuleDropTable;
}

void MySQLParser::DropTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTable(this);
}

void MySQLParser::DropTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTable(this);
}


std::any MySQLParser::DropTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTableContext* MySQLParser::dropTable() {
  DropTableContext *_localctx = _tracker.createInstance<DropTableContext>(_ctx, getState());
  enterRule(_localctx, 210, MySQLParser::RuleDropTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2891);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::TEMPORARY_SYMBOL) {
      setState(2890);
      match(MySQLParser::TEMPORARY_SYMBOL);
    }
    setState(2893);
    antlrcpp::downCast<DropTableContext *>(_localctx)->type = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::TABLES_SYMBOL

    || _la == MySQLParser::TABLE_SYMBOL)) {
      antlrcpp::downCast<DropTableContext *>(_localctx)->type = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2895);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 209, _ctx)) {
    case 1: {
      setState(2894);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2897);
    tableRefList();
    setState(2899);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
      setState(2898);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTableSpaceContext ------------------------------------------------------------------

MySQLParser::DropTableSpaceContext::DropTableSpaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropTableSpaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::DropTableSpaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

std::vector<MySQLParser::DropLogfileGroupOptionContext *> MySQLParser::DropTableSpaceContext::dropLogfileGroupOption() {
  return getRuleContexts<MySQLParser::DropLogfileGroupOptionContext>();
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::DropTableSpaceContext::dropLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::DropLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::DropTableSpaceContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::DropTableSpaceContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::DropTableSpaceContext::getRuleIndex() const {
  return MySQLParser::RuleDropTableSpace;
}

void MySQLParser::DropTableSpaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTableSpace(this);
}

void MySQLParser::DropTableSpaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTableSpace(this);
}


std::any MySQLParser::DropTableSpaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTableSpace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTableSpaceContext* MySQLParser::dropTableSpace() {
  DropTableSpaceContext *_localctx = _tracker.createInstance<DropTableSpaceContext>(_ctx, getState());
  enterRule(_localctx, 212, MySQLParser::RuleDropTableSpace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2901);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2902);
    tablespaceRef();
    setState(2913);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2903);
      dropLogfileGroupOption();
      setState(2910);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
        setState(2905);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::COMMA_SYMBOL) {
          setState(2904);
          match(MySQLParser::COMMA_SYMBOL);
        }
        setState(2907);
        dropLogfileGroupOption();
        setState(2912);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTriggerContext ------------------------------------------------------------------

MySQLParser::DropTriggerContext::DropTriggerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropTriggerContext::TRIGGER_SYMBOL() {
  return getToken(MySQLParser::TRIGGER_SYMBOL, 0);
}

MySQLParser::TriggerRefContext* MySQLParser::DropTriggerContext::triggerRef() {
  return getRuleContext<MySQLParser::TriggerRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropTriggerContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropTriggerContext::getRuleIndex() const {
  return MySQLParser::RuleDropTrigger;
}

void MySQLParser::DropTriggerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTrigger(this);
}

void MySQLParser::DropTriggerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTrigger(this);
}


std::any MySQLParser::DropTriggerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTrigger(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTriggerContext* MySQLParser::dropTrigger() {
  DropTriggerContext *_localctx = _tracker.createInstance<DropTriggerContext>(_ctx, getState());
  enterRule(_localctx, 214, MySQLParser::RuleDropTrigger);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2915);
    match(MySQLParser::TRIGGER_SYMBOL);
    setState(2917);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 214, _ctx)) {
    case 1: {
      setState(2916);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2919);
    triggerRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropViewContext ------------------------------------------------------------------

MySQLParser::DropViewContext::DropViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewRefListContext* MySQLParser::DropViewContext::viewRefList() {
  return getRuleContext<MySQLParser::ViewRefListContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropViewContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}

tree::TerminalNode* MySQLParser::DropViewContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropViewContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::DropViewContext::getRuleIndex() const {
  return MySQLParser::RuleDropView;
}

void MySQLParser::DropViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropView(this);
}

void MySQLParser::DropViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropView(this);
}


std::any MySQLParser::DropViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropViewContext* MySQLParser::dropView() {
  DropViewContext *_localctx = _tracker.createInstance<DropViewContext>(_ctx, getState());
  enterRule(_localctx, 216, MySQLParser::RuleDropView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2921);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2923);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 215, _ctx)) {
    case 1: {
      setState(2922);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2925);
    viewRefList();
    setState(2927);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
      setState(2926);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropRoleContext ------------------------------------------------------------------

MySQLParser::DropRoleContext::DropRoleContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropRoleContext::ROLE_SYMBOL() {
  return getToken(MySQLParser::ROLE_SYMBOL, 0);
}

MySQLParser::RoleListContext* MySQLParser::DropRoleContext::roleList() {
  return getRuleContext<MySQLParser::RoleListContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropRoleContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropRoleContext::getRuleIndex() const {
  return MySQLParser::RuleDropRole;
}

void MySQLParser::DropRoleContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropRole(this);
}

void MySQLParser::DropRoleContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropRole(this);
}


std::any MySQLParser::DropRoleContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropRole(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropRoleContext* MySQLParser::dropRole() {
  DropRoleContext *_localctx = _tracker.createInstance<DropRoleContext>(_ctx, getState());
  enterRule(_localctx, 218, MySQLParser::RuleDropRole);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2929);
    match(MySQLParser::ROLE_SYMBOL);
    setState(2931);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 217, _ctx)) {
    case 1: {
      setState(2930);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2933);
    roleList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropSpatialReferenceContext ------------------------------------------------------------------

MySQLParser::DropSpatialReferenceContext::DropSpatialReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::REFERENCE_SYMBOL() {
  return getToken(MySQLParser::REFERENCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::SYSTEM_SYMBOL() {
  return getToken(MySQLParser::SYSTEM_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::DropSpatialReferenceContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropSpatialReferenceContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropSpatialReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleDropSpatialReference;
}

void MySQLParser::DropSpatialReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropSpatialReference(this);
}

void MySQLParser::DropSpatialReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropSpatialReference(this);
}


std::any MySQLParser::DropSpatialReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropSpatialReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropSpatialReferenceContext* MySQLParser::dropSpatialReference() {
  DropSpatialReferenceContext *_localctx = _tracker.createInstance<DropSpatialReferenceContext>(_ctx, getState());
  enterRule(_localctx, 220, MySQLParser::RuleDropSpatialReference);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2935);
    match(MySQLParser::SPATIAL_SYMBOL);
    setState(2936);
    match(MySQLParser::REFERENCE_SYMBOL);
    setState(2937);
    match(MySQLParser::SYSTEM_SYMBOL);
    setState(2939);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 218, _ctx)) {
    case 1: {
      setState(2938);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2941);
    real_ulonglong_number();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::DropUndoTablespaceContext::DropUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::DropUndoTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::DropUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::DropUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleDropUndoTablespace;
}

void MySQLParser::DropUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropUndoTablespace(this);
}

void MySQLParser::DropUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropUndoTablespace(this);
}


std::any MySQLParser::DropUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropUndoTablespaceContext* MySQLParser::dropUndoTablespace() {
  DropUndoTablespaceContext *_localctx = _tracker.createInstance<DropUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 222, MySQLParser::RuleDropUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2943);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2944);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2945);
    tablespaceRef();
    setState(2947);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2946);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RenameTableStatementContext ------------------------------------------------------------------

MySQLParser::RenameTableStatementContext::RenameTableStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

std::vector<MySQLParser::RenamePairContext *> MySQLParser::RenameTableStatementContext::renamePair() {
  return getRuleContexts<MySQLParser::RenamePairContext>();
}

MySQLParser::RenamePairContext* MySQLParser::RenameTableStatementContext::renamePair(size_t i) {
  return getRuleContext<MySQLParser::RenamePairContext>(i);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::TABLES_SYMBOL() {
  return getToken(MySQLParser::TABLES_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::RenameTableStatementContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::RenameTableStatementContext::getRuleIndex() const {
  return MySQLParser::RuleRenameTableStatement;
}

void MySQLParser::RenameTableStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRenameTableStatement(this);
}

void MySQLParser::RenameTableStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRenameTableStatement(this);
}


std::any MySQLParser::RenameTableStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRenameTableStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RenameTableStatementContext* MySQLParser::renameTableStatement() {
  RenameTableStatementContext *_localctx = _tracker.createInstance<RenameTableStatementContext>(_ctx, getState());
  enterRule(_localctx, 224, MySQLParser::RuleRenameTableStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2949);
    match(MySQLParser::RENAME_SYMBOL);
    setState(2950);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::TABLES_SYMBOL

    || _la == MySQLParser::TABLE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2951);
    renamePair();
    setState(2956);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2952);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2953);
      renamePair();
      setState(2958);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RenamePairContext ------------------------------------------------------------------

MySQLParser::RenamePairContext::RenamePairContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableRefContext* MySQLParser::RenamePairContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::RenamePairContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::RenamePairContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}


size_t MySQLParser::RenamePairContext::getRuleIndex() const {
  return MySQLParser::RuleRenamePair;
}

void MySQLParser::RenamePairContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRenamePair(this);
}

void MySQLParser::RenamePairContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRenamePair(this);
}


std::any MySQLParser::RenamePairContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRenamePair(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RenamePairContext* MySQLParser::renamePair() {
  RenamePairContext *_localctx = _tracker.createInstance<RenamePairContext>(_ctx, getState());
  enterRule(_localctx, 226, MySQLParser::RuleRenamePair);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2959);
    tableRef();
    setState(2960);
    match(MySQLParser::TO_SYMBOL);
    setState(2961);
    tableName();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TruncateTableStatementContext ------------------------------------------------------------------

MySQLParser::TruncateTableStatementContext::TruncateTableStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TruncateTableStatementContext::TRUNCATE_SYMBOL() {
  return getToken(MySQLParser::TRUNCATE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::TruncateTableStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::TruncateTableStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}


size_t MySQLParser::TruncateTableStatementContext::getRuleIndex() const {
  return MySQLParser::RuleTruncateTableStatement;
}

void MySQLParser::TruncateTableStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTruncateTableStatement(this);
}

void MySQLParser::TruncateTableStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTruncateTableStatement(this);
}


std::any MySQLParser::TruncateTableStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTruncateTableStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TruncateTableStatementContext* MySQLParser::truncateTableStatement() {
  TruncateTableStatementContext *_localctx = _tracker.createInstance<TruncateTableStatementContext>(_ctx, getState());
  enterRule(_localctx, 228, MySQLParser::RuleTruncateTableStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2963);
    match(MySQLParser::TRUNCATE_SYMBOL);
    setState(2965);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 221, _ctx)) {
    case 1: {
      setState(2964);
      match(MySQLParser::TABLE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2967);
    tableRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ImportStatementContext ------------------------------------------------------------------

MySQLParser::ImportStatementContext::ImportStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ImportStatementContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ImportStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ImportStatementContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

MySQLParser::TextStringLiteralListContext* MySQLParser::ImportStatementContext::textStringLiteralList() {
  return getRuleContext<MySQLParser::TextStringLiteralListContext>(0);
}


size_t MySQLParser::ImportStatementContext::getRuleIndex() const {
  return MySQLParser::RuleImportStatement;
}

void MySQLParser::ImportStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterImportStatement(this);
}

void MySQLParser::ImportStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitImportStatement(this);
}


std::any MySQLParser::ImportStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitImportStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ImportStatementContext* MySQLParser::importStatement() {
  ImportStatementContext *_localctx = _tracker.createInstance<ImportStatementContext>(_ctx, getState());
  enterRule(_localctx, 230, MySQLParser::RuleImportStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2969);
    match(MySQLParser::IMPORT_SYMBOL);
    setState(2970);
    match(MySQLParser::TABLE_SYMBOL);
    setState(2971);
    match(MySQLParser::FROM_SYMBOL);
    setState(2972);
    textStringLiteralList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CallStatementContext ------------------------------------------------------------------

MySQLParser::CallStatementContext::CallStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CallStatementContext::CALL_SYMBOL() {
  return getToken(MySQLParser::CALL_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::CallStatementContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

tree::TerminalNode* MySQLParser::CallStatementContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CallStatementContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::ExprListContext* MySQLParser::CallStatementContext::exprList() {
  return getRuleContext<MySQLParser::ExprListContext>(0);
}


size_t MySQLParser::CallStatementContext::getRuleIndex() const {
  return MySQLParser::RuleCallStatement;
}

void MySQLParser::CallStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCallStatement(this);
}

void MySQLParser::CallStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCallStatement(this);
}


std::any MySQLParser::CallStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCallStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CallStatementContext* MySQLParser::callStatement() {
  CallStatementContext *_localctx = _tracker.createInstance<CallStatementContext>(_ctx, getState());
  enterRule(_localctx, 232, MySQLParser::RuleCallStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2974);
    match(MySQLParser::CALL_SYMBOL);
    setState(2975);
    procedureRef();
    setState(2981);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2976);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2978);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 222, _ctx)) {
      case 1: {
        setState(2977);
        exprList();
        break;
      }

      default:
        break;
      }
      setState(2980);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DeleteStatementContext ------------------------------------------------------------------

MySQLParser::DeleteStatementContext::DeleteStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::DELETE_SYMBOL() {
  return getToken(MySQLParser::DELETE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

MySQLParser::TableAliasRefListContext* MySQLParser::DeleteStatementContext::tableAliasRefList() {
  return getRuleContext<MySQLParser::TableAliasRefListContext>(0);
}

MySQLParser::TableReferenceListContext* MySQLParser::DeleteStatementContext::tableReferenceList() {
  return getRuleContext<MySQLParser::TableReferenceListContext>(0);
}

MySQLParser::WithClauseContext* MySQLParser::DeleteStatementContext::withClause() {
  return getRuleContext<MySQLParser::WithClauseContext>(0);
}

std::vector<MySQLParser::DeleteStatementOptionContext *> MySQLParser::DeleteStatementContext::deleteStatementOption() {
  return getRuleContexts<MySQLParser::DeleteStatementOptionContext>();
}

MySQLParser::DeleteStatementOptionContext* MySQLParser::DeleteStatementContext::deleteStatementOption(size_t i) {
  return getRuleContext<MySQLParser::DeleteStatementOptionContext>(i);
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::USING_SYMBOL() {
  return getToken(MySQLParser::USING_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::DeleteStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::DeleteStatementContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::DeleteStatementContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::PartitionDeleteContext* MySQLParser::DeleteStatementContext::partitionDelete() {
  return getRuleContext<MySQLParser::PartitionDeleteContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::DeleteStatementContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::SimpleLimitClauseContext* MySQLParser::DeleteStatementContext::simpleLimitClause() {
  return getRuleContext<MySQLParser::SimpleLimitClauseContext>(0);
}


size_t MySQLParser::DeleteStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDeleteStatement;
}

void MySQLParser::DeleteStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDeleteStatement(this);
}

void MySQLParser::DeleteStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDeleteStatement(this);
}


std::any MySQLParser::DeleteStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDeleteStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DeleteStatementContext* MySQLParser::deleteStatement() {
  DeleteStatementContext *_localctx = _tracker.createInstance<DeleteStatementContext>(_ctx, getState());
  enterRule(_localctx, 234, MySQLParser::RuleDeleteStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2985);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 224, _ctx)) {
    case 1: {
      setState(2983);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2984);
      withClause();
      break;
    }

    default:
      break;
    }
    setState(2987);
    match(MySQLParser::DELETE_SYMBOL);
    setState(2991);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 225, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2988);
        deleteStatementOption(); 
      }
      setState(2993);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 225, _ctx);
    }
    setState(3026);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 234, _ctx)) {
    case 1: {
      setState(2994);
      match(MySQLParser::FROM_SYMBOL);
      setState(3018);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 232, _ctx)) {
      case 1: {
        setState(2995);
        tableAliasRefList();
        setState(2996);
        match(MySQLParser::USING_SYMBOL);
        setState(2997);
        tableReferenceList();
        setState(2999);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::WHERE_SYMBOL) {
          setState(2998);
          whereClause();
        }
        break;
      }

      case 2: {
        setState(3001);
        tableRef();
        setState(3004);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 227, _ctx)) {
        case 1: {
          setState(3002);

          if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
          setState(3003);
          tableAlias();
          break;
        }

        default:
          break;
        }
        setState(3007);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::PARTITION_SYMBOL) {
          setState(3006);
          partitionDelete();
        }
        setState(3010);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::WHERE_SYMBOL) {
          setState(3009);
          whereClause();
        }
        setState(3013);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ORDER_SYMBOL) {
          setState(3012);
          orderClause();
        }
        setState(3016);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::LIMIT_SYMBOL) {
          setState(3015);
          simpleLimitClause();
        }
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3020);
      tableAliasRefList();
      setState(3021);
      match(MySQLParser::FROM_SYMBOL);
      setState(3022);
      tableReferenceList();
      setState(3024);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::WHERE_SYMBOL) {
        setState(3023);
        whereClause();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- PartitionDeleteContext ------------------------------------------------------------------

MySQLParser::PartitionDeleteContext::PartitionDeleteContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::PartitionDeleteContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}


size_t MySQLParser::PartitionDeleteContext::getRuleIndex() const {
  return MySQLParser::RulePartitionDelete;
}

void MySQLParser::PartitionDeleteContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterPartitionDelete(this);
}

void MySQLParser::PartitionDeleteContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitPartitionDelete(this);
}


std::any MySQLParser::PartitionDeleteContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitPartitionDelete(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::PartitionDeleteContext* MySQLParser::partitionDelete() {
  PartitionDeleteContext *_localctx = _tracker.createInstance<PartitionDeleteContext>(_ctx, getState());
  enterRule(_localctx, 236, MySQLParser::RulePartitionDelete);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3028);
    match(MySQLParser::PARTITION_SYMBOL);
    setState(3029);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3030);
    identifierList();
    setState(3031);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DeleteStatementOptionContext ------------------------------------------------------------------

MySQLParser::DeleteStatementOptionContext::DeleteStatementOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::QUICK_SYMBOL() {
  return getToken(MySQLParser::QUICK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::DeleteStatementOptionContext::getRuleIndex() const {
  return MySQLParser::RuleDeleteStatementOption;
}

void MySQLParser::DeleteStatementOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDeleteStatementOption(this);
}

void MySQLParser::DeleteStatementOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDeleteStatementOption(this);
}


std::any MySQLParser::DeleteStatementOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDeleteStatementOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DeleteStatementOptionContext* MySQLParser::deleteStatementOption() {
  DeleteStatementOptionContext *_localctx = _tracker.createInstance<DeleteStatementOptionContext>(_ctx, getState());
  enterRule(_localctx, 238, MySQLParser::RuleDeleteStatementOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3033);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::IGNORE_SYMBOL

    || _la == MySQLParser::LOW_PRIORITY_SYMBOL || _la == MySQLParser::QUICK_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DoStatementContext ------------------------------------------------------------------

MySQLParser::DoStatementContext::DoStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DoStatementContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::ExprListContext* MySQLParser::DoStatementContext::exprList() {
  return getRuleContext<MySQLParser::ExprListContext>(0);
}

MySQLParser::SelectItemListContext* MySQLParser::DoStatementContext::selectItemList() {
  return getRuleContext<MySQLParser::SelectItemListContext>(0);
}


size_t MySQLParser::DoStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDoStatement;
}

void MySQLParser::DoStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDoStatement(this);
}

void MySQLParser::DoStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDoStatement(this);
}


std::any MySQLParser::DoStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDoStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DoStatementContext* MySQLParser::doStatement() {
  DoStatementContext *_localctx = _tracker.createInstance<DoStatementContext>(_ctx, getState());
  enterRule(_localctx, 240, MySQLParser::RuleDoStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3035);
    match(MySQLParser::DO_SYMBOL);
    setState(3040);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 235, _ctx)) {
    case 1: {
      setState(3036);

      if (!(serverVersion < 50709)) throw FailedPredicateException(this, "serverVersion < 50709");
      setState(3037);
      exprList();
      break;
    }

    case 2: {
      setState(3038);

      if (!(serverVersion >= 50709)) throw FailedPredicateException(this, "serverVersion >= 50709");
      setState(3039);
      selectItemList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HandlerStatementContext ------------------------------------------------------------------

MySQLParser::HandlerStatementContext::HandlerStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::HANDLER_SYMBOL() {
  return getToken(MySQLParser::HANDLER_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::HandlerStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::OPEN_SYMBOL() {
  return getToken(MySQLParser::OPEN_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::HandlerStatementContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::CLOSE_SYMBOL() {
  return getToken(MySQLParser::CLOSE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::READ_SYMBOL() {
  return getToken(MySQLParser::READ_SYMBOL, 0);
}

MySQLParser::HandlerReadOrScanContext* MySQLParser::HandlerStatementContext::handlerReadOrScan() {
  return getRuleContext<MySQLParser::HandlerReadOrScanContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::HandlerStatementContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::HandlerStatementContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::LimitClauseContext* MySQLParser::HandlerStatementContext::limitClause() {
  return getRuleContext<MySQLParser::LimitClauseContext>(0);
}


size_t MySQLParser::HandlerStatementContext::getRuleIndex() const {
  return MySQLParser::RuleHandlerStatement;
}

void MySQLParser::HandlerStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHandlerStatement(this);
}

void MySQLParser::HandlerStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHandlerStatement(this);
}


std::any MySQLParser::HandlerStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHandlerStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HandlerStatementContext* MySQLParser::handlerStatement() {
  HandlerStatementContext *_localctx = _tracker.createInstance<HandlerStatementContext>(_ctx, getState());
  enterRule(_localctx, 242, MySQLParser::RuleHandlerStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3042);
    match(MySQLParser::HANDLER_SYMBOL);
    setState(3060);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 240, _ctx)) {
    case 1: {
      setState(3043);
      tableRef();
      setState(3044);
      match(MySQLParser::OPEN_SYMBOL);
      setState(3046);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 236, _ctx)) {
      case 1: {
        setState(3045);
        tableAlias();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3048);
      identifier();
      setState(3058);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::CLOSE_SYMBOL: {
          setState(3049);
          match(MySQLParser::CLOSE_SYMBOL);
          break;
        }

        case MySQLParser::READ_SYMBOL: {
          setState(3050);
          match(MySQLParser::READ_SYMBOL);
          setState(3051);
          handlerReadOrScan();
          setState(3053);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::WHERE_SYMBOL) {
            setState(3052);
            whereClause();
          }
          setState(3056);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::LIMIT_SYMBOL) {
            setState(3055);
            limitClause();
          }
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HandlerReadOrScanContext ------------------------------------------------------------------

MySQLParser::HandlerReadOrScanContext::HandlerReadOrScanContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::FIRST_SYMBOL() {
  return getToken(MySQLParser::FIRST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::NEXT_SYMBOL() {
  return getToken(MySQLParser::NEXT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::HandlerReadOrScanContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::ValuesContext* MySQLParser::HandlerReadOrScanContext::values() {
  return getRuleContext<MySQLParser::ValuesContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::PREV_SYMBOL() {
  return getToken(MySQLParser::PREV_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LAST_SYMBOL() {
  return getToken(MySQLParser::LAST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LESS_THAN_OPERATOR() {
  return getToken(MySQLParser::LESS_THAN_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::GREATER_THAN_OPERATOR() {
  return getToken(MySQLParser::GREATER_THAN_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LESS_OR_EQUAL_OPERATOR() {
  return getToken(MySQLParser::LESS_OR_EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::GREATER_OR_EQUAL_OPERATOR() {
  return getToken(MySQLParser::GREATER_OR_EQUAL_OPERATOR, 0);
}


size_t MySQLParser::HandlerReadOrScanContext::getRuleIndex() const {
  return MySQLParser::RuleHandlerReadOrScan;
}

void MySQLParser::HandlerReadOrScanContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHandlerReadOrScan(this);
}

void MySQLParser::HandlerReadOrScanContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHandlerReadOrScan(this);
}


std::any MySQLParser::HandlerReadOrScanContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHandlerReadOrScan(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HandlerReadOrScanContext* MySQLParser::handlerReadOrScan() {
  HandlerReadOrScanContext *_localctx = _tracker.createInstance<HandlerReadOrScanContext>(_ctx, getState());
  enterRule(_localctx, 244, MySQLParser::RuleHandlerReadOrScan);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3072);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 242, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3062);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::FIRST_SYMBOL || _la == MySQLParser::NEXT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3063);
      identifier();
      setState(3070);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::FIRST_SYMBOL:
        case MySQLParser::LAST_SYMBOL:
        case MySQLParser::NEXT_SYMBOL:
        case MySQLParser::PREV_SYMBOL: {
          setState(3064);
          _la = _input->LA(1);
          if (!(_la == MySQLParser::FIRST_SYMBOL || _la == MySQLParser::LAST_SYMBOL || _la == MySQLParser::NEXT_SYMBOL

          || _la == MySQLParser::PREV_SYMBOL)) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          break;
        }

        case MySQLParser::EQUAL_OPERATOR:
        case MySQLParser::GREATER_OR_EQUAL_OPERATOR:
        case MySQLParser::GREATER_THAN_OPERATOR:
        case MySQLParser::LESS_OR_EQUAL_OPERATOR:
        case MySQLParser::LESS_THAN_OPERATOR: {
          setState(3065);
          _la = _input->LA(1);
          if (!((((_la & ~ 0x3fULL) == 0) &&
            ((1ULL << _la) & ((1ULL << MySQLParser::EQUAL_OPERATOR)
            | (1ULL << MySQLParser::GREATER_OR_EQUAL_OPERATOR)
            | (1ULL << MySQLParser::GREATER_THAN_OPERATOR)
            | (1ULL << MySQLParser::LESS_OR_EQUAL_OPERATOR)
            | (1ULL << MySQLParser::LESS_THAN_OPERATOR))) != 0))) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          setState(3066);
          match(MySQLParser::OPEN_PAR_SYMBOL);
          setState(3067);
          values();
          setState(3068);
          match(MySQLParser::CLOSE_PAR_SYMBOL);
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertStatementContext ------------------------------------------------------------------

MySQLParser::InsertStatementContext::InsertStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertStatementContext::INSERT_SYMBOL() {
  return getToken(MySQLParser::INSERT_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::InsertStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::InsertStatementContext::insertFromConstructor() {
  return getRuleContext<MySQLParser::InsertFromConstructorContext>(0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::InsertStatementContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::InsertStatementContext::insertQueryExpression() {
  return getRuleContext<MySQLParser::InsertQueryExpressionContext>(0);
}

MySQLParser::InsertLockOptionContext* MySQLParser::InsertStatementContext::insertLockOption() {
  return getRuleContext<MySQLParser::InsertLockOptionContext>(0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::InsertStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

MySQLParser::InsertUpdateListContext* MySQLParser::InsertStatementContext::insertUpdateList() {
  return getRuleContext<MySQLParser::InsertUpdateListContext>(0);
}

MySQLParser::ValuesReferenceContext* MySQLParser::InsertStatementContext::valuesReference() {
  return getRuleContext<MySQLParser::ValuesReferenceContext>(0);
}


size_t MySQLParser::InsertStatementContext::getRuleIndex() const {
  return MySQLParser::RuleInsertStatement;
}

void MySQLParser::InsertStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertStatement(this);
}

void MySQLParser::InsertStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertStatement(this);
}


std::any MySQLParser::InsertStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertStatementContext* MySQLParser::insertStatement() {
  InsertStatementContext *_localctx = _tracker.createInstance<InsertStatementContext>(_ctx, getState());
  enterRule(_localctx, 246, MySQLParser::RuleInsertStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3074);
    match(MySQLParser::INSERT_SYMBOL);
    setState(3076);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 243, _ctx)) {
    case 1: {
      setState(3075);
      insertLockOption();
      break;
    }

    default:
      break;
    }
    setState(3079);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 244, _ctx)) {
    case 1: {
      setState(3078);
      match(MySQLParser::IGNORE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3082);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 245, _ctx)) {
    case 1: {
      setState(3081);
      match(MySQLParser::INTO_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3084);
    tableRef();
    setState(3086);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 246, _ctx)) {
    case 1: {
      setState(3085);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(3098);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 249, _ctx)) {
    case 1: {
      setState(3088);
      insertFromConstructor();
      setState(3090);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 247, _ctx)) {
      case 1: {
        setState(3089);
        valuesReference();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3092);
      match(MySQLParser::SET_SYMBOL);
      setState(3093);
      updateList();
      setState(3095);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 248, _ctx)) {
      case 1: {
        setState(3094);
        valuesReference();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 3: {
      setState(3097);
      insertQueryExpression();
      break;
    }

    default:
      break;
    }
    setState(3101);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(3100);
      insertUpdateList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertLockOptionContext ------------------------------------------------------------------

MySQLParser::InsertLockOptionContext::InsertLockOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::DELAYED_SYMBOL() {
  return getToken(MySQLParser::DELAYED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::HIGH_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::HIGH_PRIORITY_SYMBOL, 0);
}


size_t MySQLParser::InsertLockOptionContext::getRuleIndex() const {
  return MySQLParser::RuleInsertLockOption;
}

void MySQLParser::InsertLockOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertLockOption(this);
}

void MySQLParser::InsertLockOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertLockOption(this);
}


std::any MySQLParser::InsertLockOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertLockOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertLockOptionContext* MySQLParser::insertLockOption() {
  InsertLockOptionContext *_localctx = _tracker.createInstance<InsertLockOptionContext>(_ctx, getState());
  enterRule(_localctx, 248, MySQLParser::RuleInsertLockOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3103);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DELAYED_SYMBOL || _la == MySQLParser::HIGH_PRIORITY_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertFromConstructorContext ------------------------------------------------------------------

MySQLParser::InsertFromConstructorContext::InsertFromConstructorContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::InsertValuesContext* MySQLParser::InsertFromConstructorContext::insertValues() {
  return getRuleContext<MySQLParser::InsertValuesContext>(0);
}

tree::TerminalNode* MySQLParser::InsertFromConstructorContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertFromConstructorContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldsContext* MySQLParser::InsertFromConstructorContext::fields() {
  return getRuleContext<MySQLParser::FieldsContext>(0);
}


size_t MySQLParser::InsertFromConstructorContext::getRuleIndex() const {
  return MySQLParser::RuleInsertFromConstructor;
}

void MySQLParser::InsertFromConstructorContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertFromConstructor(this);
}

void MySQLParser::InsertFromConstructorContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertFromConstructor(this);
}


std::any MySQLParser::InsertFromConstructorContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertFromConstructor(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::insertFromConstructor() {
  InsertFromConstructorContext *_localctx = _tracker.createInstance<InsertFromConstructorContext>(_ctx, getState());
  enterRule(_localctx, 250, MySQLParser::RuleInsertFromConstructor);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3110);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3105);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(3107);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 251, _ctx)) {
      case 1: {
        setState(3106);
        fields();
        break;
      }

      default:
        break;
      }
      setState(3109);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
    }
    setState(3112);
    insertValues();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FieldsContext ------------------------------------------------------------------

MySQLParser::FieldsContext::FieldsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::InsertIdentifierContext *> MySQLParser::FieldsContext::insertIdentifier() {
  return getRuleContexts<MySQLParser::InsertIdentifierContext>();
}

MySQLParser::InsertIdentifierContext* MySQLParser::FieldsContext::insertIdentifier(size_t i) {
  return getRuleContext<MySQLParser::InsertIdentifierContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::FieldsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::FieldsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::FieldsContext::getRuleIndex() const {
  return MySQLParser::RuleFields;
}

void MySQLParser::FieldsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFields(this);
}

void MySQLParser::FieldsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFields(this);
}


std::any MySQLParser::FieldsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFields(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FieldsContext* MySQLParser::fields() {
  FieldsContext *_localctx = _tracker.createInstance<FieldsContext>(_ctx, getState());
  enterRule(_localctx, 252, MySQLParser::RuleFields);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3114);
    insertIdentifier();
    setState(3119);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3115);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3116);
      insertIdentifier();
      setState(3121);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertValuesContext ------------------------------------------------------------------

MySQLParser::InsertValuesContext::InsertValuesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::ValueListContext* MySQLParser::InsertValuesContext::valueList() {
  return getRuleContext<MySQLParser::ValueListContext>(0);
}

tree::TerminalNode* MySQLParser::InsertValuesContext::VALUES_SYMBOL() {
  return getToken(MySQLParser::VALUES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertValuesContext::VALUE_SYMBOL() {
  return getToken(MySQLParser::VALUE_SYMBOL, 0);
}


size_t MySQLParser::InsertValuesContext::getRuleIndex() const {
  return MySQLParser::RuleInsertValues;
}

void MySQLParser::InsertValuesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertValues(this);
}

void MySQLParser::InsertValuesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertValues(this);
}


std::any MySQLParser::InsertValuesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertValues(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertValuesContext* MySQLParser::insertValues() {
  InsertValuesContext *_localctx = _tracker.createInstance<InsertValuesContext>(_ctx, getState());
  enterRule(_localctx, 254, MySQLParser::RuleInsertValues);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3122);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::VALUES_SYMBOL

    || _la == MySQLParser::VALUE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(3123);
    valueList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertQueryExpressionContext ------------------------------------------------------------------

MySQLParser::InsertQueryExpressionContext::InsertQueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::InsertQueryExpressionContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::InsertQueryExpressionContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::InsertQueryExpressionContext::queryExpressionWithOptLockingClauses() {
  return getRuleContext<MySQLParser::QueryExpressionWithOptLockingClausesContext>(0);
}

tree::TerminalNode* MySQLParser::InsertQueryExpressionContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertQueryExpressionContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldsContext* MySQLParser::InsertQueryExpressionContext::fields() {
  return getRuleContext<MySQLParser::FieldsContext>(0);
}


size_t MySQLParser::InsertQueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleInsertQueryExpression;
}

void MySQLParser::InsertQueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertQueryExpression(this);
}

void MySQLParser::InsertQueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertQueryExpression(this);
}


std::any MySQLParser::InsertQueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::insertQueryExpression() {
  InsertQueryExpressionContext *_localctx = _tracker.createInstance<InsertQueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 256, MySQLParser::RuleInsertQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3135);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 256, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3125);
      queryExpression();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3126);
      queryExpressionParens();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3132);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 255, _ctx)) {
      case 1: {
        setState(3127);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(3129);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 254, _ctx)) {
        case 1: {
          setState(3128);
          fields();
          break;
        }

        default:
          break;
        }
        setState(3131);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(3134);
      queryExpressionWithOptLockingClauses();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValueListContext ------------------------------------------------------------------

MySQLParser::ValueListContext::ValueListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::OPEN_PAR_SYMBOL() {
  return getTokens(MySQLParser::OPEN_PAR_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::OPEN_PAR_SYMBOL(size_t i) {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::CLOSE_PAR_SYMBOL() {
  return getTokens(MySQLParser::CLOSE_PAR_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::CLOSE_PAR_SYMBOL(size_t i) {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, i);
}

std::vector<MySQLParser::ValuesContext *> MySQLParser::ValueListContext::values() {
  return getRuleContexts<MySQLParser::ValuesContext>();
}

MySQLParser::ValuesContext* MySQLParser::ValueListContext::values(size_t i) {
  return getRuleContext<MySQLParser::ValuesContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ValueListContext::getRuleIndex() const {
  return MySQLParser::RuleValueList;
}

void MySQLParser::ValueListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValueList(this);
}

void MySQLParser::ValueListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValueList(this);
}


std::any MySQLParser::ValueListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValueList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValueListContext* MySQLParser::valueList() {
  ValueListContext *_localctx = _tracker.createInstance<ValueListContext>(_ctx, getState());
  enterRule(_localctx, 258, MySQLParser::RuleValueList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3137);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3139);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 257, _ctx)) {
    case 1: {
      setState(3138);
      values();
      break;
    }

    default:
      break;
    }
    setState(3141);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(3150);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 259, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3142);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3143);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(3145);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 258, _ctx)) {
        case 1: {
          setState(3144);
          values();
          break;
        }

        default:
          break;
        }
        setState(3147);
        match(MySQLParser::CLOSE_PAR_SYMBOL); 
      }
      setState(3152);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 259, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValuesContext ------------------------------------------------------------------

MySQLParser::ValuesContext::ValuesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::ExprContext *> MySQLParser::ValuesContext::expr() {
  return getRuleContexts<MySQLParser::ExprContext>();
}

MySQLParser::ExprContext* MySQLParser::ValuesContext::expr(size_t i) {
  return getRuleContext<MySQLParser::ExprContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValuesContext::DEFAULT_SYMBOL() {
  return getTokens(MySQLParser::DEFAULT_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValuesContext::DEFAULT_SYMBOL(size_t i) {
  return getToken(MySQLParser::DEFAULT_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValuesContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValuesContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ValuesContext::getRuleIndex() const {
  return MySQLParser::RuleValues;
}

void MySQLParser::ValuesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValues(this);
}

void MySQLParser::ValuesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValues(this);
}


std::any MySQLParser::ValuesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValues(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValuesContext* MySQLParser::values() {
  ValuesContext *_localctx = _tracker.createInstance<ValuesContext>(_ctx, getState());
  enterRule(_localctx, 260, MySQLParser::RuleValues);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3155);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 260, _ctx)) {
    case 1: {
      setState(3153);
      expr(0);
      break;
    }

    case 2: {
      setState(3154);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3164);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3157);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3160);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 261, _ctx)) {
      case 1: {
        setState(3158);
        expr(0);
        break;
      }

      case 2: {
        setState(3159);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(3166);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValuesReferenceContext ------------------------------------------------------------------

MySQLParser::ValuesReferenceContext::ValuesReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ValuesReferenceContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::ValuesReferenceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::ValuesReferenceContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::ValuesReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleValuesReference;
}

void MySQLParser::ValuesReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValuesReference(this);
}

void MySQLParser::ValuesReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValuesReference(this);
}


std::any MySQLParser::ValuesReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValuesReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValuesReferenceContext* MySQLParser::valuesReference() {
  ValuesReferenceContext *_localctx = _tracker.createInstance<ValuesReferenceContext>(_ctx, getState());
  enterRule(_localctx, 262, MySQLParser::RuleValuesReference);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3167);

    if (!( serverVersion >= 80018)) throw FailedPredicateException(this, " serverVersion >= 80018");
    setState(3168);
    match(MySQLParser::AS_SYMBOL);
    setState(3169);
    identifier();
    setState(3171);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3170);
      columnInternalRefList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertUpdateListContext ------------------------------------------------------------------

MySQLParser::InsertUpdateListContext::InsertUpdateListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::DUPLICATE_SYMBOL() {
  return getToken(MySQLParser::DUPLICATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::InsertUpdateListContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}


size_t MySQLParser::InsertUpdateListContext::getRuleIndex() const {
  return MySQLParser::RuleInsertUpdateList;
}

void MySQLParser::InsertUpdateListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertUpdateList(this);
}

void MySQLParser::InsertUpdateListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertUpdateList(this);
}


std::any MySQLParser::InsertUpdateListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertUpdateList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertUpdateListContext* MySQLParser::insertUpdateList() {
  InsertUpdateListContext *_localctx = _tracker.createInstance<InsertUpdateListContext>(_ctx, getState());
  enterRule(_localctx, 264, MySQLParser::RuleInsertUpdateList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3173);
    match(MySQLParser::ON_SYMBOL);
    setState(3174);
    match(MySQLParser::DUPLICATE_SYMBOL);
    setState(3175);
    match(MySQLParser::KEY_SYMBOL);
    setState(3176);
    match(MySQLParser::UPDATE_SYMBOL);
    setState(3177);
    updateList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadStatementContext ------------------------------------------------------------------

MySQLParser::LoadStatementContext::LoadStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOAD_SYMBOL() {
  return getToken(MySQLParser::LOAD_SYMBOL, 0);
}

MySQLParser::DataOrXmlContext* MySQLParser::LoadStatementContext::dataOrXml() {
  return getRuleContext<MySQLParser::DataOrXmlContext>(0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::LoadStatementContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::LoadStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::LoadDataFileTailContext* MySQLParser::LoadStatementContext::loadDataFileTail() {
  return getRuleContext<MySQLParser::LoadDataFileTailContext>(0);
}

MySQLParser::LoadDataLockContext* MySQLParser::LoadStatementContext::loadDataLock() {
  return getRuleContext<MySQLParser::LoadDataLockContext>(0);
}

MySQLParser::LoadFromContext* MySQLParser::LoadStatementContext::loadFrom() {
  return getRuleContext<MySQLParser::LoadFromContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOCAL_SYMBOL() {
  return getToken(MySQLParser::LOCAL_SYMBOL, 0);
}

MySQLParser::LoadSourceTypeContext* MySQLParser::LoadStatementContext::loadSourceType() {
  return getRuleContext<MySQLParser::LoadSourceTypeContext>(0);
}

MySQLParser::SourceCountContext* MySQLParser::LoadStatementContext::sourceCount() {
  return getRuleContext<MySQLParser::SourceCountContext>(0);
}

MySQLParser::SourceOrderContext* MySQLParser::LoadStatementContext::sourceOrder() {
  return getRuleContext<MySQLParser::SourceOrderContext>(0);
}

MySQLParser::UsePartitionContext* MySQLParser::LoadStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

MySQLParser::CharsetClauseContext* MySQLParser::LoadStatementContext::charsetClause() {
  return getRuleContext<MySQLParser::CharsetClauseContext>(0);
}

MySQLParser::XmlRowsIdentifiedByContext* MySQLParser::LoadStatementContext::xmlRowsIdentifiedBy() {
  return getRuleContext<MySQLParser::XmlRowsIdentifiedByContext>(0);
}

MySQLParser::FieldsClauseContext* MySQLParser::LoadStatementContext::fieldsClause() {
  return getRuleContext<MySQLParser::FieldsClauseContext>(0);
}

MySQLParser::LinesClauseContext* MySQLParser::LoadStatementContext::linesClause() {
  return getRuleContext<MySQLParser::LinesClauseContext>(0);
}

MySQLParser::LoadParallelContext* MySQLParser::LoadStatementContext::loadParallel() {
  return getRuleContext<MySQLParser::LoadParallelContext>(0);
}

MySQLParser::LoadMemoryContext* MySQLParser::LoadStatementContext::loadMemory() {
  return getRuleContext<MySQLParser::LoadMemoryContext>(0);
}

MySQLParser::LoadAlgorithmContext* MySQLParser::LoadStatementContext::loadAlgorithm() {
  return getRuleContext<MySQLParser::LoadAlgorithmContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::LoadStatementContext::getRuleIndex() const {
  return MySQLParser::RuleLoadStatement;
}

void MySQLParser::LoadStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadStatement(this);
}

void MySQLParser::LoadStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadStatement(this);
}


std::any MySQLParser::LoadStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadStatementContext* MySQLParser::loadStatement() {
  LoadStatementContext *_localctx = _tracker.createInstance<LoadStatementContext>(_ctx, getState());
  enterRule(_localctx, 266, MySQLParser::RuleLoadStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3179);
    match(MySQLParser::LOAD_SYMBOL);
    setState(3180);
    dataOrXml();
    setState(3182);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 264, _ctx)) {
    case 1: {
      setState(3181);
      loadDataLock();
      break;
    }

    default:
      break;
    }
    setState(3185);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 265, _ctx)) {
    case 1: {
      setState(3184);
      loadFrom();
      break;
    }

    default:
      break;
    }
    setState(3188);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 266, _ctx)) {
    case 1: {
      setState(3187);
      match(MySQLParser::LOCAL_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3191);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 267, _ctx)) {
    case 1: {
      setState(3190);
      loadSourceType();
      break;
    }

    default:
      break;
    }
    setState(3193);
    textStringLiteral();
    setState(3195);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 268, _ctx)) {
    case 1: {
      setState(3194);
      sourceCount();
      break;
    }

    default:
      break;
    }
    setState(3198);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 269, _ctx)) {
    case 1: {
      setState(3197);
      sourceOrder();
      break;
    }

    default:
      break;
    }
    setState(3201);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL) {
      setState(3200);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(3203);
    match(MySQLParser::INTO_SYMBOL);
    setState(3204);
    match(MySQLParser::TABLE_SYMBOL);
    setState(3205);
    tableRef();
    setState(3207);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 271, _ctx)) {
    case 1: {
      setState(3206);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(3210);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 272, _ctx)) {
    case 1: {
      setState(3209);
      charsetClause();
      break;
    }

    default:
      break;
    }
    setState(3213);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 273, _ctx)) {
    case 1: {
      setState(3212);
      xmlRowsIdentifiedBy();
      break;
    }

    default:
      break;
    }
    setState(3216);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 274, _ctx)) {
    case 1: {
      setState(3215);
      fieldsClause();
      break;
    }

    default:
      break;
    }
    setState(3219);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 275, _ctx)) {
    case 1: {
      setState(3218);
      linesClause();
      break;
    }

    default:
      break;
    }
    setState(3221);
    loadDataFileTail();
    setState(3223);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 276, _ctx)) {
    case 1: {
      setState(3222);
      loadParallel();
      break;
    }

    default:
      break;
    }
    setState(3226);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 277, _ctx)) {
    case 1: {
      setState(3225);
      loadMemory();
      break;
    }

    default:
      break;
    }
    setState(3229);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 278, _ctx)) {
    case 1: {
      setState(3228);
      loadAlgorithm();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DataOrXmlContext ------------------------------------------------------------------

MySQLParser::DataOrXmlContext::DataOrXmlContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DataOrXmlContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DataOrXmlContext::XML_SYMBOL() {
  return getToken(MySQLParser::XML_SYMBOL, 0);
}


size_t MySQLParser::DataOrXmlContext::getRuleIndex() const {
  return MySQLParser::RuleDataOrXml;
}

void MySQLParser::DataOrXmlContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDataOrXml(this);
}

void MySQLParser::DataOrXmlContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDataOrXml(this);
}


std::any MySQLParser::DataOrXmlContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDataOrXml(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DataOrXmlContext* MySQLParser::dataOrXml() {
  DataOrXmlContext *_localctx = _tracker.createInstance<DataOrXmlContext>(_ctx, getState());
  enterRule(_localctx, 268, MySQLParser::RuleDataOrXml);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3231);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DATA_SYMBOL || _la == MySQLParser::XML_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataLockContext ------------------------------------------------------------------

MySQLParser::LoadDataLockContext::LoadDataLockContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataLockContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataLockContext::CONCURRENT_SYMBOL() {
  return getToken(MySQLParser::CONCURRENT_SYMBOL, 0);
}


size_t MySQLParser::LoadDataLockContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataLock;
}

void MySQLParser::LoadDataLockContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataLock(this);
}

void MySQLParser::LoadDataLockContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataLock(this);
}


std::any MySQLParser::LoadDataLockContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataLock(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataLockContext* MySQLParser::loadDataLock() {
  LoadDataLockContext *_localctx = _tracker.createInstance<LoadDataLockContext>(_ctx, getState());
  enterRule(_localctx, 270, MySQLParser::RuleLoadDataLock);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3233);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::CONCURRENT_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadFromContext ------------------------------------------------------------------

MySQLParser::LoadFromContext::LoadFromContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadFromContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}


size_t MySQLParser::LoadFromContext::getRuleIndex() const {
  return MySQLParser::RuleLoadFrom;
}

void MySQLParser::LoadFromContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadFrom(this);
}

void MySQLParser::LoadFromContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadFrom(this);
}


std::any MySQLParser::LoadFromContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadFrom(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadFromContext* MySQLParser::loadFrom() {
  LoadFromContext *_localctx = _tracker.createInstance<LoadFromContext>(_ctx, getState());
  enterRule(_localctx, 272, MySQLParser::RuleLoadFrom);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3235);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3236);
    match(MySQLParser::FROM_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadSourceTypeContext ------------------------------------------------------------------

MySQLParser::LoadSourceTypeContext::LoadSourceTypeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadSourceTypeContext::INFILE_SYMBOL() {
  return getToken(MySQLParser::INFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadSourceTypeContext::URL_SYMBOL() {
  return getToken(MySQLParser::URL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadSourceTypeContext::S3_SYMBOL() {
  return getToken(MySQLParser::S3_SYMBOL, 0);
}


size_t MySQLParser::LoadSourceTypeContext::getRuleIndex() const {
  return MySQLParser::RuleLoadSourceType;
}

void MySQLParser::LoadSourceTypeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadSourceType(this);
}

void MySQLParser::LoadSourceTypeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadSourceType(this);
}


std::any MySQLParser::LoadSourceTypeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadSourceType(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadSourceTypeContext* MySQLParser::loadSourceType() {
  LoadSourceTypeContext *_localctx = _tracker.createInstance<LoadSourceTypeContext>(_ctx, getState());
  enterRule(_localctx, 274, MySQLParser::RuleLoadSourceType);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3241);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 279, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3238);
      match(MySQLParser::INFILE_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3239);

      if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
      setState(3240);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::URL_SYMBOL

      || _la == MySQLParser::S3_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SourceCountContext ------------------------------------------------------------------

MySQLParser::SourceCountContext::SourceCountContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SourceCountContext::COUNT_SYMBOL() {
  return getToken(MySQLParser::COUNT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SourceCountContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}

MySQLParser::PureIdentifierContext* MySQLParser::SourceCountContext::pureIdentifier() {
  return getRuleContext<MySQLParser::PureIdentifierContext>(0);
}


size_t MySQLParser::SourceCountContext::getRuleIndex() const {
  return MySQLParser::RuleSourceCount;
}

void MySQLParser::SourceCountContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSourceCount(this);
}

void MySQLParser::SourceCountContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSourceCount(this);
}


std::any MySQLParser::SourceCountContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSourceCount(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SourceCountContext* MySQLParser::sourceCount() {
  SourceCountContext *_localctx = _tracker.createInstance<SourceCountContext>(_ctx, getState());
  enterRule(_localctx, 276, MySQLParser::RuleSourceCount);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3243);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3249);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 280, _ctx)) {
    case 1: {
      setState(3244);
      match(MySQLParser::COUNT_SYMBOL);
      setState(3245);
      match(MySQLParser::INT_NUMBER);
      break;
    }

    case 2: {
      setState(3246);
      pureIdentifier();
      setState(3247);
      match(MySQLParser::INT_NUMBER);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SourceOrderContext ------------------------------------------------------------------

MySQLParser::SourceOrderContext::SourceOrderContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SourceOrderContext::IN_SYMBOL() {
  return getToken(MySQLParser::IN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SourceOrderContext::PRIMARY_SYMBOL() {
  return getToken(MySQLParser::PRIMARY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SourceOrderContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SourceOrderContext::ORDER_SYMBOL() {
  return getToken(MySQLParser::ORDER_SYMBOL, 0);
}


size_t MySQLParser::SourceOrderContext::getRuleIndex() const {
  return MySQLParser::RuleSourceOrder;
}

void MySQLParser::SourceOrderContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSourceOrder(this);
}

void MySQLParser::SourceOrderContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSourceOrder(this);
}


std::any MySQLParser::SourceOrderContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSourceOrder(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SourceOrderContext* MySQLParser::sourceOrder() {
  SourceOrderContext *_localctx = _tracker.createInstance<SourceOrderContext>(_ctx, getState());
  enterRule(_localctx, 278, MySQLParser::RuleSourceOrder);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3251);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3252);
    match(MySQLParser::IN_SYMBOL);
    setState(3253);
    match(MySQLParser::PRIMARY_SYMBOL);
    setState(3254);
    match(MySQLParser::KEY_SYMBOL);
    setState(3255);
    match(MySQLParser::ORDER_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- XmlRowsIdentifiedByContext ------------------------------------------------------------------

MySQLParser::XmlRowsIdentifiedByContext::XmlRowsIdentifiedByContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::IDENTIFIED_SYMBOL() {
  return getToken(MySQLParser::IDENTIFIED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::TextStringContext* MySQLParser::XmlRowsIdentifiedByContext::textString() {
  return getRuleContext<MySQLParser::TextStringContext>(0);
}


size_t MySQLParser::XmlRowsIdentifiedByContext::getRuleIndex() const {
  return MySQLParser::RuleXmlRowsIdentifiedBy;
}

void MySQLParser::XmlRowsIdentifiedByContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterXmlRowsIdentifiedBy(this);
}

void MySQLParser::XmlRowsIdentifiedByContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitXmlRowsIdentifiedBy(this);
}


std::any MySQLParser::XmlRowsIdentifiedByContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitXmlRowsIdentifiedBy(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::XmlRowsIdentifiedByContext* MySQLParser::xmlRowsIdentifiedBy() {
  XmlRowsIdentifiedByContext *_localctx = _tracker.createInstance<XmlRowsIdentifiedByContext>(_ctx, getState());
  enterRule(_localctx, 280, MySQLParser::RuleXmlRowsIdentifiedBy);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3257);
    match(MySQLParser::ROWS_SYMBOL);
    setState(3258);
    match(MySQLParser::IDENTIFIED_SYMBOL);
    setState(3259);
    match(MySQLParser::BY_SYMBOL);
    setState(3260);
    textString();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataFileTailContext ------------------------------------------------------------------

MySQLParser::LoadDataFileTailContext::LoadDataFileTailContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}

MySQLParser::LoadDataFileTargetListContext* MySQLParser::LoadDataFileTailContext::loadDataFileTargetList() {
  return getRuleContext<MySQLParser::LoadDataFileTargetListContext>(0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::LoadDataFileTailContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::LINES_SYMBOL() {
  return getToken(MySQLParser::LINES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}


size_t MySQLParser::LoadDataFileTailContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataFileTail;
}

void MySQLParser::LoadDataFileTailContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataFileTail(this);
}

void MySQLParser::LoadDataFileTailContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataFileTail(this);
}


std::any MySQLParser::LoadDataFileTailContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataFileTail(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataFileTailContext* MySQLParser::loadDataFileTail() {
  LoadDataFileTailContext *_localctx = _tracker.createInstance<LoadDataFileTailContext>(_ctx, getState());
  enterRule(_localctx, 282, MySQLParser::RuleLoadDataFileTail);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3265);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 281, _ctx)) {
    case 1: {
      setState(3262);
      match(MySQLParser::IGNORE_SYMBOL);
      setState(3263);
      match(MySQLParser::INT_NUMBER);
      setState(3264);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::LINES_SYMBOL || _la == MySQLParser::ROWS_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(3268);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 282, _ctx)) {
    case 1: {
      setState(3267);
      loadDataFileTargetList();
      break;
    }

    default:
      break;
    }
    setState(3272);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 283, _ctx)) {
    case 1: {
      setState(3270);
      match(MySQLParser::SET_SYMBOL);
      setState(3271);
      updateList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataFileTargetListContext ------------------------------------------------------------------

MySQLParser::LoadDataFileTargetListContext::LoadDataFileTargetListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataFileTargetListContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTargetListContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldOrVariableListContext* MySQLParser::LoadDataFileTargetListContext::fieldOrVariableList() {
  return getRuleContext<MySQLParser::FieldOrVariableListContext>(0);
}


size_t MySQLParser::LoadDataFileTargetListContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataFileTargetList;
}

void MySQLParser::LoadDataFileTargetListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataFileTargetList(this);
}

void MySQLParser::LoadDataFileTargetListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataFileTargetList(this);
}


std::any MySQLParser::LoadDataFileTargetListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataFileTargetList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataFileTargetListContext* MySQLParser::loadDataFileTargetList() {
  LoadDataFileTargetListContext *_localctx = _tracker.createInstance<LoadDataFileTargetListContext>(_ctx, getState());
  enterRule(_localctx, 284, MySQLParser::RuleLoadDataFileTargetList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3274);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3276);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 284, _ctx)) {
    case 1: {
      setState(3275);
      fieldOrVariableList();
      break;
    }

    default:
      break;
    }
    setState(3278);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FieldOrVariableListContext ------------------------------------------------------------------

MySQLParser::FieldOrVariableListContext::FieldOrVariableListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::ColumnRefContext *> MySQLParser::FieldOrVariableListContext::columnRef() {
  return getRuleContexts<MySQLParser::ColumnRefContext>();
}

MySQLParser::ColumnRefContext* MySQLParser::FieldOrVariableListContext::columnRef(size_t i) {
  return getRuleContext<MySQLParser::ColumnRefContext>(i);
}

std::vector<MySQLParser::UserVariableContext *> MySQLParser::FieldOrVariableListContext::userVariable() {
  return getRuleContexts<MySQLParser::UserVariableContext>();
}

MySQLParser::UserVariableContext* MySQLParser::FieldOrVariableListContext::userVariable(size_t i) {
  return getRuleContext<MySQLParser::UserVariableContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::FieldOrVariableListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::FieldOrVariableListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::FieldOrVariableListContext::getRuleIndex() const {
  return MySQLParser::RuleFieldOrVariableList;
}

void MySQLParser::FieldOrVariableListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFieldOrVariableList(this);
}

void MySQLParser::FieldOrVariableListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFieldOrVariableList(this);
}


std::any MySQLParser::FieldOrVariableListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFieldOrVariableList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FieldOrVariableListContext* MySQLParser::fieldOrVariableList() {
  FieldOrVariableListContext *_localctx = _tracker.createInstance<FieldOrVariableListContext>(_ctx, getState());
  enterRule(_localctx, 286, MySQLParser::RuleFieldOrVariableList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3282);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 285, _ctx)) {
    case 1: {
      setState(3280);
      columnRef();
      break;
    }

    case 2: {
      setState(3281);
      userVariable();
      break;
    }

    default:
      break;
    }
    setState(3291);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3284);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3287);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 286, _ctx)) {
      case 1: {
        setState(3285);
        columnRef();
        break;
      }

      case 2: {
        setState(3286);
        userVariable();
        break;
      }

      default:
        break;
      }
      setState(3293);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadAlgorithmContext ------------------------------------------------------------------

MySQLParser::LoadAlgorithmContext::LoadAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadAlgorithmContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadAlgorithmContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::LoadAlgorithmContext::BULK_SYMBOL() {
  return getToken(MySQLParser::BULK_SYMBOL, 0);
}


size_t MySQLParser::LoadAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleLoadAlgorithm;
}

void MySQLParser::LoadAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadAlgorithm(this);
}

void MySQLParser::LoadAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadAlgorithm(this);
}


std::any MySQLParser::LoadAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadAlgorithmContext* MySQLParser::loadAlgorithm() {
  LoadAlgorithmContext *_localctx = _tracker.createInstance<LoadAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 288, MySQLParser::RuleLoadAlgorithm);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3294);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3295);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(3296);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(3297);
    match(MySQLParser::BULK_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadParallelContext ------------------------------------------------------------------

MySQLParser::LoadParallelContext::LoadParallelContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadParallelContext::PARALLEL_SYMBOL() {
  return getToken(MySQLParser::PARALLEL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadParallelContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::LoadParallelContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}


size_t MySQLParser::LoadParallelContext::getRuleIndex() const {
  return MySQLParser::RuleLoadParallel;
}

void MySQLParser::LoadParallelContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadParallel(this);
}

void MySQLParser::LoadParallelContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadParallel(this);
}


std::any MySQLParser::LoadParallelContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadParallel(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadParallelContext* MySQLParser::loadParallel() {
  LoadParallelContext *_localctx = _tracker.createInstance<LoadParallelContext>(_ctx, getState());
  enterRule(_localctx, 290, MySQLParser::RuleLoadParallel);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3299);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3300);
    match(MySQLParser::PARALLEL_SYMBOL);
    setState(3301);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(3302);
    match(MySQLParser::INT_NUMBER);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadMemoryContext ------------------------------------------------------------------

MySQLParser::LoadMemoryContext::LoadMemoryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadMemoryContext::MEMORY_SYMBOL() {
  return getToken(MySQLParser::MEMORY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadMemoryContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::LoadMemoryContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}


size_t MySQLParser::LoadMemoryContext::getRuleIndex() const {
  return MySQLParser::RuleLoadMemory;
}

void MySQLParser::LoadMemoryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadMemory(this);
}

void MySQLParser::LoadMemoryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadMemory(this);
}


std::any MySQLParser::LoadMemoryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadMemory(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadMemoryContext* MySQLParser::loadMemory() {
  LoadMemoryContext *_localctx = _tracker.createInstance<LoadMemoryContext>(_ctx, getState());
  enterRule(_localctx, 292, MySQLParser::RuleLoadMemory);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3304);

    if (!(serverVersion >= 80200)) throw FailedPredicateException(this, "serverVersion >= 80200");
    setState(3305);
    match(MySQLParser::MEMORY_SYMBOL);
    setState(3306);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(3307);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ReplaceStatementContext ------------------------------------------------------------------

MySQLParser::ReplaceStatementContext::ReplaceStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::ReplaceStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::ReplaceStatementContext::insertFromConstructor() {
  return getRuleContext<MySQLParser::InsertFromConstructorContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::ReplaceStatementContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::ReplaceStatementContext::insertQueryExpression() {
  return getRuleContext<MySQLParser::InsertQueryExpressionContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::ReplaceStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::DELAYED_SYMBOL() {
  return getToken(MySQLParser::DELAYED_SYMBOL, 0);
}


size_t MySQLParser::ReplaceStatementContext::getRuleIndex() const {
  return MySQLParser::RuleReplaceStatement;
}

void MySQLParser::ReplaceStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterReplaceStatement(this);
}

void MySQLParser::ReplaceStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitReplaceStatement(this);
}


std::any MySQLParser::ReplaceStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitReplaceStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ReplaceStatementContext* MySQLParser::replaceStatement() {
  ReplaceStatementContext *_localctx = _tracker.createInstance<ReplaceStatementContext>(_ctx, getState());
  enterRule(_localctx, 294, MySQLParser::RuleReplaceStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3309);
    match(MySQLParser::REPLACE_SYMBOL);
    setState(3311);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 288, _ctx)) {
    case 1: {
      setState(3310);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::DELAYED_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(3314);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 289, _ctx)) {
    case 1: {
      setState(3313);
      match(MySQLParser::INTO_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3316);
    tableRef();
    setState(3318);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 290, _ctx)) {
    case 1: {
      setState(3317);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(3324);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 291, _ctx)) {
    case 1: {
      setState(3320);
      insertFromConstructor();
      break;
    }

    case 2: {
      setState(3321);
      match(MySQLParser::SET_SYMBOL);
      setState(3322);
      updateList();
      break;
    }

    case 3: {
      setState(3323);
      insertQueryExpression();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectStatementContext ------------------------------------------------------------------

MySQLParser::SelectStatementContext::SelectStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::SelectStatementContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::SelectStatementContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::SelectStatementContext::selectStatementWithInto() {
  return getRuleContext<MySQLParser::SelectStatementWithIntoContext>(0);
}


size_t MySQLParser::SelectStatementContext::getRuleIndex() const {
  return MySQLParser::RuleSelectStatement;
}

void MySQLParser::SelectStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectStatement(this);
}

void MySQLParser::SelectStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectStatement(this);
}


std::any MySQLParser::SelectStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectStatementContext* MySQLParser::selectStatement() {
  SelectStatementContext *_localctx = _tracker.createInstance<SelectStatementContext>(_ctx, getState());
  enterRule(_localctx, 296, MySQLParser::RuleSelectStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3331);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 293, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3326);
      queryExpression();
      setState(3328);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 292, _ctx)) {
      case 1: {
        setState(3327);
        lockingClauseList();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3330);
      selectStatementWithInto();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectStatementWithIntoContext ------------------------------------------------------------------

MySQLParser::SelectStatementWithIntoContext::SelectStatementWithIntoContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SelectStatementWithIntoContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::SelectStatementWithIntoContext::selectStatementWithInto() {
  return getRuleContext<MySQLParser::SelectStatementWithIntoContext>(0);
}

tree::TerminalNode* MySQLParser::SelectStatementWithIntoContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::QueryExpressionContext* MySQLParser::SelectStatementWithIntoContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::IntoClauseContext* MySQLParser::SelectStatementWithIntoContext::intoClause() {
  return getRuleContext<MySQLParser::IntoClauseContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::SelectStatementWithIntoContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::SelectStatementWithIntoContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::SelectStatementWithIntoContext::getRuleIndex() const {
  return MySQLParser::RuleSelectStatementWithInto;
}

void MySQLParser::SelectStatementWithIntoContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectStatementWithInto(this);
}

void MySQLParser::SelectStatementWithIntoContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectStatementWithInto(this);
}


std::any MySQLParser::SelectStatementWithIntoContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectStatementWithInto(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::selectStatementWithInto() {
  SelectStatementWithIntoContext *_localctx = _tracker.createInstance<SelectStatementWithIntoContext>(_ctx, getState());
  enterRule(_localctx, 298, MySQLParser::RuleSelectStatementWithInto);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3350);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 295, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3333);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(3334);
      selectStatementWithInto();
      setState(3335);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3337);
      queryExpression();
      setState(3338);
      intoClause();
      setState(3340);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 294, _ctx)) {
      case 1: {
        setState(3339);
        lockingClauseList();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3342);
      queryExpression();
      setState(3343);
      lockingClauseList();
      setState(3344);
      intoClause();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(3346);

      if (!(serverVersion >= 80024 && serverVersion < 80031)) throw FailedPredicateException(this, "serverVersion >= 80024 && serverVersion < 80031");
      setState(3347);
      queryExpressionParens();
      setState(3348);
      intoClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionContext ------------------------------------------------------------------

MySQLParser::QueryExpressionContext::QueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::QueryExpressionContext::queryExpressionBody() {
  return getRuleContext<MySQLParser::QueryExpressionBodyContext>(0);
}

MySQLParser::WithClauseContext* MySQLParser::QueryExpressionContext::withClause() {
  return getRuleContext<MySQLParser::WithClauseContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::QueryExpressionContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::LimitClauseContext* MySQLParser::QueryExpressionContext::limitClause() {
  return getRuleContext<MySQLParser::LimitClauseContext>(0);
}

MySQLParser::ProcedureAnalyseClauseContext* MySQLParser::QueryExpressionContext::procedureAnalyseClause() {
  return getRuleContext<MySQLParser::ProcedureAnalyseClauseContext>(0);
}


size_t MySQLParser::QueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpression;
}

void MySQLParser::QueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpression(this);
}

void MySQLParser::QueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpression(this);
}


std::any MySQLParser::QueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionContext* MySQLParser::queryExpression() {
  QueryExpressionContext *_localctx = _tracker.createInstance<QueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 300, MySQLParser::RuleQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3354);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 296, _ctx)) {
    case 1: {
      setState(3352);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(3353);
      withClause();
      break;
    }

    default:
      break;
    }
    setState(3356);
    queryExpressionBody();
    setState(3358);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 297, _ctx)) {
    case 1: {
      setState(3357);
      orderClause();
      break;
    }

    default:
      break;
    }
    setState(3361);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 298, _ctx)) {
    case 1: {
      setState(3360);
      limitClause();
      break;
    }

    default:
      break;
    }
    setState(3365);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 299, _ctx)) {
    case 1: {
      setState(3363);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(3364);
      procedureAnalyseClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionBodyContext ------------------------------------------------------------------

MySQLParser::QueryExpressionBodyContext::QueryExpressionBodyContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryPrimaryContext* MySQLParser::QueryExpressionBodyContext::queryPrimary() {
  return getRuleContext<MySQLParser::QueryPrimaryContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionBodyContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

std::vector<MySQLParser::QueryExpressionBodyContext *> MySQLParser::QueryExpressionBodyContext::queryExpressionBody() {
  return getRuleContexts<MySQLParser::QueryExpressionBodyContext>();
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::QueryExpressionBodyContext::queryExpressionBody(size_t i) {
  return getRuleContext<MySQLParser::QueryExpressionBodyContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::QueryExpressionBodyContext::UNION_SYMBOL() {
  return getTokens(MySQLParser::UNION_SYMBOL);
}

tree::TerminalNode* MySQLParser::QueryExpressionBodyContext::UNION_SYMBOL(size_t i) {
  return getToken(MySQLParser::UNION_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::QueryExpressionBodyContext::EXCEPT_SYMBOL() {
  return getTokens(MySQLParser::EXCEPT_SYMBOL);
}

tree::TerminalNode* MySQLParser::QueryExpressionBodyContext::EXCEPT_SYMBOL(size_t i) {
  return getToken(MySQLParser::EXCEPT_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::QueryExpressionBodyContext::INTERSECT_SYMBOL() {
  return getTokens(MySQLParser::INTERSECT_SYMBOL);
}

tree::TerminalNode* MySQLParser::QueryExpressionBodyContext::INTERSECT_SYMBOL(size_t i) {
  return getToken(MySQLParser::INTERSECT_SYMBOL, i);
}

std::vector<MySQLParser::UnionOptionContext *> MySQLParser::QueryExpressionBodyContext::unionOption() {
  return getRuleContexts<MySQLParser::UnionOptionContext>();
}

MySQLParser::UnionOptionContext* MySQLParser::QueryExpressionBodyContext::unionOption(size_t i) {
  return getRuleContext<MySQLParser::UnionOptionContext>(i);
}


size_t MySQLParser::QueryExpressionBodyContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionBody;
}

void MySQLParser::QueryExpressionBodyContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionBody(this);
}

void MySQLParser::QueryExpressionBodyContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionBody(this);
}


std::any MySQLParser::QueryExpressionBodyContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionBody(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::queryExpressionBody() {
  QueryExpressionBodyContext *_localctx = _tracker.createInstance<QueryExpressionBodyContext>(_ctx, getState());
  enterRule(_localctx, 302, MySQLParser::RuleQueryExpressionBody);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3369);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 300, _ctx)) {
    case 1: {
      setState(3367);
      queryPrimary();
      break;
    }

    case 2: {
      setState(3368);
      queryExpressionParens();
      break;
    }

    default:
      break;
    }
    setState(3382);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 303, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3374);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 301, _ctx)) {
        case 1: {
          setState(3371);
          match(MySQLParser::UNION_SYMBOL);
          break;
        }

        case 2: {
          setState(3372);

          if (!(serverVersion >= 80031)) throw FailedPredicateException(this, "serverVersion >= 80031");
          setState(3373);
          _la = _input->LA(1);
          if (!(_la == MySQLParser::EXCEPT_SYMBOL || _la == MySQLParser::INTERSECT_SYMBOL)) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          break;
        }

        default:
          break;
        }
        setState(3377);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 302, _ctx)) {
        case 1: {
          setState(3376);
          unionOption();
          break;
        }

        default:
          break;
        }
        setState(3379);
        queryExpressionBody(); 
      }
      setState(3384);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 303, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionParensContext ------------------------------------------------------------------

MySQLParser::QueryExpressionParensContext::QueryExpressionParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QueryExpressionParensContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QueryExpressionParensContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionParensContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::QueryExpressionWithOptLockingClausesContext* MySQLParser::QueryExpressionParensContext::queryExpressionWithOptLockingClauses() {
  return getRuleContext<MySQLParser::QueryExpressionWithOptLockingClausesContext>(0);
}


size_t MySQLParser::QueryExpressionParensContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionParens;
}

void MySQLParser::QueryExpressionParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionParens(this);
}

void MySQLParser::QueryExpressionParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionParens(this);
}


std::any MySQLParser::QueryExpressionParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::queryExpressionParens() {
  QueryExpressionParensContext *_localctx = _tracker.createInstance<QueryExpressionParensContext>(_ctx, getState());
  enterRule(_localctx, 304, MySQLParser::RuleQueryExpressionParens);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3385);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3388);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 304, _ctx)) {
    case 1: {
      setState(3386);
      queryExpressionParens();
      break;
    }

    case 2: {
      setState(3387);
      queryExpressionWithOptLockingClauses();
      break;
    }

    default:
      break;
    }
    setState(3390);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryPrimaryContext ------------------------------------------------------------------

MySQLParser::QueryPrimaryContext::QueryPrimaryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QuerySpecificationContext* MySQLParser::QueryPrimaryContext::querySpecification() {
  return getRuleContext<MySQLParser::QuerySpecificationContext>(0);
}

MySQLParser::TableValueConstructorContext* MySQLParser::QueryPrimaryContext::tableValueConstructor() {
  return getRuleContext<MySQLParser::TableValueConstructorContext>(0);
}

MySQLParser::ExplicitTableContext* MySQLParser::QueryPrimaryContext::explicitTable() {
  return getRuleContext<MySQLParser::ExplicitTableContext>(0);
}


size_t MySQLParser::QueryPrimaryContext::getRuleIndex() const {
  return MySQLParser::RuleQueryPrimary;
}

void MySQLParser::QueryPrimaryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryPrimary(this);
}

void MySQLParser::QueryPrimaryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryPrimary(this);
}


std::any MySQLParser::QueryPrimaryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryPrimary(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryPrimaryContext* MySQLParser::queryPrimary() {
  QueryPrimaryContext *_localctx = _tracker.createInstance<QueryPrimaryContext>(_ctx, getState());
  enterRule(_localctx, 306, MySQLParser::RuleQueryPrimary);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3397);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 305, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3392);
      querySpecification();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3393);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(3394);
      tableValueConstructor();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3395);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(3396);
      explicitTable();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QuerySpecificationContext ------------------------------------------------------------------

MySQLParser::QuerySpecificationContext::QuerySpecificationContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QuerySpecificationContext::SELECT_SYMBOL() {
  return getToken(MySQLParser::SELECT_SYMBOL, 0);
}

MySQLParser::SelectItemListContext* MySQLParser::QuerySpecificationContext::selectItemList() {
  return getRuleContext<MySQLParser::SelectItemListContext>(0);
}

std::vector<MySQLParser::SelectOptionContext *> MySQLParser::QuerySpecificationContext::selectOption() {
  return getRuleContexts<MySQLParser::SelectOptionContext>();
}

MySQLParser::SelectOptionContext* MySQLParser::QuerySpecificationContext::selectOption(size_t i) {
  return getRuleContext<MySQLParser::SelectOptionContext>(i);
}

MySQLParser::IntoClauseContext* MySQLParser::QuerySpecificationContext::intoClause() {
  return getRuleContext<MySQLParser::IntoClauseContext>(0);
}

MySQLParser::FromClauseContext* MySQLParser::QuerySpecificationContext::fromClause() {
  return getRuleContext<MySQLParser::FromClauseContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::QuerySpecificationContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::GroupByClauseContext* MySQLParser::QuerySpecificationContext::groupByClause() {
  return getRuleContext<MySQLParser::GroupByClauseContext>(0);
}

MySQLParser::HavingClauseContext* MySQLParser::QuerySpecificationContext::havingClause() {
  return getRuleContext<MySQLParser::HavingClauseContext>(0);
}

MySQLParser::WindowClauseContext* MySQLParser::QuerySpecificationContext::windowClause() {
  return getRuleContext<MySQLParser::WindowClauseContext>(0);
}


size_t MySQLParser::QuerySpecificationContext::getRuleIndex() const {
  return MySQLParser::RuleQuerySpecification;
}

void MySQLParser::QuerySpecificationContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuerySpecification(this);
}

void MySQLParser::QuerySpecificationContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuerySpecification(this);
}


std::any MySQLParser::QuerySpecificationContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuerySpecification(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QuerySpecificationContext* MySQLParser::querySpecification() {
  QuerySpecificationContext *_localctx = _tracker.createInstance<QuerySpecificationContext>(_ctx, getState());
  enterRule(_localctx, 308, MySQLParser::RuleQuerySpecification);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3399);
    match(MySQLParser::SELECT_SYMBOL);
    setState(3403);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 306, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3400);
        selectOption(); 
      }
      setState(3405);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 306, _ctx);
    }
    setState(3406);
    selectItemList();
    setState(3408);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 307, _ctx)) {
    case 1: {
      setState(3407);
      intoClause();
      break;
    }

    default:
      break;
    }
    setState(3411);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 308, _ctx)) {
    case 1: {
      setState(3410);
      fromClause();
      break;
    }

    default:
      break;
    }
    setState(3414);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 309, _ctx)) {
    case 1: {
      setState(3413);
      whereClause();
      break;
    }

    default:
      break;
    }
    setState(3417);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 310, _ctx)) {
    case 1: {
      setState(3416);
      groupByClause();
      break;
    }

    default:
      break;
    }
    setState(3420);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 311, _ctx)) {
    case 1: {
      setState(3419);
      havingClause();
      break;
    }

    default:
      break;
    }
    setState(3424);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 312, _ctx)) {
    case 1: {
      setState(3422);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(3423);
      windowClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SubqueryContext ------------------------------------------------------------------

MySQLParser::SubqueryContext::SubqueryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionParensContext* MySQLParser::SubqueryContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::SubqueryContext::getRuleIndex() const {
  return MySQLParser::RuleSubquery;
}

void MySQLParser::SubqueryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSubquery(this);
}

void MySQLParser::SubqueryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSubquery(this);
}


std::any MySQLParser::SubqueryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSubquery(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SubqueryContext* MySQLParser::subquery() {
  SubqueryContext *_localctx = _tracker.createInstance<SubqueryContext>(_ctx, getState());
  enterRule(_localctx, 310, MySQLParser::RuleSubquery);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3426);
    queryExpressionParens();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QuerySpecOptionContext ------------------------------------------------------------------

MySQLParser::QuerySpecOptionContext::QuerySpecOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::ALL_SYMBOL() {
  return getToken(MySQLParser::ALL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::DISTINCT_SYMBOL() {
  return getToken(MySQLParser::DISTINCT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::STRAIGHT_JOIN_SYMBOL() {
  return getToken(MySQLParser::STRAIGHT_JOIN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::HIGH_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::HIGH_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_SMALL_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_SMALL_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_BIG_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_BIG_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_BUFFER_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_BUFFER_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_CALC_FOUND_ROWS_SYMBOL() {
  return getToken(MySQLParser::SQL_CALC_FOUND_ROWS_SYMBOL, 0);
}


size_t MySQLParser::QuerySpecOptionContext::getRuleIndex() const {
  return MySQLParser::RuleQuerySpecOption;
}

void MySQLParser::QuerySpecOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuerySpecOption(this);
}

void MySQLParser::QuerySpecOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuerySpecOption(this);
}


std::any MySQLParser::QuerySpecOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuerySpecOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QuerySpecOptionContext* MySQLParser::querySpecOption() {
  QuerySpecOptionContext *_localctx = _tracker.createInstance<QuerySpecOptionContext>(_ctx, getState());
  enterRule(_localctx, 312, MySQLParser::RuleQuerySpecOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3428);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ALL_SYMBOL || _la == MySQLParser::DISTINCT_SYMBOL || _la == MySQLParser::HIGH_PRIORITY_SYMBOL || ((((_la - 557) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 557)) & ((1ULL << (MySQLParser::SQL_BIG_RESULT_SYMBOL - 557))
      | (1ULL << (MySQLParser::SQL_BUFFER_RESULT_SYMBOL - 557))
      | (1ULL << (MySQLParser::SQL_CALC_FOUND_ROWS_SYMBOL - 557))
      | (1ULL << (MySQLParser::SQL_SMALL_RESULT_SYMBOL - 557))
      | (1ULL << (MySQLParser::STRAIGHT_JOIN_SYMBOL - 557)))) != 0))) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitClauseContext ------------------------------------------------------------------

MySQLParser::LimitClauseContext::LimitClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LimitClauseContext::LIMIT_SYMBOL() {
  return getToken(MySQLParser::LIMIT_SYMBOL, 0);
}

MySQLParser::LimitOptionsContext* MySQLParser::LimitClauseContext::limitOptions() {
  return getRuleContext<MySQLParser::LimitOptionsContext>(0);
}


size_t MySQLParser::LimitClauseContext::getRuleIndex() const {
  return MySQLParser::RuleLimitClause;
}

void MySQLParser::LimitClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitClause(this);
}

void MySQLParser::LimitClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitClause(this);
}


std::any MySQLParser::LimitClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitClauseContext* MySQLParser::limitClause() {
  LimitClauseContext *_localctx = _tracker.createInstance<LimitClauseContext>(_ctx, getState());
  enterRule(_localctx, 314, MySQLParser::RuleLimitClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3430);
    match(MySQLParser::LIMIT_SYMBOL);
    setState(3431);
    limitOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SimpleLimitClauseContext ------------------------------------------------------------------

MySQLParser::SimpleLimitClauseContext::SimpleLimitClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SimpleLimitClauseContext::LIMIT_SYMBOL() {
  return getToken(MySQLParser::LIMIT_SYMBOL, 0);
}

MySQLParser::LimitOptionContext* MySQLParser::SimpleLimitClauseContext::limitOption() {
  return getRuleContext<MySQLParser::LimitOptionContext>(0);
}


size_t MySQLParser::SimpleLimitClauseContext::getRuleIndex() const {
  return MySQLParser::RuleSimpleLimitClause;
}

void MySQLParser::SimpleLimitClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSimpleLimitClause(this);
}

void MySQLParser::SimpleLimitClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSimpleLimitClause(this);
}


std::any MySQLParser::SimpleLimitClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSimpleLimitClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SimpleLimitClauseContext* MySQLParser::simpleLimitClause() {
  SimpleLimitClauseContext *_localctx = _tracker.createInstance<SimpleLimitClauseContext>(_ctx, getState());
  enterRule(_localctx, 316, MySQLParser::RuleSimpleLimitClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3433);
    match(MySQLParser::LIMIT_SYMBOL);
    setState(3434);
    limitOption();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitOptionsContext ------------------------------------------------------------------

MySQLParser::LimitOptionsContext::LimitOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LimitOptionContext *> MySQLParser::LimitOptionsContext::limitOption() {
  return getRuleContexts<MySQLParser::LimitOptionContext>();
}

MySQLParser::LimitOptionContext* MySQLParser::LimitOptionsContext::limitOption(size_t i) {
  return getRuleContext<MySQLParser::LimitOptionContext>(i);
}

tree::TerminalNode* MySQLParser::LimitOptionsContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionsContext::OFFSET_SYMBOL() {
  return getToken(MySQLParser::OFFSET_SYMBOL, 0);
}


size_t MySQLParser::LimitOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleLimitOptions;
}

void MySQLParser::LimitOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitOptions(this);
}

void MySQLParser::LimitOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitOptions(this);
}


std::any MySQLParser::LimitOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitOptionsContext* MySQLParser::limitOptions() {
  LimitOptionsContext *_localctx = _tracker.createInstance<LimitOptionsContext>(_ctx, getState());
  enterRule(_localctx, 318, MySQLParser::RuleLimitOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3436);
    limitOption();
    setState(3439);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 313, _ctx)) {
    case 1: {
      setState(3437);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::COMMA_SYMBOL || _la == MySQLParser::OFFSET_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(3438);
      limitOption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitOptionContext ------------------------------------------------------------------

MySQLParser::LimitOptionContext::LimitOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::LimitOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::ULONGLONG_NUMBER() {
  return getToken(MySQLParser::ULONGLONG_NUMBER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::LONG_NUMBER() {
  return getToken(MySQLParser::LONG_NUMBER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}


size_t MySQLParser::LimitOptionContext::getRuleIndex() const {
  return MySQLParser::RuleLimitOption;
}

void MySQLParser::LimitOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitOption(this);
}

void MySQLParser::LimitOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitOption(this);
}


std::any MySQLParser::LimitOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitOptionContext* MySQLParser::limitOption() {
  LimitOptionContext *_localctx = _tracker.createInstance<LimitOptionContext>(_ctx, getState());
  enterRule(_localctx, 320, MySQLParser::RuleLimitOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3443);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 314, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3441);
      identifier();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3442);
      _la = _input->LA(1);
      if (!((((_la & ~ 0x3fULL) == 0) &&
        ((1ULL << _la) & ((1ULL << MySQLParser::INT_NUMBER)
        | (1ULL << MySQLParser::LONG_NUMBER)
        | (1ULL << MySQLParser::ULONGLONG_NUMBER)
        | (1ULL << MySQLParser::PARAM_MARKER))) != 0))) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IntoClauseContext ------------------------------------------------------------------

MySQLParser::IntoClauseContext::IntoClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::IntoClauseContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::OUTFILE_SYMBOL() {
  return getToken(MySQLParser::OUTFILE_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::IntoClauseContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::DUMPFILE_SYMBOL() {
  return getToken(MySQLParser::DUMPFILE_SYMBOL, 0);
}

std::vector<MySQLParser::TextOrIdentifierContext *> MySQLParser::IntoClauseContext::textOrIdentifier() {
  return getRuleContexts<MySQLParser::TextOrIdentifierContext>();
}

MySQLParser::TextOrIdentifierContext* MySQLParser::IntoClauseContext::textOrIdentifier(size_t i) {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(i);
}

std::vector<MySQLParser::UserVariableContext *> MySQLParser::IntoClauseContext::userVariable() {
  return getRuleContexts<MySQLParser::UserVariableContext>();
}

MySQLParser::UserVariableContext* MySQLParser::IntoClauseContext::userVariable(size_t i) {
  return getRuleContext<MySQLParser::UserVariableContext>(i);
}

MySQLParser::CharsetClauseContext* MySQLParser::IntoClauseContext::charsetClause() {
  return getRuleContext<MySQLParser::CharsetClauseContext>(0);
}

MySQLParser::FieldsClauseContext* MySQLParser::IntoClauseContext::fieldsClause() {
  return getRuleContext<MySQLParser::FieldsClauseContext>(0);
}

MySQLParser::LinesClauseContext* MySQLParser::IntoClauseContext::linesClause() {
  return getRuleContext<MySQLParser::LinesClauseContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::IntoClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::IntoClauseContext::getRuleIndex() const {
  return MySQLParser::RuleIntoClause;
}

void MySQLParser::IntoClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIntoClause(this);
}

void MySQLParser::IntoClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIntoClause(this);
}


std::any MySQLParser::IntoClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIntoClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IntoClauseContext* MySQLParser::intoClause() {
  IntoClauseContext *_localctx = _tracker.createInstance<IntoClauseContext>(_ctx, getState());
  enterRule(_localctx, 322, MySQLParser::RuleIntoClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3445);
    match(MySQLParser::INTO_SYMBOL);
    setState(3473);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 321, _ctx)) {
    case 1: {
      setState(3446);
      match(MySQLParser::OUTFILE_SYMBOL);
      setState(3447);
      textStringLiteral();
      setState(3449);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 315, _ctx)) {
      case 1: {
        setState(3448);
        charsetClause();
        break;
      }

      default:
        break;
      }
      setState(3452);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 316, _ctx)) {
      case 1: {
        setState(3451);
        fieldsClause();
        break;
      }

      default:
        break;
      }
      setState(3455);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 317, _ctx)) {
      case 1: {
        setState(3454);
        linesClause();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3457);
      match(MySQLParser::DUMPFILE_SYMBOL);
      setState(3458);
      textStringLiteral();
      break;
    }

    case 3: {
      setState(3461);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 318, _ctx)) {
      case 1: {
        setState(3459);
        textOrIdentifier();
        break;
      }

      case 2: {
        setState(3460);
        userVariable();
        break;
      }

      default:
        break;
      }
      setState(3470);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 320, _ctx);
      while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
        if (alt == 1) {
          setState(3463);
          match(MySQLParser::COMMA_SYMBOL);
          setState(3466);
          _errHandler->sync(this);
          switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 319, _ctx)) {
          case 1: {
            setState(3464);
            textOrIdentifier();
            break;
          }

          case 2: {
            setState(3465);
            userVariable();
            break;
          }

          default:
            break;
          } 
        }
        setState(3472);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 320, _ctx);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ProcedureAnalyseClauseContext ------------------------------------------------------------------

MySQLParser::ProcedureAnalyseClauseContext::ProcedureAnalyseClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::ANALYSE_SYMBOL() {
  return getToken(MySQLParser::ANALYSE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::ProcedureAnalyseClauseContext::INT_NUMBER() {
  return getTokens(MySQLParser::INT_NUMBER);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::INT_NUMBER(size_t i) {
  return getToken(MySQLParser::INT_NUMBER, i);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::ProcedureAnalyseClauseContext::getRuleIndex() const {
  return MySQLParser::RuleProcedureAnalyseClause;
}

void MySQLParser::ProcedureAnalyseClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterProcedureAnalyseClause(this);
}

void MySQLParser::ProcedureAnalyseClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitProcedureAnalyseClause(this);
}


std::any MySQLParser::ProcedureAnalyseClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitProcedureAnalyseClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ProcedureAnalyseClauseContext* MySQLParser::procedureAnalyseClause() {
  ProcedureAnalyseClauseContext *_localctx = _tracker.createInstance<ProcedureAnalyseClauseContext>(_ctx, getState());
  enterRule(_localctx, 324, MySQLParser::RuleProcedureAnalyseClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3475);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(3476);
    match(MySQLParser::ANALYSE_SYMBOL);
    setState(3477);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3483);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::INT_NUMBER) {
      setState(3478);
      match(MySQLParser::INT_NUMBER);
      setState(3481);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(3479);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3480);
        match(MySQLParser::INT_NUMBER);
      }
    }
    setState(3485);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HavingClauseContext ------------------------------------------------------------------

MySQLParser::HavingClauseContext::HavingClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HavingClauseContext::HAVING_SYMBOL() {
  return getToken(MySQLParser::HAVING_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::HavingClauseContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}


size_t MySQLParser::HavingClauseContext::getRuleIndex() const {
  return MySQLParser::RuleHavingClause;
}

void MySQLParser::HavingClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHavingClause(this);
}

void MySQLParser::HavingClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHavingClause(this);
}


std::any MySQLParser::HavingClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHavingClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HavingClauseContext* MySQLParser::havingClause() {
  HavingClauseContext *_localctx = _tracker.createInstance<HavingClauseContext>(_ctx, getState());
  enterRule(_localctx, 326, MySQLParser::RuleHavingClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3487);
    match(MySQLParser::HAVING_SYMBOL);
    setState(3488);
    expr(0);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowClauseContext ------------------------------------------------------------------

MySQLParser::WindowClauseContext::WindowClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowClauseContext::WINDOW_SYMBOL() {
  return getToken(MySQLParser::WINDOW_SYMBOL, 0);
}

std::vector<MySQLParser::WindowDefinitionContext *> MySQLParser::WindowClauseContext::windowDefinition() {
  return getRuleContexts<MySQLParser::WindowDefinitionContext>();
}

MySQLParser::WindowDefinitionContext* MySQLParser::WindowClauseContext::windowDefinition(size_t i) {
  return getRuleContext<MySQLParser::WindowDefinitionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::WindowClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::WindowClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::WindowClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWindowClause;
}

void MySQLParser::WindowClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowClause(this);
}

void MySQLParser::WindowClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowClause(this);
}


std::any MySQLParser::WindowClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowClauseContext* MySQLParser::windowClause() {
  WindowClauseContext *_localctx = _tracker.createInstance<WindowClauseContext>(_ctx, getState());
  enterRule(_localctx, 328, MySQLParser::RuleWindowClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3490);
    match(MySQLParser::WINDOW_SYMBOL);
    setState(3491);
    windowDefinition();
    setState(3496);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 324, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3492);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3493);
        windowDefinition(); 
      }
      setState(3498);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 324, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowDefinitionContext ------------------------------------------------------------------

MySQLParser::WindowDefinitionContext::WindowDefinitionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowNameContext* MySQLParser::WindowDefinitionContext::windowName() {
  return getRuleContext<MySQLParser::WindowNameContext>(0);
}

tree::TerminalNode* MySQLParser::WindowDefinitionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::WindowSpecContext* MySQLParser::WindowDefinitionContext::windowSpec() {
  return getRuleContext<MySQLParser::WindowSpecContext>(0);
}


size_t MySQLParser::WindowDefinitionContext::getRuleIndex() const {
  return MySQLParser::RuleWindowDefinition;
}

void MySQLParser::WindowDefinitionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowDefinition(this);
}

void MySQLParser::WindowDefinitionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowDefinition(this);
}


std::any MySQLParser::WindowDefinitionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowDefinition(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowDefinitionContext* MySQLParser::windowDefinition() {
  WindowDefinitionContext *_localctx = _tracker.createInstance<WindowDefinitionContext>(_ctx, getState());
  enterRule(_localctx, 330, MySQLParser::RuleWindowDefinition);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3499);
    windowName();
    setState(3500);
    match(MySQLParser::AS_SYMBOL);
    setState(3501);
    windowSpec();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowSpecContext ------------------------------------------------------------------

MySQLParser::WindowSpecContext::WindowSpecContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowSpecContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::WindowSpecDetailsContext* MySQLParser::WindowSpecContext::windowSpecDetails() {
  return getRuleContext<MySQLParser::WindowSpecDetailsContext>(0);
}

tree::TerminalNode* MySQLParser::WindowSpecContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}


size_t MySQLParser::WindowSpecContext::getRuleIndex() const {
  return MySQLParser::RuleWindowSpec;
}

void MySQLParser::WindowSpecContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowSpec(this);
}

void MySQLParser::WindowSpecContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowSpec(this);
}


std::any MySQLParser::WindowSpecContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowSpec(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowSpecContext* MySQLParser::windowSpec() {
  WindowSpecContext *_localctx = _tracker.createInstance<WindowSpecContext>(_ctx, getState());
  enterRule(_localctx, 332, MySQLParser::RuleWindowSpec);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3503);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3504);
    windowSpecDetails();
    setState(3505);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowSpecDetailsContext ------------------------------------------------------------------

MySQLParser::WindowSpecDetailsContext::WindowSpecDetailsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowNameContext* MySQLParser::WindowSpecDetailsContext::windowName() {
  return getRuleContext<MySQLParser::WindowNameContext>(0);
}

tree::TerminalNode* MySQLParser::WindowSpecDetailsContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowSpecDetailsContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::WindowSpecDetailsContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::WindowSpecDetailsContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::WindowFrameClauseContext* MySQLParser::WindowSpecDetailsContext::windowFrameClause() {
  return getRuleContext<MySQLParser::WindowFrameClauseContext>(0);
}


size_t MySQLParser::WindowSpecDetailsContext::getRuleIndex() const {
  return MySQLParser::RuleWindowSpecDetails;
}

void MySQLParser::WindowSpecDetailsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowSpecDetails(this);
}

void MySQLParser::WindowSpecDetailsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowSpecDetails(this);
}


std::any MySQLParser::WindowSpecDetailsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowSpecDetails(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowSpecDetailsContext* MySQLParser::windowSpecDetails() {
  WindowSpecDetailsContext *_localctx = _tracker.createInstance<WindowSpecDetailsContext>(_ctx, getState());
  enterRule(_localctx, 334, MySQLParser::RuleWindowSpecDetails);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3508);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 325, _ctx)) {
    case 1: {
      setState(3507);
      windowName();
      break;
    }

    default:
      break;
    }
    setState(3513);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::PARTITION_SYMBOL) {
      setState(3510);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(3511);
      match(MySQLParser::BY_SYMBOL);
      setState(3512);
      orderList();
    }
    setState(3516);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ORDER_SYMBOL) {
      setState(3515);
      orderClause();
    }
    setState(3519);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::RANGE_SYMBOL

    || _la == MySQLParser::ROWS_SYMBOL || _la == MySQLParser::GROUPS_SYMBOL) {
      setState(3518);
      windowFrameClause();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameClauseContext ------------------------------------------------------------------

MySQLParser::WindowFrameClauseContext::WindowFrameClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameUnitsContext* MySQLParser::WindowFrameClauseContext::windowFrameUnits() {
  return getRuleContext<MySQLParser::WindowFrameUnitsContext>(0);
}

MySQLParser::WindowFrameExtentContext* MySQLParser::WindowFrameClauseContext::windowFrameExtent() {
  return getRuleContext<MySQLParser::WindowFrameExtentContext>(0);
}

MySQLParser::WindowFrameExclusionContext* MySQLParser::WindowFrameClauseContext::windowFrameExclusion() {
  return getRuleContext<MySQLParser::WindowFrameExclusionContext>(0);
}


size_t MySQLParser::WindowFrameClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameClause;
}

void MySQLParser::WindowFrameClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameClause(this);
}

void MySQLParser::WindowFrameClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameClause(this);
}


std::any MySQLParser::WindowFrameClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameClauseContext* MySQLParser::windowFrameClause() {
  WindowFrameClauseContext *_localctx = _tracker.createInstance<WindowFrameClauseContext>(_ctx, getState());
  enterRule(_localctx, 336, MySQLParser::RuleWindowFrameClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3521);
    windowFrameUnits();
    setState(3522);
    windowFrameExtent();
    setState(3524);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::EXCLUDE_SYMBOL) {
      setState(3523);
      windowFrameExclusion();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameUnitsContext ------------------------------------------------------------------

MySQLParser::WindowFrameUnitsContext::WindowFrameUnitsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::RANGE_SYMBOL() {
  return getToken(MySQLParser::RANGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::GROUPS_SYMBOL() {
  return getToken(MySQLParser::GROUPS_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameUnitsContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameUnits;
}

void MySQLParser::WindowFrameUnitsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameUnits(this);
}

void MySQLParser::WindowFrameUnitsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameUnits(this);
}


std::any MySQLParser::WindowFrameUnitsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameUnits(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameUnitsContext* MySQLParser::windowFrameUnits() {
  WindowFrameUnitsContext *_localctx = _tracker.createInstance<WindowFrameUnitsContext>(_ctx, getState());
  enterRule(_localctx, 338, MySQLParser::RuleWindowFrameUnits);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3526);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::RANGE_SYMBOL

    || _la == MySQLParser::ROWS_SYMBOL || _la == MySQLParser::GROUPS_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameExtentContext ------------------------------------------------------------------

MySQLParser::WindowFrameExtentContext::WindowFrameExtentContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameStartContext* MySQLParser::WindowFrameExtentContext::windowFrameStart() {
  return getRuleContext<MySQLParser::WindowFrameStartContext>(0);
}

MySQLParser::WindowFrameBetweenContext* MySQLParser::WindowFrameExtentContext::windowFrameBetween() {
  return getRuleContext<MySQLParser::WindowFrameBetweenContext>(0);
}


size_t MySQLParser::WindowFrameExtentContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameExtent;
}

void MySQLParser::WindowFrameExtentContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameExtent(this);
}

void MySQLParser::WindowFrameExtentContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameExtent(this);
}


std::any MySQLParser::WindowFrameExtentContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameExtent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameExtentContext* MySQLParser::windowFrameExtent() {
  WindowFrameExtentContext *_localctx = _tracker.createInstance<WindowFrameExtentContext>(_ctx, getState());
  enterRule(_localctx, 340, MySQLParser::RuleWindowFrameExtent);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3530);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INT_NUMBER:
      case MySQLParser::LONG_NUMBER:
      case MySQLParser::ULONGLONG_NUMBER:
      case MySQLParser::PARAM_MARKER:
      case MySQLParser::DECIMAL_NUMBER:
      case MySQLParser::FLOAT_NUMBER:
      case MySQLParser::CURRENT_SYMBOL:
      case MySQLParser::INTERVAL_SYMBOL:
      case MySQLParser::UNBOUNDED_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3528);
        windowFrameStart();
        break;
      }

      case MySQLParser::BETWEEN_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3529);
        windowFrameBetween();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameStartContext ------------------------------------------------------------------

MySQLParser::WindowFrameStartContext::WindowFrameStartContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::UNBOUNDED_SYMBOL() {
  return getToken(MySQLParser::UNBOUNDED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::PRECEDING_SYMBOL() {
  return getToken(MySQLParser::PRECEDING_SYMBOL, 0);
}

MySQLParser::Ulonglong_numberContext* MySQLParser::WindowFrameStartContext::ulonglong_number() {
  return getRuleContext<MySQLParser::Ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::INTERVAL_SYMBOL() {
  return getToken(MySQLParser::INTERVAL_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::WindowFrameStartContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::IntervalContext* MySQLParser::WindowFrameStartContext::interval() {
  return getRuleContext<MySQLParser::IntervalContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::CURRENT_SYMBOL() {
  return getToken(MySQLParser::CURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameStartContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameStart;
}

void MySQLParser::WindowFrameStartContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameStart(this);
}

void MySQLParser::WindowFrameStartContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameStart(this);
}


std::any MySQLParser::WindowFrameStartContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameStart(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameStartContext* MySQLParser::windowFrameStart() {
  WindowFrameStartContext *_localctx = _tracker.createInstance<WindowFrameStartContext>(_ctx, getState());
  enterRule(_localctx, 342, MySQLParser::RuleWindowFrameStart);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3546);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::UNBOUNDED_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3532);
        match(MySQLParser::UNBOUNDED_SYMBOL);
        setState(3533);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::INT_NUMBER:
      case MySQLParser::LONG_NUMBER:
      case MySQLParser::ULONGLONG_NUMBER:
      case MySQLParser::DECIMAL_NUMBER:
      case MySQLParser::FLOAT_NUMBER: {
        enterOuterAlt(_localctx, 2);
        setState(3534);
        ulonglong_number();
        setState(3535);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::PARAM_MARKER: {
        enterOuterAlt(_localctx, 3);
        setState(3537);
        match(MySQLParser::PARAM_MARKER);
        setState(3538);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::INTERVAL_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(3539);
        match(MySQLParser::INTERVAL_SYMBOL);
        setState(3540);
        expr(0);
        setState(3541);
        interval();
        setState(3542);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::CURRENT_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(3544);
        match(MySQLParser::CURRENT_SYMBOL);
        setState(3545);
        match(MySQLParser::ROW_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameBetweenContext ------------------------------------------------------------------

MySQLParser::WindowFrameBetweenContext::WindowFrameBetweenContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameBetweenContext::BETWEEN_SYMBOL() {
  return getToken(MySQLParser::BETWEEN_SYMBOL, 0);
}

std::vector<MySQLParser::WindowFrameBoundContext *> MySQLParser::WindowFrameBetweenContext::windowFrameBound() {
  return getRuleContexts<MySQLParser::WindowFrameBoundContext>();
}

MySQLParser::WindowFrameBoundContext* MySQLParser::WindowFrameBetweenContext::windowFrameBound(size_t i) {
  return getRuleContext<MySQLParser::WindowFrameBoundContext>(i);
}

tree::TerminalNode* MySQLParser::WindowFrameBetweenContext::AND_SYMBOL() {
  return getToken(MySQLParser::AND_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameBetweenContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameBetween;
}

void MySQLParser::WindowFrameBetweenContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameBetween(this);
}

void MySQLParser::WindowFrameBetweenContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameBetween(this);
}


std::any MySQLParser::WindowFrameBetweenContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameBetween(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameBetweenContext* MySQLParser::windowFrameBetween() {
  WindowFrameBetweenContext *_localctx = _tracker.createInstance<WindowFrameBetweenContext>(_ctx, getState());
  enterRule(_localctx, 344, MySQLParser::RuleWindowFrameBetween);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3548);
    match(MySQLParser::BETWEEN_SYMBOL);
    setState(3549);
    windowFrameBound();
    setState(3550);
    match(MySQLParser::AND_SYMBOL);
    setState(3551);
    windowFrameBound();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameBoundContext ------------------------------------------------------------------

MySQLParser::WindowFrameBoundContext::WindowFrameBoundContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameStartContext* MySQLParser::WindowFrameBoundContext::windowFrameStart() {
  return getRuleContext<MySQLParser::WindowFrameStartContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::UNBOUNDED_SYMBOL() {
  return getToken(MySQLParser::UNBOUNDED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::FOLLOWING_SYMBOL() {
  return getToken(MySQLParser::FOLLOWING_SYMBOL, 0);
}

MySQLParser::Ulonglong_numberContext* MySQLParser::WindowFrameBoundContext::ulonglong_number() {
  return getRuleContext<MySQLParser::Ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::INTERVAL_SYMBOL() {
  return getToken(MySQLParser::INTERVAL_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::WindowFrameBoundContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::IntervalContext* MySQLParser::WindowFrameBoundContext::interval() {
  return getRuleContext<MySQLParser::IntervalContext>(0);
}


size_t MySQLParser::WindowFrameBoundContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameBound;
}

void MySQLParser::WindowFrameBoundContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameBound(this);
}

void MySQLParser::WindowFrameBoundContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameBound(this);
}


std::any MySQLParser::WindowFrameBoundContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameBound(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameBoundContext* MySQLParser::windowFrameBound() {
  WindowFrameBoundContext *_localctx = _tracker.createInstance<WindowFrameBoundContext>(_ctx, getState());
  enterRule(_localctx, 346, MySQLParser::RuleWindowFrameBound);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3566);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 332, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3553);
      windowFrameStart();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3554);
      match(MySQLParser::UNBOUNDED_SYMBOL);
      setState(3555);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3556);
      ulonglong_number();
      setState(3557);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(3559);
      match(MySQLParser::PARAM_MARKER);
      setState(3560);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(3561);
      match(MySQLParser::INTERVAL_SYMBOL);
      setState(3562);
      expr(0);
      setState(3563);
      interval();
      setState(3564);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameExclusionContext ------------------------------------------------------------------

MySQLParser::WindowFrameExclusionContext::WindowFrameExclusionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::EXCLUDE_SYMBOL() {
  return getToken(MySQLParser::EXCLUDE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::CURRENT_SYMBOL() {
  return getToken(MySQLParser::CURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::TIES_SYMBOL() {
  return getToken(MySQLParser::TIES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::OTHERS_SYMBOL() {
  return getToken(MySQLParser::OTHERS_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameExclusionContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameExclusion;
}

void MySQLParser::WindowFrameExclusionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameExclusion(this);
}

void MySQLParser::WindowFrameExclusionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameExclusion(this);
}


std::any MySQLParser::WindowFrameExclusionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameExclusion(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameExclusionContext* MySQLParser::windowFrameExclusion() {
  WindowFrameExclusionContext *_localctx = _tracker.createInstance<WindowFrameExclusionContext>(_ctx, getState());
  enterRule(_localctx, 348, MySQLParser::RuleWindowFrameExclusion);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3568);
    match(MySQLParser::EXCLUDE_SYMBOL);
    setState(3575);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::CURRENT_SYMBOL: {
        setState(3569);
        match(MySQLParser::CURRENT_SYMBOL);
        setState(3570);
        match(MySQLParser::ROW_SYMBOL);
        break;
      }

      case MySQLParser::GROUP_SYMBOL: {
        setState(3571);
        match(MySQLParser::GROUP_SYMBOL);
        break;
      }

      case MySQLParser::TIES_SYMBOL: {
        setState(3572);
        match(MySQLParser::TIES_SYMBOL);
        break;
      }

      case MySQLParser::NO_SYMBOL: {
        setState(3573);
        match(MySQLParser::NO_SYMBOL);
        setState(3574);
        match(MySQLParser::OTHERS_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WithClauseContext ------------------------------------------------------------------

MySQLParser::WithClauseContext::WithClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WithClauseContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

std::vector<MySQLParser::CommonTableExpressionContext *> MySQLParser::WithClauseContext::commonTableExpression() {
  return getRuleContexts<MySQLParser::CommonTableExpressionContext>();
}

MySQLParser::CommonTableExpressionContext* MySQLParser::WithClauseContext::commonTableExpression(size_t i) {
  return getRuleContext<MySQLParser::CommonTableExpressionContext>(i);
}

tree::TerminalNode* MySQLParser::WithClauseContext::RECURSIVE_SYMBOL() {
  return getToken(MySQLParser::RECURSIVE_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::WithClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::WithClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::WithClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWithClause;
}

void MySQLParser::WithClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWithClause(this);
}

void MySQLParser::WithClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWithClause(this);
}


std::any MySQLParser::WithClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWithClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WithClauseContext* MySQLParser::withClause() {
  WithClauseContext *_localctx = _tracker.createInstance<WithClauseContext>(_ctx, getState());
  enterRule(_localctx, 350, MySQLParser::RuleWithClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3577);
    match(MySQLParser::WITH_SYMBOL);
    setState(3579);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 334, _ctx)) {
    case 1: {
      setState(3578);
      match(MySQLParser::RECURSIVE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3581);
    commonTableExpression();
    setState(3586);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 335, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3582);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3583);
        commonTableExpression(); 
      }
      setState(3588);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 335, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CommonTableExpressionContext ------------------------------------------------------------------

MySQLParser::CommonTableExpressionContext::CommonTableExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::CommonTableExpressionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::CommonTableExpressionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::SubqueryContext* MySQLParser::CommonTableExpressionContext::subquery() {
  return getRuleContext<MySQLParser::SubqueryContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::CommonTableExpressionContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::CommonTableExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleCommonTableExpression;
}

void MySQLParser::CommonTableExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCommonTableExpression(this);
}

void MySQLParser::CommonTableExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCommonTableExpression(this);
}


std::any MySQLParser::CommonTableExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCommonTableExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CommonTableExpressionContext* MySQLParser::commonTableExpression() {
  CommonTableExpressionContext *_localctx = _tracker.createInstance<CommonTableExpressionContext>(_ctx, getState());
  enterRule(_localctx, 352, MySQLParser::RuleCommonTableExpression);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3589);
    identifier();
    setState(3591);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3590);
      columnInternalRefList();
    }
    setState(3593);
    match(MySQLParser::AS_SYMBOL);
    setState(3594);
    subquery();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- GroupByClauseContext ------------------------------------------------------------------

MySQLParser::GroupByClauseContext::GroupByClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::GroupByClauseContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}

MySQLParser::OlapOptionContext* MySQLParser::GroupByClauseContext::olapOption() {
  return getRuleContext<MySQLParser::OlapOptionContext>(0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::GroupListContext* MySQLParser::GroupByClauseContext::groupList() {
  return getRuleContext<MySQLParser::GroupListContext>(0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::ROLLUP_SYMBOL() {
  return getToken(MySQLParser::ROLLUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::CUBE_SYMBOL() {
  return getToken(MySQLParser::CUBE_SYMBOL, 0);
}


size_t MySQLParser::GroupByClauseContext::getRuleIndex() const {
  return MySQLParser::RuleGroupByClause;
}

void MySQLParser::GroupByClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterGroupByClause(this);
}

void MySQLParser::GroupByClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitGroupByClause(this);
}


std::any MySQLParser::GroupByClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitGroupByClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::GroupByClauseContext* MySQLParser::groupByClause() {
  GroupByClauseContext *_localctx = _tracker.createInstance<GroupByClauseContext>(_ctx, getState());
  enterRule(_localctx, 354, MySQLParser::RuleGroupByClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3610);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 338, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3596);
      match(MySQLParser::GROUP_SYMBOL);
      setState(3597);
      match(MySQLParser::BY_SYMBOL);
      setState(3598);
      orderList();
      setState(3600);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 337, _ctx)) {
      case 1: {
        setState(3599);
        olapOption();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3602);

      if (!(serverVersion >= 80032)) throw FailedPredicateException(this, "serverVersion >= 80032");
      setState(3603);
      match(MySQLParser::GROUP_SYMBOL);
      setState(3604);
      match(MySQLParser::BY_SYMBOL);
      setState(3605);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CUBE_SYMBOL || _la == MySQLParser::ROLLUP_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(3606);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(3607);
      groupList();
      setState(3608);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- OlapOptionContext ------------------------------------------------------------------

MySQLParser::OlapOptionContext::OlapOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::OlapOptionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OlapOptionContext::ROLLUP_SYMBOL() {
  return getToken(MySQLParser::ROLLUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OlapOptionContext::CUBE_SYMBOL() {
  return getToken(MySQLParser::CUBE_SYMBOL, 0);
}


size_t MySQLParser::OlapOptionContext::getRuleIndex() const {
  return MySQLParser::RuleOlapOption;
}

void MySQLParser::OlapOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterOlapOption(this);
}

void MySQLParser::OlapOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitOlapOption(this);
}


std::any MySQLParser::OlapOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitOlapOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::OlapOptionContext* MySQLParser::olapOption() {
  OlapOptionContext *_localctx = _tracker.createInstance<OlapOptionContext>(_ctx, getState());
  enterRule(_localctx, 356, MySQLParser::RuleOlapOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3617);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 339, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3612);
      match(MySQLParser::WITH_SYMBOL);
      setState(3613);
      match(MySQLParser::ROLLUP_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3614);

      if (!(serverVersion < 80000)) throw FailedPredicateE