﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/email/SES_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Xml
{
  class XmlNode;
} // namespace Xml
} // namespace Utils
namespace SES
{
namespace Model
{

  /**
   * <p>A domain that is used to redirect email recipients to an Amazon SES-operated
   * domain. This domain captures open and click events generated by Amazon SES
   * emails.</p> <p>For more information, see <a
   * href="ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
   * Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
   * Developer Guide</i>.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TrackingOptions">AWS
   * API Reference</a></p>
   */
  class AWS_SES_API TrackingOptions
  {
  public:
    TrackingOptions();
    TrackingOptions(const Aws::Utils::Xml::XmlNode& xmlNode);
    TrackingOptions& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

    void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
    void OutputToStream(Aws::OStream& oStream, const char* location) const;


    /**
     * <p>The custom subdomain that will be used to redirect email recipients to the
     * Amazon SES event tracking domain.</p>
     */
    inline const Aws::String& GetCustomRedirectDomain() const{ return m_customRedirectDomain; }

    /**
     * <p>The custom subdomain that will be used to redirect email recipients to the
     * Amazon SES event tracking domain.</p>
     */
    inline bool CustomRedirectDomainHasBeenSet() const { return m_customRedirectDomainHasBeenSet; }

    /**
     * <p>The custom subdomain that will be used to redirect email recipients to the
     * Amazon SES event tracking domain.</p>
     */
    inline void SetCustomRedirectDomain(const Aws::String& value) { m_customRedirectDomainHasBeenSet = true; m_customRedirectDomain = value; }

    /**
     * <p>The custom subdomain that will be used to redirect email recipients to the
     * Amazon SES event tracking domain.</p>
     */
    inline void SetCustomRedirectDomain(Aws::String&& value) { m_customRedirectDomainHasBeenSet = true; m_customRedirectDomain = std::move(value); }

    /**
     * <p>The custom subdomain that will be used to redirect email recipients to the
     * Amazon SES event tracking domain.</p>
     */
    inline void SetCustomRedirectDomain(const char* value) { m_customRedirectDomainHasBeenSet = true; m_customRedirectDomain.assign(value); }

    /**
     * <p>The custom subdomain that will be used to redirect email recipients to the
     * Amazon SES event tracking domain.</p>
     */
    inline TrackingOptions& WithCustomRedirectDomain(const Aws::String& value) { SetCustomRedirectDomain(value); return *this;}

    /**
     * <p>The custom subdomain that will be used to redirect email recipients to the
     * Amazon SES event tracking domain.</p>
     */
    inline TrackingOptions& WithCustomRedirectDomain(Aws::String&& value) { SetCustomRedirectDomain(std::move(value)); return *this;}

    /**
     * <p>The custom subdomain that will be used to redirect email recipients to the
     * Amazon SES event tracking domain.</p>
     */
    inline TrackingOptions& WithCustomRedirectDomain(const char* value) { SetCustomRedirectDomain(value); return *this;}

  private:

    Aws::String m_customRedirectDomain;
    bool m_customRedirectDomainHasBeenSet;
  };

} // namespace Model
} // namespace SES
} // namespace Aws
