﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/awstransfer/Transfer_EXPORTS.h>
#include <aws/awstransfer/TransferRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace Transfer
{
namespace Model
{

  /**
   */
  class AWS_TRANSFER_API UntagResourceRequest : public TransferRequest
  {
  public:
    UntagResourceRequest();
    
    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "UntagResource"; }

    Aws::String SerializePayload() const override;

    Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>This is the value of the resource that will have the tag removed. An Amazon
     * Resource Name (ARN) is an identifier for a specific AWS resource, such as a
     * server, user, or role.</p>
     */
    inline const Aws::String& GetArn() const{ return m_arn; }

    /**
     * <p>This is the value of the resource that will have the tag removed. An Amazon
     * Resource Name (ARN) is an identifier for a specific AWS resource, such as a
     * server, user, or role.</p>
     */
    inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }

    /**
     * <p>This is the value of the resource that will have the tag removed. An Amazon
     * Resource Name (ARN) is an identifier for a specific AWS resource, such as a
     * server, user, or role.</p>
     */
    inline void SetArn(const Aws::String& value) { m_arnHasBeenSet = true; m_arn = value; }

    /**
     * <p>This is the value of the resource that will have the tag removed. An Amazon
     * Resource Name (ARN) is an identifier for a specific AWS resource, such as a
     * server, user, or role.</p>
     */
    inline void SetArn(Aws::String&& value) { m_arnHasBeenSet = true; m_arn = std::move(value); }

    /**
     * <p>This is the value of the resource that will have the tag removed. An Amazon
     * Resource Name (ARN) is an identifier for a specific AWS resource, such as a
     * server, user, or role.</p>
     */
    inline void SetArn(const char* value) { m_arnHasBeenSet = true; m_arn.assign(value); }

    /**
     * <p>This is the value of the resource that will have the tag removed. An Amazon
     * Resource Name (ARN) is an identifier for a specific AWS resource, such as a
     * server, user, or role.</p>
     */
    inline UntagResourceRequest& WithArn(const Aws::String& value) { SetArn(value); return *this;}

    /**
     * <p>This is the value of the resource that will have the tag removed. An Amazon
     * Resource Name (ARN) is an identifier for a specific AWS resource, such as a
     * server, user, or role.</p>
     */
    inline UntagResourceRequest& WithArn(Aws::String&& value) { SetArn(std::move(value)); return *this;}

    /**
     * <p>This is the value of the resource that will have the tag removed. An Amazon
     * Resource Name (ARN) is an identifier for a specific AWS resource, such as a
     * server, user, or role.</p>
     */
    inline UntagResourceRequest& WithArn(const char* value) { SetArn(value); return *this;}


    /**
     * <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and
     * search for resources by type. This metadata can be attached to resources for any
     * purpose.</p>
     */
    inline const Aws::Vector<Aws::String>& GetTagKeys() const{ return m_tagKeys; }

    /**
     * <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and
     * search for resources by type. This metadata can be attached to resources for any
     * purpose.</p>
     */
    inline bool TagKeysHasBeenSet() const { return m_tagKeysHasBeenSet; }

    /**
     * <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and
     * search for resources by type. This metadata can be attached to resources for any
     * purpose.</p>
     */
    inline void SetTagKeys(const Aws::Vector<Aws::String>& value) { m_tagKeysHasBeenSet = true; m_tagKeys = value; }

    /**
     * <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and
     * search for resources by type. This metadata can be attached to resources for any
     * purpose.</p>
     */
    inline void SetTagKeys(Aws::Vector<Aws::String>&& value) { m_tagKeysHasBeenSet = true; m_tagKeys = std::move(value); }

    /**
     * <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and
     * search for resources by type. This metadata can be attached to resources for any
     * purpose.</p>
     */
    inline UntagResourceRequest& WithTagKeys(const Aws::Vector<Aws::String>& value) { SetTagKeys(value); return *this;}

    /**
     * <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and
     * search for resources by type. This metadata can be attached to resources for any
     * purpose.</p>
     */
    inline UntagResourceRequest& WithTagKeys(Aws::Vector<Aws::String>&& value) { SetTagKeys(std::move(value)); return *this;}

    /**
     * <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and
     * search for resources by type. This metadata can be attached to resources for any
     * purpose.</p>
     */
    inline UntagResourceRequest& AddTagKeys(const Aws::String& value) { m_tagKeysHasBeenSet = true; m_tagKeys.push_back(value); return *this; }

    /**
     * <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and
     * search for resources by type. This metadata can be attached to resources for any
     * purpose.</p>
     */
    inline UntagResourceRequest& AddTagKeys(Aws::String&& value) { m_tagKeysHasBeenSet = true; m_tagKeys.push_back(std::move(value)); return *this; }

    /**
     * <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and
     * search for resources by type. This metadata can be attached to resources for any
     * purpose.</p>
     */
    inline UntagResourceRequest& AddTagKeys(const char* value) { m_tagKeysHasBeenSet = true; m_tagKeys.push_back(value); return *this; }

  private:

    Aws::String m_arn;
    bool m_arnHasBeenSet;

    Aws::Vector<Aws::String> m_tagKeys;
    bool m_tagKeysHasBeenSet;
  };

} // namespace Model
} // namespace Transfer
} // namespace Aws
