﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/rekognition/model/CompareFacesRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Rekognition::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

CompareFacesRequest::CompareFacesRequest() : 
    m_sourceImageHasBeenSet(false),
    m_targetImageHasBeenSet(false),
    m_similarityThreshold(0.0),
    m_similarityThresholdHasBeenSet(false)
{
}

Aws::String CompareFacesRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_sourceImageHasBeenSet)
  {
   payload.WithObject("SourceImage", m_sourceImage.Jsonize());

  }

  if(m_targetImageHasBeenSet)
  {
   payload.WithObject("TargetImage", m_targetImage.Jsonize());

  }

  if(m_similarityThresholdHasBeenSet)
  {
   payload.WithDouble("SimilarityThreshold", m_similarityThreshold);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CompareFacesRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "RekognitionService.CompareFaces"));
  return headers;

}




