﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/pinpoint-email/model/Destination.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace PinpointEmail
{
namespace Model
{

Destination::Destination() : 
    m_toAddressesHasBeenSet(false),
    m_ccAddressesHasBeenSet(false),
    m_bccAddressesHasBeenSet(false)
{
}

Destination::Destination(JsonView jsonValue) : 
    m_toAddressesHasBeenSet(false),
    m_ccAddressesHasBeenSet(false),
    m_bccAddressesHasBeenSet(false)
{
  *this = jsonValue;
}

Destination& Destination::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("ToAddresses"))
  {
    Array<JsonView> toAddressesJsonList = jsonValue.GetArray("ToAddresses");
    for(unsigned toAddressesIndex = 0; toAddressesIndex < toAddressesJsonList.GetLength(); ++toAddressesIndex)
    {
      m_toAddresses.push_back(toAddressesJsonList[toAddressesIndex].AsString());
    }
    m_toAddressesHasBeenSet = true;
  }

  if(jsonValue.ValueExists("CcAddresses"))
  {
    Array<JsonView> ccAddressesJsonList = jsonValue.GetArray("CcAddresses");
    for(unsigned ccAddressesIndex = 0; ccAddressesIndex < ccAddressesJsonList.GetLength(); ++ccAddressesIndex)
    {
      m_ccAddresses.push_back(ccAddressesJsonList[ccAddressesIndex].AsString());
    }
    m_ccAddressesHasBeenSet = true;
  }

  if(jsonValue.ValueExists("BccAddresses"))
  {
    Array<JsonView> bccAddressesJsonList = jsonValue.GetArray("BccAddresses");
    for(unsigned bccAddressesIndex = 0; bccAddressesIndex < bccAddressesJsonList.GetLength(); ++bccAddressesIndex)
    {
      m_bccAddresses.push_back(bccAddressesJsonList[bccAddressesIndex].AsString());
    }
    m_bccAddressesHasBeenSet = true;
  }

  return *this;
}

JsonValue Destination::Jsonize() const
{
  JsonValue payload;

  if(m_toAddressesHasBeenSet)
  {
   Array<JsonValue> toAddressesJsonList(m_toAddresses.size());
   for(unsigned toAddressesIndex = 0; toAddressesIndex < toAddressesJsonList.GetLength(); ++toAddressesIndex)
   {
     toAddressesJsonList[toAddressesIndex].AsString(m_toAddresses[toAddressesIndex]);
   }
   payload.WithArray("ToAddresses", std::move(toAddressesJsonList));

  }

  if(m_ccAddressesHasBeenSet)
  {
   Array<JsonValue> ccAddressesJsonList(m_ccAddresses.size());
   for(unsigned ccAddressesIndex = 0; ccAddressesIndex < ccAddressesJsonList.GetLength(); ++ccAddressesIndex)
   {
     ccAddressesJsonList[ccAddressesIndex].AsString(m_ccAddresses[ccAddressesIndex]);
   }
   payload.WithArray("CcAddresses", std::move(ccAddressesJsonList));

  }

  if(m_bccAddressesHasBeenSet)
  {
   Array<JsonValue> bccAddressesJsonList(m_bccAddresses.size());
   for(unsigned bccAddressesIndex = 0; bccAddressesIndex < bccAddressesJsonList.GetLength(); ++bccAddressesIndex)
   {
     bccAddressesJsonList[bccAddressesIndex].AsString(m_bccAddresses[bccAddressesIndex]);
   }
   payload.WithArray("BccAddresses", std::move(bccAddressesJsonList));

  }

  return payload;
}

} // namespace Model
} // namespace PinpointEmail
} // namespace Aws
