﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/macie2/model/BucketLevelPermissions.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Macie2
{
namespace Model
{

BucketLevelPermissions::BucketLevelPermissions() : 
    m_accessControlListHasBeenSet(false),
    m_blockPublicAccessHasBeenSet(false),
    m_bucketPolicyHasBeenSet(false)
{
}

BucketLevelPermissions::BucketLevelPermissions(JsonView jsonValue) : 
    m_accessControlListHasBeenSet(false),
    m_blockPublicAccessHasBeenSet(false),
    m_bucketPolicyHasBeenSet(false)
{
  *this = jsonValue;
}

BucketLevelPermissions& BucketLevelPermissions::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("accessControlList"))
  {
    m_accessControlList = jsonValue.GetObject("accessControlList");

    m_accessControlListHasBeenSet = true;
  }

  if(jsonValue.ValueExists("blockPublicAccess"))
  {
    m_blockPublicAccess = jsonValue.GetObject("blockPublicAccess");

    m_blockPublicAccessHasBeenSet = true;
  }

  if(jsonValue.ValueExists("bucketPolicy"))
  {
    m_bucketPolicy = jsonValue.GetObject("bucketPolicy");

    m_bucketPolicyHasBeenSet = true;
  }

  return *this;
}

JsonValue BucketLevelPermissions::Jsonize() const
{
  JsonValue payload;

  if(m_accessControlListHasBeenSet)
  {
   payload.WithObject("accessControlList", m_accessControlList.Jsonize());

  }

  if(m_blockPublicAccessHasBeenSet)
  {
   payload.WithObject("blockPublicAccess", m_blockPublicAccess.Jsonize());

  }

  if(m_bucketPolicyHasBeenSet)
  {
   payload.WithObject("bucketPolicy", m_bucketPolicy.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace Macie2
} // namespace Aws
