﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/sesv2/model/SuppressionAttributes.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace SESV2
{
namespace Model
{

SuppressionAttributes::SuppressionAttributes() : 
    m_suppressedReasonsHasBeenSet(false)
{
}

SuppressionAttributes::SuppressionAttributes(JsonView jsonValue) : 
    m_suppressedReasonsHasBeenSet(false)
{
  *this = jsonValue;
}

SuppressionAttributes& SuppressionAttributes::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("SuppressedReasons"))
  {
    Array<JsonView> suppressedReasonsJsonList = jsonValue.GetArray("SuppressedReasons");
    for(unsigned suppressedReasonsIndex = 0; suppressedReasonsIndex < suppressedReasonsJsonList.GetLength(); ++suppressedReasonsIndex)
    {
      m_suppressedReasons.push_back(SuppressionListReasonMapper::GetSuppressionListReasonForName(suppressedReasonsJsonList[suppressedReasonsIndex].AsString()));
    }
    m_suppressedReasonsHasBeenSet = true;
  }

  return *this;
}

JsonValue SuppressionAttributes::Jsonize() const
{
  JsonValue payload;

  if(m_suppressedReasonsHasBeenSet)
  {
   Array<JsonValue> suppressedReasonsJsonList(m_suppressedReasons.size());
   for(unsigned suppressedReasonsIndex = 0; suppressedReasonsIndex < suppressedReasonsJsonList.GetLength(); ++suppressedReasonsIndex)
   {
     suppressedReasonsJsonList[suppressedReasonsIndex].AsString(SuppressionListReasonMapper::GetNameForSuppressionListReason(m_suppressedReasons[suppressedReasonsIndex]));
   }
   payload.WithArray("SuppressedReasons", std::move(suppressedReasonsJsonList));

  }

  return payload;
}

} // namespace Model
} // namespace SESV2
} // namespace Aws
