﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>A vendor that generates a vulnerability report.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/VulnerabilityVendor">AWS
   * API Reference</a></p>
   */
  class AWS_SECURITYHUB_API VulnerabilityVendor
  {
  public:
    VulnerabilityVendor();
    VulnerabilityVendor(Aws::Utils::Json::JsonView jsonValue);
    VulnerabilityVendor& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The name of the vendor.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }

    /**
     * <p>The name of the vendor.</p>
     */
    inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }

    /**
     * <p>The name of the vendor.</p>
     */
    inline void SetName(const Aws::String& value) { m_nameHasBeenSet = true; m_name = value; }

    /**
     * <p>The name of the vendor.</p>
     */
    inline void SetName(Aws::String&& value) { m_nameHasBeenSet = true; m_name = std::move(value); }

    /**
     * <p>The name of the vendor.</p>
     */
    inline void SetName(const char* value) { m_nameHasBeenSet = true; m_name.assign(value); }

    /**
     * <p>The name of the vendor.</p>
     */
    inline VulnerabilityVendor& WithName(const Aws::String& value) { SetName(value); return *this;}

    /**
     * <p>The name of the vendor.</p>
     */
    inline VulnerabilityVendor& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}

    /**
     * <p>The name of the vendor.</p>
     */
    inline VulnerabilityVendor& WithName(const char* value) { SetName(value); return *this;}


    /**
     * <p>The URL of the vulnerability advisory.</p>
     */
    inline const Aws::String& GetUrl() const{ return m_url; }

    /**
     * <p>The URL of the vulnerability advisory.</p>
     */
    inline bool UrlHasBeenSet() const { return m_urlHasBeenSet; }

    /**
     * <p>The URL of the vulnerability advisory.</p>
     */
    inline void SetUrl(const Aws::String& value) { m_urlHasBeenSet = true; m_url = value; }

    /**
     * <p>The URL of the vulnerability advisory.</p>
     */
    inline void SetUrl(Aws::String&& value) { m_urlHasBeenSet = true; m_url = std::move(value); }

    /**
     * <p>The URL of the vulnerability advisory.</p>
     */
    inline void SetUrl(const char* value) { m_urlHasBeenSet = true; m_url.assign(value); }

    /**
     * <p>The URL of the vulnerability advisory.</p>
     */
    inline VulnerabilityVendor& WithUrl(const Aws::String& value) { SetUrl(value); return *this;}

    /**
     * <p>The URL of the vulnerability advisory.</p>
     */
    inline VulnerabilityVendor& WithUrl(Aws::String&& value) { SetUrl(std::move(value)); return *this;}

    /**
     * <p>The URL of the vulnerability advisory.</p>
     */
    inline VulnerabilityVendor& WithUrl(const char* value) { SetUrl(value); return *this;}


    /**
     * <p>The severity that the vendor assigned to the vulnerability.</p>
     */
    inline const Aws::String& GetVendorSeverity() const{ return m_vendorSeverity; }

    /**
     * <p>The severity that the vendor assigned to the vulnerability.</p>
     */
    inline bool VendorSeverityHasBeenSet() const { return m_vendorSeverityHasBeenSet; }

    /**
     * <p>The severity that the vendor assigned to the vulnerability.</p>
     */
    inline void SetVendorSeverity(const Aws::String& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = value; }

    /**
     * <p>The severity that the vendor assigned to the vulnerability.</p>
     */
    inline void SetVendorSeverity(Aws::String&& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = std::move(value); }

    /**
     * <p>The severity that the vendor assigned to the vulnerability.</p>
     */
    inline void SetVendorSeverity(const char* value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity.assign(value); }

    /**
     * <p>The severity that the vendor assigned to the vulnerability.</p>
     */
    inline VulnerabilityVendor& WithVendorSeverity(const Aws::String& value) { SetVendorSeverity(value); return *this;}

    /**
     * <p>The severity that the vendor assigned to the vulnerability.</p>
     */
    inline VulnerabilityVendor& WithVendorSeverity(Aws::String&& value) { SetVendorSeverity(std::move(value)); return *this;}

    /**
     * <p>The severity that the vendor assigned to the vulnerability.</p>
     */
    inline VulnerabilityVendor& WithVendorSeverity(const char* value) { SetVendorSeverity(value); return *this;}


    /**
     * <p>Indicates when the vulnerability advisory was created.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline const Aws::String& GetVendorCreatedAt() const{ return m_vendorCreatedAt; }

    /**
     * <p>Indicates when the vulnerability advisory was created.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline bool VendorCreatedAtHasBeenSet() const { return m_vendorCreatedAtHasBeenSet; }

    /**
     * <p>Indicates when the vulnerability advisory was created.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline void SetVendorCreatedAt(const Aws::String& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = value; }

    /**
     * <p>Indicates when the vulnerability advisory was created.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline void SetVendorCreatedAt(Aws::String&& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = std::move(value); }

    /**
     * <p>Indicates when the vulnerability advisory was created.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline void SetVendorCreatedAt(const char* value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt.assign(value); }

    /**
     * <p>Indicates when the vulnerability advisory was created.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline VulnerabilityVendor& WithVendorCreatedAt(const Aws::String& value) { SetVendorCreatedAt(value); return *this;}

    /**
     * <p>Indicates when the vulnerability advisory was created.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline VulnerabilityVendor& WithVendorCreatedAt(Aws::String&& value) { SetVendorCreatedAt(std::move(value)); return *this;}

    /**
     * <p>Indicates when the vulnerability advisory was created.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline VulnerabilityVendor& WithVendorCreatedAt(const char* value) { SetVendorCreatedAt(value); return *this;}


    /**
     * <p>Indicates when the vulnerability advisory was last updated.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline const Aws::String& GetVendorUpdatedAt() const{ return m_vendorUpdatedAt; }

    /**
     * <p>Indicates when the vulnerability advisory was last updated.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline bool VendorUpdatedAtHasBeenSet() const { return m_vendorUpdatedAtHasBeenSet; }

    /**
     * <p>Indicates when the vulnerability advisory was last updated.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline void SetVendorUpdatedAt(const Aws::String& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = value; }

    /**
     * <p>Indicates when the vulnerability advisory was last updated.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline void SetVendorUpdatedAt(Aws::String&& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = std::move(value); }

    /**
     * <p>Indicates when the vulnerability advisory was last updated.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline void SetVendorUpdatedAt(const char* value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt.assign(value); }

    /**
     * <p>Indicates when the vulnerability advisory was last updated.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline VulnerabilityVendor& WithVendorUpdatedAt(const Aws::String& value) { SetVendorUpdatedAt(value); return *this;}

    /**
     * <p>Indicates when the vulnerability advisory was last updated.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline VulnerabilityVendor& WithVendorUpdatedAt(Aws::String&& value) { SetVendorUpdatedAt(std::move(value)); return *this;}

    /**
     * <p>Indicates when the vulnerability advisory was last updated.</p> <p>Uses the
     * <code>date-time</code> format specified in <a
     * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6,
     * Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.</p>
     */
    inline VulnerabilityVendor& WithVendorUpdatedAt(const char* value) { SetVendorUpdatedAt(value); return *this;}

  private:

    Aws::String m_name;
    bool m_nameHasBeenSet;

    Aws::String m_url;
    bool m_urlHasBeenSet;

    Aws::String m_vendorSeverity;
    bool m_vendorSeverityHasBeenSet;

    Aws::String m_vendorCreatedAt;
    bool m_vendorCreatedAtHasBeenSet;

    Aws::String m_vendorUpdatedAt;
    bool m_vendorUpdatedAtHasBeenSet;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
