﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/alexaforbusiness/model/DeleteConferenceProviderRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::AlexaForBusiness::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

DeleteConferenceProviderRequest::DeleteConferenceProviderRequest() : 
    m_conferenceProviderArnHasBeenSet(false)
{
}

Aws::String DeleteConferenceProviderRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_conferenceProviderArnHasBeenSet)
  {
   payload.WithString("ConferenceProviderArn", m_conferenceProviderArn);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteConferenceProviderRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AlexaForBusiness.DeleteConferenceProvider"));
  return headers;

}




