﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/logs/model/PutLogEventsResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::CloudWatchLogs::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

PutLogEventsResult::PutLogEventsResult()
{
}

PutLogEventsResult::PutLogEventsResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

PutLogEventsResult& PutLogEventsResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("nextSequenceToken"))
  {
    m_nextSequenceToken = jsonValue.GetString("nextSequenceToken");

  }

  if(jsonValue.ValueExists("rejectedLogEventsInfo"))
  {
    m_rejectedLogEventsInfo = jsonValue.GetObject("rejectedLogEventsInfo");

  }



  return *this;
}
