﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/mediapackage/model/MssEncryption.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace MediaPackage
{
namespace Model
{

MssEncryption::MssEncryption() : 
    m_spekeKeyProviderHasBeenSet(false)
{
}

MssEncryption::MssEncryption(JsonView jsonValue) : 
    m_spekeKeyProviderHasBeenSet(false)
{
  *this = jsonValue;
}

MssEncryption& MssEncryption::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("spekeKeyProvider"))
  {
    m_spekeKeyProvider = jsonValue.GetObject("spekeKeyProvider");

    m_spekeKeyProviderHasBeenSet = true;
  }

  return *this;
}

JsonValue MssEncryption::Jsonize() const
{
  JsonValue payload;

  if(m_spekeKeyProviderHasBeenSet)
  {
   payload.WithObject("spekeKeyProvider", m_spekeKeyProvider.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace MediaPackage
} // namespace Aws
