﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/CreateUseCaseResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::Connect::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreateUseCaseResult::CreateUseCaseResult()
{
}

CreateUseCaseResult::CreateUseCaseResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

CreateUseCaseResult& CreateUseCaseResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("UseCaseId"))
  {
    m_useCaseId = jsonValue.GetString("UseCaseId");

  }

  if(jsonValue.ValueExists("UseCaseArn"))
  {
    m_useCaseArn = jsonValue.GetString("UseCaseArn");

  }



  return *this;
}
