﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CustomerProfiles
{
namespace Model
{

  /**
   * <p>A ProfileObject in a list of ProfileObjects.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectsItem">AWS
   * API Reference</a></p>
   */
  class AWS_CUSTOMERPROFILES_API ListProfileObjectsItem
  {
  public:
    ListProfileObjectsItem();
    ListProfileObjectsItem(Aws::Utils::Json::JsonView jsonValue);
    ListProfileObjectsItem& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Specifies the kind of object being added to a profile, such as
     * "Salesforce-Account."</p>
     */
    inline const Aws::String& GetObjectTypeName() const{ return m_objectTypeName; }

    /**
     * <p>Specifies the kind of object being added to a profile, such as
     * "Salesforce-Account."</p>
     */
    inline bool ObjectTypeNameHasBeenSet() const { return m_objectTypeNameHasBeenSet; }

    /**
     * <p>Specifies the kind of object being added to a profile, such as
     * "Salesforce-Account."</p>
     */
    inline void SetObjectTypeName(const Aws::String& value) { m_objectTypeNameHasBeenSet = true; m_objectTypeName = value; }

    /**
     * <p>Specifies the kind of object being added to a profile, such as
     * "Salesforce-Account."</p>
     */
    inline void SetObjectTypeName(Aws::String&& value) { m_objectTypeNameHasBeenSet = true; m_objectTypeName = std::move(value); }

    /**
     * <p>Specifies the kind of object being added to a profile, such as
     * "Salesforce-Account."</p>
     */
    inline void SetObjectTypeName(const char* value) { m_objectTypeNameHasBeenSet = true; m_objectTypeName.assign(value); }

    /**
     * <p>Specifies the kind of object being added to a profile, such as
     * "Salesforce-Account."</p>
     */
    inline ListProfileObjectsItem& WithObjectTypeName(const Aws::String& value) { SetObjectTypeName(value); return *this;}

    /**
     * <p>Specifies the kind of object being added to a profile, such as
     * "Salesforce-Account."</p>
     */
    inline ListProfileObjectsItem& WithObjectTypeName(Aws::String&& value) { SetObjectTypeName(std::move(value)); return *this;}

    /**
     * <p>Specifies the kind of object being added to a profile, such as
     * "Salesforce-Account."</p>
     */
    inline ListProfileObjectsItem& WithObjectTypeName(const char* value) { SetObjectTypeName(value); return *this;}


    /**
     * <p>The unique identifier of the ProfileObject generated by the service.</p>
     */
    inline const Aws::String& GetProfileObjectUniqueKey() const{ return m_profileObjectUniqueKey; }

    /**
     * <p>The unique identifier of the ProfileObject generated by the service.</p>
     */
    inline bool ProfileObjectUniqueKeyHasBeenSet() const { return m_profileObjectUniqueKeyHasBeenSet; }

    /**
     * <p>The unique identifier of the ProfileObject generated by the service.</p>
     */
    inline void SetProfileObjectUniqueKey(const Aws::String& value) { m_profileObjectUniqueKeyHasBeenSet = true; m_profileObjectUniqueKey = value; }

    /**
     * <p>The unique identifier of the ProfileObject generated by the service.</p>
     */
    inline void SetProfileObjectUniqueKey(Aws::String&& value) { m_profileObjectUniqueKeyHasBeenSet = true; m_profileObjectUniqueKey = std::move(value); }

    /**
     * <p>The unique identifier of the ProfileObject generated by the service.</p>
     */
    inline void SetProfileObjectUniqueKey(const char* value) { m_profileObjectUniqueKeyHasBeenSet = true; m_profileObjectUniqueKey.assign(value); }

    /**
     * <p>The unique identifier of the ProfileObject generated by the service.</p>
     */
    inline ListProfileObjectsItem& WithProfileObjectUniqueKey(const Aws::String& value) { SetProfileObjectUniqueKey(value); return *this;}

    /**
     * <p>The unique identifier of the ProfileObject generated by the service.</p>
     */
    inline ListProfileObjectsItem& WithProfileObjectUniqueKey(Aws::String&& value) { SetProfileObjectUniqueKey(std::move(value)); return *this;}

    /**
     * <p>The unique identifier of the ProfileObject generated by the service.</p>
     */
    inline ListProfileObjectsItem& WithProfileObjectUniqueKey(const char* value) { SetProfileObjectUniqueKey(value); return *this;}


    /**
     * <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
     */
    inline const Aws::String& GetObject() const{ return m_object; }

    /**
     * <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
     */
    inline bool ObjectHasBeenSet() const { return m_objectHasBeenSet; }

    /**
     * <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
     */
    inline void SetObject(const Aws::String& value) { m_objectHasBeenSet = true; m_object = value; }

    /**
     * <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
     */
    inline void SetObject(Aws::String&& value) { m_objectHasBeenSet = true; m_object = std::move(value); }

    /**
     * <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
     */
    inline void SetObject(const char* value) { m_objectHasBeenSet = true; m_object.assign(value); }

    /**
     * <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
     */
    inline ListProfileObjectsItem& WithObject(const Aws::String& value) { SetObject(value); return *this;}

    /**
     * <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
     */
    inline ListProfileObjectsItem& WithObject(Aws::String&& value) { SetObject(std::move(value)); return *this;}

    /**
     * <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
     */
    inline ListProfileObjectsItem& WithObject(const char* value) { SetObject(value); return *this;}

  private:

    Aws::String m_objectTypeName;
    bool m_objectTypeNameHasBeenSet;

    Aws::String m_profileObjectUniqueKey;
    bool m_profileObjectUniqueKeyHasBeenSet;

    Aws::String m_object;
    bool m_objectHasBeenSet;
  };

} // namespace Model
} // namespace CustomerProfiles
} // namespace Aws
