// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssmcontacts

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptPage = "AcceptPage"

// AcceptPageRequest generates a "aws/request.Request" representing the
// client's request for the AcceptPage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptPage for more information on using the AcceptPage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptPageRequest method.
//	req, resp := client.AcceptPageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/AcceptPage
func (c *SSMContacts) AcceptPageRequest(input *AcceptPageInput) (req *request.Request, output *AcceptPageOutput) {
	op := &request.Operation{
		Name:       opAcceptPage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptPageInput{}
	}

	output = &AcceptPageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptPage API operation for AWS Systems Manager Incident Manager Contacts.
//
// Used to acknowledge an engagement to a contact channel during an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation AcceptPage for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/AcceptPage
func (c *SSMContacts) AcceptPage(input *AcceptPageInput) (*AcceptPageOutput, error) {
	req, out := c.AcceptPageRequest(input)
	return out, req.Send()
}

// AcceptPageWithContext is the same as AcceptPage with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptPage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) AcceptPageWithContext(ctx aws.Context, input *AcceptPageInput, opts ...request.Option) (*AcceptPageOutput, error) {
	req, out := c.AcceptPageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opActivateContactChannel = "ActivateContactChannel"

// ActivateContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the ActivateContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateContactChannel for more information on using the ActivateContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ActivateContactChannelRequest method.
//	req, resp := client.ActivateContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ActivateContactChannel
func (c *SSMContacts) ActivateContactChannelRequest(input *ActivateContactChannelInput) (req *request.Request, output *ActivateContactChannelOutput) {
	op := &request.Operation{
		Name:       opActivateContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateContactChannelInput{}
	}

	output = &ActivateContactChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ActivateContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// Activates a contact's contact channel. Incident Manager can't engage a contact
// until the contact channel has been activated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ActivateContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ActivateContactChannel
func (c *SSMContacts) ActivateContactChannel(input *ActivateContactChannelInput) (*ActivateContactChannelOutput, error) {
	req, out := c.ActivateContactChannelRequest(input)
	return out, req.Send()
}

// ActivateContactChannelWithContext is the same as ActivateContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ActivateContactChannelWithContext(ctx aws.Context, input *ActivateContactChannelInput, opts ...request.Option) (*ActivateContactChannelOutput, error) {
	req, out := c.ActivateContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContact = "CreateContact"

// CreateContactRequest generates a "aws/request.Request" representing the
// client's request for the CreateContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContact for more information on using the CreateContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateContactRequest method.
//	req, resp := client.CreateContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContact
func (c *SSMContacts) CreateContactRequest(input *CreateContactInput) (req *request.Request, output *CreateContactOutput) {
	op := &request.Operation{
		Name:       opCreateContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContactInput{}
	}

	output = &CreateContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// Contacts are either the contacts that Incident Manager engages during an
// incident or the escalation plans that Incident Manager uses to engage contacts
// in phases during an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation CreateContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContact
func (c *SSMContacts) CreateContact(input *CreateContactInput) (*CreateContactOutput, error) {
	req, out := c.CreateContactRequest(input)
	return out, req.Send()
}

// CreateContactWithContext is the same as CreateContact with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) CreateContactWithContext(ctx aws.Context, input *CreateContactInput, opts ...request.Option) (*CreateContactOutput, error) {
	req, out := c.CreateContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContactChannel = "CreateContactChannel"

// CreateContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContactChannel for more information on using the CreateContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateContactChannelRequest method.
//	req, resp := client.CreateContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContactChannel
func (c *SSMContacts) CreateContactChannelRequest(input *CreateContactChannelInput) (req *request.Request, output *CreateContactChannelOutput) {
	op := &request.Operation{
		Name:       opCreateContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContactChannelInput{}
	}

	output = &CreateContactChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// A contact channel is the method that Incident Manager uses to engage your
// contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation CreateContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContactChannel
func (c *SSMContacts) CreateContactChannel(input *CreateContactChannelInput) (*CreateContactChannelOutput, error) {
	req, out := c.CreateContactChannelRequest(input)
	return out, req.Send()
}

// CreateContactChannelWithContext is the same as CreateContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) CreateContactChannelWithContext(ctx aws.Context, input *CreateContactChannelInput, opts ...request.Option) (*CreateContactChannelOutput, error) {
	req, out := c.CreateContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeactivateContactChannel = "DeactivateContactChannel"

// DeactivateContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeactivateContactChannel for more information on using the DeactivateContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeactivateContactChannelRequest method.
//	req, resp := client.DeactivateContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeactivateContactChannel
func (c *SSMContacts) DeactivateContactChannelRequest(input *DeactivateContactChannelInput) (req *request.Request, output *DeactivateContactChannelOutput) {
	op := &request.Operation{
		Name:       opDeactivateContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeactivateContactChannelInput{}
	}

	output = &DeactivateContactChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeactivateContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// To no longer receive Incident Manager engagements to a contact channel, you
// can deactivate the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DeactivateContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeactivateContactChannel
func (c *SSMContacts) DeactivateContactChannel(input *DeactivateContactChannelInput) (*DeactivateContactChannelOutput, error) {
	req, out := c.DeactivateContactChannelRequest(input)
	return out, req.Send()
}

// DeactivateContactChannelWithContext is the same as DeactivateContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeactivateContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DeactivateContactChannelWithContext(ctx aws.Context, input *DeactivateContactChannelInput, opts ...request.Option) (*DeactivateContactChannelOutput, error) {
	req, out := c.DeactivateContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContact = "DeleteContact"

// DeleteContactRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContact for more information on using the DeleteContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteContactRequest method.
//	req, resp := client.DeleteContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContact
func (c *SSMContacts) DeleteContactRequest(input *DeleteContactInput) (req *request.Request, output *DeleteContactOutput) {
	op := &request.Operation{
		Name:       opDeleteContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContactInput{}
	}

	output = &DeleteContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// To remove a contact from Incident Manager, you can delete the contact. Deleting
// a contact removes them from all escalation plans and related response plans.
// Deleting an escalation plan removes it from all related response plans. You
// will have to recreate the contact and its contact channels before you can
// use it again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DeleteContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContact
func (c *SSMContacts) DeleteContact(input *DeleteContactInput) (*DeleteContactOutput, error) {
	req, out := c.DeleteContactRequest(input)
	return out, req.Send()
}

// DeleteContactWithContext is the same as DeleteContact with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DeleteContactWithContext(ctx aws.Context, input *DeleteContactInput, opts ...request.Option) (*DeleteContactOutput, error) {
	req, out := c.DeleteContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContactChannel = "DeleteContactChannel"

// DeleteContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContactChannel for more information on using the DeleteContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteContactChannelRequest method.
//	req, resp := client.DeleteContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContactChannel
func (c *SSMContacts) DeleteContactChannelRequest(input *DeleteContactChannelInput) (req *request.Request, output *DeleteContactChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContactChannelInput{}
	}

	output = &DeleteContactChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// To no longer receive engagements on a contact channel, you can delete the
// channel from a contact. Deleting the contact channel removes it from the
// contact's engagement plan. If you delete the only contact channel for a contact,
// you won't be able to engage that contact during an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DeleteContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContactChannel
func (c *SSMContacts) DeleteContactChannel(input *DeleteContactChannelInput) (*DeleteContactChannelOutput, error) {
	req, out := c.DeleteContactChannelRequest(input)
	return out, req.Send()
}

// DeleteContactChannelWithContext is the same as DeleteContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DeleteContactChannelWithContext(ctx aws.Context, input *DeleteContactChannelInput, opts ...request.Option) (*DeleteContactChannelOutput, error) {
	req, out := c.DeleteContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEngagement = "DescribeEngagement"

// DescribeEngagementRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngagement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngagement for more information on using the DescribeEngagement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEngagementRequest method.
//	req, resp := client.DescribeEngagementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribeEngagement
func (c *SSMContacts) DescribeEngagementRequest(input *DescribeEngagementInput) (req *request.Request, output *DescribeEngagementOutput) {
	op := &request.Operation{
		Name:       opDescribeEngagement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEngagementInput{}
	}

	output = &DescribeEngagementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngagement API operation for AWS Systems Manager Incident Manager Contacts.
//
// Incident Manager uses engagements to engage contacts and escalation plans
// during an incident. Use this command to describe the engagement that occurred
// during an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DescribeEngagement for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribeEngagement
func (c *SSMContacts) DescribeEngagement(input *DescribeEngagementInput) (*DescribeEngagementOutput, error) {
	req, out := c.DescribeEngagementRequest(input)
	return out, req.Send()
}

// DescribeEngagementWithContext is the same as DescribeEngagement with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngagement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DescribeEngagementWithContext(ctx aws.Context, input *DescribeEngagementInput, opts ...request.Option) (*DescribeEngagementOutput, error) {
	req, out := c.DescribeEngagementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePage = "DescribePage"

// DescribePageRequest generates a "aws/request.Request" representing the
// client's request for the DescribePage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePage for more information on using the DescribePage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePageRequest method.
//	req, resp := client.DescribePageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribePage
func (c *SSMContacts) DescribePageRequest(input *DescribePageInput) (req *request.Request, output *DescribePageOutput) {
	op := &request.Operation{
		Name:       opDescribePage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePageInput{}
	}

	output = &DescribePageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePage API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists details of the engagement to a contact channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation DescribePage for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribePage
func (c *SSMContacts) DescribePage(input *DescribePageInput) (*DescribePageOutput, error) {
	req, out := c.DescribePageRequest(input)
	return out, req.Send()
}

// DescribePageWithContext is the same as DescribePage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) DescribePageWithContext(ctx aws.Context, input *DescribePageInput, opts ...request.Option) (*DescribePageOutput, error) {
	req, out := c.DescribePageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContact = "GetContact"

// GetContactRequest generates a "aws/request.Request" representing the
// client's request for the GetContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContact for more information on using the GetContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetContactRequest method.
//	req, resp := client.GetContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContact
func (c *SSMContacts) GetContactRequest(input *GetContactInput) (req *request.Request, output *GetContactOutput) {
	op := &request.Operation{
		Name:       opGetContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactInput{}
	}

	output = &GetContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// Retrieves information about the specified contact or escalation plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation GetContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContact
func (c *SSMContacts) GetContact(input *GetContactInput) (*GetContactOutput, error) {
	req, out := c.GetContactRequest(input)
	return out, req.Send()
}

// GetContactWithContext is the same as GetContact with the addition of
// the ability to pass a context and additional request options.
//
// See GetContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) GetContactWithContext(ctx aws.Context, input *GetContactInput, opts ...request.Option) (*GetContactOutput, error) {
	req, out := c.GetContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContactChannel = "GetContactChannel"

// GetContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContactChannel for more information on using the GetContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetContactChannelRequest method.
//	req, resp := client.GetContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactChannel
func (c *SSMContacts) GetContactChannelRequest(input *GetContactChannelInput) (req *request.Request, output *GetContactChannelOutput) {
	op := &request.Operation{
		Name:       opGetContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactChannelInput{}
	}

	output = &GetContactChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// List details about a specific contact channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation GetContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactChannel
func (c *SSMContacts) GetContactChannel(input *GetContactChannelInput) (*GetContactChannelOutput, error) {
	req, out := c.GetContactChannelRequest(input)
	return out, req.Send()
}

// GetContactChannelWithContext is the same as GetContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) GetContactChannelWithContext(ctx aws.Context, input *GetContactChannelInput, opts ...request.Option) (*GetContactChannelOutput, error) {
	req, out := c.GetContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContactPolicy = "GetContactPolicy"

// GetContactPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetContactPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContactPolicy for more information on using the GetContactPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetContactPolicyRequest method.
//	req, resp := client.GetContactPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactPolicy
func (c *SSMContacts) GetContactPolicyRequest(input *GetContactPolicyInput) (req *request.Request, output *GetContactPolicyOutput) {
	op := &request.Operation{
		Name:       opGetContactPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactPolicyInput{}
	}

	output = &GetContactPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContactPolicy API operation for AWS Systems Manager Incident Manager Contacts.
//
// Retrieves the resource policies attached to the specified contact or escalation
// plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation GetContactPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactPolicy
func (c *SSMContacts) GetContactPolicy(input *GetContactPolicyInput) (*GetContactPolicyOutput, error) {
	req, out := c.GetContactPolicyRequest(input)
	return out, req.Send()
}

// GetContactPolicyWithContext is the same as GetContactPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetContactPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) GetContactPolicyWithContext(ctx aws.Context, input *GetContactPolicyInput, opts ...request.Option) (*GetContactPolicyOutput, error) {
	req, out := c.GetContactPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListContactChannels = "ListContactChannels"

// ListContactChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListContactChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContactChannels for more information on using the ListContactChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContactChannelsRequest method.
//	req, resp := client.ListContactChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContactChannels
func (c *SSMContacts) ListContactChannelsRequest(input *ListContactChannelsInput) (req *request.Request, output *ListContactChannelsOutput) {
	op := &request.Operation{
		Name:       opListContactChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactChannelsInput{}
	}

	output = &ListContactChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContactChannels API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists all contact channels for the specified contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListContactChannels for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContactChannels
func (c *SSMContacts) ListContactChannels(input *ListContactChannelsInput) (*ListContactChannelsOutput, error) {
	req, out := c.ListContactChannelsRequest(input)
	return out, req.Send()
}

// ListContactChannelsWithContext is the same as ListContactChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListContactChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListContactChannelsWithContext(ctx aws.Context, input *ListContactChannelsInput, opts ...request.Option) (*ListContactChannelsOutput, error) {
	req, out := c.ListContactChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactChannelsPages iterates over the pages of a ListContactChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContactChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContactChannels operation.
//	pageNum := 0
//	err := client.ListContactChannelsPages(params,
//	    func(page *ssmcontacts.ListContactChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListContactChannelsPages(input *ListContactChannelsInput, fn func(*ListContactChannelsOutput, bool) bool) error {
	return c.ListContactChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactChannelsPagesWithContext same as ListContactChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListContactChannelsPagesWithContext(ctx aws.Context, input *ListContactChannelsInput, fn func(*ListContactChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContacts = "ListContacts"

// ListContactsRequest generates a "aws/request.Request" representing the
// client's request for the ListContacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContacts for more information on using the ListContacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContactsRequest method.
//	req, resp := client.ListContactsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContacts
func (c *SSMContacts) ListContactsRequest(input *ListContactsInput) (req *request.Request, output *ListContactsOutput) {
	op := &request.Operation{
		Name:       opListContacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactsInput{}
	}

	output = &ListContactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContacts API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists all contacts and escalation plans in Incident Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListContacts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContacts
func (c *SSMContacts) ListContacts(input *ListContactsInput) (*ListContactsOutput, error) {
	req, out := c.ListContactsRequest(input)
	return out, req.Send()
}

// ListContactsWithContext is the same as ListContacts with the addition of
// the ability to pass a context and additional request options.
//
// See ListContacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListContactsWithContext(ctx aws.Context, input *ListContactsInput, opts ...request.Option) (*ListContactsOutput, error) {
	req, out := c.ListContactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactsPages iterates over the pages of a ListContacts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContacts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContacts operation.
//	pageNum := 0
//	err := client.ListContactsPages(params,
//	    func(page *ssmcontacts.ListContactsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListContactsPages(input *ListContactsInput, fn func(*ListContactsOutput, bool) bool) error {
	return c.ListContactsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactsPagesWithContext same as ListContactsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListContactsPagesWithContext(ctx aws.Context, input *ListContactsInput, fn func(*ListContactsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEngagements = "ListEngagements"

// ListEngagementsRequest generates a "aws/request.Request" representing the
// client's request for the ListEngagements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEngagements for more information on using the ListEngagements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEngagementsRequest method.
//	req, resp := client.ListEngagementsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListEngagements
func (c *SSMContacts) ListEngagementsRequest(input *ListEngagementsInput) (req *request.Request, output *ListEngagementsOutput) {
	op := &request.Operation{
		Name:       opListEngagements,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEngagementsInput{}
	}

	output = &ListEngagementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEngagements API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists all engagements that have happened in an incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListEngagements for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListEngagements
func (c *SSMContacts) ListEngagements(input *ListEngagementsInput) (*ListEngagementsOutput, error) {
	req, out := c.ListEngagementsRequest(input)
	return out, req.Send()
}

// ListEngagementsWithContext is the same as ListEngagements with the addition of
// the ability to pass a context and additional request options.
//
// See ListEngagements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListEngagementsWithContext(ctx aws.Context, input *ListEngagementsInput, opts ...request.Option) (*ListEngagementsOutput, error) {
	req, out := c.ListEngagementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEngagementsPages iterates over the pages of a ListEngagements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEngagements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEngagements operation.
//	pageNum := 0
//	err := client.ListEngagementsPages(params,
//	    func(page *ssmcontacts.ListEngagementsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListEngagementsPages(input *ListEngagementsInput, fn func(*ListEngagementsOutput, bool) bool) error {
	return c.ListEngagementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEngagementsPagesWithContext same as ListEngagementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListEngagementsPagesWithContext(ctx aws.Context, input *ListEngagementsInput, fn func(*ListEngagementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEngagementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEngagementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEngagementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPageReceipts = "ListPageReceipts"

// ListPageReceiptsRequest generates a "aws/request.Request" representing the
// client's request for the ListPageReceipts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPageReceipts for more information on using the ListPageReceipts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPageReceiptsRequest method.
//	req, resp := client.ListPageReceiptsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageReceipts
func (c *SSMContacts) ListPageReceiptsRequest(input *ListPageReceiptsInput) (req *request.Request, output *ListPageReceiptsOutput) {
	op := &request.Operation{
		Name:       opListPageReceipts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPageReceiptsInput{}
	}

	output = &ListPageReceiptsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPageReceipts API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists all of the engagements to contact channels that have been acknowledged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListPageReceipts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageReceipts
func (c *SSMContacts) ListPageReceipts(input *ListPageReceiptsInput) (*ListPageReceiptsOutput, error) {
	req, out := c.ListPageReceiptsRequest(input)
	return out, req.Send()
}

// ListPageReceiptsWithContext is the same as ListPageReceipts with the addition of
// the ability to pass a context and additional request options.
//
// See ListPageReceipts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPageReceiptsWithContext(ctx aws.Context, input *ListPageReceiptsInput, opts ...request.Option) (*ListPageReceiptsOutput, error) {
	req, out := c.ListPageReceiptsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPageReceiptsPages iterates over the pages of a ListPageReceipts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPageReceipts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPageReceipts operation.
//	pageNum := 0
//	err := client.ListPageReceiptsPages(params,
//	    func(page *ssmcontacts.ListPageReceiptsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListPageReceiptsPages(input *ListPageReceiptsInput, fn func(*ListPageReceiptsOutput, bool) bool) error {
	return c.ListPageReceiptsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPageReceiptsPagesWithContext same as ListPageReceiptsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPageReceiptsPagesWithContext(ctx aws.Context, input *ListPageReceiptsInput, fn func(*ListPageReceiptsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPageReceiptsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPageReceiptsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPageReceiptsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPagesByContact = "ListPagesByContact"

// ListPagesByContactRequest generates a "aws/request.Request" representing the
// client's request for the ListPagesByContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPagesByContact for more information on using the ListPagesByContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPagesByContactRequest method.
//	req, resp := client.ListPagesByContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByContact
func (c *SSMContacts) ListPagesByContactRequest(input *ListPagesByContactInput) (req *request.Request, output *ListPagesByContactOutput) {
	op := &request.Operation{
		Name:       opListPagesByContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPagesByContactInput{}
	}

	output = &ListPagesByContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPagesByContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists the engagements to a contact's contact channels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListPagesByContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByContact
func (c *SSMContacts) ListPagesByContact(input *ListPagesByContactInput) (*ListPagesByContactOutput, error) {
	req, out := c.ListPagesByContactRequest(input)
	return out, req.Send()
}

// ListPagesByContactWithContext is the same as ListPagesByContact with the addition of
// the ability to pass a context and additional request options.
//
// See ListPagesByContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPagesByContactWithContext(ctx aws.Context, input *ListPagesByContactInput, opts ...request.Option) (*ListPagesByContactOutput, error) {
	req, out := c.ListPagesByContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPagesByContactPages iterates over the pages of a ListPagesByContact operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPagesByContact method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPagesByContact operation.
//	pageNum := 0
//	err := client.ListPagesByContactPages(params,
//	    func(page *ssmcontacts.ListPagesByContactOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListPagesByContactPages(input *ListPagesByContactInput, fn func(*ListPagesByContactOutput, bool) bool) error {
	return c.ListPagesByContactPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPagesByContactPagesWithContext same as ListPagesByContactPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPagesByContactPagesWithContext(ctx aws.Context, input *ListPagesByContactInput, fn func(*ListPagesByContactOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPagesByContactInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPagesByContactRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPagesByContactOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPagesByEngagement = "ListPagesByEngagement"

// ListPagesByEngagementRequest generates a "aws/request.Request" representing the
// client's request for the ListPagesByEngagement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPagesByEngagement for more information on using the ListPagesByEngagement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPagesByEngagementRequest method.
//	req, resp := client.ListPagesByEngagementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByEngagement
func (c *SSMContacts) ListPagesByEngagementRequest(input *ListPagesByEngagementInput) (req *request.Request, output *ListPagesByEngagementOutput) {
	op := &request.Operation{
		Name:       opListPagesByEngagement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPagesByEngagementInput{}
	}

	output = &ListPagesByEngagementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPagesByEngagement API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists the engagements to contact channels that occurred by engaging a contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListPagesByEngagement for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByEngagement
func (c *SSMContacts) ListPagesByEngagement(input *ListPagesByEngagementInput) (*ListPagesByEngagementOutput, error) {
	req, out := c.ListPagesByEngagementRequest(input)
	return out, req.Send()
}

// ListPagesByEngagementWithContext is the same as ListPagesByEngagement with the addition of
// the ability to pass a context and additional request options.
//
// See ListPagesByEngagement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPagesByEngagementWithContext(ctx aws.Context, input *ListPagesByEngagementInput, opts ...request.Option) (*ListPagesByEngagementOutput, error) {
	req, out := c.ListPagesByEngagementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPagesByEngagementPages iterates over the pages of a ListPagesByEngagement operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPagesByEngagement method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPagesByEngagement operation.
//	pageNum := 0
//	err := client.ListPagesByEngagementPages(params,
//	    func(page *ssmcontacts.ListPagesByEngagementOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSMContacts) ListPagesByEngagementPages(input *ListPagesByEngagementInput, fn func(*ListPagesByEngagementOutput, bool) bool) error {
	return c.ListPagesByEngagementPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPagesByEngagementPagesWithContext same as ListPagesByEngagementPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListPagesByEngagementPagesWithContext(ctx aws.Context, input *ListPagesByEngagementInput, fn func(*ListPagesByEngagementOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPagesByEngagementInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPagesByEngagementRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPagesByEngagementOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListTagsForResource
func (c *SSMContacts) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Systems Manager Incident Manager Contacts.
//
// Lists the tags of an escalation plan or contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListTagsForResource
func (c *SSMContacts) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutContactPolicy = "PutContactPolicy"

// PutContactPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutContactPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutContactPolicy for more information on using the PutContactPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutContactPolicyRequest method.
//	req, resp := client.PutContactPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/PutContactPolicy
func (c *SSMContacts) PutContactPolicyRequest(input *PutContactPolicyInput) (req *request.Request, output *PutContactPolicyOutput) {
	op := &request.Operation{
		Name:       opPutContactPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutContactPolicyInput{}
	}

	output = &PutContactPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutContactPolicy API operation for AWS Systems Manager Incident Manager Contacts.
//
// Adds a resource policy to the specified contact or escalation plan. The resource
// policy is used to share the contact or escalation plan using Resource Access
// Manager (RAM). For more information about cross-account sharing, see Setting
// up cross-account functionality (https://docs.aws.amazon.com/incident-manager/latest/userguide/xa.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation PutContactPolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/PutContactPolicy
func (c *SSMContacts) PutContactPolicy(input *PutContactPolicyInput) (*PutContactPolicyOutput, error) {
	req, out := c.PutContactPolicyRequest(input)
	return out, req.Send()
}

// PutContactPolicyWithContext is the same as PutContactPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutContactPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) PutContactPolicyWithContext(ctx aws.Context, input *PutContactPolicyInput, opts ...request.Option) (*PutContactPolicyOutput, error) {
	req, out := c.PutContactPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendActivationCode = "SendActivationCode"

// SendActivationCodeRequest generates a "aws/request.Request" representing the
// client's request for the SendActivationCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendActivationCode for more information on using the SendActivationCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendActivationCodeRequest method.
//	req, resp := client.SendActivationCodeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/SendActivationCode
func (c *SSMContacts) SendActivationCodeRequest(input *SendActivationCodeInput) (req *request.Request, output *SendActivationCodeOutput) {
	op := &request.Operation{
		Name:       opSendActivationCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendActivationCodeInput{}
	}

	output = &SendActivationCodeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendActivationCode API operation for AWS Systems Manager Incident Manager Contacts.
//
// Sends an activation code to a contact channel. The contact can use this code
// to activate the contact channel in the console or with the ActivateChannel
// operation. Incident Manager can't engage a contact channel until it has been
// activated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation SendActivationCode for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/SendActivationCode
func (c *SSMContacts) SendActivationCode(input *SendActivationCodeInput) (*SendActivationCodeOutput, error) {
	req, out := c.SendActivationCodeRequest(input)
	return out, req.Send()
}

// SendActivationCodeWithContext is the same as SendActivationCode with the addition of
// the ability to pass a context and additional request options.
//
// See SendActivationCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) SendActivationCodeWithContext(ctx aws.Context, input *SendActivationCodeInput, opts ...request.Option) (*SendActivationCodeOutput, error) {
	req, out := c.SendActivationCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartEngagement = "StartEngagement"

// StartEngagementRequest generates a "aws/request.Request" representing the
// client's request for the StartEngagement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartEngagement for more information on using the StartEngagement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartEngagementRequest method.
//	req, resp := client.StartEngagementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StartEngagement
func (c *SSMContacts) StartEngagementRequest(input *StartEngagementInput) (req *request.Request, output *StartEngagementOutput) {
	op := &request.Operation{
		Name:       opStartEngagement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartEngagementInput{}
	}

	output = &StartEngagementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartEngagement API operation for AWS Systems Manager Incident Manager Contacts.
//
// Starts an engagement to a contact or escalation plan. The engagement engages
// each contact specified in the incident.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation StartEngagement for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StartEngagement
func (c *SSMContacts) StartEngagement(input *StartEngagementInput) (*StartEngagementOutput, error) {
	req, out := c.StartEngagementRequest(input)
	return out, req.Send()
}

// StartEngagementWithContext is the same as StartEngagement with the addition of
// the ability to pass a context and additional request options.
//
// See StartEngagement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) StartEngagementWithContext(ctx aws.Context, input *StartEngagementInput, opts ...request.Option) (*StartEngagementOutput, error) {
	req, out := c.StartEngagementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEngagement = "StopEngagement"

// StopEngagementRequest generates a "aws/request.Request" representing the
// client's request for the StopEngagement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEngagement for more information on using the StopEngagement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopEngagementRequest method.
//	req, resp := client.StopEngagementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StopEngagement
func (c *SSMContacts) StopEngagementRequest(input *StopEngagementInput) (req *request.Request, output *StopEngagementOutput) {
	op := &request.Operation{
		Name:       opStopEngagement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEngagementInput{}
	}

	output = &StopEngagementOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopEngagement API operation for AWS Systems Manager Incident Manager Contacts.
//
// Stops an engagement before it finishes the final stage of the escalation
// plan or engagement plan. Further contacts aren't engaged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation StopEngagement for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StopEngagement
func (c *SSMContacts) StopEngagement(input *StopEngagementInput) (*StopEngagementOutput, error) {
	req, out := c.StopEngagementRequest(input)
	return out, req.Send()
}

// StopEngagementWithContext is the same as StopEngagement with the addition of
// the ability to pass a context and additional request options.
//
// See StopEngagement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) StopEngagementWithContext(ctx aws.Context, input *StopEngagementInput, opts ...request.Option) (*StopEngagementOutput, error) {
	req, out := c.StopEngagementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/TagResource
func (c *SSMContacts) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Systems Manager Incident Manager Contacts.
//
// Tags a contact or escalation plan. You can tag only contacts and escalation
// plans in the first region of your replication set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/TagResource
func (c *SSMContacts) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UntagResource
func (c *SSMContacts) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Systems Manager Incident Manager Contacts.
//
// Removes tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UntagResource
func (c *SSMContacts) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContact = "UpdateContact"

// UpdateContactRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContact for more information on using the UpdateContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactRequest method.
//	req, resp := client.UpdateContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContact
func (c *SSMContacts) UpdateContactRequest(input *UpdateContactInput) (req *request.Request, output *UpdateContactOutput) {
	op := &request.Operation{
		Name:       opUpdateContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContactInput{}
	}

	output = &UpdateContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContact API operation for AWS Systems Manager Incident Manager Contacts.
//
// Updates the contact or escalation plan specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation UpdateContact for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContact
func (c *SSMContacts) UpdateContact(input *UpdateContactInput) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	return out, req.Send()
}

// UpdateContactWithContext is the same as UpdateContact with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) UpdateContactWithContext(ctx aws.Context, input *UpdateContactInput, opts ...request.Option) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactChannel = "UpdateContactChannel"

// UpdateContactChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactChannel for more information on using the UpdateContactChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactChannelRequest method.
//	req, resp := client.UpdateContactChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContactChannel
func (c *SSMContacts) UpdateContactChannelRequest(input *UpdateContactChannelInput) (req *request.Request, output *UpdateContactChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateContactChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContactChannelInput{}
	}

	output = &UpdateContactChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactChannel API operation for AWS Systems Manager Incident Manager Contacts.
//
// Updates a contact's contact channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Systems Manager Incident Manager Contacts's
// API operation UpdateContactChannel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this operation.
//
//   - ConflictException
//     Updating or deleting a resource causes an inconsistent state.
//
//   - DataEncryptionException
//     The operation failed to due an encryption key error.
//
//   - InternalServerException
//     Unexpected error occurred while processing the request.
//
//   - ResourceNotFoundException
//     Request references a resource that doesn't exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an Amazon Web Services
//     service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContactChannel
func (c *SSMContacts) UpdateContactChannel(input *UpdateContactChannelInput) (*UpdateContactChannelOutput, error) {
	req, out := c.UpdateContactChannelRequest(input)
	return out, req.Send()
}

// UpdateContactChannelWithContext is the same as UpdateContactChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMContacts) UpdateContactChannelWithContext(ctx aws.Context, input *UpdateContactChannelInput, opts ...request.Option) (*UpdateContactChannelOutput, error) {
	req, out := c.UpdateContactChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptPageInput struct {
	_ struct{} `type:"structure"`

	// The accept code is a 6-digit code used to acknowledge the page.
	//
	// AcceptCode is a required field
	AcceptCode *string `min:"6" type:"string" required:"true"`

	// An optional field that Incident Manager uses to ENFORCE AcceptCode validation
	// when acknowledging an page. Acknowledgement can occur by replying to a page,
	// or when entering the AcceptCode in the console. Enforcing AcceptCode validation
	// causes Incident Manager to verify that the code entered by the user matches
	// the code sent by Incident Manager with the page.
	//
	// Incident Manager can also IGNORE AcceptCode validation. Ignoring AcceptCode
	// validation causes Incident Manager to accept any value entered for the AcceptCode.
	AcceptCodeValidation *string `type:"string" enum:"AcceptCodeValidation"`

	// The type indicates if the page was DELIVERED or READ.
	//
	// AcceptType is a required field
	AcceptType *string `type:"string" required:"true" enum:"AcceptType"`

	// The ARN of the contact channel.
	ContactChannelId *string `min:"1" type:"string"`

	// Information provided by the user when the user acknowledges the page.
	Note *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the engagement to a contact channel.
	//
	// PageId is a required field
	PageId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptPageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptPageInput"}
	if s.AcceptCode == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceptCode"))
	}
	if s.AcceptCode != nil && len(*s.AcceptCode) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("AcceptCode", 6))
	}
	if s.AcceptType == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceptType"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}
	if s.Note != nil && len(*s.Note) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Note", 1))
	}
	if s.PageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PageId"))
	}
	if s.PageId != nil && len(*s.PageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptCode sets the AcceptCode field's value.
func (s *AcceptPageInput) SetAcceptCode(v string) *AcceptPageInput {
	s.AcceptCode = &v
	return s
}

// SetAcceptCodeValidation sets the AcceptCodeValidation field's value.
func (s *AcceptPageInput) SetAcceptCodeValidation(v string) *AcceptPageInput {
	s.AcceptCodeValidation = &v
	return s
}

// SetAcceptType sets the AcceptType field's value.
func (s *AcceptPageInput) SetAcceptType(v string) *AcceptPageInput {
	s.AcceptType = &v
	return s
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *AcceptPageInput) SetContactChannelId(v string) *AcceptPageInput {
	s.ContactChannelId = &v
	return s
}

// SetNote sets the Note field's value.
func (s *AcceptPageInput) SetNote(v string) *AcceptPageInput {
	s.Note = &v
	return s
}

// SetPageId sets the PageId field's value.
func (s *AcceptPageInput) SetPageId(v string) *AcceptPageInput {
	s.PageId = &v
	return s
}

type AcceptPageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPageOutput) GoString() string {
	return s.String()
}

// You don't have sufficient access to perform this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ActivateContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The code sent to the contact channel when it was created in the contact.
	//
	// ActivationCode is a required field
	ActivationCode *string `min:"6" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateContactChannelInput"}
	if s.ActivationCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationCode"))
	}
	if s.ActivationCode != nil && len(*s.ActivationCode) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("ActivationCode", 6))
	}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivationCode sets the ActivationCode field's value.
func (s *ActivateContactChannelInput) SetActivationCode(v string) *ActivateContactChannelInput {
	s.ActivationCode = &v
	return s
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *ActivateContactChannelInput) SetContactChannelId(v string) *ActivateContactChannelInput {
	s.ContactChannelId = &v
	return s
}

type ActivateContactChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateContactChannelOutput) GoString() string {
	return s.String()
}

// Information about the contact channel that Incident Manager uses to engage
// the contact.
type ChannelTargetInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`

	// The number of minutes to wait to retry sending engagement in the case the
	// engagement initially fails.
	RetryIntervalInMinutes *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelTargetInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelTargetInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelTargetInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelTargetInfo"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *ChannelTargetInfo) SetContactChannelId(v string) *ChannelTargetInfo {
	s.ContactChannelId = &v
	return s
}

// SetRetryIntervalInMinutes sets the RetryIntervalInMinutes field's value.
func (s *ChannelTargetInfo) SetRetryIntervalInMinutes(v int64) *ChannelTargetInfo {
	s.RetryIntervalInMinutes = &v
	return s
}

// Updating or deleting a resource causes an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource in use
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// ype of the resource in use
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A personal contact or escalation plan that Incident Manager engages during
// an incident.
type Contact struct {
	_ struct{} `type:"structure"`

	// The unique and identifiable alias of the contact or escalation plan.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The full name of the contact or escalation plan.
	DisplayName *string `type:"string"`

	// Refers to the type of contact. A single contact is type PERSONAL and an escalation
	// plan is type ESCALATION.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ContactType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *Contact) SetAlias(v string) *Contact {
	s.Alias = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *Contact) SetContactArn(v string) *Contact {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Contact) SetDisplayName(v string) *Contact {
	s.DisplayName = &v
	return s
}

// SetType sets the Type field's value.
func (s *Contact) SetType(v string) *Contact {
	s.Type = &v
	return s
}

// The method that Incident Manager uses to engage a contact.
type ContactChannel struct {
	_ struct{} `type:"structure"`

	// A Boolean value describing if the contact channel has been activated or not.
	// If the contact channel isn't activated, Incident Manager can't engage the
	// contact through it.
	//
	// ActivationStatus is a required field
	ActivationStatus *string `type:"string" required:"true" enum:"ActivationStatus"`

	// The ARN of the contact that contains the contact channel.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelArn is a required field
	ContactChannelArn *string `min:"1" type:"string" required:"true"`

	// The details that Incident Manager uses when trying to engage the contact
	// channel.
	//
	// DeliveryAddress is a required field
	DeliveryAddress *ContactChannelAddress `type:"structure" required:"true"`

	// The name of the contact channel.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of the contact channel. Incident Manager supports three contact
	// methods:
	//
	//    * SMS
	//
	//    * VOICE
	//
	//    * EMAIL
	Type *string `type:"string" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactChannel) GoString() string {
	return s.String()
}

// SetActivationStatus sets the ActivationStatus field's value.
func (s *ContactChannel) SetActivationStatus(v string) *ContactChannel {
	s.ActivationStatus = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *ContactChannel) SetContactArn(v string) *ContactChannel {
	s.ContactArn = &v
	return s
}

// SetContactChannelArn sets the ContactChannelArn field's value.
func (s *ContactChannel) SetContactChannelArn(v string) *ContactChannel {
	s.ContactChannelArn = &v
	return s
}

// SetDeliveryAddress sets the DeliveryAddress field's value.
func (s *ContactChannel) SetDeliveryAddress(v *ContactChannelAddress) *ContactChannel {
	s.DeliveryAddress = v
	return s
}

// SetName sets the Name field's value.
func (s *ContactChannel) SetName(v string) *ContactChannel {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ContactChannel) SetType(v string) *ContactChannel {
	s.Type = &v
	return s
}

// The details that Incident Manager uses when trying to engage the contact
// channel.
type ContactChannelAddress struct {
	_ struct{} `type:"structure"`

	// The format is dependent on the type of the contact channel. The following
	// are the expected formats:
	//
	//    * SMS - '+' followed by the country code and phone number
	//
	//    * VOICE - '+' followed by the country code and phone number
	//
	//    * EMAIL - any standard email format
	SimpleAddress *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactChannelAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactChannelAddress) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContactChannelAddress) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContactChannelAddress"}
	if s.SimpleAddress != nil && len(*s.SimpleAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SimpleAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSimpleAddress sets the SimpleAddress field's value.
func (s *ContactChannelAddress) SetSimpleAddress(v string) *ContactChannelAddress {
	s.SimpleAddress = &v
	return s
}

// The contact that Incident Manager is engaging during an incident.
type ContactTargetInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact.
	ContactId *string `min:"1" type:"string"`

	// A Boolean value determining if the contact's acknowledgement stops the progress
	// of stages in the plan.
	//
	// IsEssential is a required field
	IsEssential *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactTargetInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactTargetInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContactTargetInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContactTargetInfo"}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.IsEssential == nil {
		invalidParams.Add(request.NewErrParamRequired("IsEssential"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *ContactTargetInfo) SetContactId(v string) *ContactTargetInfo {
	s.ContactId = &v
	return s
}

// SetIsEssential sets the IsEssential field's value.
func (s *ContactTargetInfo) SetIsEssential(v bool) *ContactTargetInfo {
	s.IsEssential = &v
	return s
}

type CreateContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact you are adding the contact
	// channel to.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// If you want to activate the channel at a later time, you can choose to defer
	// activation. Incident Manager can't engage your contact channel until it has
	// been activated.
	DeferActivation *bool `type:"boolean"`

	// The details that Incident Manager uses when trying to engage the contact
	// channel. The format is dependent on the type of the contact channel. The
	// following are the expected formats:
	//
	//    * SMS - '+' followed by the country code and phone number
	//
	//    * VOICE - '+' followed by the country code and phone number
	//
	//    * EMAIL - any standard email format
	//
	// DeliveryAddress is a required field
	DeliveryAddress *ContactChannelAddress `type:"structure" required:"true"`

	// A token ensuring that the operation is called only once with the specified
	// details.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The name of the contact channel.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Incident Manager supports three types of contact channels:
	//
	//    * SMS
	//
	//    * VOICE
	//
	//    * EMAIL
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContactChannelInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.DeliveryAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryAddress"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.DeliveryAddress != nil {
		if err := s.DeliveryAddress.Validate(); err != nil {
			invalidParams.AddNested("DeliveryAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *CreateContactChannelInput) SetContactId(v string) *CreateContactChannelInput {
	s.ContactId = &v
	return s
}

// SetDeferActivation sets the DeferActivation field's value.
func (s *CreateContactChannelInput) SetDeferActivation(v bool) *CreateContactChannelInput {
	s.DeferActivation = &v
	return s
}

// SetDeliveryAddress sets the DeliveryAddress field's value.
func (s *CreateContactChannelInput) SetDeliveryAddress(v *ContactChannelAddress) *CreateContactChannelInput {
	s.DeliveryAddress = v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateContactChannelInput) SetIdempotencyToken(v string) *CreateContactChannelInput {
	s.IdempotencyToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateContactChannelInput) SetName(v string) *CreateContactChannelInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateContactChannelInput) SetType(v string) *CreateContactChannelInput {
	s.Type = &v
	return s
}

type CreateContactChannelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelArn is a required field
	ContactChannelArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactChannelOutput) GoString() string {
	return s.String()
}

// SetContactChannelArn sets the ContactChannelArn field's value.
func (s *CreateContactChannelOutput) SetContactChannelArn(v string) *CreateContactChannelOutput {
	s.ContactChannelArn = &v
	return s
}

type CreateContactInput struct {
	_ struct{} `type:"structure"`

	// The short name to quickly identify a contact or escalation plan. The contact
	// alias must be unique and identifiable.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The full name of the contact or escalation plan.
	DisplayName *string `type:"string"`

	// A token ensuring that the operation is called only once with the specified
	// details.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// A list of stages. A contact has an engagement plan with stages that contact
	// specified contact channels. An escalation plan uses stages that contact specified
	// contacts.
	//
	// Plan is a required field
	Plan *Plan `type:"structure" required:"true"`

	// Adds a tag to the target. You can only tag resources created in the first
	// Region of your replication set.
	Tags []*Tag `type:"list"`

	// To create an escalation plan use ESCALATION. To create a contact use PERSONAL.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ContactType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContactInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.Plan == nil {
		invalidParams.Add(request.NewErrParamRequired("Plan"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Plan != nil {
		if err := s.Plan.Validate(); err != nil {
			invalidParams.AddNested("Plan", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *CreateContactInput) SetAlias(v string) *CreateContactInput {
	s.Alias = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateContactInput) SetDisplayName(v string) *CreateContactInput {
	s.DisplayName = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateContactInput) SetIdempotencyToken(v string) *CreateContactInput {
	s.IdempotencyToken = &v
	return s
}

// SetPlan sets the Plan field's value.
func (s *CreateContactInput) SetPlan(v *Plan) *CreateContactInput {
	s.Plan = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateContactInput) SetTags(v []*Tag) *CreateContactInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateContactInput) SetType(v string) *CreateContactInput {
	s.Type = &v
	return s
}

type CreateContactOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *CreateContactOutput) SetContactArn(v string) *CreateContactOutput {
	s.ContactArn = &v
	return s
}

// The operation failed to due an encryption key error.
type DataEncryptionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataEncryptionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataEncryptionException) GoString() string {
	return s.String()
}

func newErrorDataEncryptionException(v protocol.ResponseMetadata) error {
	return &DataEncryptionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DataEncryptionException) Code() string {
	return "DataEncryptionException"
}

// Message returns the exception's message.
func (s *DataEncryptionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DataEncryptionException) OrigErr() error {
	return nil
}

func (s *DataEncryptionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DataEncryptionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DataEncryptionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeactivateContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel you're deactivating.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeactivateContactChannelInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *DeactivateContactChannelInput) SetContactChannelId(v string) *DeactivateContactChannelInput {
	s.ContactChannelId = &v
	return s
}

type DeactivateContactChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateContactChannelOutput) GoString() string {
	return s.String()
}

type DeleteContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContactChannelInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *DeleteContactChannelInput) SetContactChannelId(v string) *DeleteContactChannelInput {
	s.ContactChannelId = &v
	return s
}

type DeleteContactChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactChannelOutput) GoString() string {
	return s.String()
}

type DeleteContactInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact that you're deleting.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *DeleteContactInput) SetContactId(v string) *DeleteContactInput {
	s.ContactId = &v
	return s
}

type DeleteContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContactOutput) GoString() string {
	return s.String()
}

type DescribeEngagementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the engagement you want the details of.
	//
	// EngagementId is a required field
	EngagementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngagementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngagementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEngagementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEngagementInput"}
	if s.EngagementId == nil {
		invalidParams.Add(request.NewErrParamRequired("EngagementId"))
	}
	if s.EngagementId != nil && len(*s.EngagementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EngagementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngagementId sets the EngagementId field's value.
func (s *DescribeEngagementInput) SetEngagementId(v string) *DescribeEngagementInput {
	s.EngagementId = &v
	return s
}

type DescribeEngagementOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the escalation plan or contacts involved in the engagement.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The secure content of the message that was sent to the contact. Use this
	// field for engagements to VOICE and EMAIL.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The ARN of the engagement.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the incident in which the engagement occurred.
	IncidentId *string `type:"string"`

	// The insecure content of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicContent *string `min:"1" type:"string"`

	// The insecure subject of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicSubject *string `min:"1" type:"string"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The time that the engagement started.
	StartTime *time.Time `type:"timestamp"`

	// The time that the engagement ended.
	StopTime *time.Time `type:"timestamp"`

	// The secure subject of the message that was sent to the contact. Use this
	// field for engagements to VOICE and EMAIL.
	//
	// Subject is a required field
	Subject *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngagementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngagementOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *DescribeEngagementOutput) SetContactArn(v string) *DescribeEngagementOutput {
	s.ContactArn = &v
	return s
}

// SetContent sets the Content field's value.
func (s *DescribeEngagementOutput) SetContent(v string) *DescribeEngagementOutput {
	s.Content = &v
	return s
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *DescribeEngagementOutput) SetEngagementArn(v string) *DescribeEngagementOutput {
	s.EngagementArn = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *DescribeEngagementOutput) SetIncidentId(v string) *DescribeEngagementOutput {
	s.IncidentId = &v
	return s
}

// SetPublicContent sets the PublicContent field's value.
func (s *DescribeEngagementOutput) SetPublicContent(v string) *DescribeEngagementOutput {
	s.PublicContent = &v
	return s
}

// SetPublicSubject sets the PublicSubject field's value.
func (s *DescribeEngagementOutput) SetPublicSubject(v string) *DescribeEngagementOutput {
	s.PublicSubject = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *DescribeEngagementOutput) SetSender(v string) *DescribeEngagementOutput {
	s.Sender = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEngagementOutput) SetStartTime(v time.Time) *DescribeEngagementOutput {
	s.StartTime = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *DescribeEngagementOutput) SetStopTime(v time.Time) *DescribeEngagementOutput {
	s.StopTime = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *DescribeEngagementOutput) SetSubject(v string) *DescribeEngagementOutput {
	s.Subject = &v
	return s
}

type DescribePageInput struct {
	_ struct{} `type:"structure"`

	// The ID of the engagement to a contact channel.
	//
	// PageId is a required field
	PageId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePageInput"}
	if s.PageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PageId"))
	}
	if s.PageId != nil && len(*s.PageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageId sets the PageId field's value.
func (s *DescribePageInput) SetPageId(v string) *DescribePageInput {
	s.PageId = &v
	return s
}

type DescribePageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact that was engaged.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The secure content of the message that was sent to the contact. Use this
	// field for engagements to VOICE and EMAIL.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The time that the contact channel received the engagement.
	DeliveryTime *time.Time `type:"timestamp"`

	// The ARN of the engagement that engaged the contact channel.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the incident that engaged the contact channel.
	IncidentId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the engagement to a contact channel.
	//
	// PageArn is a required field
	PageArn *string `min:"1" type:"string" required:"true"`

	// The insecure content of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicContent *string `min:"1" type:"string"`

	// The insecure subject of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicSubject *string `min:"1" type:"string"`

	// The time that the contact channel acknowledged the engagement.
	ReadTime *time.Time `type:"timestamp"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The time the engagement was sent to the contact channel.
	SentTime *time.Time `type:"timestamp"`

	// The secure subject of the message that was sent to the contact. Use this
	// field for engagements to VOICE and EMAIL.
	//
	// Subject is a required field
	Subject *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePageOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *DescribePageOutput) SetContactArn(v string) *DescribePageOutput {
	s.ContactArn = &v
	return s
}

// SetContent sets the Content field's value.
func (s *DescribePageOutput) SetContent(v string) *DescribePageOutput {
	s.Content = &v
	return s
}

// SetDeliveryTime sets the DeliveryTime field's value.
func (s *DescribePageOutput) SetDeliveryTime(v time.Time) *DescribePageOutput {
	s.DeliveryTime = &v
	return s
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *DescribePageOutput) SetEngagementArn(v string) *DescribePageOutput {
	s.EngagementArn = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *DescribePageOutput) SetIncidentId(v string) *DescribePageOutput {
	s.IncidentId = &v
	return s
}

// SetPageArn sets the PageArn field's value.
func (s *DescribePageOutput) SetPageArn(v string) *DescribePageOutput {
	s.PageArn = &v
	return s
}

// SetPublicContent sets the PublicContent field's value.
func (s *DescribePageOutput) SetPublicContent(v string) *DescribePageOutput {
	s.PublicContent = &v
	return s
}

// SetPublicSubject sets the PublicSubject field's value.
func (s *DescribePageOutput) SetPublicSubject(v string) *DescribePageOutput {
	s.PublicSubject = &v
	return s
}

// SetReadTime sets the ReadTime field's value.
func (s *DescribePageOutput) SetReadTime(v time.Time) *DescribePageOutput {
	s.ReadTime = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *DescribePageOutput) SetSender(v string) *DescribePageOutput {
	s.Sender = &v
	return s
}

// SetSentTime sets the SentTime field's value.
func (s *DescribePageOutput) SetSentTime(v time.Time) *DescribePageOutput {
	s.SentTime = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *DescribePageOutput) SetSubject(v string) *DescribePageOutput {
	s.Subject = &v
	return s
}

// Incident Manager reaching out to a contact or escalation plan to engage contact
// during an incident.
type Engagement struct {
	_ struct{} `type:"structure"`

	// The ARN of the escalation plan or contact that Incident Manager is engaging.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the engagement.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the incident that's engaging the contact.
	IncidentId *string `type:"string"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The time that the engagement began.
	StartTime *time.Time `type:"timestamp"`

	// The time that the engagement ended.
	StopTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Engagement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Engagement) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *Engagement) SetContactArn(v string) *Engagement {
	s.ContactArn = &v
	return s
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *Engagement) SetEngagementArn(v string) *Engagement {
	s.EngagementArn = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *Engagement) SetIncidentId(v string) *Engagement {
	s.IncidentId = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *Engagement) SetSender(v string) *Engagement {
	s.Sender = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Engagement) SetStartTime(v time.Time) *Engagement {
	s.StartTime = &v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *Engagement) SetStopTime(v time.Time) *Engagement {
	s.StopTime = &v
	return s
}

type GetContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel you want information
	// about.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContactChannelInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *GetContactChannelInput) SetContactChannelId(v string) *GetContactChannelInput {
	s.ContactChannelId = &v
	return s
}

type GetContactChannelOutput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating if the contact channel has been activated or not.
	ActivationStatus *string `type:"string" enum:"ActivationStatus"`

	// The ARN of the contact that the channel belongs to.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the contact channel.
	//
	// ContactChannelArn is a required field
	ContactChannelArn *string `min:"1" type:"string" required:"true"`

	// The details that Incident Manager uses when trying to engage the contact
	// channel.
	//
	// DeliveryAddress is a required field
	DeliveryAddress *ContactChannelAddress `type:"structure" required:"true"`

	// The name of the contact channel
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of contact channel. The type is SMS, VOICE, or EMAIL.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ChannelType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactChannelOutput) GoString() string {
	return s.String()
}

// SetActivationStatus sets the ActivationStatus field's value.
func (s *GetContactChannelOutput) SetActivationStatus(v string) *GetContactChannelOutput {
	s.ActivationStatus = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactChannelOutput) SetContactArn(v string) *GetContactChannelOutput {
	s.ContactArn = &v
	return s
}

// SetContactChannelArn sets the ContactChannelArn field's value.
func (s *GetContactChannelOutput) SetContactChannelArn(v string) *GetContactChannelOutput {
	s.ContactChannelArn = &v
	return s
}

// SetDeliveryAddress sets the DeliveryAddress field's value.
func (s *GetContactChannelOutput) SetDeliveryAddress(v *ContactChannelAddress) *GetContactChannelOutput {
	s.DeliveryAddress = v
	return s
}

// SetName sets the Name field's value.
func (s *GetContactChannelOutput) SetName(v string) *GetContactChannelOutput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetContactChannelOutput) SetType(v string) *GetContactChannelOutput {
	s.Type = &v
	return s
}

type GetContactInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *GetContactInput) SetContactId(v string) *GetContactInput {
	s.ContactId = &v
	return s
}

type GetContactOutput struct {
	_ struct{} `type:"structure"`

	// The alias of the contact or escalation plan. The alias is unique and identifiable.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The ARN of the contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The full name of the contact or escalation plan.
	DisplayName *string `type:"string"`

	// Details about the specific timing or stages and targets of the escalation
	// plan or engagement plan.
	//
	// Plan is a required field
	Plan *Plan `type:"structure" required:"true"`

	// The type of contact, either PERSONAL or ESCALATION.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ContactType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *GetContactOutput) SetAlias(v string) *GetContactOutput {
	s.Alias = &v
	return s
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactOutput) SetContactArn(v string) *GetContactOutput {
	s.ContactArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetContactOutput) SetDisplayName(v string) *GetContactOutput {
	s.DisplayName = &v
	return s
}

// SetPlan sets the Plan field's value.
func (s *GetContactOutput) SetPlan(v *Plan) *GetContactOutput {
	s.Plan = v
	return s
}

// SetType sets the Type field's value.
func (s *GetContactOutput) SetType(v string) *GetContactOutput {
	s.Type = &v
	return s
}

type GetContactPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContactPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContactPolicyInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}
	if s.ContactArn != nil && len(*s.ContactArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactPolicyInput) SetContactArn(v string) *GetContactPolicyInput {
	s.ContactArn = &v
	return s
}

type GetContactPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact or escalation plan.
	ContactArn *string `min:"1" type:"string"`

	// Details about the resource policy attached to the contact or escalation plan.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContactPolicyOutput) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *GetContactPolicyOutput) SetContactArn(v string) *GetContactPolicyOutput {
	s.ContactArn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetContactPolicyOutput) SetPolicy(v string) *GetContactPolicyOutput {
	s.Policy = &v
	return s
}

// Unexpected error occurred while processing the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Advice to clients on when the call can be safely retried
	RetryAfterSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListContactChannelsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The maximum number of contact channels per page.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContactChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContactChannelsInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *ListContactChannelsInput) SetContactId(v string) *ListContactChannelsInput {
	s.ContactId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContactChannelsInput) SetMaxResults(v int64) *ListContactChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactChannelsInput) SetNextToken(v string) *ListContactChannelsInput {
	s.NextToken = &v
	return s
}

type ListContactChannelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of contact channels related to the specified contact.
	//
	// ContactChannels is a required field
	ContactChannels []*ContactChannel `type:"list" required:"true"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactChannelsOutput) GoString() string {
	return s.String()
}

// SetContactChannels sets the ContactChannels field's value.
func (s *ListContactChannelsOutput) SetContactChannels(v []*ContactChannel) *ListContactChannelsOutput {
	s.ContactChannels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactChannelsOutput) SetNextToken(v string) *ListContactChannelsOutput {
	s.NextToken = &v
	return s
}

type ListContactsInput struct {
	_ struct{} `type:"structure"`

	// Used to list only contacts who's aliases start with the specified prefix.
	AliasPrefix *string `min:"1" type:"string"`

	// The maximum number of contacts and escalation plans per page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The type of contact. A contact is type PERSONAL and an escalation plan is
	// type ESCALATION.
	Type *string `type:"string" enum:"ContactType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContactsInput"}
	if s.AliasPrefix != nil && len(*s.AliasPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasPrefix sets the AliasPrefix field's value.
func (s *ListContactsInput) SetAliasPrefix(v string) *ListContactsInput {
	s.AliasPrefix = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContactsInput) SetMaxResults(v int64) *ListContactsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactsInput) SetNextToken(v string) *ListContactsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListContactsInput) SetType(v string) *ListContactsInput {
	s.Type = &v
	return s
}

type ListContactsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the contacts and escalation plans in your Incident Manager account.
	Contacts []*Contact `type:"list"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContactsOutput) GoString() string {
	return s.String()
}

// SetContacts sets the Contacts field's value.
func (s *ListContactsOutput) SetContacts(v []*Contact) *ListContactsOutput {
	s.Contacts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactsOutput) SetNextToken(v string) *ListContactsOutput {
	s.NextToken = &v
	return s
}

type ListEngagementsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the incident you're listing engagements
	// for.
	IncidentId *string `type:"string"`

	// The maximum number of engagements per page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The time range to lists engagements for an incident.
	TimeRangeValue *TimeRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngagementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngagementsInput) GoString() string {
	return s.String()
}

// SetIncidentId sets the IncidentId field's value.
func (s *ListEngagementsInput) SetIncidentId(v string) *ListEngagementsInput {
	s.IncidentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEngagementsInput) SetMaxResults(v int64) *ListEngagementsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEngagementsInput) SetNextToken(v string) *ListEngagementsInput {
	s.NextToken = &v
	return s
}

// SetTimeRangeValue sets the TimeRangeValue field's value.
func (s *ListEngagementsInput) SetTimeRangeValue(v *TimeRange) *ListEngagementsInput {
	s.TimeRangeValue = v
	return s
}

type ListEngagementsOutput struct {
	_ struct{} `type:"structure"`

	// A list of each engagement that occurred during the specified time range of
	// an incident.
	//
	// Engagements is a required field
	Engagements []*Engagement `type:"list" required:"true"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngagementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngagementsOutput) GoString() string {
	return s.String()
}

// SetEngagements sets the Engagements field's value.
func (s *ListEngagementsOutput) SetEngagements(v []*Engagement) *ListEngagementsOutput {
	s.Engagements = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEngagementsOutput) SetNextToken(v string) *ListEngagementsOutput {
	s.NextToken = &v
	return s
}

type ListPageReceiptsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of acknowledgements per page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the engagement to a specific contact channel.
	//
	// PageId is a required field
	PageId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageReceiptsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageReceiptsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPageReceiptsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPageReceiptsInput"}
	if s.PageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PageId"))
	}
	if s.PageId != nil && len(*s.PageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPageReceiptsInput) SetMaxResults(v int64) *ListPageReceiptsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPageReceiptsInput) SetNextToken(v string) *ListPageReceiptsInput {
	s.NextToken = &v
	return s
}

// SetPageId sets the PageId field's value.
func (s *ListPageReceiptsInput) SetPageId(v string) *ListPageReceiptsInput {
	s.PageId = &v
	return s
}

type ListPageReceiptsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// A list of each acknowledgement.
	Receipts []*Receipt `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageReceiptsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPageReceiptsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPageReceiptsOutput) SetNextToken(v string) *ListPageReceiptsOutput {
	s.NextToken = &v
	return s
}

// SetReceipts sets the Receipts field's value.
func (s *ListPageReceiptsOutput) SetReceipts(v []*Receipt) *ListPageReceiptsOutput {
	s.Receipts = v
	return s
}

type ListPagesByContactInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact you are retrieving engagements
	// for.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The maximum number of engagements to contact channels to list per page of
	// results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPagesByContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPagesByContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *ListPagesByContactInput) SetContactId(v string) *ListPagesByContactInput {
	s.ContactId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPagesByContactInput) SetMaxResults(v int64) *ListPagesByContactInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPagesByContactInput) SetNextToken(v string) *ListPagesByContactInput {
	s.NextToken = &v
	return s
}

type ListPagesByContactOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The list of engagements to a contact's contact channel.
	//
	// Pages is a required field
	Pages []*Page `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByContactOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPagesByContactOutput) SetNextToken(v string) *ListPagesByContactOutput {
	s.NextToken = &v
	return s
}

// SetPages sets the Pages field's value.
func (s *ListPagesByContactOutput) SetPages(v []*Page) *ListPagesByContactOutput {
	s.Pages = v
	return s
}

type ListPagesByEngagementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the engagement.
	//
	// EngagementId is a required field
	EngagementId *string `min:"1" type:"string" required:"true"`

	// The maximum number of engagements to contact channels to list per page of
	// results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByEngagementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByEngagementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPagesByEngagementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPagesByEngagementInput"}
	if s.EngagementId == nil {
		invalidParams.Add(request.NewErrParamRequired("EngagementId"))
	}
	if s.EngagementId != nil && len(*s.EngagementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EngagementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngagementId sets the EngagementId field's value.
func (s *ListPagesByEngagementInput) SetEngagementId(v string) *ListPagesByEngagementInput {
	s.EngagementId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPagesByEngagementInput) SetMaxResults(v int64) *ListPagesByEngagementInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPagesByEngagementInput) SetNextToken(v string) *ListPagesByEngagementInput {
	s.NextToken = &v
	return s
}

type ListPagesByEngagementOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to continue to the next page of results.
	NextToken *string `type:"string"`

	// The list of engagements to contact channels.
	//
	// Pages is a required field
	Pages []*Page `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByEngagementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPagesByEngagementOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPagesByEngagementOutput) SetNextToken(v string) *ListPagesByEngagementOutput {
	s.NextToken = &v
	return s
}

// SetPages sets the Pages field's value.
func (s *ListPagesByEngagementOutput) SetPages(v []*Page) *ListPagesByEngagementOutput {
	s.Pages = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags related to the contact or escalation plan.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Incident Manager engaging a contact's contact channel.
type Page struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact that Incident Manager is engaging.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// The time the message was delivered to the contact channel.
	DeliveryTime *time.Time `type:"timestamp"`

	// The ARN of the engagement that this page is part of.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the incident that's engaging the contact channel.
	IncidentId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the page to the contact channel.
	//
	// PageArn is a required field
	PageArn *string `min:"1" type:"string" required:"true"`

	// The time that the contact channel acknowledged engagement.
	ReadTime *time.Time `type:"timestamp"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The time that Incident Manager engaged the contact channel.
	SentTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Page) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Page) GoString() string {
	return s.String()
}

// SetContactArn sets the ContactArn field's value.
func (s *Page) SetContactArn(v string) *Page {
	s.ContactArn = &v
	return s
}

// SetDeliveryTime sets the DeliveryTime field's value.
func (s *Page) SetDeliveryTime(v time.Time) *Page {
	s.DeliveryTime = &v
	return s
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *Page) SetEngagementArn(v string) *Page {
	s.EngagementArn = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *Page) SetIncidentId(v string) *Page {
	s.IncidentId = &v
	return s
}

// SetPageArn sets the PageArn field's value.
func (s *Page) SetPageArn(v string) *Page {
	s.PageArn = &v
	return s
}

// SetReadTime sets the ReadTime field's value.
func (s *Page) SetReadTime(v time.Time) *Page {
	s.ReadTime = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *Page) SetSender(v string) *Page {
	s.Sender = &v
	return s
}

// SetSentTime sets the SentTime field's value.
func (s *Page) SetSentTime(v time.Time) *Page {
	s.SentTime = &v
	return s
}

// The stages that an escalation plan or engagement plan engages contacts and
// contact methods in.
type Plan struct {
	_ struct{} `type:"structure"`

	// A list of stages that the escalation plan or engagement plan uses to engage
	// contacts and contact methods.
	//
	// Stages is a required field
	Stages []*Stage `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plan) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Plan) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Plan"}
	if s.Stages == nil {
		invalidParams.Add(request.NewErrParamRequired("Stages"))
	}
	if s.Stages != nil {
		for i, v := range s.Stages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Stages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStages sets the Stages field's value.
func (s *Plan) SetStages(v []*Stage) *Plan {
	s.Stages = v
	return s
}

type PutContactPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ContactArn is a required field
	ContactArn *string `min:"1" type:"string" required:"true"`

	// Details of the resource policy.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContactPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContactPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutContactPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutContactPolicyInput"}
	if s.ContactArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactArn"))
	}
	if s.ContactArn != nil && len(*s.ContactArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactArn", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactArn sets the ContactArn field's value.
func (s *PutContactPolicyInput) SetContactArn(v string) *PutContactPolicyInput {
	s.ContactArn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutContactPolicyInput) SetPolicy(v string) *PutContactPolicyInput {
	s.Policy = &v
	return s
}

type PutContactPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContactPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContactPolicyOutput) GoString() string {
	return s.String()
}

// Records events during an engagement.
type Receipt struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
	ContactChannelArn *string `min:"1" type:"string"`

	// Information provided during the page acknowledgement.
	ReceiptInfo *string `min:"1" type:"string"`

	// The time receipt was SENT, DELIVERED, or READ.
	//
	// ReceiptTime is a required field
	ReceiptTime *time.Time `type:"timestamp" required:"true"`

	// The type follows the engagement cycle, SENT, DELIVERED, and READ.
	//
	// ReceiptType is a required field
	ReceiptType *string `type:"string" required:"true" enum:"ReceiptType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Receipt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Receipt) GoString() string {
	return s.String()
}

// SetContactChannelArn sets the ContactChannelArn field's value.
func (s *Receipt) SetContactChannelArn(v string) *Receipt {
	s.ContactChannelArn = &v
	return s
}

// SetReceiptInfo sets the ReceiptInfo field's value.
func (s *Receipt) SetReceiptInfo(v string) *Receipt {
	s.ReceiptInfo = &v
	return s
}

// SetReceiptTime sets the ReceiptTime field's value.
func (s *Receipt) SetReceiptTime(v time.Time) *Receipt {
	s.ReceiptTime = &v
	return s
}

// SetReceiptType sets the ReceiptType field's value.
func (s *Receipt) SetReceiptType(v string) *Receipt {
	s.ReceiptType = &v
	return s
}

// Request references a resource that doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Hypothetical resource identifier that was not found
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Hypothetical resource type that was not found
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SendActivationCodeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendActivationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendActivationCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendActivationCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendActivationCodeInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *SendActivationCodeInput) SetContactChannelId(v string) *SendActivationCodeInput {
	s.ContactChannelId = &v
	return s
}

type SendActivationCodeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendActivationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendActivationCodeOutput) GoString() string {
	return s.String()
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Service Quotas requirement to identify originating service
	//
	// QuotaCode is a required field
	QuotaCode *string `type:"string" required:"true"`

	// Identifier of the resource affected
	ResourceId *string `type:"string"`

	// Type of the resource affected
	ResourceType *string `type:"string"`

	// Service Quotas requirement to identify originating quota
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A set amount of time that an escalation plan or engagement plan engages the
// specified contacts or contact methods.
type Stage struct {
	_ struct{} `type:"structure"`

	// The time to wait until beginning the next stage. The duration can only be
	// set to 0 if a target is specified.
	//
	// DurationInMinutes is a required field
	DurationInMinutes *int64 `type:"integer" required:"true"`

	// The contacts or contact methods that the escalation plan or engagement plan
	// is engaging.
	//
	// Targets is a required field
	Targets []*Target `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Stage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Stage"}
	if s.DurationInMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("DurationInMinutes"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDurationInMinutes sets the DurationInMinutes field's value.
func (s *Stage) SetDurationInMinutes(v int64) *Stage {
	s.DurationInMinutes = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Stage) SetTargets(v []*Target) *Stage {
	s.Targets = v
	return s
}

type StartEngagementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact being engaged.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The secure content of the message that was sent to the contact. Use this
	// field for engagements to VOICE or EMAIL.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// A token ensuring that the operation is called only once with the specified
	// details.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The ARN of the incident that the engagement is part of.
	IncidentId *string `type:"string"`

	// The insecure content of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicContent *string `min:"1" type:"string"`

	// The insecure subject of the message that was sent to the contact. Use this
	// field for engagements to SMS.
	PublicSubject *string `min:"1" type:"string"`

	// The user that started the engagement.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The secure subject of the message that was sent to the contact. Use this
	// field for engagements to VOICE or EMAIL.
	//
	// Subject is a required field
	Subject *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEngagementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEngagementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartEngagementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartEngagementInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.PublicContent != nil && len(*s.PublicContent) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublicContent", 1))
	}
	if s.PublicSubject != nil && len(*s.PublicSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PublicSubject", 1))
	}
	if s.Sender == nil {
		invalidParams.Add(request.NewErrParamRequired("Sender"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.Subject != nil && len(*s.Subject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subject", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *StartEngagementInput) SetContactId(v string) *StartEngagementInput {
	s.ContactId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *StartEngagementInput) SetContent(v string) *StartEngagementInput {
	s.Content = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *StartEngagementInput) SetIdempotencyToken(v string) *StartEngagementInput {
	s.IdempotencyToken = &v
	return s
}

// SetIncidentId sets the IncidentId field's value.
func (s *StartEngagementInput) SetIncidentId(v string) *StartEngagementInput {
	s.IncidentId = &v
	return s
}

// SetPublicContent sets the PublicContent field's value.
func (s *StartEngagementInput) SetPublicContent(v string) *StartEngagementInput {
	s.PublicContent = &v
	return s
}

// SetPublicSubject sets the PublicSubject field's value.
func (s *StartEngagementInput) SetPublicSubject(v string) *StartEngagementInput {
	s.PublicSubject = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *StartEngagementInput) SetSender(v string) *StartEngagementInput {
	s.Sender = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *StartEngagementInput) SetSubject(v string) *StartEngagementInput {
	s.Subject = &v
	return s
}

type StartEngagementOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the engagement.
	//
	// EngagementArn is a required field
	EngagementArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEngagementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEngagementOutput) GoString() string {
	return s.String()
}

// SetEngagementArn sets the EngagementArn field's value.
func (s *StartEngagementOutput) SetEngagementArn(v string) *StartEngagementOutput {
	s.EngagementArn = &v
	return s
}

type StopEngagementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the engagement.
	//
	// EngagementId is a required field
	EngagementId *string `min:"1" type:"string" required:"true"`

	// The reason that you're stopping the engagement.
	Reason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEngagementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEngagementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEngagementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEngagementInput"}
	if s.EngagementId == nil {
		invalidParams.Add(request.NewErrParamRequired("EngagementId"))
	}
	if s.EngagementId != nil && len(*s.EngagementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EngagementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngagementId sets the EngagementId field's value.
func (s *StopEngagementInput) SetEngagementId(v string) *StopEngagementInput {
	s.EngagementId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *StopEngagementInput) SetReason(v string) *StopEngagementInput {
	s.Reason = &v
	return s
}

type StopEngagementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEngagementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEngagementOutput) GoString() string {
	return s.String()
}

// A container of a key-value name pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// Name of the object key.
	Key *string `min:"1" type:"string"`

	// Value of the tag.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tags that you are adding to the contact or escalation plan.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The contact or contact channel that's being engaged.
type Target struct {
	_ struct{} `type:"structure"`

	// Information about the contact channel Incident Manager is engaging.
	ChannelTargetInfo *ChannelTargetInfo `type:"structure"`

	// Information about the contact that Incident Manager is engaging.
	ContactTargetInfo *ContactTargetInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.ChannelTargetInfo != nil {
		if err := s.ChannelTargetInfo.Validate(); err != nil {
			invalidParams.AddNested("ChannelTargetInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.ContactTargetInfo != nil {
		if err := s.ContactTargetInfo.Validate(); err != nil {
			invalidParams.AddNested("ContactTargetInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelTargetInfo sets the ChannelTargetInfo field's value.
func (s *Target) SetChannelTargetInfo(v *ChannelTargetInfo) *Target {
	s.ChannelTargetInfo = v
	return s
}

// SetContactTargetInfo sets the ContactTargetInfo field's value.
func (s *Target) SetContactTargetInfo(v *ContactTargetInfo) *Target {
	s.ContactTargetInfo = v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Service Quotas requirement to identify originating service
	QuotaCode *string `type:"string"`

	// Advice to clients on when the call can be safely retried
	RetryAfterSeconds *int64 `type:"integer"`

	// Service Quotas requirement to identify originating quota
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A range of between two set times
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The end of the time range.
	EndTime *time.Time `type:"timestamp"`

	// The start of the time range.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRange) SetEndTime(v time.Time) *TimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRange) SetStartTime(v time.Time) *TimeRange {
	s.StartTime = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The key of the tag that you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateContactChannelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact channel you want to update.
	//
	// ContactChannelId is a required field
	ContactChannelId *string `min:"1" type:"string" required:"true"`

	// The details that Incident Manager uses when trying to engage the contact
	// channel.
	DeliveryAddress *ContactChannelAddress `type:"structure"`

	// The name of the contact channel.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContactChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContactChannelInput"}
	if s.ContactChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactChannelId"))
	}
	if s.ContactChannelId != nil && len(*s.ContactChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactChannelId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.DeliveryAddress != nil {
		if err := s.DeliveryAddress.Validate(); err != nil {
			invalidParams.AddNested("DeliveryAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactChannelId sets the ContactChannelId field's value.
func (s *UpdateContactChannelInput) SetContactChannelId(v string) *UpdateContactChannelInput {
	s.ContactChannelId = &v
	return s
}

// SetDeliveryAddress sets the DeliveryAddress field's value.
func (s *UpdateContactChannelInput) SetDeliveryAddress(v *ContactChannelAddress) *UpdateContactChannelInput {
	s.DeliveryAddress = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateContactChannelInput) SetName(v string) *UpdateContactChannelInput {
	s.Name = &v
	return s
}

type UpdateContactChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactChannelOutput) GoString() string {
	return s.String()
}

type UpdateContactInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The full name of the contact or escalation plan.
	DisplayName *string `type:"string"`

	// A list of stages. A contact has an engagement plan with stages for specified
	// contact channels. An escalation plan uses these stages to contact specified
	// contacts.
	Plan *Plan `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.Plan != nil {
		if err := s.Plan.Validate(); err != nil {
			invalidParams.AddNested("Plan", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *UpdateContactInput) SetContactId(v string) *UpdateContactInput {
	s.ContactId = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateContactInput) SetDisplayName(v string) *UpdateContactInput {
	s.DisplayName = &v
	return s
}

// SetPlan sets the Plan field's value.
func (s *UpdateContactInput) SetPlan(v *Plan) *UpdateContactInput {
	s.Plan = v
	return s
}

type UpdateContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContactOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an Amazon Web Services
// service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that caused the error
	Fields []*ValidationExceptionField `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`

	// Reason the request failed validation
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about which field caused the exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Information about what caused the field to cause an exception.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The name of the field that caused the exception.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AcceptCodeValidationIgnore is a AcceptCodeValidation enum value
	AcceptCodeValidationIgnore = "IGNORE"

	// AcceptCodeValidationEnforce is a AcceptCodeValidation enum value
	AcceptCodeValidationEnforce = "ENFORCE"
)

// AcceptCodeValidation_Values returns all elements of the AcceptCodeValidation enum
func AcceptCodeValidation_Values() []string {
	return []string{
		AcceptCodeValidationIgnore,
		AcceptCodeValidationEnforce,
	}
}

const (
	// AcceptTypeDelivered is a AcceptType enum value
	AcceptTypeDelivered = "DELIVERED"

	// AcceptTypeRead is a AcceptType enum value
	AcceptTypeRead = "READ"
)

// AcceptType_Values returns all elements of the AcceptType enum
func AcceptType_Values() []string {
	return []string{
		AcceptTypeDelivered,
		AcceptTypeRead,
	}
}

const (
	// ActivationStatusActivated is a ActivationStatus enum value
	ActivationStatusActivated = "ACTIVATED"

	// ActivationStatusNotActivated is a ActivationStatus enum value
	ActivationStatusNotActivated = "NOT_ACTIVATED"
)

// ActivationStatus_Values returns all elements of the ActivationStatus enum
func ActivationStatus_Values() []string {
	return []string{
		ActivationStatusActivated,
		ActivationStatusNotActivated,
	}
}

const (
	// ChannelTypeSms is a ChannelType enum value
	ChannelTypeSms = "SMS"

	// ChannelTypeVoice is a ChannelType enum value
	ChannelTypeVoice = "VOICE"

	// ChannelTypeEmail is a ChannelType enum value
	ChannelTypeEmail = "EMAIL"
)

// ChannelType_Values returns all elements of the ChannelType enum
func ChannelType_Values() []string {
	return []string{
		ChannelTypeSms,
		ChannelTypeVoice,
		ChannelTypeEmail,
	}
}

const (
	// ContactTypePersonal is a ContactType enum value
	ContactTypePersonal = "PERSONAL"

	// ContactTypeEscalation is a ContactType enum value
	ContactTypeEscalation = "ESCALATION"
)

// ContactType_Values returns all elements of the ContactType enum
func ContactType_Values() []string {
	return []string{
		ContactTypePersonal,
		ContactTypeEscalation,
	}
}

const (
	// ReceiptTypeDelivered is a ReceiptType enum value
	ReceiptTypeDelivered = "DELIVERED"

	// ReceiptTypeError is a ReceiptType enum value
	ReceiptTypeError = "ERROR"

	// ReceiptTypeRead is a ReceiptType enum value
	ReceiptTypeRead = "READ"

	// ReceiptTypeSent is a ReceiptType enum value
	ReceiptTypeSent = "SENT"

	// ReceiptTypeStop is a ReceiptType enum value
	ReceiptTypeStop = "STOP"
)

// ReceiptType_Values returns all elements of the ReceiptType enum
func ReceiptType_Values() []string {
	return []string{
		ReceiptTypeDelivered,
		ReceiptTypeError,
		ReceiptTypeRead,
		ReceiptTypeSent,
		ReceiptTypeStop,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
