// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costandusagereportservice

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDeleteReportDefinition = "DeleteReportDefinition"

// DeleteReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReportDefinition for more information on using the DeleteReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReportDefinitionRequest method.
//    req, resp := client.DeleteReportDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DeleteReportDefinition
func (c *CostandUsageReportService) DeleteReportDefinitionRequest(input *DeleteReportDefinitionInput) (req *request.Request, output *DeleteReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteReportDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReportDefinitionInput{}
	}

	output = &DeleteReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReportDefinition API operation for AWS Cost and Usage Report Service.
//
// Deletes the specified report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation DeleteReportDefinition for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DeleteReportDefinition
func (c *CostandUsageReportService) DeleteReportDefinition(input *DeleteReportDefinitionInput) (*DeleteReportDefinitionOutput, error) {
	req, out := c.DeleteReportDefinitionRequest(input)
	return out, req.Send()
}

// DeleteReportDefinitionWithContext is the same as DeleteReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) DeleteReportDefinitionWithContext(ctx aws.Context, input *DeleteReportDefinitionInput, opts ...request.Option) (*DeleteReportDefinitionOutput, error) {
	req, out := c.DeleteReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReportDefinitions = "DescribeReportDefinitions"

// DescribeReportDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReportDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReportDefinitions for more information on using the DescribeReportDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReportDefinitionsRequest method.
//    req, resp := client.DescribeReportDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions
func (c *CostandUsageReportService) DescribeReportDefinitionsRequest(input *DescribeReportDefinitionsInput) (req *request.Request, output *DescribeReportDefinitionsOutput) {
	op := &request.Operation{
		Name:       opDescribeReportDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReportDefinitionsInput{}
	}

	output = &DescribeReportDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReportDefinitions API operation for AWS Cost and Usage Report Service.
//
// Lists the AWS Cost and Usage reports available to this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation DescribeReportDefinitions for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions
func (c *CostandUsageReportService) DescribeReportDefinitions(input *DescribeReportDefinitionsInput) (*DescribeReportDefinitionsOutput, error) {
	req, out := c.DescribeReportDefinitionsRequest(input)
	return out, req.Send()
}

// DescribeReportDefinitionsWithContext is the same as DescribeReportDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReportDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) DescribeReportDefinitionsWithContext(ctx aws.Context, input *DescribeReportDefinitionsInput, opts ...request.Option) (*DescribeReportDefinitionsOutput, error) {
	req, out := c.DescribeReportDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReportDefinitionsPages iterates over the pages of a DescribeReportDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReportDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReportDefinitions operation.
//    pageNum := 0
//    err := client.DescribeReportDefinitionsPages(params,
//        func(page *costandusagereportservice.DescribeReportDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CostandUsageReportService) DescribeReportDefinitionsPages(input *DescribeReportDefinitionsInput, fn func(*DescribeReportDefinitionsOutput, bool) bool) error {
	return c.DescribeReportDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReportDefinitionsPagesWithContext same as DescribeReportDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) DescribeReportDefinitionsPagesWithContext(ctx aws.Context, input *DescribeReportDefinitionsInput, fn func(*DescribeReportDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReportDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReportDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReportDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opModifyReportDefinition = "ModifyReportDefinition"

// ModifyReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReportDefinition for more information on using the ModifyReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyReportDefinitionRequest method.
//    req, resp := client.ModifyReportDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ModifyReportDefinition
func (c *CostandUsageReportService) ModifyReportDefinitionRequest(input *ModifyReportDefinitionInput) (req *request.Request, output *ModifyReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opModifyReportDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReportDefinitionInput{}
	}

	output = &ModifyReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyReportDefinition API operation for AWS Cost and Usage Report Service.
//
// Allows you to programatically update your report preferences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation ModifyReportDefinition for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ModifyReportDefinition
func (c *CostandUsageReportService) ModifyReportDefinition(input *ModifyReportDefinitionInput) (*ModifyReportDefinitionOutput, error) {
	req, out := c.ModifyReportDefinitionRequest(input)
	return out, req.Send()
}

// ModifyReportDefinitionWithContext is the same as ModifyReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) ModifyReportDefinitionWithContext(ctx aws.Context, input *ModifyReportDefinitionInput, opts ...request.Option) (*ModifyReportDefinitionOutput, error) {
	req, out := c.ModifyReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutReportDefinition = "PutReportDefinition"

// PutReportDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the PutReportDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutReportDefinition for more information on using the PutReportDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutReportDefinitionRequest method.
//    req, resp := client.PutReportDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/PutReportDefinition
func (c *CostandUsageReportService) PutReportDefinitionRequest(input *PutReportDefinitionInput) (req *request.Request, output *PutReportDefinitionOutput) {
	op := &request.Operation{
		Name:       opPutReportDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutReportDefinitionInput{}
	}

	output = &PutReportDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutReportDefinition API operation for AWS Cost and Usage Report Service.
//
// Creates a new report using the description that you provide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cost and Usage Report Service's
// API operation PutReportDefinition for usage and error information.
//
// Returned Error Types:
//   * DuplicateReportNameException
//   A report with the specified name already exists in the account. Specify a
//   different report name.
//
//   * ReportLimitReachedException
//   This account already has five reports defined. To define a new report, you
//   must delete an existing report.
//
//   * InternalErrorException
//   An error on the server occurred during the processing of your request. Try
//   again later.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/PutReportDefinition
func (c *CostandUsageReportService) PutReportDefinition(input *PutReportDefinitionInput) (*PutReportDefinitionOutput, error) {
	req, out := c.PutReportDefinitionRequest(input)
	return out, req.Send()
}

// PutReportDefinitionWithContext is the same as PutReportDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See PutReportDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CostandUsageReportService) PutReportDefinitionWithContext(ctx aws.Context, input *PutReportDefinitionInput, opts ...request.Option) (*PutReportDefinitionOutput, error) {
	req, out := c.PutReportDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Deletes the specified report.
type DeleteReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The name of the report that you want to create. The name must be unique,
	// is case sensitive, and can't include spaces.
	ReportName *string `type:"string"`
}

// String returns the string representation
func (s DeleteReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReportDefinitionInput) GoString() string {
	return s.String()
}

// SetReportName sets the ReportName field's value.
func (s *DeleteReportDefinitionInput) SetReportName(v string) *DeleteReportDefinitionInput {
	s.ReportName = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response.
type DeleteReportDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Whether the deletion was successful or not.
	ResponseMessage *string `type:"string"`
}

// String returns the string representation
func (s DeleteReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReportDefinitionOutput) GoString() string {
	return s.String()
}

// SetResponseMessage sets the ResponseMessage field's value.
func (s *DeleteReportDefinitionOutput) SetResponseMessage(v string) *DeleteReportDefinitionOutput {
	s.ResponseMessage = &v
	return s
}

// Requests a list of AWS Cost and Usage reports owned by the account.
type DescribeReportDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that AWS returns for the operation.
	MaxResults *int64 `min:"5" type:"integer"`

	// A generic string.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeReportDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReportDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReportDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReportDefinitionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReportDefinitionsInput) SetMaxResults(v int64) *DescribeReportDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReportDefinitionsInput) SetNextToken(v string) *DescribeReportDefinitionsInput {
	s.NextToken = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response.
type DescribeReportDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// A generic string.
	NextToken *string `type:"string"`

	// A list of AWS Cost and Usage reports owned by the account.
	ReportDefinitions []*ReportDefinition `type:"list"`
}

// String returns the string representation
func (s DescribeReportDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReportDefinitionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReportDefinitionsOutput) SetNextToken(v string) *DescribeReportDefinitionsOutput {
	s.NextToken = &v
	return s
}

// SetReportDefinitions sets the ReportDefinitions field's value.
func (s *DescribeReportDefinitionsOutput) SetReportDefinitions(v []*ReportDefinition) *DescribeReportDefinitionsOutput {
	s.ReportDefinitions = v
	return s
}

// A report with the specified name already exists in the account. Specify a
// different report name.
type DuplicateReportNameException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	// A message to show the detail of the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DuplicateReportNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DuplicateReportNameException) GoString() string {
	return s.String()
}

func newErrorDuplicateReportNameException(v protocol.ResponseMetadata) error {
	return &DuplicateReportNameException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s DuplicateReportNameException) Code() string {
	return "DuplicateReportNameException"
}

// Message returns the exception's message.
func (s DuplicateReportNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s DuplicateReportNameException) OrigErr() error {
	return nil
}

func (s DuplicateReportNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s DuplicateReportNameException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s DuplicateReportNameException) RequestID() string {
	return s.respMetadata.RequestID
}

// An error on the server occurred during the processing of your request. Try
// again later.
type InternalErrorException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	// A message to show the detail of the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalErrorException) GoString() string {
	return s.String()
}

func newErrorInternalErrorException(v protocol.ResponseMetadata) error {
	return &InternalErrorException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InternalErrorException) Code() string {
	return "InternalErrorException"
}

// Message returns the exception's message.
func (s InternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InternalErrorException) OrigErr() error {
	return nil
}

func (s InternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InternalErrorException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InternalErrorException) RequestID() string {
	return s.respMetadata.RequestID
}

type ModifyReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The definition of AWS Cost and Usage Report. You can specify the report name,
	// time unit, report format, compression format, S3 bucket, additional artifacts,
	// and schema elements in the definition.
	//
	// ReportDefinition is a required field
	ReportDefinition *ReportDefinition `type:"structure" required:"true"`

	// The name of the report that you want to create. The name must be unique,
	// is case sensitive, and can't include spaces.
	//
	// ReportName is a required field
	ReportName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReportDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReportDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReportDefinitionInput"}
	if s.ReportDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportDefinition"))
	}
	if s.ReportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportName"))
	}
	if s.ReportDefinition != nil {
		if err := s.ReportDefinition.Validate(); err != nil {
			invalidParams.AddNested("ReportDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportDefinition sets the ReportDefinition field's value.
func (s *ModifyReportDefinitionInput) SetReportDefinition(v *ReportDefinition) *ModifyReportDefinitionInput {
	s.ReportDefinition = v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *ModifyReportDefinitionInput) SetReportName(v string) *ModifyReportDefinitionInput {
	s.ReportName = &v
	return s
}

type ModifyReportDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReportDefinitionOutput) GoString() string {
	return s.String()
}

// Creates a Cost and Usage Report.
type PutReportDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Represents the output of the PutReportDefinition operation. The content consists
	// of the detailed metadata and data file information.
	//
	// ReportDefinition is a required field
	ReportDefinition *ReportDefinition `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutReportDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutReportDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutReportDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutReportDefinitionInput"}
	if s.ReportDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportDefinition"))
	}
	if s.ReportDefinition != nil {
		if err := s.ReportDefinition.Validate(); err != nil {
			invalidParams.AddNested("ReportDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportDefinition sets the ReportDefinition field's value.
func (s *PutReportDefinitionInput) SetReportDefinition(v *ReportDefinition) *PutReportDefinitionInput {
	s.ReportDefinition = v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type PutReportDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutReportDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutReportDefinitionOutput) GoString() string {
	return s.String()
}

// The definition of AWS Cost and Usage Report. You can specify the report name,
// time unit, report format, compression format, S3 bucket, additional artifacts,
// and schema elements in the definition.
type ReportDefinition struct {
	_ struct{} `type:"structure"`

	// A list of manifests that you want Amazon Web Services to create for this
	// report.
	AdditionalArtifacts []*string `type:"list"`

	// A list of strings that indicate additional content that Amazon Web Services
	// includes in the report, such as individual resource IDs.
	//
	// AdditionalSchemaElements is a required field
	AdditionalSchemaElements []*string `type:"list" required:"true"`

	// The compression format that AWS uses for the report.
	//
	// Compression is a required field
	Compression *string `type:"string" required:"true" enum:"CompressionFormat"`

	// The format that AWS saves the report in.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"ReportFormat"`

	// Whether you want Amazon Web Services to update your reports after they have
	// been finalized if Amazon Web Services detects charges related to previous
	// months. These charges can include refunds, credits, or support fees.
	RefreshClosedReports *bool `type:"boolean"`

	// The name of the report that you want to create. The name must be unique,
	// is case sensitive, and can't include spaces.
	//
	// ReportName is a required field
	ReportName *string `type:"string" required:"true"`

	// Whether you want Amazon Web Services to overwrite the previous version of
	// each report or to deliver the report in addition to the previous versions.
	ReportVersioning *string `type:"string" enum:"ReportVersioning"`

	// The S3 bucket where AWS delivers the report.
	//
	// S3Bucket is a required field
	S3Bucket *string `type:"string" required:"true"`

	// The prefix that AWS adds to the report name when AWS delivers the report.
	// Your prefix can't include spaces.
	//
	// S3Prefix is a required field
	S3Prefix *string `type:"string" required:"true"`

	// The region of the S3 bucket that AWS delivers the report into.
	//
	// S3Region is a required field
	S3Region *string `type:"string" required:"true" enum:"AWSRegion"`

	// The length of time covered by the report.
	//
	// TimeUnit is a required field
	TimeUnit *string `type:"string" required:"true" enum:"TimeUnit"`
}

// String returns the string representation
func (s ReportDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReportDefinition"}
	if s.AdditionalSchemaElements == nil {
		invalidParams.Add(request.NewErrParamRequired("AdditionalSchemaElements"))
	}
	if s.Compression == nil {
		invalidParams.Add(request.NewErrParamRequired("Compression"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.ReportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportName"))
	}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Prefix"))
	}
	if s.S3Region == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Region"))
	}
	if s.TimeUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeUnit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalArtifacts sets the AdditionalArtifacts field's value.
func (s *ReportDefinition) SetAdditionalArtifacts(v []*string) *ReportDefinition {
	s.AdditionalArtifacts = v
	return s
}

// SetAdditionalSchemaElements sets the AdditionalSchemaElements field's value.
func (s *ReportDefinition) SetAdditionalSchemaElements(v []*string) *ReportDefinition {
	s.AdditionalSchemaElements = v
	return s
}

// SetCompression sets the Compression field's value.
func (s *ReportDefinition) SetCompression(v string) *ReportDefinition {
	s.Compression = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ReportDefinition) SetFormat(v string) *ReportDefinition {
	s.Format = &v
	return s
}

// SetRefreshClosedReports sets the RefreshClosedReports field's value.
func (s *ReportDefinition) SetRefreshClosedReports(v bool) *ReportDefinition {
	s.RefreshClosedReports = &v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *ReportDefinition) SetReportName(v string) *ReportDefinition {
	s.ReportName = &v
	return s
}

// SetReportVersioning sets the ReportVersioning field's value.
func (s *ReportDefinition) SetReportVersioning(v string) *ReportDefinition {
	s.ReportVersioning = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *ReportDefinition) SetS3Bucket(v string) *ReportDefinition {
	s.S3Bucket = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *ReportDefinition) SetS3Prefix(v string) *ReportDefinition {
	s.S3Prefix = &v
	return s
}

// SetS3Region sets the S3Region field's value.
func (s *ReportDefinition) SetS3Region(v string) *ReportDefinition {
	s.S3Region = &v
	return s
}

// SetTimeUnit sets the TimeUnit field's value.
func (s *ReportDefinition) SetTimeUnit(v string) *ReportDefinition {
	s.TimeUnit = &v
	return s
}

// This account already has five reports defined. To define a new report, you
// must delete an existing report.
type ReportLimitReachedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	// A message to show the detail of the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ReportLimitReachedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportLimitReachedException) GoString() string {
	return s.String()
}

func newErrorReportLimitReachedException(v protocol.ResponseMetadata) error {
	return &ReportLimitReachedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ReportLimitReachedException) Code() string {
	return "ReportLimitReachedException"
}

// Message returns the exception's message.
func (s ReportLimitReachedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ReportLimitReachedException) OrigErr() error {
	return nil
}

func (s ReportLimitReachedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ReportLimitReachedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ReportLimitReachedException) RequestID() string {
	return s.respMetadata.RequestID
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	// A message to show the detail of the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ValidationException) OrigErr() error {
	return nil
}

func (s ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ValidationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ValidationException) RequestID() string {
	return s.respMetadata.RequestID
}

// The region of the S3 bucket that AWS delivers the report into.
const (
	// AWSRegionUsEast1 is a AWSRegion enum value
	AWSRegionUsEast1 = "us-east-1"

	// AWSRegionUsWest1 is a AWSRegion enum value
	AWSRegionUsWest1 = "us-west-1"

	// AWSRegionUsWest2 is a AWSRegion enum value
	AWSRegionUsWest2 = "us-west-2"

	// AWSRegionEuCentral1 is a AWSRegion enum value
	AWSRegionEuCentral1 = "eu-central-1"

	// AWSRegionEuWest1 is a AWSRegion enum value
	AWSRegionEuWest1 = "eu-west-1"

	// AWSRegionApSoutheast1 is a AWSRegion enum value
	AWSRegionApSoutheast1 = "ap-southeast-1"

	// AWSRegionApSoutheast2 is a AWSRegion enum value
	AWSRegionApSoutheast2 = "ap-southeast-2"

	// AWSRegionApNortheast1 is a AWSRegion enum value
	AWSRegionApNortheast1 = "ap-northeast-1"

	// AWSRegionEuNorth1 is a AWSRegion enum value
	AWSRegionEuNorth1 = "eu-north-1"

	// AWSRegionApNortheast3 is a AWSRegion enum value
	AWSRegionApNortheast3 = "ap-northeast-3"

	// AWSRegionApEast1 is a AWSRegion enum value
	AWSRegionApEast1 = "ap-east-1"
)

// The types of manifest that you want AWS to create for this report.
const (
	// AdditionalArtifactRedshift is a AdditionalArtifact enum value
	AdditionalArtifactRedshift = "REDSHIFT"

	// AdditionalArtifactQuicksight is a AdditionalArtifact enum value
	AdditionalArtifactQuicksight = "QUICKSIGHT"

	// AdditionalArtifactAthena is a AdditionalArtifact enum value
	AdditionalArtifactAthena = "ATHENA"
)

// The compression format that AWS uses for the report.
const (
	// CompressionFormatZip is a CompressionFormat enum value
	CompressionFormatZip = "ZIP"

	// CompressionFormatGzip is a CompressionFormat enum value
	CompressionFormatGzip = "GZIP"

	// CompressionFormatParquet is a CompressionFormat enum value
	CompressionFormatParquet = "Parquet"
)

// The format that AWS saves the report in.
const (
	// ReportFormatTextOrcsv is a ReportFormat enum value
	ReportFormatTextOrcsv = "textORcsv"

	// ReportFormatParquet is a ReportFormat enum value
	ReportFormatParquet = "Parquet"
)

const (
	// ReportVersioningCreateNewReport is a ReportVersioning enum value
	ReportVersioningCreateNewReport = "CREATE_NEW_REPORT"

	// ReportVersioningOverwriteReport is a ReportVersioning enum value
	ReportVersioningOverwriteReport = "OVERWRITE_REPORT"
)

// Whether or not AWS includes resource IDs in the report.
const (
	// SchemaElementResources is a SchemaElement enum value
	SchemaElementResources = "RESOURCES"
)

// The length of time covered by the report.
const (
	// TimeUnitHourly is a TimeUnit enum value
	TimeUnitHourly = "HOURLY"

	// TimeUnitDaily is a TimeUnit enum value
	TimeUnitDaily = "DAILY"
)
