﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iotthingsgraph/IoTThingsGraph_EXPORTS.h>
#include <aws/iotthingsgraph/IoTThingsGraphRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotthingsgraph/model/DefinitionDocument.h>
#include <utility>

namespace Aws
{
namespace IoTThingsGraph
{
namespace Model
{

  /**
   */
  class AWS_IOTTHINGSGRAPH_API UpdateSystemTemplateRequest : public IoTThingsGraphRequest
  {
  public:
    UpdateSystemTemplateRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "UpdateSystemTemplate"; }

    Aws::String SerializePayload() const override;

    Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>The ID of the system to be updated.</p> <p>The ID should be in the following
     * format.</p> <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
     * </p>
     */
    inline const Aws::String& GetId() const{ return m_id; }

    /**
     * <p>The ID of the system to be updated.</p> <p>The ID should be in the following
     * format.</p> <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
     * </p>
     */
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }

    /**
     * <p>The ID of the system to be updated.</p> <p>The ID should be in the following
     * format.</p> <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
     * </p>
     */
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }

    /**
     * <p>The ID of the system to be updated.</p> <p>The ID should be in the following
     * format.</p> <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
     * </p>
     */
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }

    /**
     * <p>The ID of the system to be updated.</p> <p>The ID should be in the following
     * format.</p> <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
     * </p>
     */
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }

    /**
     * <p>The ID of the system to be updated.</p> <p>The ID should be in the following
     * format.</p> <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
     * </p>
     */
    inline UpdateSystemTemplateRequest& WithId(const Aws::String& value) { SetId(value); return *this;}

    /**
     * <p>The ID of the system to be updated.</p> <p>The ID should be in the following
     * format.</p> <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
     * </p>
     */
    inline UpdateSystemTemplateRequest& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}

    /**
     * <p>The ID of the system to be updated.</p> <p>The ID should be in the following
     * format.</p> <p> <code>urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME</code>
     * </p>
     */
    inline UpdateSystemTemplateRequest& WithId(const char* value) { SetId(value); return *this;}


    /**
     * <p>The <code>DefinitionDocument</code> that contains the updated system
     * definition.</p>
     */
    inline const DefinitionDocument& GetDefinition() const{ return m_definition; }

    /**
     * <p>The <code>DefinitionDocument</code> that contains the updated system
     * definition.</p>
     */
    inline bool DefinitionHasBeenSet() const { return m_definitionHasBeenSet; }

    /**
     * <p>The <code>DefinitionDocument</code> that contains the updated system
     * definition.</p>
     */
    inline void SetDefinition(const DefinitionDocument& value) { m_definitionHasBeenSet = true; m_definition = value; }

    /**
     * <p>The <code>DefinitionDocument</code> that contains the updated system
     * definition.</p>
     */
    inline void SetDefinition(DefinitionDocument&& value) { m_definitionHasBeenSet = true; m_definition = std::move(value); }

    /**
     * <p>The <code>DefinitionDocument</code> that contains the updated system
     * definition.</p>
     */
    inline UpdateSystemTemplateRequest& WithDefinition(const DefinitionDocument& value) { SetDefinition(value); return *this;}

    /**
     * <p>The <code>DefinitionDocument</code> that contains the updated system
     * definition.</p>
     */
    inline UpdateSystemTemplateRequest& WithDefinition(DefinitionDocument&& value) { SetDefinition(std::move(value)); return *this;}


    /**
     * <p>The version of the user's namespace. Defaults to the latest version of the
     * user's namespace.</p> <p>If no value is specified, the latest version is used by
     * default.</p>
     */
    inline long long GetCompatibleNamespaceVersion() const{ return m_compatibleNamespaceVersion; }

    /**
     * <p>The version of the user's namespace. Defaults to the latest version of the
     * user's namespace.</p> <p>If no value is specified, the latest version is used by
     * default.</p>
     */
    inline bool CompatibleNamespaceVersionHasBeenSet() const { return m_compatibleNamespaceVersionHasBeenSet; }

    /**
     * <p>The version of the user's namespace. Defaults to the latest version of the
     * user's namespace.</p> <p>If no value is specified, the latest version is used by
     * default.</p>
     */
    inline void SetCompatibleNamespaceVersion(long long value) { m_compatibleNamespaceVersionHasBeenSet = true; m_compatibleNamespaceVersion = value; }

    /**
     * <p>The version of the user's namespace. Defaults to the latest version of the
     * user's namespace.</p> <p>If no value is specified, the latest version is used by
     * default.</p>
     */
    inline UpdateSystemTemplateRequest& WithCompatibleNamespaceVersion(long long value) { SetCompatibleNamespaceVersion(value); return *this;}

  private:

    Aws::String m_id;
    bool m_idHasBeenSet;

    DefinitionDocument m_definition;
    bool m_definitionHasBeenSet;

    long long m_compatibleNamespaceVersion;
    bool m_compatibleNamespaceVersionHasBeenSet;
  };

} // namespace Model
} // namespace IoTThingsGraph
} // namespace Aws
