﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cognito-idp/CognitoIdentityProvider_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CognitoIdentityProvider
{
namespace Model
{
  class AWS_COGNITOIDENTITYPROVIDER_API CreateUserPoolDomainResult
  {
  public:
    CreateUserPoolDomainResult();
    CreateUserPoolDomainResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    CreateUserPoolDomainResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The Amazon CloudFront endpoint that you use as the target of the alias that
     * you set up with your Domain Name Service (DNS) provider.</p>
     */
    inline const Aws::String& GetCloudFrontDomain() const{ return m_cloudFrontDomain; }

    /**
     * <p>The Amazon CloudFront endpoint that you use as the target of the alias that
     * you set up with your Domain Name Service (DNS) provider.</p>
     */
    inline void SetCloudFrontDomain(const Aws::String& value) { m_cloudFrontDomain = value; }

    /**
     * <p>The Amazon CloudFront endpoint that you use as the target of the alias that
     * you set up with your Domain Name Service (DNS) provider.</p>
     */
    inline void SetCloudFrontDomain(Aws::String&& value) { m_cloudFrontDomain = std::move(value); }

    /**
     * <p>The Amazon CloudFront endpoint that you use as the target of the alias that
     * you set up with your Domain Name Service (DNS) provider.</p>
     */
    inline void SetCloudFrontDomain(const char* value) { m_cloudFrontDomain.assign(value); }

    /**
     * <p>The Amazon CloudFront endpoint that you use as the target of the alias that
     * you set up with your Domain Name Service (DNS) provider.</p>
     */
    inline CreateUserPoolDomainResult& WithCloudFrontDomain(const Aws::String& value) { SetCloudFrontDomain(value); return *this;}

    /**
     * <p>The Amazon CloudFront endpoint that you use as the target of the alias that
     * you set up with your Domain Name Service (DNS) provider.</p>
     */
    inline CreateUserPoolDomainResult& WithCloudFrontDomain(Aws::String&& value) { SetCloudFrontDomain(std::move(value)); return *this;}

    /**
     * <p>The Amazon CloudFront endpoint that you use as the target of the alias that
     * you set up with your Domain Name Service (DNS) provider.</p>
     */
    inline CreateUserPoolDomainResult& WithCloudFrontDomain(const char* value) { SetCloudFrontDomain(value); return *this;}

  private:

    Aws::String m_cloudFrontDomain;
  };

} // namespace Model
} // namespace CognitoIdentityProvider
} // namespace Aws
