﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/iotsitewise/IoTSiteWiseRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotsitewise/model/GatewayPlatform.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <utility>

namespace Aws
{
namespace IoTSiteWise
{
namespace Model
{

  /**
   */
  class AWS_IOTSITEWISE_API CreateGatewayRequest : public IoTSiteWiseRequest
  {
  public:
    CreateGatewayRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CreateGateway"; }

    Aws::String SerializePayload() const override;


    /**
     * <p>A unique, friendly name for the gateway.</p>
     */
    inline const Aws::String& GetGatewayName() const{ return m_gatewayName; }

    /**
     * <p>A unique, friendly name for the gateway.</p>
     */
    inline bool GatewayNameHasBeenSet() const { return m_gatewayNameHasBeenSet; }

    /**
     * <p>A unique, friendly name for the gateway.</p>
     */
    inline void SetGatewayName(const Aws::String& value) { m_gatewayNameHasBeenSet = true; m_gatewayName = value; }

    /**
     * <p>A unique, friendly name for the gateway.</p>
     */
    inline void SetGatewayName(Aws::String&& value) { m_gatewayNameHasBeenSet = true; m_gatewayName = std::move(value); }

    /**
     * <p>A unique, friendly name for the gateway.</p>
     */
    inline void SetGatewayName(const char* value) { m_gatewayNameHasBeenSet = true; m_gatewayName.assign(value); }

    /**
     * <p>A unique, friendly name for the gateway.</p>
     */
    inline CreateGatewayRequest& WithGatewayName(const Aws::String& value) { SetGatewayName(value); return *this;}

    /**
     * <p>A unique, friendly name for the gateway.</p>
     */
    inline CreateGatewayRequest& WithGatewayName(Aws::String&& value) { SetGatewayName(std::move(value)); return *this;}

    /**
     * <p>A unique, friendly name for the gateway.</p>
     */
    inline CreateGatewayRequest& WithGatewayName(const char* value) { SetGatewayName(value); return *this;}


    /**
     * <p>The gateway's platform. You can only specify one platform in a gateway.</p>
     */
    inline const GatewayPlatform& GetGatewayPlatform() const{ return m_gatewayPlatform; }

    /**
     * <p>The gateway's platform. You can only specify one platform in a gateway.</p>
     */
    inline bool GatewayPlatformHasBeenSet() const { return m_gatewayPlatformHasBeenSet; }

    /**
     * <p>The gateway's platform. You can only specify one platform in a gateway.</p>
     */
    inline void SetGatewayPlatform(const GatewayPlatform& value) { m_gatewayPlatformHasBeenSet = true; m_gatewayPlatform = value; }

    /**
     * <p>The gateway's platform. You can only specify one platform in a gateway.</p>
     */
    inline void SetGatewayPlatform(GatewayPlatform&& value) { m_gatewayPlatformHasBeenSet = true; m_gatewayPlatform = std::move(value); }

    /**
     * <p>The gateway's platform. You can only specify one platform in a gateway.</p>
     */
    inline CreateGatewayRequest& WithGatewayPlatform(const GatewayPlatform& value) { SetGatewayPlatform(value); return *this;}

    /**
     * <p>The gateway's platform. You can only specify one platform in a gateway.</p>
     */
    inline CreateGatewayRequest& WithGatewayPlatform(GatewayPlatform&& value) { SetGatewayPlatform(std::move(value)); return *this;}


    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline const Aws::Map<Aws::String, Aws::String>& GetTags() const{ return m_tags; }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline void SetTags(const Aws::Map<Aws::String, Aws::String>& value) { m_tagsHasBeenSet = true; m_tags = value; }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline void SetTags(Aws::Map<Aws::String, Aws::String>&& value) { m_tagsHasBeenSet = true; m_tags = std::move(value); }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline CreateGatewayRequest& WithTags(const Aws::Map<Aws::String, Aws::String>& value) { SetTags(value); return *this;}

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline CreateGatewayRequest& WithTags(Aws::Map<Aws::String, Aws::String>&& value) { SetTags(std::move(value)); return *this;}

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline CreateGatewayRequest& AddTags(const Aws::String& key, const Aws::String& value) { m_tagsHasBeenSet = true; m_tags.emplace(key, value); return *this; }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline CreateGatewayRequest& AddTags(Aws::String&& key, const Aws::String& value) { m_tagsHasBeenSet = true; m_tags.emplace(std::move(key), value); return *this; }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline CreateGatewayRequest& AddTags(const Aws::String& key, Aws::String&& value) { m_tagsHasBeenSet = true; m_tags.emplace(key, std::move(value)); return *this; }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline CreateGatewayRequest& AddTags(Aws::String&& key, Aws::String&& value) { m_tagsHasBeenSet = true; m_tags.emplace(std::move(key), std::move(value)); return *this; }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline CreateGatewayRequest& AddTags(const char* key, Aws::String&& value) { m_tagsHasBeenSet = true; m_tags.emplace(key, std::move(value)); return *this; }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline CreateGatewayRequest& AddTags(Aws::String&& key, const char* value) { m_tagsHasBeenSet = true; m_tags.emplace(std::move(key), value); return *this; }

    /**
     * <p>A list of key-value pairs that contain metadata for the gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging
     * your AWS IoT SiteWise resources</a> in the <i>AWS IoT SiteWise User
     * Guide</i>.</p>
     */
    inline CreateGatewayRequest& AddTags(const char* key, const char* value) { m_tagsHasBeenSet = true; m_tags.emplace(key, value); return *this; }

  private:

    Aws::String m_gatewayName;
    bool m_gatewayNameHasBeenSet;

    GatewayPlatform m_gatewayPlatform;
    bool m_gatewayPlatformHasBeenSet;

    Aws::Map<Aws::String, Aws::String> m_tags;
    bool m_tagsHasBeenSet;
  };

} // namespace Model
} // namespace IoTSiteWise
} // namespace Aws
