﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/pinpoint/model/UpdateEndpointsBatchRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Pinpoint::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

UpdateEndpointsBatchRequest::UpdateEndpointsBatchRequest() : 
    m_applicationIdHasBeenSet(false),
    m_endpointBatchRequestHasBeenSet(false)
{
}

Aws::String UpdateEndpointsBatchRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_endpointBatchRequestHasBeenSet)
  {
   payload = m_endpointBatchRequest.Jsonize();
  }

  return payload.View().WriteReadable();
}




