﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/quicksight/model/CreateColumnsOperation.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace QuickSight
{
namespace Model
{

CreateColumnsOperation::CreateColumnsOperation() : 
    m_columnsHasBeenSet(false)
{
}

CreateColumnsOperation::CreateColumnsOperation(JsonView jsonValue) : 
    m_columnsHasBeenSet(false)
{
  *this = jsonValue;
}

CreateColumnsOperation& CreateColumnsOperation::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Columns"))
  {
    Array<JsonView> columnsJsonList = jsonValue.GetArray("Columns");
    for(unsigned columnsIndex = 0; columnsIndex < columnsJsonList.GetLength(); ++columnsIndex)
    {
      m_columns.push_back(columnsJsonList[columnsIndex].AsObject());
    }
    m_columnsHasBeenSet = true;
  }

  return *this;
}

JsonValue CreateColumnsOperation::Jsonize() const
{
  JsonValue payload;

  if(m_columnsHasBeenSet)
  {
   Array<JsonValue> columnsJsonList(m_columns.size());
   for(unsigned columnsIndex = 0; columnsIndex < columnsJsonList.GetLength(); ++columnsIndex)
   {
     columnsJsonList[columnsIndex].AsObject(m_columns[columnsIndex].Jsonize());
   }
   payload.WithArray("Columns", std::move(columnsJsonList));

  }

  return payload;
}

} // namespace Model
} // namespace QuickSight
} // namespace Aws
