﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/sagemaker/model/NotebookInstanceSortOrder.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace SageMaker
  {
    namespace Model
    {
      namespace NotebookInstanceSortOrderMapper
      {

        static const int Ascending_HASH = HashingUtils::HashString("Ascending");
        static const int Descending_HASH = HashingUtils::HashString("Descending");


        NotebookInstanceSortOrder GetNotebookInstanceSortOrderForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == Ascending_HASH)
          {
            return NotebookInstanceSortOrder::Ascending;
          }
          else if (hashCode == Descending_HASH)
          {
            return NotebookInstanceSortOrder::Descending;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<NotebookInstanceSortOrder>(hashCode);
          }

          return NotebookInstanceSortOrder::NOT_SET;
        }

        Aws::String GetNameForNotebookInstanceSortOrder(NotebookInstanceSortOrder enumValue)
        {
          switch(enumValue)
          {
          case NotebookInstanceSortOrder::Ascending:
            return "Ascending";
          case NotebookInstanceSortOrder::Descending:
            return "Descending";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace NotebookInstanceSortOrderMapper
    } // namespace Model
  } // namespace SageMaker
} // namespace Aws
