﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>
#include <aws/sso-admin/SSOAdminRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sso-admin/model/TargetType.h>
#include <aws/sso-admin/model/PrincipalType.h>
#include <utility>

namespace Aws
{
namespace SSOAdmin
{
namespace Model
{

  /**
   */
  class AWS_SSOADMIN_API CreateAccountAssignmentRequest : public SSOAdminRequest
  {
  public:
    CreateAccountAssignmentRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CreateAccountAssignment"; }

    Aws::String SerializePayload() const override;

    Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>The ARN of the SSO instance under which the operation will be executed. For
     * more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline const Aws::String& GetInstanceArn() const{ return m_instanceArn; }

    /**
     * <p>The ARN of the SSO instance under which the operation will be executed. For
     * more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline bool InstanceArnHasBeenSet() const { return m_instanceArnHasBeenSet; }

    /**
     * <p>The ARN of the SSO instance under which the operation will be executed. For
     * more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline void SetInstanceArn(const Aws::String& value) { m_instanceArnHasBeenSet = true; m_instanceArn = value; }

    /**
     * <p>The ARN of the SSO instance under which the operation will be executed. For
     * more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline void SetInstanceArn(Aws::String&& value) { m_instanceArnHasBeenSet = true; m_instanceArn = std::move(value); }

    /**
     * <p>The ARN of the SSO instance under which the operation will be executed. For
     * more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline void SetInstanceArn(const char* value) { m_instanceArnHasBeenSet = true; m_instanceArn.assign(value); }

    /**
     * <p>The ARN of the SSO instance under which the operation will be executed. For
     * more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline CreateAccountAssignmentRequest& WithInstanceArn(const Aws::String& value) { SetInstanceArn(value); return *this;}

    /**
     * <p>The ARN of the SSO instance under which the operation will be executed. For
     * more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline CreateAccountAssignmentRequest& WithInstanceArn(Aws::String&& value) { SetInstanceArn(std::move(value)); return *this;}

    /**
     * <p>The ARN of the SSO instance under which the operation will be executed. For
     * more information about ARNs, see <a
     * href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.</p>
     */
    inline CreateAccountAssignmentRequest& WithInstanceArn(const char* value) { SetInstanceArn(value); return *this;}


    /**
     * <p>TargetID is an AWS account identifier, typically a 10-12 digit string (For
     * example, 123456789012).</p>
     */
    inline const Aws::String& GetTargetId() const{ return m_targetId; }

    /**
     * <p>TargetID is an AWS account identifier, typically a 10-12 digit string (For
     * example, 123456789012).</p>
     */
    inline bool TargetIdHasBeenSet() const { return m_targetIdHasBeenSet; }

    /**
     * <p>TargetID is an AWS account identifier, typically a 10-12 digit string (For
     * example, 123456789012).</p>
     */
    inline void SetTargetId(const Aws::String& value) { m_targetIdHasBeenSet = true; m_targetId = value; }

    /**
     * <p>TargetID is an AWS account identifier, typically a 10-12 digit string (For
     * example, 123456789012).</p>
     */
    inline void SetTargetId(Aws::String&& value) { m_targetIdHasBeenSet = true; m_targetId = std::move(value); }

    /**
     * <p>TargetID is an AWS account identifier, typically a 10-12 digit string (For
     * example, 123456789012).</p>
     */
    inline void SetTargetId(const char* value) { m_targetIdHasBeenSet = true; m_targetId.assign(value); }

    /**
     * <p>TargetID is an AWS account identifier, typically a 10-12 digit string (For
     * example, 123456789012).</p>
     */
    inline CreateAccountAssignmentRequest& WithTargetId(const Aws::String& value) { SetTargetId(value); return *this;}

    /**
     * <p>TargetID is an AWS account identifier, typically a 10-12 digit string (For
     * example, 123456789012).</p>
     */
    inline CreateAccountAssignmentRequest& WithTargetId(Aws::String&& value) { SetTargetId(std::move(value)); return *this;}

    /**
     * <p>TargetID is an AWS account identifier, typically a 10-12 digit string (For
     * example, 123456789012).</p>
     */
    inline CreateAccountAssignmentRequest& WithTargetId(const char* value) { SetTargetId(value); return *this;}


    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline const TargetType& GetTargetType() const{ return m_targetType; }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline bool TargetTypeHasBeenSet() const { return m_targetTypeHasBeenSet; }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline void SetTargetType(const TargetType& value) { m_targetTypeHasBeenSet = true; m_targetType = value; }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline void SetTargetType(TargetType&& value) { m_targetTypeHasBeenSet = true; m_targetType = std::move(value); }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline CreateAccountAssignmentRequest& WithTargetType(const TargetType& value) { SetTargetType(value); return *this;}

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline CreateAccountAssignmentRequest& WithTargetType(TargetType&& value) { SetTargetType(std::move(value)); return *this;}


    /**
     * <p>The ARN of the permission set that the admin wants to grant the principal
     * access to.</p>
     */
    inline const Aws::String& GetPermissionSetArn() const{ return m_permissionSetArn; }

    /**
     * <p>The ARN of the permission set that the admin wants to grant the principal
     * access to.</p>
     */
    inline bool PermissionSetArnHasBeenSet() const { return m_permissionSetArnHasBeenSet; }

    /**
     * <p>The ARN of the permission set that the admin wants to grant the principal
     * access to.</p>
     */
    inline void SetPermissionSetArn(const Aws::String& value) { m_permissionSetArnHasBeenSet = true; m_permissionSetArn = value; }

    /**
     * <p>The ARN of the permission set that the admin wants to grant the principal
     * access to.</p>
     */
    inline void SetPermissionSetArn(Aws::String&& value) { m_permissionSetArnHasBeenSet = true; m_permissionSetArn = std::move(value); }

    /**
     * <p>The ARN of the permission set that the admin wants to grant the principal
     * access to.</p>
     */
    inline void SetPermissionSetArn(const char* value) { m_permissionSetArnHasBeenSet = true; m_permissionSetArn.assign(value); }

    /**
     * <p>The ARN of the permission set that the admin wants to grant the principal
     * access to.</p>
     */
    inline CreateAccountAssignmentRequest& WithPermissionSetArn(const Aws::String& value) { SetPermissionSetArn(value); return *this;}

    /**
     * <p>The ARN of the permission set that the admin wants to grant the principal
     * access to.</p>
     */
    inline CreateAccountAssignmentRequest& WithPermissionSetArn(Aws::String&& value) { SetPermissionSetArn(std::move(value)); return *this;}

    /**
     * <p>The ARN of the permission set that the admin wants to grant the principal
     * access to.</p>
     */
    inline CreateAccountAssignmentRequest& WithPermissionSetArn(const char* value) { SetPermissionSetArn(value); return *this;}


    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline const PrincipalType& GetPrincipalType() const{ return m_principalType; }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline bool PrincipalTypeHasBeenSet() const { return m_principalTypeHasBeenSet; }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline void SetPrincipalType(const PrincipalType& value) { m_principalTypeHasBeenSet = true; m_principalType = value; }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline void SetPrincipalType(PrincipalType&& value) { m_principalTypeHasBeenSet = true; m_principalType = std::move(value); }

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline CreateAccountAssignmentRequest& WithPrincipalType(const PrincipalType& value) { SetPrincipalType(value); return *this;}

    /**
     * <p>The entity type for which the assignment will be created.</p>
     */
    inline CreateAccountAssignmentRequest& WithPrincipalType(PrincipalType&& value) { SetPrincipalType(std::move(value)); return *this;}


    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline const Aws::String& GetPrincipalId() const{ return m_principalId; }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline bool PrincipalIdHasBeenSet() const { return m_principalIdHasBeenSet; }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline void SetPrincipalId(const Aws::String& value) { m_principalIdHasBeenSet = true; m_principalId = value; }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline void SetPrincipalId(Aws::String&& value) { m_principalIdHasBeenSet = true; m_principalId = std::move(value); }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline void SetPrincipalId(const char* value) { m_principalIdHasBeenSet = true; m_principalId.assign(value); }

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline CreateAccountAssignmentRequest& WithPrincipalId(const Aws::String& value) { SetPrincipalId(value); return *this;}

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline CreateAccountAssignmentRequest& WithPrincipalId(Aws::String&& value) { SetPrincipalId(std::move(value)); return *this;}

    /**
     * <p>An identifier for an object in AWS SSO, such as a user or group. PrincipalIds
     * are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more
     * information about PrincipalIds in AWS SSO, see the <a
     * href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">AWS SSO
     * Identity Store API Reference</a>.</p>
     */
    inline CreateAccountAssignmentRequest& WithPrincipalId(const char* value) { SetPrincipalId(value); return *this;}

  private:

    Aws::String m_instanceArn;
    bool m_instanceArnHasBeenSet;

    Aws::String m_targetId;
    bool m_targetIdHasBeenSet;

    TargetType m_targetType;
    bool m_targetTypeHasBeenSet;

    Aws::String m_permissionSetArn;
    bool m_permissionSetArnHasBeenSet;

    PrincipalType m_principalType;
    bool m_principalTypeHasBeenSet;

    Aws::String m_principalId;
    bool m_principalIdHasBeenSet;
  };

} // namespace Model
} // namespace SSOAdmin
} // namespace Aws
