/*-
 * Public Domain 2014-present MongoDB, Inc.
 * Public Domain 2008-2014 WiredTiger, Inc.
 *
 * This is free and unencumbered software released into the public domain.
 *
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 *
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef RANDOM_GENERATOR_H
#define RANDOM_GENERATOR_H

#include <random>
#include <string>

namespace test_harness {
/* Helper class to generate random values using uniform distributions. */
class random_generator {
    public:
    static random_generator &instance();

    public:
    /* No copies of the singleton allowed. */
    random_generator(random_generator const &) = delete;
    random_generator &operator=(random_generator const &) = delete;

    /* Generate a random string of a given length. */
    std::string generate_string(std::size_t length);

    /* Generate a pseudo random string which compresses better. */
    std::string generate_pseudo_random_string(std::size_t length);

    /* Generate a random integer between min and max. */
    template <typename T>
    T
    generate_integer(T min, T max)
    {
        std::uniform_int_distribution<T> dis(min, max);
        return dis(_generator);
    }

    private:
    random_generator();

    std::mt19937 _generator;
    std::uniform_int_distribution<> _distribution;
    const std::string _characters =
      "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
};
} // namespace test_harness

#endif
