/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/dtl/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojox/string/tokenize","dojo/_base/json","dojo/dom","dojo/_base/xhr","dojox/string/Builder","dojo/_base/Deferred"],function(_1,_2,_3,_4,_5,_6,_7,_8){_1.experimental("dojox.dtl");var dd=_2.getObject("dojox.dtl",true);dd._base={};dd.TOKEN_BLOCK=-1;dd.TOKEN_VAR=-2;dd.TOKEN_COMMENT=-3;dd.TOKEN_TEXT=3;dd._Context=_2.extend(function(_9){if(_9){_2._mixin(this,_9);if(_9.get){this._getter=_9.get;delete this.get;}}},{push:function(){var _a=this;var _b=_2.delegate(this);_b.pop=function(){return _a;};return _b;},pop:function(){throw new Error("pop() called on empty Context");},get:function(_c,_d){var n=this._normalize;if(this._getter){var _e=this._getter(_c);if(_e!==undefined){return n(_e);}}if(this[_c]!==undefined){return n(this[_c]);}return _d;},_normalize:function(_f){if(_f instanceof Date){_f.year=_f.getFullYear();_f.month=_f.getMonth()+1;_f.day=_f.getDate();_f.date=_f.year+"-"+("0"+_f.month).slice(-2)+"-"+("0"+_f.day).slice(-2);_f.hour=_f.getHours();_f.minute=_f.getMinutes();_f.second=_f.getSeconds();_f.microsecond=_f.getMilliseconds();}return _f;},update:function(_10){var _11=this.push();if(_10){_2._mixin(this,_10);}return _11;}});var _12=/("(?:[^"\\]*(?:\\.[^"\\]*)*)"|'(?:[^'\\]*(?:\\.[^'\\]*)*)'|[^\s]+)/g;var _13=/\s+/g;var _14=function(_15,_16){_15=_15||_13;if(!(_15 instanceof RegExp)){_15=new RegExp(_15,"g");}if(!_15.global){throw new Error("You must use a globally flagged RegExp with split "+_15);}_15.exec("");var _17,_18=[],_19=0,i=0;while((_17=_15.exec(this))){_18.push(this.slice(_19,_15.lastIndex-_17[0].length));_19=_15.lastIndex;if(_16&&(++i>_16-1)){break;}}_18.push(this.slice(_19));return _18;};dd.Token=function(_1a,_1b){this.token_type=_1a;this.contents=new String(_2.trim(_1b));this.contents.split=_14;this.split=function(){return String.prototype.split.apply(this.contents,arguments);};};dd.Token.prototype.split_contents=function(_1c){var bit,_1d=[],i=0;_1c=_1c||999;while(i++<_1c&&(bit=_12.exec(this.contents))){bit=bit[0];if(bit.charAt(0)=="\""&&bit.slice(-1)=="\""){_1d.push("\""+bit.slice(1,-1).replace("\\\"","\"").replace("\\\\","\\")+"\"");}else{if(bit.charAt(0)=="'"&&bit.slice(-1)=="'"){_1d.push("'"+bit.slice(1,-1).replace("\\'","'").replace("\\\\","\\")+"'");}else{_1d.push(bit);}}}return _1d;};var ddt=dd.text={_get:function(_1e,_1f,_20){var _21=dd.register.get(_1e,_1f.toLowerCase(),_20);if(!_21){if(!_20){throw new Error("No tag found for "+_1f);}return null;}var fn=_21[1];var _22=_21[2];var _23;if(fn.indexOf(":")!=-1){_23=fn.split(":");fn=_23.pop();}var mod=_22;if(/\./.test(_22)){_22=_22.replace(/\./g,"/");}require([_22],function(){});var _24=_2.getObject(mod);return _24[fn||_1f]||_24[_1f+"_"]||_24[fn+"_"];},getTag:function(_25,_26){return ddt._get("tag",_25,_26);},getFilter:function(_27,_28){return ddt._get("filter",_27,_28);},getTemplate:function(_29){return new dd.Template(ddt.getTemplateString(_29));},getTemplateString:function(_2a){return _6._getText(_2a.toString())||"";},_resolveLazy:function(_2b,_2c,_2d){if(_2c){if(_2d){return _2d.fromJson(_6._getText(_2b))||{};}else{return dd.text.getTemplateString(_2b);}}else{return _6.get({handleAs:_2d?"json":"text",url:_2b});}},_resolveTemplateArg:function(arg,_2e){if(ddt._isTemplate(arg)){if(!_2e){var d=new _8();d.callback(arg);return d;}return arg;}return ddt._resolveLazy(arg,_2e);},_isTemplate:function(arg){return (arg===undefined)||(typeof arg=="string"&&(arg.match(/^\s*[<{]/)||arg.indexOf(" ")!=-1));},_resolveContextArg:function(arg,_2f){if(arg.constructor==Object){if(!_2f){var d=new _8;d.callback(arg);return d;}return arg;}return ddt._resolveLazy(arg,_2f,true);},_re:/(?:\{\{\s*(.+?)\s*\}\}|\{%\s*(load\s*)?(.+?)\s*%\})/g,tokenize:function(str){return _3(str,ddt._re,ddt._parseDelims);},_parseDelims:function(_30,_31,tag){if(_30){return [dd.TOKEN_VAR,_30];}else{if(_31){var _32=_2.trim(tag).split(/\s+/g);for(var i=0,_33;_33=_32[i];i++){if(/\./.test(_33)){_33=_33.replace(/\./g,"/");}require([_33]);}}else{return [dd.TOKEN_BLOCK,tag];}}}};dd.Template=_2.extend(function(_34,_35){var str=_35?_34:ddt._resolveTemplateArg(_34,true)||"";var _36=ddt.tokenize(str);var _37=new dd._Parser(_36);this.nodelist=_37.parse();},{update:function(_38,_39){return ddt._resolveContextArg(_39).addCallback(this,function(_3a){var _3b=this.render(new dd._Context(_3a));if(_38.forEach){_38.forEach(function(_3c){_3c.innerHTML=_3b;});}else{_5.byId(_38).innerHTML=_3b;}return this;});},render:function(_3d,_3e){_3e=_3e||this.getBuffer();_3d=_3d||new dd._Context({});return this.nodelist.render(_3d,_3e)+"";},getBuffer:function(){return new _7();}});var _3f=/\{\{\s*(.+?)\s*\}\}/g;dd.quickFilter=function(str){if(!str){return new dd._NodeList();}if(str.indexOf("{%")==-1){return new dd._QuickNodeList(_3(str,_3f,function(_40){return new dd._Filter(_40);}));}};dd._QuickNodeList=_2.extend(function(_41){this.contents=_41;},{render:function(_42,_43){for(var i=0,l=this.contents.length;i<l;i++){if(this.contents[i].resolve){_43=_43.concat(this.contents[i].resolve(_42));}else{_43=_43.concat(this.contents[i]);}}return _43;},dummyRender:function(_44){return this.render(_44,dd.Template.prototype.getBuffer()).toString();},clone:function(_45){return this;}});dd._Filter=_2.extend(function(_46){if(!_46){throw new Error("Filter must be called with variable name");}this.contents=_46;var _47=this._cache[_46];if(_47){this.key=_47[0];this.filters=_47[1];}else{this.filters=[];_3(_46,this._re,this._tokenize,this);this._cache[_46]=[this.key,this.filters];}},{_cache:{},_re:/(?:^_\("([^\\"]*(?:\\.[^\\"])*)"\)|^"([^\\"]*(?:\\.[^\\"]*)*)"|^([a-zA-Z0-9_.]+)|\|(\w+)(?::(?:_\("([^\\"]*(?:\\.[^\\"])*)"\)|"([^\\"]*(?:\\.[^\\"]*)*)"|([a-zA-Z0-9_.]+)|'([^\\']*(?:\\.[^\\']*)*)'))?|^'([^\\']*(?:\\.[^\\']*)*)')/g,_values:{0:"\"",1:"\"",2:"",8:"\""},_args:{4:"\"",5:"\"",6:"",7:"'"},_tokenize:function(){var pos,arg;for(var i=0,has=[];i<arguments.length;i++){has[i]=(arguments[i]!==undefined&&typeof arguments[i]=="string"&&arguments[i]);}if(!this.key){for(pos in this._values){if(has[pos]){this.key=this._values[pos]+arguments[pos]+this._values[pos];break;}}}else{for(pos in this._args){if(has[pos]){var _48=arguments[pos];if(this._args[pos]=="'"){_48=_48.replace(/\\'/g,"'");}else{if(this._args[pos]=="\""){_48=_48.replace(/\\"/g,"\"");}}arg=[!this._args[pos],_48];break;}}var fn=ddt.getFilter(arguments[3]);if(!_2.isFunction(fn)){throw new Error(arguments[3]+" is not registered as a filter");}this.filters.push([fn,arg]);}},getExpression:function(){return this.contents;},resolve:function(_49){if(this.key===undefined){return "";}var str=this.resolvePath(this.key,_49);for(var i=0,_4a;_4a=this.filters[i];i++){if(_4a[1]){if(_4a[1][0]){str=_4a[0](str,this.resolvePath(_4a[1][1],_49));}else{str=_4a[0](str,_4a[1][1]);}}else{str=_4a[0](str);}}return str;},resolvePath:function(_4b,_4c){var _4d,_4e;var _4f=_4b.charAt(0);var _50=_4b.slice(-1);if(!isNaN(parseInt(_4f))){_4d=(_4b.indexOf(".")==-1)?parseInt(_4b):parseFloat(_4b);}else{if(_4f=="\""&&_4f==_50){_4d=_4b.slice(1,-1);}else{if(_4b=="true"){return true;}if(_4b=="false"){return false;}if(_4b=="null"||_4b=="None"){return null;}_4e=_4b.split(".");_4d=_4c.get(_4e[0]);if(_2.isFunction(_4d)){var _51=_4c.getThis&&_4c.getThis();if(_4d.alters_data){_4d="";}else{if(_51){_4d=_4d.call(_51);}else{_4d="";}}}for(var i=1;i<_4e.length;i++){var _52=_4e[i];if(_4d){var _53=_4d;if(_2.isObject(_4d)&&_52=="items"&&_4d[_52]===undefined){var _54=[];for(var key in _4d){_54.push([key,_4d[key]]);}_4d=_54;continue;}if(_4d.get&&_2.isFunction(_4d.get)&&_4d.get.safe){_4d=_4d.get(_52);}else{if(_4d[_52]===undefined){_4d=_4d[_52];break;}else{_4d=_4d[_52];}}if(_2.isFunction(_4d)){if(_4d.alters_data){_4d="";}else{_4d=_4d.call(_53);}}else{if(_4d instanceof Date){_4d=dd._Context.prototype._normalize(_4d);}}}else{return "";}}}}return _4d;}});dd._TextNode=dd._Node=_2.extend(function(obj){this.contents=obj;},{set:function(_55){this.contents=_55;return this;},render:function(_56,_57){return _57.concat(this.contents);},isEmpty:function(){return !_2.trim(this.contents);},clone:function(){return this;}});dd._NodeList=_2.extend(function(_58){this.contents=_58||[];this.last="";},{push:function(_59){this.contents.push(_59);return this;},concat:function(_5a){this.contents=this.contents.concat(_5a);return this;},render:function(_5b,_5c){for(var i=0;i<this.contents.length;i++){_5c=this.contents[i].render(_5b,_5c);if(!_5c){throw new Error("Template must return buffer");}}return _5c;},dummyRender:function(_5d){return this.render(_5d,dd.Template.prototype.getBuffer()).toString();},unrender:function(){return arguments[1];},clone:function(){return this;},rtrim:function(){while(1){i=this.contents.length-1;if(this.contents[i] instanceof dd._TextNode&&this.contents[i].isEmpty()){this.contents.pop();}else{break;}}return this;}});dd._VarNode=_2.extend(function(str){this.contents=new dd._Filter(str);},{render:function(_5e,_5f){var str=this.contents.resolve(_5e);if(!str.safe){str=dd._base.escape(""+str);}return _5f.concat(str);}});dd._noOpNode=new function(){this.render=this.unrender=function(){return arguments[1];};this.clone=function(){return this;};};dd._Parser=_2.extend(function(_60){this.contents=_60;},{i:0,parse:function(_61){var _62={},_63;_61=_61||[];for(var i=0;i<_61.length;i++){_62[_61[i]]=true;}var _64=new dd._NodeList();while(this.i<this.contents.length){_63=this.contents[this.i++];if(typeof _63=="string"){_64.push(new dd._TextNode(_63));}else{var _65=_63[0];var _66=_63[1];if(_65==dd.TOKEN_VAR){_64.push(new dd._VarNode(_66));}else{if(_65==dd.TOKEN_BLOCK){if(_62[_66]){--this.i;return _64;}var cmd=_66.split(/\s+/g);if(cmd.length){cmd=cmd[0];var fn=ddt.getTag(cmd);if(fn){_64.push(fn(this,new dd.Token(_65,_66)));}}}}}}if(_61.length){throw new Error("Could not find closing tag(s): "+_61.toString());}this.contents.length=0;return _64;},next_token:function(){var _67=this.contents[this.i++];return new dd.Token(_67[0],_67[1]);},delete_first_token:function(){this.i++;},skip_past:function(_68){while(this.i<this.contents.length){var _69=this.contents[this.i++];if(_69[0]==dd.TOKEN_BLOCK&&_69[1]==_68){return;}}throw new Error("Unclosed tag found when looking for "+_68);},create_variable_node:function(_6a){return new dd._VarNode(_6a);},create_text_node:function(_6b){return new dd._TextNode(_6b||"");},getTemplate:function(_6c){return new dd.Template(_6c);}});dd.register={_registry:{attributes:[],tags:[],filters:[]},get:function(_6d,_6e){var _6f=dd.register._registry[_6d+"s"];for(var i=0,_70;_70=_6f[i];i++){if(typeof _70[0]=="string"){if(_70[0]==_6e){return _70;}}else{if(_6e.match(_70[0])){return _70;}}}},getAttributeTags:function(){var _71=[];var _72=dd.register._registry.attributes;for(var i=0,_73;_73=_72[i];i++){if(_73.length==3){_71.push(_73);}else{var fn=_2.getObject(_73[1]);if(fn&&_2.isFunction(fn)){_73.push(fn);_71.push(_73);}}}return _71;},_any:function(_74,_75,_76){for(var _77 in _76){for(var i=0,fn;fn=_76[_77][i];i++){var key=fn;if(_2.isArray(fn)){key=fn[0];fn=fn[1];}if(typeof key=="string"){if(key.substr(0,5)=="attr:"){var _78=fn;if(_78.substr(0,5)=="attr:"){_78=_78.slice(5);}dd.register._registry.attributes.push([_78.toLowerCase(),_75+"."+_77+"."+_78]);}key=key.toLowerCase();}dd.register._registry[_74].push([key,fn,_75+"."+_77]);}}},tags:function(_79,_7a){dd.register._any("tags",_79,_7a);},filters:function(_7b,_7c){dd.register._any("filters",_7b,_7c);}};var _7d=/&/g;var _7e=/</g;var _7f=/>/g;var _80=/'/g;var _81=/"/g;dd._base.escape=function(_82){return dd.mark_safe(_82.replace(_7d,"&amp;").replace(_7e,"&lt;").replace(_7f,"&gt;").replace(_81,"&quot;").replace(_80,"&#39;"));};dd._base.safe=function(_83){if(typeof _83=="string"){_83=new String(_83);}if(typeof _83=="object"){_83.safe=true;}return _83;};dd.mark_safe=dd._base.safe;dd.register.tags("dojox.dtl.tag",{"date":["now"],"logic":["if","for","ifequal","ifnotequal"],"loader":["extends","block","include","load","ssi"],"misc":["comment","debug","filter","firstof","spaceless","templatetag","widthratio","with"],"loop":["cycle","ifchanged","regroup"]});dd.register.filters("dojox.dtl.filter",{"dates":["date","time","timesince","timeuntil"],"htmlstrings":["linebreaks","linebreaksbr","removetags","striptags"],"integers":["add","get_digit"],"lists":["dictsort","dictsortreversed","first","join","length","length_is","random","slice","unordered_list"],"logic":["default","default_if_none","divisibleby","yesno"],"misc":["filesizeformat","pluralize","phone2numeric","pprint"],"strings":["addslashes","capfirst","center","cut","fix_ampersands","floatformat","iriencode","linenumbers","ljust","lower","make_list","rjust","slugify","stringformat","title","truncatewords","truncatewords_html","upper","urlencode","urlize","urlizetrunc","wordcount","wordwrap"]});dd.register.filters("dojox.dtl",{"_base":["escape","safe"]});return dd;});},"dojox/dtl/tag/loader":function(){define("dojox/dtl/tag/loader",["dojo/_base/lang","../_base","dojo/_base/array","dojo/_base/connect"],function(_84,dd,_85,_86){_84.getObject("dojox.dtl.tag.loader",true);var _87=dd.tag.loader;_87.BlockNode=_84.extend(function(_88,_89){this.name=_88;this.nodelist=_89;},{"super":function(){if(this.parent){var _8a=this.parent.nodelist.dummyRender(this.context,null,true);if(typeof _8a=="string"){_8a=new String(_8a);}_8a.safe=true;return _8a;}return "";},render:function(_8b,_8c){var _8d=this.name;var _8e=this.nodelist;var _8f;if(_8c.blocks){var _90=_8c.blocks[_8d];if(_90){_8f=_90.parent;_8e=_90.nodelist;_90.used=true;}}this.rendered=_8e;_8b=_8b.push();this.context=_8b;this.parent=null;if(_8e!=this.nodelist){this.parent=this;}_8b.block=this;if(_8c.getParent){var _91=_8c.getParent();var _92=_86.connect(_8c,"onSetParent",function(_93,up,_94){if(up&&_94){_8c.setParent(_91);}});}_8c=_8e.render(_8b,_8c,this);_92&&_86.disconnect(_92);_8b=_8b.pop();return _8c;},unrender:function(_95,_96){return this.rendered.unrender(_95,_96);},clone:function(_97){return new this.constructor(this.name,this.nodelist.clone(_97));},toString:function(){return "dojox.dtl.tag.loader.BlockNode";}});_87.ExtendsNode=_84.extend(function(_98,_99,_9a,_9b,key){this.getTemplate=_98;this.nodelist=_99;this.shared=_9a;this.parent=_9b;this.key=key;},{parents:{},getParent:function(_9c){var _9d=this.parent;if(!_9d){var _9e;_9d=this.parent=_9c.get(this.key,false);if(!_9d){throw new Error("extends tag used a variable that did not resolve");}if(typeof _9d=="object"){var url=_9d.url||_9d.templatePath;if(_9d.shared){this.shared=true;}if(url){_9d=this.parent=url.toString();}else{if(_9d.templateString){_9e=_9d.templateString;_9d=this.parent=" ";}else{_9d=this.parent=this.parent.toString();}}}if(_9d&&_9d.indexOf("shared:")===0){this.shared=true;_9d=this.parent=_9d.substring(7,_9d.length);}}if(!_9d){throw new Error("Invalid template name in 'extends' tag.");}if(_9d.render){return _9d;}if(this.parents[_9d]){return this.parents[_9d];}this.parent=this.getTemplate(_9e||dojox.dtl.text.getTemplateString(_9d));if(this.shared){this.parents[_9d]=this.parent;}return this.parent;},render:function(_9f,_a0){var _a1=this.getParent(_9f);_a1.blocks=_a1.blocks||{};_a0.blocks=_a0.blocks||{};for(var i=0,_a2;_a2=this.nodelist.contents[i];i++){if(_a2 instanceof dojox.dtl.tag.loader.BlockNode){var old=_a1.blocks[_a2.name];if(old&&old.nodelist!=_a2.nodelist){_a0=old.nodelist.unrender(_9f,_a0);}_a1.blocks[_a2.name]=_a0.blocks[_a2.name]={shared:this.shared,nodelist:_a2.nodelist,used:false};}}this.rendered=_a1;return _a1.nodelist.render(_9f,_a0,this);},unrender:function(_a3,_a4){return this.rendered.unrender(_a3,_a4,this);},toString:function(){return "dojox.dtl.block.ExtendsNode";}});_87.IncludeNode=_84.extend(function(_a5,_a6,_a7,_a8,_a9){this._path=_a5;this.constant=_a6;this.path=(_a6)?_a5:new dd._Filter(_a5);this.getTemplate=_a7;this.text=_a8;this.parsed=(arguments.length==5)?_a9:true;},{_cache:[{},{}],render:function(_aa,_ab){var _ac=((this.constant)?this.path:this.path.resolve(_aa)).toString();var _ad=Number(this.parsed);var _ae=false;if(_ac!=this.last){_ae=true;if(this.last){_ab=this.unrender(_aa,_ab);}this.last=_ac;}var _af=this._cache[_ad];if(_ad){if(!_af[_ac]){_af[_ac]=dd.text._resolveTemplateArg(_ac,true);}if(_ae){var _b0=this.getTemplate(_af[_ac]);this.rendered=_b0.nodelist;}return this.rendered.render(_aa,_ab,this);}else{if(this.text instanceof dd._TextNode){if(_ae){this.rendered=this.text;this.rendered.set(dd.text._resolveTemplateArg(_ac,true));}return this.rendered.render(_aa,_ab);}else{if(!_af[_ac]){var _b1=[];var div=document.createElement("div");div.innerHTML=dd.text._resolveTemplateArg(_ac,true);var _b2=div.childNodes;while(_b2.length){var _b3=div.removeChild(_b2[0]);_b1.push(_b3);}_af[_ac]=_b1;}if(_ae){this.nodelist=[];var _b4=true;for(var i=0,_b5;_b5=_af[_ac][i];i++){this.nodelist.push(_b5.cloneNode(true));}}for(var i=0,_b6;_b6=this.nodelist[i];i++){_ab=_ab.concat(_b6);}}}return _ab;},unrender:function(_b7,_b8){if(this.rendered){_b8=this.rendered.unrender(_b7,_b8);}if(this.nodelist){for(var i=0,_b9;_b9=this.nodelist[i];i++){_b8=_b8.remove(_b9);}}return _b8;},clone:function(_ba){return new this.constructor(this._path,this.constant,this.getTemplate,this.text.clone(_ba),this.parsed);}});_84.mixin(_87,{block:function(_bb,_bc){var _bd=_bc.contents.split();var _be=_bd[1];_bb._blocks=_bb._blocks||{};_bb._blocks[_be]=_bb._blocks[_be]||[];_bb._blocks[_be].push(_be);var _bf=_bb.parse(["endblock","endblock "+_be]).rtrim();_bb.next_token();return new dojox.dtl.tag.loader.BlockNode(_be,_bf);},extends_:function(_c0,_c1){var _c2=_c1.contents.split();var _c3=false;var _c4=null;var key=null;if(_c2[1].charAt(0)=="\""||_c2[1].charAt(0)=="'"){_c4=_c2[1].substring(1,_c2[1].length-1);}else{key=_c2[1];}if(_c4&&_c4.indexOf("shared:")==0){_c3=true;_c4=_c4.substring(7,_c4.length);}var _c5=_c0.parse();return new dojox.dtl.tag.loader.ExtendsNode(_c0.getTemplate,_c5,_c3,_c4,key);},include:function(_c6,_c7){var _c8=_c7.contents.split();if(_c8.length!=2){throw new Error(_c8[0]+" tag takes one argument: the name of the template to be included");}var _c9=_c8[1];var _ca=false;if((_c9.charAt(0)=="\""||_c9.slice(-1)=="'")&&_c9.charAt(0)==_c9.slice(-1)){_c9=_c9.slice(1,-1);_ca=true;}return new _87.IncludeNode(_c9,_ca,_c6.getTemplate,_c6.create_text_node());},ssi:function(_cb,_cc){var _cd=_cc.contents.split();var _ce=false;if(_cd.length==3){_ce=(_cd.pop()=="parsed");if(!_ce){throw new Error("Second (optional) argument to ssi tag must be 'parsed'");}}var _cf=_87.include(_cb,new dd.Token(_cc.token_type,_cd.join(" ")));_cf.parsed=_ce;return _cf;}});return dojox.dtl.tag.loader;});},"dojo/date":function(){define(["./_base/kernel","./_base/lang"],function(_d0,_d1){_d1.getObject("date",true,_d0);_d0.date.getDaysInMonth=function(_d2){var _d3=_d2.getMonth();var _d4=[31,28,31,30,31,30,31,31,30,31,30,31];if(_d3==1&&_d0.date.isLeapYear(_d2)){return 29;}return _d4[_d3];};_d0.date.isLeapYear=function(_d5){var _d6=_d5.getFullYear();return !(_d6%400)||(!(_d6%4)&&!!(_d6%100));};_d0.date.getTimezoneName=function(_d7){var str=_d7.toString();var tz="";var _d8;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_d8=str.match(pat))){tz=_d8[1];}else{str=_d7.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_d8=str.match(pat))){tz=_d8[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};_d0.date.compare=function(_d9,_da,_db){_d9=new Date(+_d9);_da=new Date(+(_da||new Date()));if(_db=="date"){_d9.setHours(0,0,0,0);_da.setHours(0,0,0,0);}else{if(_db=="time"){_d9.setFullYear(0,0,0);_da.setFullYear(0,0,0);}}if(_d9>_da){return 1;}if(_d9<_da){return -1;}return 0;};_d0.date.add=function(_dc,_dd,_de){var sum=new Date(+_dc);var _df=false;var _e0="Date";switch(_dd){case "day":break;case "weekday":var _e1,_e2;var mod=_de%5;if(!mod){_e1=(_de>0)?5:-5;_e2=(_de>0)?((_de-5)/5):((_de+5)/5);}else{_e1=mod;_e2=parseInt(_de/5);}var _e3=_dc.getDay();var adj=0;if(_e3==6&&_de>0){adj=1;}else{if(_e3==0&&_de<0){adj=-1;}}var _e4=_e3+_e1;if(_e4==0||_e4==6){adj=(_de>0)?2:-2;}_de=(7*_e2)+_e1+adj;break;case "year":_e0="FullYear";_df=true;break;case "week":_de*=7;break;case "quarter":_de*=3;case "month":_df=true;_e0="Month";break;default:_e0="UTC"+_dd.charAt(0).toUpperCase()+_dd.substring(1)+"s";}if(_e0){sum["set"+_e0](sum["get"+_e0]()+_de);}if(_df&&(sum.getDate()<_dc.getDate())){sum.setDate(0);}return sum;};_d0.date.difference=function(_e5,_e6,_e7){_e6=_e6||new Date();_e7=_e7||"day";var _e8=_e6.getFullYear()-_e5.getFullYear();var _e9=1;switch(_e7){case "quarter":var m1=_e5.getMonth();var m2=_e6.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_e8*4);_e9=q2-q1;break;case "weekday":var _ea=Math.round(_d0.date.difference(_e5,_e6,"day"));var _eb=parseInt(_d0.date.difference(_e5,_e6,"week"));var mod=_ea%7;if(mod==0){_ea=_eb*5;}else{var adj=0;var _ec=_e5.getDay();var _ed=_e6.getDay();_eb=parseInt(_ea/7);mod=_ea%7;var _ee=new Date(_e5);_ee.setDate(_ee.getDate()+(_eb*7));var _ef=_ee.getDay();if(_ea>0){switch(true){case _ec==6:adj=-1;break;case _ec==0:adj=0;break;case _ed==6:adj=-1;break;case _ed==0:adj=-2;break;case (_ef+mod)>5:adj=-2;}}else{if(_ea<0){switch(true){case _ec==6:adj=0;break;case _ec==0:adj=1;break;case _ed==6:adj=2;break;case _ed==0:adj=1;break;case (_ef+mod)<0:adj=2;}}}_ea+=adj;_ea-=(_eb*2);}_e9=_ea;break;case "year":_e9=_e8;break;case "month":_e9=(_e6.getMonth()-_e5.getMonth())+(_e8*12);break;case "week":_e9=parseInt(_d0.date.difference(_e5,_e6,"day")/7);break;case "day":_e9/=24;case "hour":_e9/=60;case "minute":_e9/=60;case "second":_e9/=1000;case "millisecond":_e9*=_e6.getTime()-_e5.getTime();}return Math.round(_e9);};return _d0.date;});},"dojox/date/php":function(){define("dojox/date/php",["dojo/_base/kernel","dojo/_base/lang","dojo/date","dojox/string/tokenize"],function(_f0,_f1,_f2,_f3){_f0.getObject("date.php",true,dojox);dojox.date.php.format=function(_f4,_f5){var df=new dojox.date.php.DateFormat(_f5);return df.format(_f4);};dojox.date.php.DateFormat=function(_f6){if(!this.regex){var _f7=[];for(var key in this.constructor.prototype){if(_f0.isString(key)&&key.length==1&&_f0.isFunction(this[key])){_f7.push(key);}}this.constructor.prototype.regex=new RegExp("(?:(\\\\.)|(["+_f7.join("")+"]))","g");}var _f8=[];this.tokens=_f3(_f6,this.regex,function(_f9,_fa,i){if(_fa){_f8.push([i,_fa]);return _fa;}if(_f9){return _f9.charAt(1);}});this.replacements=_f8;};_f0.extend(dojox.date.php.DateFormat,{weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdays_3:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],months_3:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],monthdays:[31,28,31,30,31,30,31,31,30,31,30,31],format:function(_fb){this.date=_fb;for(var i=0,_fc;_fc=this.replacements[i];i++){this.tokens[_fc[0]]=this[_fc[1]]();}return this.tokens.join("");},d:function(){var j=this.j();return (j.length==1)?"0"+j:j;},D:function(){return this.weekdays_3[this.date.getDay()];},j:function(){return this.date.getDate()+"";},l:function(){return this.weekdays[this.date.getDay()];},N:function(){var w=this.w();return (!w)?7:w;},S:function(){switch(this.date.getDate()){case 11:case 12:case 13:return "th";case 1:case 21:case 31:return "st";case 2:case 22:return "nd";case 3:case 23:return "rd";default:return "th";}},w:function(){return this.date.getDay()+"";},z:function(){var _fd=this.date.getTime()-new Date(this.date.getFullYear(),0,1).getTime();return Math.floor(_fd/86400000)+"";},W:function(){var _fe;var _ff=new Date(this.date.getFullYear(),0,1).getDay()+1;var w=this.date.getDay()+1;var z=parseInt(this.z());if(z<=(8-_ff)&&_ff>4){var _100=new Date(this.date.getFullYear()-1,this.date.getMonth(),this.date.getDate());if(_ff==5||(_ff==6&&_f2.isLeapYear(_100))){_fe=53;}else{_fe=52;}}else{var i;if(Boolean(this.L())){i=366;}else{i=365;}if((i-z)<(4-w)){_fe=1;}else{var j=z+(7-w)+(_ff-1);_fe=Math.ceil(j/7);if(_ff>4){--_fe;}}}return _fe;},F:function(){return this.months[this.date.getMonth()];},m:function(){var n=this.n();return (n.length==1)?"0"+n:n;},M:function(){return this.months_3[this.date.getMonth()];},n:function(){return this.date.getMonth()+1+"";},t:function(){return (Boolean(this.L())&&this.date.getMonth()==1)?29:this.monthdays[this.getMonth()];},L:function(){return (_f2.isLeapYear(this.date))?"1":"0";},o:function(){},Y:function(){return this.date.getFullYear()+"";},y:function(){return this.Y().slice(-2);},a:function(){return this.date.getHours()>=12?"pm":"am";},b:function(){return this.a().toUpperCase();},B:function(){var off=this.date.getTimezoneOffset()+60;var secs=(this.date.getHours()*3600)+(this.date.getMinutes()*60)+this.getSeconds()+(off*60);var beat=Math.abs(Math.floor(secs/86.4)%1000)+"";while(beat.length<2){beat="0"+beat;}return beat;},g:function(){return (this.date.getHours()>12)?this.date.getHours()-12+"":this.date.getHours()+"";},G:function(){return this.date.getHours()+"";},h:function(){var g=this.g();return (g.length==1)?"0"+g:g;},H:function(){var G=this.G();return (G.length==1)?"0"+G:G;},i:function(){var mins=this.date.getMinutes()+"";return (mins.length==1)?"0"+mins:mins;},s:function(){var secs=this.date.getSeconds()+"";return (secs.length==1)?"0"+secs:secs;},e:function(){return _f2.getTimezoneName(this.date);},I:function(){},O:function(){var off=Math.abs(this.date.getTimezoneOffset());var _101=Math.floor(off/60)+"";var mins=(off%60)+"";if(_101.length==1){_101="0"+_101;}if(mins.length==1){_101="0"+mins;}return ((this.date.getTimezoneOffset()<0)?"+":"-")+_101+mins;},P:function(){var O=this.O();return O.substring(0,2)+":"+O.substring(2,4);},T:function(){return this.e().substring(0,3);},Z:function(){return this.date.getTimezoneOffset()*-60;},c:function(){return this.Y()+"-"+this.m()+"-"+this.d()+"T"+this.h()+":"+this.i()+":"+this.s()+this.P();},r:function(){return this.D()+", "+this.d()+" "+this.M()+" "+this.Y()+" "+this.H()+":"+this.i()+":"+this.s()+" "+this.O();},U:function(){return Math.floor(this.date.getTime()/1000);}});return dojox.date.php;});},"dojox/dtl/ext-dojo/NodeList":function(){define(["dojo/_base/lang","dojo/_base/NodeList","../_base"],function(lang,_102,dd){var nl=lang.getObject("dojox.dtl.ext-dojo.NodeList",true);lang.extend(_102,{dtl:function(_103,_104){var d=dd,self=this;var _105=function(_106,_107){var _108=_106.render(new d._Context(_107));self.forEach(function(node){node.innerHTML=_108;});};d.text._resolveTemplateArg(_103).addCallback(function(_109){_103=new d.Template(_109);d.text._resolveContextArg(_104).addCallback(function(_10a){_105(_103,_10a);});});return this;}});return nl;});},"dojox/dtl/utils/date":function(){define("dojox/dtl/utils/date",["dojo/_base/lang","dojox/date/php","../_base"],function(lang,ddp,dd){lang.getObject("dojox.dtl.utils.date",true);dd.utils.date.DateFormat=ddp.DateFormat;lang.extend(dd.utils.date.DateFormat,ddp.DateFormat.prototype,{f:function(){return (!this.date.getMinutes())?this.g():this.g()+":"+this.i();},N:function(){return dojox.dtl.utils.date._months_ap[this.date.getMonth()];},P:function(){if(!this.date.getMinutes()&&!this.date.getHours()){return "midnight";}if(!this.date.getMinutes()&&this.date.getHours()==12){return "noon";}return this.f()+" "+this.a();}});lang.mixin(dojox.dtl.utils.date,{format:function(date,_10b){var df=new dojox.dtl.utils.date.DateFormat(_10b);return df.format(date);},timesince:function(d,now){if(!(d instanceof Date)){d=new Date(d.year,d.month,d.day);}if(!now){now=new Date();}var _10c=Math.abs(now.getTime()-d.getTime());for(var i=0,_10d;_10d=dojox.dtl.utils.date._chunks[i];i++){var _10e=Math.floor(_10c/_10d[0]);if(_10e){break;}}return _10e+" "+_10d[1](_10e);},_chunks:[[60*60*24*365*1000,function(n){return (n==1)?"year":"years";}],[60*60*24*30*1000,function(n){return (n==1)?"month":"months";}],[60*60*24*7*1000,function(n){return (n==1)?"week":"weeks";}],[60*60*24*1000,function(n){return (n==1)?"day":"days";}],[60*60*1000,function(n){return (n==1)?"hour":"hours";}],[60*1000,function(n){return (n==1)?"minute":"minutes";}]],_months_ap:["Jan.","Feb.","March","April","May","June","July","Aug.","Sept.","Oct.","Nov.","Dec."]});return dojox.dtl.utils.date;});},"dojox/dtl/tag/loop":function(){define("dojox/dtl/tag/loop",["dojo/_base/lang","dojo/_base/array","dojo/_base/json","../_base","dojox/string/tokenize"],function(lang,_10f,json,dd,_110){lang.getObject("dojox.dtl.tag.loop",true);var ddtl=dd.tag.loop;ddtl.CycleNode=lang.extend(function(_111,name,text,_112){this.cyclevars=_111;this.name=name;this.contents=text;this.shared=_112||{counter:-1,map:{}};},{render:function(_113,_114){if(_113.forloop&&!_113.forloop.counter0){this.shared.counter=-1;}++this.shared.counter;var _115=this.cyclevars[this.shared.counter%this.cyclevars.length];var map=this.shared.map;if(!map[_115]){map[_115]=new dd._Filter(_115);}_115=map[_115].resolve(_113,_114);if(this.name){_113[this.name]=_115;}this.contents.set(_115);return this.contents.render(_113,_114);},unrender:function(_116,_117){return this.contents.unrender(_116,_117);},clone:function(_118){return new this.constructor(this.cyclevars,this.name,this.contents.clone(_118),this.shared);}});ddtl.IfChangedNode=lang.extend(function(_119,vars,_11a){this.nodes=_119;this._vars=vars;this.shared=_11a||{last:null,counter:0};this.vars=_10f.map(vars,function(item){return new dojox.dtl._Filter(item);});},{render:function(_11b,_11c){if(_11b.forloop){if(_11b.forloop.counter<=this.shared.counter){this.shared.last=null;}this.shared.counter=_11b.forloop.counter;}var _11d;if(this.vars.length){_11d=json.toJson(_10f.map(this.vars,function(item){return item.resolve(_11b);}));}else{_11d=this.nodes.dummyRender(_11b,_11c);}if(_11d!=this.shared.last){var _11e=(this.shared.last===null);this.shared.last=_11d;_11b=_11b.push();_11b.ifchanged={firstloop:_11e};_11c=this.nodes.render(_11b,_11c);_11b=_11b.pop();}else{_11c=this.nodes.unrender(_11b,_11c);}return _11c;},unrender:function(_11f,_120){return this.nodes.unrender(_11f,_120);},clone:function(_121){return new this.constructor(this.nodes.clone(_121),this._vars,this.shared);}});ddtl.RegroupNode=lang.extend(function(_122,key,_123){this._expression=_122;this.expression=new dd._Filter(_122);this.key=key;this.alias=_123;},{_push:function(_124,_125,_126){if(_126.length){_124.push({grouper:_125,list:_126});}},render:function(_127,_128){_127[this.alias]=[];var list=this.expression.resolve(_127);if(list){var last=null;var _129=[];for(var i=0;i<list.length;i++){var id=list[i][this.key];if(last!==id){this._push(_127[this.alias],last,_129);last=id;_129=[list[i]];}else{_129.push(list[i]);}}this._push(_127[this.alias],last,_129);}return _128;},unrender:function(_12a,_12b){return _12b;},clone:function(_12c,_12d){return this;}});lang.mixin(ddtl,{cycle:function(_12e,_12f){var args=_12f.split_contents();if(args.length<2){throw new Error("'cycle' tag requires at least two arguments");}if(args[1].indexOf(",")!=-1){var vars=args[1].split(",");args=[args[0]];for(var i=0;i<vars.length;i++){args.push("\""+vars[i]+"\"");}}if(args.length==2){var name=args[args.length-1];if(!_12e._namedCycleNodes){throw new Error("No named cycles in template: '"+name+"' is not defined");}if(!_12e._namedCycleNodes[name]){throw new Error("Named cycle '"+name+"' does not exist");}return _12e._namedCycleNodes[name];}if(args.length>4&&args[args.length-2]=="as"){var name=args[args.length-1];var node=new ddtl.CycleNode(args.slice(1,args.length-2),name,_12e.create_text_node());if(!_12e._namedCycleNodes){_12e._namedCycleNodes={};}_12e._namedCycleNodes[name]=node;}else{node=new ddtl.CycleNode(args.slice(1),null,_12e.create_text_node());}return node;},ifchanged:function(_130,_131){var _132=_131.contents.split();var _133=_130.parse(["endifchanged"]);_130.delete_first_token();return new ddtl.IfChangedNode(_133,_132.slice(1));},regroup:function(_134,_135){var _136=_110(_135.contents,/(\s+)/g,function(_137){return _137;});if(_136.length<11||_136[_136.length-3]!="as"||_136[_136.length-7]!="by"){throw new Error("Expected the format: regroup list by key as newList");}var _138=_136.slice(2,-8).join("");var key=_136[_136.length-5];var _139=_136[_136.length-1];return new ddtl.RegroupNode(_138,key,_139);}});return dojox.dtl.tag.loop;});},"dojox/string/Builder":function(){define("dojox/string/Builder",["dojo/_base/lang"],function(lang){lang.getObject("string",true,dojox).Builder=function(str){var b="";this.length=0;this.append=function(s){if(arguments.length>1){var tmp="",l=arguments.length;switch(l){case 9:tmp=""+arguments[8]+tmp;case 8:tmp=""+arguments[7]+tmp;case 7:tmp=""+arguments[6]+tmp;case 6:tmp=""+arguments[5]+tmp;case 5:tmp=""+arguments[4]+tmp;case 4:tmp=""+arguments[3]+tmp;case 3:tmp=""+arguments[2]+tmp;case 2:b+=""+arguments[0]+arguments[1]+tmp;break;default:var i=0;while(i<arguments.length){tmp+=arguments[i++];}b+=tmp;}}else{b+=s;}this.length=b.length;return this;};this.concat=function(s){return this.append.apply(this,arguments);};this.appendArray=function(_13a){return this.append.apply(this,_13a);};this.clear=function(){b="";this.length=0;return this;};this.replace=function(_13b,_13c){b=b.replace(_13b,_13c);this.length=b.length;return this;};this.remove=function(_13d,len){if(len===undefined){len=b.length;}if(len==0){return this;}b=b.substr(0,_13d)+b.substr(_13d+len);this.length=b.length;return this;};this.insert=function(_13e,str){if(_13e==0){b=str+b;}else{b=b.slice(0,_13e)+str+b.slice(_13e);}this.length=b.length;return this;};this.toString=function(){return b;};if(str){this.append(str);}};return dojox.string.Builder;});},"dojox/string/tokenize":function(){define(["dojo/_base/lang","dojo/_base/sniff"],function(lang,has){var _13f=lang.getObject("dojox.string",true).tokenize;_13f=function(str,re,_140,_141){var _142=[];var _143,_144,_145=0;while(_143=re.exec(str)){_144=str.slice(_145,re.lastIndex-_143[0].length);if(_144.length){_142.push(_144);}if(_140){if(has("opera")){var copy=_143.slice(0);while(copy.length<_143.length){copy.push(null);}_143=copy;}var _146=_140.apply(_141,_143.slice(1).concat(_142.length));if(typeof _146!="undefined"){_142.push(_146);}}_145=re.lastIndex;}_144=str.slice(_145);if(_144.length){_142.push(_144);}return _142;};return _13f;});},"dojox/dtl/tag/misc":function(){define("dojox/dtl/tag/misc",["dojo/_base/lang","dojo/_base/array","dojo/_base/connect","../_base"],function(lang,_147,_148,dd){lang.getObject("dojox.dtl.tag.misc",true);var ddtm=dd.tag.misc;ddtm.DebugNode=lang.extend(function(text){this.text=text;},{render:function(_149,_14a){var keys=_149.getKeys();var _14b=[];var only={};for(var i=0,key;key=keys[i];i++){only[key]=_149[key];_14b+="["+key+": "+typeof _149[key]+"]\n";}return this.text.set(_14b).render(_149,_14a,this);},unrender:function(_14c,_14d){return _14d;},clone:function(_14e){return new this.constructor(this.text.clone(_14e));},toString:function(){return "ddtm.DebugNode";}});ddtm.FilterNode=lang.extend(function(_14f,_150){this._varnode=_14f;this._nodelist=_150;},{render:function(_151,_152){var _153=this._nodelist.render(_151,new dojox.string.Builder());_151=_151.update({"var":_153.toString()});var _154=this._varnode.render(_151,_152);_151=_151.pop();return _152;},unrender:function(_155,_156){return _156;},clone:function(_157){return new this.constructor(this._expression,this._nodelist.clone(_157));}});ddtm.FirstOfNode=lang.extend(function(vars,text){this._vars=vars;this.vars=_147.map(vars,function(item){return new dojox.dtl._Filter(item);});this.contents=text;},{render:function(_158,_159){for(var i=0,item;item=this.vars[i];i++){var _15a=item.resolve(_158);if(typeof _15a!="undefined"){if(_15a===null){_15a="null";}this.contents.set(_15a);return this.contents.render(_158,_159);}}return this.contents.unrender(_158,_159);},unrender:function(_15b,_15c){return this.contents.unrender(_15b,_15c);},clone:function(_15d){return new this.constructor(this._vars,this.contents.clone(_15d));}});ddtm.SpacelessNode=lang.extend(function(_15e,text){this.nodelist=_15e;this.contents=text;},{render:function(_15f,_160){if(_160.getParent){var _161=[_148.connect(_160,"onAddNodeComplete",this,"_watch"),_148.connect(_160,"onSetParent",this,"_watchParent")];_160=this.nodelist.render(_15f,_160);_148.disconnect(_161[0]);_148.disconnect(_161[1]);}else{var _162=this.nodelist.dummyRender(_15f);this.contents.set(_162.replace(/>\s+</g,"><"));_160=this.contents.render(_15f,_160);}return _160;},unrender:function(_163,_164){return this.nodelist.unrender(_163,_164);},clone:function(_165){return new this.constructor(this.nodelist.clone(_165),this.contents.clone(_165));},_isEmpty:function(node){return (node.nodeType==3&&!node.data.match(/[^\s\n]/));},_watch:function(node){if(this._isEmpty(node)){var _166=false;if(node.parentNode.firstChild==node){node.parentNode.removeChild(node);}}else{var _167=node.parentNode.childNodes;if(node.nodeType==1&&_167.length>2){for(var i=2,_168;_168=_167[i];i++){if(_167[i-2].nodeType==1&&this._isEmpty(_167[i-1])){node.parentNode.removeChild(_167[i-1]);return;}}}}},_watchParent:function(node){var _169=node.childNodes;if(_169.length){while(node.childNodes.length){var last=node.childNodes[node.childNodes.length-1];if(!this._isEmpty(last)){return;}node.removeChild(last);}}}});ddtm.TemplateTagNode=lang.extend(function(tag,text){this.tag=tag;this.contents=text;},{mapping:{openblock:"{%",closeblock:"%}",openvariable:"{{",closevariable:"}}",openbrace:"{",closebrace:"}",opencomment:"{#",closecomment:"#}"},render:function(_16a,_16b){this.contents.set(this.mapping[this.tag]);return this.contents.render(_16a,_16b);},unrender:function(_16c,_16d){return this.contents.unrender(_16c,_16d);},clone:function(_16e){return new this.constructor(this.tag,this.contents.clone(_16e));}});ddtm.WidthRatioNode=lang.extend(function(_16f,max,_170,text){this.current=new dd._Filter(_16f);this.max=new dd._Filter(max);this.width=_170;this.contents=text;},{render:function(_171,_172){var _173=+this.current.resolve(_171);var max=+this.max.resolve(_171);if(typeof _173!="number"||typeof max!="number"||!max){this.contents.set("");}else{this.contents.set(""+Math.round((_173/max)*this.width));}return this.contents.render(_171,_172);},unrender:function(_174,_175){return this.contents.unrender(_174,_175);},clone:function(_176){return new this.constructor(this.current.getExpression(),this.max.getExpression(),this.width,this.contents.clone(_176));}});ddtm.WithNode=lang.extend(function(_177,_178,_179){this.target=new dd._Filter(_177);this.alias=_178;this.nodelist=_179;},{render:function(_17a,_17b){var _17c=this.target.resolve(_17a);_17a=_17a.push();_17a[this.alias]=_17c;_17b=this.nodelist.render(_17a,_17b);_17a=_17a.pop();return _17b;},unrender:function(_17d,_17e){return _17e;},clone:function(_17f){return new this.constructor(this.target.getExpression(),this.alias,this.nodelist.clone(_17f));}});lang.mixin(ddtm,{comment:function(_180,_181){_180.skip_past("endcomment");return dd._noOpNode;},debug:function(_182,_183){return new ddtm.DebugNode(_182.create_text_node());},filter:function(_184,_185){var rest=_185.contents.split(null,1)[1];var _186=_184.create_variable_node("var|"+rest);var _187=_184.parse(["endfilter"]);_184.next_token();return new ddtm.FilterNode(_186,_187);},firstof:function(_188,_189){var _18a=_189.split_contents().slice(1);if(!_18a.length){throw new Error("'firstof' statement requires at least one argument");}return new ddtm.FirstOfNode(_18a,_188.create_text_node());},spaceless:function(_18b,_18c){var _18d=_18b.parse(["endspaceless"]);_18b.delete_first_token();return new ddtm.SpacelessNode(_18d,_18b.create_text_node());},templatetag:function(_18e,_18f){var _190=_18f.contents.split();if(_190.length!=2){throw new Error("'templatetag' statement takes one argument");}var tag=_190[1];var _191=ddtm.TemplateTagNode.prototype.mapping;if(!_191[tag]){var keys=[];for(var key in _191){keys.push(key);}throw new Error("Invalid templatetag argument: '"+tag+"'. Must be one of: "+keys.join(", "));}return new ddtm.TemplateTagNode(tag,_18e.create_text_node());},widthratio:function(_192,_193){var _194=_193.contents.split();if(_194.length!=4){throw new Error("widthratio takes three arguments");}var _195=+_194[3];if(typeof _195!="number"){throw new Error("widthratio final argument must be an integer");}return new ddtm.WidthRatioNode(_194[1],_194[2],_195,_192.create_text_node());},with_:function(_196,_197){var _198=_197.split_contents();if(_198.length!=4||_198[2]!="as"){throw new Error("do_width expected format as 'with value as name'");}var _199=_196.parse(["endwith"]);_196.next_token();return new ddtm.WithNode(_198[1],_198[3],_199);}});return dojox.dtl.tag.misc;});},"dojox/dtl/Context":function(){define("dojox/dtl/Context",["dojo/_base/lang","./_base"],function(lang,dd){dd.Context=lang.extend(function(dict){this._this={};dd._Context.call(this,dict);},dd._Context.prototype,{getKeys:function(){var keys=[];for(var key in this){if(this.hasOwnProperty(key)&&key!="_this"){keys.push(key);}}return keys;},extend:function(obj){return lang.delegate(this,obj);},filter:function(_19a){var _19b=new dd.Context();var keys=[];var i,arg;if(_19a instanceof dd.Context){keys=_19a.getKeys();}else{if(typeof _19a=="object"){for(var key in _19a){keys.push(key);}}else{for(i=0;arg=arguments[i];i++){if(typeof arg=="string"){keys.push(arg);}}}}for(i=0,key;key=keys[i];i++){_19b[key]=this[key];}return _19b;},setThis:function(_19c){this._this=_19c;},getThis:function(){return this._this;},hasKey:function(key){if(this._getter){var got=this._getter(key);if(typeof got!="undefined"){return true;}}if(typeof this[key]!="undefined"){return true;}return false;}});return dojox.dtl.Context;});},"dojox/dtl/tag/logic":function(){define(["dojo/_base/lang","../_base"],function(lang,dd){lang.getObject("dojox.dtl.tag.logic",true);var ddt=dd.text;var ddtl=dd.tag.logic;ddtl.IfNode=lang.extend(function(_19d,_19e,_19f,type){this.bools=_19d;this.trues=_19e;this.falses=_19f;this.type=type;},{render:function(_1a0,_1a1){var i,bool,_1a2,_1a3,_1a4;if(this.type=="or"){for(i=0;bool=this.bools[i];i++){_1a2=bool[0];_1a3=bool[1];_1a4=_1a3.resolve(_1a0);if((_1a4&&!_1a2)||(_1a2&&!_1a4)){if(this.falses){_1a1=this.falses.unrender(_1a0,_1a1);}return (this.trues)?this.trues.render(_1a0,_1a1,this):_1a1;}}if(this.trues){_1a1=this.trues.unrender(_1a0,_1a1);}return (this.falses)?this.falses.render(_1a0,_1a1,this):_1a1;}else{for(i=0;bool=this.bools[i];i++){_1a2=bool[0];_1a3=bool[1];_1a4=_1a3.resolve(_1a0);if(_1a4==_1a2){if(this.trues){_1a1=this.trues.unrender(_1a0,_1a1);}return (this.falses)?this.falses.render(_1a0,_1a1,this):_1a1;}}if(this.falses){_1a1=this.falses.unrender(_1a0,_1a1);}return (this.trues)?this.trues.render(_1a0,_1a1,this):_1a1;}return _1a1;},unrender:function(_1a5,_1a6){_1a6=(this.trues)?this.trues.unrender(_1a5,_1a6):_1a6;_1a6=(this.falses)?this.falses.unrender(_1a5,_1a6):_1a6;return _1a6;},clone:function(_1a7){var _1a8=(this.trues)?this.trues.clone(_1a7):null;var _1a9=(this.falses)?this.falses.clone(_1a7):null;return new this.constructor(this.bools,_1a8,_1a9,this.type);}});ddtl.IfEqualNode=lang.extend(function(var1,var2,_1aa,_1ab,_1ac){this.var1=new dd._Filter(var1);this.var2=new dd._Filter(var2);this.trues=_1aa;this.falses=_1ab;this.negate=_1ac;},{render:function(_1ad,_1ae){var var1=this.var1.resolve(_1ad);var var2=this.var2.resolve(_1ad);var1=(typeof var1!="undefined")?var1:"";var2=(typeof var1!="undefined")?var2:"";if((this.negate&&var1!=var2)||(!this.negate&&var1==var2)){if(this.falses){_1ae=this.falses.unrender(_1ad,_1ae,this);}return (this.trues)?this.trues.render(_1ad,_1ae,this):_1ae;}if(this.trues){_1ae=this.trues.unrender(_1ad,_1ae,this);}return (this.falses)?this.falses.render(_1ad,_1ae,this):_1ae;},unrender:function(_1af,_1b0){return ddtl.IfNode.prototype.unrender.call(this,_1af,_1b0);},clone:function(_1b1){var _1b2=this.trues?this.trues.clone(_1b1):null;var _1b3=this.falses?this.falses.clone(_1b1):null;return new this.constructor(this.var1.getExpression(),this.var2.getExpression(),_1b2,_1b3,this.negate);}});ddtl.ForNode=lang.extend(function(_1b4,loop,_1b5,_1b6){this.assign=_1b4;this.loop=new dd._Filter(loop);this.reversed=_1b5;this.nodelist=_1b6;this.pool=[];},{render:function(_1b7,_1b8){var i,j,k;var _1b9=false;var _1ba=this.assign;for(k=0;k<_1ba.length;k++){if(typeof _1b7[_1ba[k]]!="undefined"){_1b9=true;_1b7=_1b7.push();break;}}if(!_1b9&&_1b7.forloop){_1b9=true;_1b7=_1b7.push();}var _1bb=this.loop.resolve(_1b7)||[];for(i=_1bb.length;i<this.pool.length;i++){this.pool[i].unrender(_1b7,_1b8,this);}if(this.reversed){_1bb=_1bb.slice(0).reverse();}var _1bc=lang.isObject(_1bb)&&!lang.isArrayLike(_1bb);var _1bd=[];if(_1bc){for(var key in _1bb){_1bd.push(_1bb[key]);}}else{_1bd=_1bb;}var _1be=_1b7.forloop={parentloop:_1b7.get("forloop",{})};var j=0;for(i=0;i<_1bd.length;i++){var item=_1bd[i];_1be.counter0=j;_1be.counter=j+1;_1be.revcounter0=_1bd.length-j-1;_1be.revcounter=_1bd.length-j;_1be.first=!j;_1be.last=(j==_1bd.length-1);if(_1ba.length>1&&lang.isArrayLike(item)){if(!_1b9){_1b9=true;_1b7=_1b7.push();}var _1bf={};for(k=0;k<item.length&&k<_1ba.length;k++){_1bf[_1ba[k]]=item[k];}lang.mixin(_1b7,_1bf);}else{_1b7[_1ba[0]]=item;}if(j+1>this.pool.length){this.pool.push(this.nodelist.clone(_1b8));}_1b8=this.pool[j++].render(_1b7,_1b8,this);}delete _1b7.forloop;if(_1b9){_1b7=_1b7.pop();}else{for(k=0;k<_1ba.length;k++){delete _1b7[_1ba[k]];}}return _1b8;},unrender:function(_1c0,_1c1){for(var i=0,pool;pool=this.pool[i];i++){_1c1=pool.unrender(_1c0,_1c1);}return _1c1;},clone:function(_1c2){return new this.constructor(this.assign,this.loop.getExpression(),this.reversed,this.nodelist.clone(_1c2));}});lang.mixin(ddtl,{if_:function(_1c3,_1c4){var i,part,type,_1c5=[],_1c6=_1c4.contents.split();_1c6.shift();_1c4=_1c6.join(" ");_1c6=_1c4.split(" and ");if(_1c6.length==1){type="or";_1c6=_1c4.split(" or ");}else{type="and";for(i=0;i<_1c6.length;i++){if(_1c6[i].indexOf(" or ")!=-1){throw new Error("'if' tags can't mix 'and' and 'or'");}}}for(i=0;part=_1c6[i];i++){var not=false;if(part.indexOf("not ")==0){part=part.slice(4);not=true;}_1c5.push([not,new dd._Filter(part)]);}var _1c7=_1c3.parse(["else","endif"]);var _1c8=false;var _1c4=_1c3.next_token();if(_1c4.contents=="else"){_1c8=_1c3.parse(["endif"]);_1c3.next_token();}return new ddtl.IfNode(_1c5,_1c7,_1c8,type);},_ifequal:function(_1c9,_1ca,_1cb){var _1cc=_1ca.split_contents();if(_1cc.length!=3){throw new Error(_1cc[0]+" takes two arguments");}var end="end"+_1cc[0];var _1cd=_1c9.parse(["else",end]);var _1ce=false;var _1ca=_1c9.next_token();if(_1ca.contents=="else"){_1ce=_1c9.parse([end]);_1c9.next_token();}return new ddtl.IfEqualNode(_1cc[1],_1cc[2],_1cd,_1ce,_1cb);},ifequal:function(_1cf,_1d0){return ddtl._ifequal(_1cf,_1d0);},ifnotequal:function(_1d1,_1d2){return ddtl._ifequal(_1d1,_1d2,true);},for_:function(_1d3,_1d4){var _1d5=_1d4.contents.split();if(_1d5.length<4){throw new Error("'for' statements should have at least four words: "+_1d4.contents);}var _1d6=_1d5[_1d5.length-1]=="reversed";var _1d7=(_1d6)?-3:-2;if(_1d5[_1d5.length+_1d7]!="in"){throw new Error("'for' tag received an invalid argument: "+_1d4.contents);}var _1d8=_1d5.slice(1,_1d7).join(" ").split(/ *, */);for(var i=0;i<_1d8.length;i++){if(!_1d8[i]||_1d8[i].indexOf(" ")!=-1){throw new Error("'for' tag received an invalid argument: "+_1d4.contents);}}var _1d9=_1d3.parse(["endfor"]);_1d3.next_token();return new ddtl.ForNode(_1d8,_1d5[_1d5.length+_1d7+1],_1d6,_1d9);}});return dojox.dtl.tag.logic;});},"dojox/dtl/tag/date":function(){define("dojox/dtl/tag/date",["dojo/_base/lang","../_base","../utils/date"],function(lang,dd,ddud){lang.getObject("dojox.dtl.tag.date",true);dojox.dtl.tag.date.NowNode=function(_1da,node){this._format=_1da;this.format=new ddud.DateFormat(_1da);this.contents=node;};lang.extend(dd.tag.date.NowNode,{render:function(_1db,_1dc){this.contents.set(this.format.format(new Date()));return this.contents.render(_1db,_1dc);},unrender:function(_1dd,_1de){return this.contents.unrender(_1dd,_1de);},clone:function(_1df){return new this.constructor(this._format,this.contents.clone(_1df));}});dojox.dtl.tag.date.now=function(_1e0,_1e1){var _1e2=_1e1.split_contents();if(_1e2.length!=2){throw new Error("'now' statement takes one argument");}return new dojox.dtl.tag.date.NowNode(_1e2[1].slice(1,-1),_1e0.create_text_node());};return dojox.dtl.tag.date;});}}});define("dojox/dtl",["./dtl/_base"],function(_1e3){return _1e3;});