/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.Styleable;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileNoteAlone
extends AbstractFtile
implements Stencil,
Styleable {
    private final Opale opale;
    private final boolean withOutPoint;
    private final Swimlane swimlane;

    @Override
    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public FtileNoteAlone(boolean shadow, Display note, ISkinParam skinParam, boolean withOutPoint, Swimlane swimlane) {
        super(skinParam);
        LineBreakStrategy wrapWidth;
        double shadowing;
        HColor borderColor;
        HColor noteBackgroundColor;
        this.swimlane = swimlane;
        this.withOutPoint = withOutPoint;
        Rose rose = new Rose();
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(skinParam.getCurrentStyleBuilder());
            noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            shadowing = style.value(PName.Shadowing).asDouble();
            wrapWidth = style.wrapWidth();
        } else {
            noteBackgroundColor = rose.getHtmlColor(skinParam, ColorParam.noteBackground);
            borderColor = rose.getHtmlColor(skinParam, ColorParam.noteBorder);
            shadowing = skinParam.shadowing(null) ? 4.0 : 0.0;
            wrapWidth = skinParam.wrapWidth();
        }
        FontConfiguration fc = new FontConfiguration(skinParam, FontParam.NOTE, null);
        Sheet sheet = Parser.build(fc, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), skinParam, CreoleMode.FULL).createSheet(note);
        SheetBlock2 text = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), this, new UStroke(1.0));
        this.opale = new Opale(shadowing, borderColor, noteBackgroundColor, text, false);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.opale.drawU(ug);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        if (this.withOutPoint) {
            return new FtileGeometry(dimTotal, dimTotal.getWidth() / 2.0, 0.0, dimTotal.getHeight());
        }
        return new FtileGeometry(dimTotal, dimTotal.getWidth() / 2.0, 0.0);
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        return this.opale.calculateDimension(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }
}

