# *Percona XtraBackup* 2.4.14

Percona is glad to announce the release of *Percona XtraBackup* 2.4.14 on
May 1, 2019. Downloads are available from our [download site](http://www.percona.com/downloads/XtraBackup/Percona-XtraBackup-2.4.14/) and
from [apt](../../installation/apt_repo.md#apt-repo) and [yum](../../installation/yum_repo.md#yum-repo) repositories.

*Percona XtraBackup* 2.4.14 enables saving backups to an Amazon S3 storage
when using *xbcloud*. The following example demonstrates how to use an Amazon S3
storage to make a full backup.

```bash
$ xtrabackup --backup --stream=xbstream --extra-lsndir=/tmp --target-dir=/tmp | \
xbcloud put --storage=s3 \
--s3-endpoint='s3.amazonaws.com' \
--s3-access-key='YOUR-ACCESSKEYID' \
--s3-secret-key='YOUR-SECRETACCESSKEY' \
--s3-bucket='mysql_backups'
--parallel=10 \
${date -I}-full_backup
```

All Percona software is open-source and free.

## New Features

Amazon S3 is now supported in *xbcloud*. More information in
[PXB-1813](https://jira.percona.com/browse/PXB-1813).

## Bugs Fixed

* When the row format was changed during the backup, *xtrabackup* could crash
during the incremental prepare stage. Bug fixed [PXB-1824](https://jira.percona.com/browse/PXB-1824).

* If compressed InnoDB undo tablespaces were not removed beforehand, the
incremental backup could crash at the prepare stage. Bug fixed
[PXB-1552](https://jira.percona.com/browse/PXB-1552).

**Other bugs fixed**:
[PXB-1771](https://jira.percona.com/browse/PXB-1771),
[PXB-1809](https://jira.percona.com/browse/PXB-1809),
[PXB-1837](https://jira.percona.com/browse/PXB-1837).
