/*
   Copyright (c) 2003, 2021, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*/

#ifndef NDB_TCP_H
#define NDB_TCP_H

#include <ndb_global.h>
#include <ndb_net.h>
#include "ndb_socket.h"
#include <portlib/ndb_socket_poller.h>

typedef ndb_socket_t NDB_SOCKET_TYPE;

#define NDB_ADDR_STRLEN 512

#ifdef	__cplusplus
extern "C" {
#endif

/**
 * Convert host name or ip address to in_addr
 *
 * Returns  0 on success
 *         -1 on failure
 *
 * Implemented as:
 *   gethostbyname
 *   if not success
 *      inet_addr
 */
int Ndb_getInAddr6(struct in6_addr * dst, const char *address);
int Ndb_getInAddr(struct in_addr * dst, const char *address);

char* Ndb_inet_ntop(int af,
                    const void *src,
                    char *dst,
                    size_t dst_size);

int Ndb_check_socket_hup(NDB_SOCKET_TYPE sock);
int Ndb_split_string_address_port(const char *arg,
                               char *host,
                               size_t hostlen,
                               char *serv,
                               size_t servlen);

char* Ndb_combine_address_port(char *buf,
                               size_t bufsize,
                               const char *host,
                               Uint16 port);

#ifdef	__cplusplus
}
#endif

#endif
