// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

import QtQuick

ListModel {
    id: roomsList

    ListElement {
        name: qsTr("Living Room")
        floor: qsTr("First floor")
        iconName: "living_room.svg"
        mode: "Auto"
        active: false
        temp: 24
        thermostatTemp: 22
        humidity: 32
        energy: 12
        humidityStats: [
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 40
            },
            ListElement {
                hmd: 45
            },
            ListElement {
                hmd: 35
            },
            ListElement {
                hmd: 30
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 60
            }
        ]
        energyStats: [
            ListElement {
                enrg: 1200
            },
            ListElement {
                enrg: 1400
            },
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 900
            },
            ListElement {
                enrg: 800
            },
            ListElement {
                enrg: 500
            },
            ListElement {
                enrg: 600
            },
            ListElement {
                enrg: 550
            },
            ListElement {
                enrg: 1200
            },
            ListElement {
                enrg: 1400
            },
            ListElement {
                enrg: 1600
            },
            ListElement {
                enrg: 1000
            }
        ]
        tempStats: [
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.9
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 19.0
            },
            ListElement {
                tmp: 18.7
            },
            ListElement {
                tmp: 17.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 23.0
            }
        ]
    }
    ListElement {
        name: qsTr("Master")
        floor: qsTr("First floor")
        iconName: "bedroom.svg"
        mode: "Auto"
        active: true
        temp: 14
        thermostatTemp: 22
        humidity: 32
        energy: 12
        humidityStats: [
            ListElement {
                hmd: 40
            },
            ListElement {
                hmd: 45
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 40
            },
            ListElement {
                hmd: 45
            },
            ListElement {
                hmd: 35
            },
            ListElement {
                hmd: 30
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 40
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 45
            },
            ListElement {
                hmd: 40
            }
        ]
        energyStats: [
            ListElement {
                enrg: 800
            },
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 900
            },
            ListElement {
                enrg: 600
            },
            ListElement {
                enrg: 300
            },
            ListElement {
                enrg: 300
            },
            ListElement {
                enrg: 450
            },
            ListElement {
                enrg: 600
            },
            ListElement {
                enrg: 1200
            },
            ListElement {
                enrg: 1300
            },
            ListElement {
                enrg: 1600
            }
        ]
        tempStats: [
            ListElement {
                tmp: 20.0
            },
            ListElement {
                tmp: 20.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.9
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 23.4
            },
            ListElement {
                tmp: 24.2
            },
            ListElement {
                tmp: 25.3
            },
            ListElement {
                tmp: 25.5
            },
            ListElement {
                tmp: 24.5
            },
            ListElement {
                tmp: 23.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 20.0
            },
            ListElement {
                tmp: 20.2
            },
            ListElement {
                tmp: 20.3
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.7
            },
            ListElement {
                tmp: 17.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 23.0
            }
        ]
    }
    ListElement {
        name: qsTr("Kitchen")
        floor: qsTr("First floor")
        iconName: "kitchen.svg"
        mode: "Auto"
        active: false
        temp: 24
        thermostatTemp: 22
        humidity: 32
        energy: 12
        humidityStats: [
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 40
            },
            ListElement {
                hmd: 45
            },
            ListElement {
                hmd: 35
            },
            ListElement {
                hmd: 30
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 60
            }
        ]
        energyStats: [
            ListElement {
                enrg: 1700
            },
            ListElement {
                enrg: 1600
            },
            ListElement {
                enrg: 1600
            },
            ListElement {
                enrg: 1400
            },
            ListElement {
                enrg: 1800
            },
            ListElement {
                enrg: 1900
            },
            ListElement {
                enrg: 1300
            },
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 900
            },
            ListElement {
                enrg: 1200
            },
            ListElement {
                enrg: 1300
            },
            ListElement {
                enrg: 1400
            }
        ]
        tempStats: [
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.9
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 19.0
            },
            ListElement {
                tmp: 18.7
            },
            ListElement {
                tmp: 17.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 23.0
            }
        ]
    }
    ListElement {
        name: qsTr("Kid Room")
        floor: qsTr("First floor")
        iconName: "kid_room.svg"
        mode: "Auto"
        active: false
        temp: 14
        thermostatTemp: 22
        humidity: 32
        energy: 12
        humidityStats: [
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 40
            },
            ListElement {
                hmd: 45
            },
            ListElement {
                hmd: 35
            },
            ListElement {
                hmd: 30
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 60
            }
        ]
        energyStats: [
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 1100
            },
            ListElement {
                enrg: 920
            },
            ListElement {
                enrg: 840
            },
            ListElement {
                enrg: 800
            },
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 1100
            },
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 600
            },
            ListElement {
                enrg: 590
            },
            ListElement {
                enrg: 720
            }
        ]
        tempStats: [
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.9
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 19.0
            },
            ListElement {
                tmp: 18.7
            },
            ListElement {
                tmp: 17.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 23.0
            }
        ]
    }
    ListElement {
        name: qsTr("Kid Room2")
        floor: qsTr("First floor")
        iconName: "kid_room.svg"
        mode: "Auto"
        active: false
        temp: 22
        thermostatTemp: 22
        humidity: 32
        energy: 12
        humidityStats: [
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 40
            },
            ListElement {
                hmd: 45
            },
            ListElement {
                hmd: 35
            },
            ListElement {
                hmd: 30
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 60
            }
        ]
        energyStats: [
            ListElement {
                enrg: 900
            },
            ListElement {
                enrg: 800
            },
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 900
            },
            ListElement {
                enrg: 900
            },
            ListElement {
                enrg: 1000
            },
            ListElement {
                enrg: 1100
            },
            ListElement {
                enrg: 1200
            },
            ListElement {
                enrg: 1300
            },
            ListElement {
                enrg: 800
            },
            ListElement {
                enrg: 700
            },
            ListElement {
                enrg: 720
            }
        ]
        tempStats: [
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.9
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 19.0
            },
            ListElement {
                tmp: 18.7
            },
            ListElement {
                tmp: 17.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 23.0
            }
        ]
    }
    ListElement {
        name: qsTr("Bedroom")
        floor: qsTr("First floor")
        iconName: "bedroom.svg"
        mode: "Auto"
        active: false
        temp: 21
        thermostatTemp: 22
        humidity: 32
        energy: 12
        humidityStats: [
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 40
            },
            ListElement {
                hmd: 45
            },
            ListElement {
                hmd: 35
            },
            ListElement {
                hmd: 30
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 60
            },
            ListElement {
                hmd: 50
            },
            ListElement {
                hmd: 55
            },
            ListElement {
                hmd: 60
            }
        ]
        energyStats: [
            ListElement {
                enrg: 400
            },
            ListElement {
                enrg: 500
            },
            ListElement {
                enrg: 400
            },
            ListElement {
                enrg: 400
            },
            ListElement {
                enrg: 450
            },
            ListElement {
                enrg: 500
            },
            ListElement {
                enrg: 600
            },
            ListElement {
                enrg: 550
            },
            ListElement {
                enrg: 700
            },
            ListElement {
                enrg: 720
            },
            ListElement {
                enrg: 780
            },
            ListElement {
                enrg: 750
            }
        ]
        tempStats: [
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 20.0
            },
            ListElement {
                tmp: 20.8
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 21.9
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 22.2
            },
            ListElement {
                tmp: 22.3
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 21.2
            },
            ListElement {
                tmp: 21.3
            },
            ListElement {
                tmp: 21.5
            },
            ListElement {
                tmp: 22.5
            },
            ListElement {
                tmp: 22.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 19.0
            },
            ListElement {
                tmp: 18.7
            },
            ListElement {
                tmp: 17.5
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 21.0
            },
            ListElement {
                tmp: 20.5
            },
            ListElement {
                tmp: 21.8
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 22.0
            },
            ListElement {
                tmp: 23.0
            },
            ListElement {
                tmp: 23.0
            }
        ]
    }
}
