/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.RotateDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

public class ExtractStyle {
    Class<?> styleableClass = this.getClass("android.R$styleable");
    Class<?> rippleDrawableClass = this.getClass("android.graphics.drawable.RippleDrawable");
    Class<?> animatedStateListDrawableClass = this.getClass("android.graphics.drawable.AnimatedStateListDrawable");
    Class<?> vectorDrawableClass = this.getClass("android.graphics.drawable.VectorDrawable");
    final int[] EMPTY_STATE_SET = new int[0];
    final int[] ENABLED_STATE_SET = new int[]{16842910};
    final int[] FOCUSED_STATE_SET = new int[]{16842908};
    final int[] SELECTED_STATE_SET = new int[]{0x10100A1};
    final int[] PRESSED_STATE_SET = new int[]{16842919};
    final int[] WINDOW_FOCUSED_STATE_SET = new int[]{16842909};
    final int[] ENABLED_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_STATE_SET, this.FOCUSED_STATE_SET);
    final int[] ENABLED_SELECTED_STATE_SET = this.stateSetUnion(this.ENABLED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] ENABLED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] FOCUSED_SELECTED_STATE_SET = this.stateSetUnion(this.FOCUSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] FOCUSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.FOCUSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] ENABLED_FOCUSED_SELECTED_STATE_SET = this.stateSetUnion(this.ENABLED_FOCUSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_FOCUSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.FOCUSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_FOCUSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_SELECTED_STATE_SET = this.stateSetUnion(this.PRESSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_STATE_SET, this.FOCUSED_STATE_SET);
    final int[] PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_FOCUSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_FOCUSED_SELECTED_STATE_SET = this.stateSetUnion(this.PRESSED_FOCUSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_FOCUSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_STATE_SET = this.stateSetUnion(this.PRESSED_STATE_SET, this.ENABLED_STATE_SET);
    final int[] PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_SELECTED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_STATE_SET, this.FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_FOCUSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_FOCUSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int View_background = this.getField(this.styleableClass, "View_background");
    final int View_padding = this.getField(this.styleableClass, "View_padding");
    final int View_paddingLeft = this.getField(this.styleableClass, "View_paddingLeft");
    final int View_paddingTop = this.getField(this.styleableClass, "View_paddingTop");
    final int View_paddingRight = this.getField(this.styleableClass, "View_paddingRight");
    final int View_paddingBottom = this.getField(this.styleableClass, "View_paddingBottom");
    final int View_scrollX = this.getField(this.styleableClass, "View_scrollX");
    final int View_scrollY = this.getField(this.styleableClass, "View_scrollY");
    final int View_id = this.getField(this.styleableClass, "View_id");
    final int View_tag = this.getField(this.styleableClass, "View_tag");
    final int View_fitsSystemWindows = this.getField(this.styleableClass, "View_fitsSystemWindows");
    final int View_focusable = this.getField(this.styleableClass, "View_focusable");
    final int View_focusableInTouchMode = this.getField(this.styleableClass, "View_focusableInTouchMode");
    final int View_clickable = this.getField(this.styleableClass, "View_clickable");
    final int View_longClickable = this.getField(this.styleableClass, "View_longClickable");
    final int View_saveEnabled = this.getField(this.styleableClass, "View_saveEnabled");
    final int View_duplicateParentState = this.getField(this.styleableClass, "View_duplicateParentState");
    final int View_visibility = this.getField(this.styleableClass, "View_visibility");
    final int View_drawingCacheQuality = this.getField(this.styleableClass, "View_drawingCacheQuality");
    final int View_contentDescription = this.getField(this.styleableClass, "View_contentDescription");
    final int View_soundEffectsEnabled = this.getField(this.styleableClass, "View_soundEffectsEnabled");
    final int View_hapticFeedbackEnabled = this.getField(this.styleableClass, "View_hapticFeedbackEnabled");
    final int View_scrollbars = this.getField(this.styleableClass, "View_scrollbars");
    final int View_fadingEdge = this.getField(this.styleableClass, "View_fadingEdge");
    final int View_scrollbarStyle = this.getField(this.styleableClass, "View_scrollbarStyle");
    final int View_scrollbarFadeDuration = this.getField(this.styleableClass, "View_scrollbarFadeDuration");
    final int View_scrollbarDefaultDelayBeforeFade = this.getField(this.styleableClass, "View_scrollbarDefaultDelayBeforeFade");
    final int View_scrollbarSize = this.getField(this.styleableClass, "View_scrollbarSize");
    final int View_scrollbarThumbHorizontal = this.getField(this.styleableClass, "View_scrollbarThumbHorizontal");
    final int View_scrollbarThumbVertical = this.getField(this.styleableClass, "View_scrollbarThumbVertical");
    final int View_scrollbarTrackHorizontal = this.getField(this.styleableClass, "View_scrollbarTrackHorizontal");
    final int View_scrollbarTrackVertical = this.getField(this.styleableClass, "View_scrollbarTrackVertical");
    final int View_isScrollContainer = this.getField(this.styleableClass, "View_isScrollContainer");
    final int View_keepScreenOn = this.getField(this.styleableClass, "View_keepScreenOn");
    final int View_filterTouchesWhenObscured = this.getField(this.styleableClass, "View_filterTouchesWhenObscured");
    final int View_nextFocusLeft = this.getField(this.styleableClass, "View_nextFocusLeft");
    final int View_nextFocusRight = this.getField(this.styleableClass, "View_nextFocusRight");
    final int View_nextFocusUp = this.getField(this.styleableClass, "View_nextFocusUp");
    final int View_nextFocusDown = this.getField(this.styleableClass, "View_nextFocusDown");
    final int View_minWidth = this.getField(this.styleableClass, "View_minWidth");
    final int View_minHeight = this.getField(this.styleableClass, "View_minHeight");
    final int View_onClick = this.getField(this.styleableClass, "View_onClick");
    final int View_overScrollMode = this.getField(this.styleableClass, "View_overScrollMode");
    final int View_paddingStart = this.getField(this.styleableClass, "View_paddingStart");
    final int View_paddingEnd = this.getField(this.styleableClass, "View_paddingEnd");
    final int TextAppearance_textColorHighlight = this.getField(this.styleableClass, "TextAppearance_textColorHighlight");
    final int TextAppearance_textColor = this.getField(this.styleableClass, "TextAppearance_textColor");
    final int TextAppearance_textColorHint = this.getField(this.styleableClass, "TextAppearance_textColorHint");
    final int TextAppearance_textColorLink = this.getField(this.styleableClass, "TextAppearance_textColorLink");
    final int TextAppearance_textSize = this.getField(this.styleableClass, "TextAppearance_textSize");
    final int TextAppearance_typeface = this.getField(this.styleableClass, "TextAppearance_typeface");
    final int TextAppearance_textStyle = this.getField(this.styleableClass, "TextAppearance_textStyle");
    final int TextAppearance_textAllCaps = this.getField(this.styleableClass, "TextAppearance_textAllCaps");
    final int TextView_editable = this.getField(this.styleableClass, "TextView_editable");
    final int TextView_inputMethod = this.getField(this.styleableClass, "TextView_inputMethod");
    final int TextView_numeric = this.getField(this.styleableClass, "TextView_numeric");
    final int TextView_digits = this.getField(this.styleableClass, "TextView_digits");
    final int TextView_phoneNumber = this.getField(this.styleableClass, "TextView_phoneNumber");
    final int TextView_autoText = this.getField(this.styleableClass, "TextView_autoText");
    final int TextView_capitalize = this.getField(this.styleableClass, "TextView_capitalize");
    final int TextView_bufferType = this.getField(this.styleableClass, "TextView_bufferType");
    final int TextView_selectAllOnFocus = this.getField(this.styleableClass, "TextView_selectAllOnFocus");
    final int TextView_autoLink = this.getField(this.styleableClass, "TextView_autoLink");
    final int TextView_linksClickable = this.getField(this.styleableClass, "TextView_linksClickable");
    final int TextView_drawableLeft = this.getField(this.styleableClass, "TextView_drawableLeft");
    final int TextView_drawableTop = this.getField(this.styleableClass, "TextView_drawableTop");
    final int TextView_drawableRight = this.getField(this.styleableClass, "TextView_drawableRight");
    final int TextView_drawableBottom = this.getField(this.styleableClass, "TextView_drawableBottom");
    final int TextView_drawableStart = this.getField(this.styleableClass, "TextView_drawableStart");
    final int TextView_drawableEnd = this.getField(this.styleableClass, "TextView_drawableEnd");
    final int TextView_drawablePadding = this.getField(this.styleableClass, "TextView_drawablePadding");
    final int TextView_textCursorDrawable = this.getField(this.styleableClass, "TextView_textCursorDrawable");
    final int TextView_maxLines = this.getField(this.styleableClass, "TextView_maxLines");
    final int TextView_maxHeight = this.getField(this.styleableClass, "TextView_maxHeight");
    final int TextView_lines = this.getField(this.styleableClass, "TextView_lines");
    final int TextView_height = this.getField(this.styleableClass, "TextView_height");
    final int TextView_minLines = this.getField(this.styleableClass, "TextView_minLines");
    final int TextView_minHeight = this.getField(this.styleableClass, "TextView_minHeight");
    final int TextView_maxEms = this.getField(this.styleableClass, "TextView_maxEms");
    final int TextView_maxWidth = this.getField(this.styleableClass, "TextView_maxWidth");
    final int TextView_ems = this.getField(this.styleableClass, "TextView_ems");
    final int TextView_width = this.getField(this.styleableClass, "TextView_width");
    final int TextView_minEms = this.getField(this.styleableClass, "TextView_minEms");
    final int TextView_minWidth = this.getField(this.styleableClass, "TextView_minWidth");
    final int TextView_gravity = this.getField(this.styleableClass, "TextView_gravity");
    final int TextView_hint = this.getField(this.styleableClass, "TextView_hint");
    final int TextView_text = this.getField(this.styleableClass, "TextView_text");
    final int TextView_scrollHorizontally = this.getField(this.styleableClass, "TextView_scrollHorizontally");
    final int TextView_singleLine = this.getField(this.styleableClass, "TextView_singleLine");
    final int TextView_ellipsize = this.getField(this.styleableClass, "TextView_ellipsize");
    final int TextView_marqueeRepeatLimit = this.getField(this.styleableClass, "TextView_marqueeRepeatLimit");
    final int TextView_includeFontPadding = this.getField(this.styleableClass, "TextView_includeFontPadding");
    final int TextView_cursorVisible = this.getField(this.styleableClass, "TextView_cursorVisible");
    final int TextView_maxLength = this.getField(this.styleableClass, "TextView_maxLength");
    final int TextView_textScaleX = this.getField(this.styleableClass, "TextView_textScaleX");
    final int TextView_freezesText = this.getField(this.styleableClass, "TextView_freezesText");
    final int TextView_shadowColor = this.getField(this.styleableClass, "TextView_shadowColor");
    final int TextView_shadowDx = this.getField(this.styleableClass, "TextView_shadowDx");
    final int TextView_shadowDy = this.getField(this.styleableClass, "TextView_shadowDy");
    final int TextView_shadowRadius = this.getField(this.styleableClass, "TextView_shadowRadius");
    final int TextView_enabled = this.getField(this.styleableClass, "TextView_enabled");
    final int TextView_textColorHighlight = this.getField(this.styleableClass, "TextView_textColorHighlight");
    final int TextView_textColor = this.getField(this.styleableClass, "TextView_textColor");
    final int TextView_textColorHint = this.getField(this.styleableClass, "TextView_textColorHint");
    final int TextView_textColorLink = this.getField(this.styleableClass, "TextView_textColorLink");
    final int TextView_textSize = this.getField(this.styleableClass, "TextView_textSize");
    final int TextView_typeface = this.getField(this.styleableClass, "TextView_typeface");
    final int TextView_textStyle = this.getField(this.styleableClass, "TextView_textStyle");
    final int TextView_password = this.getField(this.styleableClass, "TextView_password");
    final int TextView_lineSpacingExtra = this.getField(this.styleableClass, "TextView_lineSpacingExtra");
    final int TextView_lineSpacingMultiplier = this.getField(this.styleableClass, "TextView_lineSpacingMultiplier");
    final int TextView_inputType = this.getField(this.styleableClass, "TextView_inputType");
    final int TextView_imeOptions = this.getField(this.styleableClass, "TextView_imeOptions");
    final int TextView_imeActionLabel = this.getField(this.styleableClass, "TextView_imeActionLabel");
    final int TextView_imeActionId = this.getField(this.styleableClass, "TextView_imeActionId");
    final int TextView_privateImeOptions = this.getField(this.styleableClass, "TextView_privateImeOptions");
    final int TextView_textSelectHandleLeft = this.getField(this.styleableClass, "TextView_textSelectHandleLeft");
    final int TextView_textSelectHandleRight = this.getField(this.styleableClass, "TextView_textSelectHandleRight");
    final int TextView_textSelectHandle = this.getField(this.styleableClass, "TextView_textSelectHandle");
    final int TextView_textIsSelectable = this.getField(this.styleableClass, "TextView_textIsSelectable");
    final int TextView_textAllCaps = this.getField(this.styleableClass, "TextView_textAllCaps");
    final int ImageView_src = this.getField(this.styleableClass, "ImageView_src");
    final int ImageView_baselineAlignBottom = this.getField(this.styleableClass, "ImageView_baselineAlignBottom");
    final int ImageView_adjustViewBounds = this.getField(this.styleableClass, "ImageView_adjustViewBounds");
    final int ImageView_maxWidth = this.getField(this.styleableClass, "ImageView_maxWidth");
    final int ImageView_maxHeight = this.getField(this.styleableClass, "ImageView_maxHeight");
    final int ImageView_scaleType = this.getField(this.styleableClass, "ImageView_scaleType");
    final int ImageView_tint = this.getField(this.styleableClass, "ImageView_tint");
    final int ImageView_cropToPadding = this.getField(this.styleableClass, "ImageView_cropToPadding");
    final Resources.Theme m_theme;
    final String m_extractPath;
    Context m_context;
    final int defaultBackgroundColor;
    final int defaultTextColor;
    final int[] DrawableStates = new int[]{16842914, 0x10100A0, 16842910, 16842908, 16842919, 0x10100A1, 16842909, 0x1020000, 16843597, 16843518, 16843547};
    final String[] DrawableStatesLabels = new String[]{"active", "checked", "enabled", "focused", "pressed", "selected", "window_focused", "background", "multiline", "activated", "accelerated"};
    final String[] DisableDrawableStatesLabels = new String[]{"inactive", "unchecked", "disabled", "not_focused", "no_pressed", "unselected", "window_not_focused", "background", "multiline", "activated", "accelerated"};
    private HashMap<String, DrawableCache> m_drawableCache = new HashMap();
    final String[] sScaleTypeArray = new String[]{"MATRIX", "FIT_XY", "FIT_START", "FIT_CENTER", "FIT_END", "CENTER", "CENTER_CROP", "CENTER_INSIDE"};

    static native int[] extractChunkInfo(byte[] var0);

    static native int[] extractNativeChunkInfo(int var0);

    static native int[] extractChunkInfo20(byte[] var0);

    static native int[] extractNativeChunkInfo20(long var0);

    private int[] stateSetUnion(int[] nArray, int[] nArray2) {
        try {
            int[] nArray3;
            int n = nArray.length;
            int n2 = nArray2.length;
            int[] nArray4 = new int[n + n2];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int n6 : nArray3 = (int[])this.styleableClass.getDeclaredField("ViewDrawableStates").get(null)) {
                if (n4 < n && nArray[n4] == n6) {
                    nArray4[n3++] = n6;
                    ++n4;
                } else if (n5 < n2 && nArray2[n5] == n6) {
                    nArray4[n3++] = n6;
                    ++n5;
                }
                if (n3 > 1) assert (nArray4[n3 - 1] > nArray4[n3 - 2]);
            }
            return nArray4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Class<?> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    Field getAccessibleField(Class<?> clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    Field tryGetAccessibleField(Class<?> clazz, String string) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                Field field = this.tryGetAccessibleField(clazz2, string);
                if (field == null) continue;
                return field;
            }
            return this.tryGetAccessibleField(clazz.getSuperclass(), string);
        }
    }

    int getField(Class<?> clazz, String string) {
        try {
            return clazz.getDeclaredField(string).getInt(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    JSONObject getColorStateList(ColorStateList colorStateList) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("EMPTY_STATE_SET", colorStateList.getColorForState(this.EMPTY_STATE_SET, 0));
            jSONObject.put("WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("SELECTED_STATE_SET", colorStateList.getColorForState(this.SELECTED_STATE_SET, 0));
            jSONObject.put("SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("FOCUSED_STATE_SET", colorStateList.getColorForState(this.FOCUSED_STATE_SET, 0));
            jSONObject.put("FOCUSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.FOCUSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("FOCUSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.FOCUSED_SELECTED_STATE_SET, 0));
            jSONObject.put("FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_STATE_SET", colorStateList.getColorForState(this.ENABLED_STATE_SET, 0));
            jSONObject.put("ENABLED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_SELECTED_STATE_SET", colorStateList.getColorForState(this.ENABLED_SELECTED_STATE_SET, 0));
            jSONObject.put("ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_FOCUSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.ENABLED_FOCUSED_SELECTED_STATE_SET, 0));
            jSONObject.put("ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_STATE_SET, 0));
            jSONObject.put("PRESSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.PRESSED_SELECTED_STATE_SET, 0));
            jSONObject.put("PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_FOCUSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.PRESSED_FOCUSED_SELECTED_STATE_SET, 0));
            jSONObject.put("PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_SELECTED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_SELECTED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    String getFileName(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            string = string + "__" + string2;
        }
        return string;
    }

    String getStatesName(String[] stringArray) {
        String string = "";
        for (String string2 : stringArray) {
            if (string.length() > 0) {
                string = string + "__";
            }
            string = string + string2;
        }
        return string;
    }

    void addDrawableItemIfNotExists(JSONObject jSONObject, ArrayList<Integer> arrayList, Drawable drawable, String[] stringArray, String string) {
        for (Integer n : arrayList) {
            if (!n.equals(drawable.hashCode())) continue;
            return;
        }
        arrayList.add(drawable.hashCode());
        try {
            jSONObject.put(this.getStatesName(stringArray), (Object)this.getDrawable(drawable, this.getFileName(string, stringArray), null));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    void addSolution(String string, JSONObject jSONObject, int n, Drawable drawable, ArrayList<Integer> arrayList, int n2) {
        int n3 = 0;
        int[] nArray = new int[n];
        String[] stringArray = new String[n];
        int n4 = 0;
        while (n2 > 0) {
            if ((n2 & 1) > 0) {
                stringArray[n3] = this.DrawableStatesLabels[n4];
                nArray[n3++] = this.DrawableStates[n4];
            }
            ++n4;
            n2 >>= 1;
        }
        drawable.setState(nArray);
        this.addDrawableItemIfNotExists(jSONObject, arrayList, drawable.getCurrent(), stringArray, string);
    }

    int bitCount(int n) {
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n &= n - 1;
        }
        return n2;
    }

    JSONObject getStatesList(int[] nArray) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (int n : nArray) {
            boolean bl = false;
            for (int i = 0; i < this.DrawableStates.length; ++i) {
                if (n == this.DrawableStates[i]) {
                    jSONObject.put(this.DrawableStatesLabels[i], true);
                    bl = true;
                    break;
                }
                if (n != -this.DrawableStates[i]) continue;
                jSONObject.put(this.DrawableStatesLabels[i], false);
                bl = true;
                break;
            }
            if (bl) continue;
            jSONObject.put("unhandled_state_" + n, n > 0);
        }
        return jSONObject;
    }

    String getStatesName(int[] nArray) {
        String string = "";
        for (int n : nArray) {
            boolean bl = false;
            for (int i = 0; i < this.DrawableStates.length; ++i) {
                if (n == this.DrawableStates[i]) {
                    if (string.length() > 0) {
                        string = string + "__";
                    }
                    string = string + this.DrawableStatesLabels[i];
                    bl = true;
                    break;
                }
                if (n != -this.DrawableStates[i]) continue;
                if (string.length() > 0) {
                    string = string + "__";
                }
                string = string + this.DisableDrawableStatesLabels[i];
                bl = true;
                break;
            }
            if (bl) continue;
            if (string.length() > 0) {
                string = string + ";";
            }
            string = string + n;
        }
        if (string.length() > 0) {
            return string;
        }
        return "empty";
    }

    private JSONObject getLayerDrawable(Object object, String string) {
        JSONObject jSONObject = new JSONObject();
        LayerDrawable layerDrawable = (LayerDrawable)object;
        int n = layerDrawable.getNumberOfLayers();
        try {
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < n; ++i) {
                int n2 = layerDrawable.getId(i);
                if (n2 == -1) {
                    n2 = i;
                }
                JSONObject jSONObject2 = this.getDrawable(layerDrawable.getDrawable(i), string + "__" + n2, null);
                jSONObject2.put("id", n2);
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("type", (Object)"layer");
            Rect rect = new Rect();
            if (layerDrawable.getPadding(rect)) {
                jSONObject.put("padding", (Object)this.getJsonRect(rect));
            }
            jSONObject.put("layers", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getStateListDrawable(Object object, String string) {
        JSONObject jSONObject = new JSONObject();
        try {
            StateListDrawable stateListDrawable = (StateListDrawable)object;
            int n = (Integer)StateListDrawable.class.getMethod("getStateCount", new Class[0]).invoke((Object)stateListDrawable, new Object[0]);
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = new JSONObject();
                Drawable drawable = (Drawable)StateListDrawable.class.getMethod("getStateDrawable", Integer.TYPE).invoke((Object)stateListDrawable, i);
                int[] nArray = (int[])StateListDrawable.class.getMethod("getStateSet", Integer.TYPE).invoke((Object)stateListDrawable, i);
                if (nArray != null) {
                    jSONObject2.put("states", (Object)this.getStatesList(nArray));
                }
                jSONObject2.put("drawable", (Object)this.getDrawable(drawable, string + "__" + (nArray != null ? this.getStatesName(nArray) : "state_pos_" + i), null));
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("type", (Object)"stateslist");
            Rect rect = new Rect();
            if (stateListDrawable.getPadding(rect)) {
                jSONObject.put("padding", (Object)this.getJsonRect(rect));
            }
            jSONObject.put("stateslist", (Object)jSONArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getGradientDrawable(GradientDrawable gradientDrawable) {
        JSONObject jSONObject = new JSONObject();
        try {
            Rect rect;
            jSONObject.put("type", (Object)"gradient");
            Drawable.ConstantState constantState = gradientDrawable.getConstantState();
            Class<?> clazz = constantState.getClass();
            jSONObject.put("shape", clazz.getField("mShape").getInt(constantState));
            jSONObject.put("gradient", clazz.getField("mGradient").getInt(constantState));
            GradientDrawable.Orientation orientation = (GradientDrawable.Orientation)clazz.getField("mOrientation").get(constantState);
            jSONObject.put("orientation", (Object)orientation.name());
            int[] nArray = (int[])clazz.getField("mColors").get(constantState);
            if (nArray != null) {
                jSONObject.put("colors", (Object)this.getJsonArray(nArray, 0, nArray.length));
            }
            jSONObject.put("positions", (Object)this.getJsonArray((float[])clazz.getField("mPositions").get(constantState)));
            jSONObject.put("strokeWidth", clazz.getField("mStrokeWidth").getInt(constantState));
            jSONObject.put("strokeDashWidth", (double)clazz.getField("mStrokeDashWidth").getFloat(constantState));
            jSONObject.put("strokeDashGap", (double)clazz.getField("mStrokeDashGap").getFloat(constantState));
            jSONObject.put("radius", (double)clazz.getField("mRadius").getFloat(constantState));
            float[] fArray = (float[])clazz.getField("mRadiusArray").get(constantState);
            if (fArray != null) {
                jSONObject.put("radiusArray", (Object)this.getJsonArray(fArray));
            }
            if ((rect = (Rect)clazz.getField("mPadding").get(constantState)) != null) {
                jSONObject.put("padding", (Object)this.getJsonRect(rect));
            }
            jSONObject.put("width", clazz.getField("mWidth").getInt(constantState));
            jSONObject.put("height", clazz.getField("mHeight").getInt(constantState));
            jSONObject.put("innerRadiusRatio", (double)clazz.getField("mInnerRadiusRatio").getFloat(constantState));
            jSONObject.put("thicknessRatio", (double)clazz.getField("mThicknessRatio").getFloat(constantState));
            jSONObject.put("innerRadius", clazz.getField("mInnerRadius").getInt(constantState));
            jSONObject.put("thickness", clazz.getField("mThickness").getInt(constantState));
            if (Build.VERSION.SDK_INT < 20) {
                jSONObject.put("solidColor", clazz.getField("mSolidColor").getInt(constantState));
                jSONObject.put("strokeColor", clazz.getField("mStrokeColor").getInt(constantState));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getRotateDrawable(RotateDrawable rotateDrawable, String string) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"rotate");
            Drawable.ConstantState constantState = rotateDrawable.getConstantState();
            Class<?> clazz = constantState.getClass();
            jSONObject.put("drawable", (Object)this.getDrawable(this.getAccessibleField(clazz, "mDrawable").get(constantState), string, null));
            jSONObject.put("pivotX", (double)this.getAccessibleField(clazz, "mPivotX").getFloat(constantState));
            jSONObject.put("pivotXRel", this.getAccessibleField(clazz, "mPivotXRel").getBoolean(constantState));
            jSONObject.put("pivotY", (double)this.getAccessibleField(clazz, "mPivotY").getFloat(constantState));
            jSONObject.put("pivotYRel", this.getAccessibleField(clazz, "mPivotYRel").getBoolean(constantState));
            jSONObject.put("fromDegrees", (double)this.getAccessibleField(clazz, "mFromDegrees").getFloat(constantState));
            jSONObject.put("toDegrees", (double)this.getAccessibleField(clazz, "mToDegrees").getFloat(constantState));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getAnimationDrawable(AnimationDrawable animationDrawable, String string) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"animation");
            jSONObject.put("oneshot", animationDrawable.isOneShot());
            int n = animationDrawable.getNumberOfFrames();
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("duration", animationDrawable.getDuration(i));
                jSONObject2.put("drawable", (Object)this.getDrawable(animationDrawable.getFrame(i), string + "__" + i, null));
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("frames", (Object)jSONArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getJsonRect(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("left", rect.left);
        jSONObject.put("top", rect.top);
        jSONObject.put("right", rect.right);
        jSONObject.put("bottom", rect.bottom);
        return jSONObject;
    }

    private JSONArray getJsonArray(int[] nArray, int n, int n2) {
        JSONArray jSONArray = new JSONArray();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            jSONArray.put(nArray[i]);
        }
        return jSONArray;
    }

    private JSONArray getJsonArray(float[] fArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        if (fArray != null) {
            for (float f : fArray) {
                jSONArray.put((double)f);
            }
        }
        return jSONArray;
    }

    private JSONObject getJsonChunkInfo(int[] nArray) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (nArray == null) {
            return jSONObject;
        }
        jSONObject.put("xdivs", (Object)this.getJsonArray(nArray, 3, nArray[0]));
        jSONObject.put("ydivs", (Object)this.getJsonArray(nArray, 3 + nArray[0], nArray[1]));
        jSONObject.put("colors", (Object)this.getJsonArray(nArray, 3 + nArray[0] + nArray[1], nArray[2]));
        return jSONObject;
    }

    private JSONObject findPatchesMarings(Drawable drawable) throws JSONException, NoSuchFieldException, IllegalAccessException {
        NinePatch ninePatch = (NinePatch)this.getAccessibleField(NinePatchDrawable.class, "mNinePatch").get(drawable);
        if (Build.VERSION.SDK_INT < 19) {
            return this.getJsonChunkInfo(ExtractStyle.extractChunkInfo((byte[])this.getAccessibleField(ninePatch.getClass(), "mChunk").get(ninePatch)));
        }
        if (Build.VERSION.SDK_INT > 19) {
            return this.getJsonChunkInfo(ExtractStyle.extractNativeChunkInfo20(this.getAccessibleField(ninePatch.getClass(), "mNativeChunk").getLong(ninePatch)));
        }
        return this.getJsonChunkInfo(ExtractStyle.extractNativeChunkInfo(this.getAccessibleField(ninePatch.getClass(), "mNativeChunk").getInt(ninePatch)));
    }

    private JSONObject getRippleDrawable(Object object, String string, Rect rect) {
        JSONObject jSONObject = this.getLayerDrawable(object, string);
        JSONObject jSONObject2 = new JSONObject();
        try {
            Object object2 = this.getAccessibleField(this.rippleDrawableClass, "mState").get(object);
            jSONObject2.put("mask", (Object)this.getDrawable((Drawable)this.getAccessibleField(this.rippleDrawableClass, "mMask").get(object), string, rect));
            jSONObject2.put("maxRadius", this.getAccessibleField(object2.getClass(), "mMaxRadius").getInt(object2));
            jSONObject2.put("color", (Object)this.getColorStateList((ColorStateList)this.getAccessibleField(object2.getClass(), "mColor").get(object2)));
            jSONObject.put("ripple", (Object)jSONObject2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private HashMap<Long, Long> getStateTransitions(Object object) throws Exception {
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        int n = this.getAccessibleField(object.getClass(), "mSize").getInt(object);
        long[] lArray = (long[])this.getAccessibleField(object.getClass(), "mKeys").get(object);
        long[] lArray2 = (long[])this.getAccessibleField(object.getClass(), "mValues").get(object);
        for (int i = 0; i < n; ++i) {
            hashMap.put(lArray[i], lArray2[i]);
        }
        return hashMap;
    }

    private HashMap<Integer, Integer> getStateIds(Object object) throws Exception {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = this.getAccessibleField(object.getClass(), "mSize").getInt(object);
        int[] nArray = (int[])this.getAccessibleField(object.getClass(), "mKeys").get(object);
        int[] nArray2 = (int[])this.getAccessibleField(object.getClass(), "mValues").get(object);
        for (int i = 0; i < n; ++i) {
            hashMap.put(nArray[i], nArray2[i]);
        }
        return hashMap;
    }

    private int findStateIndex(int n, HashMap<Integer, Integer> hashMap) {
        for (Map.Entry<Integer, Integer> entry : hashMap.entrySet()) {
            if (n != entry.getValue()) continue;
            return entry.getKey();
        }
        return -1;
    }

    private JSONObject getAnimatedStateListDrawable(Object object, String string) {
        JSONObject jSONObject = this.getStateListDrawable(object, string);
        try {
            Object object2 = this.getAccessibleField(this.animatedStateListDrawableClass, "mState").get(object);
            HashMap<Integer, Integer> hashMap = this.getStateIds(this.getAccessibleField(object2.getClass(), "mStateIds").get(object2));
            HashMap<Long, Long> hashMap2 = this.getStateTransitions(this.getAccessibleField(object2.getClass(), "mTransitions").get(object2));
            for (Map.Entry<Long, Long> entry : hashMap2.entrySet()) {
                int n = this.findStateIndex(entry.getKey().intValue(), hashMap);
                int n2 = this.findStateIndex((int)(entry.getKey() >> 32), hashMap);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("from", n2);
                jSONObject2.put("to", n);
                jSONObject2.put("reverse", entry.getValue() >> 32 != 0L);
                JSONArray jSONArray = jSONObject.getJSONArray("stateslist");
                JSONObject jSONObject3 = jSONArray.getJSONObject(entry.getValue().intValue());
                jSONObject3.put("transition", (Object)jSONObject2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getVPath(Object object) throws Exception {
        JSONObject jSONObject = new JSONObject();
        Class<?> clazz = object.getClass();
        jSONObject.put("type", (Object)"path");
        jSONObject.put("name", this.tryGetAccessibleField(clazz, "mPathName").get(object));
        Object[] objectArray = (Object[])this.tryGetAccessibleField(clazz, "mNodes").get(object);
        JSONArray jSONArray = new JSONArray();
        for (Object object2 : objectArray) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("type", (Object)String.valueOf(this.getAccessibleField(object2.getClass(), "mType").getChar(object2)));
            jSONObject2.put("params", (Object)this.getJsonArray((float[])this.getAccessibleField(object2.getClass(), "mParams").get(object2)));
            jSONArray.put((Object)jSONObject2);
        }
        jSONObject.put("nodes", (Object)jSONArray);
        jSONObject.put("isClip", (Object)((Boolean)clazz.getMethod("isClipPath", new Class[0]).invoke(object, new Object[0])));
        if (this.tryGetAccessibleField(clazz, "mStrokeColor") == null) {
            return jSONObject;
        }
        jSONObject.put("strokeColor", this.getAccessibleField(clazz, "mStrokeColor").getInt(object));
        jSONObject.put("strokeWidth", (double)this.getAccessibleField(clazz, "mStrokeWidth").getFloat(object));
        jSONObject.put("fillColor", this.getAccessibleField(clazz, "mFillColor").getInt(object));
        jSONObject.put("strokeAlpha", (double)this.getAccessibleField(clazz, "mStrokeAlpha").getFloat(object));
        jSONObject.put("fillRule", this.getAccessibleField(clazz, "mFillRule").getInt(object));
        jSONObject.put("fillAlpha", (double)this.getAccessibleField(clazz, "mFillAlpha").getFloat(object));
        jSONObject.put("trimPathStart", (double)this.getAccessibleField(clazz, "mTrimPathStart").getFloat(object));
        jSONObject.put("trimPathEnd", (double)this.getAccessibleField(clazz, "mTrimPathEnd").getFloat(object));
        jSONObject.put("trimPathOffset", (double)this.getAccessibleField(clazz, "mTrimPathOffset").getFloat(object));
        jSONObject.put("strokeLineCap", (Object)((Paint.Cap)this.getAccessibleField(clazz, "mStrokeLineCap").get(object)));
        jSONObject.put("strokeLineJoin", (Object)((Paint.Join)this.getAccessibleField(clazz, "mStrokeLineJoin").get(object)));
        jSONObject.put("strokeMiterlimit", (double)this.getAccessibleField(clazz, "mStrokeMiterlimit").getFloat(object));
        return jSONObject;
    }

    private JSONObject getVGroup(Object object) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", (Object)"group");
        Class<?> clazz = object.getClass();
        jSONObject.put("name", this.getAccessibleField(clazz, "mGroupName").get(object));
        jSONObject.put("rotate", (double)this.getAccessibleField(clazz, "mRotate").getFloat(object));
        jSONObject.put("pivotX", (double)this.getAccessibleField(clazz, "mPivotX").getFloat(object));
        jSONObject.put("pivotY", (double)this.getAccessibleField(clazz, "mPivotY").getFloat(object));
        jSONObject.put("scaleX", (double)this.getAccessibleField(clazz, "mScaleX").getFloat(object));
        jSONObject.put("scaleY", (double)this.getAccessibleField(clazz, "mScaleY").getFloat(object));
        jSONObject.put("translateX", (double)this.getAccessibleField(clazz, "mTranslateX").getFloat(object));
        jSONObject.put("translateY", (double)this.getAccessibleField(clazz, "mTranslateY").getFloat(object));
        ArrayList arrayList = (ArrayList)this.getAccessibleField(clazz, "mChildren").get(object);
        JSONArray jSONArray = new JSONArray();
        for (Object e : arrayList) {
            if (clazz.isInstance(e)) {
                jSONArray.put((Object)this.getVGroup(e));
                continue;
            }
            jSONArray.put((Object)this.getVPath(e));
        }
        jSONObject.put("children", (Object)jSONArray);
        return jSONObject;
    }

    private JSONObject getVectorDrawable(Object object, String string, Rect rect) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"vector");
            Object object2 = this.getAccessibleField(this.vectorDrawableClass, "mVectorState").get(object);
            Class<?> clazz = object2.getClass();
            ColorStateList colorStateList = (ColorStateList)this.getAccessibleField(clazz, "mTint").get(object2);
            if (colorStateList != null) {
                jSONObject.put("tintList", (Object)this.getColorStateList(colorStateList));
                jSONObject.put("tintMode", (Object)((PorterDuff.Mode)this.getAccessibleField(clazz, "mTintMode").get(object2)));
            }
            Object object3 = this.getAccessibleField(clazz, "mVPathRenderer").get(object2);
            Class<?> clazz2 = object3.getClass();
            jSONObject.put("baseWidth", (double)this.getAccessibleField(clazz2, "mBaseWidth").getFloat(object3));
            jSONObject.put("baseHeight", (double)this.getAccessibleField(clazz2, "mBaseHeight").getFloat(object3));
            jSONObject.put("viewportWidth", (double)this.getAccessibleField(clazz2, "mViewportWidth").getFloat(object3));
            jSONObject.put("viewportHeight", (double)this.getAccessibleField(clazz2, "mViewportHeight").getFloat(object3));
            jSONObject.put("rootAlpha", this.getAccessibleField(clazz2, "mRootAlpha").getInt(object3));
            jSONObject.put("rootName", this.getAccessibleField(clazz2, "mRootName").get(object3));
            jSONObject.put("rootGroup", (Object)this.getVGroup(this.getAccessibleField(object3.getClass(), "mRootGroup").get(object3)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    public JSONObject getDrawable(Object object, String string, Rect rect) {
        Object object2;
        Bitmap bitmap;
        JSONObject jSONObject;
        block48: {
            if (object == null) {
                return null;
            }
            DrawableCache drawableCache = this.m_drawableCache.get(string);
            if (drawableCache != null) {
                if (drawableCache.drawable.equals(object)) {
                    return drawableCache.object;
                }
                Log.e((String)"Qt JAVA", (String)("Different drawable objects points to the same file name \"" + string + "\""));
            }
            jSONObject = new JSONObject();
            bitmap = null;
            if (object instanceof Bitmap) {
                bitmap = (Bitmap)object;
            } else if (object instanceof BitmapDrawable) {
                object2 = (BitmapDrawable)object;
                bitmap = object2.getBitmap();
                try {
                    jSONObject.put("gravity", object2.getGravity());
                    jSONObject.put("tileModeX", (Object)object2.getTileModeX());
                    jSONObject.put("tileModeY", (Object)object2.getTileModeY());
                    if (Build.VERSION.SDK_INT >= 18) {
                        jSONObject.put("antialias", (Object)((Boolean)BitmapDrawable.class.getMethod("hasAntiAlias", new Class[0]).invoke(object2, new Object[0])));
                        jSONObject.put("mipMap", (Object)((Boolean)BitmapDrawable.class.getMethod("hasMipMap", new Class[0]).invoke(object2, new Object[0])));
                    }
                    if (Build.VERSION.SDK_INT < 21) break block48;
                    jSONObject.put("tintMode", (Object)((PorterDuff.Mode)BitmapDrawable.class.getMethod("getTintMode", new Class[0]).invoke(object2, new Object[0])));
                    ColorStateList colorStateList = (ColorStateList)BitmapDrawable.class.getMethod("getTint", new Class[0]).invoke(object2, new Object[0]);
                    if (colorStateList != null) {
                        jSONObject.put("tintList", (Object)this.getColorStateList(colorStateList));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                if (this.rippleDrawableClass != null && this.rippleDrawableClass.isInstance(object)) {
                    return this.getRippleDrawable(object, string, rect);
                }
                if (this.animatedStateListDrawableClass != null && this.animatedStateListDrawableClass.isInstance(object)) {
                    return this.getAnimatedStateListDrawable(object, string);
                }
                if (this.vectorDrawableClass != null && this.vectorDrawableClass.isInstance(object)) {
                    return this.getVectorDrawable(object, string, rect);
                }
                if (object instanceof ScaleDrawable) {
                    return this.getDrawable(((ScaleDrawable)object).getDrawable(), string, null);
                }
                if (object instanceof LayerDrawable) {
                    return this.getLayerDrawable(object, string);
                }
                if (object instanceof StateListDrawable) {
                    return this.getStateListDrawable(object, string);
                }
                if (object instanceof GradientDrawable) {
                    return this.getGradientDrawable((GradientDrawable)object);
                }
                if (object instanceof RotateDrawable) {
                    return this.getRotateDrawable((RotateDrawable)object, string);
                }
                if (object instanceof AnimationDrawable) {
                    return this.getAnimationDrawable((AnimationDrawable)object, string);
                }
                if (object instanceof ClipDrawable) {
                    try {
                        jSONObject.put("type", (Object)"clipDrawable");
                        Drawable.ConstantState constantState = ((ClipDrawable)object).getConstantState();
                        jSONObject.put("drawable", (Object)this.getDrawable(this.getAccessibleField(constantState.getClass(), "mDrawable").get(constantState), string, null));
                        if (null != rect) {
                            jSONObject.put("padding", (Object)this.getJsonRect(rect));
                        } else {
                            Rect rect2 = new Rect();
                            if (((Drawable)object).getPadding(rect2)) {
                                jSONObject.put("padding", (Object)this.getJsonRect(rect2));
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return jSONObject;
                }
                if (object instanceof ColorDrawable) {
                    bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Drawable drawable = (Drawable)object;
                    drawable.setBounds(0, 0, 1, 1);
                    drawable.draw(new Canvas(bitmap));
                    try {
                        jSONObject.put("type", (Object)"color");
                        jSONObject.put("color", bitmap.getPixel(0, 0));
                        if (null != rect) {
                            jSONObject.put("padding", (Object)this.getJsonRect(rect));
                        } else {
                            Rect rect3 = new Rect();
                            if (drawable.getPadding(rect3)) {
                                jSONObject.put("padding", (Object)this.getJsonRect(rect3));
                            }
                        }
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    return jSONObject;
                }
                if (object instanceof InsetDrawable) {
                    try {
                        InsetDrawable insetDrawable = (InsetDrawable)object;
                        Object object3 = this.getAccessibleField(InsetDrawable.class, Build.VERSION.SDK_INT > 21 ? "mState" : "mInsetState").get(insetDrawable);
                        Rect rect4 = new Rect();
                        boolean bl = insetDrawable.getPadding(rect4);
                        return this.getDrawable(this.getAccessibleField(object3.getClass(), "mDrawable").get(object3), string, (Rect)(bl ? rect4 : null));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    object2 = (Drawable)object;
                    int n = object2.getIntrinsicWidth();
                    int n2 = object2.getIntrinsicHeight();
                    object2.setLevel(10000);
                    if (n < 1 || n2 < 1) {
                        n = 100;
                        n2 = 100;
                    }
                    bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    object2.setBounds(0, 0, n, n2);
                    object2.draw(new Canvas(bitmap));
                    if (object instanceof NinePatchDrawable) {
                        NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)object;
                        try {
                            jSONObject.put("type", (Object)"9patch");
                            jSONObject.put("drawable", (Object)this.getDrawable(bitmap, string, null));
                            if (rect != null) {
                                jSONObject.put("padding", (Object)this.getJsonRect(rect));
                            } else {
                                Rect rect5 = new Rect();
                                if (ninePatchDrawable.getPadding(rect5)) {
                                    jSONObject.put("padding", (Object)this.getJsonRect(rect5));
                                }
                            }
                            jSONObject.put("chunkInfo", (Object)this.findPatchesMarings((Drawable)object2));
                            return jSONObject;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        }
        try {
            string = this.m_extractPath + string + ".png";
            object2 = new FileOutputStream(string);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object2);
            ((FileOutputStream)object2).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            jSONObject.put("type", (Object)"image");
            jSONObject.put("path", (Object)string);
            jSONObject.put("width", bitmap.getWidth());
            jSONObject.put("height", bitmap.getHeight());
            this.m_drawableCache.put(string, new DrawableCache(jSONObject, object));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public void extractViewInformations(String string, int n, JSONObject jSONObject, String string2, AttributeSet attributeSet) {
        try {
            int[] nArray = (int[])this.styleableClass.getDeclaredField("View").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(attributeSet, nArray, n, 0);
            if (null != string2) {
                jSONObject.put("qtClass", (Object)string2);
            }
            jSONObject.put("defaultBackgroundColor", this.defaultBackgroundColor);
            jSONObject.put("defaultTextColorPrimary", this.defaultTextColor);
            int n2 = typedArray.getIndexCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = typedArray.getIndex(i);
                if (n3 == this.View_background) {
                    jSONObject.put("View_background", (Object)this.getDrawable(typedArray.getDrawable(n3), string + "_View_background", null));
                    continue;
                }
                if (n3 == this.View_padding) {
                    jSONObject.put("View_padding", typedArray.getDimensionPixelSize(n3, -1));
                    continue;
                }
                if (n3 == this.View_paddingLeft) {
                    jSONObject.put("View_paddingLeft", typedArray.getDimensionPixelSize(n3, -1));
                    continue;
                }
                if (n3 == this.View_paddingTop) {
                    jSONObject.put("View_paddingTop", typedArray.getDimensionPixelSize(n3, -1));
                    continue;
                }
                if (n3 == this.View_paddingRight) {
                    jSONObject.put("View_paddingRight", typedArray.getDimensionPixelSize(n3, -1));
                    continue;
                }
                if (n3 == this.View_paddingBottom) {
                    jSONObject.put("View_paddingBottom", typedArray.getDimensionPixelSize(n3, -1));
                    continue;
                }
                if (n3 == this.View_scrollX) {
                    jSONObject.put("View_paddingBottom", typedArray.getDimensionPixelOffset(n3, 0));
                    continue;
                }
                if (n3 == this.View_scrollY) {
                    jSONObject.put("View_scrollY", typedArray.getDimensionPixelOffset(n3, 0));
                    continue;
                }
                if (n3 == this.View_id) {
                    jSONObject.put("View_id", typedArray.getResourceId(n3, -1));
                    continue;
                }
                if (n3 == this.View_tag) {
                    jSONObject.put("View_tag", (Object)typedArray.getText(n3));
                    continue;
                }
                if (n3 == this.View_fitsSystemWindows) {
                    jSONObject.put("View_fitsSystemWindows", typedArray.getBoolean(n3, false));
                    continue;
                }
                if (n3 == this.View_focusable) {
                    jSONObject.put("View_focusable", typedArray.getBoolean(n3, false));
                    continue;
                }
                if (n3 == this.View_focusableInTouchMode) {
                    jSONObject.put("View_focusableInTouchMode", typedArray.getBoolean(n3, false));
                    continue;
                }
                if (n3 == this.View_clickable) {
                    jSONObject.put("View_clickable", typedArray.getBoolean(n3, false));
                    continue;
                }
                if (n3 == this.View_longClickable) {
                    jSONObject.put("View_longClickable", typedArray.getBoolean(n3, false));
                    continue;
                }
                if (n3 == this.View_saveEnabled) {
                    jSONObject.put("View_saveEnabled", typedArray.getBoolean(n3, true));
                    continue;
                }
                if (n3 == this.View_duplicateParentState) {
                    jSONObject.put("View_duplicateParentState", typedArray.getBoolean(n3, false));
                    continue;
                }
                if (n3 == this.View_visibility) {
                    jSONObject.put("View_visibility", typedArray.getInt(n3, 0));
                    continue;
                }
                if (n3 == this.View_drawingCacheQuality) {
                    jSONObject.put("View_drawingCacheQuality", typedArray.getInt(n3, 0));
                    continue;
                }
                if (n3 == this.View_drawingCacheQuality) {
                    jSONObject.put("View_contentDescription", (Object)typedArray.getString(n3));
                    continue;
                }
                if (n3 == this.View_soundEffectsEnabled) {
                    jSONObject.put("View_soundEffectsEnabled", typedArray.getBoolean(n3, true));
                    continue;
                }
                if (n3 == this.View_hapticFeedbackEnabled) {
                    jSONObject.put("View_hapticFeedbackEnabled", typedArray.getBoolean(n3, true));
                    continue;
                }
                if (n3 == this.View_scrollbars) {
                    jSONObject.put("View_scrollbars", typedArray.getInt(n3, 0));
                    continue;
                }
                if (n3 == this.View_fadingEdge) {
                    jSONObject.put("View_fadingEdge", typedArray.getInt(n3, 0));
                    continue;
                }
                if (n3 == this.View_scrollbarStyle) {
                    jSONObject.put("View_scrollbarStyle", typedArray.getInt(n3, 0));
                    continue;
                }
                if (n3 == this.View_scrollbarFadeDuration) {
                    jSONObject.put("View_scrollbarFadeDuration", typedArray.getInt(n3, 0));
                    continue;
                }
                if (n3 == this.View_scrollbarDefaultDelayBeforeFade) {
                    jSONObject.put("View_scrollbarDefaultDelayBeforeFade", typedArray.getInt(n3, 0));
                    continue;
                }
                if (n3 == this.View_scrollbarSize) {
                    jSONObject.put("View_scrollbarSize", typedArray.getDimensionPixelSize(n3, -1));
                    continue;
                }
                if (n3 == this.View_scrollbarThumbHorizontal) {
                    jSONObject.put("View_scrollbarThumbHorizontal", (Object)this.getDrawable(typedArray.getDrawable(n3), string + "_View_scrollbarThumbHorizontal", null));
                    continue;
                }
                if (n3 == this.View_scrollbarThumbVertical) {
                    jSONObject.put("View_scrollbarThumbVertical", (Object)this.getDrawable(typedArray.getDrawable(n3), string + "_View_scrollbarThumbVertical", null));
                    continue;
                }
                if (n3 == this.View_scrollbarTrackHorizontal) {
                    jSONObject.put("View_scrollbarTrackHorizontal", (Object)this.getDrawable(typedArray.getDrawable(n3), string + "_View_scrollbarTrackHorizontal", null));
                    continue;
                }
                if (n3 == this.View_scrollbarTrackVertical) {
                    jSONObject.put("View_scrollbarTrackVertical", (Object)this.getDrawable(typedArray.getDrawable(n3), string + "_View_scrollbarTrackVertical", null));
                    continue;
                }
                if (n3 == this.View_isScrollContainer) {
                    jSONObject.put("View_isScrollContainer", typedArray.getBoolean(n3, false));
                    continue;
                }
                if (n3 == this.View_keepScreenOn) {
                    jSONObject.put("View_keepScreenOn", typedArray.getBoolean(n3, false));
                    continue;
                }
                if (n3 == this.View_filterTouchesWhenObscured) {
                    jSONObject.put("View_filterTouchesWhenObscured", typedArray.getBoolean(n3, false));
                    continue;
                }
                if (n3 == this.View_nextFocusLeft) {
                    jSONObject.put("View_nextFocusLeft", typedArray.getResourceId(n3, -1));
                    continue;
                }
                if (n3 == this.View_nextFocusRight) {
                    jSONObject.put("View_nextFocusRight", typedArray.getResourceId(n3, -1));
                    continue;
                }
                if (n3 == this.View_nextFocusUp) {
                    jSONObject.put("View_nextFocusUp", typedArray.getResourceId(n3, -1));
                    continue;
                }
                if (n3 == this.View_nextFocusDown) {
                    jSONObject.put("View_nextFocusDown", typedArray.getResourceId(n3, -1));
                    continue;
                }
                if (n3 == this.View_minWidth) {
                    jSONObject.put("View_minWidth", typedArray.getDimensionPixelSize(n3, 0));
                    continue;
                }
                if (n3 == this.View_minHeight) {
                    jSONObject.put("View_minHeight", typedArray.getDimensionPixelSize(n3, 0));
                    continue;
                }
                if (n3 == this.View_onClick) {
                    jSONObject.put("View_onClick", (Object)typedArray.getString(n3));
                    continue;
                }
                if (n3 == this.View_overScrollMode) {
                    jSONObject.put("View_overScrollMode", typedArray.getInt(n3, 1));
                    continue;
                }
                if (n3 == this.View_paddingStart) {
                    jSONObject.put("View_paddingStart", typedArray.getDimensionPixelSize(n3, 0));
                    continue;
                }
                if (n3 != this.View_paddingEnd) continue;
                jSONObject.put("View_paddingEnd", typedArray.getDimensionPixelSize(n3, 0));
            }
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JSONObject extractTextAppearance(int n) {
        JSONObject jSONObject = new JSONObject();
        try {
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(n, (int[])this.styleableClass.getDeclaredField("TextAppearance").get(null));
            int n2 = typedArray.getIndexCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = typedArray.getIndex(i);
                if (n3 == this.TextAppearance_textColorHighlight) {
                    jSONObject.put("TextAppearance_textColorHighlight", typedArray.getColor(n3, 0));
                    continue;
                }
                if (n3 == this.TextAppearance_textColor) {
                    jSONObject.put("TextAppearance_textColor", (Object)this.getColorStateList(typedArray.getColorStateList(n3)));
                    continue;
                }
                if (n3 == this.TextAppearance_textColorHint) {
                    jSONObject.put("TextAppearance_textColorHint", (Object)this.getColorStateList(typedArray.getColorStateList(n3)));
                    continue;
                }
                if (n3 == this.TextAppearance_textColorLink) {
                    jSONObject.put("TextAppearance_textColorLink", (Object)this.getColorStateList(typedArray.getColorStateList(n3)));
                    continue;
                }
                if (n3 == this.TextAppearance_textSize) {
                    jSONObject.put("TextAppearance_textSize", typedArray.getDimensionPixelSize(n3, 15));
                    continue;
                }
                if (n3 == this.TextAppearance_typeface) {
                    jSONObject.put("TextAppearance_typeface", typedArray.getInt(n3, -1));
                    continue;
                }
                if (n3 == this.TextAppearance_textStyle) {
                    jSONObject.put("TextAppearance_textStyle", typedArray.getInt(n3, -1));
                    continue;
                }
                if (n3 != this.TextAppearance_textAllCaps) continue;
                jSONObject.put("TextAppearance_textAllCaps", typedArray.getBoolean(n3, false));
            }
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    public JSONObject extractTextAppearanceInformations(String string, String string2, AttributeSet attributeSet, int n) {
        JSONObject jSONObject = new JSONObject();
        try {
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            ColorStateList colorStateList = null;
            ColorStateList colorStateList2 = null;
            ColorStateList colorStateList3 = null;
            int n6 = 15;
            int n7 = -1;
            int n8 = -1;
            boolean bl = false;
            Class<?> clazz = Class.forName("android.R$attr");
            int n9 = clazz.getDeclaredField(string).getInt(null);
            this.extractViewInformations(string, n9, jSONObject, string2, attributeSet);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("TextView").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n9, 0);
            TypedArray typedArray2 = null;
            if (-1 == n) {
                n = typedArray.getResourceId(this.styleableClass.getDeclaredField("TextView_textAppearance").getInt(null), -1);
            }
            if (n != -1) {
                typedArray2 = this.m_theme.obtainStyledAttributes(n, (int[])this.styleableClass.getDeclaredField("TextAppearance").get(null));
            }
            if (typedArray2 != null) {
                n4 = typedArray2.getIndexCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = typedArray2.getIndex(n3);
                    if (n2 == this.TextAppearance_textColorHighlight) {
                        n5 = typedArray2.getColor(n2, n5);
                        continue;
                    }
                    if (n2 == this.TextAppearance_textColor) {
                        colorStateList = typedArray2.getColorStateList(n2);
                        continue;
                    }
                    if (n2 == this.TextAppearance_textColorHint) {
                        colorStateList2 = typedArray2.getColorStateList(n2);
                        continue;
                    }
                    if (n2 == this.TextAppearance_textColorLink) {
                        colorStateList3 = typedArray2.getColorStateList(n2);
                        continue;
                    }
                    if (n2 == this.TextAppearance_textSize) {
                        n6 = typedArray2.getDimensionPixelSize(n2, n6);
                        continue;
                    }
                    if (n2 == this.TextAppearance_typeface) {
                        n7 = typedArray2.getInt(n2, -1);
                        continue;
                    }
                    if (n2 == this.TextAppearance_textStyle) {
                        n8 = typedArray2.getInt(n2, -1);
                        continue;
                    }
                    if (n2 != this.TextAppearance_textAllCaps) continue;
                    bl = typedArray2.getBoolean(n2, false);
                }
                typedArray2.recycle();
            }
            n4 = typedArray.getIndexCount();
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = typedArray.getIndex(n3);
                if (n2 == this.TextView_editable) {
                    jSONObject.put("TextView_editable", typedArray.getBoolean(n2, false));
                    continue;
                }
                if (n2 == this.TextView_inputMethod) {
                    jSONObject.put("TextView_inputMethod", (Object)typedArray.getText(n2));
                    continue;
                }
                if (n2 == this.TextView_numeric) {
                    jSONObject.put("TextView_numeric", typedArray.getInt(n2, 0));
                    continue;
                }
                if (n2 == this.TextView_digits) {
                    jSONObject.put("TextView_digits", (Object)typedArray.getText(n2));
                    continue;
                }
                if (n2 == this.TextView_phoneNumber) {
                    jSONObject.put("TextView_phoneNumber", typedArray.getBoolean(n2, false));
                    continue;
                }
                if (n2 == this.TextView_autoText) {
                    jSONObject.put("TextView_autoText", typedArray.getBoolean(n2, false));
                    continue;
                }
                if (n2 == this.TextView_capitalize) {
                    jSONObject.put("TextView_capitalize", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_bufferType) {
                    jSONObject.put("TextView_bufferType", typedArray.getInt(n2, 0));
                    continue;
                }
                if (n2 == this.TextView_selectAllOnFocus) {
                    jSONObject.put("TextView_selectAllOnFocus", typedArray.getBoolean(n2, false));
                    continue;
                }
                if (n2 == this.TextView_autoLink) {
                    jSONObject.put("TextView_autoLink", typedArray.getInt(n2, 0));
                    continue;
                }
                if (n2 == this.TextView_linksClickable) {
                    jSONObject.put("TextView_linksClickable", typedArray.getBoolean(n2, true));
                    continue;
                }
                if (n2 == this.TextView_linksClickable) {
                    jSONObject.put("TextView_linksClickable", typedArray.getBoolean(n2, true));
                    continue;
                }
                if (n2 == this.TextView_drawableLeft) {
                    jSONObject.put("TextView_drawableLeft", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_drawableLeft", null));
                    continue;
                }
                if (n2 == this.TextView_drawableTop) {
                    jSONObject.put("TextView_drawableTop", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_drawableTop", null));
                    continue;
                }
                if (n2 == this.TextView_drawableRight) {
                    jSONObject.put("TextView_drawableRight", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_drawableRight", null));
                    continue;
                }
                if (n2 == this.TextView_drawableBottom) {
                    jSONObject.put("TextView_drawableBottom", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_drawableBottom", null));
                    continue;
                }
                if (n2 == this.TextView_drawableStart) {
                    jSONObject.put("TextView_drawableStart", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_drawableStart", null));
                    continue;
                }
                if (n2 == this.TextView_drawableEnd) {
                    jSONObject.put("TextView_drawableEnd", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_drawableEnd", null));
                    continue;
                }
                if (n2 == this.TextView_drawablePadding) {
                    jSONObject.put("TextView_drawablePadding", typedArray.getDimensionPixelSize(n2, 0));
                    continue;
                }
                if (n2 == this.TextView_textCursorDrawable) {
                    try {
                        jSONObject.put("TextView_textCursorDrawable", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_textCursorDrawable", null));
                    }
                    catch (Exception exception) {
                        try {
                            jSONObject.put("TextView_textCursorDrawable", (Object)this.getDrawable(this.m_context.getResources().getDrawable(typedArray.getResourceId(n2, 0)), string + "_TextView_textCursorDrawable", null));
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                    }
                    continue;
                }
                if (n2 == this.TextView_maxLines) {
                    jSONObject.put("TextView_maxLines", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_maxHeight) {
                    jSONObject.put("TextView_maxHeight", typedArray.getDimensionPixelSize(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_lines) {
                    jSONObject.put("TextView_lines", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_height) {
                    jSONObject.put("TextView_height", typedArray.getDimensionPixelSize(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_minLines) {
                    jSONObject.put("TextView_minLines", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_minHeight) {
                    jSONObject.put("TextView_minHeight", typedArray.getDimensionPixelSize(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_maxEms) {
                    jSONObject.put("TextView_maxEms", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_maxWidth) {
                    jSONObject.put("TextView_maxWidth", typedArray.getDimensionPixelSize(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_ems) {
                    jSONObject.put("TextView_ems", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_width) {
                    jSONObject.put("TextView_width", typedArray.getDimensionPixelSize(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_minEms) {
                    jSONObject.put("TextView_minEms", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_minWidth) {
                    jSONObject.put("TextView_minWidth", typedArray.getDimensionPixelSize(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_gravity) {
                    jSONObject.put("TextView_gravity", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_hint) {
                    jSONObject.put("TextView_hint", (Object)typedArray.getText(n2));
                    continue;
                }
                if (n2 == this.TextView_text) {
                    jSONObject.put("TextView_text", (Object)typedArray.getText(n2));
                    continue;
                }
                if (n2 == this.TextView_scrollHorizontally) {
                    jSONObject.put("TextView_scrollHorizontally", typedArray.getBoolean(n2, false));
                    continue;
                }
                if (n2 == this.TextView_singleLine) {
                    jSONObject.put("TextView_singleLine", typedArray.getBoolean(n2, false));
                    continue;
                }
                if (n2 == this.TextView_ellipsize) {
                    jSONObject.put("TextView_ellipsize", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_marqueeRepeatLimit) {
                    jSONObject.put("TextView_marqueeRepeatLimit", typedArray.getInt(n2, 3));
                    continue;
                }
                if (n2 == this.TextView_includeFontPadding) {
                    jSONObject.put("TextView_includeFontPadding", typedArray.getBoolean(n2, true));
                    continue;
                }
                if (n2 == this.TextView_cursorVisible) {
                    jSONObject.put("TextView_cursorVisible", typedArray.getBoolean(n2, true));
                    continue;
                }
                if (n2 == this.TextView_maxLength) {
                    jSONObject.put("TextView_maxLength", typedArray.getInt(n2, -1));
                    continue;
                }
                if (n2 == this.TextView_textScaleX) {
                    jSONObject.put("TextView_textScaleX", (double)typedArray.getFloat(n2, 1.0f));
                    continue;
                }
                if (n2 == this.TextView_freezesText) {
                    jSONObject.put("TextView_freezesText", typedArray.getBoolean(n2, false));
                    continue;
                }
                if (n2 == this.TextView_shadowColor) {
                    jSONObject.put("TextView_shadowColor", typedArray.getInt(n2, 0));
                    continue;
                }
                if (n2 == this.TextView_shadowDx) {
                    jSONObject.put("TextView_shadowDx", (double)typedArray.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == this.TextView_shadowDy) {
                    jSONObject.put("TextView_shadowDy", (double)typedArray.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == this.TextView_shadowRadius) {
                    jSONObject.put("TextView_shadowRadius", (double)typedArray.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == this.TextView_enabled) {
                    jSONObject.put("TextView_enabled", typedArray.getBoolean(n2, true));
                    continue;
                }
                if (n2 == this.TextView_textColorHighlight) {
                    n5 = typedArray.getColor(n2, n5);
                    continue;
                }
                if (n2 == this.TextView_textColor) {
                    colorStateList = typedArray.getColorStateList(n2);
                    continue;
                }
                if (n2 == this.TextView_textColorHint) {
                    colorStateList2 = typedArray.getColorStateList(n2);
                    continue;
                }
                if (n2 == this.TextView_textColorLink) {
                    colorStateList3 = typedArray.getColorStateList(n2);
                    continue;
                }
                if (n2 == this.TextView_textSize) {
                    n6 = typedArray.getDimensionPixelSize(n2, n6);
                    continue;
                }
                if (n2 == this.TextView_typeface) {
                    n7 = typedArray.getInt(n2, n7);
                    continue;
                }
                if (n2 == this.TextView_textStyle) {
                    n8 = typedArray.getInt(n2, n8);
                    continue;
                }
                if (n2 == this.TextView_password) {
                    jSONObject.put("TextView_password", typedArray.getBoolean(n2, false));
                    continue;
                }
                if (n2 == this.TextView_lineSpacingExtra) {
                    jSONObject.put("TextView_lineSpacingExtra", typedArray.getDimensionPixelSize(n2, 0));
                    continue;
                }
                if (n2 == this.TextView_lineSpacingMultiplier) {
                    jSONObject.put("TextView_lineSpacingMultiplier", (double)typedArray.getFloat(n2, 1.0f));
                    continue;
                }
                if (n2 == this.TextView_inputType) {
                    jSONObject.put("TextView_inputType", typedArray.getInt(n2, 0));
                    continue;
                }
                if (n2 == this.TextView_imeOptions) {
                    jSONObject.put("TextView_imeOptions", typedArray.getInt(n2, 0));
                    continue;
                }
                if (n2 == this.TextView_imeActionLabel) {
                    jSONObject.put("TextView_imeActionLabel", (Object)typedArray.getText(n2));
                    continue;
                }
                if (n2 == this.TextView_imeActionId) {
                    jSONObject.put("TextView_imeActionId", typedArray.getInt(n2, 0));
                    continue;
                }
                if (n2 == this.TextView_privateImeOptions) {
                    jSONObject.put("TextView_privateImeOptions", (Object)typedArray.getString(n2));
                    continue;
                }
                if (n2 == this.TextView_textSelectHandleLeft && string.equals("textViewStyle")) {
                    try {
                        jSONObject.put("TextView_textSelectHandleLeft", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_textSelectHandleLeft", null));
                    }
                    catch (Exception exception) {
                        try {
                            jSONObject.put("TextView_textSelectHandleLeft", (Object)this.getDrawable(this.m_context.getResources().getDrawable(typedArray.getResourceId(n2, 0)), string + "_TextView_textSelectHandleLeft", null));
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                    }
                    continue;
                }
                if (n2 == this.TextView_textSelectHandleRight && string.equals("textViewStyle")) {
                    try {
                        jSONObject.put("TextView_textSelectHandleRight", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_textSelectHandleRight", null));
                    }
                    catch (Exception exception) {
                        try {
                            jSONObject.put("TextView_textSelectHandleRight", (Object)this.getDrawable(this.m_context.getResources().getDrawable(typedArray.getResourceId(n2, 0)), string + "_TextView_textSelectHandleRight", null));
                        }
                        catch (Exception exception4) {
                            exception4.printStackTrace();
                        }
                    }
                    continue;
                }
                if (n2 == this.TextView_textSelectHandle && string.equals("textViewStyle")) {
                    try {
                        jSONObject.put("TextView_textSelectHandle", (Object)this.getDrawable(typedArray.getDrawable(n2), string + "_TextView_textSelectHandle", null));
                    }
                    catch (Exception exception) {
                        try {
                            jSONObject.put("TextView_textSelectHandle", (Object)this.getDrawable(this.m_context.getResources().getDrawable(typedArray.getResourceId(n2, 0)), string + "_TextView_textSelectHandle", null));
                        }
                        catch (Exception exception5) {
                            exception5.printStackTrace();
                        }
                    }
                    continue;
                }
                if (n2 == this.TextView_textIsSelectable) {
                    jSONObject.put("TextView_textIsSelectable", typedArray.getBoolean(n2, false));
                    continue;
                }
                if (n2 != this.TextView_textAllCaps) continue;
                bl = typedArray.getBoolean(n2, false);
            }
            typedArray.recycle();
            jSONObject.put("TextAppearance_textColorHighlight", n5);
            jSONObject.put("TextAppearance_textColor", (Object)this.getColorStateList(colorStateList));
            jSONObject.put("TextAppearance_textColorHint", (Object)this.getColorStateList(colorStateList2));
            jSONObject.put("TextAppearance_textColorLink", (Object)this.getColorStateList(colorStateList3));
            jSONObject.put("TextAppearance_textSize", n6);
            jSONObject.put("TextAppearance_typeface", n7);
            jSONObject.put("TextAppearance_textStyle", n8);
            jSONObject.put("TextAppearance_textAllCaps", bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    public JSONObject extractImageViewInformations(String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            int n;
            Class<?> clazz = Class.forName("android.R$attr");
            int n2 = clazz.getDeclaredField(string).getInt(null);
            this.extractViewInformations(string, n2, jSONObject, string2, null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("ImageView").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n2, 0);
            Drawable drawable = typedArray.getDrawable(this.ImageView_src);
            if (drawable != null) {
                jSONObject.put("ImageView_src", (Object)this.getDrawable(drawable, string + "_ImageView_src", null));
            }
            jSONObject.put("ImageView_baselineAlignBottom", typedArray.getBoolean(this.ImageView_baselineAlignBottom, false));
            jSONObject.put("ImageView_adjustViewBounds", typedArray.getBoolean(this.ImageView_adjustViewBounds, false));
            jSONObject.put("ImageView_maxWidth", typedArray.getDimensionPixelSize(this.ImageView_maxWidth, Integer.MAX_VALUE));
            jSONObject.put("ImageView_maxHeight", typedArray.getDimensionPixelSize(this.ImageView_maxHeight, Integer.MAX_VALUE));
            int n3 = typedArray.getInt(this.ImageView_scaleType, -1);
            if (n3 >= 0) {
                jSONObject.put("ImageView_scaleType", (Object)this.sScaleTypeArray[n3]);
            }
            if ((n = typedArray.getInt(this.ImageView_tint, 0)) != 0) {
                jSONObject.put("ImageView_tint", n);
            }
            jSONObject.put("ImageView_cropToPadding", typedArray.getBoolean(this.ImageView_cropToPadding, false));
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    void extractCompoundButton(SimpleJsonWriter simpleJsonWriter, String string, String string2) {
        JSONObject jSONObject = this.extractTextAppearanceInformations(string, string2, null, -1);
        try {
            Class<?> clazz = Class.forName("android.R$attr");
            int n = clazz.getDeclaredField(string).getInt(null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("CompoundButton").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n, 0);
            Drawable drawable = typedArray.getDrawable(this.getField(this.styleableClass, "CompoundButton_button"));
            if (drawable != null) {
                jSONObject.put("CompoundButton_button", (Object)this.getDrawable(drawable, string + "_CompoundButton_button", null));
            }
            typedArray.recycle();
            simpleJsonWriter.name(string).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractProgressBarInfo(JSONObject jSONObject, String string) {
        try {
            Class<?> clazz = Class.forName("android.R$attr");
            int n = clazz.getDeclaredField(string).getInt(null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("ProgressBar").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n, 0);
            int n2 = 24;
            int n3 = 48;
            int n4 = 24;
            int n5 = 48;
            n2 = typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "ProgressBar_minWidth"), n2);
            n3 = typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "ProgressBar_maxWidth"), n3);
            n4 = typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "ProgressBar_minHeight"), n4);
            n5 = typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "ProgressBar_maxHeight"), n5);
            jSONObject.put("ProgressBar_indeterminateDuration", typedArray.getInt(this.getField(this.styleableClass, "ProgressBar_indeterminateDuration"), 4000));
            jSONObject.put("ProgressBar_minWidth", n2);
            jSONObject.put("ProgressBar_maxWidth", n3);
            jSONObject.put("ProgressBar_minHeight", n4);
            jSONObject.put("ProgressBar_maxHeight", n5);
            jSONObject.put("ProgressBar_progress_id", 16908301);
            jSONObject.put("ProgressBar_secondaryProgress_id", 16908303);
            Drawable drawable = typedArray.getDrawable(this.getField(this.styleableClass, "ProgressBar_progressDrawable"));
            if (drawable != null) {
                jSONObject.put("ProgressBar_progressDrawable", (Object)this.getDrawable(drawable, string + "_ProgressBar_progressDrawable", null));
            }
            if ((drawable = typedArray.getDrawable(this.getField(this.styleableClass, "ProgressBar_indeterminateDrawable"))) != null) {
                jSONObject.put("ProgressBar_indeterminateDrawable", (Object)this.getDrawable(drawable, string + "_ProgressBar_indeterminateDrawable", null));
            }
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractProgressBar(SimpleJsonWriter simpleJsonWriter, String string, String string2) {
        JSONObject jSONObject = this.extractTextAppearanceInformations(string, string2, null, -1);
        try {
            this.extractProgressBarInfo(jSONObject, string);
            simpleJsonWriter.name(string).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractAbsSeekBar(SimpleJsonWriter simpleJsonWriter, String string, String string2) {
        JSONObject jSONObject = this.extractTextAppearanceInformations(string, string2, null, -1);
        this.extractProgressBarInfo(jSONObject, string);
        try {
            Class<?> clazz = Class.forName("android.R$attr");
            int n = clazz.getDeclaredField(string).getInt(null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("SeekBar").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n, 0);
            Drawable drawable = typedArray.getDrawable(this.getField(this.styleableClass, "SeekBar_thumb"));
            if (drawable != null) {
                jSONObject.put("SeekBar_thumb", (Object)this.getDrawable(drawable, string + "_SeekBar_thumb", null));
            }
            try {
                jSONObject.put("SeekBar_thumbOffset", this.styleableClass.getDeclaredField("SeekBar_thumbOffset").getInt(null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            typedArray.recycle();
            simpleJsonWriter.name(string).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractSwitch(SimpleJsonWriter simpleJsonWriter, String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            Drawable drawable;
            Class<?> clazz = Class.forName("com.android.internal.R$attr");
            int n = clazz.getDeclaredField(string).getInt(null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("Switch").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n, 0);
            Drawable drawable2 = typedArray.getDrawable(this.getField(this.styleableClass, "Switch_thumb"));
            if (drawable2 != null) {
                jSONObject.put("Switch_thumb", (Object)this.getDrawable(drawable2, string + "_Switch_thumb", null));
            }
            if ((drawable = typedArray.getDrawable(this.getField(this.styleableClass, "Switch_track"))) != null) {
                jSONObject.put("Switch_track", (Object)this.getDrawable(drawable, string + "_Switch_track", null));
            }
            int n2 = typedArray.getResourceId(this.styleableClass.getDeclaredField("Switch_switchTextAppearance").getInt(null), -1);
            jSONObject.put("Switch_switchTextAppearance", (Object)this.extractTextAppearance(n2));
            jSONObject.put("Switch_textOn", (Object)typedArray.getText(this.getField(this.styleableClass, "Switch_textOn")));
            jSONObject.put("Switch_textOff", (Object)typedArray.getText(this.getField(this.styleableClass, "Switch_textOff")));
            jSONObject.put("Switch_switchMinWidth", typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "Switch_switchMinWidth"), 0));
            jSONObject.put("Switch_switchPadding", typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "Switch_switchPadding"), 0));
            jSONObject.put("Switch_thumbTextPadding", typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "Switch_thumbTextPadding"), 0));
            if (Build.VERSION.SDK_INT >= 21) {
                jSONObject.put("Switch_showText", typedArray.getBoolean(this.getField(this.styleableClass, "Switch_showText"), true));
                jSONObject.put("Switch_splitTrack", typedArray.getBoolean(this.getField(this.styleableClass, "Switch_splitTrack"), false));
            }
            typedArray.recycle();
            simpleJsonWriter.name(string).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    JSONObject extractCheckedTextView(AttributeSet attributeSet, String string) {
        JSONObject jSONObject = this.extractTextAppearanceInformations("textViewStyle", string, attributeSet, -1);
        try {
            Class<?> clazz = Class.forName("android.R$attr");
            int n = clazz.getDeclaredField("textViewStyle").getInt(null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("CheckedTextView").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(attributeSet, nArray, n, 0);
            Drawable drawable = typedArray.getDrawable(this.getField(this.styleableClass, "CheckedTextView_checkMark"));
            if (drawable != null) {
                jSONObject.put("CheckedTextView_checkMark", (Object)this.getDrawable(drawable, string + "_CheckedTextView_checkMark", null));
            }
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject extractItemStyle(int n, String string, int n2) {
        try {
            int n3;
            XmlResourceParser xmlResourceParser = this.m_context.getResources().getLayout(n);
            while ((n3 = xmlResourceParser.next()) != 2 && n3 != 1) {
            }
            if (n3 != 2) {
                return null;
            }
            AttributeSet attributeSet = Xml.asAttributeSet((XmlPullParser)xmlResourceParser);
            String string2 = xmlResourceParser.getName();
            if (string2.equals("TextView")) {
                return this.extractTextAppearanceInformations("textViewStyle", string, attributeSet, n2);
            }
            if (string2.equals("CheckedTextView")) {
                return this.extractCheckedTextView(attributeSet, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private void extractItemsStyle(SimpleJsonWriter simpleJsonWriter) {
        try {
            simpleJsonWriter.name("simple_list_item").value(this.extractItemStyle(17367043, "simple_list_item", 16973890));
            simpleJsonWriter.name("simple_list_item_checked").value(this.extractItemStyle(17367045, "simple_list_item_checked", 16973890));
            simpleJsonWriter.name("simple_list_item_multiple_choice").value(this.extractItemStyle(0x1090010, "simple_list_item_multiple_choice", 16973890));
            simpleJsonWriter.name("simple_list_item_single_choice").value(this.extractItemStyle(17367055, "simple_list_item_single_choice", 16973890));
            simpleJsonWriter.name("simple_spinner_item").value(this.extractItemStyle(17367048, "simple_spinner_item", -1));
            simpleJsonWriter.name("simple_spinner_dropdown_item").value(this.extractItemStyle(0x1090009, "simple_spinner_dropdown_item", 16973890));
            simpleJsonWriter.name("simple_dropdown_item_1line").value(this.extractItemStyle(17367050, "simple_dropdown_item_1line", 16973890));
            if (Build.VERSION.SDK_INT > 10) {
                Class<?> clazz = Class.forName("android.R$layout");
                int n = clazz.getDeclaredField("simple_selectable_list_item").getInt(null);
                simpleJsonWriter.name("simple_selectable_list_item").value(this.extractItemStyle(n, "simple_selectable_list_item", 16973890));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractListView(SimpleJsonWriter simpleJsonWriter, String string, String string2) {
        JSONObject jSONObject = this.extractTextAppearanceInformations(string, string2, null, -1);
        try {
            Class<?> clazz = Class.forName("android.R$attr");
            int n = clazz.getDeclaredField(string).getInt(null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("ListView").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n, 0);
            Drawable drawable = typedArray.getDrawable(this.getField(this.styleableClass, "ListView_divider"));
            if (drawable != null) {
                jSONObject.put("ListView_divider", (Object)this.getDrawable(drawable, string + "_ListView_divider", null));
            }
            jSONObject.put("ListView_dividerHeight", typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "ListView_dividerHeight"), 0));
            typedArray.recycle();
            simpleJsonWriter.name(string).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractCalendar(SimpleJsonWriter simpleJsonWriter, String string, String string2) {
        JSONObject jSONObject = this.extractTextAppearanceInformations(string, string2, null, -1);
        try {
            Class<?> clazz = Class.forName("android.R$attr");
            int n = clazz.getDeclaredField(string).getInt(null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("CalendarView").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n, 0);
            Drawable drawable = typedArray.getDrawable(this.getField(this.styleableClass, "CalendarView_selectedDateVerticalBar"));
            if (drawable != null) {
                jSONObject.put("CalendarView_selectedDateVerticalBar", (Object)this.getDrawable(drawable, string + "_CalendarView_selectedDateVerticalBar", null));
            }
            int n2 = typedArray.getResourceId(this.styleableClass.getDeclaredField("CalendarView_dateTextAppearance").getInt(null), -1);
            jSONObject.put("CalendarView_dateTextAppearance", (Object)this.extractTextAppearance(n2));
            int n3 = typedArray.getResourceId(this.styleableClass.getDeclaredField("CalendarView_weekDayTextAppearance").getInt(null), -1);
            jSONObject.put("CalendarView_weekDayTextAppearance", (Object)this.extractTextAppearance(n3));
            jSONObject.put("CalendarView_firstDayOfWeek", typedArray.getInt(this.getField(this.styleableClass, "CalendarView_firstDayOfWeek"), 0));
            jSONObject.put("CalendarView_focusedMonthDateColor", typedArray.getColor(this.getField(this.styleableClass, "CalendarView_focusedMonthDateColor"), 0));
            jSONObject.put("CalendarView_selectedWeekBackgroundColor", typedArray.getColor(this.getField(this.styleableClass, "CalendarView_selectedWeekBackgroundColor"), 0));
            jSONObject.put("CalendarView_showWeekNumber", typedArray.getBoolean(this.getField(this.styleableClass, "CalendarView_showWeekNumber"), true));
            jSONObject.put("CalendarView_shownWeekCount", typedArray.getInt(this.getField(this.styleableClass, "CalendarView_shownWeekCount"), 6));
            jSONObject.put("CalendarView_unfocusedMonthDateColor", typedArray.getColor(this.getField(this.styleableClass, "CalendarView_unfocusedMonthDateColor"), 0));
            jSONObject.put("CalendarView_weekNumberColor", typedArray.getColor(this.getField(this.styleableClass, "CalendarView_weekNumberColor"), 0));
            jSONObject.put("CalendarView_weekSeparatorLineColor", typedArray.getColor(this.getField(this.styleableClass, "CalendarView_weekSeparatorLineColor"), 0));
            typedArray.recycle();
            simpleJsonWriter.name(string).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractToolBar(SimpleJsonWriter simpleJsonWriter, String string, String string2) {
        JSONObject jSONObject = this.extractTextAppearanceInformations(string, string2, null, -1);
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$attr");
            int n = clazz.getDeclaredField(string).getInt(null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("ActionBar").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n, 0);
            Drawable drawable = typedArray.getDrawable(this.getField(this.styleableClass, "ActionBar_background"));
            if (drawable != null) {
                jSONObject.put("ActionBar_background", (Object)this.getDrawable(drawable, string + "_ActionBar_background", null));
            }
            if ((drawable = typedArray.getDrawable(this.getField(this.styleableClass, "ActionBar_backgroundStacked"))) != null) {
                jSONObject.put("ActionBar_backgroundStacked", (Object)this.getDrawable(drawable, string + "_ActionBar_backgroundStacked", null));
            }
            if ((drawable = typedArray.getDrawable(this.getField(this.styleableClass, "ActionBar_backgroundSplit"))) != null) {
                jSONObject.put("ActionBar_backgroundSplit", (Object)this.getDrawable(drawable, string + "_ActionBar_backgroundSplit", null));
            }
            if ((drawable = typedArray.getDrawable(this.getField(this.styleableClass, "ActionBar_divider"))) != null) {
                jSONObject.put("ActionBar_divider", (Object)this.getDrawable(drawable, string + "_ActionBar_divider", null));
            }
            jSONObject.put("ActionBar_itemPadding", typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "ActionBar_itemPadding"), 0));
            typedArray.recycle();
            simpleJsonWriter.name(string).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractTabBar(SimpleJsonWriter simpleJsonWriter, String string, String string2) {
        JSONObject jSONObject = this.extractTextAppearanceInformations(string, string2, null, -1);
        try {
            Class<?> clazz = Class.forName("android.R$attr");
            int n = clazz.getDeclaredField(string).getInt(null);
            int[] nArray = (int[])this.styleableClass.getDeclaredField("LinearLayout").get(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n, 0);
            Drawable drawable = typedArray.getDrawable(this.getField(this.styleableClass, "LinearLayout_divider"));
            if (drawable != null) {
                jSONObject.put("LinearLayout_divider", (Object)this.getDrawable(drawable, string + "_LinearLayout_divider", null));
            }
            jSONObject.put("LinearLayout_showDividers", typedArray.getInt(this.getField(this.styleableClass, "LinearLayout_showDividers"), 0));
            jSONObject.put("LinearLayout_dividerPadding", typedArray.getDimensionPixelSize(this.getField(this.styleableClass, "LinearLayout_dividerPadding"), 0));
            typedArray.recycle();
            simpleJsonWriter.name(string).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void extractWindow(SimpleJsonWriter simpleJsonWriter, String string) {
        JSONObject jSONObject = new JSONObject();
        try {
            Class<?> clazz = Class.forName("android.R$attr");
            int[] nArray = (int[])this.styleableClass.getDeclaredField("Window").get(null);
            int n = clazz.getDeclaredField("windowBackground").getInt(null);
            TypedArray typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n, 0);
            Drawable drawable = typedArray.getDrawable(this.getField(this.styleableClass, "Window_windowBackground"));
            if (drawable != null) {
                jSONObject.put("Window_windowBackground", (Object)this.getDrawable(drawable, string + "_Window_windowBackground", null));
            }
            typedArray.recycle();
            int n2 = clazz.getDeclaredField("windowFrame").getInt(null);
            typedArray = this.m_theme.obtainStyledAttributes(null, nArray, n2, 0);
            Drawable drawable2 = typedArray.getDrawable(this.getField(this.styleableClass, "Window_windowFrame"));
            if (drawable2 != null) {
                jSONObject.put("Window_windowFrame", (Object)this.getDrawable(drawable2, string + "_Window_windowFrame", null));
            }
            typedArray.recycle();
            simpleJsonWriter.name(string).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JSONObject extractDefaultPalette() {
        TypedArray typedArray = this.m_theme.obtainStyledAttributes(new int[]{16842804});
        int n = 0;
        JSONObject jSONObject = this.extractTextAppearance(typedArray.getResourceId(n++, -1));
        try {
            jSONObject.put("defaultBackgroundColor", this.defaultBackgroundColor);
            jSONObject.put("defaultTextColorPrimary", this.defaultTextColor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        typedArray.recycle();
        return jSONObject;
    }

    public ExtractStyle(Context context, String string) {
        this.m_extractPath = string + "/";
        new File(this.m_extractPath).mkdirs();
        this.m_context = context;
        this.m_theme = context.getTheme();
        TypedArray typedArray = this.m_theme.obtainStyledAttributes(new int[]{0x1010031, 16842806, 16842904});
        this.defaultBackgroundColor = typedArray.getColor(0, 0);
        int n = typedArray.getColor(1, 0xFFFFFF);
        if (n == 0xFFFFFF) {
            n = typedArray.getColor(2, 0xFFFFFF);
        }
        this.defaultTextColor = n;
        typedArray.recycle();
        try {
            SimpleJsonWriter simpleJsonWriter = new SimpleJsonWriter(this.m_extractPath + "style.json");
            simpleJsonWriter.beginObject();
            try {
                simpleJsonWriter.name("defaultStyle").value(this.extractDefaultPalette());
                this.extractWindow(simpleJsonWriter, "windowStyle");
                simpleJsonWriter.name("buttonStyle").value(this.extractTextAppearanceInformations("buttonStyle", "QPushButton", null, -1));
                simpleJsonWriter.name("spinnerStyle").value(this.extractTextAppearanceInformations("spinnerStyle", "QComboBox", null, -1));
                this.extractProgressBar(simpleJsonWriter, "progressBarStyleHorizontal", "QProgressBar");
                this.extractProgressBar(simpleJsonWriter, "progressBarStyleLarge", null);
                this.extractProgressBar(simpleJsonWriter, "progressBarStyleSmall", null);
                this.extractProgressBar(simpleJsonWriter, "progressBarStyle", null);
                this.extractAbsSeekBar(simpleJsonWriter, "seekBarStyle", "QSlider");
                if (Build.VERSION.SDK_INT > 13) {
                    this.extractSwitch(simpleJsonWriter, "switchStyle", null);
                }
                this.extractCompoundButton(simpleJsonWriter, "checkboxStyle", "QCheckBox");
                simpleJsonWriter.name("editTextStyle").value(this.extractTextAppearanceInformations("editTextStyle", "QLineEdit", null, -1));
                this.extractCompoundButton(simpleJsonWriter, "radioButtonStyle", "QRadioButton");
                simpleJsonWriter.name("textViewStyle").value(this.extractTextAppearanceInformations("textViewStyle", "QWidget", null, -1));
                simpleJsonWriter.name("scrollViewStyle").value(this.extractTextAppearanceInformations("scrollViewStyle", "QAbstractScrollArea", null, -1));
                this.extractListView(simpleJsonWriter, "listViewStyle", "QListView");
                simpleJsonWriter.name("listSeparatorTextViewStyle").value(this.extractTextAppearanceInformations("listSeparatorTextViewStyle", null, null, -1));
                this.extractItemsStyle(simpleJsonWriter);
                this.extractCompoundButton(simpleJsonWriter, "buttonStyleToggle", null);
                if (Build.VERSION.SDK_INT > 10) {
                    this.extractCalendar(simpleJsonWriter, "calendarViewStyle", "QCalendarWidget");
                    this.extractToolBar(simpleJsonWriter, "actionBarStyle", "QToolBar");
                    simpleJsonWriter.name("actionButtonStyle").value(this.extractTextAppearanceInformations("actionButtonStyle", "QToolButton", null, -1));
                    simpleJsonWriter.name("actionBarTabTextStyle").value(this.extractTextAppearanceInformations("actionBarTabTextStyle", null, null, -1));
                    simpleJsonWriter.name("actionBarTabStyle").value(this.extractTextAppearanceInformations("actionBarTabStyle", null, null, -1));
                    simpleJsonWriter.name("actionOverflowButtonStyle").value(this.extractImageViewInformations("actionOverflowButtonStyle", null));
                    this.extractTabBar(simpleJsonWriter, "actionBarTabBarStyle", "QTabBar");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            simpleJsonWriter.endObject();
            simpleJsonWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class DrawableCache {
        JSONObject object;
        Object drawable;

        public DrawableCache(JSONObject jSONObject, Object object) {
            this.object = jSONObject;
            this.drawable = object;
        }
    }

    class FakeCanvas
    extends Canvas {
        int[] chunkData = null;

        FakeCanvas() {
        }

        public boolean isHardwareAccelerated() {
            return true;
        }

        public void drawPatch(Bitmap bitmap, byte[] byArray, RectF rectF, Paint paint) {
            this.chunkData = Build.VERSION.SDK_INT > 19 ? ExtractStyle.extractChunkInfo20(byArray) : ExtractStyle.extractChunkInfo(byArray);
        }

        class Size {
            public int s;
            public int e;

            Size(int n, int n2) {
                this.s = n;
                this.e = n2;
            }
        }
    }

    class SimpleJsonWriter {
        private OutputStreamWriter m_writer;
        private boolean m_addComma = false;
        private int m_indentLevel = 0;

        public SimpleJsonWriter(String string) throws FileNotFoundException {
            this.m_writer = new OutputStreamWriter(new FileOutputStream(string));
        }

        public void close() throws IOException {
            this.m_writer.close();
        }

        private void writeIndent() throws IOException {
            this.m_writer.write(" ", 0, this.m_indentLevel);
        }

        SimpleJsonWriter beginObject() throws IOException {
            this.writeIndent();
            this.m_writer.write("{\n");
            ++this.m_indentLevel;
            this.m_addComma = false;
            return this;
        }

        SimpleJsonWriter endObject() throws IOException {
            this.m_writer.write("\n");
            this.writeIndent();
            this.m_writer.write("}\n");
            --this.m_indentLevel;
            this.m_addComma = false;
            return this;
        }

        SimpleJsonWriter name(String string) throws IOException {
            if (this.m_addComma) {
                this.m_writer.write(",\n");
            }
            this.writeIndent();
            this.m_writer.write(JSONObject.quote((String)string) + ": ");
            this.m_addComma = true;
            return this;
        }

        SimpleJsonWriter value(JSONObject jSONObject) throws IOException {
            this.m_writer.write(jSONObject.toString());
            return this;
        }
    }
}

