// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef NGOutOfFlowLayoutPart_h
#define NGOutOfFlowLayoutPart_h

#include "core/CoreExport.h"

#include "core/layout/ng/ng_absolute_utils.h"
#include "core/layout/ng/ng_constraint_space.h"
#include "core/layout/ng/ng_layout_algorithm.h"
#include "platform/heap/Handle.h"
#include "platform/wtf/Optional.h"

namespace blink {

class ComputedStyle;
class NGBlockNode;
class NGFragmentBuilder;
class NGConstraintSpace;
class NGLayoutResult;

// Helper class for positioning of out-of-flow blocks.
// It should be used together with NGFragmentBuilder.
// See NGFragmentBuilder::AddOutOfFlowChildCandidate documentation
// for example of using these classes together.
class CORE_EXPORT NGOutOfFlowLayoutPart {
  STACK_ALLOCATED();

 public:
  NGOutOfFlowLayoutPart(const NGConstraintSpace& contianer_space,
                        const ComputedStyle& container_style,
                        NGFragmentBuilder* container_builder);
  void Run();

 private:
  RefPtr<NGLayoutResult> LayoutDescendant(NGBlockNode descendant,
                                          NGStaticPosition static_position,
                                          NGLogicalOffset* offset);

  RefPtr<NGLayoutResult> GenerateFragment(
      NGBlockNode node,
      const Optional<LayoutUnit>& block_estimate,
      const NGAbsolutePhysicalPosition node_position);

  const ComputedStyle& container_style_;
  NGFragmentBuilder* container_builder_;

  NGLogicalOffset container_border_offset_;
  NGPhysicalOffset container_border_physical_offset_;
  RefPtr<NGConstraintSpace> container_space_;
};

}  // namespace blink

#endif
