/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.HandlerFactory;
import com.puppycrawl.tools.checkstyle.checks.indentation.PrimordialHandler;
import java.util.ArrayDeque;
import java.util.Deque;

public class IndentationCheck
extends Check {
    private static final int DEFAULT_INDENTATION = 4;
    private int basicOffset = 4;
    private int caseIndentationAmount = 4;
    private int braceAdjustment;
    private int throwsIndentationAmount = 4;
    private int arrayInitIndentationAmount = 4;
    private int lineWrappingIndentation = 4;
    private boolean forceStrictCondition;
    private final Deque<ExpressionHandler> handlers = new ArrayDeque<ExpressionHandler>();
    private final HandlerFactory handlerFactory = new HandlerFactory();

    public boolean getForceStrictCondition() {
        return this.forceStrictCondition;
    }

    public void setForceStrictCondition(boolean value) {
        this.forceStrictCondition = value;
    }

    public void setBasicOffset(int basicOffset) {
        this.basicOffset = basicOffset;
    }

    public int getBasicOffset() {
        return this.basicOffset;
    }

    public void setBraceAdjustment(int adjustmentAmount) {
        this.braceAdjustment = adjustmentAmount;
    }

    public int getBraceAdjustement() {
        return this.braceAdjustment;
    }

    public void setCaseIndent(int amount) {
        this.caseIndentationAmount = amount;
    }

    public int getCaseIndent() {
        return this.caseIndentationAmount;
    }

    public void setThrowsIndent(int throwsIndent) {
        this.throwsIndentationAmount = throwsIndent;
    }

    public int getThrowsIndent() {
        return this.throwsIndentationAmount;
    }

    public void setArrayInitIndent(int arrayInitIndent) {
        this.arrayInitIndentationAmount = arrayInitIndent;
    }

    public int getArrayInitIndent() {
        return this.arrayInitIndentationAmount;
    }

    public int getLineWrappingIndentation() {
        return this.lineWrappingIndentation;
    }

    public void setLineWrappingIndentation(int lineWrappingIndentation) {
        this.lineWrappingIndentation = lineWrappingIndentation;
    }

    public void indentationLog(int line, String key, Object ... args) {
        super.log(line, key, args);
    }

    public int getIndentationTabWidth() {
        return this.getTabWidth();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.handlerFactory.getHandledTypes();
    }

    @Override
    public void beginTree(DetailAST ast) {
        this.handlerFactory.clearCreatedHandlers();
        this.handlers.clear();
        this.handlers.push(new PrimordialHandler(this));
    }

    @Override
    public void visitToken(DetailAST ast) {
        ExpressionHandler handler = this.handlerFactory.getHandler(this, ast, this.handlers.peek());
        this.handlers.push(handler);
        handler.checkIndentation();
    }

    @Override
    public void leaveToken(DetailAST ast) {
        this.handlers.pop();
    }

    final HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }
}

