// Copyright (C) 2016 Denis Shienkov <denis.shienkov@gmail.com>
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once

#include <QList>
#include <QObject>

#include <utils/filepath.h>

namespace Utils { class PersistentSettingsWriter; }

namespace BareMetal::Internal {

class BareMetalPlugin;
class IDebugServerProvider;

// DebugServerProviderManager

class DebugServerProviderManager final : public QObject
{
    Q_OBJECT

public:
    static DebugServerProviderManager *instance();

    static QList<IDebugServerProvider *> providers();
    static IDebugServerProvider *findProvider(const QString &id);
    static IDebugServerProvider *findByDisplayName(const QString &displayName);
    static bool registerProvider(IDebugServerProvider *provider);
    static void deregisterProvider(IDebugServerProvider *provider);

signals:
    void providerAdded(IDebugServerProvider *provider);
    void providerRemoved(IDebugServerProvider *provider);
    void providerUpdated(IDebugServerProvider *provider);
    void providersChanged();
    void providersLoaded();

private:
    DebugServerProviderManager();
    ~DebugServerProviderManager() final;

    void saveProviders();
    void restoreProviders();
    static void notifyAboutUpdate(IDebugServerProvider *provider);

    Utils::PersistentSettingsWriter *m_writer = nullptr;
    const Utils::FilePath m_configFile;

    friend class IDebugServerProvider;
};

void setupDebugServerProviderManager(QObject *guard);

} // BareMetal::Internal
