// Copyright (C) 2016 Jochen Becher
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once

#include "stereotypeicon.h"

#include <utils/filepath.h>

#include <QMarginsF>
#include <QObject>

namespace qmt {

class CustomRelation;
class Toolbar;
class Style;

class QMT_EXPORT StereotypeController : public QObject
{
    class StereotypeControllerPrivate;

public:
    explicit StereotypeController(QObject *parent = nullptr);
    ~StereotypeController() override;

    QList<StereotypeIcon> stereotypeIcons() const;
    QList<Toolbar> toolbars() const;
    QList<Toolbar> findToolbars(const QString &elementType) const;
    QStringList knownStereotypes(StereotypeIcon::Element stereotypeElement) const;

    QString findStereotypeIconId(StereotypeIcon::Element element,
                                 const QStringList &stereotypes) const;
    QStringList filterStereotypesByIconId(const QString &stereotypeIconId,
                                          const QStringList &stereotypes) const;
    StereotypeIcon findStereotypeIcon(const QString &stereotypeIconId) const;
    CustomRelation findCustomRelation(const QString &customRelationId) const;
    CustomRelation findCustomRelationByStereotype(const QString &steoreotype) const;
    QIcon createIcon(StereotypeIcon::Element element,
                     const QStringList &stereotypes,
                     const Utils::FilePath &defaultIconPath,
                     const Style *style,
                     const QSize &size,
                     const QMarginsF &margins,
                     qreal lineWidth);

    void addStereotypeIcon(const StereotypeIcon &stereotypeIcon);
    void addCustomRelation(const CustomRelation &customRelation);
    void addToolbar(const Toolbar &toolbar);

private:
    StereotypeControllerPrivate *d;
};

} // namespace qmt
