.\" dpkg manual page - deb-substvars(5)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2009,2012-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2009-2010 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH deb\-substvars 5 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
deb\-substvars \- Variables de substitution de source Debian
.
.SH SYNOPSIS
substvars
.
.SH DESCRIPTION
Avant que \fBdpkg\-source\fP, \fBdpkg\-gencontrol\fP et \fBdpkg\-genchanges\fP
n'écrivent leurs informations de contrôle (dans le fichier source de
contrôle \fB.dsc\fP pour \fBdpkg\-source\fP et sur la sortie standard pour
\fBdpkg\-gencontrol\fP et \fBdpkg\-genchanges\fP), ils réalisent quelques
substitutions de variables dans le fichier de sortie.

Une substitution de variable est de la forme\ : \fB${\fP\fInom\-variable\fP\fB}\fP. Les
noms de variable consistent en caractères alphanumériques (a\-zA\-Z0\-9),
traits d'union (\-) et «\ deux points\ » (:)\ ; ils commencent par une lettre ou
un chiffre et sont sensibles à la casse même si ils se réfèrent à d'autres
entités qui préservent la casse. La substitution se fait répétitivement
jusqu'à ce qu'il n'en reste aucune à faire\ ; le texte entier du champ après
la substitution est réexaminé pour chercher d'autres substitutions.

Quand toutes les substitutions ont été faites, chaque occurrence de la
chaîne \fB${}\fP (laquelle n'est pas une substitution autorisée) est remplacée
par un signe \fB$\fP.

Alors que le remplacement de variables est effectué sur tous les champs de
contrôle, certains de ces champs sont utilisés et nécessaires pendant la
construction alors même que la substitution n'a pas encore pu être
effectuée. Cela explique pourquoi il n'est pas possible d'utiliser de
variables dans les champs \fBPackage\fP, \fBSource\fP et \fBArchitecture\fP.

La substitution de variables se fait dans le contenu des champs après leur
analyse. En conséquence, si vous souhaitez qu'une variable soit remplacée
sur plusieurs lignes, il n'est pas nécessaire de placer une espace après le
retour à la ligne. Cela se fait implicitement quand le champ est
affiché. Par exemple, si la variable \fB${Description}\fP est positionnée sur
«\ foo est bar.${Newline}foo est super.\ » et si vous avez le champ suivant\ :

 Description: application foo
  ${Description}
  .
  Encore du texte.

Le résultat final sera\ :

 Description: application foo
  foo est bar.
  foo est super.
  .
  Encore du texte.

On peut définir les variables en utilisant l'option commune \fB\-V\fP. On peut
aussi se servir du fichier \fBdebian/substvars\fP (ou tout autre fichier avec
l'option \fB\-T\fP). Ce fichier est composé de lignes de la forme suivante\ :
\fInom\fP\fB=\fP\fIvaleur\fP. Les espaces résiduelles sur chaque ligne, les lignes
vides et les lignes qui commencent par un symbole \fB#\fP sont ignorées.

En outre, les variables standard suivantes sont disponibles\ :
.TP 
\fBArch\fP
L'architecture de l'hôte actuel (c'est\-à\-dire l'architecture pour laquelle
le paquet est construit, équivalent de \fBDEB_HOST_ARCH\fP).
.TP 
\fBsource:Version\fP
Version du paquet source (depuis dpkg\ 1.13.19).
.TP 
\fBsource:Upstream\-Version\fP
La version amont du paquet source, avec éventuellement l'«\ epoch\ » de la
version Debian (depuis dpkg\ 1.13.19).
.TP 
\fBbinary:Version\fP
La version du paquet binaire (qui peut être différente de \fBsource:Version\fP
dans un binNMU par exemple\ ; depuis dpkg\ 1.13.19).
.TP 
\fBSource\-Version\fP
La version du paquet source, selon le fichier changelog. Cette variable est
maintenant \fBobsolète\fP et produit une erreur lors de son utilisation car sa
signification est distincte de sa fonction. Utilisez plutôt
\fBsource:Version\fP ou \fBbinary:Version\fP.
.TP 
\fBsource:Synopsis\fP
Le synopsis du paquet source, extrait du champ \fBDescription\fP du paragraphe
source, s'il existe (depuis dpkg\ 1.19.0).
.TP 
\fBsource:Extended\-Description\fP
La description étendue du paquet source, extraite du champ \fBDescription\fP du
paragraphe source, s'il existe (depuis dpkg\ 1.19.0).
.TP 
\fBInstalled\-Size\fP
La taille approximative de tous les fichiers installés du paquet. Cette
valeur est copiée dans le champ adéquat du fichier «\ control\ »\ ; quand on
fixe cette variable, cela modifie la valeur de ce champ. Quand elle est
indéterminée, \fBdpkg\-gencontrol\fP calcule la valeur par défaut en
additionnant la taille de chaque fichier ordinaire et lien symbolique
arrondie en unité d'un kio utilisée et sur la base d'un kio pour n'importe
quel type d'objet du système de fichiers.

\fBRemarque\fP\ : Il faut tenir compte que cela ne peut jamais être qu'une
approximation dans la mesure où la taille véritablement occupée sur un
système installé dépend largement du système de fichiers utilisé et de ses
paramètres, ce qui pourrait finir par l'utilisation de plus ou moins
d'espace que ce qui est spécifié dans ce champ.
.TP 
\fBExtra\-Size\fP
L'espace disque supplémentaire utilisé pour l'installation du paquet. Quand
on fixe cette variable, on ajoute sa valeur à la valeur de la variable
\fBInstalled\-Size\fP (qu'elle soit définie explicitement ou calculée par
défaut) avant qu'elle soit copiée dans le champ \fBInstalled\-Size\fP du fichier
«\ control\ ».
.TP 
\fBS:\fP\fInom\-de\-champ\fP
La valeur du champ \fInom\-de\-champ\fP du paragraphe source (qui doit être
classiquement en majuscules, depuis dpkg\ 1.18.11). Quand on fixe ces
variables, cela ne prend effet que là où elles sont explicitement
développées. Ces variables ne sont disponibles que lors de la création des
fichiers de contrôle binaires.
.TP 
\fBF:\fP\fInom\-de\-champ\fP
La valeur du champ \fInom\-de\-champ\fP affichée en sortie (qui doit être
classiquement en majuscules). Quand on fixe ces variables, cela ne prend
effet que là où elles sont explicitement développées.
.TP 
\fBFormat\fP
La version du format du fichier \fB.changes\fP produite par la version des
scripts construisant le source. Quand on détermine cette variable, le
contenu du champ \fBFormat\fP dans le fichier \fB.changes\fP est aussi modifié.
.TP 
\fBNewline\fP, \fBSpace\fP, \fBTab\fP
Ces variables contiennent chacune le caractère correspondant.
.TP 
\fBshlibs:\fP\fIchamp\-dépendance\fP
Les variables déterminées de cette façon sont produites par
\fBdpkg\-shlibdeps\fP.
.TP 
\fBdpkg:Upstream\-Version\fP
La version amont de dpkg (depuis dpkg\ 1.13.19).
.TP 
\fBdpkg:Version\fP
La version complète de dpkg (depuis dpkg\ 1.13.19).
.LP
Quand une variable est référencée mais n'est pas définie, cela produit un
avertissement et une valeur vide est supposée.
.
.SH FICHIERS
.TP 
\fBdebian/substvars\fP
La liste des variables de substitution et leurs valeurs.
.
.SH "VOIR AUSSI"
.ad l
\fBdpkg\fP(1), \fBdpkg\-genchanges\fP(1), \fBdpkg\-gencontrol\fP(1),
\fBdpkg\-shlibdeps\fP(1), \fBdpkg\-source\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
