/*
 * Copyright 2001-2009 OFFIS, Tammo Freese
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.easymock;

/**
 * A comparison function that is used to match arguments.
 * 
 * @see MockControl#setDefaultMatcher
 * @see MockControl#setMatcher
 * @see MockControl#EQUALS_MATCHER
 * @see MockControl#ARRAY_MATCHER
 * @see MockControl#ALWAYS_MATCHER
 * 
 * @deprecated Since EasyMock 2.0, <code>ArgumentsMatcher</code>s are only supported
 * for the legacy <code>MockControl</code>. For mock objects generated by the methods
 * on <code>EasyMock</code>, there are per-argument matchers available. For more
 * information, see the EasyMock documentation.
 */
public interface ArgumentsMatcher {

    /**
     * Matches two arrays of arguments.
     * 
     * @param expected
     *            the expected arguments.
     * @param actual
     *            the actual arguments.
     * @return true if the arguments match, false otherwise.
     */
    boolean matches(Object[] expected, Object[] actual);

    /**
     * Returns a string representation of the arguments.
     * 
     * @param arguments
     *            the arguments to be used in the string representation.
     * @return a string representation of the arguments.
     */
    String toString(Object[] arguments);
}
