/*
 * %CopyrightBegin%
 *
 * Copyright Ericsson AB 2010-2013. All Rights Reserved.
 *
 * The contents of this file are subject to the Erlang Public License,
 * Version 1.1, (the "License"); you may not use this file except in
 * compliance with the License. You should have received a copy of the
 * Erlang Public License along with this software. If not, it can be
 * retrieved online at http://www.erlang.org/.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * %CopyrightEnd%
 */

/*
 * Description:	CPU topology and related functionality
 *
 * Author: 	Rickard Green
 */

#ifndef ERL_CPU_TOPOLOGY_H__
#define ERL_CPU_TOPOLOGY_H__

void erts_pre_early_init_cpu_topology(int *max_rg_p,
				      int *conf_p,
				      int *onln_p,
				      int *avail_p);
void erts_early_init_cpu_topology(int no_schedulers,
				  int *max_main_threads_p,
				  int max_reader_groups,
				  int *reader_groups_p);
void erts_init_cpu_topology(void);


#define ERTS_INIT_SCHED_BIND_TYPE_SUCCESS		0
#define ERTS_INIT_SCHED_BIND_TYPE_NOT_SUPPORTED		1
#define ERTS_INIT_SCHED_BIND_TYPE_ERROR_NO_CPU_TOPOLOGY	2
#define ERTS_INIT_SCHED_BIND_TYPE_ERROR_BAD_TYPE	3

int erts_init_scheduler_bind_type_string(char *how);


#define ERTS_INIT_CPU_TOPOLOGY_OK			0
#define ERTS_INIT_CPU_TOPOLOGY_INVALID_ID		1
#define ERTS_INIT_CPU_TOPOLOGY_INVALID_ID_RANGE		2
#define ERTS_INIT_CPU_TOPOLOGY_INVALID_HIERARCHY	3
#define ERTS_INIT_CPU_TOPOLOGY_INVALID_ID_TYPE		4
#define ERTS_INIT_CPU_TOPOLOGY_INVALID_NODES		5
#define ERTS_INIT_CPU_TOPOLOGY_MISSING_LID		6
#define ERTS_INIT_CPU_TOPOLOGY_NOT_UNIQUE_LIDS		7
#define ERTS_INIT_CPU_TOPOLOGY_NOT_UNIQUE_ENTITIES	8
#define ERTS_INIT_CPU_TOPOLOGY_MISSING			9

int erts_init_cpu_topology_string(char *topology_str);

void erts_sched_check_cpu_bind(ErtsSchedulerData *esdp);
#ifdef ERTS_SMP
void erts_sched_init_check_cpu_bind(ErtsSchedulerData *esdp);
void erts_sched_check_cpu_bind_prep_suspend(ErtsSchedulerData *esdp);
void erts_sched_check_cpu_bind_post_suspend(ErtsSchedulerData *esdp);
#endif

int erts_update_cpu_info(void);

Eterm erts_bind_schedulers(Process *c_p, Eterm how);
Eterm erts_get_schedulers_binds(Process *c_p);

Eterm erts_get_reader_groups_map(Process *c_p);

Eterm erts_set_cpu_topology(Process *c_p, Eterm term);
Eterm erts_get_cpu_topology_term(Process *c_p, Eterm which);

int erts_update_cpu_info(void);
void erts_get_logical_processors(int *conf, int *onln, int *avail);

int erts_sched_bind_atthrcreate_prepare(void);
int erts_sched_bind_atthrcreate_child(int unbind);
void erts_sched_bind_atthrcreate_parent(int unbind);

int erts_sched_bind_atfork_prepare(void);
int erts_sched_bind_atfork_child(int unbind);
char *erts_sched_bind_atvfork_child(int unbind);
void erts_sched_bind_atfork_parent(int unbind);

Eterm erts_fake_scheduler_bindings(Process *p, Eterm how);
Eterm erts_debug_cpu_groups_map(Process *c_p, int groups);


typedef void (*erts_cpu_groups_callback_t)(int,
					   ErtsSchedulerData *,
					   int,
					   void *);

void erts_add_cpu_groups(int groups,
			 erts_cpu_groups_callback_t callback,
			 void *arg);
void erts_remove_cpu_groups(erts_cpu_groups_callback_t callback,
			    void *arg);

#endif
